create table COMMENT (COMMENT_ID integer not null, CREATE_DATE timestamp, message longvarchar not null, draft bit not null, deleted bit not null, defectRaised bit not null, defectApproved bit not null, USER_ID integer, REVIEW_ID integer not null, REPLY_TO_COMMENT_ID integer, primary key (COMMENT_ID));
create table COMMENT_FIELD (COMMENT_ID integer not null, FIELD_ID integer not null, FIELD_ORDER integer not null, primary key (COMMENT_ID, FIELD_ORDER));
create table COMPLETED_FRX (PARTICIPANT_ID integer not null, FRX_ID integer not null, primary key (PARTICIPANT_ID, FRX_ID));
create table CRUPROJECT (PROJECT_ID integer not null, name varchar(255), key varchar(255), defaultRepositoryName varchar(255), allowReviewersToJoin bit, permissionScheme integer, defaultModerator integer, primary key (PROJECT_ID));
create table CRUPROJECT_ALWDREV (PROJECT_ID integer not null, USER_ID integer not null, primary key (PROJECT_ID, USER_ID));
create table CRUPROJECT_ALWDREVGRP (PROJECT_ID integer not null, GROUP_NAME varchar(255));
create table CRUPROJECT_DEFREV (PROJECT_ID integer not null, USER_ID integer not null, primary key (PROJECT_ID, USER_ID));
create table CRUPROJECT_DEFREVGRP (PROJECT_ID integer not null, GROUP_NAME varchar(255));
create table CRUVERSION (VERSION_ID integer not null, VERSION integer, primary key (VERSION_ID));
create table FEINDEX_MSG (ID integer not null, FR_ID integer, REVIEW_ID integer not null, primary key (ID));
create table FIELD (FIELD_ID integer not null, configVersion integer, fieldScope varchar(255), name varchar(255), stringVal varchar(255), intVal integer, booleanVal bit, DATE timestamp, primary key (FIELD_ID));
create table FR_EXTRA (FRX_ID integer not null, WHEN_ADDED timestamp, reviewed integer, furtherAction integer, reviewScope integer, fileRevision integer, REVIEW_ID integer not null, fromRevision integer, FRX_ORDER integer, primary key (FRX_ID), unique (fileRevision, REVIEW_ID));
create table LOGITEM (LOGITEM_ID integer not null, CREATE_DATE timestamp, item longvarchar, primary key (LOGITEM_ID));
create table METRIC_DEFINITION (METRIC_ID integer not null, xml longvarchar, primary key (METRIC_ID));
create table NOTIFICATION (NOTIFICATION_ID integer not null, NOTE_TYPE varchar(255) not null, CREATE_DATE timestamp, actioner integer, note varchar(255), review integer, ref1 integer, ref2 integer, primary key (NOTIFICATION_ID));
create table PATCH (PATCH_ID integer not null, review integer, uploadItem integer, primary key (PATCH_ID));
create table PATCH_REVISION (PATCH_ID integer not null, REVISION_ID integer not null, REVISION_ORDER integer not null, primary key (PATCH_ID, REVISION_ORDER));
create table PERM_SCHEME (PS_ID integer not null, name varchar(255), primary key (PS_ID), unique (name));
create table PS_ALL_USER (ps integer not null, actionName varchar(255) not null, primary key (ps, actionName));
create table PS_ANON (ps integer not null, actionName varchar(255) not null, primary key (ps, actionName));
create table PS_GROUP (ps integer not null, pid varchar(255) not null, actionName varchar(255) not null, primary key (ps, pid, actionName));
create table PS_REVIEW_ROLE (ps integer not null, pid varchar(255) not null, actionName varchar(255) not null, primary key (ps, pid, actionName));
create table PS_USER (ps integer not null, pid varchar(255) not null, actionName varchar(255) not null, primary key (ps, pid, actionName));
create table RECIPIENT (RECIPIENT_ID integer not null, email integer, rss integer, uiACK bit, NOTIFICATION_ID integer not null, user integer, primary key (RECIPIENT_ID));
create table REPLY (COMMENT_ID integer not null, REPLY_ID integer not null, primary key (COMMENT_ID, REPLY_ID));
create table REVIEW (REVIEW_ID integer not null, name varchar(255), repoName varchar(255), state varchar(255), description varchar(255), summary varchar(255), allowReviewerToJoin bit, CREATE_DATE timestamp, metricsVersion integer, parentReview integer, creator integer, project integer, primary key (REVIEW_ID));
create table REVIEW_COMMENT (REVIEW_ID integer not null, COMMENT_ID integer not null, primary key (REVIEW_ID, COMMENT_ID));
create table REVIEW_FIELD (REVIEW_ID integer not null, FIELD_ID integer not null, FIELD_ORDER integer not null, primary key (REVIEW_ID, FIELD_ORDER));
create table REVIEW_PARTICIPANT (PARTICIPANT_ID integer not null, REVIEW_ID integer not null, user integer, author bit, moderator bit, reviewer bit, allComplete bit, LAST_READ timestamp, primary key (PARTICIPANT_ID), unique (REVIEW_ID, user));
create table REVISION (REVISION_ID integer not null, CREATE_DATE timestamp, sourceName varchar(255), path varchar(255), revIdent varchar(255), revisionName varchar(255), reviewResult varchar(255), primary key (REVISION_ID), unique (sourceName, path, revIdent));
create table REVISION_COMMENT (RC_ID integer not null, CREATE_DATE timestamp, lineRange varchar(255), FRX_ID integer not null, revision integer, comment integer, primary key (RC_ID));
create table REVPERMAID (key varchar(255) not null, number integer not null, REVIEW_ID integer, primary key (key, number));
create table STATE_CHANGE (ID integer not null, TIME_STAMP timestamp, SUPERSEDED timestamp, reviewId integer, newState varchar(255), primary key (ID));
create table UPLOAD (UPLOAD_ID integer not null, CREATE_DATE timestamp, user integer, description varchar(255), originalName varchar(255), originalContentType varchar(255), primary key (UPLOAD_ID));
create table USER (USER_ID integer not null, userName varchar(255), dontSendMeMyNotifications bit, stateChangeEmailNotification integer, commentEmailNotification integer, replyEmailNotification integer, generalEmailNotification integer, completeEmailNotification integer, primary key (USER_ID), unique (userName));
insert into CRUVERSION values (1,22);
