/*eslint eqeqeq:0*/

function setupSelectedItemBinding(target, destinationForm, name, ignoreValue) {
    AJS.$("#" + target).bind("change", function () {
        // add the selected option to the form
        var selectedOption = this;
        if (selectedOption.value != ignoreValue) {
            //remove first then add to ensure only one copy is present at all times.
            AJS.$("#" + destinationForm + " input[type=hidden][value=" + selectedOption.value + "][name=" + name + "]").remove();
            AJS.$("#" + destinationForm).append("<input type='hidden' name='" + name + "' value='" + selectedOption.value + "'>");
            // change the UI to reflect the updated form
            AJS.$("#" + target + "-display #selected-item-" + selectedOption.value).remove();
            AJS.$("#" + target + "-display #selected-item-remove-" + selectedOption.value).remove();
            AJS.$("#" + target + "-display").append(makeRemoveLinkHTML(selectedOption.value));
            // bind to the UI the 'x' button - removes the selectedItem from both form and UI.
            AJS.$("#" + target + "-display #selected-item-remove-" + selectedOption.value)
                .bind("click", removeSelectedItemClicked(target, destinationForm, name, selectedOption.value));
            // hide the selected items, so as to prevent duplicates (or triggering this event again)
            AJS.$("#" + target + " option:selected").hide();
        }
    });
    //bind to existing form and UI elements if they exist (e.g., on the edit page)
    AJS.$("#" + destinationForm + " input[type=hidden][name=" + name + "]").each(function () {
        AJS.$("#" + target + "-display #selected-item-remove-" + this.value).bind("click",
            removeSelectedItemClicked(target, destinationForm, name, this.value));
        AJS.$("#" + target + " option[value=" + this.value + "]").hide();
    });
}

function setupDropdownChangeEvent(target, destination, name, ignoreValue) {
    AJS.$("#" + target).bind("change", function () {
        if (this.value != ignoreValue) {
            AJS.$("#" + destination + ' input[type=hidden][name=' + name + ']').remove();
            AJS.$("#" + destination).append("<input type='hidden' name='" + name + "' value='" + this.value + "'>");
        }
    });
}

function removeSelectedItemClicked(target, destination, name, optionVal) {
    return function () {
        AJS.$("#" + target + "-display #selected-item-" + optionVal).remove();
        AJS.$("#" + target + "-display #selected-item-remove-" + optionVal).remove();
        AJS.$("#" + destination + " input[type=hidden][value=" + optionVal + "][name=" + name + "]").remove();
        AJS.$("#" + target + " option[value=" + optionVal + "]").show();
    };
}

function setupAddAllLink(linkid, target, destination, name, ignoreValue) {
    var link = AJS.$("#" + linkid);
    link.bind('click', function (evnt) {
        evnt.preventDefault();
        var add = link.hasClass("addAll");
        var optionElements = AJS.$("#" + target + " option[value!=" + ignoreValue + "]");
        if (add) {
            optionElements.each(function () {
                // add the selected option to the form
                var selectedOption = this;
                if (selectedOption.value != ignoreValue) {
                    AJS.$("#" + destination + " input[type=hidden][value=" + selectedOption.value + "][value!=" + ignoreValue + "][name=" + name + "]").remove();
                    AJS.$("#" + destination).append("<input type='hidden' name='" + name + "' value='" + selectedOption.value + "'>");
                    // change the UI to reflect the updated form
                    AJS.$("#" + target + "-display #selected-item-" + selectedOption.value).remove();
                    AJS.$("#" + target + "-display #selected-item-remove-" + selectedOption.value).remove();
                    AJS.$("#" + target + "-display ").append(makeRemoveLinkHTML(selectedOption.value));
                    // bind to the UI the 'x' button - removes the selectedItem from both form and UI.
                    AJS.$("#" + target + "-display #selected-item-remove-" + selectedOption.value)
                        .bind("click", removeSelectedItemClicked(target, destination, name, selectedOption.value));
                }
            });
            AJS.$("#" + target + " option[value!=" + ignoreValue + "]").hide();
            link.removeClass("addAll");
            AJS.$("#" + linkid + " span").text("remove");
        } else {
            // remove all
            var hiddenInputs = AJS.$("#" + destination + " input[type=hidden][name=" + name + "]");
            hiddenInputs.each(function () {
                var selectedInput = this;
                // change the UI to reflect the updated form
                AJS.$("#" + target + "-display #selected-item-" + selectedInput.value).remove();
                AJS.$("#" + target + "-display #selected-item-remove-" + selectedInput.value).remove();
            });
            optionElements.show();
            hiddenInputs.remove();
            link.addClass("addAll");
            AJS.$("#" + linkid + " span").text("add");
        }
    });
}

function makeRemoveLinkHTML(id) {
    return "<div class='jira-admin-selected' id='selected-item-" + id + "'>" + id + "</" + "div>" +
        "<div class='jira-admin-selected-remove' id='selected-item-remove-" + id + "'>x<" + "/div>";
}
/*[{!jira_js_0ufx5ee!}]*/