//crucible global.js
var $dropdown = 0;
var dropdownTimer = 0;

function openDropDown(id) {
    clearTimeout(dropdownTimer);

    // Close the old menu if it's not the same menu as is already open
    if ($dropdown && (id instanceof AJS.$ ? ($dropdown.get(0) !== id.get(0)) : ($dropdown.attr("id") !== id))) {
        $dropdown.fadeOut(100);
    }

    // get new menu and show it
    var $menu = (id instanceof AJS.$) ? id : AJS.$("#" + id);
    $dropdown = $menu.show();
}

function closeDropDown() {
    if ($dropdown && $dropdown.length === 1) {
        dropdownTimer = setTimeout(function () {
            $dropdown.fadeOut(100);
        }, 200);
    }
}

function simpleSwap(toHide, toShow) {
    if (typeof(toHide) === 'object') {
        AJS.$(toHide).hide();
    } else {
        AJS.$("#" + toHide).hide();
    }
    if (typeof(toShow) === 'object') {
        AJS.$(toShow).show();
    } else {
        AJS.$("#" + toShow).show();
    }
}
function expandAll(ids, prefix) {
    toggleAll(ids, true, false, prefix);
}
function collapseAll(ids, prefix) {
    toggleAll(ids, false, true, prefix);
}
function expandSelected(allIds, selectedIds, prefix) {
    //first collapse all
    toggleAll(allIds, false, true, prefix);
    toggleAll(selectedIds, true, false, prefix);
}
function toggleType(ids, prefix) {
    toggleAll(ids, false, false, prefix);
}
function toggleBasic(nodeName) {
    toggleNodeAndImage(nodeName, false, false);
}
function collapseBasic(nodeName) {
    toggleNodeAndImage(nodeName, false, true);
}
function expandBasic(nodeName) {
    toggleNodeAndImage(nodeName, true, false);
}
function toggleAll(ids, forceOpen, forceClose, prefix) {
    prefix = prefix || '';
    for (var i = 0; i < ids.length; i++) {
        var theNode = prefix + ids[i];
        toggleNodeAndImage(theNode, forceOpen, forceClose);
    }
    return false;
}

function toggleNodeAndImage(nodeName, forceOpen, forceClose) {
    if (!nodeName) {
        return;
    }
    nodeName = FECRU.sanitizeId(nodeName);
    var $node = AJS.$("#" + nodeName);
    if ($node.length === 0) {
        return;
    }

    var img = AJS.$("#" + nodeName + 'img');
    if (img.length === 1) {
        var swapImage = true;
    }

    // Don't use is(":hidden") here, because we need to force things closed even if their parents are closed
    var shouldOpen = $node.css("display") === 'none';
    shouldOpen = (!forceClose) && (forceOpen || shouldOpen);
    if (shouldOpen) {
        $node.show();
        if (swapImage) {
            img.attr("src", FECRU.pageContext + '/' + FECRU.staticDirectory + '/images/arrow_open.gif');
        }
    } else {
        $node.hide();
        if (swapImage) {
            img.attr("src", FECRU.pageContext + '/' + FECRU.staticDirectory + '/images/arrow_closed.gif');
        }
    }
}

function rollover(obj) {
    if (obj.tagName === 'IMG') {
        var imgsrc = obj.src.replace(/\.gif$/, '');
        obj.src = imgsrc + '_over.gif';
    }
    return false;
}

function rollout(obj) {
    if (obj.tagName === 'IMG') {
        obj.src = obj.src.replace(/\_over\.gif$/, '.gif');
    }
    return false;
}

function toggleOverflow(handle, element) {
    var $el = AJS.$(element);
    var $hd = AJS.$(handle);
    if ($el.css("overflow") === 'hidden' || $el.css("overflow") === '') {
        $el.css({'overflow': 'visible', 'height': 'auto'});
        $hd.attr("src", $hd.attr("src").replace(/expand\.gif$/, 'collapse.gif'));
    } else {
        $el.css({'overflow': 'hidden', 'height': '1.3em'});
        $hd.attr("src", $hd.attr("src").replace(/collapse\.gif$/, 'expand.gif'));
    }
}


function submitDefaultForm(command) {
    document.defaultForm.command.value = command;
    document.defaultForm.submit();
}

function toggleWording(handle) {
    var $handleEl = AJS.$(handle);
    var handleText = $handleEl.html().substring(0, 4);
    switch (handleText) {
        case 'Show':
            $handleEl.html($handleEl.html().replace(/^Show/, 'Hide'));
            return true;
        case 'Hide':
            $handleEl.html($handleEl.html().replace(/^Hide/, 'Show'));
            return true;
        case 'Expa':
            $handleEl.html($handleEl.html().replace(/^Expand/, 'Collapse'));
            return true;
        case 'Coll':
            $handleEl.html($handleEl.html().replace(/^Collapse/, 'Expand'));
            return true;
        case 'More':
            $handleEl.html($handleEl.html().replace(/^More/, 'Less'));
            return true;
        case 'Less':
            $handleEl.html($handleEl.html().replace(/^Less/, 'More'));
            return true;
    }
    return false;
}

function show(toShow, bool) {
    AJS.$(toShow).toggle(bool);
}

var ovAnk = false; //tracks whether the mouse is over a "real" anchor
function toggleSensitively(id) {
    if (!ovAnk) {
        toggleBasic(id);
    }
}

// force IE8 to load icon fonts
// http://stackoverflow.com/questions/9809351/ie8-css-font-face-fonts-only-working-for-before-content-on-over-and-sometimes
(function ($) {
    if ($.browser.msie && $.browser.version <= 8) {
        AJS.$(function () {
            var head = document.getElementsByTagName('head')[0];
            var style = document.createElement('style');

            style.type = 'text/css';
            style.styleSheet.cssText = ':before,:after{content:none !important';
            head.appendChild(style);
            setTimeout(function () {
                head.removeChild(style);
            }, 0);
        });
    }
})(AJS.$);

// forces ie10 to redraw element for certain events
// we can remove this code after redesign of review page
(function ($, _) {
    var isIE11 = '-ms-scroll-limit' in document.documentElement.style && '-ms-ime-align' in document.documentElement.style;
    var isIE10 = $.browser.msie && $.browser.version === 10;
    if (isIE10 || isIE11) {
        document.documentElement.classList.add(isIE11 ? 'ie11' : 'ie10');

        $(function () {
            var classList = document.body.classList;
            var redrawBody = classList.toggle.bind(classList, 'oh-come-on-ie');
            var timeouts = {
                // aui2 dropdown2 sometimes needs 2 repaints
                'aui-dropdown2-show': [20, 100]
            };

            if (isIE10) {
                timeouts['aui-dropdown2-show'] = [20, 300];
                timeouts.showLayer = [200];
                timeouts.default = [50];
            }

            $(document).on(Object.keys(timeouts).join(' '), _.debounce(function (e) {
                redrawBody();
                var timeout = timeouts[e.type] || timeouts.default;
                timeout.forEach(setTimeout.bind(window, redrawBody));
            }, 50));
        });
    }

    if (isIE11) {
        // IE11 triggers focusin on body element after closing inline-dialog
        // "We need to stop him!"
        // should be fixed in AUI
        $(document).on('aui-dropdown2-show', function () {
            var $body = $(document.body);
            var blockFocusIn = function (e) {
                e.stopPropagation();
            };

            $body.on('focusin', blockFocusIn);
            setTimeout(function () {
                $body.off('focusin', blockFocusIn);
            }, 300);
        });
    }
})(AJS.$, _);
/*[{!global_js_ue575ef!}]*/