/* CONCAT of
/2static/script/lib/jquery/plugins/jquery.mousewheel.min.js
/2static/script/lib/jquery/plugins/jquery.ba-bbq.min.js
/2static/script/fe/commitgraph/drawing/shapes.js
/2static/script/fe/commitgraph/drawing/targets/element-data.js
/2static/script/fe/commitgraph/drawing/targets/svg-target.js
/2static/script/fe/commitgraph/configuration-data.js
/2static/script/fe/commitgraph/fragment.js
/2static/script/fe/commitgraph/branch-set.js
/2static/script/fe/commitgraph/drawing/positioner.js
/2static/script/fe/commitgraph/drawing/highlights/lineage-iterator.js
/2static/script/fe/commitgraph/drawing/highlights/highlight.js
/2static/script/fe/commitgraph/drawing/highlights/highlight-popup.js
/2static/script/fe/commitgraph/drawing/highlights/highlight-lozenge.js
/2static/script/fe/commitgraph/drawing/highlights/relation-highlighter.js
/2static/script/fe/commitgraph/drawing/highlights/jira-highlighter.js
/2static/script/fe/commitgraph/drawing/highlights/review-highlighter.js
/2static/script/fe/commitgraph/drawing/renderer.js
/2static/script/fe/commitgraph/drawing/branch-header.js
/2static/script/fe/commitgraph/changeset-dialog.js
/2static/script/fe/commitgraph/models/edge.js
/2static/script/fe/commitgraph/models/branch-revision.js
/2static/script/fe/commitgraph/models/changeset.js
/2static/script/fe/commitgraph/models/changeset-group.js
/2static/script/fe/commitgraph/models/changeset-dag-slice.js
/2static/script/fe/commitgraph/models/changeset-dag.js
/2static/script/fe/commitgraph/project-visualiser.js
*/
/* START /2static/script/lib/jquery/plugins/jquery.mousewheel.min.js */
/*! Copyright (c) 2011 Brandon Aaron (http://brandonaaron.net)
 Licensed under the MIT License (LICENSE.txt).

 Thanks to: http://adomas.org/javascript-mouse-wheel/ for some pointers.
 Thanks to: Mathias Bank(http://www.mathias-bank.de) for a scope bug fix.
 Thanks to: Seamus Leahy for adding deltaX and deltaY

 Version: 3.0.6

 Requires: 1.2.2+
 */(function($){var types=['DOMMouseScroll','mousewheel'];if($.event.fixHooks){for(var i=types.length;i;){$.event.fixHooks[types[--i]]=$.event.mouseHooks;}}
    $.event.special.mousewheel={setup:function(){if(this.addEventListener){for(var i=types.length;i;){this.addEventListener(types[--i],handler,false);}}else{this.onmousewheel=handler;}},teardown:function(){if(this.removeEventListener){for(var i=types.length;i;){this.removeEventListener(types[--i],handler,false);}}else{this.onmousewheel=null;}}};$.fn.extend({mousewheel:function(fn){return fn?this.bind("mousewheel",fn):this.trigger("mousewheel");},unmousewheel:function(fn){return this.unbind("mousewheel",fn);}});function handler(event){var orgEvent=event||window.event,args=[].slice.call(arguments,1),delta=0,returnValue=true,deltaX=0,deltaY=0;event=$.event.fix(orgEvent);event.type="mousewheel";if(orgEvent.wheelDelta){delta=orgEvent.wheelDelta/120;}
        if(orgEvent.detail){delta=-orgEvent.detail/3;}
        deltaY=delta;if(orgEvent.axis!==undefined&&orgEvent.axis===orgEvent.HORIZONTAL_AXIS){deltaY=0;deltaX=-1*delta;}
        if(orgEvent.wheelDeltaY!==undefined){deltaY=orgEvent.wheelDeltaY/120;}
        if(orgEvent.wheelDeltaX!==undefined){deltaX=-1*orgEvent.wheelDeltaX/120;}
        args.unshift(event,delta,deltaX,deltaY);return($.event.dispatch||$.event.handle).apply(this,args);}})(jQuery);/*[{!jquery_mousewheel_min_js_ap2f55p!}]*/;
/* END /2static/script/lib/jquery/plugins/jquery.mousewheel.min.js */
/* START /2static/script/lib/jquery/plugins/jquery.ba-bbq.min.js */
/*
 * jQuery BBQ: Back Button & Query Library - v1.2.1 - 2/17/2010
 * http://benalman.com/projects/jquery-bbq-plugin/
 * 
 * Copyright (c) 2010 "Cowboy" Ben Alman
 * Dual licensed under the MIT and GPL licenses.
 * http://benalman.com/about/license/
 */
(function($,p){var i,m=Array.prototype.slice,r=decodeURIComponent,a=$.param,c,l,v,b=$.bbq=$.bbq||{},q,u,j,e=$.event.special,d="hashchange",A="querystring",D="fragment",y="elemUrlAttr",g="location",k="href",t="src",x=/^.*\?|#.*$/g,w=/^.*\#/,h,C={};function E(F){return typeof F==="string"}function B(G){var F=m.call(arguments,1);return function(){return G.apply(this,F.concat(m.call(arguments)))}}function n(F){return F.replace(/^[^#]*#?(.*)$/,"$1")}function o(F){return F.replace(/(?:^[^?#]*\?([^#]*).*$)?.*/,"$1")}function f(H,M,F,I,G){var O,L,K,N,J;if(I!==i){K=F.match(H?/^([^#]*)\#?(.*)$/:/^([^#?]*)\??([^#]*)(#?.*)/);J=K[3]||"";if(G===2&&E(I)){L=I.replace(H?w:x,"")}else{N=l(K[2]);I=E(I)?l[H?D:A](I):I;L=G===2?I:G===1?$.extend({},I,N):$.extend({},N,I);L=a(L);if(H){L=L.replace(h,r)}}O=K[1]+(H?"#":L||!K[1]?"?":"")+L+J}else{O=M(F!==i?F:p[g][k])}return O}a[A]=B(f,0,o);a[D]=c=B(f,1,n);c.noEscape=function(G){G=G||"";var F=$.map(G.split(""),encodeURIComponent);h=new RegExp(F.join("|"),"g")};c.noEscape(",/");$.deparam=l=function(I,F){var H={},G={"true":!0,"false":!1,"null":null};$.each(I.replace(/\+/g," ").split("&"),function(L,Q){var K=Q.split("="),P=r(K[0]),J,O=H,M=0,R=P.split("]["),N=R.length-1;if(/\[/.test(R[0])&&/\]$/.test(R[N])){R[N]=R[N].replace(/\]$/,"");R=R.shift().split("[").concat(R);N=R.length-1}else{N=0}if(K.length===2){J=r(K[1]);if(F){J=J&&!isNaN(J)?+J:J==="undefined"?i:G[J]!==i?G[J]:J}if(N){for(;M<=N;M++){P=R[M]===""?O.length:R[M];O=O[P]=M<N?O[P]||(R[M+1]&&isNaN(R[M+1])?{}:[]):J}}else{if($.isArray(H[P])){H[P].push(J)}else{if(H[P]!==i){H[P]=[H[P],J]}else{H[P]=J}}}}else{if(P){H[P]=F?i:""}}});return H};function z(H,F,G){if(F===i||typeof F==="boolean"){G=F;F=a[H?D:A]()}else{F=E(F)?F.replace(H?w:x,""):F}return l(F,G)}l[A]=B(z,0);l[D]=v=B(z,1);$[y]||($[y]=function(F){return $.extend(C,F)})({a:k,base:k,iframe:t,img:t,input:t,form:"action",link:k,script:t});j=$[y];function s(I,G,H,F){if(!E(H)&&typeof H!=="object"){F=H;H=G;G=i}return this.each(function(){var L=$(this),J=G||j()[(this.nodeName||"").toLowerCase()]||"",K=J&&L.attr(J)||"";L.attr(J,a[I](K,H,F))})}$.fn[A]=B(s,A);$.fn[D]=B(s,D);b.pushState=q=function(I,F){if(E(I)&&/^#/.test(I)&&F===i){F=2}var H=I!==i,G=c(p[g][k],H?I:{},H?F:2);p[g][k]=G+(/#/.test(G)?"":"#")};b.getState=u=function(F,G){return F===i||typeof F==="boolean"?v(F):v(G)[F]};b.removeState=function(F){var G={};if(F!==i){G=u();$.each($.isArray(F)?F:arguments,function(I,H){delete G[H]})}q(G,2)};e[d]=$.extend(e[d],{add:function(F){var H;function G(J){var I=J[D]=c();J.getState=function(K,L){return K===i||typeof K==="boolean"?l(I,K):l(I,L)[K]};H.apply(this,arguments)}if($.isFunction(F)){H=F;return G}else{H=F.handler;F.handler=G}}})})(jQuery,this);
/*
 * jQuery hashchange event - v1.2 - 2/11/2010
 * http://benalman.com/projects/jquery-hashchange-plugin/
 * 
 * Copyright (c) 2010 "Cowboy" Ben Alman
 * Dual licensed under the MIT and GPL licenses.
 * http://benalman.com/about/license/
 */
(function($,i,b){var j,k=$.event.special,c="location",d="hashchange",l="href",f=$.browser,g=document.documentMode,h=f.msie&&(g===b||g<8),e="on"+d in i&&!h;function a(m){m=m||i[c][l];return m.replace(/^[^#]*#?(.*)$/,"$1")}$[d+"Delay"]=100;k[d]=$.extend(k[d],{setup:function(){if(e){return false}$(j.start)},teardown:function(){if(e){return false}$(j.stop)}});j=(function(){var m={},r,n,o,q;function p(){o=q=function(s){return s};if(h){n=$('<iframe src="javascript:0"/>').hide().insertAfter("body")[0].contentWindow;q=function(){return a(n.document[c][l])};o=function(u,s){if(u!==s){var t=n.document;t.open().close();t[c].hash="#"+u}};o(a())}}m.start=function(){if(r){return}var t=a();o||p();(function s(){var v=a(),u=q(t);if(v!==t){o(t=v,u);$(i).trigger(d)}else{if(u!==t){i[c][l]=i[c][l].replace(/#.*/,"")+"#"+u}}r=setTimeout(s,$[d+"Delay"])})()};m.stop=function(){if(!n){r&&clearTimeout(r);r=0}};return m})()})(jQuery,this);/*[{!jquery_ba_bbq_min_js_wmyd550!}]*/;
/* END /2static/script/lib/jquery/plugins/jquery.ba-bbq.min.js */
/* START /2static/script/fe/commitgraph/drawing/shapes.js */
var Shapes = (function () {
    var Point = function (x, y) {
        this.x = Number(x);
        this.y = Number(y);
    };
    Point.prototype.isValid = function () {
        return !isNaN(this.x) && !isNaN(this.y);
    };
    Point.prototype.toString = function () {
        return '(' + this.x.toFixed(2) + ',' + this.y.toFixed(2) + ')';
    };
    Point.prototype.isOrigin = function () {
        return this.x === 0 && this.y === 0;
    };

    var Vector = function (x, y) {
        this.x = Number(x);
        this.y = Number(y);
    };
    Vector.prototype.isValid = function () {
        return !isNaN(this.x) && !isNaN(this.y) && Number(this.x) === this.x && Number(this.y) === this.y;
    };
    Vector.prototype.add = function (vector) {
        if (!this.isValid() || !(vector instanceof Vector) || !vector.isValid()) {
            return undefined;
        }
        return new Vector(this.x + vector.x, this.y + vector.y);
    };
    Vector.prototype.equals = function (vector) {
        return vector && (vector instanceof Vector) && this.x === vector.x && this.y === vector.y;
    };
    Vector.prototype.getMagnitude = function () {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    };
    Vector.prototype.multiply = function (scalar) {
        return new Vector(this.x * scalar, this.y * scalar);
    };
    Vector.prototype.toString = function () {
        return '(' + this.x.toFixed(2) + ',' + this.y.toFixed(2) + ')';
    };

    /*
     * Takes in two Point instances.  The points will be reordered
     * such that point1 is left of point2 (or below point2 if the line is perfectly vertical).
     */
    var LineSegment = function (point1, point2) {
        if (!point1 || !point2) {
            throw "You must specify two Point objects";
        }
        if (point1.x < point2.x ||
            (point1.x === point2.x && point1.y <= point2.y)) {
            this.point1 = point1;
            this.point2 = point2;
        } else {
            this.point1 = point2;
            this.point2 = point1;
        }
    };
    LineSegment.hasIntersection = function (lineSegmentA, lineSegmentB) {
        //cache EVERYTHING
        var pA1 = lineSegmentA.point1;
        var pA2 = lineSegmentA.point2;
        var pB1 = lineSegmentB.point1;
        var pB2 = lineSegmentB.point2;
        var xA1 = pA1.x;
        var yA1 = pA1.y;
        var xA2 = pA2.x;
        var yA2 = pA2.y;
        var xB1 = pB1.x;
        var yB1 = pB1.y;
        var xB2 = pB2.x;
        var yB2 = pB2.y;

        /*
         The math is from: http://local.wasp.uwa.edu.au/~pbourke/geometry/lineline2d/

         Line segment A has endpoints P1(x1, y1) and P2(x2, y2)
         Line segment B has endpoints P3(x3, y3) and P4(x4, y4)

         Point on line segment A = Pa = P1 + ua ( P2 - P1 ); ua is between 0 and 1
         Point on line segment B = Pb = P3 + ub ( P4 - P3 ); ub is between 0 and 1

         Intersection of A and B is where Pa = Pb
         In terms of x and y, this is:
         x1 + ua (x2 - x1) = x3 + ub (x4 - x3)
         y1 + ua (y2 - y1) = y3 + ub (y4 - y3)

         Solving for ua and ua gives:
         ua = [(x4 - x3)(y1 - y3) - (y4 - y3)(x1 - x3)] / [(y4 - y3)(x2 - x1) - (x4 - x3)(y2 - y1)]
         ub = [(x2 - x1)(y1 - y3) - (y2 - y1)(x1 - x3)] / [(y4 - y3)(x2 - x1) - (x4 - x3)(y2 - y1)]
         Notice the denominators are the same.

         Notes I've taken for granted and can't explain:
         If the denominator for the equations for ua and ub is 0 then the two lines are parallel.
         If the denominator and numerator for the equations for ua and ub are 0 then the two lines are coincident.

         Since we're checking the line segments, ua and ub have to remain between 0 and 1 for their to be a collision.
         Because coincident lines have a denominator of 0, uA and uB are undefined, and checking 0 <= u <= 1 fails.
         Instead I rotate the coincident line segments parallel to x.
         */
        var yB2mYB1 = yB2 - yB1;
        var xA2mXA1 = xA2 - xA1;
        var xB2mXB1 = xB2 - xB1;
        var yA2mYA1 = yA2 - yA1;
        var yA1mYB1 = yA1 - yB1;
        var xA1mXB1 = xA1 - xB1;

        var uDenominator = yB2mYB1 * xA2mXA1 - xB2mXB1 * yA2mYA1;
        var uANumerator = xB2mXB1 * yA1mYB1 - yB2mYB1 * xA1mXB1;
        var uBNumerator = xA2mXA1 * yA1mYB1 - yA2mYA1 * xA1mXB1;
        var parallel = uDenominator === 0;

        if (parallel) {
            var coincident = uANumerator === 0 && uBNumerator === 0;
            if (coincident) { // They are both the same line, but possibly different segments of it.
                // First I rotate the points around the origin such that they are all parallel to the x-axis.
                // This lets me use the x coordinate alone to determine overlap (all y's should be the same)
                var angleToRotate = -Math.atan2(yA2mYA1, xA2mXA1);
                var cosAngle = Math.cos(angleToRotate);
                var sinAngle = Math.sin(angleToRotate);
                var xA1rotated = xA1 * cosAngle - yA1 * sinAngle;
                var xA2rotated = xA2 * cosAngle - yA2 * sinAngle;
                var xB1rotated = xB1 * cosAngle - yB1 * sinAngle;
                var xB2rotated = xB2 * cosAngle - yB2 * sinAngle;

                // the following line is only sufficient for intersection with the following assumptions:
                // 1) xA1rotated <= xA2rotated && xB1rotated <= xB2rotated - should be met by LineSegment ctor logic
                // 2) yA1rotated == yA2rotated == yB1rotated == yB2rotated - should be met by the rotation we did.
                return xA1rotated <= xB2rotated && xB1rotated <= xA2rotated;
            } else {
                return false;
            }
        } else {
            var uA = uANumerator / uDenominator;
            var uB = uBNumerator / uDenominator;

            return uA <= 1 && uA >= 0 && uB <= 1 && uB >= 0;
        }
    };
    LineSegment.prototype.intersects = function (other) {
        if (other instanceof LineSegment) {
            return LineSegment.hasIntersection(this, other);
        } else {
            throw "Not implemented."
        }
    };

    var Rectangle = function (x, y, width, height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.topLeft = new Point(x, y);
        this.topRight = new Point(x + width, y);
        this.bottomLeft = new Point(x, y + height);
        this.bottomRight = new Point(x + width, y + height);
        this.top = new LineSegment(this.topLeft, this.topRight);
        this.bottom = new LineSegment(this.bottomLeft, this.bottomRight);
        this.left = new LineSegment(this.topLeft, this.bottomLeft);
        this.right = new LineSegment(this.topRight, this.bottomRight);
    };
    /*
     * Determines whether the line segment passed in intersects with this Rectangle.
     * the line segment is considered to intersect if it intersects with any edge of
     * the Rectangle or is completely contained within the Rectangle
     * */
    Rectangle.prototype.intersectsLineSegment = function (ls) {
        return ( // is contained in Rectangle
                ls.point1.x > this.x &&
                ls.point1.y > this.y &&
                ls.point1.x < this.x + this.width &&
                ls.point1.y < this.y + this.height
            ) ||
            ls.intersects(this.left) || // intersects the left edge
            ls.intersects(this.right) || // intersects the right edge
            ls.intersects(this.top) || // intersects the top edge
            ls.intersects(this.bottom); // intersects the bottom edge
    };
    Rectangle.prototype.intersectsRectangle = function (rect) {
        return this.x <= rect.x + rect.width &&
            rect.x <= this.x + this.width &&
            this.y <= rect.y + rect.height &&
            rect.y <= this.y + this.height;
    };

    Rectangle.prototype.toString = function () {
        return '(' + this.x.toFixed(2) + ',' + this.y.toFixed(2) + ',' +
            this.width.toFixed(2) + ',' + this.height.toFixed(2) + ')';
    };

    return {
        Point: Point,
        Vector: Vector,
        LineSegment: LineSegment,
        Rectangle: Rectangle
    };
})();
/*[{!shapes_js_q4r352s!}]*/;
/* END /2static/script/fe/commitgraph/drawing/shapes.js */
/* START /2static/script/fe/commitgraph/drawing/targets/element-data.js */
window.Targets = window.Targets || {};

Targets.TargetResizeEvent = "resize";

Targets.ElementData = function (element, data) {
    this.element = element;
    this.data = data;
};

Targets.defaultSettings = {
    strokeColor: '#000',
    fillColor: '#000',
    strokeWidth: 1
};
/*[{!element_data_js_ntpx531!}]*/;
/* END /2static/script/fe/commitgraph/drawing/targets/element-data.js */
/* START /2static/script/fe/commitgraph/drawing/targets/svg-target.js */
window.Targets = window.Targets || {};

/* Drawing Targets
 * Must implement the following interface:
 * getElement() - returns the root DOM element of the drawing area.
 * getWidth() - returns the width of the root element of the drawing area.
 * getHeight() - returns the height of the root element of the drawing area.
 * drawGroup(parent, translation, scale, width, height) - draw a group element, used for doing bulk transforms on
 *       elements. Returns an object representing the group.
 * drawPoint(parent, position, radius, color) - draw a circle
 * drawPath(parent, start, \* optional midpoints, *\ end, color, moveToBack) - draw a path through the given points.
 * erase(element) - destroy the given element and remove it from the drawing area.
 * clear() - destroy all elements and reset the drawing area.
 */
Targets.SVG = (function ($) {
    // Imports
    var Point = Shapes.Point;
    var Vector = Shapes.Vector;
    var ElementData = Targets.ElementData;
    var EventProducer = FECRU.MIXINS.EventProducer;

    function toTransform(scale, translation) {
        var svgTranslate = "translate(" + translation.x + "," + translation.y + ")";
        var svgScale = typeof(scale) === 'number' && scale !== 1 ?
        "scale(" + scale + "," + scale + ")" :
            "";

        return svgTranslate || svgScale ? [svgScale, svgTranslate].join(' ') : "";
    }

    var SVGTarget = function (containerElement, settings) {
        this.settings = $.extend({}, Targets.defaultSettings, settings);
        var width = containerElement.offsetWidth;
        var height = containerElement.offsetHeight;
        var root = document.createElementNS(this.svgns, "svg");
        root.style.width = width;
        root.style.height = height;
        root.style.overflow = "hidden";

        var target = this;
        this.resize = function () {
            if (width !== containerElement.offsetWidth || height !== containerElement.offsetHeight) {
                width = containerElement.offsetWidth;
                height = containerElement.offsetHeight;
                root.style.width = width + 'px';
                root.style.height = height + 'px';

                target.trigger(Targets.TargetResizeEvent, {
                    width: width,
                    height: height
                });
            }
        };

        containerElement.appendChild(root);

        this.getElement = function () {
            return root;
        };
        this.getContainer = function () {
            return containerElement;
        };
        this.getWidth = function () {
            return width;
        };
        this.getHeight = function () {
            return height;
        };
    };
    $.extend(SVGTarget.prototype, EventProducer);
    SVGTarget.prototype.svgns = "http://www.w3.org/2000/svg";

    function getRootElementData(target) {
        return new ElementData(target.getElement(), {
            position: new Point(0, 0),
            width: target.getWidth(),
            height: target.getHeight()
        });
    }

    SVGTarget.prototype.drawGroup = function (parent, position, attributes) {
        //if no parent, assume root.
        parent = parent || getRootElementData(this);

        var position = new Point(position.x, position.y);

        attributes = $.extend({
            scale: 1,
            position: position
        }, attributes);

        var group = document.createElementNS(this.svgns, 'g');
        var elData = new ElementData(group, attributes);

        this.setGroupAttributes(elData, attributes);

        parent.element.appendChild(group);

        return elData;
    };

    SVGTarget.prototype.setGroupAttributes = function (elData, attributes) {
        var element = elData.element;

        if (attributes) {
            var data = elData.data;
            if (attributes.scale) {
                var position = data.position;
                var transform = toTransform(attributes.scale, position);

                if (transform) {
                    element.setAttribute('transform', transform);
                }
            }

            elData.data !== attributes && $.extend(elData.data, attributes);
        }
    };

    SVGTarget.prototype.drawRect = function (parent, position, attributes, prepend) {
        //if no parent, assume root.
        parent = parent || getRootElementData(this);

        attributes = $.extend({}, attributes);

        var rect = document.createElementNS(this.svgns, 'rect');
        var elData = new ElementData(rect, attributes);

        this.setRectAttributes(elData, attributes);

        if (prepend) {
            parent.element.insertBefore(rect, parent.element.firstChild);
        } else {
            parent.element.appendChild(rect);
        }

        return elData;
    };

    SVGTarget.prototype.setRectAttributes = function (elData, attributes) {
        var element = elData.element;

        if (attributes) {
            element.setAttribute('x', attributes.x + "px");
            element.setAttribute('y', attributes.y + "px");
            element.setAttribute('width', attributes.width + "px");
            element.setAttribute('height', attributes.height + "px");
            element.setAttribute('fill', attributes.fill);

            elData.data !== attributes && $.extend(elData.data, attributes);
        }
    };

    SVGTarget.prototype.drawPoint = function (parent, position, attributes) {
        //if no parent, assume root.
        parent = parent || getRootElementData(this);

        attributes = $.extend({
            radius: 9,
            position: new Point(position.x, position.y)
        }, this.settings, attributes);

        var circle = document.createElementNS(this.svgns, 'circle');
        var elementData = new ElementData(circle, attributes);

        circle.setAttribute('cy', position.y + 'px');
        circle.setAttribute('cx', position.x + 'px');
        circle.setAttribute('class', 'point');
        this.setPointAttributes(elementData, attributes);

        parent.element.appendChild(circle);

        return elementData;
    };
    SVGTarget.prototype.setPointAttributes = function (elData, attributes) {
        var element = elData.element;
        if (attributes) {
            attributes.radius && element.setAttribute('r', attributes.radius + 'px');
            attributes.fillColor && element.setAttribute('fill', attributes.fillColor);
            attributes.strokeColor && element.setAttribute('stroke', attributes.strokeColor);
            attributes.strokeWidth && element.setAttribute('stroke-width', attributes.strokeWidth + "px");

            elData.data !== attributes && $.extend(elData.data, attributes);
        }
    };

    function getPathStr(points) {

        if (points.length % 3 === 0) {
            var pointsCopy = points.slice(0);
            var startCmd = "M";
            var str = "";

            while (pointsCopy.length) {
                var p1 = pointsCopy.shift();
                var p2 = pointsCopy.shift();
                var p3 = pointsCopy.shift();

                str += startCmd + p1.x + "," + p1.y +
                    " Q" + p2.x + "," + p2.y + " " + p3.x + "," + p3.y;
                startCmd = " L";
            }
            return str;
        } else { // fallback to straight lines.
            return Array.reduce(points, "", function (str, point) {
                return (str ? str + " L" : "M") + point.x + "," + point.y;
            });
        }
    }

    SVGTarget.prototype.drawPath = function (parent, points, attributes) {
        //if no parent, assume root.
        parent = parent || getRootElementData(this);

        var pointsCopy = Array.map(points, function (point) {
            return new Point(point.x, point.y);
        });

        attributes = $.extend({
            positions: pointsCopy
        }, this.settings, attributes);

        var line = document.createElementNS(this.svgns, 'path');
        var elementData = new ElementData(line, attributes);

        line.setAttribute('d', getPathStr(points));
        line.setAttribute('fill', "none");
        line.setAttribute('class', 'path');
        setPathAttributesInternal(elementData, attributes, parent.element);

        return elementData;
    };

    SVGTarget.prototype.setPathAttributes = function (elData, attributes) {
        setPathAttributesInternal(elData, attributes);
        $.extend(elData.data, attributes);
    };
    function setPathAttributesInternal(elData, attributes, parentInternalUse) {
        var element = elData.element;
        if (attributes) {
            attributes.strokeColor && element.setAttribute('stroke', attributes.strokeColor);
            attributes.strokeWidth && element.setAttribute('stroke-width', attributes.strokeWidth);

            //don't move anything if they don't specify DOM placement attributes.
            var parentNode = parentInternalUse || element.parentNode;
            if (attributes.insertBeforeElement) {
                parentNode.insertBefore(element, attributes.insertBeforeElement.element);
            } else if (attributes.moveToBack !== undefined) {
                if (attributes.moveToBack) {
                    parentNode.insertBefore(element, parentNode.firstChild);
                } else {
                    parentNode.appendChild(element);
                }
            }
        }
    };

    SVGTarget.prototype.moveGroup = function (elData, position) {
        var el = elData.element;
        el.setAttribute('transform', toTransform(elData.scale, position));
        elData.data.position = new Point(position.x, position.y);
    };
    SVGTarget.prototype.movePoint = function (elData, position) {
        var el = elData.element;
        el.setAttribute('cx', position.x + "px");
        el.setAttribute('cy', position.y + "px");
    };
    SVGTarget.prototype.movePath = function (elData, points) {
        var el = elData.element;
        var pointsStr = getPathStr(points);
        el.setAttribute('d', pointsStr);
    };
    SVGTarget.prototype.moveRectangle = function (elData, position) {
        var el = elData.element;
        el.setAttribute('x', position.x + "px");
        el.setAttribute('y', position.y + "px");
    };

    SVGTarget.prototype.clear = function () {
        $(this.getElement()).children().remove();
    };
    SVGTarget.prototype.erase = function (el) {
        var element = el.element;
        if (element && element.parentNode) {
            element.parentNode.removeChild(element);
            el.element = null;
            return true;
        }
        return false;
    };
    return SVGTarget;
})(AJS.$);
/*[{!svg_target_js_9bu2533!}]*/;
/* END /2static/script/fe/commitgraph/drawing/targets/svg-target.js */
/* START /2static/script/fe/commitgraph/configuration-data.js */
window.FE = window.FE || {};
FE.VIS = FE.VIS || {};
/**
 * Stores configuration data.
 */
FE.VIS.Configuration = {
    CHANGESET_SPACING: 24,
    CHANGESET_RADIUS: 4.5,
    BRANCH_SPACING: 4,
    EDGE_HOVER_WIDTH: 4,
    NODE_HOVER_RADIUS: 2,
    METADATA_PADDING_LEFT: 12, // half a changeset spacing
    PERMALINK_THROTTLE: 750
};

FE.VIS.localStorageKeys = function (repoName) {
    return {
        highlighter: AJS.contextPath() + "VIS.highlighter." + repoName,
        branches: AJS.contextPath() + "VIS.branches." + repoName,
        mode: AJS.contextPath() + "VIS.mode." + repoName
    }
};

//FE.VIS.Configuration.defaultAvatarUrl is set in visualisation.jsp
/*[{!configuration_data_js_gq8c52j!}]*/;
/* END /2static/script/fe/commitgraph/configuration-data.js */
/* START /2static/script/fe/commitgraph/fragment.js */
FE.VIS.Fragment = (function ($) {

    /**
     * Returns an array composed of the given arr, and the given elem, but only if elem
     * is non-null.
     * @param arr an array
     * @param elem an element to append to the given array
     */
    function appendToArray(arr, elem) {
        if (arr && elem) {
            arr.push(elem);
        }
        return arr;
    }

    /*Public*/

    var Fragment = function (map, isAllBranchMode) {
        this.fragment = map;
        this.isAllBranchMode = isAllBranchMode;
    };

    Fragment.create = function (branches, isAllBranchMode, selectedChangesetId, highlighter, scrollToChangesetId) {
        var map = {};

        branches && (map.branch = $.isArray(branches) ? branches : [branches]);
        selectedChangesetId && (map.csid = selectedChangesetId);
        highlighter && (map.hl = highlighter);
        scrollToChangesetId && (map.scrollToCsid = scrollToChangesetId);

        return new Fragment(map, isAllBranchMode);
    };


    /**
     * expect the hash format to be #key=val&key2=val2
     * The key could have multiple values. In that case, the value will be added to an array in the order they appear.
     * @param fragmentString the hash fragment, or if undefined, defaults to the current urls' hash fragment
     * @param defaults the default values for keys, if they are not defined in the hash.
     * @param isAllBranchMode optional argument indicating whether the current mode is all branch mode. Assume to be false if not passed in.
     */
    Fragment.fromString = function (fragmentString, defaults, isAllBranchMode) {
        var fragmentStringMap = $.deparam.fragment(fragmentString || $.param.fragment(), false);
        var fullMap = defaults ?
            $.extend({}, defaults, fragmentStringMap) :
            fragmentStringMap;

        return new Fragment(fullMap, isAllBranchMode);
    };

    /**
     * @Returns the branches in the hash. If there are no branches in the hash, this will return the defaults (passed in via the ctor), or undefined if
     * the defaults didn't have any branches.
     */
    Fragment.prototype.getBranches = function () {
        var branches = this.get("branch");
        var csbr = (!this.isAllBranchMode) ? this.getChangesetBranch() : undefined;

        //the library doesn't force the branch param to be an array, so we do it here before munging
        return appendToArray(($.isArray(branches) ? branches : [branches]), csbr);
    };

    Fragment.prototype.getChangesetId = function () {
        return this.get("csid");
    };

    Fragment.prototype.getScrollToChangesetId = function () {
        return this.get("scrollToCsid");
    };

    Fragment.prototype.getChangesetBranch = function () {
        return this.get("csbr");
    };

    Fragment.prototype.getHighlighterName = function () {
        return this.get("hl");
    };

    /**
     * @Returns the parameter value given the key to the param key/val pair. The value could be an array if there are multiple
     * values for the same key. They are in the order that they appear in from the hash
     */
    Fragment.prototype.get = function (key) {
        return this.fragment[key];
    };

    Fragment.prototype.asMap = function () {
        return this.fragment;
    };

    Fragment.prototype.asString = function () {
        return $.param(this.fragment);
    };

    return Fragment;
})(AJS.$);
/*[{!fragment_js_v4zw52l!}]*/;
/* END /2static/script/fe/commitgraph/fragment.js */
/* START /2static/script/fe/commitgraph/branch-set.js */
FE.VIS.BranchSet = (function ($) {
    /**
     * Imports
     */
    var Map = FECRU.DATA_STRUCTURES.Map;
    var Fragment = FE.VIS.Fragment;
    var Configuration = FE.VIS.Configuration;
    var EventProducer = FECRU.MIXINS.EventProducer;
    var numericHash = FECRU.numericHash;

    /**
     * The set of colors that branches can have
     */
    var colors = [
        "#5e7084",
        "#326ca6",
        "#8c9ca9",
        "#2b8fb2",
        "#3d4a50",
        "#076c76",
        "#4e7c62",
        "#066006",
        "#7d8712",
        "#767649",
        "#330660",
        "#613991",
        "#85557d",
        "#841484",
        "#600633",
        "#ba6e72",
        "#900909",
        "#b7440b",
        "#ca7f0c",
        "#906c09"
    ];
    var defaultBranchColor = "#003366";

    /*private*/

    function createBranch(name, color) {
        return {
            name: name,
            breadth: 0,
            branchPosition: 0,
            color: color
        };
    }

    /*public*/

    /**
     * Create a branchset that models the set of branch in the graph
     * @param branchNames an array of branch names
     * @param allBranchesMode a boolean indicating whether the current display mode is 'all in one' or multi branch
     * @param options settings (the repo name, type and the url to use to save the branch)
     */
    var BranchSet = function (branchNames, allBranchesMode, options) {
        allBranchesMode = !!allBranchesMode;
        var allInOneBranch = createBranch('All Branches', '#666');
        var self = this;
        var settings = $.extend(options, {});

        this.repositoryName = settings.repositoryName;
        this.repositoryType = settings.repositoryType;
        this.saveBranchesUrl = settings.saveBranchesUrl;
        this.hashFragment = settings.hashFragment || Fragment.fromString("#", {branch: branchNames}, allBranchesMode);

        this.get = function (branchName) {
            return this.branchByName.get(branchName);
        };

        this.getAllBranches = function () {
            return this.iterable.slice(0);
        };

        this.getBranchNames = function () {
            return this.branchNames.slice(0); // clone
        };

        this.isAllInOne = function () {
            return allBranchesMode;
        };

        this.getAllInOne = function () {
            return allInOneBranch;
        };

        this.getRepositoryName = function () {
            return this.repositoryName;
        };

        this.getRepositoryType = function () {
            return this.repositoryType;
        };

        this.addBranch = function (branchName) {
            if (this.isAllInOne()) {
                //switch out of all-in-one.
                reinit(this, [branchName], false);
            } else if (!this.get(branchName)) {
                var branch = createBranch(branchName, BranchSet.colorForBranch(branchName));
                self.branchByName.set(branchName, branch);
                self.iterable.push(branch);
                self.branchNames.push(branchName);
            }
        };

        this.removeBranch = function (branchName) {
            var branch = this.branchByName.get(branchName);
            if (branch) {
                this.branchByName.remove(branchName);
                var branchIndex = $.inArray(branch, self.iterable);
                Array.remove(self.iterable, branchIndex);
            }
        };

        function reinit(self, branchNames, isAllBranchesMode) {
            self.branchByName = new Map();
            self.iterable = [];
            self.branchNames = [];
            allBranchesMode = !!isAllBranchesMode;
            if (allBranchesMode) {
                self.branchNames = branchNames;
                self.iterable.push(allInOneBranch);
            } else {
                branchNames && Array.each(branchNames, function (name) {
                    self.addBranch(name);
                });
                //save the changeset branch if it exists
                if (self.hashFragment.getChangesetBranch()) {
                    //pass in $.noop as callback because the is no need to trigger any call back here - the set of branches,
                    //as far as other components are concerned, has not been modified (so we dont trigger any events either)
                    self.saveBranches(branchNames, allBranchesMode, $.noop, $.noop);
                }
            }
        }

        //TODO: change to FECRU.ajax(), not $.ajax()
        this.saveBranches = function (branchesToSave, allBranchesMode, successCallback, errorCallback) {
            var self = this;
            var onSuccess = successCallback || function () {
                    self.trigger(BranchSet.BranchModified, {
                        branches: branchesToSave
                    });
                };
            var onError = errorCallback || function () {
                    AJS.log("error saving branches " + branchesToSave);
                };
            $.ajax({
                url: self.saveBranchesUrl,
                type: "POST",
                data: {
                    repoName: self.getRepositoryName(),
                    'vbs': '{"' + self.getRepositoryName() + '":{' + (branchesToSave ? ('bl:[' +
                    Array.map(branchesToSave, function (b) {
                        return '"' + FECRU.quoteString(b) + '"';
                    }).join(',') + '], ') : '') + 'm:"' + (allBranchesMode ? 'A' : 'C') + '"}}'
                },
                success: function (data, textStatus, jqXHR) {
                    onSuccess && onSuccess(data, textStatus, jqXHR);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    onError && onError(jqXHR, textStatus, errorThrown);
                }
            });

            if (window.localStorage) {
                window.localStorage[FE.VIS.localStorageKeys(this.repositoryName).branches] = JSON.stringify(branchesToSave);
                window.localStorage[FE.VIS.localStorageKeys(this.repositoryName).mode] = allBranchesMode ? 'ALL' : 'CUSTOM';
            }
        };

        reinit(this, branchNames, allBranchesMode);
    };

    function isDefaultBranch(branchName) {
        return Configuration.visualiserSetting.defaultBranchName === branchName;
    }

    BranchSet.colorForBranch = function (branchName) {
        return isDefaultBranch(branchName) ? defaultBranchColor : colors[numericHash(branchName, colors.length)];
    };
    //fallback if no branch exists.
    BranchSet.fallbackBranchColor = "#666";

    /**
     * Events that exist on the branchset. You can obtain a reference to the branchset instance and
     * call branchSet.trigger(_event_name_, {...parametersMap...}) to trigger the event (all bound functions to that event will execute), or
     * branchSet.bind(_event_name_, function(parametersMap){...code...}); to bind the event.
     */
    BranchSet.BranchModified = "BranchModified";
    BranchSet.BranchesAdded = "BranchesAdded";
    BranchSet.BranchesRemoved = "BranchesRemoved";
    BranchSet.BranchResized = "BranchResized";
    BranchSet.BranchesReordered = "BranchesReordered";

    $.extend(BranchSet.prototype, EventProducer);

    return BranchSet;
})(AJS.$);
/*[{!branch_set_js_hc1j52h!}]*/;
/* END /2static/script/fe/commitgraph/branch-set.js */
/* START /2static/script/fe/commitgraph/drawing/positioner.js */
FE.VIS.POSITIONING = (function ($) {

    /* Imports */
    var EventProducer = FECRU.MIXINS.EventProducer;

    var AbstractPositioner = function (positionChangesetsInBranch) {
        this.positionChangesetsInBranch = positionChangesetsInBranch;
    };
    $.extend(AbstractPositioner.prototype, EventProducer);

    AbstractPositioner.prototype.positionGroups = function (slice) {
        var self = this;
        var nextY = 0;

        Array.each(slice.changesetGroups, function (group) {
            var maxBranchPosition = 0;
            var l = group.branchRevisions.length;

            for (var i = 0; i < l; i++) {
                var branchRevision = group.branchRevisions[i];
                maxBranchPosition = Math.max(maxBranchPosition, branchRevision.branchPosition);
            }

            var groupBreadth = l ?
                Math.max(maxBranchPosition + 1, 2) /* min-width: 2*changeset-spacings */ :
                /*Empty breadth: */ 1;
            var branch = group.branch;

            var oldBranchBreadth = branch.breadth;
            var branchBreadth;

            if (oldBranchBreadth < groupBreadth) {
                branchBreadth = groupBreadth;
                self.trigger(AbstractPositioner.BranchExpandedEvent, {
                    branchName: branch.name,
                    breadth: branchBreadth
                });
            } else {
                branchBreadth = oldBranchBreadth;
            }

            branch.branchPosition = nextY;
            branch.breadth = branchBreadth;
            nextY += branchBreadth; // the group below shifts down by this branch's breadth
        });
    };
    AbstractPositioner.BranchExpandedEvent = "BranchExpanded";

    AbstractPositioner.prototype.positionSlice = function (slice, neighbor, atEnd) {
        if (neighbor) {
            slice.timePosition = atEnd ?
            neighbor.timePosition + neighbor.length :
            neighbor.timePosition - slice.length;
        } else {
            slice.timePosition = 0;
        }
    };
    var timeSpanOnGraph = function (brev1, brev2) {
        return Math.abs(brev1.changeset.absTimePosition - brev2.changeset.absTimePosition);
    };

    var findNearestSpace = function (stack, startIndex) {
        var length = stack.length;
        for (var upI = startIndex, downI = startIndex;
             upI > 0 || downI < length;
             --upI, ++downI) {
            if (upI >= 0) {
                if (stack[upI] === undefined) {
                    return upI;
                }
            }
            if (downI < length) {
                if (stack[downI] === undefined) {
                    return downI;
                }
            }
        }

        return length;
    };

    var methodGroups = {
        ancestorBased: {
            prevNodes: "parents",
            nextNodes: "children",
            prevNodesOnBranch: "parentsOnBranch",
            nextNodesOnBranch: "childrenOnBranch",
            isSparsePrevNode: "isSparseAncestor"
        },
        descendantBased: {
            prevNodes: "children",
            nextNodes: "parents",
            prevNodesOnBranch: "childrenOnBranch",
            nextNodesOnBranch: "parentsOnBranch",
            isSparsePrevNode: "isSparseDescendant"
        }
    };

    AbstractPositioner.prototype.positionChangesetsInTime = function (changesets, slice, ancestorBased) {
        //set changeset positions
        if (ancestorBased) {
            Array.each(changesets, function (cs, i) {
                cs.timePosition = i;
                cs.absTimePosition = slice.timePosition + i;
            });
        } else {
            var lastIndex = changesets.length - 1;
            Array.each(changesets, function (cs, i) {
                var x = cs.timePosition = (lastIndex - i);
                cs.absTimePosition = slice.timePosition + x;
            });
        }
    };

    AbstractPositioner.prototype.positionNewSlices = function (newSlices, newSparseAncestors, newSparseDescendants, newSparseOnBranch, positioningData, neighbor, ancestorBased) {
        var positioner = this;
        var newLiveChangesets = [];

        Array.each(newSlices, function (slice) {
            positioner.positionSlice(slice, neighbor, ancestorBased);
            neighbor = slice;

            var sliceChangesets = slice.getAllChangesets(!ancestorBased);

            positioner.positionChangesetsInTime(sliceChangesets, slice, ancestorBased);

            $.merge(newLiveChangesets, sliceChangesets);
        });
        // position sparse changesets in time as well.
        Array.each(newSparseAncestors, function (cs) {
            cs.timePosition = cs.absTimePosition = -Infinity;
        });
        Array.each(newSparseDescendants, function (cs) {
            cs.timePosition = cs.absTimePosition = Infinity;
        });
        Array.each(newSparseOnBranch, function (cs) {
            cs.timePosition = NaN;
        });

        var firstSparse = (ancestorBased ? newSparseAncestors : newSparseDescendants) || [];
        var lastSparse = (ancestorBased ? newSparseDescendants : newSparseAncestors) || [];

        if (firstSparse.length) {
            // First lot of data to be loaded
            positioner.positionChangesetsInBranch(firstSparse, positioningData, ancestorBased, true);
        }
        positioner.positionChangesetsInBranch(newLiveChangesets || [], positioningData, ancestorBased);
        positioner.positionChangesetsInBranch(lastSparse, positioningData, ancestorBased);

        Array.each(newSparseOnBranch, function (cs) {
            cs.branchPosition = Infinity;
        });

        Array.each(newSlices, function (slice) {
            positioner.positionGroups(slice);
        });
    };

    AbstractPositioner.prototype.getChangesetAtTimePosition = function (graph, timePosition) {
        var sliceWithChangeset;
        var changesetAtTimePosition = null;

        Array.each(graph.dagSlices, function (slice) {
            if (slice.timePosition <= timePosition &&
                slice.getLength() + slice.timePosition >= timePosition) {
                sliceWithChangeset = slice;
                return false;
            }
        });

        if (sliceWithChangeset) {
            var offset = timePosition - sliceWithChangeset.timePosition;
            Array.each(sliceWithChangeset.getAllChangesets(), function (cs) {
                if (cs.timePosition === offset) {
                    changesetAtTimePosition = cs;
                    return false;
                }
            });
        }

        return changesetAtTimePosition;
    };

    // Our positioning algorithm

    function positionBranchRevisionInBranch(branchRevision, positionArray, methods) {
        var nextNodesFuncKey = methods.nextNodesOnBranch;
        var prevNodesFuncKey = methods.prevNodesOnBranch;
        var isSparsePrevNodeFuncKey = methods.isSparsePrevNode;
        var notChangeset = function (node) {
            return node !== branchRevision;
        };

        var prevNodesOnBranch = branchRevision[prevNodesFuncKey]();
        var prevNodeCount = prevNodesOnBranch.length;
        var stackHeight = positionArray.length;
        var newBreadthPos;

        if (prevNodeCount === 0 || branchRevision[isSparsePrevNodeFuncKey]()) { // head, sparse or branch point

            // Find the first empty spot in the array. If there isn't one, use the height
            var availablePosition = $.inArray(undefined, positionArray);
            newBreadthPos = availablePosition !== -1 ? availablePosition : stackHeight;

        } else if (prevNodeCount === 1) {

            var prevNode = prevNodesOnBranch[0];
            var prevNodeNextNodesOnBranch = $.grep(prevNode[nextNodesFuncKey](), notChangeset); // Sibling / spouse
            var prevNodeNextNodeCount = prevNodeNextNodesOnBranch.length;

            if (prevNodeNextNodeCount === 0) {
                // Its a normal commit
                newBreadthPos = prevNode.branchPosition;
            } else {
                var timeSpan = timeSpanOnGraph(branchRevision, prevNode);
                if (Array.any(prevNodeNextNodesOnBranch,
                        function (node) {
                            return timeSpanOnGraph(node, prevNode) > timeSpan;
                        })) {
                    newBreadthPos = findNearestSpace(positionArray, prevNode.branchPosition);
                } else {
                    newBreadthPos = prevNode.branchPosition;
                }
            }

        } else {

            var furthestPrevNode = null;
            var longestTimeSpan = 0;

            Array.each(prevNodesOnBranch, function (prevNode) {
                var timeSpan = timeSpanOnGraph(branchRevision, prevNode);
                if (timeSpan > longestTimeSpan) {
                    longestTimeSpan = timeSpan;
                    furthestPrevNode = prevNode;
                    if (timeSpan === Infinity) {
                        return false; // child is sparse
                    }
                }
            });

            var shouldMatchFurthestPrevNode = true;
            Array.each(prevNodesOnBranch, function (prevNode) {
                var timeSpan = timeSpanOnGraph(branchRevision, prevNode);
                var nextNodeIsFurther = function (nextNode) {
                    return nextNode !== branchRevision && timeSpanOnGraph(nextNode, prevNode) > timeSpan;
                };

                if (!Array.any(prevNode[nextNodesFuncKey](), nextNodeIsFurther)) {
                    positionArray[prevNode.branchPosition] = undefined;
                } else if (prevNode === furthestPrevNode) {
                    /**
                     * This scenario happened
                     * <---Positioner is sweeper this way
                     * o--------------o
                     *           @---/
                     *            \o
                     *
                     * The furthest previous node is not the further previous node of one of its next node
                     */
                    shouldMatchFurthestPrevNode = false;
                }
            });
            newBreadthPos = shouldMatchFurthestPrevNode ?
                furthestPrevNode.branchPosition :
                findNearestSpace(positionArray, furthestPrevNode.branchPosition);
        }
        // Ensure the changeset is only positioned once
        branchRevision.branchPosition = !isNaN(branchRevision.branchPosition) ? branchRevision.branchPosition : newBreadthPos;

        var nextNodes = branchRevision[nextNodesFuncKey]();
        var shouldMakeAvailable = !branchRevision.isSparse()
            && (nextNodes.length === 0 || Array.all(nextNodes, function (brev) {
                return !isNaN(brev.branchPosition);
            }));

        //preserve this position in the positioning array if the changeset isn't sparse and has "next" nodes.
        positionArray[newBreadthPos] = shouldMakeAvailable ? undefined : branchRevision.id;
    }

    function positionChangesetInBranch(changeset, positionArraysByBranch, methods) {
        Array.each(changeset.branchRevisions, function (brev) {
            var branchName = brev.primaryBranch.name;
            if (!positionArraysByBranch[branchName]) {
                positionArraysByBranch[branchName] = [];
            }
            positionBranchRevisionInBranch(brev, positionArraysByBranch[branchName], methods);
        });
    }

    function positionChangesetsInBranch(changesets, positioningData, ancestorBased, initialPositioning) {
        var positionArraysByBranch;
        if (ancestorBased) {
            positionArraysByBranch = positioningData.atEnd = positioningData.atEnd || {};
        } else {
            positionArraysByBranch = positioningData.atStart = positioningData.atStart || {};
        }

        var methods = ancestorBased ? methodGroups.ancestorBased : methodGroups.descendantBased;
        Array.each(changesets, function (cs) {
            positionChangesetInBranch(cs, positionArraysByBranch, methods);
        });
        if (initialPositioning) {
            if (ancestorBased) {
                positioningData.atStart = $.extend(true, {}, positionArraysByBranch);
            } else {
                positioningData.atEnd = $.extend(true, {}, positionArraysByBranch);
            }
        }
    }

    return {
        AbstractPositioner: AbstractPositioner,
        defaultPositioner: new AbstractPositioner(positionChangesetsInBranch)
    };
})(AJS.$);
/*[{!positioner_js_0sha52q!}]*/;
/* END /2static/script/fe/commitgraph/drawing/positioner.js */
/* START /2static/script/fe/commitgraph/drawing/highlights/lineage-iterator.js */
FE.VIS.HIGHLIGHTS = FE.VIS.HIGHLIGHTS || {};
FE.VIS.HIGHLIGHTS.ITERATORS = (function ($) {
    function getDepthFirstIterator(startingObject, startingCs, getNextEdges, getNextChangeset) {
        var pathSoFar = [];
        var indicesSoFar = [];
        var curr = startingCs;
        var allTraversedObjects = [startingCs];
        var addToTraversedObjects = function (newObj) {
            if ($.inArray(newObj, allTraversedObjects) === -1) {
                allTraversedObjects.push(newObj);
                return true;
            }
            return false;
        };
        var firstTime = true;

        if (startingObject !== startingCs) {
            allTraversedObjects.shift(startingObject);
        }

        var iterator = function (endCurrentPath) {
            var edges;
            var nextI;
            var nextEdge;

            if (firstTime) {
                firstTime = false;
                nextI = 0;
                return curr;
            }

            if (!endCurrentPath) {
                edges = getNextEdges(curr);
                nextI = 0;
                if (edges.length) {
                    nextEdge = edges[nextI];

                    var nextCs = getNextChangeset(nextEdge);
                    if (nextCs && addToTraversedObjects(nextEdge) && addToTraversedObjects(nextCs)) {
                        pathSoFar.push(curr);
                        indicesSoFar.push(nextI);
                        return curr = nextCs;
                    } else {
                        // this path has already been traversed from another route.
                        // try the next sibling if it exists (otherwise, we'll begin stepping back below.
                        nextI++;
                    }

                }
            }

            //else  must step back, while we have path left to backtrack on.
            var validNextEdge = edges && edges.length > nextI;
            var canStepBack = pathSoFar.length;

            while (canStepBack || validNextEdge) {
                // while we've exausted all edges on the current node and we still have some path left to backtrack
                while (!validNextEdge && canStepBack) {
                    curr = pathSoFar.pop(); // step back
                    edges = getNextEdges(curr); // re-get edges
                    nextI = indicesSoFar.pop() + 1; // get the next edge-index to try

                    validNextEdge = edges && edges.length > nextI;
                    canStepBack = pathSoFar.length;
                }

                // found something, try each edge in turn.
                while (validNextEdge) {
                    nextEdge = edges[nextI];

                    var nextCs = getNextChangeset(nextEdge);
                    if (nextCs && addToTraversedObjects(nextEdge) && addToTraversedObjects(nextCs)) {
                        pathSoFar.push(curr);
                        indicesSoFar.push(nextI);
                        return curr = nextCs;
                    }

                    ++nextI;
                    validNextEdge = edges && edges.length > nextI;
                }
            }
            return null; // nothing left
        };
        iterator.getCurrentPathObjects = function () {
            var objects = startingCs === startingObject ? [] : [startingObject];
            //push pairs of changeset + following edge
            Array.each(pathSoFar, function (cs, i) {
                objects.push(cs);
                var edgeIndex = indicesSoFar[i];
                var edges = getNextEdges(cs);
                var edge = edges[edgeIndex];

                objects.push(edge);
            });
            //finally push the current object
            objects.push(curr);
            return objects;
        };
        iterator.getCurrentPathChangesets = function () {
            var objects = pathSoFar.slice(0);
            objects.push(curr);
            return objects;
        };
        iterator.getAllTraversedObjects = function () {
            return allTraversedObjects;
        };
        iterator.getAllTraversedChangesets = function () {
            return $.grep(allTraversedObjects, function (obj) {
                return obj.isChangeset();
            });
        };
        return iterator;
    }

    function getAncestorIterator(startingObject, startingCs, untilCs) {
        if (!untilCs || startingCs.order > untilCs.order) {
            return getDepthFirstIterator(startingObject, startingCs,
                function (cs) {
                    return cs.parentEdges();
                },
                untilCs ?
                    function (edge) {
                        var parent = edge.parent();
                        return parent.order >= untilCs.order ? parent : null;
                    } :
                    function (edge) {
                        return edge.parent();
                    }
            );
        } else {
            return getDepthFirstIterator(startingObject, startingCs, function () {
                return [];
            }, function () {
            });
        }
    }

    function getDescendantIterator(startingObject, startingCs, untilCs) {
        if (!untilCs || startingCs.order < untilCs.order) {
            return getDepthFirstIterator(startingObject, startingCs,
                function (cs) {
                    return cs.childEdges();
                },
                untilCs ?
                    function (edge) {
                        var child = edge.child();
                        return child.order <= untilCs.order ? child : null;
                    } :
                    function (edge) {
                        return edge.child();
                    }
            );
        } else {
            return getDepthFirstIterator(startingObject, startingCs, function () {
                return [];
            }, function () {
            });
        }
    }

    var Iterators;
    return Iterators = {
        DESCENDANTS: "descendants",
        ANCESTORS: "ancestors",
        getDepthFirstChangesetIterator: function (startObject, stopChangesetOrDirection) {
            if (!startObject) {
                throw new Error("Starting changeset or edge must be specified.");
            }
            if (!stopChangesetOrDirection) {
                throw new Error("Stopping changeset or direction must be specified.");
            }

            var startChangeset;
            var stopChangeset;
            var getter;

            switch (stopChangesetOrDirection) {
                case Iterators.DESCENDANTS:
                    getter = getDescendantIterator;
                    break;
                case Iterators.ANCESTORS:
                    getter = getAncestorIterator;
                    break;
                default:
                    stopChangeset = stopChangesetOrDirection;
                    if (startObject.isEdge()) {
                        if (stopChangeset.order >= startObject.child().order) {
                            startChangeset = startObject.child();
                            getter = getDescendantIterator;
                        } else {
                            startChangeset = startObject.parent();
                            getter = getAncestorIterator;
                        }

                    } else {
                        startChangeset = startObject;
                        getter = stopChangeset.order > startChangeset.order ?
                            getDescendantIterator :
                            getAncestorIterator;
                    }
                    break;
            }

            //if they passed a direction, we haven't filled in the start changeset yet
            if (!startChangeset) {
                startChangeset = startObject.isEdge() ?
                    (getter === getDescendantIterator ? startObject.child() : startObject.parent()) :
                    startObject;
            }

            return getter(startObject, startChangeset, stopChangeset);
        }
    };

})(AJS.$);
/*[{!lineage_iterator_js_29i152y!}]*/;
/* END /2static/script/fe/commitgraph/drawing/highlights/lineage-iterator.js */
/* START /2static/script/fe/commitgraph/drawing/highlights/highlight.js */
AJS.$.extend(FE.VIS.HIGHLIGHTS, (function ($) {

    /* Imports */
    var Map = FECRU.DATA_STRUCTURES.Map;
    var CacheMap = FECRU.DATA_STRUCTURES.CacheMap;
    var EventProducer = FECRU.MIXINS.EventProducer;
    var colorForBranch = FE.VIS.BranchSet.colorForBranch;
    var fallbackBranchColor = FE.VIS.fallbackBranchColor;
    var Iterators = FE.VIS.HIGHLIGHTS.ITERATORS;

    var COLOR_BY_BRANCH = "COLOR_BY_BRANCH";

    function getBranchColorFromChangeset(cs) {
        var primaryBranches = cs._model.primaryBranches;
        if (primaryBranches && primaryBranches.length === 1) {
            var primaryBranch = primaryBranches[0];
            return primaryBranch.name !== 'All Branches' ? //all check is a hack
                primaryBranch.color :
            cs.branches && cs.branches.length && colorForBranch(cs.branches[0]);
        } else if (primaryBranches && primaryBranches.length > 1) {
            /* complex SVN commit */
            return COLOR_BY_BRANCH;
        } else {
            return fallbackBranchColor;
            /* sparseOnBranch */
        }
    }

    function getBranchColorFromEdge(edge) {
        return getBranchColorFromChangeset(edge.parent());
    }

    function HighlightHelper(highlightContext) {
        var context = highlightContext;
        var loadingState = false;

        return {
            setLoading: function (isLoading) {
                if (isLoading !== loadingState) {
                    if (isLoading) {
                        context.trigger(HighlightContext.LoadingStarted);
                    } else {
                        context.trigger(HighlightContext.LoadingFinished);
                        this.forceRedraw();
                    }
                    loadingState = isLoading;
                }
            },
            forceRedraw: function () {
                context.trigger(HighlightContext.RedrawRequested);
            }
        }
    }

    /* Public */

    /**
     * Encapsulates a highlighter's interface with the views.
     * It can create "HighlightableChangesets" and "HighlightableEdges" that
     * will be sent to the highlighter for highlighting.
     * @param highlighter the highlighter this context is for.
     * @param changesetDefaults standard changeset styling attributes to pass to plugins.
     * @param edgeDefaults standard edge styling attributes to pass to plugins.
     */
    var HighlightContext = function (highlighter, changesetDefaults, edgeDefaults) {
        this.highlighter = highlighter = highlighter || {};

        var helperEnabled = !!highlighter.setHelper;
        var edgeHighlightsEnabled = this.edgeHighlightsEnabled = !!highlighter.highlightEdge;
        var changesetHighlightsEnabled = this.changesetHighlightsEnabled = !!highlighter.highlightChangeset;
        var focusEnabled = this.focusEnabled = highlighter.onFocusChanged;
        var relatedChangesetsEnabled = this.relatedChangesetsEnabled = !!highlighter.getAllRelatedChangesets;
        var moreInfoEnabled = this.moreInfoEnabled = !!highlighter.getMoreInfo;
        var onActivationEnabled = this.onActivationEnabled = !!highlighter.onActivation;
        var onDeactivationEnabled = this.onDeactivationEnabled = !!highlighter.onDeactivation;
        var onDataLoadedEnabled = this.onDataLoadedEnabled = !!highlighter.onDataLoaded;
        var onDataUnloadedEnabled = this.onDataUnloadedEnabled = !!highlighter.onDataUnloaded;
        var lozengesEnabled = this.getLozenges = !!highlighter.getLozenges;
        var changesetAnnotationEnabled = this.getChangesetAnnotation = !!highlighter.getChangesetAnnotation;

        changesetDefaults = $.extend(true, {
            Selected: {
                color: '#FFF',
                hasBorder: true,
                borderColor: '#000',
                borderWidth: 4,
                textColor: null,
                backgroundColor: '#3D82F8',
                metadataCssClass: null
            },
            Emphasized: {
                color: '#EA7400',
                hasBorder: true,
                borderColor: '#003366',
                borderWidth: 2,
                textColor: null,
                backgroundColor: '#FFCC00',
                metadataCssClass: null
            },
            Normal: {
                color: '#326CA6',
                hasBorder: false,
                borderColor: null,
                borderWidth: null,
                textColor: null,
                backgroundColor: null,
                metadataCssClass: null
            },
            BranchSelected: {
                color: '#FFF',
                hasBorder: true,
                borderColor: '#000',
                borderWidth: 4,
                textColor: null,
                backgroundColor: '#3D82F8',
                metadataCssClass: null
            },
            BranchEmphasized: {
                color: getBranchColorFromChangeset,
                hasBorder: true,
                borderColor: getBranchColorFromChangeset,
                borderWidth: 2,
                textColor: null,
                backgroundColor: null,
                metadataCssClass: null
            },
            BranchNormal: {
                color: getBranchColorFromChangeset,
                hasBorder: false,
                borderColor: null,
                borderWidth: null,
                textColor: null,
                backgroundColor: null,
                metadataCssClass: null
            },
            Dimmed: {
                color: '#CCC',
                hasBorder: false,
                borderColor: null,
                borderWidth: null,
                textColor: '#999',
                backgroundColor: null,
                metadataCssClass: "metadata-dimmed"
            }
        }, changesetDefaults || {});

        edgeDefaults = $.extend(true, {
            Selected: {
                color: '#000',
                hasBorder: true,
                borderColor: '#000',
                borderWidth: 1
            },
            Emphasized: {
                color: '#CCC',
                hasBorder: 1,
                borderColor: "#CCC",
                borderWidth: 1
            },
            Normal: {
                color: '#CCC',
                hasBorder: false,
                borderColor: null,
                borderWidth: null
            },
            BranchSelected: {
                color: getBranchColorFromEdge,
                hasBorder: true,
                borderColor: getBranchColorFromEdge,
                borderWidth: 1
            },
            BranchEmphasized: {
                color: getBranchColorFromEdge,
                hasBorder: false,
                borderColor: null,
                borderWidth: null
            },
            BranchNormal: {
                color: '#CCC',
                hasBorder: false,
                borderColor: null,
                borderWidth: null
            },
            Dimmed: {
                color: '#CCC',
                hasBorder: false,
                borderColor: null,
                borderWidth: null
            }
        }, edgeDefaults || {});

        this.focusedObject = null;

        //Putting our ancestry cache on the context allows me to isolate it from other plugins (so one can't ruin another).
        this.ancestorCache = new CacheMap(20);
        this.descendantCache = new CacheMap(20);


        var changesetsById = new Map();
        var edgesByLinkedIds = new Map();
        var self = this;

        var getChangeset = function (model) {
            return changesetsById.get(model.id);
        };
        var createChangeset = function (model) {
            var newCs = new HighlightableChangeset(model, self);
            changesetsById.set(model.id, newCs);
            newCs.attr(changesetDefaults.Normal);
            return newCs;
        };
        var getOrCreateChangeset = function (model) {
            return getChangeset(model) || createChangeset(model);
        };
        var getEdge = function (model) {
            return edgesByLinkedIds.get(model.childChangeset.id + "-" + model.parentChangeset.id);
        };
        var createEdge = function (model) {
            var parent = getOrCreateChangeset(model.parentChangeset);
            var child = getOrCreateChangeset(model.childChangeset);
            var edge = new HighlightableEdge(model, parent, child, self);

            edgesByLinkedIds.set(child.csid + "-" + parent.csid, edge);
            edge.attr(edgeDefaults.Normal);
            return edge;
        };
        var getOrCreateEdge = function (model) {
            return getEdge(model) || createEdge(model);
        };

        this.getChangeset = getOrCreateChangeset;
        this.getEdge = getOrCreateEdge;

        function logError(e) {
            FECRU.AJAX.appendErrorResponse(e, false);
            FECRU.AJAX.showNotificationBox(e.toString());
        }

        function getTryFunction(isEnabled, enabledFunc, disabledFunc, getDefaultValue) {
            if (isEnabled) {
                return function () {
                    try {
                        return enabledFunc.apply(this, arguments);
                    } catch (e) {
                        logError(e);
                        return getDefaultValue && getDefaultValue();
                    }
                };
            } else {
                return !disabledFunc ? $.noop : function () {
                    try {
                        return disabledFunc.apply(this, arguments);
                    } catch (e) {
                        logError(e);
                        return getDefaultValue && getDefaultValue();
                    }
                };
            }
        }

        this.highlightEdge = getTryFunction(edgeHighlightsEnabled, function (edge) {
            if (edge === this.focusedObject) {
                this.focusedObject.attr(edgeDefaults.Selected);
                if (!focusEnabled) {
                    return;
                }
            }
            highlighter.highlightEdge(edge, edgeDefaults);
        }/*, noop - do not set selected style on edges if highlightEdges isn't implemented */);

        this.highlightChangeset = getTryFunction(changesetHighlightsEnabled, function (cs) {
            if (cs === this.focusedObject) {
                this.focusedObject.attr(changesetDefaults.Selected);
                if (!focusEnabled) {
                    return;
                }
            }
            highlighter.highlightChangeset(cs, changesetDefaults);
        }, function (cs) {
            /* if they don't implement highlightChangeset, there's probably something terribly wrong going on.
             Regardless, we still want to make sure the selected attributes are applied.
             * */
            if (cs === this.focusedObject) {
                this.focusedObject.attr(changesetDefaults.Selected);
            } else {
                this.focusedObject.attr(changesetDefaults.Normal);
            }
        });

        this.onFocusChanged = getTryFunction(focusEnabled, function (focusedObject) {
            if (focusedObject !== this.focusedObject) {
                this.focusedObject = focusedObject;
                highlighter.onFocusChanged(focusedObject);
            }
        }, function (focusedObject) {
            this.focusedObject = focusedObject;
        });

        this.getAllRelatedChangesets = getTryFunction(relatedChangesetsEnabled, function (focusedChangeset) {
            return highlighter.getAllRelatedChangesets(focusedChangeset);
        }, null, function () {
            return [];
        });

        this.getMoreInfo = getTryFunction(moreInfoEnabled, function (focusedChangeset, $moreInfoContainer) {
            return highlighter.getMoreInfo(focusedChangeset, $moreInfoContainer);
        });

        this.onActivation = getTryFunction(onActivationEnabled, function (allChangesets, focusedObject) {
            highlighter.onActivation(allChangesets);
            this.onFocusChanged(focusedObject);
        }, function (unused, focusedObject) {
            this.onFocusChanged(focusedObject);
        });

        this.onDeactivation = getTryFunction(onDeactivationEnabled, function () {
            highlighter.onDeactivation();
        });

        this.onDataLoaded = getTryFunction(onDataLoadedEnabled, function (loadedChangesets) {
            highlighter.onDataLoaded(loadedChangesets);
        });

        this.onDataUnloaded = getTryFunction(onDataUnloadedEnabled, function (unloadedChangesets) {
            highlighter.onDataUnloaded(unloadedChangesets);
        });

        this.getChangesetAnnotation = getTryFunction(changesetAnnotationEnabled, function (changeset) {
            return highlighter.getChangesetAnnotation(changeset, FE.VIS.HIGHLIGHT_POPUP.createAnnotationList);
        });

        this.getLozenges = getTryFunction(lozengesEnabled, function (changeset) {
            return highlighter.getLozenges(changeset, FE.VIS.HIGHLIGHT_LOZENGE.create);
        });

        if (helperEnabled) {
            try {
                this.highlighter.setHelper(new HighlightHelper(this));
            } catch (e) {
                logError(e);
            }
        }
    };

    $.extend(HighlightContext.prototype, EventProducer);
    HighlightContext.LoadingStarted = "LoadingStarted";
    HighlightContext.LoadingFinished = "LoadingFinished";
    HighlightContext.RedrawRequested = "RedrawRequested";

    function getValue(obj, funcOrValue) {
        return $.isFunction(funcOrValue) ? funcOrValue(obj) : funcOrValue;
    }

    /**
     * These functions are called in attr if the key passed in matches the key in this object.
     * They are also callable directly on some objects.
     */
    var attributeHooks = {
        color: function (funcOrColor) {
            if (funcOrColor !== undefined) {
                this._attributes.color = getValue(this, funcOrColor);
                return this;
            } else {
                return this._attributes.color;
            }
        },
        hasBorder: function (funcOrBool) {
            if (funcOrBool !== undefined) {
                this._attributes.hasBorder = !!getValue(this, funcOrBool);
                return this;
            } else {
                return this._attributes.hasBorder;
            }
        },
        borderColor: function (funcOrColorStr) {
            if (funcOrColorStr !== undefined) {
                this._attributes.borderColor = getValue(this, funcOrColorStr);
                return this;
            } else {
                return this._attributes.borderColor;
            }
        },
        borderWidth: function (funcOrNumber) {
            if (funcOrNumber !== undefined) {
                var width = getValue(this, funcOrNumber);
                if (width !== null && typeof width !== 'number') {
                    throw new Error("borderWidth must be a number or a function that returns a number.");
                }
                this._attributes.borderWidth = width;
                return this;
            } else {
                return this._attributes.borderWidth;
            }
        },
        textColor: function (funcOrColorStr) {
            if (funcOrColorStr !== undefined) {
                this._attributes.textColor = getValue(this, funcOrColorStr) || '';
                return this;
            } else {
                return this._attributes.textColor;
            }
        },
        backgroundColor: function (funcOrColorStr) {
            if (funcOrColorStr !== undefined) {
                this._attributes.backgroundColor = getValue(this, funcOrColorStr) || '';
                return this;
            } else {
                return this._attributes.backgroundColor;
            }
        },
        metadataCssClass: function (funcOrClassStr) {
            if (funcOrClassStr !== undefined) {
                this._attributes.metadataCssClass = getValue(this, funcOrClassStr) || '';
                return this;
            } else {
                return this._attributes.metadataCssClass;
            }
        }
    };

    function isObject(o) {
        return typeof o === 'object' && o !== null;
    }

    var isRelated = function (toCs, iterator, directionalCacheMap) {
        var cache;
        if (directionalCacheMap.has(toCs.csid)) {
            cache = directionalCacheMap.get(toCs.csid);
        } else {
            directionalCacheMap.set(toCs.csid, cache = new Map());
        }

        var endCurrentPath = false;
        var next;

        while (next = iterator(endCurrentPath)) {
            endCurrentPath = false;
            if (cache.get(next.csid) === false) {
                endCurrentPath = true;

            } else if (cache.get(next.csid) === true || next.csid === toCs.csid) {

                var changesetsInPath = iterator.getCurrentPathChangesets();
                Array.each(changesetsInPath, function (cs) {
                    cache.set(cs.csid, true);
                });

                return true;
            }
        }

        //if none of my ancestors were related, everything can be set to unrelated.
        var allCs = iterator.getAllTraversedChangesets();
        Array.each(allCs, function (cs) {
            cache.set(cs.csid, false);
        });
        return false;
    };

    /**
     * A mixin containing the basic functionality of a highlightable object.
     * Changesets/edges we expose to highlight-plugin developers should implement these methods.
     */
    var HighlightableObject = {

        color: attributeHooks.color,

        hasBorder: attributeHooks.hasBorder,

        borderColor: attributeHooks.borderColor,

        borderWidth: attributeHooks.borderWidth,

        metadataCssClass: attributeHooks.metadataCssClass,

        attr: function (attributesOrKey, value) {
            var attributeFunction;

            if (attributesOrKey === void 0) {
                return (this._attributes = this._attributes || {});
            }

            if (isObject(attributesOrKey) && attributesOrKey.hasOwnProperty) { // all attrs
                for (var attribute in attributesOrKey) {
                    if (attributesOrKey.hasOwnProperty(attribute)) {
                        if (attributeFunction = attributeHooks[attribute]) {
                            attributeFunction.call(this, attributesOrKey[attribute]);
                        } else {
                            throw new Error('Unrecognized attribute: "' + attribute + '"');
                        }
                    }
                }
            } else if (attributeFunction = attributeHooks[attributesOrKey]) { // single attr
                return attributeFunction.call(this, value);
            } else {
                if (attributesOrKey === null) {
                    throw new TypeError("Attribute object cannot be null.");
                } else {
                    throw new Error('Unrecognized attribute: "' + attributesOrKey + '"');
                }
            }

            return this;
        },

        isDescendantOf: function (ofObj) {
            if (this === ofObj) {
                return false;
            }

            var endCs = ofObj.isChangeset() ? ofObj : ofObj.child();
            var iterator = this.getAncestorIterator(endCs);

            return isRelated(endCs, iterator, this._context.descendantCache);
        },

        isAncestorOf: function (ofObj) {
            if (this === ofObj) {
                return false;
            }

            var endCs = ofObj.isChangeset() ? ofObj : ofObj.parent();
            var iterator = this.getDescendantIterator(endCs);

            return isRelated(endCs, iterator, this._context.ancestorCache);
        },

        isRelatedTo: function (toCs) {
            return toCs === this || this.isAncestorOf(toCs) || this.isDescendantOf(toCs);
        }
    };


    /**
     * An object that represents a changeset, as it is visible to the highlighter.
     * @param model the actual changeset model backing this HighlightableChangeset
     * @param highlightContext the highlightContext that created this HighlightableChangeset.
     */
    var HighlightableChangeset = function (model, highlightContext) {
        //Private
        this._attributes = {};
        this._context = highlightContext;

        this.init(model);
    };
    $.extend(HighlightableChangeset.prototype, HighlightableObject);

    HighlightableChangeset.prototype.init = function (model) {
        //Private
        this._model = model;

        // Public
        this.csid = model.id;
        this.branches = model.branches.slice(0);
        this.tags = model.tags.slice(0);
        this.order = model.order;
        this.commitDate = new Date(model.date);
        this.author = $.extend(true, {}, model.author);
        this.commentHtml = model.comment;
    };

    HighlightableChangeset.prototype.backgroundColor = attributeHooks.backgroundColor;

    HighlightableChangeset.prototype.textColor = attributeHooks.textColor;

    HighlightableChangeset.prototype.highlightedClass = attributeHooks.highlightedClass;

    HighlightableChangeset.prototype.parents = function () {
        var parents = Array.map(this._model.parents(), this._context.getChangeset);

        if (this._model.isLive()) {
            this.parents = function () {
                return parents;
            };
        }

        return parents;
    };

    HighlightableChangeset.prototype.children = function () {
        var children = Array.map(this._model.children(), this._context.getChangeset);

        if (this._model.isLive()) {
            this.children = function () {
                return children;
            };
        }

        return children;
    };

    HighlightableChangeset.prototype.getAncestorIterator = function (stopAtCs) {
        return Iterators.getDepthFirstChangesetIterator(
            this,
            stopAtCs ?
                (stopAtCs.order < this.order ? stopAtCs : this) :
                Iterators.ANCESTORS);
    };

    HighlightableChangeset.prototype.getDescendantIterator = function (stopAtCs) {
        return Iterators.getDepthFirstChangesetIterator(
            this,
            stopAtCs ?
                (stopAtCs.order > this.order ? stopAtCs : this) :
                Iterators.DESCENDANTS);
    };

    HighlightableChangeset.prototype.parentEdges = function () {
        var branchRevisions = this._model.branchRevisions;
        var edges = [];

        Array.each(branchRevisions, function (brev) {
            if (brev.parentEdges) {
                Array.each(brev.parentEdges, function (edge) {
                    edges.push(edge);
                });
            }
        });

        var parentEdges = Array.map(edges, this._context.getEdge);

        if (this._model.isLive()) {
            this.parentEdges = function () {
                return parentEdges;
            };
        }

        return parentEdges;
    };

    HighlightableChangeset.prototype.childEdges = function () {
        var branchRevisions = this._model.branchRevisions;
        var edges = [];

        Array.each(branchRevisions, function (brev) {
            if (brev.childEdges) {
                Array.each(brev.childEdges, function (edge) {
                    edges.push(edge);
                });
            }
        });

        var childEdges = Array.map(edges, this._context.getEdge);

        if (this._model.isLive()) {
            this.childEdges = function () {
                return childEdges;
            };
        }

        return childEdges;
    };

    HighlightableChangeset.prototype.isChangeset = function () {
        return true;
    };
    HighlightableChangeset.prototype.isEdge = function () {
        return false;
    };


    /**
     * An object that represents an edge, as it is visible to the highlighter.
     * @param model the edge model backing this HighlightableEdge
     * @param parent a HighlightableChangeset representing the parent on this edge
     * @param child a HighlightableChangeset representing the child on this edge
     * @param highlightContext the context that created this HighlightableEdge
     */
    var HighlightableEdge = function (model, parent, child, highlightContext) {
        this._attributes = {};
        this._model = model;
        this._context = highlightContext;
        this._parent = parent;
        this._child = child;

        // Public
    };
    $.extend(HighlightableEdge.prototype, HighlightableObject);

    HighlightableEdge.prototype.parent = function () {
        return this._parent;
    };
    HighlightableEdge.prototype.child = function () {
        return this._child;
    };

    HighlightableEdge.prototype.isChangeset = function () {
        return false;
    };
    HighlightableEdge.prototype.isEdge = function () {
        return true;
    };

    HighlightableEdge.prototype.getAncestorIterator = function (stopAtCs) {
        var parent = this.parent();
        return Iterators.getDepthFirstChangesetIterator(
            this,
            stopAtCs ?
                (stopAtCs.order <= parent.order ? stopAtCs : this.parent()) :
                Iterators.ANCESTORS);
    };

    HighlightableEdge.prototype.getDescendantIterator = function (stopAtCs) {
        var child = this.child();
        return Iterators.getDepthFirstChangesetIterator(
            this,
            stopAtCs ?
                (stopAtCs.order >= child.order ? stopAtCs : this.child()) :
                Iterators.DESCENDANTS);
    };

    var pluginHighlighters = [];
    var addHighlighter = function (highlighter) {
        pluginHighlighters.push(highlighter);//TODO: check for clashes in names etc
    };
    var getPluginHighlighters = function () {
        return pluginHighlighters;
    };

    return {
        HighlightContext: HighlightContext,
        HighlightableObject: HighlightableObject,
        HighlightableChangeset: HighlightableChangeset,
        HighlightableEdge: HighlightableEdge,
        addHighlighter: addHighlighter,
        getPluginHighlighters: getPluginHighlighters,
        COLOR_BY_BRANCH: COLOR_BY_BRANCH
    };
})(AJS.$));
/*[{!highlight_js_izd752w!}]*/;
/* END /2static/script/fe/commitgraph/drawing/highlights/highlight.js */
/* START /2static/script/fe/commitgraph/drawing/highlights/highlight-popup.js */
FE.VIS.HIGHLIGHT_POPUP = (function ($) {

    var ANNOTATION_CLASS = "highlight-annotation";

    function getSortedBranches(branches, primaryBranchNames) {
        branches = branches.slice(0);
        branches.sort(function (a, b) {
            var aIndex = $.inArray(a, primaryBranchNames);
            var bIndex = $.inArray(b, primaryBranchNames);

            if (aIndex !== -1) {
                if (bIndex !== -1) {
                    return a > b ? 1 : -1;
                } else {
                    return -1;
                }
            } else {
                if (bIndex !== -1) {
                    return 1;
                } else {
                    return a > b ? 1 : -1;
                }
            }
        });
        return branches;
    }

    var HighlightPopup = function (selector, id, opts) {
        var defaults = {
            onHover: true,
            fadeTime: 0,
            hideDelay: 80,
            showDelay: 30,
            cacheContent: false,
            useLiveEvents: true,
            addActiveClass: false,
            displayShadow: false,
            getHighlightableChangeset: function () {
                throw "You must supply a getHighlightableChangeset method to HighlightPopup";
            },
            getHighlightContext: function () {
                throw "You must supply a getHighlightContext method to HighlightPopup";
            },
            calculatePositions: function (popup, targetPosition, mousePosition, opts) {
                // CONSTANTS
                var LEFT_PADDING = 8;

                var popupTop = 0;
                var popupLeft = 0;
                var useMousePosition = $.browser.msie && $.browser.version < 9;

                // Only calculate svg element locations if we aren't using mouse position
                if (!useMousePosition) {
                    try {
                        var svgElement = targetPosition.target[0];
                        var boundingBox = svgElement.getBoundingClientRect();

                        var boxLeft = boundingBox.left;
                        var boxTop = boundingBox.top;
                        var boxWidth = boundingBox.width;
                        var boxHeight = boundingBox.height;
                        var elementRadius = svgElement.nodeName === "circle" ? svgElement.r.baseVal.value : 0;

                        if (!boxLeft && !boxTop) {
                            useMousePosition = true;
                        } else {
                            popupLeft = boxLeft + (boxWidth + elementRadius) / 2;
                            popupTop = boxTop + boxHeight / 2 - elementRadius - 3;
                        }
                    } catch (e) {
                        useMousePosition = true;
                    }
                }

                if (useMousePosition) {
                    // fall back to mouse position
                    popupLeft = mousePosition.x;
                    popupTop = mousePosition.y;
                }

                popupLeft += LEFT_PADDING;

                return {
                    displayAbove: false,
                    popupCss: {
                        left: popupLeft,
                        right: "auto",
                        top: popupTop
                    },
                    arrowCss: {
                        display: "none"
                    }
                }
            }
        };

        var hoverOpts = $.extend({}, defaults, opts);

        this.initialise(selector, id, hoverOpts);
    };

    HighlightPopup.create = function (selector, id, opts) {
        return new HighlightPopup(selector, id, opts);
    };

    HighlightPopup.prototype.initialise = function (selector, id, opts) {
        if (this.popup) {
            return; // don't multi-init
        }
        var self = this;
        var lastTrigger = undefined;

        this.popup = AJS.InlineDialog(selector, id, function (contents, trigger, showPopup) {
            var $contents = $(contents).empty();
            var cs = opts.getHighlightableChangeset(trigger);

            if (cs) {
                var highlightContext = opts.getHighlightContext();
                var highlightableChangeset = highlightContext.getChangeset(cs);

                var annotation = highlightContext.getChangesetAnnotation(highlightableChangeset);

                var $container = $("<div></div>");
                var primaryBranches = Array.map(cs.primaryBranches, function (branch) {
                    return branch.name;
                });

                var branches = getSortedBranches(cs.branches, primaryBranches);

                var $csidElem = $("<div></div>").text(opts.getDisplayCsId(cs.id));

                var $branchUl = HighlightPopup.createAnnotationList(branches, {
                    sort: false,
                    getTruncationMessage: function (hiddenCount) {
                        return hiddenCount + " other branches";
                    }
                }).addClass(ANNOTATION_CLASS);

                $container
                    .append($csidElem)
                    .append($branchUl);

                if (annotation) {
                    if (annotation instanceof jQuery) {
                        $container.append(annotation.addClass(ANNOTATION_CLASS));
                    } else {
                        $container.append(
                            $("<div>")
                                .addClass(ANNOTATION_CLASS)
                                .html(annotation)
                        );
                    }
                }
                $contents.append($container);

                if (lastTrigger && lastTrigger !== trigger) {
                    if (self.popup) {
                        // Set the display property rather than calling "hide()" because InlineDialog overrides this method
                        // and it does not do what we expect
                        self.popup.css("display", "none");
                    }
                }
                lastTrigger = trigger;

                showPopup();
            }
        }, opts);
    };

    HighlightPopup.prototype.erase = function () {
        if (this.popup) {
            this.popup.remove();
            this.popup = null;
        }
    };

    HighlightPopup.createAnnotationList = function (items, listOpts) {
        if (!items || !items.length) {
            return null;
        }

        var defaults = {
            maxItems: 10,
            sort: false,
            getTruncationMessage: function (hiddenCount) {
                return hiddenCount + " not shown";
            },
            getItemHtml: undefined,
            listClass: undefined,
            truncatedMessageClass: "hidden-truncated"
        };

        var opts = $.extend({}, defaults, listOpts);

        var $ul = $("<ul></ul>");

        if (opts.listClass) {
            $ul.addClass(opts.listClass);
        }

        if (opts.sort) {
            items = $.isFunction(opts.sort) ?
                items.sort(opts.sort) :
                items.sort();
        }

        Array.each(items, function (item, i) {
            if (opts.maxItems && i >= opts.maxItems) {
                var truncatedMessage = opts.getTruncationMessage(items.length - i);
                $ul.append(
                    $("<li>")
                        .addClass(opts.truncatedMessageClass)
                        .text(truncatedMessage)
                );
                return false;
            }
            var $li = $("<li>");
            if (opts.getItemHtml) {
                $li.html(opts.getItemHtml(item));
            } else {
                $li.text(item);
            }
            $ul.append($li);
        });

        return $ul;
    };

    HighlightPopup.getSortedBranches = getSortedBranches;

    return HighlightPopup;
})(AJS.$);
/*[{!highlight_popup_js_swf152v!}]*/;
/* END /2static/script/fe/commitgraph/drawing/highlights/highlight-popup.js */
/* START /2static/script/fe/commitgraph/drawing/highlights/highlight-lozenge.js */
FE.VIS.HIGHLIGHT_LOZENGE = (function ($) {
    var HighlightLozenge = function (items, options) {

        if (!items || !items.length) {
            throw "Can't create a lozenge out of nothing, sire!";
        }

        var defaults = {
            lozengeClass: null,
            getItemText: null,
            getItemTitle: null,
            collapseCount: 2,
            maxItems: 20,
            sort: false,
            collapsedLozengeText: function (itemCount) {
                return itemCount + " items";
            },
            getTruncationMessage: function (hiddenCount) {
                return hiddenCount + " not shown";
            },
            truncatedMessageClass: "hidden-truncated"
        };

        this.opts = $.extend({}, defaults, options);
        this.lozenges = [];
        this.dropdowns = [];

        var self = this;
        var opts = self.opts;

        if (opts.sort) {
            items = $.isFunction(opts.sort) ?
                items.sort(opts.sort) :
                items.sort();
        }

        if (items.length <= opts.collapseCount) {
            Array.each(items, function (item) {
                self.createLozengeItem(item, opts.getItemText, opts.getItemTitle);
            });
        } else {
            self.createCollapsedLozengeItem(items);
        }
    };

    HighlightLozenge.create = function (items, opts) {
        return new HighlightLozenge(items, opts);
    };

    HighlightLozenge.prototype.erase = function () {
        this.dropdowns = [];
        this.lozenges = [];
        this.opts = null;
    };

    HighlightLozenge.prototype.getLozenges = function () {
        return this.lozenges;
    };

    var _setupLozengeItem = function (item, $lozenge, itemTextCreator, itemTitleCreator) {
        if (itemTextCreator) {
            var itemText = itemTextCreator(item);
            if (itemText.jquery) {
                $lozenge.append($(itemText));
            } else {
                $lozenge.text(itemText);
            }
        } else {
            $lozenge.text(item);
        }

        if (itemTitleCreator) {
            var title = itemTitleCreator(item);
            if (title) {
                $lozenge.attr("title", title);
            }
        }
    };

    HighlightLozenge.prototype.createLozengeItem = function (item, itemTextCreator, itemTitleCreator) {
        var opts = this.opts;
        var $item = $("<span></span>").addClass("highlight-lozenge");

        if (opts.lozengeClass) {
            $item.addClass(opts.lozengeClass);
        }

        _setupLozengeItem(item, $item, itemTextCreator, itemTitleCreator);
        this.lozenges.push($item);
        return $item;
    };

    HighlightLozenge.prototype.createCollapsedLozengeItem = function (items) {
        var self = this;
        var opts = self.opts;
        var $item = self.createLozengeItem(opts.collapsedLozengeText(items.length), function (item) {
            return $("<span class='aui-dd-trigger'></span>").text(item);
        }).addClass("aui-dd-parent");

        var itemTextCreator = opts.getItemText;
        var itemTitleCreator = opts.getItemTitle;

        var $ul = $("<ul></ul>").addClass("collapsed-items aui-dropdown");
        Array.each(items, function (item, i) {
            var $li = $("<li></li>");
            if (opts.maxItems && i >= opts.maxItems) {
                var truncatedMessage = opts.getTruncationMessage(items.length - i);
                $ul.append(
                    $li
                        .addClass(opts.truncatedMessageClass)
                        .text(truncatedMessage)
                );
                return false;
            }

            _setupLozengeItem(item, $li, itemTextCreator, itemTitleCreator);

            $ul.append($li);
        });

        $item
            .addClass("lozenge-collapsed")
            .append($ul);

        // setup AUI dropdown foo
        $item.addClass("aui-dd-trigger");
        var dropDown = $item.dropDown("Standard", {
            alignment: "right"
        });
        this.dropdowns.push(dropDown);
    };

    return HighlightLozenge;
})(AJS.$);
/*[{!highlight_lozenge_js_7miq52u!}]*/;
/* END /2static/script/fe/commitgraph/drawing/highlights/highlight-lozenge.js */
/* START /2static/script/fe/commitgraph/drawing/highlights/relation-highlighter.js */
FE.VIS.getRelationHighlighter = function () {
    var selectedObj = null;

    function highlightObject(obj, defaultAttributes) {
        if (selectedObj) {
            if (obj === selectedObj) {
                obj.attr(defaultAttributes.BranchSelected);
            } else if (obj.isRelatedTo(selectedObj)) {
                obj.attr(defaultAttributes.BranchEmphasized);
            } else {
                obj.attr(defaultAttributes.Dimmed);
            }
        } else {
            obj.attr(defaultAttributes.BranchNormal);
        }
    }

    return {
        name: "Lineage",
        highlightChangeset: highlightObject,
        highlightEdge: highlightObject,
        onFocusChanged: function (focusedObject) {
            selectedObj = focusedObject;
        }
    }
};
/*[{!relation_highlighter_js_ih8552z!}]*/;
/* END /2static/script/fe/commitgraph/drawing/highlights/relation-highlighter.js */
/* START /2static/script/fe/commitgraph/drawing/highlights/jira-highlighter.js */
FE.VIS.getJiraHighlighter = (function ($) {

    /* Imports */
    var Map = FECRU.DATA_STRUCTURES.Map;


    function findIssuesForChangeset(cs, cache) {
        // we cant looking for issues without changeset comment
        if (typeof cs._model.comment === 'undefined') {
            return;
        }
        var $jiraIssues = $('<div>' + cs._model.comment + '</div>').find('.jira-hover-trigger > a');
        var issues = [];
        Array.each($jiraIssues, function (span) {
            var $span = $(span);
            issues.push($span.text());
        });
        cache.set(cs.csid, issues);
    }

    function findRelatedIssuesForChangeset(cs, focusedCsid, issuesById, cache) {
        var csid = cs.csid;
        var focusedIssues = issuesById.get(focusedCsid);
        var issues = issuesById.get(csid);
        var related = [];
        if (typeof issues !== 'undefined') {
            Array.each(issues, function (issueKey) {
                if ($.inArray(issueKey, focusedIssues) !== -1) {
                    related.push(issueKey);
                }
            });
        }
        cache.set(csid, related);
    }

    return function () {
        var issuesById = new Map();
        var relatedIssuesById = null;
        var focusedCsid = null;

        return {
            name: "JIRA issues",
            highlightChangeset: function (cs, defaults) {
                var csid = cs.csid;
                // Ensure caches
                if (!issuesById.has(csid)) {
                    findIssuesForChangeset(cs, issuesById);
                }
                if (focusedCsid !== null && !relatedIssuesById.has(csid)) {
                    findRelatedIssuesForChangeset(cs, focusedCsid, issuesById, relatedIssuesById);
                }

                // Highlighting
                if (focusedCsid === csid) {
                    cs.attr(defaults.Selected);
                } else if (focusedCsid !== null && relatedIssuesById.get(csid).length > 0) {
                    cs.attr(defaults.Emphasized);
                } else if (issuesById.has(csid) && issuesById.get(csid).length > 0) {
                    cs.attr(defaults.Normal)
                        .attr("metadataCssClass", "has-jira-issue");
                } else {
                    cs.attr(defaults.Dimmed);
                }
            },
            onFocusChanged: function (highlightable) {
                if (highlightable && highlightable.isChangeset()) {
                    focusedCsid = highlightable.csid;
                    relatedIssuesById = new Map();
                    if (!issuesById.has(focusedCsid)) {
                        findIssuesForChangeset(highlightable, issuesById);
                    }
                } else {
                    focusedCsid = null;
                    relatedIssuesById = null;
                }
            },
            getChangesetAnnotation: function (cs, createAnnotationList) {
                var csid = cs.csid;
                // Ensure caches
                if (!issuesById.has(csid)) {
                    findIssuesForChangeset(cs, issuesById);
                }
                return createAnnotationList(issuesById.get(csid), {
                    sort: true,
                    getTruncationMessage: function (hiddenCount) {
                        return hiddenCount + " other issues";
                    }
                });
            }
        };
    };
})(AJS.$);
/*[{!jira_highlighter_js_miy652x!}]*/;
/* END /2static/script/fe/commitgraph/drawing/highlights/jira-highlighter.js */
/* START /2static/script/fe/commitgraph/drawing/highlights/review-highlighter.js */
;
(function ($) {

    var Map = FECRU.DATA_STRUCTURES.Map;

    /*private*/

    var changesetAttrs = $.extend(true, {
        Reviewed: {
            color: '#669900',
            hasBorder: false,
            borderColor: null,
            borderWidth: 0,
            textColor: null,
            backgroundColor: null
        },
        InProgress: {
            color: '#FF9900',
            hasBorder: false,
            borderColor: null,
            borderWidth: 0,
            textColor: null,
            backgroundColor: null
        },
        Unreviewed: {
            color: '#AA0000',
            hasBorder: false,
            borderColor: null,
            borderWidth: 0,
            textColor: null,
            backgroundColor: null
        }
    }, {});

    var attrsForState = {
        "Draft": changesetAttrs.InProgress,
        "Approval": changesetAttrs.InProgress,
        "Review": changesetAttrs.InProgress,
        "Summarize": changesetAttrs.InProgress,
        "Closed": changesetAttrs.Reviewed,
        "Dead": changesetAttrs.Unreviewed,
        "Rejected": changesetAttrs.Unreviewed
    };

    var reviewsForChangesets = new Map();
    var changesetIdsToLoad = [];
    var relatedChangesets = null;
    var focusedCsid = null;
    var jqXHR = null;
    var highlightHelper = null;
    var dataUrl;

    var init = function () {
        reviewsForChangesets = new Map();
        changesetIdsToLoad = [];
        relatedChangesets = null;
    };

    var dispose = function () {
        jqXHR && jqXHR.abort();
        init();
    };

    var loadReviewData = function () {
        highlightHelper.setLoading(true);
        jqXHR = $.ajax({
            url: dataUrl,
            type: "POST",
            dataType: 'json',
            data: {cs: changesetIdsToLoad},
            success: function (data) {
                jqXHR = null;
                changesetIdsToLoad = [];
                var changesets = data.changesets;
                if (changesets) {
                    Array.each(changesets, function (cs) {
                        if (cs.reviews && cs.reviews.length) {
                            reviewsForChangesets.set(cs.changesetId, cs.reviews);
                        }
                    });
                }
                if (focusedCsid) {
                    relatedChangesets = findChangesetsForReviews(reviewsForChangesets.get(focusedCsid));
                }
                highlightHelper.setLoading(false);
            },
            error: function (req, textStatus, errorThrown) {
                jqXHR = null;
                var resp = eval('(' + req.responseText + ')');
                if (resp.stacktrace) {
                    FECRU.AJAX.appendErrorResponse(resp.stacktrace, false);
                    FECRU.AJAX.showNotificationBox(resp.code + ": " + resp.message);
                }
                highlightHelper.setLoading(false);
            }
        });
    };

    var loadChangesets = function (changesets) {
        Array.each(changesets, function (cs) {
            var id = cs.csid;
            if (!reviewsForChangesets.has(id)) {
                changesetIdsToLoad.push(id);
            }
        });
        loadReviewData();
    };

    var unloadChangesets = function (changesets) {
        Array.each(changesets, function (cs) {
            reviewsForChangesets.remove(cs.csid);
            // todo clear out queue
        });
    };

    function findChangesetsForReviews(reviews) {
        var changesets = [];
        var changesetReviews;

        if (!reviews || !reviews.length) {
            return changesets;
        }

        var reviewKeys = Array.map(reviews, function (review) {
            return review.permaId.id;
        });
        Array.each(reviewsForChangesets.getKeys(), function (csid) {
            changesetReviews = reviewsForChangesets.get(csid);
            // nb this algorithm is slow, O(n*m), but should be closer to linear as there shouldn't be too many reviews
            Array.each(changesetReviews, function (review) {
                var permaId = review.permaId.id;
                if (jQuery.inArray(permaId, reviewKeys) >= 0) {
                    changesets.push(csid);
                    return false;
                }
            });
        });
        return changesets;
    }

    FE.VIS.getReviewHighlighter = function (url) {
        dataUrl = url;

        var reviewedChangesetHighlighter = {
            name: "Reviewed changesets",
            setHelper: function (helper) {
                highlightHelper = helper;
            },
            onDataLoaded: function (changesets) {
                loadChangesets(changesets);
            },
            onDataUnloaded: function (changesets) {
                unloadChangesets(changesets);
            },
            onActivation: function (changesets) {
                init();
                loadChangesets(changesets);
            },
            onDeactivation: function () {
                dispose();
            },
            highlightChangeset: function (cs, defaults) {
                var csid = cs.csid;
                var reviews = reviewsForChangesets.get(csid);
                if (focusedCsid === csid) {
                    cs.attr(defaults.Selected);
                } else if (focusedCsid !== null && relatedChangesets && $.inArray(csid, relatedChangesets) >= 0) {
                    cs.attr(defaults.Emphasized);
                } else if (reviews && reviews.length) {

                    var attr = changesetAttrs.Unreviewed;
                    Array.each(reviews, function (review) {
                        var revAttr = attrsForState[review.state];
                        if (revAttr === changesetAttrs.Reviewed) {
                            attr = revAttr;
                            return false;
                        }
                        if (revAttr !== changesetAttrs.Unreviewed) {
                            attr = revAttr;
                        }
                    });
                    cs.attr(attr);
                } else {
                    cs.attr(changesetAttrs.Unreviewed);
                }

                if (reviews && reviews.length) {
                    cs.attr("metadataCssClass", "has-review");
                }
            },
            onFocusChanged: function (highlightable) {
                if (highlightable && highlightable.isChangeset()) {
                    focusedCsid = highlightable.csid;
                    relatedChangesets = findChangesetsForReviews(reviewsForChangesets.get(focusedCsid));
                } else {
                    focusedCsid = null;
                    relatedChangesets = null;
                }
            },
            getChangesetAnnotation: function (cs, createAnnotationList) {
                var reviews = reviewsForChangesets.get(cs.csid);
                return createAnnotationList(reviews, {
                    sort: true,
                    getTruncationMessage: function (hiddenCount) {
                        return hiddenCount + " other reviews";
                    },
                    getItemHtml: function (review) {
                        var reviewKey = review.permaId.id;
                        var state = review.state;
                        var href = CRU.UTIL.urlBase(reviewKey);
                        var $stateElem = $("<span></span>");

                        $stateElem.text(" \u2013 " + state);

                        return $("<span>")
                            .append(
                            $("<a></a>")
                                .attr("href", href)
                                .text(reviewKey)
                        )
                            .append($stateElem);
                    }
                });
            },
            getLozenges: function (cs, createLozenge) {
                var reviews = reviewsForChangesets.get(cs.csid);
                if (!reviews || reviews.length === 0) {
                    return null;
                }
                var reviewKeys = Array.map(reviews, function (review) {
                    return review.permaId.id;
                });
                return createLozenge(reviewKeys, {
                    collapsedLozengeText: function (itemCount) {
                        return itemCount + " reviews";
                    },
                    getItemText: function (reviewKey) {
                        var href = CRU.UTIL.urlBase(reviewKey);
                        return $("<a></a>")
                            .attr("href", href)
                            .text(reviewKey)
                    },
                    sort: true,
                    lozengeClass: "review-lozenge"
                });
            }
        };

        return reviewedChangesetHighlighter;
    };
})(AJS.$);
/*[{!review_highlighter_js_5fcb530!}]*/;
/* END /2static/script/fe/commitgraph/drawing/highlights/review-highlighter.js */
/* START /2static/script/fe/commitgraph/drawing/renderer.js */
/**
 * Implements View objects for Changesets, Edges, Groups, Slices, and the Graph, and builds up a hierarchy of the
 * views. When you call the draw method on the presenter, it updates these views and redraws them.
 *
 *  - DefaultPresenter (ctor; takes in a target to draw to, and has:
 *       .draw(view)
 *       .translate(vector)
 *       .createGraphView(ChangesetDAG) returns a view.
 *
 * The purpose of splitting this out is to
 * 1. simplify the model files a bit more.
 * 2. allow someone to implement a new kind of view (e.g., HTML Tables like Sharkie thought up) that wouldn't even use
 *    x and y positions like SVG and VML do. They can implement their own GraphView and use that instead
 *    of this.
 */

FE.VIS.DRAWING = (function ($, templateFactory) {

    /* Imports */
    var Point = Shapes.Point;
    var Vector = Shapes.Vector;
    var Rectangle = Shapes.Rectangle;
    var VIS = FE.VIS;
    var Configuration = VIS.Configuration;
    var CHANGESET_SPACING = Configuration.CHANGESET_SPACING;
    var CHANGESET_RADIUS = Configuration.CHANGESET_RADIUS;
    var BRANCH_SPACING = Configuration.BRANCH_SPACING;
    var METADATA_PADDING_LEFT = Configuration.METADATA_PADDING_LEFT;
    var EDGE_HOVER_WIDTH = Configuration.EDGE_HOVER_WIDTH;
    var NODE_HOVER_RADIUS = Configuration.NODE_HOVER_RADIUS;
    var EventProducer = FECRU.MIXINS.EventProducer;
    var HIGHLIGHTS = VIS.HIGHLIGHTS;
    var HighlightContext = HIGHLIGHTS.HighlightContext;
    var COLOR_BY_BRANCH = HIGHLIGHTS.COLOR_BY_BRANCH;
    var HighlightPopup = VIS.HIGHLIGHT_POPUP;
    var HighlightLozenge = VIS.HIGHLIGHT_LOZENGE;
    var fallbackBranchColor = FE.VIS.fallbackBranchColor;
    var Map = FECRU.DATA_STRUCTURES.Map;
    var pad = FECRU.pad;

    var createBackgroundColor = (function (isIE, opacity) {
        var cache = new Map();
        var threeHexPattern = /#[a-fA-F0-9]{3}/;
        var sixHexPattern = /#[a-fA-F0-9]{6}/;
        var rgbPattern = /rgb[^\(]*\([^\d]*(\d{1,3}),[^\d]*(\d{1,3}),[^\d]*(\d{1,3})[^\)]*\)/;
        var opacityString;
        var stylePrefix;
        var createColor;
        var minValue = (1 - opacity) * 255;

        function padLeft(str) {
            return pad(str, 2, false, "0");
        }

        function translateToRGB(color) {
            var match;
            var ret = null;

            if (!color) {
                ret = null;
            } else if (match = color.match(sixHexPattern)) {
                ret = [
                    parseInt(color.substring(1, 3), 16),
                    parseInt(color.substring(3, 5), 16),
                    parseInt(color.substring(5, 7), 16)
                ];
            } else if (match = color.match(threeHexPattern)) {
                ret = [
                    parseInt(color[1] + color[1], 16),
                    parseInt(color[2] + color[2], 16),
                    parseInt(color[3] + color[3], 16)
                ];
            } else if (match = color.match(rgbPattern)) {
                ret = match.slice(1);
            }
            return ret;
        }

        if (!!isIE) {
            opacityString = (Math.floor(opacity * 255)).toString(16);
            stylePrefix = "progid:DXImageTransform.Microsoft.gradient";
            createColor = function (color) {
                if (!color) {
                    return {filter: color};
                }
                if (!cache.has(color)) {
                    var rgb = translateToRGB(color);
                    var newColor = "#"
                        + opacityString
                        + padLeft(rgb[0].toString(16))
                        + padLeft(rgb[1].toString(16))
                        + padLeft(rgb[2].toString(16));
                    var style = stylePrefix + "(startColorStr=" + newColor + ", endColorStr=" + newColor + ")";

                    cache.set(color, style);
                }
                return {filter: cache.get(color)};
            };
        } else {
            opacityString = opacity.toString();
            stylePrefix = "rgba";
            createColor = function (color) {
                if (!color) {
                    return {backgroundColor: color};
                }
                if (!cache.has(color)) {
                    var rgb = translateToRGB(color);
                    var newColor = rgb[0] + ", "
                        + rgb[1] + ", "
                        + rgb[2] + ", "
                        + opacityString;
                    var style = stylePrefix + "(" + newColor + ")";

                    cache.set(color, style);
                }
                return {backgroundColor: cache.get(color)};
            };
        }
        return createColor;
    })($.browser.msie && $.browser.version < 9, 0.1);

    var EdgeProximityEvent = "EdgeProximityEvent";

    function abstractFunction() {
        throw "Cannot call abstract method";
    }

    function removeDisposedViews(views) {
        var newViews = [];
        views && Array.each(views, function (view) {
            if (!view.model.disposed) {
                newViews.push(view);
            }
        });
        return newViews;
    }

    function addNewViews(thisView, currentViews, newModels, viewFactory) {
        newModels && Array.each(newModels, function (model) {
            var viewAlreadyCreated = Array.any(currentViews, function (view) {
                return view.model === model;
            });
            if (!viewAlreadyCreated) {
                currentViews.push(viewFactory(model, thisView));
            }
        });
    }

    function createContext(horizontal, flippedTimewise, spacing, changesetRadius) {
        var pathNubX = spacing / 2;
        var pathNubY = spacing / 2;

        var context = {
            getSpacing: function () {
                return spacing;
            },
            getChangesetRadius: function () {
                return changesetRadius;
            },
            setHighlightContext: function (highlightContext) {
                this.highlightContext = highlightContext;
            },
            highlightContext: new HighlightContext(null)
        };

        /**
         These functions allow us to encapsulate the direction of the drawn graph.
         They map (time, branch) coordinates to (x, y) coordinates depending on whether you are displaying the graph
         vertically or horizontally.

         The "flipped time" transformation we do throughout this file should be fairly simple:
             (time, breadth) => (-time, breadth)
            It's complicated by the fact that we use svg:g elements with their own coordinate systems. To avoid putting
            a negative width/height on these groups, we have to switch the "first" and "last" points.
            We flip the sign on Slice positions and then subtract their time-width.  This means a Rectangle:
                top-left: (20, 0);
                bottom-right: (45, 50);
                width: 25;
                height: 50;
            becomes:
                top-left: (-(20) - 25, 0);
                bottom-right: (-25, 50);
                width: 25;
                height: 50;
              AKA:
                top-left: (-45, 0);                 <= we must switch the left and right
                bottom-right: (-25, 50);            <= sides so we don't have negative width.
                width: 25;
                height: 50;
        */
        context.createPoint = horizontal ?
            function (timewise, branchwise) {
                return new Point(timewise, branchwise);
            } :
            function (timewise, branchwise) {
                return new Point(branchwise, timewise);
            };
        context.createVector = horizontal ?
            function (timewise, branchwise) {
                return new Vector(timewise, branchwise);
            } :
            function (timewise, branchwise) {
                return new Vector(branchwise, timewise);
            };
        context.createRectangle = horizontal ?
            function (timewiseStart, breadthwiseStart, length, breadth) {
                return new Rectangle(timewiseStart, breadthwiseStart, length, breadth);
            } :
            function (timewiseStart, breadthwiseStart, length, breadth) {
                return new Rectangle(breadthwiseStart, timewiseStart, breadth, length);
            };
        context.getChangesetTimewise = flippedTimewise ?
            function (timePosition, parentLength) {
                return (parentLength - timePosition - 1);
            } :
            function (timePosition, parentLength) {
                return timePosition;
            };
        context.getSliceTimewise = flippedTimewise ?
            function (timePosition, length) {
                return ( -timePosition - length);
            } :
            function (timePosition) {
                return timePosition;
            };
        context.getGraphTimewise = context.getSliceTimewise;
        context.getGraphTimePosition = flippedTimewise ?
            function (dag) {
                var slices = dag.dagSlices;
                var slicesLength = slices.length;
                var length = dag.getLength();

                if (slicesLength) {
                    return slices[slicesLength - 1].timePosition + slices[slicesLength - 1].length - length;
                } else {
                    return 0;
                }
            } :
            function (dag) {
                var slices = dag.dagSlices;
                return slices.length ? slices[0].timePosition : 0
            };
        context.createGraphSpaceRectangle = flippedTimewise ?
            function (x, y, width, height) {
                var rect = context.createRectangle(x, y, width, height);
                rect.x = -rect.x - rect.width;
                return rect;
            } :
            function (x, y, width, height) {
                return context.createRectangle(x, y, width, height);
            };

        context.translateBy = horizontal ?
            function (translation, vector) {
                translation.x += vector.x;
            } :
            function (translation, vector) {
                translation.y += vector.y;
            };

        context.translateTo = horizontal ?
            function (translation, position) {
                translation.x = -position.x + (spacing / 2);
            } :
            function (translation, position) {
                translation.y = -position.y + (spacing / 2);
            };

        /**
         * Given one of the changeset's containers (the group, slice, or dag),
         * this function will convert the changeset's local coordinates into that container's
         * coordinate system.
         * If a changeset is Sparse, then its local coordinates are unknown and assumed infinitely far.  In that case,
         * this function will position it at the further of the appropriate edge of the container or the viewport.
         */
        context.getPositionInContainerCoordinates = function (changeset, branchRevision, containerView, viewport) {
            var position;
            var timewise;
            var breadthwise;
            var containerModel = containerView.model;

            if (changeset.isLive()) {
                var group = branchRevision.group;
                var slice = group.slice;


                timewise = context.getChangesetTimewise(changeset.timePosition, slice.getLength());
                breadthwise = branchRevision.branchPosition;
                if (containerModel !== group) {
                    breadthwise += group.branch.branchPosition;

                    if (containerModel !== slice) {
                        timewise += context.getSliceTimewise(slice.timePosition, slice.length);
                    }
                }
                position = context.createPoint(
                    timewise * spacing,
                    breadthwise * spacing
                );
            } else if (changeset.isSparse()) {
                var branch = branchRevision ? branchRevision.primaryBranch : null;

                // time positions should be Infinity or NaN, so translation/scale is moot. Only the sign matters.
                timewise = (flippedTimewise ? -1 : 1) * (changeset.timePosition);

                // branch positions, on the other hand, are only Infinity for sparseOnBranch.
                breadthwise = (branchRevision ? branchRevision.branchPosition : Infinity) + (branch ? branch.branchPosition : 0);

                position = context.createPoint(
                    timewise * spacing,
                    breadthwise * spacing
                );
                var graphBounds = containerView.boundingBox;

                if (position.x === -Infinity) {
                    position.x = Math.min(graphBounds.x, viewport.x);
                } else if (position.x === Infinity) {
                    var lastGraphX = graphBounds.x + graphBounds.width;
                    var lastViewportX = viewport.x + viewport.width;

                    position.x = Math.max(lastGraphX, lastViewportX);
                }
                if (position.y === -Infinity) {
                    position.y = Math.min(graphBounds.y, viewport.y);
                } else if (position.y === Infinity) {
                    var lastGraphY = graphBounds.y + graphBounds.height;
                    var lastViewportY = viewport.y + viewport.height;

                    position.y = Math.max(lastGraphY, lastViewportY);
                }
            }
            return position;
        };

        /**
         * An edge can be at one of a few levels, so it must calculate the parent/child changeset positions in a common
         * coordinate space.
         * It also must calculate a few midpoints between the changesets for a prettier line.
         */
        /*eslint-disable complexity*/
        context.calculateEdgePositions = function (parentChangeset, parentBranchRevision, childChangeset, childBranchRevision, commonContainerView) {
            var parentPosition = context.getPositionInContainerCoordinates(parentChangeset, parentBranchRevision, commonContainerView, commonContainerView.viewport);
            var childPosition = context.getPositionInContainerCoordinates(childChangeset, childBranchRevision, commonContainerView, commonContainerView.viewport);

            //if one of these is SparseOnBranch, we draw it directly inline with the Live one.
            if (isNaN(parentPosition.x)) {
                parentPosition.x = childPosition.x;
            } else if (isNaN(childPosition.x)) {
                childPosition.x = parentPosition.x;
            } else if (isNaN(parentPosition.y)) {
                parentPosition.y = childPosition.y;
            } else if (isNaN(childPosition.y)) {
                childPosition.y = parentPosition.y;
            } else {
                var heightDifference = parentPosition.y - childPosition.y;
                var widthDifference = parentPosition.x - childPosition.x;
                var parentAbove = heightDifference > 0;
                var parentBefore = widthDifference < 0;
                var notInLine = heightDifference !== 0 && widthDifference !== 0;
                var spacing = context.getSpacing();
                var absHeightDiff = Math.abs(heightDifference);
                var absWidthDiff = Math.abs(widthDifference);
                var notDiagonallyOneAway = !(absHeightDiff === absWidthDiff && absHeightDiff === spacing);
                var requiresCenter = !(absHeightDiff === spacing || absWidthDiff === spacing);

                var curveX = pathNubX / 2;
                var curveY = pathNubY / 2;

                if (notInLine) {//} && notDiagonallyOneAway) {
                    var parentCurveEnd = new Point(
                        parentPosition.x + (parentBefore ? pathNubX : -pathNubX ),
                        parentPosition.y + (parentAbove ? -pathNubY : pathNubY )
                    );
                    var childCurveEnd = new Point(
                        childPosition.x + (parentBefore ? -pathNubX : pathNubX),
                        childPosition.y + (parentAbove ? pathNubY : -pathNubY )
                    );

                    var center;
                    if (requiresCenter) {
                        center = new Point(parentCurveEnd.x, childCurveEnd.y);
                    }

                    // HACK: sharp edges - we should make edges curvy in IE8 also eventually.
                    if ($.browser.msie && $.browser.version < 9) {
                        if (requiresCenter) {
                            return [parentPosition, parentCurveEnd, center, childCurveEnd, childPosition];
                        } else {
                            return [parentPosition, parentCurveEnd, childCurveEnd, childPosition];
                        }
                    }

                    var parentCurveMiddle;
                    var childCurveMiddle;

                    if (absWidthDiff === spacing && notDiagonallyOneAway) {
                        childCurveMiddle = new Point(childCurveEnd.x, childPosition.y);
                    } else {
                        childCurveMiddle = new Point(childPosition.x, childCurveEnd.y);
                    }

                    if (absHeightDiff === spacing) {
                        parentCurveMiddle = new Point(parentPosition.x, parentCurveEnd.y);
                    } else {
                        parentCurveMiddle = new Point(parentCurveEnd.x, parentPosition.y);
                    }

                    if (requiresCenter) {
                        var centerCurveStart = new Point(
                            center.x,
                            center.y + (parentAbove ? curveY : -curveY)
                        );
                        var centerCurveEnd = new Point(
                            center.x + (parentBefore ? curveX : -curveX),
                            center.y
                        );
                        return [parentPosition, parentCurveMiddle, parentCurveEnd,
                            centerCurveStart, center, centerCurveEnd,
                            childCurveEnd, childCurveMiddle, childPosition];
                    } else {
                        return [parentPosition, parentCurveMiddle, parentCurveEnd,
                            childCurveEnd, childCurveMiddle, childPosition];
                    }
                }
            }

            return [parentPosition, childPosition];
        };
        /*eslint-enable*/

        return context;
    }

    /**
     * A Generic view that allows subViews and a model. Mixin or extend this class. never create a new view
     */
    var View = (function () {
        var View = function () {
            this.model = undefined;
            this.parentView = undefined;
            this.subViews = undefined;

            this._isSyncedWithModel = false;
            this._isVisible = false;
            this._requiresHighlight = true;

            throw new Error("View is abstract and should not be instantiated.");
        };

        /**
         * Updates only the currently existing DOM elements to reflect any changes we've made.
         */
        View.prototype.reDraw = function () {
            if (this.isVisible()) {
                this.drawSelf();
                this.subViews && Array.each(this.subViews, function (subView) {
                    subView.reDraw();
                });
            }
        };

        /**
         * Similar to draw but doesn't draw the subviews as well
         */
        View.prototype.drawSelf = abstractFunction;

        /**
         * Updates positioning calculations ready for this view to be redrawn and its subViews. Usually called before draw()
         */
        View.prototype.sync = function (forceFullRefresh) {
            if (forceFullRefresh || this.requiresSync()) {
                this.syncSelf();
                this.setSyncRequired(false);
            }

            this.subViews && Array.each(this.subViews, function (subView) {
                subView.sync(forceFullRefresh);
            });

            return this;
        };

        /**
         * Similar to sync but ignores subViews
         */
        View.prototype.syncSelf = abstractFunction;

        /**
         * Updates visibility to reflect changes in viewport. Usually called before draw()
         */
        View.prototype.updateVisibility = function () {
            this.updateVisibilitySelf(); // recursion is handled in setVisible

            this.subViews && Array.each(this.subViews, function (subView) {
                subView.updateVisibility();
            });

            return this;
        };

        /**
         * Similar to updateVisibility but ignores subViews
         */
        View.prototype.updateVisibilitySelf = function () {
            this.setVisible(this.parentView.isVisible());
            return this;
        };

        /**
         * Permanently remove this view.  The view is unusuable after this method is called.
         */
        View.prototype.destroy = function () {
            this.eraseSelf();

            this.subViews && Array.each(this.subViews, function (view) {
                view.destroy();
            });
        };

        /**
         * If visible, updates appearance data to reflect changes in highlighting and redraws.
         */
        View.prototype.reHighlight = function () {
            if (this.isVisible()) {
                this.highlightSelf();
                this.drawSelf();
            } else {
                this.setHighlightRequired(true);
            }
            this.subViews && Array.each(this.subViews, function (view) {
                view.reHighlight();
            });

            return this;
        };

        /**
         * Similar to highlight but ignores subViews
         */
        View.prototype.highlightSelf = abstractFunction;

        /**
         * Similar to erase() but ignores subViews
         */
        View.prototype.eraseSelf = abstractFunction;

        /**
         * Removes any subViews from the subView array whos model has been disposed
         */
        View.prototype.removeDisposedSubViews = function () {
            var views = this.subViews;
            var newViews = [];

            views && Array.each(views, function (view) {
                if (!view.model.disposed) {
                    newViews.push(view);
                }
            });
            this.subViews = newViews;
        };

        /**
         * Recursively find a subView associated
         * @param model
         */
        View.prototype.findViewByModel = function (model) {
            var foundView = null;
            this.forEachView(function (view) {
                if (view.model === model) {
                    foundView = view;
                    return View.END_ALL;
                }
            });
            return foundView;
        };


        View.END_PATH = {};
        View.END_ALL = false;
        /**
         * Call a function on each view in this view tree.
         * If the function returns false, stop traversing.
         * @param func function that will be called with each view as the first parameter. If
         * your function returns View.END_PATH on a node, then forEachView will not traverse that node's subtree.
         * If your function returns View.END_ALL at any point, forEachView will stop traversal of the entire View tree.
         */
        View.prototype.forEachView = function (func) {
            var result = func(this);
            if (result === View.END_ALL) {
                return false;
            }
            if (result !== View.END_PATH && this.subViews) {
                var lastResult;
                Array.each(this.subViews, function (subView) {
                    return lastResult = subView.forEachView(func);
                });
                return lastResult;
            }
        };

        View.prototype.isVisible = function () {
            return this._isVisible;
        };

        View.prototype.setVisible = function (isVisible) {
            if (!this._isVisible && isVisible) {
                this._isVisible = true;
                if (this.requiresHighlight()) {
                    this.highlightSelf();
                }
                this.drawSelf();
            } else if (this._isVisible && !isVisible) {
                this._isVisible = false;
                this.eraseSelf(!this.parentView || !this.parentView.element);
            }
        };


        View.prototype.requiresHighlight = function () {
            return this._requiresHighlight;
        };

        View.prototype.setHighlightRequired = function (requiresHighlight) {
            this._requiresHighlight = requiresHighlight;
        };


        View.prototype.requiresSync = function () {
            return !this._isSyncedWithModel;
        };

        View.prototype.setSyncRequired = function (requiresSync) {
            this._isSyncedWithModel = !requiresSync;
        };

        return View;
    })();

    var TopLevelView = (function () {
        var TopLevelView = function () {
            this.model = undefined;
            this.context = undefined;
            throw new Error("TopLevelView is abstract and should not be instantiated");
        };
        $.extend(TopLevelView.prototype, View.prototype, EventProducer);


        TopLevelView.prototype.setHighlightContext = function (highlightContext) {
            if (this.parentView) {
                this.parentView.setHighlightContext(highlightContext);
                return;
            }

            this.context.setHighlightContext(highlightContext);
            this.reHighlight();
        };

        TopLevelView.prototype.setFocus = function (highlightable) {
            if (this.parentView) {
                this.parentView.setFocus(highlightable);
                return;
            }

            var highlightContext = this.context.highlightContext;
            if (highlightContext.focusedObject === highlightable) {
                // Blur
                highlightable = null;
            }
            highlightContext.onFocusChanged(highlightable);
            this.reHighlight();
        };

        TopLevelView.prototype.translate = abstractFunction;

        TopLevelView.prototype.translateTo = abstractFunction;

        TopLevelView.prototype.resize = abstractFunction;

        TopLevelView.prototype.getScrolledToTimePosition = abstractFunction;

        return TopLevelView;
    })();

    var SliceView = (function () {
        var SliceView = function () {
            this.model = undefined;
            this.context = undefined;
            throw new Error("SliceView is abstract and should not be instantiated.");
        };
        $.extend(SliceView.prototype, View.prototype);

        SliceView.prototype.syncSelf = function () {
            var model = this.model;
            var length = model.getLength();
            var breadth = model.getBreadth();
            var context = this.context;
            var spacing = context.getSpacing();

            var boundingBox = this.boundingBox = context.createRectangle(
                spacing * context.getSliceTimewise(model.timePosition, length),
                0,
                spacing * length,
                spacing * breadth
            );
            this.boundingBoxInGraphSpace = new Rectangle(
                model.timePosition,
                0,
                length,
                breadth
            );

            this.translation = new Vector(boundingBox.x, boundingBox.y);

            this.attributes = {
                scale: 1,
                width: boundingBox.width,
                height: boundingBox.height
            };

            this.removeDisposedSubViews();
            this.addNewSubViews();

            return this;
        };

        return SliceView;
    })();

    var GraphEdgeView = (function () {
        var GraphEdgeView = function (edge, parentView) {
            this.model = edge;
            this.parentView = parentView;
            this.target = parentView.target;
            this.context = parentView.context;

            this._requiresHighlight = true;
            this.highlightable = undefined;
        };
        $.extend(GraphEdgeView.prototype, View.prototype);
        GraphEdgeView.create = function (edge, parentView) {
            var view = new GraphEdgeView(edge, parentView);

            view.syncSelf();
            view.updateVisibilitySelf();
            view.resetHighlights();

            return view;
        };

        GraphEdgeView.prototype.sync = function (forceFullRefresh) {
            if (forceFullRefresh || this.requiresSync()) {
                var wasSparse = this.model.hasSparseEndpoint();
                this.syncSelf();
                //if it was sparse,
                if (wasSparse) {
                    this.updateVisibilitySelf();
                    this.drawSelf();
                }
                !this.model.hasSparseEndpoint() && this.setSyncRequired(false); // only set it clean once it's not sparse.
            }

            return this;
        };

        GraphEdgeView.prototype.syncSelf = function () {
            var edge = this.model;
            this.points = this.context.calculateEdgePositions(edge.parentChangeset, edge.parentBranchRevision, edge.childChangeset, edge.childBranchRevision, this.parentView);
        };

        GraphEdgeView.prototype.setVisible = function (isVisible) {
            // HACK : Sparse edges are always visible, and redraw every time.
            if (this.parentView instanceof GraphView || (!this._isVisible && isVisible)) {
                this._isVisible = true;
                if (this.requiresHighlight()) {
                    this.highlightSelf();
                }
                this.drawSelf();
            } else if (this._isVisible && !isVisible) {
                this._isVisible = false;
                this.eraseSelf();
            }
        };

        GraphEdgeView.prototype.updateVisibilitySelf = function () {
            // TODO : do edge visibility calculations in slices for better perf.
            // set sparse edges visible always. Yes, it's a hack.
            this.setVisible(this.parentView instanceof GraphView || this.parentView.isVisible());
        };

        GraphEdgeView.prototype.resetHighlights = function () {
            var context = this.highlightContext = this.context.highlightContext;
            var highlightable = this.highlightable = context.getEdge(this.model);
        };

        GraphEdgeView.prototype.highlightSelf = function () {
            if (this.highlightContext !== this.context.highlightContext) {
                this.resetHighlights();
            }

            var highlightable = this.highlightable;

            this.highlightContext.highlightEdge(highlightable);

            var color = highlightable.color();
            var parent;

            if (color === COLOR_BY_BRANCH) {
                parent = this.model.parentBranchRevision;
                if (parent) {
                    color = parent.primaryBranch ? parent.primaryBranch.color : fallbackBranchColor;
                }
            }

            this.attributes = {
                strokeWidth: 1,
                strokeColor: color
            };

            if (highlightable.hasBorder()) {
                var borderColor = highlightable.borderColor();
                if (borderColor === COLOR_BY_BRANCH) {
                    parent = this.model.parentBranchRevision;
                    if (parent) {
                        color = parent.primaryBranch ? parent.primaryBranch.color : fallbackBranchColor;
                    }
                }

                this.glowAttributes = {
                    strokeWidth: highlightable.borderWidth() * 2 + 1, //width of 2 borders + actual path width
                    strokeColor: borderColor
                };
            } else {
                this.glowAttributes = null;
            }

            return this;
        };

        GraphEdgeView.prototype.eraseSelf = function () {
            if (this.element) {
                this.target.erase(this.element);
                this.element = null;
            }
            return this;
        };

        GraphEdgeView.prototype.drawSelf = function () {
            var target = this.target;

            if (this.element) {
                this.target.movePath(this.element, this.points);
                target.setPathAttributes(this.element, this.attributes);
            } else {
                this.attributes.moveToBack = true;
                this.element = target.drawPath(this.parentView.element, this.points, this.attributes);
                $(this.element.element).data('model', this.model);
            }

            /*
             There's no good way to put an aura/glow around a path. "stroke" is already being used to draw the edge,
             and "fill" will do weird things (try to fill the shape defined by the path). So we need a second element
             to represent the outer color.
             */
            if (this.glowAttributes) {
                if (this.glowElement) {
                    target.movePath(this.glowElement, this.points);
                    target.setPathAttributes(this.glowElement, this.glowAttributes);
                } else {
                    this.glowAttributes.insertBeforeElement = this.element;
                    this.glowElement = target.drawPath(this.parentView.element, this.points, this.glowAttributes);
                }
            } else if (this.glowElement) {
                target.erase(this.glowElement);
                this.glowElement = null;
            }
        };

        return GraphEdgeView;
    })();

    var GraphBranchRevisionView = (function () {
        var GraphBranchRevisionView = function (changeset, groupView) {
            this.model = changeset;
            this.parentView = groupView;
            this.target = groupView.target;
            this.context = groupView.context;

            this._requiresHighlight = true;
            this.highlightable = undefined;
        };
        $.extend(GraphBranchRevisionView.prototype, View.prototype);

        GraphBranchRevisionView.create = function (changeset, groupView) {
            var view = new GraphBranchRevisionView(changeset, groupView);

            view.syncSelf();
            view.updateVisibilitySelf();
            view.resetHighlights();

            return view;
        };

        GraphBranchRevisionView.prototype.highlightSelf = function () {
            if (this.highlightContext !== this.context.highlightContext) {
                this.resetHighlights();
            }

            var highlightable = this.highlightable;

            this.highlightContext.highlightChangeset(highlightable);

            var strokeWidth;
            var strokeColor;
            var fillColor;

            fillColor = highlightable.color();

            if (fillColor === COLOR_BY_BRANCH) {
                fillColor = this.model.primaryBranch ? this.model.primaryBranch.color : fallbackBranchColor;
            }

            if (highlightable.hasBorder()) {
                strokeWidth = highlightable.borderWidth();
                strokeColor = highlightable.borderColor();

                if (strokeColor === COLOR_BY_BRANCH) {
                    strokeColor = this.model.primaryBranch ? this.model.primaryBranch.color : fallbackBranchColor;
                }
            } else {
                strokeWidth = 1;
                strokeColor = fillColor;
            }

            this.attributes = {
                // stroke is centered on the edge, so we need to shift it outward by half its width.
                // this ensures the visible "fill" area is a constant size, unaffected by strokeWidth.
                radius: this.context.getChangesetRadius() + (strokeWidth / 2),
                strokeWidth: strokeWidth,
                strokeColor: strokeColor,
                fillColor: fillColor
            };

            return this;
        };

        GraphBranchRevisionView.prototype.syncSelf = function () {
            var branchRevision = this.model;
            var changeset = branchRevision.changeset;
            var context = this.context;
            var spacing = context.getSpacing();

            this.position = context.createPoint(
                context.getChangesetTimewise(changeset.timePosition, changeset.slice.length) * spacing,
                branchRevision.branchPosition * spacing
            );

            return this;
        };

        GraphBranchRevisionView.prototype.drawSelf = function () {
            var target = this.target;

            if (this.element) {
                target.movePoint(this.element, this.position);
                target.setPointAttributes(this.element, this.attributes);
            } else {
                this.element = target.drawPoint(this.parentView.element, this.position, this.attributes);
                $(this.element.element).data('model', this.model.changeset);
            }
            return this;
        };

        GraphBranchRevisionView.prototype.eraseSelf = function () {
            if (this.element) {
                this.target.erase(this.element);
                this.element = null;
            }
            return this;
        };

        GraphBranchRevisionView.prototype.resetHighlights = function () {
            var context = this.highlightContext = this.context.highlightContext;
            this.highlightable = context.getChangeset(this.model.changeset);
        };

        return GraphBranchRevisionView;
    })();

    var GraphGroupView = (function () {
        var GraphGroupView = function (group, sliceView) {
            this.model = group;
            this.parentView = sliceView;
            this.target = sliceView.target;
            this.context = sliceView.context;
        };
        $.extend(GraphGroupView.prototype, View.prototype);
        GraphGroupView.create = function (group, sliceView) {
            var view = new GraphGroupView(group, sliceView);

            view.syncSelf();
            view.updateVisibilitySelf();

            return view;
        };

        GraphGroupView.prototype.highlightSelf = function () {
            // Do Nothing
            return this;
        };

        GraphGroupView.prototype.syncSelf = function () {
            var branch = this.model.branch;
            var slice = this.parentView.model;
            var context = this.context;
            var spacing = context.getSpacing();

            var boundingBox = this.boundingBox = this.context.createRectangle(
                0,
                spacing * branch.branchPosition,
                spacing * slice.length,
                spacing * branch.breadth
            );

            this.translation = new Vector(boundingBox.x, boundingBox.y);

            this.attributes = {
                scale: 1,
                width: boundingBox.width,
                height: boundingBox.height
            };

            this.removeDisposedSubViews();
            this.addNewSubViews();
        };

        GraphGroupView.prototype.addNewSubViews = function () {
            var model = this.model;
            var subViews = this.subViews;

            addNewViews(this, subViews, model.branchRevisions, GraphBranchRevisionView.create);
            addNewViews(this, subViews, model.internalEdges, GraphEdgeView.create);
        };

        GraphGroupView.prototype.drawSelf = function () {
            if (this.element) {
                this.target.moveGroup(this.element, this.translation);
                this.target.setGroupAttributes(this.element, this.attributes);
            } else {
                this.element = this.target.drawGroup(this.parentView.element, this.translation, this.attributes);
            }

            return this;
        };

        GraphGroupView.prototype.eraseSelf = function () {
            if (this.element) {
                this.target.erase(this.element);
                this.element = null;
            }
            return this;
        };

        return GraphGroupView;
    })();

    var GraphSliceView = (function () {
        var GraphSliceView = function (slice, graphView) {
            this.model = slice;
            this.parentView = graphView;
            this.target = graphView.target;
            this.context = graphView.context;
        };
        $.extend(GraphSliceView.prototype, SliceView.prototype);
        GraphSliceView.create = function (slice, graphView) {
            var view = new GraphSliceView(slice, graphView);

            view.syncSelf();
            view.updateVisibilitySelf();

            return view;
        };

        GraphSliceView.prototype.addNewSubViews = function () {
            var model = this.model;
            var subViews = this.subViews;

            addNewViews(this, subViews, model.changesetGroups, GraphGroupView.create);
            addNewViews(this, subViews, model.interGroupEdges, GraphEdgeView.create);
        };

        GraphSliceView.prototype.updateVisibilitySelf = function () {
            var isVisible = this.parentView.isVisible() &&
                this.boundingBoxInGraphSpace.intersectsRectangle(this.parentView.visibleAreaInGraphSpace);
            this.setVisible(isVisible);

            return this;
        };

        GraphSliceView.prototype.highlightSelf = function () {
            // Do Nothing
            return this;
        };

        GraphSliceView.prototype.drawSelf = function () {
            if (this.element) {
                this.target.moveGroup(this.element, this.translation);
                this.target.setGroupAttributes(this.element, this.attributes);
            } else {
                this.element = this.target.drawGroup(this.parentView.element, this.translation, this.attributes);
            }

            return this;
        };

        GraphSliceView.prototype.eraseSelf = function () {
            if (this.element) {
                this.target.erase(this.element);
                this.element = null;
            }
            return this;
        };

        return GraphSliceView;
    })();

    var GraphBranchView = (function () {
        var GraphBranchView = function (branch, graphView) {
            this.model = branch;
            this.parentView = graphView;
            this.context = graphView.context;

            this.element = $("<div></div>").attr("id", "lane-" + FECRU.zEscape(branch.name));
            $(graphView.target.getContainer()).siblings(".branch-lanes").append(this.element);
        };

        $.extend(GraphBranchView.prototype, View.prototype);

        GraphBranchView.create = function (branch, graphView) {
            var view = new GraphBranchView(branch, graphView);

            view.syncSelf();
            view.updateVisibilitySelf();

            return view;
        };

        GraphBranchView.prototype.highlightSelf = function () {
            // Do Nothing
            return this;
        };

        GraphBranchView.prototype.syncSelf = function () {
            var branch = this.model;
            var $element = this.element;
            var context = this.context;
            var spacing = context.getSpacing();

            var boundingBox = this.boundingBox = context.createRectangle(
                0,
                spacing * branch.branchPosition + (BRANCH_SPACING / 2),
                spacing * context.createVector($element.width(), $element.height()).x,
                spacing * Math.max(branch.breadth, 1) - BRANCH_SPACING
            );

            this.css = {
                left: boundingBox.x,
                top: boundingBox.y,
                width: boundingBox.width,
                height: "100%",
                position: "absolute",
                backgroundColor: "#f0f0f0"
            };

            return this;
        };

        GraphBranchView.prototype.drawSelf = function () {
            if (this.element) {
                this.element.css(this.css)
            }

            return this;
        };

        GraphBranchView.prototype.eraseSelf = function () {
            if (this.element) {
                this.element.remove();
            }
            return this;
        };

        return GraphBranchView;
    })();

    var GraphView = (function () {
        var GraphView = function (dag, target, initialViewport, initialTranslation, context) {
            this.model = dag;
            this.target = target;
            this.context = context;
            this.viewport = initialViewport;

            this.visibilityBuffer = context.getSpacing() * 20;

            this.translation = initialTranslation;
            this.visibleAreaInGraphSpace = undefined;
            this.element = undefined;

            var self = this;
            var $targetElement = $(target.getElement());

            var getChangesetFromPoint = function (point) {
                return $(point).data('model');
            };

            var getEdgeFromPath = function (path) {
                return $(path).data('model');
            };

            $targetElement.delegate('[class~="path"]', 'click', function () {
                var edge = getEdgeFromPath(this);
                var highlightable = edge ? self.context.highlightContext.getEdge(edge) : null;

                highlightable && self.setFocus(highlightable);
            }).delegate('[class~="point"]', 'click', function () {
                var cs = getChangesetFromPoint(this);
                var highlightable = cs ? self.context.highlightContext.getChangeset(cs) : null;

                highlightable && self.setFocus(highlightable);
            });

            if ($.browser.msie && ($.browser.version < 9)) {
                //ie8 handling of hover paths and nodes
                $targetElement.delegate('[class~="path"]', 'mouseenter', function () {
                    $(this).data("strokeweight", this.strokeweight);
                    this.strokeweight = EDGE_HOVER_WIDTH;
                }).delegate('[class~="path"]', 'mouseleave', function () {
                    if (Number(this.strokeweight) === EDGE_HOVER_WIDTH) {
                        this.strokeweight = $(this).data("strokeweight");
                    }
                }).delegate('[class~="point"]', 'mouseenter', function () {
                    var elemStyle = this.style;
                    var radius = parseFloat(elemStyle.width, 10) / 2;
                    var position = {x: parseFloat(elemStyle.left), y: parseFloat(elemStyle.top), radius: radius};
                    var newRadius = radius + (NODE_HOVER_RADIUS);
                    var newDiameter = newRadius * 2;

                    $(this).data('vml-position', position);
                    elemStyle.width = (newDiameter) + "px";
                    elemStyle.height = (newDiameter) + "px";
                    //shift the centre of the circle a bit due to increased radiu, so it stays in the original place
                    elemStyle.left = Math.floor(position.x - NODE_HOVER_RADIUS) + "px";
                    elemStyle.top = Math.floor(position.y - NODE_HOVER_RADIUS) + "px";
                }).delegate('[class~="point"]', 'mouseleave', function () {
                    var elemStyle = this.style;
                    var oldPosition = $(this).data('vml-position');
                    var oldRadius = oldPosition.radius;
                    var oldDiameter = oldRadius * 2;

                    if (Number(parseFloat(elemStyle.width, 10)) === (oldDiameter + (NODE_HOVER_RADIUS * 2))) {
                        elemStyle.width = (oldDiameter) + "px";
                        elemStyle.height = (oldDiameter) + "px";
                        elemStyle.left = Math.floor(oldPosition.x) + "px";
                        elemStyle.top = Math.floor(oldPosition.y) + "px";
                    }
                });
            } else {
                // jquery 1.8.3 does not delegate events fired by svg properly
                $targetElement.delegate('[class~="path"]', 'mouseenter', function () {
                    $(this).data('stroke-width', this.getAttribute('stroke-width'));
                    this.setAttribute('stroke-width', EDGE_HOVER_WIDTH);
                }).delegate('[class~="path"]', 'mouseleave', function () {
                    if (Number(this.getAttribute('stroke-width')) === EDGE_HOVER_WIDTH) {
                        this.setAttribute('stroke-width', $(this).data('stroke-width'));
                    }
                }).delegate('[class~="point"]', 'mouseenter', function () {
                    var oldRadius = parseFloat(this.getAttribute('r'), 10);
                    $(this).data('radius', oldRadius);
                    this.setAttribute('r', oldRadius + NODE_HOVER_RADIUS);
                }).delegate('[class~="point"]', 'mouseleave', function () {
                    var oldRadius = $(this).data('radius');
                    if (parseFloat(this.getAttribute('r'), 10) === (oldRadius + NODE_HOVER_RADIUS)) {
                        this.setAttribute('r', oldRadius);
                    }
                });
            }

            this.highlightPopup = HighlightPopup.create('[class~="point"]', "changeset-popup", {
                getHighlightContext: function () {
                    return self.context.highlightContext;
                },
                getDisplayCsId: function (csid) {
                    return FECRU.getDisplayCsId(self.model.settings.repositoryType, csid);
                },
                getHighlightableChangeset: getChangesetFromPoint
            });

            this.syncSelf();
            this.updateVisibilitySelf();
        };
        $.extend(GraphView.prototype, TopLevelView.prototype);

        GraphView.prototype.updateVisibilitySelf = function () {
            var context = this.context;
            var spacing = context.getSpacing();
            var buffer = this.visibilityBuffer;
            var length = this.model.getLength();
            var viewportInDrawSpace = this.viewport;
            var translationInDrawSpace = this.translation;
            var timePosition = context.getGraphTimePosition(this.model);

            //the visible portion of the bounding box is based on the viewport and how translated the dag is.
            var trueVisibleAreaInGraphSpace = context.createGraphSpaceRectangle(
                (viewportInDrawSpace.x - translationInDrawSpace.x) / spacing,
                (viewportInDrawSpace.y - translationInDrawSpace.y) / spacing,
                (viewportInDrawSpace.width) / spacing,
                (viewportInDrawSpace.height) / spacing
            );
            var graphSpaceBuffer = buffer / spacing;
            var visibleAreaInGraphSpaceWithBuffer = this.visibleAreaInGraphSpace = new Rectangle(
                trueVisibleAreaInGraphSpace.x - graphSpaceBuffer,
                trueVisibleAreaInGraphSpace.y - graphSpaceBuffer,
                trueVisibleAreaInGraphSpace.width + (2 * graphSpaceBuffer),
                trueVisibleAreaInGraphSpace.height + (2 * graphSpaceBuffer)
            );

            var visibleAreaPastEdge = visibleAreaInGraphSpaceWithBuffer.x; // x is really timePosition
            var visibleAreaFutureEdge = visibleAreaInGraphSpaceWithBuffer.x + visibleAreaInGraphSpaceWithBuffer.width; // width is really length

            // BUG: additional space needed. Not sure why.  Thought it was the branch header, but that seems unrelated.
            var buggyExtraSpace = 1.5;
            this.scrolledToTimePosition =
                trueVisibleAreaInGraphSpace.x + trueVisibleAreaInGraphSpace.width - buggyExtraSpace;

            this.setVisible(true);

            this.trigger(EdgeProximityEvent, {
                proximityToPastHorizon: visibleAreaPastEdge - timePosition,
                proximityToFutureHorizon: timePosition + length - visibleAreaFutureEdge
            });
        };

        GraphView.prototype.highlightSelf = function () {
            // Do Nothing
            return this;
        };

        GraphView.prototype.syncSelf = function () {

            var model = this.model;
            var context = this.context;
            var spacing = context.getSpacing();
            var length = model.getLength();
            var breadth = model.getBreadth();
            var timePosition = context.getGraphTimePosition(model);

            this.boundingBox = context.createRectangle(
                context.getGraphTimewise(timePosition, length) * spacing,
                0,
                length * spacing,
                breadth * spacing
            );

            this.attributes = {
                scale: 1,
                width: this.boundingBox.width,
                height: this.boundingBox.height
            };

            this.removeDisposedSubViews();
            this.addNewSubViews();
            return this;
        };

        GraphView.prototype.addNewSubViews = function () {
            var model = this.model;
            var subViews = this.subViews;
            /*DEBUG*/
            var nonSparseOnBranch = $.grep(model.interSliceEdges, function (edge) {
                return !edge.parentChangeset.isSparseOnBranch() && !edge.childChangeset.isSparseOnBranch();
            });
            addNewViews(this, subViews, model.dagSlices, GraphSliceView.create);
            addNewViews(this, subViews, nonSparseOnBranch, GraphEdgeView.create);
            addNewViews(this, subViews, model.branchManager.getBranchSet().getAllBranches(), GraphBranchView.create);
        };

        GraphView.prototype.drawSelf = function () {

            if (this.element) {
                this.target.moveGroup(this.element, this.translation);
                this.target.setGroupAttributes(this.element, this.attributes);
            } else {
                this.element = this.target.drawGroup(null, this.translation, this.attributes);
            }
            return this;
        };

        GraphView.prototype.eraseSelf = function () {
            if (this.element) {
                this.target.erase(this.element);
                this.element = null;
            }
            if (this.highlightPopup) {
                this.highlightPopup.erase();
                this.highlightPopup = null;
            }
            return this;
        };

        GraphView.prototype.translate = function (vector) {
            this.context.translateBy(this.translation, vector);
            this.updateVisibility();
            //need to update with translation changes
            this.drawSelf();
            return this;
        };

        GraphView.prototype.translateTo = function (changesetOrPxFromTop) {
            var context = this.context;

            if (typeof changesetOrPxFromTop === 'number') {
                var pixels = changesetOrPxFromTop;
                var firstChangeset = this.model.getLastChangeset();

                if (!firstChangeset.branchRevisions || !firstChangeset.branchRevisions.length) {
                    return;
                }

                var branchRevision = firstChangeset.branchRevisions[0];
                var firstCsPosition = context.getPositionInContainerCoordinates(firstChangeset, branchRevision, this, this.viewport);
                var fullTranslation = new Vector(firstCsPosition.x + pixels, firstCsPosition.y + pixels);

                context.translateTo(this.translation, fullTranslation);
            } else {
                var changeset = changesetOrPxFromTop;
                if (!changeset.branchRevisions || !changeset.branchRevisions.length) {
                    return;
                }

                var branchRevision = changeset.branchRevisions[0]; // It doesn't matter which one we scroll to. We only use the timewise position anyway
                var csPosition = context.getPositionInContainerCoordinates(changeset, branchRevision, this, this.viewport);

                context.translateTo(this.translation, csPosition);
            }

            this.updateVisibility();
            //need to update with translation changes
            this.drawSelf();
        };

        GraphView.prototype.resize = function () {
            this.target.resize();
            var oldViewport = this.viewport;
            var oldCenter = new Point(
                oldViewport.x + oldViewport.width / 2,
                oldViewport.y + oldViewport.height / 2
            );
            var newViewport = new Rectangle(
                0,
                0,
                this.target.getWidth(),
                this.target.getHeight()
            );
            var newCenter = new Point(
                oldViewport.x + oldViewport.width / 2,
                oldViewport.y + oldViewport.height / 2
            );
            this.viewport = newViewport;
            this.translate(new Vector(newCenter.x - oldCenter.x, newCenter.y - oldCenter.y));
        };

        GraphView.prototype.getScrolledToTimePosition = function () {
            return this.scrolledToTimePosition;
        };

        return GraphView;
    })();

    var MetadataChangesetView = (function () {
        var MetadataChangesetView = function (changeset, sliceView) {
            this.model = changeset;
            this.parentView = sliceView;
            this.context = sliceView.context;

            this.element = undefined;

            this._requiresHighlight = true;
            this.highlightable = undefined;
            this.highlightLozenges = [];

            this.attributes = {
                backgroundColor: '',
                color: ''
            };
            this.isFocused = false;

            this.width = sliceView.width;
        };
        $.extend(MetadataChangesetView.prototype, View.prototype);

        MetadataChangesetView.create = function (changeset, sliceView) {
            var view = new MetadataChangesetView(changeset, sliceView);

            view.syncSelf();
            view.updateVisibilitySelf();
            view.resetHighlights();

            return view;
        };

        MetadataChangesetView.prototype.highlightSelf = function () {
            if (this.highlightContext !== this.context.highlightContext) {
                this.resetHighlights();
            }

            var highlightable = this.highlightable;

            this.attributes = createBackgroundColor(highlightable.backgroundColor());
            this.attributes.color = highlightable.textColor();
            this.attributes.metadataCssClass = highlightable.metadataCssClass();
            this.isFocused = highlightable === this.highlightContext.focusedObject;

            return this;
        };

        MetadataChangesetView.prototype.drawSelf = function () {

            var getAvatarUrl = function (author, Configuration) {
                var url = (author.avatarUrl ? author.avatarUrl : Configuration.defaultAvatarUrl);
                return FECRU.getAvatarUrlAtSize(url, "16");
            };

            var isFocused = this.isFocused;
            var attributes = this.attributes;
            var cs = this.model;
            var classes = "metadata-changeset" +
                (isFocused ? " focused" : "") +
                (attributes.metadataCssClass ? " " + attributes.metadataCssClass : "") +
                (cs.isMetadataLoaded() ? " loaded" : "");

            if (cs.isMetadataLoaded()) {
                if (!this.element) {
                    var author = cs.author;
                    var html = templateFactory.load('metadata-changeset').fill({
                        'id': cs.id,
                        //a zEncoded id suitable for use in the 'id' attr of an element
                        'IdEscaped': FECRU.zEscape(cs.id),
                        'date': cs.date || '',
                        'comment:html': cs.comment || '',
                        'userDisplayName': author.displayName || '',
                        'userUrl': author.url || '',
                        'userAvatarUrl': getAvatarUrl(author, Configuration),
                        'classes': classes,
                        'width': this.width
                    });
                    var $metadataElement = this.element = $(html.toString());

                    $metadataElement.css('top', this.position.y);
                    attributes.backgroundColor && $metadataElement.css('backgroundColor', attributes.backgroundColor);
                    attributes.filter && $metadataElement.css('filter', attributes.filter);
                    attributes.color && $metadataElement.css('color', attributes.color);

                    this.parentView.element.append($metadataElement);
                    $metadataElement.data('model', this.model);
                } else {
                    this.element.css('backgroundColor', attributes.backgroundColor)
                        .css('filter', attributes.filter)
                        .css('color', attributes.color)
                        .attr('class', classes)
                        .children()
                        .first()
                        .css('paddingLeft', this.width);
                }
                this.drawLozenges();
            }
        };

        MetadataChangesetView.prototype.eraseSelf = function (parentErased) {
            if (this.element) {
                //.remove is heavy.  Don't do it if the parent element has already been removed.
                !parentErased && this.element.remove();
                this.element = null;
            }
            if (this.highlightLozenges) {
                Array.each(this.highlightLozenges, function (lozenge) {
                    lozenge.erase();
                });
                this.highlightLozenges = [];
            }
        };

        MetadataChangesetView.prototype.reloadMetadata = function () {
            this.eraseSelf();
            this.drawSelf();
            return this;
        };

        MetadataChangesetView.prototype.resize = function () {
            if (this.width !== this.parentView.width) {
                this.width = this.parentView.width;
                if (this.element) {
                    this.element.children().first().css('paddingLeft', this.width);
                }
            }
        };

        MetadataChangesetView.prototype.syncSelf = function () {
            var changeset = this.model;
            var context = this.context;
            var spacing = context.getSpacing();

            this.position = context.createPoint(
                context.getChangesetTimewise(changeset.timePosition, changeset.slice.length) * spacing,
                0
            );

            return this;
        };

        MetadataChangesetView.prototype.resetHighlights = function () {
            var context = this.highlightContext = this.context.highlightContext;
            this.highlightable = context.getChangeset(this.model);
        };

        MetadataChangesetView.prototype.drawLozenges = function () {
            if (!this.element) {
                return;
            }
            var cs = this.model;
            var $lozengeContainer = this.element.find(".lozenge-annotations").empty();
            var tags = cs.tags;

            var context = this.highlightContext;
            var highlightable = context.getChangeset(cs);
            var lozenge = context.getLozenges(highlightable);

            if (lozenge) {
                this.highlightLozenges.push(lozenge);
                Array.each(lozenge.getLozenges(), function (l) {
                    $lozengeContainer.append(l);
                })
            }

            if (tags && tags.length > 0) {
                var tagLozenge = HighlightLozenge.create(tags, {
                    collapsedLozengeText: function (itemCount) {
                        return itemCount + " tags";
                    },
                    getItemText: function (item) {
                        return FECRU.truncateText(item, {
                            maxLength: 50
                        })
                    },
                    getItemTitle: function (item) {
                        return item.length > 53 ? item : null; // only show title if truncated
                    },
                    sort: true,
                    lozengeClass: "tag-lozenge"
                });
                this.highlightLozenges.push(tagLozenge);
                Array.each(tagLozenge.getLozenges(), function (l) {
                    $lozengeContainer.append(l);
                })
            }
        };

        return MetadataChangesetView;
    })();

    var MetadataSliceView = (function () {
        var MetadataSliceView = function (slice, graphView) {
            this.model = slice;
            this.parentView = graphView;
            this.context = graphView.context;
            this.width = graphView.width;
        };
        $.extend(MetadataSliceView.prototype, SliceView.prototype);

        MetadataSliceView.create = function (slice, graphView) {
            var view = new MetadataSliceView(slice, graphView);

            view.syncSelf();
            view.updateVisibilitySelf();

            return view;
        };

        MetadataSliceView.prototype.addNewSubViews = function () {
            var model = this.model;
            var subViews = this.subViews;

            addNewViews(this, subViews, model.getAllChangesets(), MetadataChangesetView.create);

            return this;
        };

        MetadataSliceView.prototype.updateVisibilitySelf = function () {
            var isVisible = this.boundingBoxInGraphSpace.intersectsRectangle(this.parentView.visibleAreaInGraphSpace);
            this.setVisible(isVisible);
        };

        MetadataSliceView.prototype.highlightSelf = function () {
            // Do Nothing
            return this;
        };

        MetadataSliceView.prototype.drawSelf = function () {
            var boundingBox = this.boundingBox;
            var parentView = this.parentView;

            if (!this.element) {
                var $metadataElement = this.element = $('<div class="metadata-slice"/>');
                $metadataElement.height(boundingBox.height)
                    .css('top', boundingBox.y - parentView.boundingBox.y);
                parentView.element.append($metadataElement);
            } else {
                this.element.height(boundingBox.height)
                    .css('top', boundingBox.y - parentView.boundingBox.y);
            }

            return this;
        };

        MetadataSliceView.prototype.eraseSelf = function () {
            if (this.element) {
                this.element.remove();
                this.element = null;
            }
            return this;
        };

        MetadataSliceView.prototype.reloadMetadata = function () {
            if (this.subViews) {
                if (this.isVisible()) {
                    Array.each(this.subViews, function (subView) {
                        subView.highlightable.init(subView.model);
                        subView.reloadMetadata();
                    });
                } else {
                    Array.each(this.subViews, function (subView) {
                        subView.highlightable.init(subView.model);
                    });
                }
            }
            return this;
        };

        MetadataSliceView.prototype.resize = function () {
            this.width = this.parentView.width;
            this.subViews && Array.each(this.subViews, function (subView) {
                subView.resize();
            });
        };

        return MetadataSliceView;
    })();

    var MetadataView = (function () {
        var MetadataView = function (dag, $container, initialViewport, initialTranslation, context) {
            this.model = dag;
            this.$container = $container;
            this.context = context;
            this.viewport = initialViewport;

            this._events = {};

            this._isVisible = false;
            this.visibilityBuffer = context.getSpacing() * 20;

            this.translation = initialTranslation;
            this.visibleAreaInGraphSpace = undefined;
            this.element = undefined;

            this.pendingRescrollPx = 0;

            bindEvents(this);

            this.syncSelf();
            this.updateVisibilitySelf();
        };
        $.extend(MetadataView.prototype, TopLevelView.prototype);

        function bindEvents(self) {
            var $container = self.$container;
            var events = self._events;

            $container.scroll(events.onScroll = function () {
                self.scrollTop = $container.scrollTop();
            });

            $container.delegate('.metadata-changeset', 'click', events.onChangesetClick = function (e) {
                if ($(e.target).closest(".navigation", this).length > 0) {
                    return;
                }
                var cs = $(this).data('model');
                var highlightable = cs ? self.context.highlightContext.getChangeset(cs) : null;

                highlightable && self.setFocus(highlightable);
            });

            $container.delegate('.csid-copy input', 'focus mouseup', events.onCsidCopyFocus = function (e) {
                this.select();
            });

        }

        function unbindEvents(self) {
            var $container = self.$container;
            var events = self._events;

            events.onScroll && $container.unbind('scroll', events.onScroll);
            events.onChangesetClick && $('.metadata-changeset', $container).undelegate('click', events.onChangesetClick);
            events.onCsidCopyFocus && $('.csid-copy input', $container).undelegate('focus mouseup', events.onCsidCopyFocus);
        }

        MetadataView.prototype.addNewSubViews = function () {
            var model = this.model;
            var subViews = this.subViews;

            addNewViews(this, subViews, model.dagSlices, MetadataSliceView.create);
        };

        MetadataView.prototype.updateVisibilitySelf = function () {
            var context = this.context;
            var spacing = context.getSpacing();
            var buffer = this.visibilityBuffer;
            var length = this.model.getLength();
            var viewportInDrawSpace = this.viewport;
            var translationInDrawSpace = this.translation;
            var timePosition = context.getGraphTimePosition(this.model);

            //the visible portion of the bounding box is based on the viewport and how translated the dag is.
            var trueVisibleAreaInGraphSpace = context.createGraphSpaceRectangle(
                (viewportInDrawSpace.x - translationInDrawSpace.x) / spacing,
                (viewportInDrawSpace.y - translationInDrawSpace.y) / spacing,
                (viewportInDrawSpace.width) / spacing,
                (viewportInDrawSpace.height) / spacing
            );
            var graphSpaceBuffer = buffer / spacing;
            var visibleAreaInGraphSpaceWithBuffer = this.visibleAreaInGraphSpace = new Rectangle(
                trueVisibleAreaInGraphSpace.x - graphSpaceBuffer,
                trueVisibleAreaInGraphSpace.y - graphSpaceBuffer,
                trueVisibleAreaInGraphSpace.width + (2 * graphSpaceBuffer),
                trueVisibleAreaInGraphSpace.height + (2 * graphSpaceBuffer)
            );

            var visibleAreaPastEdge = visibleAreaInGraphSpaceWithBuffer.x; // x is really timePosition
            var visibleAreaFutureEdge = visibleAreaInGraphSpaceWithBuffer.x + visibleAreaInGraphSpaceWithBuffer.width; // width is really length

            this.setVisible(true);

            this.trigger(EdgeProximityEvent, {
                proximityToPastHorizon: visibleAreaPastEdge - timePosition,
                proximityToFutureHorizon: timePosition + length - visibleAreaFutureEdge
            });
        };

        MetadataView.prototype.syncSelf = function () {

            var model = this.model;
            var context = this.context;
            var spacing = context.getSpacing();
            var length = model.getLength();
            var breadth = model.getBreadth();
            var timePosition = context.getGraphTimePosition(model);

            this.boundingBox = context.createRectangle(
                context.getGraphTimewise(timePosition, length) * spacing,
                0,
                length * spacing,
                breadth * spacing
            );

            var topChangeset = model.getLastChangeset();
            if (this.lastTopChangeset && (topChangeset !== this.lastTopChangeset)) {
                var oldTopPosition = context.getPositionInContainerCoordinates(this.lastTopChangeset, this.lastTopChangeset.branchRevisions[0], this, this.viewport);
                var newTopPosition = context.getPositionInContainerCoordinates(topChangeset, topChangeset.branchRevisions[0], this, this.viewport);
                var newSpaceAtTop = oldTopPosition.y - newTopPosition.y;

                this.pendingRescrollPx += newSpaceAtTop;
            }
            this.lastTopChangeset = topChangeset;

            this.attributes = {
                scale: 1,
                width: this.boundingBox.width,
                height: this.boundingBox.height
            };

            this.removeDisposedSubViews();
            this.addNewSubViews();
            return this;
        };

        MetadataView.prototype.highlightSelf = function () {
            // Do Nothing
            return this;
        };

        MetadataView.prototype.drawSelf = function () {
            var boundingBox = this.boundingBox;
            var height = boundingBox.height;
            var scrollTop = this.scrollTop || 0;

            if (this.element) {
                this.element.height(height);
                this.$container.scrollTop(scrollTop);
            } else {
                this.element = $('<div class="metadata-dag"/>').height(height).appendTo(this.$container);
                this.$container.scrollTop(scrollTop);
            }
        };

        // Should only be called by destroy.
        MetadataView.prototype.eraseSelf = function () {
            unbindEvents(this);
            if (this.element) {
                this.element.remove();
                this.element = null;
            }
        };

        MetadataView.prototype.reloadMetadata = function () {
            this.subViews && Array.each(this.subViews, function (subView) {
                subView.reloadMetadata();
            });
            return this;
        };

        MetadataView.prototype.resize = function () {
            this.width = this.parentView.width;
            this.viewport = new Rectangle(0, 0, this.width, this.$container.height());
            this.subViews && Array.each(this.subViews, function (subView) {
                subView.resize();
            });
            this.updateVisibility();
            this.drawSelf();
        };

        MetadataView.prototype.translateTo = function (changesetOrPxFromTop) {
            if (typeof changesetOrPxFromTop === 'number') {
                this.scrollTop = changesetOrPxFromTop;
            } else {
                var context = this.context;
                var branchRevision = changesetOrPxFromTop.branchRevisions[0];
                var csPosition = context.getPositionInContainerCoordinates(changesetOrPxFromTop, branchRevision, this, this.viewport);

                this.scrollTop = csPosition.y - this.boundingBox.y;
            }
            this.drawSelf();
        };

        MetadataView.prototype.hasPendingRescroll = function () {
            return !!this.pendingRescrollPx;
        };

        MetadataView.prototype.updateScroll = function () {
            if (this.pendingRescrollPx) {
                var pendingRescrollPx = this.pendingRescrollPx;
                this.scrollTop += pendingRescrollPx;
                this.pendingRescrollPx = 0;
                this.reDraw();

                return pendingRescrollPx;
            }
            return 0;
        };

        return MetadataView;
    })();

    var DualView = (function () {
        var DualView = function (dag, target, $container, initialViewport, initialTranslation, context) {
            this.model = dag;
            this.$graphContainer = $(target.getContainer());
            this.$metadataContainer = $container;
            this.context = context;

            this.graphicalView = new GraphView(dag, target, initialViewport, initialTranslation, context);
            this.graphicalView.parentView = this;
            this.metadataView = new MetadataView(dag, $container, initialViewport, initialTranslation, context);
            this.metadataView.parentView = this;
            this.subViews = [this.graphicalView, this.metadataView];

            this._isVisible = true;
            var self = this;
            var triggerSelf = function (event) {
                self.trigger(EdgeProximityEvent, event);
            };
            Array.each(this.subViews, function (view) {
                view.bind(EdgeProximityEvent, triggerSelf);
            });
        };
        $.extend(DualView.prototype, TopLevelView.prototype);

        DualView.create = function (graph, target, $metadataContainer, horizontalOrVertical, timeDirectionPositive) {
            var horizontal = horizontalOrVertical === 'horizontal';
            var flippedTimewise = !timeDirectionPositive;
            var initialViewport = new Rectangle(
                0,
                0,
                target.getWidth(),
                target.getHeight()
            );
            var context = createContext(horizontal, flippedTimewise, CHANGESET_SPACING, CHANGESET_RADIUS);
            var initialOffset = flippedTimewise ?
                (horizontal ? initialViewport.width : initialViewport.height) :
                0;
            var initialTranslation = context.createVector(
                (CHANGESET_SPACING / 2) + initialOffset,
                CHANGESET_SPACING / 2
            );

            return new DualView(graph, target, $metadataContainer, initialViewport, initialTranslation, context);
        };

        /**
         * If sync is called on DualView, we know it comes from the user (not internal to our view tree).
         * That means we're goin got need a full lifecycle call.
         */
        var ViewSync = View.prototype.sync;
        DualView.prototype.sync = function (forceFullRefresh) {
            // The root level must resync to grab new slices
            this.setSyncRequired(true);

            ViewSync.call(this, forceFullRefresh);

            var graphView = this.graphicalView;
            var metadataView = this.metadataView;

            if (forceFullRefresh) {
                graphView.reDraw();
            }

            /** new metadata might have loaded on top.  This means
             *  the metadata view must increase its height, increase all existing slice tops to make room,
             *  and scroll down so the changesets that were on the screen before are still on the screen.
             *  This scroll should NOT trigger a matched scroll by the graph view, because that would move
             *  them out of sync.
             *  Therefore we must also scroll the graphView UP in prep for the downward scroll event from the metadataView
             */
            if (metadataView.hasPendingRescroll()) {
                //includes a redraw.
                var realignmentPx = metadataView.updateScroll();
                realignmentPx && graphView.translate(new Vector(0, realignmentPx));
            } else if (forceFullRefresh) {
                metadataView.reDraw();
            }

            return this;
        };

        DualView.prototype.syncSelf = function () {
            // Do Nothing
            return this;
        };

        DualView.prototype.updateVisibilitySelf = function () {
            // Do Nothing
            return this;
        };

        DualView.prototype.highlightSelf = function () {
            // Do Nothing
            return this;
        };

        DualView.prototype.drawSelf = function () {
            // Do Nothing
            return this;
        };

        DualView.prototype.eraseSelf = function () {
            // Do Nothing
            return this;
        };

        DualView.prototype.setSyncRequired = function (requiresSync) {
            if (requiresSync) {
                this._isSyncedWithModel = false;
                this.graphicalView.setSyncRequired(requiresSync);
                this.metadataView.setSyncRequired(requiresSync);
            } else {
                this._isSyncedWithModel = !requiresSync;
            }
        };

        // if this is IE8, don't redraw metadata until the end of the scroll.
        var isIE8 = $.browser.msie && $.browser.version < 9;
        var pendingTranslation = new Vector(0, 0);
        var graphTranslate = function (self) {
            self.graphicalView.translate(pendingTranslation);
            pendingTranslation = new Vector(0, 0);
        };
        var throttledGraphTranslate = $.browser.mozilla ?
            graphTranslate : // Firefox sucks at ordering the event execution if you setTimeout.
                             // Performance takes a hit when we don't throttle, but perceived performance
                             // is improved because you don't get huge lags in graph translation.
            $.throttle(isIE8 ? 500 : 50, graphTranslate);
        var metadataRedraw = function (self) {
            self.metadataView.updateVisibility();
            self.metadataView.drawSelf();
        };
        var throttledMetadataRedraw = isIE8 ?
            $.debounce(500, metadataRedraw) :
            $.throttle(250, metadataRedraw);
        DualView.prototype.translate = function (vector) {
            pendingTranslation = pendingTranslation.add(vector);
            throttledGraphTranslate(this);
            throttledMetadataRedraw(this);

            return this;
        };

        DualView.prototype.translateTo = function (changeset) {
            //HACK: this scroll will cause events to fire that will
            // make the ProjectVisualiser tell us to translate the graphView.
            // Very convoluted - we should move scroll handling into the view.
            this.metadataView.translateTo(changeset);

            return this;
        };

        DualView.prototype.resize = function () {
            var $dualContainer = this.$graphContainer.parent();
            var availableWidth = $dualContainer.width();
            var graphSpaceDesired = this.graphicalView.boundingBox.width + METADATA_PADDING_LEFT;
            var graphSpace = Math.min(graphSpaceDesired, availableWidth - 200);

            this.width = graphSpace;
            this.$graphContainer.width(graphSpace);
            this.graphicalView.resize();
            this.metadataView.resize();
        };

        DualView.prototype.reloadMetadata = function () {
            this.metadataView.reloadMetadata();
            this.reHighlight();
        };

        DualView.prototype.getScrolledToTimePosition = function () {
            return this.graphicalView.getScrolledToTimePosition();
        };

        DualView.prototype.init = function (scrollToChangesetId, focusChangesetId) {
            var model = this.model;
            var graphView = this.graphicalView;

            // align graph with metadata view - put first row at the top
            graphView.translateTo(0);

            var scrollToChangeset;
            if (scrollToChangesetId && (scrollToChangeset = model.findChangesetByIdOrTag(scrollToChangesetId))) {
                this.translateTo(scrollToChangeset);
            } else if (scrollToChangesetId) {
                var msg = $("<div></div>")
                    .append("<p></p>").text("Could not find a changeset with the id or tag: " + scrollToChangesetId);
                FECRU.AJAX.appendNotificationMessage(msg, true);
                FECRU.AJAX.showNotificationBox("Changeset not found", 'message');
            }

            var focusChangeset = focusChangesetId === scrollToChangesetId ?
                scrollToChangeset :
            focusChangesetId && model.findChangesetByIdOrTag(focusChangesetId);
            if (focusChangeset) {
                this.setFocus(this.context.highlightContext.getChangeset(focusChangeset));
            }
        };

        return DualView;
    })();

    return {
        createGraphView: DualView.create,
        View: View,
        SliceView: SliceView,
        GraphView: GraphView,
        GraphSliceView: GraphSliceView,
        GraphGroupView: GraphGroupView,
        GraphBranchRevisionView: GraphBranchRevisionView,
        GraphEdgeView: GraphEdgeView,
        MetadataView: MetadataView,
        MetadataSliceView: MetadataSliceView,
        MetadataChangesetView: MetadataChangesetView,
        DualView: DualView,
        EdgeProximityEvent: EdgeProximityEvent
    };
})(AJS.$, AJS.template);
/*[{!renderer_js_6tm252r!}]*/;
/* END /2static/script/fe/commitgraph/drawing/renderer.js */
/* START /2static/script/fe/commitgraph/drawing/branch-header.js */
FE.VIS.BranchHeader = (function ($, templateFactory) {
    /* Imports */
    var Vis = FE.VIS;
    var CHANGESET_SPACING = Vis.Configuration.CHANGESET_SPACING;
    var AbstractPositioner = Vis.POSITIONING.AbstractPositioner;
    var colorForBranch = Vis.BranchSet.colorForBranch;
    var BranchSet = Vis.BranchSet;
    var Map = FECRU.DATA_STRUCTURES.Map;
    var Dialog = FECRU.DIALOG;

    // This variable is used to set an id on each branch head lozenge in the main dag - _not_ in the branch dialog
    var BRANCH_HEAD_ID_PREFIX = "branch-head-";
    var MAX_BRANCHES = 20;

    /*privates */
    /**
     * Add a branch to the given container, with the given name and color. Uses the template 'branch-head'
     * @param $container the container to add the branch element to
     * @param branchName the name of the branch
     * @param color the color - all css color formats accepted.
     * @param idCreator an optional function that will return an id for the given branchName
     */
    function appendBranchToContainer($container, branchName, color, idCreator, makeOpaque) {
        if (!branchName) {
            return null;
        }

        var html = templateFactory.load('branch-head').fill({
            'branchName': branchName
        }).toString();

        var $elem = $(html)
            .data("branch-name", branchName)
            .css({
                "background-color": color,
                "border-color": color,
                "opacity": makeOpaque ? 0.5 : 1
            })
            .appendTo($container);

        if (idCreator && $.isFunction(idCreator)) {
            $elem.attr("id", idCreator(branchName));
        }
        return $elem;
    }

    function setupDragging($branchList, onUpdate, axis) {
        $branchList.sortable({
            tolerance: "intersect",
            helper: "clone",
            handle: ".draggable-handle",
            placeholder: "branch-placeholder branch-head",
            opacity: 0.4,
            cursor: "move",
            scroll: false,
            update: onUpdate,
            axis: axis || false
        });
    }

    function isAlreadySelected(branchName, $branchList) {
        var branches = [];
        $branchList.find("input.branch-name-holder").each(function () {
            branches.push($(this).val());
        });
        return Array.any(branches, function (branch) {
            return branch === branchName;
        });
    }

    /*public*/
    /**
     * Create a new branch header.
     * @param $container the containing element of the branch header
     * @param branchSet a reference to the branchset
     * @param positioner the DAG positioner (used for calculating widths)
     */
    var BranchHeader = function ($container, branchSet, positioner) {
        var self = this;
        this.$branchSetContainer = $("#branch-header-list");
        this.initialise(branchSet);

        var branchHeadPopupSelector = ".branch-head:not(.branch-placeholder,.ui-sortable-helper)";

        // If we are in "All branches mode" then only set the popup within the dialog, otherwise use all headers
        if (self.branchSet.isAllInOne()) {
            branchHeadPopupSelector = "#dialog-branch-editor " + branchHeadPopupSelector;
        }

        new BranchHeaderPopup(branchHeadPopupSelector, "branch-head-popup", {});

        if (!self.branchSet.isAllInOne()) {
            setupDragging(this.$branchSetContainer, function (event, ui) {
                var branches = Array.map($(this).sortable("toArray"), function (elem) {
                    return elem.slice(BRANCH_HEAD_ID_PREFIX.length);
                });
                if (branches.length > MAX_BRANCHES) {
                    FECRU.AJAX.appendErrorMessage('You cannot reorder branches as you have more than ' + MAX_BRANCHES + '. Remove branches before reordering.');
                    FECRU.AJAX.showUserErrorBox();
                    $(this).sortable('cancel');
                    return;
                }

                self.branchSet.trigger(BranchSet.BranchesReordered, {
                    // "this" is the sortable element in the context of this callback
                    branches: branches
                });
            }, "x");

            $container.delegate(".branch-remove", "click", function () {
                var $branchHead = $(this).closest(".branch-head");
                var branchName = $branchHead.data("branch-name");
                var visibleBranchNames = self.branchSet.getBranchNames();

                var removedBranchIndex = $.inArray(branchName, visibleBranchNames);
                if (removedBranchIndex === -1) {
                    return; // How did we end up in this state;
                }

                Array.remove(visibleBranchNames, removedBranchIndex);
                $branchHead.remove();

                self.branchSet.trigger(BranchSet.BranchesRemoved, {
                    removedBranches: [
                        branchName
                    ],
                    visibleBranches: visibleBranchNames
                });
            });
        }
        positioner.bind(AbstractPositioner.BranchExpandedEvent, function (e) {
            var width = e.breadth * CHANGESET_SPACING;
            var branch = self.elementByBranchName.get(e.branchName);
            if (branch) {
                branch.width(width - 4 + "px");
            }
        });

        var $dialogContents = $("#dialog-branch-editor");
        var $branchAutocomplete = $(".fecru-autocomplete-wrapper");

        $dialogContents.find("#autocomplete-holder").append($branchAutocomplete);
        this.createDialog($dialogContents);
        if (this.infoMsg) {
            self.branchDialog.showInfoMsg(this.infoMsg);
        }

        $("#branch-modifier").click(function () {
            self.branchDialog.resetAndShow();
            return false;
        });
    };

    BranchHeader.prototype.initialise = function (branchSet) {
        this.elementByBranchName = new Map();
        this.setBranchSet(branchSet);
        if (branchSet.getRepositoryType() === 'GIT') {
            this.infoMsg =
                $("<strong>Note:</strong> <em class='git-branch-notice'>Git repositories (such as this one) can have commits that appear in a number of different branches. "
                    + "To visualise this, we put the commit on the left-most item it occurs. "
                    + "<a href='https://confluence.atlassian.com/display/FISHEYE/Ordering+of+Branches+Important+When+Visualising+Git+Changesets'>Read more...</a></em>");
        }
    };

    BranchHeader.prototype.setBranchSet = function (branchSet) {
        this.branchSet = branchSet;
        var branches = branchSet.isAllInOne() ? [branchSet.getAllInOne()] : branchSet.getAllBranches();
        var $container = this.$branchSetContainer.empty();
        var elementByBranchName = this.elementByBranchName;

        Array.each(branches, function (branch) {
            var $elem = appendBranchToContainer($container, branch.name, branch.color, function (branchName) {
                return BRANCH_HEAD_ID_PREFIX + branchName;
            });
            elementByBranchName.set(branch.name, $elem);
        });
        if (branchSet.isAllInOne()) {
            $("#branch-header-list .branch-remove").remove();
        }
    };

    /**
     * Create a branch dialog. Will only create one.
     */
    var dialogCreated = false;
    BranchHeader.prototype.createDialog = function ($dialogContents) {
        if (dialogCreated) {
            return;
        }
        dialogCreated = true;

        var self = this;
        var isAllBranchesMode = false;
        var $branchList = $dialogContents.find(".branch-list");
        var $branchInput = $dialogContents.find("#branch-modifier-dialog-autocomplete-input");
        var $errorMsgHolder = $dialogContents.find("#dialog-error-message-holder").hide();
        var $infoMsgHolder = $dialogContents.find("#dialog-info-message-holder").hide();
        var $toggle = $dialogContents.find(".toggle-branch-mode");

        var hideDialog = function () {
            $branchInput.trigger("reset.autocomplete");
            self.branchDialog && self.branchDialog.hide();
        };

        var getNewBranchNames = function () {
            var newBranches = [];
            $dialogContents.find("input.branch-name-holder").each(function () {
                newBranches.push($(this).val());
            });
            return newBranches;
        };

        var saveDialog = function () {
            var newBranches = getNewBranchNames();
            if (newBranches.length > MAX_BRANCHES) {
                flashErrorMsg('You have selected too many branches. Please remove branches to bring your selection to less than or equal to ' + MAX_BRANCHES + ' branches.');
                return;
            }
            self.branchSet.saveBranches(newBranches, isAllBranchesMode);
            hideDialog();
        };

        var switchContentsToBranchLaneMode = function () {
            $toggle.text("Switch to all branches mode");
            var newBranchNames = getNewBranchNames();
            $branchList.empty();
            isAllBranchesMode = false;
            Array.each(newBranchNames, function (branchName) {
                addBranch(branchName, isAllBranchesMode);
            });
        };


        $toggle.bind('click', function () {
            isAllBranchesMode = !isAllBranchesMode;
            if (isAllBranchesMode) {
                saveDialog();
            } else {
                switchContentsToBranchLaneMode();
            }
        });

        var flashErrorMsg = function (msg) {
            $errorMsgHolder.text(msg);
            $errorMsgHolder.show();
        };

        var resetAutoComplete = function () {
            $branchInput.triggerHandler("placeholderReset.jQueryPlaceholder");
            $branchInput.trigger("reset.autocomplete");
        };

        var checkForBranchNameError = function (branchName, autoCompletResult) {
            if (!branchName) {
                //just ignore - could be a typo/mis-click
                return false;
            } else if (isAlreadySelected(branchName, $branchList)) {
                //no need to show error msg when selecting the same branch again and again
                resetAutoComplete();
                return false;
            } else if (autoCompletResult && !(autoCompletResult.data.length > 0)) {
                flashErrorMsg("Cannot find the branch '" + branchName + "' - please check that the branch exists.");
                return false;
            } else {
                $errorMsgHolder.hide();
                return true;
            }
        };


        $branchInput.fecruSetOptions({
            isItemChecked: function (value) {
                return isAlreadySelected(value, $branchList);
            }
        });

        var addBranchAndSwitchMode = function (branchName, preserveAutoComplete) {
            if (checkForBranchNameError(branchName)) {
                if (self.branchSet && isAllBranchesMode) {
                    switchContentsToBranchLaneMode();
                }
                addBranch(branchName, isAllBranchesMode, preserveAutoComplete);
            }
        };
        /**
         * @param branchName the string name of the branch to add. Case sensitive.
         */
        var addBranch = function (branchName, isAllBranchesMode, preserveAutoComplete) {
            if (checkForBranchNameError(branchName)) {
                appendBranchToContainer($branchList, branchName, colorForBranch(branchName), undefined, isAllBranchesMode);
                if (!preserveAutoComplete) {
                    resetAutoComplete();
                }
            }
        };
        var removeBranch = function (branchName) {
            if (branchName) {
                $branchList.find('input').filter(function () {
                    return this.value === branchName;
                }).closest('.branch-head').remove();
            }
        };

        self.branchDialog = Dialog.create(600, 400, undefined, {
            preferredFocusSelector: '.toggle-branch-mode'
        })
            .addHeader("Select Branches")
            .addButton("Apply", saveDialog, "branch-dialog-ok-button")
            .addLink("Cancel", hideDialog, "branch-dialog-cancel-button")
            .addPanel("Add Branches", $dialogContents);

        self.branchDialog.resetAndShow = function () {
            $branchList.empty();
            if (self.branchSet) {
                isAllBranchesMode = self.branchSet.isAllInOne();
                Array.each(self.branchSet.getBranchNames(), function (branchName) {
                    addBranch(branchName, isAllBranchesMode);
                });
            }
            self.branchDialog.show();
        };

        self.branchDialog.showInfoMsg = function (msg) {
            $infoMsgHolder.empty().append(msg).show();
        };

        var enterPressed = false;
        $branchInput.bind("result", function (event, data, valueOrValues, unselectedValues) {
            if ($.isArray(valueOrValues)) {
                Array.each(valueOrValues, function (branchName) {
                    addBranchAndSwitchMode(branchName);
                });
                unselectedValues && Array.each(unselectedValues, function (branchName) {
                    removeBranch(branchName);
                });
            } else {
                addBranchAndSwitchMode(valueOrValues);
            }
            enterPressed = false;
            //Disable default autocomplete handling where the selected value is set on the input
            event.stopImmediatePropagation();
        }).bind("selection", function (event, branchName, checked) {
            if (checked) {
                addBranchAndSwitchMode(branchName, true);
            } else {
                removeBranch(branchName)
            }
        }).bind("autocomplete-data-received", function (event, result) {
            var inputVal = $branchInput.val();
            if (enterPressed) {
                if (result.data.length > 0) {
                    var dataList = result.data;
                    //try to find a match in the result. If found, add branch, if not found, dont do anything
                    var match = Array.first(dataList, function (matchedItem) {
                        return matchedItem.data.id === inputVal;
                    });
                    if (match) {
                        addBranchAndSwitchMode(match.data.id);
                    } else if (dataList.length === 1) {
                        addBranchAndSwitchMode(dataList[0].data.id);
                    }
                } else {
                    checkForBranchNameError(inputVal, result);
                }
                enterPressed = false;
            }
        }).keydown(function (event) {
            if (event.which === $.ui.keyCode.ENTER) { //the enter key
                enterPressed = true;
                event.preventDefault();
                event.stopPropagation();

            }
        }).change(function () {
            enterPressed = false;
        });

        $dialogContents.delegate(".branch-remove", "click", function () {
            $(this).closest(".branch-head").remove();
            $branchInput.resetSelectionCache();
            switchContentsToBranchLaneMode();
        });

        setupDragging($branchList, $.noop);
    };

    var BranchHeaderPopup = function (selector, id, opts) {
        var self = this;
        var getArrowAttributes = function () {
            return {
                fill: self.dialogColor,
                stroke: self.dialogColor
            };
        };

        var defaults = {
            onHover: true,
            fadeTime: 0,
            hideDelay: 0,
            showDelay: 0,
            getArrowAttributes: getArrowAttributes,
            displayShadow: false,
            useLiveEvents: true,
            cacheContent: false,
            getArrowPath: function () {
                return "M0,8L6,2,12,8";
            },
            calculatePositions: function (popup, targetPosition, mousePosition, opts) {
                // CONSTANTS
                var PADDING_TOP = 0;
                var PADDING_LEFT = 0;
                var ARROW_HEIGHT = 6;

                var $header = targetPosition.target.closest(selector);
                var branchName = $header.data("branch-name");
                var offset = $header.offset();

                // Get the dialog colour here to avoid a race condition in the dialog
                if (branchName) {
                    self.dialogColor = colorForBranch(branchName);
                }

                var arrowLeft = 2;
                var arrowTop = -ARROW_HEIGHT;
                var popupLeft = offset.left + PADDING_LEFT;
                var popupTop = offset.top + $header.outerHeight() + PADDING_TOP + ARROW_HEIGHT;

                return {
                    displayAbove: false,
                    popupCss: {
                        left: popupLeft,
                        right: "auto",
                        top: popupTop
                    },
                    arrowCss: {
                        position: "absolute",
                        left: arrowLeft,
                        right: "auto",
                        top: arrowTop
                    }
                }
            }

        };

        this.dialogColor = "#333";

        var hoverOpts = $.extend({}, defaults, opts);

        this.initialise(selector, id, hoverOpts);
    };

    BranchHeaderPopup.prototype.initialise = function (selector, id, opts) {
        if (this.popup) {
            return; // don't multi-init
        }
        var self = this;
        var lastTrigger = undefined;

        var hidePopup = function () {
            if (self.popup) {
                // Set the display property rather than calling "hide()" because InlineDialog overrides this method
                // and it does not do what we expect
                self.popup.css("display", "none");
            }
        };

        this.popup = AJS.InlineDialog(selector, id, function (contents, trigger, showPopup) {
            var $contents = $(contents).empty();
            var branchName = $(trigger).data("branch-name");

            if (branchName) {
                self.dialogColor = colorForBranch(branchName);
                $contents.append(
                    $("<span></span>").text(branchName)
                ).css("backgroundColor", self.dialogColor);

                if (lastTrigger && lastTrigger !== trigger) {
                    hidePopup();
                }
                lastTrigger = trigger;
                showPopup();
            } else {
                hidePopup();
            }
        }, opts);
    };

    return BranchHeader;
})(AJS.$, AJS.template);
/*[{!branch_header_js_hqen52o!}]*/;
/* END /2static/script/fe/commitgraph/drawing/branch-header.js */
/* START /2static/script/fe/commitgraph/changeset-dialog.js */
FE.VIS.ChangesetDialog = (function ($, templateFactory) {

    /**imports**/
    var ajax = FECRU.AJAX;
    var setupPathAbbreviation = FE.setupPathAbbreviation;
    var NAV = FECRU.NAVBUILDER;
    var maxTagsDisplayed = 5;

    /**private**/
    //comparator by weight
    function byWeight(a, b) {
        return a.moreInfo.weight - b.moreInfo.weight;
    }

    function computeWidth($pathElement) {
        //abreviate up to the width of tha path, minus the width of the path action items (source, diff ,history etc)
        return $pathElement.closest('li').width() - $pathElement.siblings("ul.file-views").width();
    }

    /**
     * Return a string of the html that make up the tags
     * @param tags an array of string of tags. Should be ready sorted in the order desired by the UI
     */
    function makeTagLiHtml(tags, repositoryName) {
        return Array.map(tags, function (tag) {
            var url = NAV.browseAtTag(repositoryName, tag);
            var tagEncoded = AJS.escapeHtml(tag);

            return "<li class='highlighter-annotation-item'>" +
                "<a href='" + url + "' title='Browse repository at " + tagEncoded + "'>" + tagEncoded + "</a>" +
                "</li>";
        }).join('');
    }

    function addTags(changesetInfo) {
        if (changesetInfo && changesetInfo.tags && changesetInfo.tags.length > 0) {
            var tags = changesetInfo.tags.slice(0).sort();
            var showMore = tags.length > maxTagsDisplayed;
            var visibleTagsHtml = makeTagLiHtml(tags.slice(0, maxTagsDisplayed), changesetInfo.repositoryName);
            var amount = tags.length - maxTagsDisplayed;
            var showMoreHtml = showMore ? "<li id='tags-annotation-show-more' style='cursor:pointer'>Show " + (amount) + " more...</li>" : "";

            if (showMore) {
                //delegate because we don't yet have the dom element inserted
                $(document).delegate("#tags-annotation-show-more", "click", function (e) {
                    var $this = $(this);
                    var remainingTagsHtml = makeTagLiHtml(tags.slice(maxTagsDisplayed), changesetInfo.repositoryName);

                    $this.remove();
                    $("#tags-annotation-list").append(remainingTagsHtml);
                    //undelegate because we dont want this executing again for the next changeset
                    $(document).undelegate("#tags-annotation-show-more", "click");
                });
            }

            return {
                weight: 30,
                title: "Tags",
                element: $("<ul id='tags-annotation-list'>" + visibleTagsHtml + showMoreHtml + "</ul>")
            };
        } else {
            return null;
        }
    }

    /* Public*/

    /**
     * Constructs the chanceset more info dialog. This will delegate a click to each of the more info icon link
     * in the metadata section, which will cause the dialog to appear.
     * @param visualiser the visualiser. Used to obtain a list of highlighter plugins. The set of plugins should be loaded before being passed
     * into this constructor
     */
    var ChangesetDialog = function (visualiser) {
        //properties in this class
        this.visualiser = visualiser;
        this.$dialog = null;
        this.$panel = null;
        this.$infoLink = null;
    };

    /**
     * sets up the dialog
     * @param setting an optional setting containing the width and height. defaults to FE.VIS.Configuration.ChangesetDialogConfig;
     */
    ChangesetDialog.prototype.setup = function (setting) {
        var self = this;
        $(document).delegate('.metadata-changeset .info-link', 'click', function (e) {
            e.preventDefault();
            e.stopImmediatePropagation();

            var $infoLink = self.$infoLink = $(this);
            var url = $infoLink.attr('href');
            var width = setting.width;
            var height = setting.height;
            var dialogId = "changeset-details-dialog";
            var panelId = "changeset-details-dialog-panel";
            var $dialog = self.$dialog = self.$dialog || FECRU.DIALOG.ajaxDialog(width, height, {}, dialogId)
                    .addHeader("Changeset Details")
                    .addPanel("Changeset Details", "<div id='" + panelId + "'>Loading...</div>")
                    .addButton("Close", function (d) {
                        d.hide();
                    }, "cancelButton");
            $dialog.show();
            self.$panel = self.$panel || $('#' + panelId);
            self.$panel.empty(); //clear the panel first before putting in a spinner
            ajax.startSpin(panelId, "changeset-details-spinner");
            ajax.ajaxUpdate(url, {}, panelId, function (data) {
                ajax.stopSpin(self.$panel);
                if (data && data.worked) {
                    var $stream = $("#stream");
                    var $article = $stream.find(".article").first();
                    var model = self.$infoLink.closest(".metadata-changeset").data("model");
                    var highlighterMoreInfos = [];
                    var changesetInfo = {
                        changesetId: model.csid,
                        tags: model.tags,
                        date: model.date,
                        comment: model.comment,
                        author: model.author,
                        repositoryName: setting.repositoryName,
                        branches: model.branches.slice(0)
                    };

                    setupPathAbbreviation($stream, computeWidth);

                    //add the tags list
                    var tagMoreInfo = addTags(changesetInfo);
                    if (tagMoreInfo) {
                        highlighterMoreInfos.push({id: "built-in-tags", moreInfo: addTags(changesetInfo)});
                    }

                    Array.each(self.visualiser.getHighlighters(), function (highlighterData) {
                        var highlighterContext = self.visualiser.getHighlighterContext(highlighterData.id);
                        var moreInfo = highlighterContext.getMoreInfo(changesetInfo, $stream);

                        if (moreInfo) {
                            highlighterMoreInfos.push({id: highlighterData.id, moreInfo: moreInfo});
                        }
                    });

                    highlighterMoreInfos.sort(byWeight);

                    Array.each(highlighterMoreInfos, function (h) {
                        var $dialogContents = $(templateFactory.load("highlighter-more-info-template")
                            .fill({highlighterId: h.id, title: h.moreInfo.title})
                            .toString());

                        $dialogContents.append(h.moreInfo.element);
                        $article.append($dialogContents);
                    });
                }
            });
        }).delegate("#changeset-details-dialog-panel .article-section > h4", "click", function (e) { //TODO: should we even be hide/showing this section?
            var $this = $(this);
            var section = $this.siblings();
            var toggle = function () {
                $this.toggleClass("highlighter-more-info-heading-hidden");
            };

            if ($this.hasClass("highlighter-more-info-heading-hidden")) {
                section.show("fast", toggle);
            } else {
                section.hide("fast", toggle);
            }
        });
        return self;
    };

    /**
     * Factory method for creating a changeset dialog.
     * @param visualiser reference to the visualiser.
     * @param repositoryName the repository name - used to generate links
     */
    ChangesetDialog.create = function (visualiser, repositoryName) {
        return new ChangesetDialog(visualiser).setup({
            width: 900,
            height: 500,
            repositoryName: repositoryName
        });
    };
    return ChangesetDialog;
})(AJS.$, AJS.template);
/*[{!changeset_dialog_js_w87j52i!}]*/;
/* END /2static/script/fe/commitgraph/changeset-dialog.js */
/* START /2static/script/fe/commitgraph/models/edge.js */
FE.VIS.Edge = (function () {

    /*
     * @param parent - the parent Changeset object this edge connects with
     * @param child - the child Changeset object this edge connects with
     */
    var Edge = function (parentChangeset, childChangeset, parentBranchRevision, childBranchRevision) {
        this.parentChangeset = parentChangeset;
        this.childChangeset = childChangeset;
        this.parentBranchRevision = parentBranchRevision;
        this.childBranchRevision = childBranchRevision;
    };

    Edge.prototype.hasSparseEndpoint = function () {
        return this.childChangeset.isSparse() || this.parentChangeset.isSparse();
    };

    return Edge;
})();
/*[{!edge_js_5s3a53a!}]*/;
/* END /2static/script/fe/commitgraph/models/edge.js */
/* START /2static/script/fe/commitgraph/models/branch-revision.js */
FE.VIS.BranchRevision = (function ($) {

    // Imports
    var Edge = FE.VIS.Edge;
    var decorators = FECRU.DECORATORS;
    var memoize = decorators.memoize;
    var eraseMemoized = decorators.eraseMemoized;

    var BranchRevision = function (cs, branch) {
        this.id = branch.name + cs.id;
        this.changeset = cs;
        this.primaryBranch = branch;
        this.parentEdges = undefined;
        this.childEdges = undefined;
        this.branchPosition = NaN;
    };

    BranchRevision.prototype.setGroup = function (group) {
        this.group = group;
    };

    /*
     * A READ-ONLY array of this branch revision's direct parents.
     */
    BranchRevision.prototype.parents = function () {
        return this.parentEdges ?
            $.map(this.parentEdges, function (edge) {
                return edge.parentBranchRevision;
            }) :
            [];
    };
    memoize(BranchRevision.prototype, "parents");

    /*
     * A READ-ONLY array of this branch revision's direct children.
     */
    BranchRevision.prototype.children = function () {
        return this.childEdges ?
            $.map(this.childEdges, function (edge) {
                return edge.childBranchRevision;
            }) :
            [];
    };
    memoize(BranchRevision.prototype, "children");

    /*
     * A READ-ONLY array of this branch revision's direct parents.
     */
    BranchRevision.prototype.parentsOnBranch = function () {
        var primaryBranch = this.primaryBranch;
        return $.grep(this.parents(), function (parent) {
            return parent.primaryBranch === primaryBranch;
        });
    };
    memoize(BranchRevision.prototype, "parentsOnBranch");

    /*
     * A READ-ONLY array of this branch revision's direct children.
     */
    BranchRevision.prototype.childrenOnBranch = function () {
        var primaryBranch = this.primaryBranch;
        return $.grep(this.children(), function (child) {
            return child.primaryBranch === primaryBranch;
        });
    };
    memoize(BranchRevision.prototype, "childrenOnBranch");

    BranchRevision.prototype.isSparse = function () {
        return this.changeset.isSparse();
    };


    BranchRevision.prototype.isSparseAncestor = function () {
        return this.changeset.isSparseAncestor();
    };

    BranchRevision.prototype.isSparseDescendant = function () {
        return this.changeset.isSparseDescendant();
    };

    BranchRevision.prototype.isLive = function () {
        return this.changeset.isLive();
    };

    BranchRevision.prototype.addParentEdge = function (newEdge) {
        if (newEdge.childBranchRevision !== this) {
            throw "Cannot add this edge as parent.  The edge's child is not this changeset.";
        }

        if (this.parentEdges) {
            //if it already has its parent set, do nothing.
            if (Array.any(this.parentEdges, function (edge) {
                    return edge.parentChangeset === newEdge.parentChangeset
                        && edge.parentBranchRevision === newEdge.parentBranchRevision;
                })) {
                return this;
            }
        } else {
            this.parentEdges = [];
        }

        // add the parent to this changeset's list of parents.
        this.parentEdges.push(newEdge);

        return this;
    };
    eraseMemoized(BranchRevision.prototype, "addParentEdge", ["parents", "parentsOnBranch"]);

    BranchRevision.prototype.addChildEdge = function (newEdge) {
        if (newEdge.parentBranchRevision !== this) {
            throw "Cannot add this edge as child.  The edge's parent is not this changeset.";
        }

        if (this.childEdges) {
            //if it already has its parent set, do nothing.
            if (Array.any(this.childEdges, function (edge) {
                    return edge.childChangeset === newEdge.childChangeset
                        && edge.childBranchRevision === newEdge.childBranchRevision;
                })) {
                return this;
            }
        } else {
            this.childEdges = [];
        }

        this.childEdges.push(newEdge);

        return this;
    };
    eraseMemoized(BranchRevision.prototype, "addChildEdge", ["children", "childrenOnBranch"]);

    BranchRevision.prototype.addParent = function (parentChangeset, parentBranchRevision) {
        var edge = new Edge(parentChangeset, this.changeset, parentBranchRevision, this);

        this.addParentEdge(edge);
        if (parentBranchRevision) {
            parentBranchRevision.addChildEdge(edge);
        }

        return this;
    };

    BranchRevision.prototype.addChild = function (childChangeset, childBranchRevision) {
        var edge = new Edge(this.changeset, childChangeset, this, childBranchRevision);

        this.addChildEdge(edge);
        if (childBranchRevision) {
            childBranchRevision.addParentEdge(edge);
        }

        return this;
    };

    return BranchRevision;
})(AJS.$);
/*[{!branch_revision_js_ml1n535!}]*/;
/* END /2static/script/fe/commitgraph/models/branch-revision.js */
/* START /2static/script/fe/commitgraph/models/changeset.js */
FE.VIS.Changeset = (function ($) {

    var State = {
        UNLOADED: {
            toString: function () {
                return "Unloaded";
            }
        },
        LOADED: {
            toString: function () {
                return "Loaded";
            }
        },
        LIVE: {
            toString: function () {
                return "Live";
            }
        },
        SPARSE: {
            toString: function () {
                return "Sparse";
            }
        }
    };

    // Imports
    var BranchRevision = FE.VIS.BranchRevision;

    // Public

    /*
     * @param id - a unique identifier for this changeset.
     */
    var Changeset = function (id) {
        this.id = id;
        this.parentChangesets = undefined;
        this.childChangesets = undefined;
        this.branchRevisions = undefined;
        this.timePosition = NaN;
        this.state = State.UNLOADED;
        this.metadataState = State.UNLOADED;
    };

    /* Static Methods */

    /* Prototype Methods */

    Changeset.prototype.compareTo = function (other) {
        // order is a string, so we can't just take the difference between orders.
        return other && other.order ? (
            this.order < other.order ? -1 :
                this.order > other.order ? 1 :
                    0
        ) :
            -Infinity;
    };

    /*
     * A READ-ONLY array of this changeset's direct parents.
     */
    Changeset.prototype.parents = function () {
        return this.parentChangesets ? this.parentChangesets.slice(0) : [];
    };

    /*
     * A READ-ONLY array of this changeset's direct children.
     */
    Changeset.prototype.children = function () {
        return this.childChangesets ? this.childChangesets.slice(0) : [];
    };

    Changeset.prototype.isUnloaded = function () {
        return this.state === State.UNLOADED;
    };

    Changeset.prototype.isMetadataLoaded = function () {
        return this.metadataState === State.LOADED;
    };

    Changeset.prototype.isLive = function () {
        return this.state === State.LIVE;
    };

    Changeset.prototype.isSparse = function () {
        return this.state === State.SPARSE;
    };

    Changeset.prototype.isSparseAncestor = function () {
        return this.isSparse() && this.primaryBranches && this.primaryBranches.length > 0 && this.hasLiveChild();
    };

    Changeset.prototype.isSparseDescendant = function () {
        return this.isSparse() && this.primaryBranches && this.primaryBranches.length > 0 && this.hasLiveParent();
    };

    Changeset.prototype.isSparseOnBranch = function () {
        return this.isSparse() && (!this.primaryBranches || this.primaryBranches.length === 0);
    };

    Changeset.prototype.load = function (data, branchManager) {
        data = data || {};
        //this.date = data.date && (Date.parse(data.date) || typeof data.date === "number") ? new Date(data.date) : undefined;
        this.order = data.position;
        this.branches = data.branches || [];
        this.tags = data.tags || [];

        this.primaryBranches = this.branches && branchManager.getPrimaryBranches(this.branches);

        this.branchRevisions = [];
        var self = this;
        Array.each(this.primaryBranches, function (primaryBranch) {
            self.branchRevisions.push(new BranchRevision(self, primaryBranch));
        });

        this.author = {};

        this.state = State.LOADED;
    };

    Changeset.prototype.loadMetadata = function (data) {
        this.date = data.date;
        this.author = data.user;
        this.comment = data.comment;

        this.metadataState = State.LOADED;
    };

    Changeset.prototype.setSlice = function (slice) {
        this.slice = slice;
    };

    Changeset.prototype.makeSparse = function () {
        if (this.isUnloaded()) {
            throw "changeset must have data loaded before making it sparse"
        }

        this.state = State.SPARSE;
    };

    Changeset.prototype.makeLive = function () {
        if (this.isUnloaded()) {
            throw "changeset must have data loaded before making it live"
        }
        this.state = State.LIVE;
    };

    Changeset.prototype.dispose = function () {
        if (!this.isSparse()) {
            throw "Cannot dispose non-sparse changeset";
        }

        delete this.parentEdges;
        delete this.childEdges;
    };

    /*
     * returns whether this changeset is linked to any loaded parents
     */
    Changeset.prototype.hasLiveParent = function () {
        return this.parentChangesets && Array.any(this.parentChangesets, function (parent) {
                return parent.isLive();
            });
    };

    // returns whether this changeset is linked to any loaded children
    Changeset.prototype.hasLiveChild = function () {
        return this.childChangesets && Array.any(this.childChangesets, function (child) {
                return child.isLive();
            });
    };

    Changeset.prototype.isDisposable = function () {
        return this.isSparse() && !(this.hasLiveParent() || this.hasLiveChild());
    };

    Changeset.prototype.addParent = function (newParent) {
        if (this.parentChangesets) {
            if ($.inArray(newParent, this.parentChangesets) !== -1) {
                return this;
            }
        } else {
            this.parentChangesets = [];
        }

        if (!newParent.childChangesets) {
            newParent.childChangesets = [];
        }

        this.parentChangesets.push(newParent);
        newParent.childChangesets.push(this);

        return this;
    };

    Changeset.prototype.getBranchRevision = function (branch) {
        return Array.first(this.branchRevisions, function (brev) {
                return brev.primaryBranch === branch;
            }) || null;
    };

    function findMatchingBranchRevision(parentChangeset, primaryBranch) {
        // If there is only one parentBranchRevision, it must link to that. Otherwise we try and find the one
        // on the same branch as our branchRevision
        return parentChangeset.branchRevisions.length === 1 ?
            parentChangeset.branchRevisions[0] :
            parentChangeset.getBranchRevision(primaryBranch);
    }

    Changeset.prototype.resolveParents = function () {
        var branchRevision;
        var primaryBranch;
        var parents = this.parentChangesets;

        if (!parents || !parents.length) {
            return;
        }

        var unresolved = parents.slice(0);
        var branchRevisions = this.branchRevisions;

        // We want to return quickly for SCMs other than SVN. The will have a 1-1 relationship betweem changeset->
        if (branchRevisions.length === 1) {
            branchRevision = branchRevisions[0];
            primaryBranch = branchRevision.primaryBranch;
            // We know that all the parents should link to a branchRevision and because there is only one
            // We try and associate all the parents with it
            Array.each(parents, function (parentChangeset) {

                var parentBranchRevision = findMatchingBranchRevision(parentChangeset, primaryBranch);

                // Only add the edge if we could figure out the parentBranchRevision
                // This will only be falsy in SVN
                if (parentBranchRevision) {
                    branchRevision.addParent(parentChangeset, parentBranchRevision);
                }
            });
        } else {
            // We first want to loop over every comment
            Array.each(branchRevisions, function (branchRevision) {
                var parentChangeset;
                var parentBranchRevision;
                var primaryBranch = branchRevision.primaryBranch;

                // Use simple logic if we can
                if (parents.length === 1) {

                    parentChangeset = parents[0];
                    parentBranchRevision = findMatchingBranchRevision(parentChangeset, primaryBranch);

                    if (parentBranchRevision) {
                        branchRevision.addParent(parentChangeset, parentBranchRevision);
                    }

                } else {
                    // If we have multiple branchRevisions and multiple parents, we want to try and match
                    // branchRevisions with the changeset with the highest order with a matching primaryBranch
                    var parentsOnBranch = $.grep(parents, function (parent) {
                        return !!parent.getBranchRevision(primaryBranch)
                    });

                    // If we have a match
                    if (parentsOnBranch.length) {

                        // Sort them in reverse order. the highest changeset will be the first
                        parentsOnBranch.sort(function (a, b) {
                            return -a.compareTo(b);
                        });
                        parentChangeset = parentsOnBranch[0];

                        // We already know that there will be a matching bRev for the primary branch
                        // Due to the .grep above
                        parentBranchRevision = parentChangeset.getBranchRevision(primaryBranch);
                        branchRevision.addParent(parentChangeset, parentBranchRevision);

                        // Remove it from the unresolved list.
                        var i = $.inArray(parentChangeset, unresolved);
                        if (i !== -1) {
                            Array.remove(unresolved, i);
                        }
                    }
                }
            });

            // There are some things we just can't match. This is a logical deduction to try and match the
            // last parent with the last branchRevision
            if (unresolved.length === 1) {
                var branchRevisionsWithoutParent = $.grep(branchRevisions, function (brev) {
                    return brev.parents().length === 0
                });
                if (branchRevisionsWithoutParent.length === 1) {
                    // I haz a match
                    branchRevision = branchRevisionsWithoutParent[0];
                    primaryBranch = branchRevision.primaryBranch;
                    var parentChangeset = unresolved[0];
                    var parentBranchRevision = findMatchingBranchRevision(parentChangeset, primaryBranch);

                    if (parentBranchRevision) { // Only add it if the parent exists
                        branchRevision.addParent(parentChangeset, parentBranchRevision);
                    }

                }
            }
        }
    };

    Changeset.prototype.addChild = function (child) {
        child.addParent(this);
        return this;
    };

    return Changeset;
})(AJS.$);
/*[{!changeset_js_p74b539!}]*/;
/* END /2static/script/fe/commitgraph/models/changeset.js */
/* START /2static/script/fe/commitgraph/models/changeset-group.js */
/*
 * A ChangesetGroup represents a named branch within a given ChangesetDAGSlice. All commits
 * for that branch within the current slice's range of "commit order" should be contained here.
 * */
FE.VIS.ChangesetGroup = (function ($) {

    /*
     * @param branch - the branch that this group is part of
     * @param slice - the slice object that this group is part of.
     */
    var ChangesetGroup = function (branch, slice) {
        this.branch = branch;
        this.element = null;
        this.branchRevisions = [];
        this.internalEdges = undefined;
        this.externalEdges = undefined;

        this.slice = slice;

        this.dirty = true;
    };
    ChangesetGroup.prototype.addBranchRevision = function (branchRevision) {
        this.branchRevisions.push(branchRevision);
        branchRevision.setGroup(this);
    };
    /*
     * sort an edge into the internalEdges array or the externalEdges array based on whether
     * otherChangeset is contained in internalBranchRevisions.
     * @param edge - the edge to be sorted.  One end should point to a changeset within this
     *          Group, and the other end should point to otherChangeset
     * @param otherChangeset - check this changeset and see if it's also within this Group
     * @param internalBranchRevisions - a list of branch revisions in this group
     * @param externalEdges - a list of edges that link branch revisions in this Group to ones in other Groups.
     * @param internalEdges - a list of edges that link branch revisions in this Group to other branch revisions in this Group.
     */
    function classifyEdgeType(edge, otherBranchRevision, internalBranchRevisions, externalEdges, internalEdges) {
        if ($.inArray(otherBranchRevision, internalBranchRevisions) === -1) { // if the other end is outside, add to external edges
            if ($.inArray(edge, externalEdges) === -1) {
                externalEdges.push(edge);
            }
        } else { // otherwise add it internally
            if ($.inArray(edge, internalEdges) === -1) {
                internalEdges.push(edge);
            }
        }
    }

    ChangesetGroup.prototype.updateEdgeLevels = function () {
        var branchRevisions = this.branchRevisions;
        var externalEdges = this.externalEdges = [];
        var internalEdges = this.internalEdges = [];

        Array.each(branchRevisions, function (branchRevision) {
            if (branchRevision.parentEdges) {
                Array.each(branchRevision.parentEdges, function (edge) {
                    classifyEdgeType(edge, edge.parentBranchRevision, branchRevisions, externalEdges, internalEdges);
                });
            }
            if (branchRevision.childEdges) {
                Array.each(branchRevision.childEdges, function (edge) {
                    classifyEdgeType(edge, edge.childBranchRevision, branchRevisions, externalEdges, internalEdges);
                });
            }
        });
    };

    ChangesetGroup.prototype.getType = function () {
        return "Group";
    };

    ChangesetGroup.prototype.getAllBranchRevisions = function () {
        return this.branchRevisions.slice(0);
    };

    ChangesetGroup.prototype.dispose = function () {
        Array.each(this.branchRevisions, function (branchRevision) {
            branchRevision.dispose(); // necessary?
        });
        delete this.branchRevisions;
        delete this.internalEdges;
        delete this.externalEdges;
    };

    return ChangesetGroup;
})(AJS.$);
/*[{!changeset_group_js_tvdw538!}]*/;
/* END /2static/script/fe/commitgraph/models/changeset-group.js */
/* START /2static/script/fe/commitgraph/models/changeset-dag-slice.js */
/*
 * A ChangesetDAGSlice represents commits within an arbitrary range of "commit order".
 * "commit order" is measured generally through the commit date, with modifications
 * by the server for consistency. It contains a list of ChangesetGroups that represent
 * all displayed branches.
 */
FE.VIS.ChangesetDAGSlice = (function ($) {

    // Imports
    var VIS = FE.VIS;
    var ChangesetGroup = VIS.ChangesetGroup;
    var Map = FECRU.DATA_STRUCTURES.Map;
    var memoize = FECRU.DECORATORS.memoize;
    var eraseMemoized = FECRU.DECORATORS.eraseMemoized;

    // Public

    /*
     * @param dag - the ChangesetDAG object that this slice is part of.
     */
    var ChangesetDAGSlice = function (dag) {
        this.changesetGroupsByBranch = new Map();
        this.changesetGroups = [];
        this.changesets = [];
        this.dirtyPositions = true;
        this.interGroupEdges = undefined;
        this.externalEdges = undefined;
        this.element = undefined;
        this.timePosition = 0;
        this.length = undefined;

        this.dirty = true;

        this.dag = dag;
    };

    function setGroups(slice, branchSet) {
        Array.each(branchSet.getAllBranches(), function (branch) {
            var newGroup = new ChangesetGroup(branch, slice);
            slice.changesetGroups.push(newGroup);
            slice.changesetGroupsByBranch.set(branch.name, newGroup);
        });
    }

    ChangesetDAGSlice.prototype.getGroup = function (branch) {
        return this.changesetGroupsByBranch.get(branch.name);
    };
    ChangesetDAGSlice.prototype.updateEdgeLevels = function () {
        var externalEdges = this.externalEdges = [];
        var interGroupEdges = this.interGroupEdges = [];

        function eachGroupExternalEdge(edge) {
            var interSliceIndex = $.inArray(edge, externalEdges);
            if (interSliceIndex === -1) { // first group where this edge was external to the group
                externalEdges.push(edge); //assume external to the slice also.
            } else { // we've found the other endpoint of the edge within the slice.
                interGroupEdges.push(edge);
                Array.remove(externalEdges, interSliceIndex);
            }
        }

        Array.each(this.changesetGroups, function (group) {
            group.updateEdgeLevels();
            Array.each(group.externalEdges, eachGroupExternalEdge);
        });
    };
    ChangesetDAGSlice.prototype.getAllChangesets = function (reverseOrder) {
        var ret = this.changesets.slice(0);
        var sign = reverseOrder ? -1 : 1;

        ret.sort(function (a, b) {
            return sign * a.compareTo(b);
        });
        return ret;
    };

    ChangesetDAGSlice.prototype.dispose = function () {
        if (this.element) {
            throw "Hide the slice before disposing it.";
        }

        for (var i = this.changesetGroups.length - 1; i >= 0; i--) {
            this.changesetGroups[i].dispose();
        }
        delete this.interGroupEdges;
        delete this.changesetGroups;
        delete this.changesetGroupsByBranch;
        delete this.externalEdges;
    };

    ChangesetDAGSlice.prototype.getType = function () {
        return "Slice";
    };

    ChangesetDAGSlice.prototype.getLength = function () {
        return this.length;
    };
    memoize(ChangesetDAGSlice.prototype, 'getLength');

    ChangesetDAGSlice.prototype.getBreadth = function () {
        return Array.reduce(this.changesetGroups, 0, function (base, group) {
            return base + group.branch.breadth;
        });
    };
    memoize(ChangesetDAGSlice.prototype, 'getBreadth');

    ChangesetDAGSlice.prototype.load = function (branchSet, changesets) {
        setGroups(this, branchSet);
        var slice = this;
        Array.each(changesets, function (cs) {
            Array.each(cs.branchRevisions, function (brev) {
                slice.getGroup(brev.primaryBranch).addBranchRevision(brev);
            });
            slice.changesets.push(cs);
            cs.setSlice(slice);
        });
        this.length = changesets.length;

        this.updateEdgeLevels();
    };
    eraseMemoized(ChangesetDAGSlice.prototype, 'load', ['getLength', 'getBreadth']);

    return ChangesetDAGSlice;
})(AJS.$);
/*[{!changeset_dag_slice_js_bjah536!}]*/;
/* END /2static/script/fe/commitgraph/models/changeset-dag-slice.js */
/* START /2static/script/fe/commitgraph/models/changeset-dag.js */
FE.VIS.ChangesetDAG = (function ($) {

    // Imports
    var VIS = FE.VIS;
    var ChangesetDAGSlice = VIS.ChangesetDAGSlice;
    var Changeset = VIS.Changeset;
    var Vector = Shapes.Vector;
    var Map = FECRU.DATA_STRUCTURES.Map;
    var memoize = FECRU.DECORATORS.memoize;
    var eraseMemoized = FECRU.DECORATORS.eraseMemoized;

    var decimalPattern = /^[0-9]+$/;

    function isDecimalString(str) {
        return decimalPattern.test(str);
    }

    // Public

    /*
     * @param branchManager - an object with the methods getBranchSet and getPrimaryBranch.
     * @param settings - an object containing relevant settings.
     */
    var ChangesetDAG = function (branchManager, settings, positioner) {
        this.changesetsById = new Map();
        this.dagSlices = [];
        this.interSliceEdges = [];
        this.sparseDescendants = new Map();
        this.sparseAncestors = new Map();
        this.sparseOnBranch = new Map();
        this.branchManager = branchManager;
        this.positioner = positioner;
        this.positioningData = {};

        this.element = null;
        this.translation = new Vector(0, 0);
        this.settings = settings;
    };
    ChangesetDAG.prototype.addInterSliceEdges = function (edges) {
        var interSliceEdges = this.interSliceEdges;
        Array.each(edges, function (edge) {
            if ($.inArray(edge, interSliceEdges) === -1) {
                interSliceEdges.push(edge);
            }
        });
    };

    ChangesetDAG.prototype.createChangesets = function (data) {
        // Cache values
        var changesetsById = this.changesetsById;
        var sparseAncestors = this.sparseAncestors;
        var sparseDescendants = this.sparseDescendants;
        var sparseOnBranch = this.sparseOnBranch;
        var dag = this;

        var newLiveChangesets = [];
        var newSparse = [];
        var newSparseAncestors = [];
        var newSparseDescendants = [];
        var newSparseOnBranch = [];
        var changesetData = data.changesets || data.revisions;
        var sparseData = data.sparseChangesets || data.sparseRevisions;

        if (!changesetData && !sparseData) {
            throw "Invalid data format.  Must include 'revisions' and 'sparseRevisions' properties.";
        }

        if (changesetData) {
            Array.each(changesetData, function (csData) {
                var csId = csData.id || csData.csid;
                var cs = null;

                if (changesetsById.has(csId)) {
                    cs = changesetsById.get(csId);
                    if (cs.isSparse()) {
                        cs.makeLive();
                        sparseAncestors.remove(csId);
                        sparseDescendants.remove(csId);
                        newLiveChangesets.push(cs);
                    }
                } else {
                    cs = new Changeset(csId);
                    cs.load(csData, dag.branchManager);
                    cs.makeLive();

                    changesetsById.set(csId, cs);
                    newLiveChangesets.push(cs);
                }
            });
        }

        if (sparseData) {
            Array.each(sparseData, function (csData) {
                var csId = csData.id || csData.csid;
                if (!changesetsById.has(csId)) {
                    var cs = new Changeset(csId);
                    cs.load(csData, dag.branchManager);
                    cs.makeSparse();

                    changesetsById.set(csId, cs);
                    newSparse.push(cs);
                }
            });
        }

        //link them to parent/child changesets.
        if (changesetData) {
            Array.each(changesetData, function (csData) {
                var cs = changesetsById.get(csData.id || csData.csid);
                Array.each(csData.parents, function (parentId) {
                    if (changesetsById.has(parentId)) {
                        cs.addParent(changesetsById.get(parentId));
                    }
                });
                Array.each(csData.children, function (childId) {
                    if (changesetsById.has(childId)) {
                        changesetsById.get(childId).addParent(cs);
                    }
                });
            });
        }

        Array.each(newSparse, function (cs) {
            // if we're showing this changeset's branch, it's a descendent or ancestor
            if (cs.primaryBranches && cs.primaryBranches.length > 0) {
                if (cs.hasLiveParent()) {
                    sparseDescendants.set(cs.id, cs);
                    newSparseDescendants.push(cs);
                } else if (cs.hasLiveChild()) {
                    sparseAncestors.set(cs.id, cs);
                    newSparseAncestors.push(cs);
                }
            } else { // otherwise, it's on a skipped branch.
                sparseOnBranch.set(cs.id, cs);
                newSparseOnBranch.push(cs);
            }
        });
        function resolveParents(cs) {
            cs.resolveParents();
        }

        Array.each(newLiveChangesets, resolveParents);
        Array.each(newSparse, resolveParents);

        return {
            newLiveChangesets: newLiveChangesets,
            newSparseAncestors: newSparseAncestors,
            newSparseDescendants: newSparseDescendants,
            newSparseOnBranch: newSparseOnBranch
        };
    };

    ChangesetDAG.prototype.getType = function () {
        return "Graph";
    };


    ChangesetDAG.prototype.getLength = function () {
        return Array.reduce(this.dagSlices, 0, function (base, slice) {
            return base + slice.length;
        });
    };
    memoize(ChangesetDAG.prototype, 'getLength');

    ChangesetDAG.prototype.getBreadth = function () {
        return Array.reduce(this.branchManager.getBranchSet().getAllBranches(), 0, function (base, branch) {
            return base + branch.breadth;
        });
    };
    memoize(ChangesetDAG.prototype, 'getBreadth');

    /**
     * Load multiple slices of changesets across multiple branches.
     * @param data data in the format { changesets: [changesetData...], sparseChangesets: [changesetData...]  }
     * @param atEnd load at the end of time. Positioning based off ancestors
     */
    ChangesetDAG.prototype.loadSlices = function (data, atEnd) {
        var ret = this.createChangesets(data);
        var newLiveChangesets = ret.newLiveChangesets;
        var newSparseAncestors = ret.newSparseAncestors;
        var newSparseDescendants = ret.newSparseDescendants;
        var newSparseOnBranch = ret.newSparseOnBranch;
        var newSlices = [];
        var dag = this;

        atEnd = !!atEnd;

        var sign = atEnd ? 1 : -1;
        newLiveChangesets.sort(function (a, b) {
            return sign * a.compareTo(b);
        });

        var slice;
        var sliceChangesets;
        var existingSlices = this.dagSlices;
        var neighbor;

        if (existingSlices.length) {
            neighbor = atEnd ?
                existingSlices[existingSlices.length - 1] :
                existingSlices[0];
        } else {
            neighbor = null;
        }

        for (var i = 0, length = newLiveChangesets.length, sliceSize = this.settings.maxSliceSize;
             i < length;
             i += sliceSize) {
            sliceChangesets = newLiveChangesets.slice(i, i + sliceSize);

            slice = new ChangesetDAGSlice(dag);
            slice.load(dag.branchManager.getBranchSet(), sliceChangesets, atEnd);

            if (atEnd) {
                this.dagSlices.push(slice);
            } else {
                this.dagSlices.unshift(slice);
            }

            newSlices.push(slice);
            this.addInterSliceEdges(slice.externalEdges);
        }

        this.positioner.positionNewSlices(
            newSlices,
            newSparseAncestors,
            newSparseDescendants,
            newSparseOnBranch,
            this.positioningData,
            neighbor,
            atEnd);

        var newIds = [];
        Array.each(newLiveChangesets, function (cs) {
            newIds.push(cs.id);
        });
        return newIds;

    };
    eraseMemoized(ChangesetDAG.prototype, 'loadSlices', ['getLength', 'getBreadth']);

    ChangesetDAG.prototype.updateMetadata = function (changesets) {
        var changesetsById = this.changesetsById;
        Array.each(changesets, function (changesetData) {
            if (changesetsById.has(changesetData.csid)) {
                var cs = changesetsById.get(changesetData.csid);
                cs.loadMetadata(changesetData);
            }
        });

    };

    ChangesetDAG.prototype.getFirstChangeset = function () {
        var slices = this.dagSlices;
        if (slices.length) {
            var changesets = slices[0].getAllChangesets();
            if (changesets.length) {
                return changesets[0];
            }
        }
        return null;
    };
    ChangesetDAG.prototype.getLastChangeset = function () {
        var slices = this.dagSlices;
        if (slices.length) {
            var changesets = slices[slices.length - 1].getAllChangesets();
            if (changesets.length) {
                return changesets[changesets.length - 1];
            }
        }
        return null;
    };

    ChangesetDAG.prototype.getAllChangesets = function () {
        return this.changesetsById.getValues();
    };

    ChangesetDAG.prototype.findChangesetById = function (id) {
        return this.changesetsById.get(id);
    };

    ChangesetDAG.prototype.findChangesetByIdOrTag = function (idOrTag) {
        // If we have an exact match, return it
        var changeset = this.findChangesetById(idOrTag);
        if (changeset && changeset.isLive()) {
            return changeset;
        }

        // Otherwise try and find a partial match of an id or match a tag
        var changesets = this.getAllChangesets();
        return Array.first(changesets, function (cs) {
                return cs.isLive() &&
                    ($.inArray(idOrTag, cs.tags) !== -1 ||
                    (!isDecimalString(idOrTag) && cs.id.substr(0, idOrTag.length) === idOrTag));
            }) || null;
    };

    return ChangesetDAG;
})(AJS.$);
/*[{!changeset_dag_js_7w1f537!}]*/;
/* END /2static/script/fe/commitgraph/models/changeset-dag.js */
/* START /2static/script/fe/commitgraph/project-visualiser.js */
FE.VIS.ProjectVisualiser = (function ($, templateFactory) {

    // Imports
    var VIS = FE.VIS;
    var DRAWING = VIS.DRAWING;
    var Configuration = FE.VIS.Configuration;
    var PERMALINK_THROTTLE = Configuration.PERMALINK_THROTTLE;
    var AJAX = FECRU.AJAX;
    var EventProducer = FECRU.MIXINS.EventProducer;
    var createGraphView = DRAWING.createGraphView;
    var EdgeProximityEvent = DRAWING.EdgeProximityEvent;
    var ChangesetDAG = VIS.ChangesetDAG;
    var ChangesetDialog = FE.VIS.ChangesetDialog;
    var BranchSet = VIS.BranchSet;
    var BranchHeader = VIS.BranchHeader;
    var Vector = Shapes.Vector;
    var HighlightContext = FE.VIS.HIGHLIGHTS.HighlightContext;
    var defaultPositioner = FE.VIS.POSITIONING.defaultPositioner;
    var Fragment = VIS.Fragment;

    // Private


    var defaultSettings = {
        "maxSliceSize": 50, // when loading data, it will be split into multiple slices
                           // if more than this many changesets are given.
        "orientation": 'vertical',
        "dataUrl": "",
        "metadataUrl": "",
        "scrollToCsid": null,
        "focusCsid": null,
        "preloadBuffer": 250, // if we get with this many changesets of The Unknown, load some more.
        "initialPreload": 100, // load this many changesets initially.
        "changesetsPerLoad": 250 // every request after the first, load this many changesets
    };

    // Public
    /*
     * @param target - the drawing target on which to render the changeset graph.
     * @param settings - object containing any settings you want to override.
     */
    var ProjectVisualiser = function (target, $metadataContainer, positioner, settings) {
        if (settings && settings.repositoryType === "SVN") {
            var self = this;
            this.getPrimaryBranches = function (branches) {
                return getPrimaryBranchesForSvn(self.branchSet, branches);
            };
        }
        this.target = target;
        this.positioner = positioner;
        this.$metadataContainer = $metadataContainer && $metadataContainer.length === 1 ? $metadataContainer : null;
        this.setSettings(settings);
    };

    $.extend(ProjectVisualiser.prototype, EventProducer);
    ProjectVisualiser.HighlightRegistered = "HighlightRegistered";
    ProjectVisualiser.DataLoaded = "DataLoaded";
    ProjectVisualiser.DataUnloaded = "DataUnloaded";

    ProjectVisualiser.prototype.setSettings = function (settings) {
        this.settings = settings = $.extend({}, defaultSettings, settings || {});
    };

    ProjectVisualiser.prototype.initialize = function (settings) {
        //reset the settings so that
        settings && this.setSettings(settings);

        this.initializeHighlighters();


        this.initializeData();

        if (this.branchSet.isAllInOne() || this.branchSet.getBranchNames().length) {

            this.initializeUi();
            this.doInitialLoad();
        } else {
            var self = this;
            $("#visualiser")
                .children('.dag, .metadata-wrapper')
                .addClass('hidden')
                .end()
                .append(templateFactory.load("branch-mode").toString())
                .delegate('.option-select-branches', 'click', function () {
                    $("#branch-modifier").click();
                })
                .delegate('.option-all-branches', 'click', function () {
                    self.branchSet.saveBranches(self.branchSet.getBranchNames(), true);
                })
                .delegate('.option-recently-active', 'click', function () {
                    self.branchSet.saveBranches(null, false);
                });
        }
    };

    ProjectVisualiser.prototype.initializeData = function () {
        var settings = this.settings;

        var branchSet = new BranchSet(settings.branches || [], settings.branchMode === 'ALL', settings);
        this.setBranchSet(branchSet);

        this.dag = new ChangesetDAG(this, settings, this.positioner);

        this.dataLoadingTracker = {
            reachedBeginning: false,
            reachedEnd: false,
            alreadyLoadingFuture: false,
            alreadyLoadingPast: false,
            canLoadFuture: function () {
                return !this.reachedEnd && !this.alreadyLoadingFuture;
            },
            canLoadPast: function () {
                return !this.reachedBeginning && !this.alreadyLoadingPast;
            }
        };
    };

    /**
     * Method that updates the permalink. This is debounced so that it can be
     * repeatedly invoked in an event handler without causing choking.
     */
    var updatePermalink = $.debounce(PERMALINK_THROTTLE, function (visualiser) {
        visualiser.$permalink && visualiser.$permalink.attr('href', visualiser.getPermalinkUrl());
    });

    ProjectVisualiser.prototype.initializeUi = function () {

        if (this.dagView) {
            this.dagView.destroy();
            this.dagView = undefined;
        }

        // positive time is either toward +x or -y.
        var isPositiveTimeDirection = this.settings.orientation === 'horizontal';

        var $metadataContainer = this.$metadataContainer;
        var target = this.target;
        var self = this;

        this.dagView = createGraphView(
            this.dag,
            this.target,
            this.$metadataContainer,
            this.settings.orientation,
            isPositiveTimeDirection
        );


        // don't rebind events if this is our second time through.
        if (!this.initializedUi) {
            // The number of pixels to scroll per mousewheel delta (should match native browser scroll).
            // Firefox likes it slower than others.
            var mouseWheelPx = $.browser.mozilla ? 120 * 2 / 5 : 120;

            /* Safari + SVG + mousewheel events don't work, so also trigger on the HTML wrapper element. */
            var $mouseWheelElements = $(target.getElement()).add('.dag');

            // tools actions need to stop the click from propagating as to not click on underlying metadata
            $(self.$metadataContainer).delegate(".aui-dropdown", "click", function (e) {
                e.stopPropagation();
            });

            $("#goto")
                .placeholder("Enter changeset ID or tag")
                .bind('keydown', function (event) {
                    if (event.which === $.ui.keyCode.ENTER) { //the enter key
                        event.preventDefault();
                        event.stopPropagation();

                        var tagOrId = $.trim($(this).val());

                        if (tagOrId.length) {
                            var changeset = self.dag.findChangesetByIdOrTag(tagOrId);

                            if (changeset) {
                                self.dagView.translateTo(changeset);
                                self.dagView.setFocus(self.dagView.context.highlightContext.getChangeset(changeset));
                            } else {
                                window.location.href = FECRU.NAVBUILDER.graphAtChangeset(self.settings.repositoryName, tagOrId);
                            }

                        }
                    }
                });

            var onMouseWheel;
            if (!$metadataContainer) {
                onMouseWheel = function (e, delta) {
                    self.dagView.translate(new Vector(0, delta * mouseWheelPx));
                    updatePermalink(self);

                    return false;
                };
            } else {
                onMouseWheel = function (e, delta) {
                    $metadataContainer.scrollTop($metadataContainer.scrollTop() - delta * mouseWheelPx);

                    return false;
                };
            }

            $mouseWheelElements.mousewheel(onMouseWheel);

            if ($metadataContainer) {

                var lastScrollPos = {
                    x: $metadataContainer.scrollLeft(),
                    y: $metadataContainer.scrollTop()
                };

                $metadataContainer.bind('scroll', function () {

                    var scrollPos = {
                        x: $metadataContainer.scrollLeft(),
                        y: $metadataContainer.scrollTop()
                    };

                    // We want an inverse diff to prev. If we scroll down, the graph should go up
                    var delta = new Vector(lastScrollPos.x - scrollPos.x, lastScrollPos.y - scrollPos.y);
                    if (delta.x || delta.y) {
                        self.dagView.translate(delta);
                        updatePermalink(self);

                        lastScrollPos = scrollPos;
                    }
                });
            }
            this.changesetDialog = ChangesetDialog.create(self, self.settings.repositoryName);
        }

        this.initializedUi = true;
    };

    ProjectVisualiser.prototype.doInitialLoad = function () {
        var settings = this.settings;
        var self = this;

        // do initial data load
        var params = {
            direction: "around",
            size: settings.initialPreload
        };
        if (settings.scrollToCsid) {
            params.id = settings.scrollToCsid;
        }
        this.requestData(params, function () {
            self.dagView.init(params.id, settings.focusCsid);
            self.updatePermalink();
        });

        self.dagView.bind(EdgeProximityEvent, function (evt) {
            var pivot;
            var id;
            var params;

            if (evt.proximityToFutureHorizon < self.settings.preloadBuffer) {
                pivot = self.dag.getLastChangeset();
                id = pivot && pivot.id;
                params = {
                    direction: "after"
                };
                if (id) {
                    params.id = id;
                }
                self.requestData(params, null);
            }
            if (evt.proximityToPastHorizon < self.settings.preloadBuffer) {
                pivot = self.dag.getFirstChangeset();
                id = pivot && pivot.id;
                params = {
                    direction: "before"
                };
                if (id) {
                    params.id = id;
                }
                self.requestData(params, null);
            }
        });
    };

    ProjectVisualiser.prototype.initializeHighlighters = function () {
        var highlighterContextsById = []; // auto-incrementing 1-based id, AKA index == id + 1.
        var activeHighlightContext = null;
        var self = this;

        var getChangesetsForIds = function (csids) {
            return Array.map(csids, function (csid) {
                return activeHighlightContext.getChangeset(self.dag.findChangesetById(csid));
            })
        };

        this.bind(ProjectVisualiser.DataLoaded, function (event) {
            var changesetIds = event.changesetIds;
            if (activeHighlightContext && changesetIds.length) {
                activeHighlightContext.onDataLoaded(getChangesetsForIds(changesetIds));
            }
        });

        this.bind(ProjectVisualiser.DataUnloaded, function (event) {
            var changesetIds = event.changesetIds;
            if (activeHighlightContext && changesetIds.length) {
                activeHighlightContext.onDataUnloaded(getChangesetsForIds(changesetIds));
            }
        });

        this.registerHighlighters = function (highlighters) {
            var self = this;
            Array.each(highlighters, function (highlighter) {
                self.registerHighlighter(highlighter);
            });
        };

        this.registerHighlighter = function (highlighter) {
            var self = this;
            var highlightContext = new HighlightContext(highlighter);

            highlightContext.id = highlighterContextsById.push(highlightContext);
            this.trigger(ProjectVisualiser.HighlightRegistered, {
                name: highlighter.name,
                id: highlightContext.id
            });

            highlightContext.bind(HighlightContext.LoadingStarted, function () {
                $("#highlight-spinner").addClass("visible");
            });

            highlightContext.bind(HighlightContext.LoadingFinished, function () {
                $("#highlight-spinner").removeClass("visible");
            });

            highlightContext.bind(HighlightContext.RedrawRequested, function () {
                self.dagView.reHighlight();
            });

            //check for highlighters in the permalink, and set it if found. Otherwise,
            //sets up the initial selected highlighter from cookie. Defaults to Lineage
            var preferredHighlighterName = self.settings.hashFragment.getHighlighterName() || self.settings.highlighterName;
            var currentHighlighterName = highlightContext.highlighter.name;

            if (preferredHighlighterName === currentHighlighterName
                || currentHighlighterName === "Lineage") {
                this.$highlightSelector.val(highlightContext.id);
                this.setActiveHighlighter(highlightContext.id);
            }
            return highlightContext.id;
        };

        this.getHighlighterContext = function (id) {
            return highlighterContextsById[id - 1];
        };

        this.getHighlighter = function (id) {
            var context = this.getHighlighterContext(id);
            return context && context.highlighter;
        };

        /**
         * Returns an array of structs, each containing the highlighter id and the highlighter obj
         * e.g., [{id:1,{name:"highlighter1",...}},{id:2,{name:"highlighter2",...}},...}
         */
        this.getHighlighters = function () {
            return Array.map(highlighterContextsById, function (context) {
                return {id: context.id, highlighter: context.highlighter};
            });
        };

        this.setActiveHighlighter = function (id) {
            var newActive = this.getHighlighterContext(id);
            if (newActive && newActive !== activeHighlightContext) {
                var oldContext = activeHighlightContext;
                var focusedObject = oldContext && oldContext.focusedObject;

                oldContext && oldContext.onDeactivation();

                activeHighlightContext = newActive;

                var allChangesets;
                if (this.dag) {
                    allChangesets = Array.map(this.dag.getAllChangesets(), function (cs) {
                        return activeHighlightContext.getChangeset(cs);
                    })
                } else {
                    allChangesets = [];
                }

                // Convert focused object to new highlight context.
                if (focusedObject) {
                    focusedObject = focusedObject.isChangeset() ?
                        activeHighlightContext.getChangeset(focusedObject._model) :
                        activeHighlightContext.getEdge(focusedObject._model);
                }

                activeHighlightContext.onActivation(allChangesets, focusedObject);

                this.dagView && this.dagView.setHighlightContext(activeHighlightContext);
                updatePermalink(this);
                return activeHighlightContext.highlighter;
            } else {
                return undefined;
            }
        };
        this.getActiveHighlighter = function () {
            return activeHighlightContext && activeHighlightContext.highlighter;
        };

        //after the first initialize, reuse all the functions and just clear out the data.
        this.initializeHighlighters = function () {
            // This is a shortcut - we should really be marking all data as unloaded and reloaded.
            this.dagView && this.dagView.setHighlightContext(activeHighlightContext);
        };
    };

    /**
     * Saves to the cookie the given highlighter.
     * @param visualiser the visualiser object
     * @param highlighter
     */
    function doSaveHighlighterCookie(visualiser, highlighter) {
        if (highlighter) {
            AJAX.ajaxDo(visualiser.settings.saveBranchesUrl, {
                repoName: visualiser.settings.repositoryName,
                'vhl': '{"' +
                visualiser.settings.repositoryName + '":{' +
                'hl:"' + FECRU.quoteString(highlighter.name) + '"' +
                '}' +
                '}'
            });

            if (window.localStorage) {
                window.localStorage[FE.VIS.localStorageKeys(visualiser.settings.repositoryName).highlighter] = highlighter.name;
            }
        }
    }

    ProjectVisualiser.prototype.setHighlighterSelector = function ($select) {
        var self = this;
        var $oldSelector = this.$highlightSelector;

        this.$highlightSelector = $select;

        var addHighlight = function (highlightData) {
            $("<option>")
                .text(highlightData.name)
                .attr('value', highlightData.id)
                .appendTo($select);
        };
        $select.data('add-highlight-handler', addHighlight);
        this.bind(ProjectVisualiser.HighlightRegistered, addHighlight);
        this.getHighlighters && Array.each(this.getHighlighters(), function (highlighterData) {
            addHighlight({id: highlighterData.id, name: highlighterData.highlighter.name});
        });

        $select.change(function (e) {
            self.setActiveHighlighter && doSaveHighlighterCookie(self, self.setActiveHighlighter(e.target.value));
        });

        if ($oldSelector) {
            this.unbind(ProjectVisualiser.HighlightRegistered, $oldSelector.data('add-highlight-handler'))
        }
    };

    ProjectVisualiser.prototype.resize = function () {
        this.dagView && this.dagView.resize();
    };

    ProjectVisualiser.prototype.setLoading = function (loading) {
        var $container = this.$metadataContainer;

        var $spinner = $container.data("metadata-loading");
        if (loading) {
            // don't do anything if there is already a spinner running
            if (!$spinner) {
                $spinner = $("<div class='metadata-loading'>Loading...</div>");
                $container.prepend($spinner);
                $container.data("metadata-loading", $spinner);
            } else {
                $spinner.show();
            }
        } else {
            $spinner && $spinner.hide();
        }
    };


    ProjectVisualiser.prototype.loadMetadata = function (loadParams) {
        var self = this;
        self.setLoading(true);

        $.ajax({
            url: self.settings.metadataUrl,
            type: "POST",
            contentType: 'application/json',
            data: JSON.stringify(loadParams),
            success: function (data) {
                self.setLoading(false);
                self.dag.updateMetadata(data.changesets);
                self.dagView.reloadMetadata();
                self.trigger(ProjectVisualiser.DataLoaded, {
                    "changesetIds": Array.map(data.changesets, function (cs) {
                        return cs.csid;
                    })
                });
            },
            error: function (req) {
                displayError(req);
            }
        });
    };

    ProjectVisualiser.prototype.requestData = function (params, callback) {
        var self = this;
        var dataLoadingTracker = self.dataLoadingTracker;
        var onLoadSuccess = function (params, callback) {
            return function (data) {
                if (data.revisions && data.revisions.length) {

                    var oldBreadth = self.dag.getBreadth();
                    var newIds = self.dag.loadSlices(data, params.direction === 'after');
                    var breadthChanged = oldBreadth !== self.dag.getBreadth();

                    //only load new metadata if there are new ids loaded from this ajax call
                    newIds && newIds.length > 0 && self.loadMetadata({
                        id: newIds
                    });
                }

                if (data.revisions && data.revisions.length < params.size) {
                    if (params.direction === 'before') {
                        dataLoadingTracker.reachedBeginning = true;
                    } else if (params.direction === 'after') {
                        dataLoadingTracker.reachedEnd = true;
                    } else { // around
                        dataLoadingTracker.reachedBeginning = true;
                        dataLoadingTracker.reachedEnd = true;
                    }
                }

                if (params.direction === 'before') {
                    dataLoadingTracker.alreadyLoadingPast = false;
                } else if (params.direction === 'after') {
                    dataLoadingTracker.alreadyLoadingFuture = false;
                } else { // around
                    dataLoadingTracker.alreadyLoadingFuture = false;
                    dataLoadingTracker.alreadyLoadingPast = false;
                }

                var dagView = self.dagView;
                dagView.sync(breadthChanged);
                breadthChanged && dagView.resize();

                callback && callback();
            };
        };

        var defaults = {
            size: self.settings.changesetsPerLoad
        };

        if (!self.branchSet.isAllInOne()) {
            defaults.branch = self.branchSet.getBranchNames();
        }

        var ajaxParams = $.extend({}, defaults, params);

        if ((!dataLoadingTracker.canLoadPast() && ajaxParams.direction === 'before') ||
            (!dataLoadingTracker.canLoadFuture() && ajaxParams.direction === 'after') ||
            (!dataLoadingTracker.canLoadPast() && !dataLoadingTracker.canLoadFuture())) {
            return;
        }
        if (ajaxParams.direction === 'before' || ajaxParams.direction === 'around') {
            dataLoadingTracker.alreadyLoadingPast = true;
        }
        if (ajaxParams.direction === 'after' || ajaxParams.direction === 'around') {
            dataLoadingTracker.alreadyLoadingFuture = true;
        }

        $.ajax({
            url: self.settings.dataUrl,
            type: "GET",
            contentType: 'application/json',
            data: ajaxParams,
            success: onLoadSuccess(ajaxParams, callback),
            error: function (req, textStatus, errorThrown) {
                displayError(req);
            }
        });
    };

    /**
     * Displays an error dialog box. This method only handles errors that come from jersey's error response,
     * which contains a stacktrace property that we display.
     * @param req the request object from jquery's ajax 'onerror' callback handler. It should be a raw string, and should evaluate to
     * a json object with a stacktrace property
     */
    function displayError(req) {
        var resp = eval('(' + req.responseText + ')');
        if (resp.stacktrace) {
            FECRU.AJAX.appendErrorResponse(resp.stacktrace, false);
            FECRU.AJAX.showNotificationBox(resp.code + ": " + resp.message);
        }
    }

    /**
     * Reload the graph by reinitialising with the given newBranches
     * @param newBranches the set of branches to reload the graph with.
     */
    ProjectVisualiser.prototype.reload = function (newBranches) {
        //todo: this needs to reload at the same position/changeset
        var newSettings = $.extend(this.settings, {branches: newBranches});
        this.initialize(newSettings);
    };

    ProjectVisualiser.prototype.setBranchSet = function (branchSet) {
        var self = this;
        this.branchSet = branchSet;
        if (this.branchHeader) {
            this.branchHeader.setBranchSet(branchSet);
        }

        self.branchSet.bind(BranchSet.BranchesRemoved, function (event) {
            Array.each(event.removedBranches, function (branch) {
                self.branchSet.removeBranch(branch);
            });
            //persist the branchset after branch(es) are removed
            self.branchSet.saveBranches(event.visibleBranches, false);
        });

        self.branchSet.bind(BranchSet.BranchesAdded, function (event) {
            Array.each(event.addedBranches, function (branch) {
                self.branchSet.addBranch(branch);
            });
            //persist the branchset after branch(es) are added
            self.branchSet.saveBranches(event.visibleBranches, false);
        });

        self.branchSet.bind(BranchSet.BranchModified, function (event) {
            window.location.href = window.location.href.replace(/[\?#].*$/, ""); // page pop
        });

        self.branchSet.bind(BranchSet.BranchesReordered, function (event) {
            self.branchSet.saveBranches(event.branches, false);
        });
    };

    ProjectVisualiser.prototype.getBranchSet = function () {
        return this.branchSet;
    };

    ProjectVisualiser.prototype.setBranchHeaderContainer = function ($branchHeaderContainer) {
        this.branchHeader = new BranchHeader($branchHeaderContainer, this.branchSet, this.positioner);
    };

    ProjectVisualiser.prototype.getPrimaryBranches = function (branches) {
        if (this.branchSet.isAllInOne()) {
            return [this.branchSet.getAllInOne()];
        }
        var branch = Array.first(this.branchSet.getAllBranches(), function (branchInSet) {
            var name = branchInSet.name;
            return Array.any(branches, function (branchNameToCheck) {
                return name === branchNameToCheck;
            });
        });
        return branch ? [branch] : [];
    };

    ProjectVisualiser.prototype.getTopChangeset = function () {
        return this.positioner.getChangesetAtTimePosition(this.dag, Math.round(this.dagView.getScrolledToTimePosition()));
    };

    ProjectVisualiser.prototype.getBaseUrl = function () {
        return window.location.pathname;
    };

    ProjectVisualiser.prototype.updatePermalink = function () {
        this.$permalink && this.$permalink.attr('href', this.getPermalinkUrl());
    };

    ProjectVisualiser.prototype.getPermalinkUrl = function () {

        var topChangeset = this.getTopChangeset();
        var branches = this.branchSet.isAllInOne() ? undefined : this.branchSet.getBranchNames();
        var scrollToChangesetId = topChangeset ? topChangeset.id : undefined;
        var highlighter = this.getActiveHighlighter();
        var hashFragment = Fragment.create(branches, this.branchSet.isAllInOne(), undefined, highlighter && highlighter.name, scrollToChangesetId).asString();

        return hashFragment.length ? "#" + hashFragment : "";
    };

    ProjectVisualiser.prototype.setPermalinkElement = function (anchorSelector) {
        this.$permalink = $(anchorSelector);
    };

    /**
     * Create a new ProjectVisualiser
     * @param selector the selector of the visualisation
     * @param settings object of settings to override
     * @return a new instance of the ProjectVisualiser object
     */
    ProjectVisualiser.create = function (selector, settings) {
        var $projectVisualiser = $(selector);
        var $branchHeader = $projectVisualiser.children(".branch-header");
        var $highlightSelector = $('#highlight');
        var $dag = $projectVisualiser.children(".dag");
        var $metadataContainer = $projectVisualiser.children(".metadata-wrapper");

        settings = settings ? $.extend({}, settings) : {};

        var TargetClass = $.browser.msie && $.browser.version < 9 ? Targets.VML : Targets.SVG;
        var target = new TargetClass($dag[0]);

        if (/horizontal/.test(window.location.hash)) {
            settings.orientation = 'horizontal';
        } else {
            settings.orientation = 'vertical';
        }

        var pv = new ProjectVisualiser(target, $metadataContainer, defaultPositioner, settings);
        pv.initialize();
        pv.setBranchHeaderContainer($branchHeader);
        pv.setHighlighterSelector($highlightSelector);
        pv.setPermalinkElement("#visualisation-permalink");

        function setVisualisationHeight() {
            var $visualisationContent = $dag.add($metadataContainer);
            var $toolbar = $("#toolbar");

            var visHeight = parseInt(document.getElementById("columns").style.height, 10) // We want the actual style height not the computed height
                - $toolbar.outerHeight(true)
                - 2; // Some border somewhere which is fucking up Chrome and Safari.
            var contentHeight = visHeight - $branchHeader.outerHeight(true);

            $projectVisualiser.height(visHeight);
            $visualisationContent.height(contentHeight);
            pv.resize();
        }

        setVisualisationHeight();
        FECRU.UI.setCompletedResizeTimeout(window, setVisualisationHeight);

        return pv;
    };

    function getPrimaryBranchesForSvn(branchSet, branches) {
        if (branchSet.isAllInOne()) {
            return [branchSet.getAllInOne()];
        }
        var primaryBranches = [];
        Array.each(branchSet.getAllBranches(), function (branchInSet) {
            var name = branchInSet.name;
            if (Array.any(branches, function (branchNameToCheck) {
                    return name === branchNameToCheck;
                })) {
                primaryBranches.push(branchInSet);
            }
        });
        return primaryBranches;
    }

    return ProjectVisualiser;
})(AJS.$, AJS.template);


/*[{!project_visualiser_js_4bfv52n!}]*/;
/* END /2static/script/fe/commitgraph/project-visualiser.js */
