/* CONCAT of
/2static/script/lib/jquery/plugins/jquery.getscrollbarwidth.js
/2static/script/fe/json-hunks.js
/2static/script/fe/sbs-diff.js
/2static/script/fecru/issue-dialog.js
/2static/script/lib/ZeroClipboard-1.2.1.min.js
/2static/script/fecru/selection-history.js
*/
/* START /2static/script/lib/jquery/plugins/jquery.getscrollbarwidth.js */
/*! Copyright (c) 2008 Brandon Aaron (brandon.aaron@gmail.com || http://brandonaaron.net)
 * Dual licensed under the MIT (http://www.opensource.org/licenses/mit-license.php) 
 * and GPL (http://www.opensource.org/licenses/gpl-license.php) licenses.
 */

/**
 * Gets the width of the OS scrollbar
 */
(function($) {
	var scrollbarWidth = 0;
	$.getScrollbarWidth = function() {
		if ( !scrollbarWidth ) {
			if ( $.browser.msie ) {
				var $textarea1 = $('<textarea cols="10" rows="2"></textarea>')
						.css({ position: 'absolute', top: -1000, left: -1000 }).appendTo('body'),
					$textarea2 = $('<textarea cols="10" rows="2" style="overflow: hidden;"></textarea>')
						.css({ position: 'absolute', top: -1000, left: -1000 }).appendTo('body');
				scrollbarWidth = $textarea1.width() - $textarea2.width();
				$textarea1.add($textarea2).remove();
			} else {
				var $div = $('<div />')
					.css({ width: 100, height: 100, overflow: 'auto', position: 'absolute', top: -1000, left: -1000 })
					.prependTo('body').append('<div />').find('div')
						.css({ width: '100%', height: 200 });
				scrollbarWidth = 100 - $div.width();
				$div.parent().remove();
			}
		}
		return scrollbarWidth;
	};
})(jQuery);
/*[{!jquery_getscrollbarwidth_js_dt1855j!}]*/;
/* END /2static/script/lib/jquery/plugins/jquery.getscrollbarwidth.js */
/* START /2static/script/fe/json-hunks.js */
/**
 * A closed range of the diff line grid.
 *
 * A range will normally span whole lines, however, the concept of 'points'
 * on the line grid are required to represent and render addition and
 * deletion hunks.
 *
 * <pre>
 *   point   line      range
 *              0*
 *   [0,-1]  +-----     -+
 *           |  1        | [1, 1]
 *   [1, 0]  +-----     -+         -+
 *           |  2                   |
 *   [2, 1]  +-----                 | [2, 3]
 *           |  3                   |
 *   [3, 2]  +-----                -+
 * </pre>
 *
 * *: line zero is a special case
 *
 * @see http://www.artima.com/weblogs/viewpost.jsp?thread=164293
 *
 * @param low start of the range (inclusive)
 * @param high end of the range (inclusive); if one less than <em>low</em>
 *      then represents a point
 */
function Range(low, high) {
    if (!(this instanceof Range)) {
        return new Range(low, high);
    }
    this.low = low;
    this.high = high;
    this.length = high - low + 1;
    return this;
}

Range.ofLength = function (line, length) {
    return new Range(line, line + length - 1);
};

Range.ofLine = function (line) {
    return Range.ofLength(line, 1);
};

Range.ofLines = function (firstLine, lastLine) {
    return new Range(firstLine, lastLine);
};

Range.pointAfterLine = function (line) {
    return new Range(line, line - 1);
};

Range.pointBeforeLine = function (line) {
    return Range.pointAfterLine(line - 1);
};

Range.prototype = {
    constructor: Range,
    before: function (range) {
        return this.high < range.low;
    },
    after: function (range) {
        return range.high < this.low;
    },
    overlaps: function (range) {
        return this.low <= range.high && range.low <= this.high;
    },
    equals: function (range) {
        return this.low === range.low &&
            this.high === range.high;
    },
    toString: function () {
        return '[' + this.low + ', ' + this.high + ']';
    }
};


function Hunk(fromRange, toRange) {
    if (!(this instanceof Hunk)) {
        return new Hunk(fromRange, toRange);
    }
    this.fromRange = fromRange;
    this.toRange = toRange;
    return this;
}

Hunk.ofLengths = function (fromStart, fromLength, toStart, toLength) {
    return new Hunk(
        Range.ofLength(fromStart, fromLength),
        Range.ofLength(toStart, toLength)
    );
};

/**
 * Convenience constructor for addition hunks in normal diff output
 * format (e.g., <code>11a11,13</code>).
 *
 * @see http://www.gnu.org/software/diffutils/manual/html_node/Detailed-Normal.html
 */
Hunk.addition = function (afterFromLine, toRange) {
    return new Hunk(Range.pointAfterLine(afterFromLine), toRange);
};

/**
 * Convenience constructor for change hunks in normal diff output
 * format (e.g., <code>4,5c2,3</code>).
 *
 * @see http://www.gnu.org/software/diffutils/manual/html_node/Detailed-Normal.html
 */
Hunk.change = function (fromRange, toRange) {
    return new Hunk(fromRange, toRange);
};

/**
 * Convenience constructor for deletion hunks in normal diff output
 * format (e.g., <code>1,2d0</code>).
 *
 * @see http://www.gnu.org/software/diffutils/manual/html_node/Detailed-Normal.html
 */
Hunk.deletion = function (fromRange, afterToLine) {
    return new Hunk(fromRange, Range.pointAfterLine(afterToLine));
};

Hunk.prototype = (function () {
    var prototype = Hunk.prototype;

    prototype.isAddition = function () {
        return this.fromRange.length === 0;
    };

    prototype.isChange = function () {
        return this.fromRange.length > 0 && this.toRange.length > 0;
    };

    prototype.isDeletion = function () {
        return this.toRange.length === 0;
    };

    prototype.before = function (hunk) {
        return this.fromRange.before(hunk.fromRange) &&
            this.toRange.before(hunk.toRange);
    };

    prototype.after = function (hunk) {
        return this.fromRange.after(hunk.fromRange) &&
            this.toRange.after(hunk.toRange);
    };

    prototype.overlaps = function (hunk) {
        return this.fromRange.overlaps(hunk.fromRange) ||
            this.toRange.overlaps(hunk.toRange);
    };

    /**
     * Returns the set of hunks that overlap this hunk.
     */
    prototype.overlapping = function (sortedHunks) {
        var result = [];
        var index = binarySearch(sortedHunks, this);

        if (index >= 0) {
            var h;
            var i;
            var len;

            for (i = index - 1; i >= 0 && (h = sortedHunks[i]).overlaps(this); i -= 1) {
                result.push(h);
            }
            result.push(sortedHunks[index]);
            for (i = index + 1, len = sortedHunks.length; i < len && (h = sortedHunks[i]).overlaps(this); i++) {
                result.push(h);
            }
        }
        return result;
    };

    /**
     * Returns the index of a hunk that overlaps the given hunk.
     */
    function binarySearch(sortedHunks, hunk) {
        var min = 0;
        var max = sortedHunks.length - 1;

        while (min <= max) {
            var mid = Math.floor((min + max) / 2);
            var node = sortedHunks[mid];

            if (hunk.overlaps(node)) {
                return mid;
            } else if (hunk.before(node)) {
                max = mid - 1;
            } else if (hunk.after(node)) {
                min = mid + 1;
            } else {
                //bad hunks - either NaN values, or a mismatched from and to.
                return -1;
            }
        }
        return -1;
    }

    prototype.equals = function (hunk) {
        return this.fromRange.equals(hunk.fromRange) &&
            this.toRange.equals(hunk.toRange);
    };

    prototype.toString = (function () {
        function toHunkRangeString(range) {
            if (range.length === 1) {
                return range.low + '';
            } else {
                return range.low + ',' + range.length;
            }
        }

        return function () {
            return '-' + toHunkRangeString(this.fromRange) + ' ' +
                '+' + toHunkRangeString(this.toRange);
        };
    })();

    return prototype;
})();
/*[{!json_hunks_js_8t5z52e!}]*/;
/* END /2static/script/fe/json-hunks.js */
/* START /2static/script/fe/sbs-diff.js */
(function ($) {
    function Diff(rawDiffData) {
        if (!(this instanceof Diff)) {
            return new Diff(rawDiffData);
        }
        var parts = rawDiffData.split(Diff.DELIMITER);

        /** Sorted array of hunks. */
        this.hunks = eval(parts[0]);

        this.pagesPerBlock = eval(parts[1]);
        this.linesPerPage = eval(parts[2]);

        this.from = new File(this.pagesPerBlock, this.linesPerPage, parts[3]);
        this.to = new File(this.pagesPerBlock, this.linesPerPage, parts[4]);

        return this;
    }

    Diff.DELIMITER = '<';

    Diff.prototype = (function () {
        var prototype = Diff.prototype;

        /**
         * Merge more file blocks into the diff. Any metadata included in the
         * raw data is ignored.
         */
        prototype.merge = function (rawDiffData) {
            var diffParts = rawDiffData.split(Diff.DELIMITER);
            if (this.from.exists()) {
                this.from.merge(diffParts[3].split(File.DELIMITER));
            }
            this.to.merge(diffParts[4].split(File.DELIMITER));
        };

        /**
         * Ensures that the lines in the hunk are viewable.
         *
         * This may need to load a max of two blocks for each file from the server
         * (since the number of lines in a block is much larger than the viewport).
         *
         * @param hunk the from and to lines to show; this will typically correspond
         *      to the lines visible in the viewport.
         * @param postload optional callback executed once the entire hunk is visible.
         */
        prototype.ensureVisible = function (hunk, postload) {
            var fromRange = hunk.fromRange;
            var toRange = hunk.toRange;
            var linesPerBlock = this.pagesPerBlock * this.linesPerPage;

            var firstFromBlock = Math.floor(fromRange.low / linesPerBlock);
            var lastFromBlock = Math.floor(fromRange.high / linesPerBlock);
            var firstToBlock = Math.floor(toRange.low / linesPerBlock);
            var lastToBlock = Math.floor(toRange.high / linesPerBlock);

            var fromBlockToFetch = this.from.exists() ? nextBlockToFetch(this.from, firstFromBlock, lastFromBlock) : null;
            var toBlockToFetch = nextBlockToFetch(this.to, firstToBlock, lastToBlock);

            if (!(fromBlockToFetch || toBlockToFetch)) {
                if (this.from.exists()) {
                    this.from.ensureVisible(fromRange);
                }
                this.to.ensureVisible(toRange);
                postload && postload();
            } else {
                var diff = this;
                if (!fromBlockToFetch && diff.from.exists()) {
                    diff.from.ensureVisible(fromRange);
                }
                if (!toBlockToFetch) {
                    diff.to.ensureVisible(toRange);
                }
                $.ajax({
                    type: 'POST',
                    url: document.location.href,
                    data: {
                        linesPerPage: diff.linesPerPage,
                        fromBlock: fromBlockToFetch,
                        toBlock: toBlockToFetch,
                        ajax: "true"
                    },
                    dataType: 'text',   // Custom data format that we selectively eval.
                    success: function (rawDiffData) {
                        diff.merge(rawDiffData);
                        // Display what is visible from the just-fetched blocks.
                        if (fromBlockToFetch && diff.from.exists()) {
                            diff.from.ensureVisible(fromRange);
                        }
                        if (toBlockToFetch) {
                            diff.to.ensureVisible(toRange);
                        }
                        // Recurse to make sure the entire hunk is visible.
                        diff.ensureVisible(hunk, postload);
                    }
                });
            }
        };

        /**
         * Returns the next unrequested/unloaded block number to load for the file or null
         * if all the blocks are already requested/loaded.
         */
        function nextBlockToFetch(file, firstBlockNumber, lastBlockNumber) {
            for (var blockNumber = firstBlockNumber; blockNumber <= lastBlockNumber; blockNumber++) {
                if (!file.blocks[blockNumber]) {
                    // Mark as loading; will be overwritten upon merging the raw file data.
                    // Any object without numeric keys will work here, since we will only
                    // insert pages from the block when they've been loaded and stored under
                    // their respective page number.
                    file.blocks[blockNumber] = nextBlockToFetch.loadingBlock;
                    return blockNumber;
                }
            }
            return null;
        }

        nextBlockToFetch.loadingBlock = {loading: true};

        return prototype;
    })();

    var $gutterBoxes;

    /**
     * Call a function for each gutter we are displaying
     *
     * @param fn a function taking an int and a jQuery element -- called for each gutter box
     */
    function forEachGutterBox(fn) {
        if (typeof $gutterBoxes === "undefined") {
            $gutterBoxes = $(".gutter-box");
        }
        for (var i = 0, len = $gutterBoxes.length; i < len; ++i) {
            fn(i, $gutterBoxes.eq(i));
        }
    }


    function File(pagesPerBlock, linesPerPage, rawFileData) {
        if (!(this instanceof File)) {
            return new File(pagesPerBlock, linesPerPage, rawFileData);
        }
        var parts = rawFileData.split(File.DELIMITER);
        var metadata = eval(parts[parts.length - 1]);

        if (!this.numLines) {
            this.numLines = 0;
        }

        if (!metadata) {
            return null;
        }

        this.name = metadata.name;
        this.position = metadata.position;
        this.numLines = metadata.numLines;
        this.longestLine = metadata.longestLine;
        this.pagesPerBlock = pagesPerBlock;
        this.linesPerPage = linesPerPage;
        this.gutterWidths = metadata.gutterWidths;

        /**
         * Map of blockNumber to an array of page data (which is eval'd on demand).
         *
         * Each 'page data' is either a raw (uneval'd) string or an object
         * containing the DOM elements for that page.
         */
        this.blocks = {};

        this.merge(parts);

        // These variables can only be calculated after the DOM is ready.
        this.scrollBoxDom = null;
        this.numbersBoxDom = null;
        this.revisionBlameBoxDom = null;
        this.lineHeightPx = null;

        return this;
    }

    File.DELIMITER = '>';

    File.prototype = (function () {
        var prototype = File.prototype;

        prototype.exists = function () {
            return !!this.blocks;
        };

        /**
         * Merge more blocks into this file given the parts that result from
         * splitting the raw file data. Any file metadata included in the
         * parts is ignored.
         */
        prototype.merge = function (parts) {
            var blockNumber = eval(parts[0]);
            if (blockNumber >= 0) {
                // Store the uneval'd pages.
                this.blocks[blockNumber] = parts.slice(1, parts.length - 1);
            }
        };

        /**
         * Ensure that the pages corresponding to the range are in the DOM. This
         * can only ensure that pages from already fetched blocks are visible
         * (otherwise it is a noop).
         *
         * @param range the range of lines to show; this will typically be
         *      the range of lines visible in the viewport for this file.
         */
        prototype.ensureVisible = function (range) {
            if (this.numLines > 0) {
                var linesPerBlock = this.pagesPerBlock * this.linesPerPage;
                var firstBlock = Math.floor((range.low - 1) / linesPerBlock);
                var lastBlock = Math.floor((range.high - 1) / linesPerBlock);

                for (var blockNumber = firstBlock; blockNumber <= lastBlock; blockNumber++) {
                    var blockLineOffset = blockNumber * linesPerBlock;
                    var firstLineInBlock = (range.low - 1) - blockLineOffset;
                    var lastLineInBlock = Math.min((range.high - 1) - blockLineOffset, (blockNumber + 1) * linesPerBlock - 1);
                    var firstPage = Math.floor(firstLineInBlock / this.linesPerPage);
                    var lastPage = Math.floor(lastLineInBlock / this.linesPerPage);

                    for (var pageNumber = firstPage; pageNumber <= lastPage; pageNumber++) {
                        // This can only be the case if the block is in memory and the page hasn't yet been inserted.
                        if (this.blocks[blockNumber] && typeof this.blocks[blockNumber][pageNumber] === 'string') {
                            insertPage(this, blockNumber, pageNumber);
                        }
                    }
                }
            }
        };

        /**
         * Insert the page and its line numbers into the DOM. No check is made as
         * to whether the page is already in the DOM.
         */
        function insertPage(file, blockNumber, pageNumber) {
            var $scrollBox = $(scrollBoxDom(file));
            var $numbersBox = $(numbersBoxDom(file));
            var $revBlameBox = $(revisionBlameBoxDom(file));
            var $authBlameBox = $(authorBlameBoxDom(file));
            var cssTop = (blockNumber * file.pagesPerBlock + pageNumber) * file.linesPerPage * file.lineHeightPx;

            // TODO Page widths should be set via a dynamic css rule.
            $scrollBox.children('.content-box')[0].appendChild(
                $(pageDom(file, blockNumber, pageNumber))
                    .css('top', cssTop)
                    .css('width', $scrollBox.data('getPageWidth')())[0]
            );
            $numbersBox.children('.content-box')[0].appendChild(
                $(numbersForPageDom(file, blockNumber, pageNumber))
                    .css('top', cssTop)[0]
            );
            if ($revBlameBox.length !== 0) {
                $revBlameBox.children('.content-box')[0].appendChild(
                    $(revisionBlameForPageDom(file, blockNumber, pageNumber))
                        .css('top', cssTop)[0]
                );
            }
            if ($authBlameBox.length !== 0) {
                $authBlameBox.children('.content-box')[0].appendChild(
                    $(authorBlameForPageDom(file, blockNumber, pageNumber))
                        .css('top', cssTop)[0]
                );
            }

            forEachGutterBox(function (i, $gutterBox) {
                $gutterBox.children('.content-box')[0].appendChild(
                    $(gutterDecoratorForPageDom(file, blockNumber, pageNumber, i))
                        .css('top', cssTop)[0]
                );
            });

            triggerOnParent('sbs-page:rendered', file.blocks[blockNumber][pageNumber]);
        }

        function scrollBoxDom(file) {
            if (!file.scrollBoxDom) {
                file.scrollBoxDom = $('#' + file.name + '-box')[0];
            }
            return file.scrollBoxDom;
        }

        function numbersBoxDom(file) {
            if (!file.numbersBoxDom) {
                file.numbersBoxDom = $('#' + file.name + '-numbers-box')[0];
            }
            return file.numbersBoxDom;
        }

        function revisionBlameBoxDom(file) {
            if (!file.revisionBlameBoxDom) {
                file.revisionBlameBoxDom = $('#' + file.name + '-revision-blame-box')[0];
            }
            return file.revisionBlameBoxDom;
        }

        function authorBlameBoxDom(file) {
            if (!file.authorBlameBoxDom) {
                file.authorBlameBoxDom = $('#' + file.name + '-auth-blame-box')[0];
            }
            return file.authorBlameBoxDom
        }

        /**
         * Get the DOM element for the page. Assumes that the block has already
         * been fetched from the server.
         */
        function pageDom(file, blockNumber, pageNumber) {
            var block = file.blocks[blockNumber];
            var data = block[pageNumber];

            if (typeof data === 'string') {
                var lines = eval(data);
                var pageDom = createPageDom(lines);
                var numbersDom = createNumbersForPageDom(file, blockNumber, pageNumber, lines);
                var revisionBlameDom = createRevisionBlameForPageDom(file, blockNumber, pageNumber, lines);
                var authorBlameDom = createAuthorBlameForPageDom(file, blockNumber, pageNumber, lines);
                var gutterDom = createGutterDecoratorForPageDom(file, blockNumber, pageNumber, lines);
                var absolutePageNumber = blockNumber * file.pagesPerBlock + pageNumber;
                var lineOffset = absolutePageNumber * file.linesPerPage;
                var lineStart = lineOffset + 1;
                var lineEnd = Math.min(lineOffset + file.linesPerPage, file.numLines);

                setIdToFileBlockPage(pageDom, file, blockNumber, absolutePageNumber, 'page');
                setIdToFileBlockPage(numbersDom, file, blockNumber, absolutePageNumber, 'numbers');
                setIdToFileBlockPage(revisionBlameDom, file, blockNumber, absolutePageNumber, 'revision-blame');
                setIdToFileBlockPage(authorBlameDom, file, blockNumber, absolutePageNumber, 'auth-blame');

                // Free the memory used by raw page data by storing the DOM elements in its place.
                block[pageNumber] = {
                    pageDom: pageDom,
                    numbersDom: numbersDom,
                    revBlameDom: revisionBlameDom,
                    authBlameDom: authorBlameDom,
                    gutterDom: gutterDom,
                    lineStart: lineStart,
                    lineEnd: lineEnd
                };
            }
            return block[pageNumber].pageDom;
        }

        function setIdToFileBlockPage(dom, file, blockNumber, pageNumber, typeString) {
            dom.id = file.name + "-" + typeString + "-" + blockNumber + "-" + pageNumber;
        }

        /**
         * Get the page of line numbers for the page. Assumes that the block has
         * alredy been fetched from the server.
         */
        function numbersForPageDom(file, blockNumber, pageNumber) {
            // Ensure the raw page data has been eval'd.
            pageDom(file, blockNumber, pageNumber);
            return file.blocks[blockNumber][pageNumber].numbersDom;
        }

        function revisionBlameForPageDom(file, blockNumber, pageNumber) {
            // Ensure the raw page data has been eval'd.
            pageDom(file, blockNumber, pageNumber);
            return file.blocks[blockNumber][pageNumber].revBlameDom;
        }

        function authorBlameForPageDom(file, blockNumber, pageNumber) {
            // Ensure the raw page data has been eval'd.
            pageDom(file, blockNumber, pageNumber);
            return file.blocks[blockNumber][pageNumber].authBlameDom;
        }

        function gutterDecoratorForPageDom(file, blockNumber, pageNumber, gutterIndex) {
            // Ensure the raw page data has been eval'd.
            pageDom(file, blockNumber, pageNumber);
            return file.blocks[blockNumber][pageNumber].gutterDom[gutterIndex];
        }

        /**
         * Create a detached page DOM element.
         */
        function createPageDom(lines) {
            var pageDom = document.createElement('div');
            pageDom.className = 'page';
            for (var i = 0, len = lines.length; i < len; i++) {
                pageDom.appendChild(createLineDom(lines[i]));
            }
            return pageDom;
        }

        /**
         * Create a detached page of line numbers DOM element.
         */
        var createNumbersForPageDom = (function () {
            var location = window.top.location;
            var baseUrl = location.href.replace(location.hash, '');

            return function (file, blockNumber, pageNumber, lines) {
                var numbersDom = document.createElement('div');
                var lineOffset = (blockNumber * file.pagesPerBlock + pageNumber) * file.linesPerPage + 1;

                numbersDom.className = 'page line-numbers';
                for (var i = 0, len = lines.length; i < len; i++) {
                    var lineNumber = lineOffset + i;
                    var lineUrl = baseUrl + '#' + file.name + lineNumber;
                    var lineDom = createLineDom(lines[i], '<a href="' + lineUrl + '" target="_blank">' + lineNumber + '</a>');

                    numbersDom.appendChild(lineDom);
                }
                return numbersDom;
            };
        })();

        var createRevisionBlameForPageDom = (function () {
            return function (file, blockNumber, pageNumber, lines) {
                var blameDom = document.createElement('div');
                blameDom.className = 'page revision-blame';
                for (var i = 0, len = lines.length; i < len; i++) {
                    var html = lines[i].start && lines[i].revision || '&nbsp;';
                    var lineDom = createLineDom(lines[i], '<span>' + html + '</span>', [lines[i]['blameclass']]);
                    blameDom.appendChild(lineDom);
                }
                return blameDom;
            };
        })();

        var createAuthorBlameForPageDom = (function () {
            return function (file, blockNumber, pageNumber, lines) {
                var blameDom = document.createElement('div');
                blameDom.className = 'page author-blame';
                for (var i = 0, len = lines.length; i < len; i++) {
                    var html = lines[i].start && lines[i].author || '&nbsp;';
                    var lineDom = createLineDom(lines[i], '<span>' + html + '</span>');
                    blameDom.appendChild(lineDom);
                }
                return blameDom;
            };
        })();

        var createGutterDecoratorForPageDom = (function () {
            return function (file, blockNumber, pageNumber, lines) {
                var gutterDom = [];
                for (var gutterIndex = 0; gutterIndex < lines[0].gutters.length; ++gutterIndex) {
                    gutterDom[gutterIndex] = document.createElement('div');
                    for (var i = 0, len = lines.length; i < len; i++) {
                        var lineDom = createLineDom(lines[i], lines[i].gutters[gutterIndex]);
                        gutterDom[gutterIndex].appendChild(lineDom);
                    }
                }
                return gutterDom;
            };
        })();

        /**
         * Create a detached line DOM element.
         *
         * @param line object with at least an html property that contains the
         *      html representation of the line (i.e., with spans for syntax
         *      highlighting and ediff, etc.)
         * @param content optional content to use instead of line.html
         */
        var createLineDom = (function () {
            var codes = ['addition', 'change', 'deletion', 'start', 'end'];
            var createElem = null;

            if ($.browser.msie) {
                // IE work around for quirk of normalizing white-space on assignment to innerHTML.
                var container = document.createElement('div');
                createElem = function (content) {
                    var c = container;
                    c.innerHTML = '<pre>' + content + '</pre>';
                    return c.removeChild(c.firstChild);
                };
            } else {
                createElem = function (content) {
                    var lineDom = document.createElement('pre');
                    lineDom.innerHTML = content;
                    return lineDom;
                };
            }

            return function (line, content, extraClasses) {
                var lineDom = createElem(content || line.html);
                // Must use typeof because the empty string is falsy.
                if ((typeof lineDom.innerText !== 'undefined' ? lineDom.innerText : lineDom.textContent).length === 0) {
                    lineDom.innerHTML = lineDom.innerHTML + '&nbsp;';
                }

                var cssClasses = [];
                for (var i = 0, len = codes.length; i < len; i++) {
                    var code = codes[i];
                    if (line.hasOwnProperty(code)) {
                        cssClasses.push(code);
                    }
                }
                extraClasses = extraClasses || [];
                for (i = 0, len = extraClasses.length; i < len; i++) {
                    cssClasses.push(extraClasses[i]);
                }
                var cssClass = cssClasses.join(' ');
                if (cssClass) {
                    lineDom.className = cssClass;
                }

                return lineDom;
            };
        })();

        /**
         * Get the DOM element for the longest line in this file.
         */
        prototype.longestLineDom = function () {
            return createLineDom(this.longestLine);
        };

        return prototype;
    })();


// Navigation can't do anything until the DOM is ready.
    window.nextSegment = function () {
    };
    window.prevSegment = function () {
    };

// This is used for annotations, not just diffs
    window.FECRU = window.FECRU || {};
    FECRU.SBS = FECRU.SBS || {};
    FECRU.SBS.main = function (rawDiffData) {

        var diff = new Diff(rawDiffData);
        var $fromBox = null;
        var $toBox = null;
        var LINE_HEIGHT = null;
        var FOCUSED_LINE_OFFSET = null;

        var lastWidth = 0;
        var lastHeight = 0;
        var emsSet = false;
        var fromNumbersOuterWidth = 0;
        var fromRevisionsOuterWidth = 0;
        var fromAuthorsOuterWidth = 0;
        var segmentsOuterWidth = 0;
        var toNumbersOuterWidth = 0;
        var toRevisionsOuterWidth = 0;
        var toAuthorsOuterWidth = 0;
        var gutterOuterWidths = [];

        /*eslint-disable complexity*/
        function setPaneDimensions(forceResize) {
            var $fromNumbers = $('#from-numbers-box');
            var $toNumbers = $('#to-numbers-box');
            var $fromRevisions = $('#from-revision-blame-box');
            var $toRevisions = $('#to-revision-blame-box');
            var $fromAuthors = $('#from-auth-blame-box');
            var $toAuthors = $('#to-auth-blame-box');
            var $segments = $('#segment-box');
            var $container = $(window.frameElement || window);
            var containerWidth = $container.width();
            var containerHeight = $container.height();

            if (!forceResize && containerWidth === lastWidth && containerHeight === lastHeight) {
                // dont do it again
                return;
            }
            lastWidth = containerWidth;
            lastHeight = containerHeight;

            var paneHeight = lastHeight;
            if (!emsSet) {
                emsSet = true;
                var numbersWidthEm = Math.max(2.5, 0.75 * String(Math.max(diff.from.numLines, diff.to.numLines)).length);
                var fromRevisionsWidthEm = 4.5;
                var toRevisionsWidthEm = 4.5;
                var fromAuthorsWidthEm = 9;
                var toAuthorsWidthEm = 9;

                $fromNumbers.add($toNumbers).width(numbersWidthEm + 'em');

                var setWidth = function($column, widthEm) {
                    $column.width(widthEm + 'em');
                };

                setWidth($fromRevisions, fromRevisionsWidthEm);
                setWidth($toRevisions, toRevisionsWidthEm);
                setWidth($fromAuthors, fromAuthorsWidthEm);
                setWidth($toAuthors, toAuthorsWidthEm);

                forEachGutterBox(function (i, $gutterBox) {
                    $gutterBox.width(diff.to.gutterWidths[i] + 'em');
                    gutterOuterWidths[i] = $gutterBox.outerWidth(true);
                });

                fromNumbersOuterWidth = $fromNumbers.outerWidth(true);
                fromRevisionsOuterWidth = $fromRevisions.outerWidth(true);
                fromAuthorsOuterWidth = $fromAuthors.outerWidth(true);
                segmentsOuterWidth = $segments.outerWidth(true);
                toNumbersOuterWidth = $toNumbers.outerWidth(true);
                toRevisionsOuterWidth = $toRevisions.outerWidth(true);
                toAuthorsOuterWidth = $toAuthors.outerWidth(true);
            }

            $fromNumbers
                .add($toNumbers)
                .add($fromRevisions)
                .add($toRevisions)
                .add($fromAuthors)
                .add($toAuthors)
                .add($segments)
                .add(".gutter-box")
                .height(paneHeight);

            var fromWidth = 0;
            if ($fromNumbers.is(':visible')) {
                fromWidth += fromNumbersOuterWidth;
            }
            if ($fromRevisions.is(':visible')) {
                fromWidth += fromRevisionsOuterWidth;
            }
            if ($fromAuthors.is(':visible')) {
                fromWidth += fromAuthorsOuterWidth;
            }

            var segmentsWidth = 0;
            if ($segments.is(':visible')) {
                segmentsWidth += segmentsOuterWidth;
            }

            var toWidth = 0;
            if ($toNumbers.is(':visible')) {
                toWidth += toNumbersOuterWidth;
            }
            if ($toRevisions.is(':visible')) {
                toWidth += toRevisionsOuterWidth;
            }
            if ($toAuthors.is(':visible')) {
                toWidth += toAuthorsOuterWidth;
            }

            forEachGutterBox(function (i, $gutterBox) {
                toWidth += gutterOuterWidths[i];
            });

            var $fileBoxes = $fromBox.add($toBox);

            $fileBoxes.height(paneHeight);

            var availableWidth = lastWidth - fromWidth - segmentsWidth - toWidth - 2;

            var fromNewWidth = Math.floor(availableWidth / $fileBoxes.length);
            var toNewWidth = Math.ceil(availableWidth / $fileBoxes.length);

            //set the real width
            $fromBox.width(fromNewWidth);
            $toBox.width(toNewWidth);

            var getFromPageWidth = $fromBox.data('getPageWidth');
            if (getFromPageWidth) {
                $fromBox.children().children().css('width', getFromPageWidth());
            }

            var getToPageWidth = $toBox.data('getPageWidth');
            if (getToPageWidth) {
                $toBox.children().children().css('width', getToPageWidth());
            }

            if (!LINE_HEIGHT) {
                var lineHtml = '<pre>        <span class="hl_comment">&lt;!-- comment --&gt;</span> <span class="hl_starttag">&lt;tag <span class="hl_attrib">key</span>=<span class="hl_string">"<span class="ediffChangedB">value</span>!default"</span></span></pre>';

                //a single line wasn't accurate enough and caused overlapping pages.
                //since we're only doing it once, this isn't so bad.
                var $controlLine = $(new Array(diff.linesPerPage + 2).join(lineHtml));
                var $dummyPage = $('<div class="page">').append($controlLine);

                $toBox.children('.content-box')
                    .append($dummyPage);
                // outerHeight() only gives integral accuracy, so use offset().top
                LINE_HEIGHT = ($dummyPage.children().last().offset().top - $dummyPage.children().first().offset().top) / diff.linesPerPage;
                $toBox.children('.content-box')
                    .empty();
            }

            var numViewableLines = Math.ceil(paneHeight / LINE_HEIGHT);
            FOCUSED_LINE_OFFSET = Math.floor(numViewableLines / 3) - 1;

            $fromBox.toggleClass('all-lines-visible', diff.from.numLines < numViewableLines);
            $toBox.toggleClass('all-lines-visible', diff.to.numLines < numViewableLines);
        }

        /*eslint-enable*/

        FECRU.SBS.resize = setPaneDimensions;
        FECRU.SBS.getDiff = function () {
            return diff;
        };

        FECRU.SBS.simulateScroll = function () {
            $toBox.trigger('scroll');
            $fromBox.trigger('scroll');
        };

        function initDimensions(file, $scrollBox) {
            var $longestLine = $(file.longestLineDom());
            var SCROLLBOX_PADDING_BOTTOM = 30;

            $scrollBox.children('.content-box')
                .append($('<div class="page">').append($longestLine));

            file.lineHeightPx = LINE_HEIGHT;

            var longestLineWidth = $longestLine.outerWidth();
            var getPageWidth = function () {
                return Math.max($scrollBox.width(), longestLineWidth)
            };
            var width = getPageWidth();
            var height = file.numLines * LINE_HEIGHT;

            $scrollBox
                .children('.content-box')
                .height(height + SCROLLBOX_PADDING_BOTTOM)
                .end()
                .scrollTop(height)
                .scrollLeft(width);

            $scrollBox
                .data('name', file.name)
                .data('getPageWidth', getPageWidth)
                .data('maxScrollTop', $scrollBox.scrollTop())
                .data('maxScrollLeft', $scrollBox.scrollLeft())
                .data('prevScrollTop', 0)
                .data('prevScrollLeft', 0);

            $scrollBox
                .scrollTop(0)
                .scrollLeft(0)
                .children('.content-box')
                .empty();

            // Add some buffer to account for horizontal scrollbars that overlay the last line.
            $('#' + file.name + '-numbers-box').children('.content-box')
                .height(height + 30);
            $('#' + file.name + '-revision-blame-box').children('.content-box')
                .height(height + 30);
            $('#' + file.name + '-auth-blame-box').children('.content-box')
                .height(height + 30);
        }

        function lineTopPx(line) {
            return (line - 1) * LINE_HEIGHT;
        }

        function lineBottomPx(line) {
            return line * LINE_HEIGHT;
        }

        var ignoreScrolls = 0;

        function makeScrollSynchHandler(numLines, otherPaneLine, otherPane) {
            return function () {
                var $thisPane = $(this);
                var $otherPane = $(otherPane);
                var scrollTop = $thisPane.scrollTop();
                var scrollLeft = $thisPane.scrollLeft();
                var isDownScroll = $thisPane.data('prevScrollTop') < scrollTop;

                $thisPane
                    .data('prevScrollTop', scrollTop)
                    .data('prevScrollLeft', scrollLeft);

                $('#' + $thisPane.data('name') + '-numbers-box').scrollTop(scrollTop);
                $('#' + $thisPane.data('name') + '-revision-blame-box').scrollTop(scrollTop);
                $('#' + $thisPane.data('name') + '-auth-blame-box').scrollTop(scrollTop);
                $('.gutter-box').scrollTop(scrollTop);

                if (ignoreScrolls) {
                    ignoreScrolls -= 1;
                    return;
                }

                var firstVisibleLine = Math[isDownScroll ? 'ceil' : 'floor'](scrollTop / LINE_HEIGHT) + 1;
                var residue = scrollTop - lineTopPx(firstVisibleLine);

                var currentFocusedLine = Math.min(numLines, firstVisibleLine + FOCUSED_LINE_OFFSET);
                var previousFocusedLine = Math.min(numLines, firstVisibleLine + (isDownScroll ? -1 : 1) + FOCUSED_LINE_OFFSET);
                var keepOtherPaneStill = otherPaneLine[previousFocusedLine] === otherPaneLine[currentFocusedLine];

                if ($otherPane.length !== 0) {
                    // Need to cap the scroll positions since requesting a position larger than
                    // physically possible only scrolls as far as the maximum possible, and no less than 0...
                    var otherPaneScrollTop = lineTopPx(otherPaneLine[currentFocusedLine] - FOCUSED_LINE_OFFSET) + (keepOtherPaneStill ? 0 : residue);
                    if (otherPaneScrollTop < 0) {
                        otherPaneScrollTop = 0;
                    } else if (otherPaneScrollTop > $otherPane.data('maxScrollTop')) {
                        otherPaneScrollTop = $otherPane.data('maxScrollTop');
                    }
                    var otherPaneScrollLeft = Math.min($otherPane.data('maxScrollLeft'), scrollLeft);

                    // ...and need to make sure the scroll position will change, otherwise the
                    // scroll event handler won't fire.
                    if ($otherPane.data('prevScrollTop') !== otherPaneScrollTop) {
                        ignoreScrolls++;
                        $otherPane.scrollTop(otherPaneScrollTop);
                    }
                    if ($otherPane.data('prevScrollLeft') !== otherPaneScrollLeft) {
                        ignoreScrolls++;
                        $otherPane.scrollLeft(otherPaneScrollLeft);
                    }
                }

                renderDiffSegments();
            };
        }

        var anchoredHunk = null;
        var renderDiffSegments = (function () {

            var canvas = null;
            var $segmentBox = null;
            var visiblePaths = [];
            var anchoredPath = null;

            var createPath = (function () {
                var add = {stroke: '#ccc', fill: '#cfc'};
                var del = {stroke: '#ccc', fill: '#ffc0cb'};
                var mod = {stroke: '#ccc', fill: '#f4f4f4'};

                return function (hunk) {
                    var path = canvas.path();
                    if (hunk.isAddition()) {
                        path.attr(add);
                    } else if (hunk.isChange()) {
                        path.attr(mod);
                    } else if (hunk.isDeletion()) {
                        path.attr(del);
                    }
                    return path;
                };
            })();

            /*eslint-disable complexity*/
            return function () {
                $segmentBox = $segmentBox || $('#segment-box');
                canvas = canvas || ($segmentBox.length === 0 ? null : Raphael('segment-box'));

                var fromScrollTop = $fromBox.scrollTop();
                var fromOffsetLines = Math.floor(fromScrollTop / LINE_HEIGHT);
                var fromResidue = fromScrollTop - lineTopPx(fromOffsetLines + 1);

                var toScrollTop = $toBox.scrollTop();
                var toOffsetLines = Math.floor(toScrollTop / LINE_HEIGHT);
                var toResidue = toScrollTop - lineTopPx(toOffsetLines + 1);

                var toBoxHeight = $toBox.height();

                var numViewableLines = Math.ceil(toBoxHeight / LINE_HEIGHT);
                var viewableFromRange = Range.ofLength(fromOffsetLines + 1, numViewableLines);
                var viewableToRange = Range.ofLength(toOffsetLines + 1, numViewableLines);
                var viewport = new Hunk(viewableFromRange, viewableToRange);
                var width = $segmentBox.length === 0 ? 0 : $segmentBox.width();
                var visibleHunks = viewport.overlapping(diff.hunks);

                diff.ensureVisible(viewport);

                // Clear the canvas of previously drawn paths.
                for (var i = 0, len = visiblePaths.length; i < len; i++) {
                    visiblePaths[i].hide();
                }
                visiblePaths = [];
                if (anchoredPath) {
                    anchoredPath.hide();
                }

                // Draw the newly visible paths.
                for (i = 0, len = visibleHunks.length; i < len; i++) {
                    var hunk = visibleHunks[i];
                    var fromRange = hunk.fromRange;
                    var toRange = hunk.toRange;
                    var path = hunk.path || (hunk.path = createPath(hunk));

                    visiblePaths.push(path);
                    if (hunk.isAddition()) {
                        path.attr('path', [
                            ['M', -1, lineBottomPx(fromRange.low - fromOffsetLines) - fromResidue - 1],
                            ['L', width, lineTopPx(toRange.low - toOffsetLines) - toResidue],
                            ['V', lineBottomPx(toRange.high - toOffsetLines) - toResidue - 1],
                            ['Z']
                        ]).show();
                    } else if (hunk.isChange()) {
                        path.attr('path', [
                            ['M', -1, lineTopPx(fromRange.low - fromOffsetLines) - fromResidue],
                            ['L', width, lineTopPx(toRange.low - toOffsetLines) - toResidue],
                            ['V', lineBottomPx(toRange.high - toOffsetLines) - toResidue - 1],
                            ['L', -1, lineBottomPx(fromRange.high - fromOffsetLines) - fromResidue - 1],
                            ['Z']
                        ]).show();
                    } else if (hunk.isDeletion()) {
                        path.attr('path', [
                            ['M', -1, lineTopPx(fromRange.low - fromOffsetLines) - fromResidue],
                            ['V', lineBottomPx(fromRange.high - fromOffsetLines) - fromResidue - 1],
                            ['L', width, lineBottomPx(toRange.low - toOffsetLines) - toResidue - 1],
                            ['Z']
                        ]).show();
                    }
                }

                if (anchoredHunk) {
                    anchoredPath = anchoredPath || (canvas ? canvas.path().attr({
                            fill: '#fffff0',
                            stroke: '#fffff0',
                            opacity: 0.75
                        }) : null);
                    if (anchoredHunk.overlaps(viewport)) {
                        fromRange = anchoredHunk.fromRange;
                        toRange = anchoredHunk.toRange;
                        anchoredPath && anchoredPath.attr('path', [
                            ['M', -1, lineTopPx(fromRange.low - fromOffsetLines) - fromResidue],
                            ['L', width, lineTopPx(toRange.low - toOffsetLines) - toResidue],
                            ['V', lineBottomPx(toRange.high - toOffsetLines) - toResidue - 1],
                            ['L', -1, lineBottomPx(fromRange.high - fromOffsetLines) - fromResidue - 1],
                            ['Z']
                        ]).show().toFront();
                    }
                }

            };
            /*eslint-enable*/
        })();

        function hunkAfterLine(sortedHunks, fromLineNumber) {
            var min = 0;
            var max = sortedHunks.length - 1;
            var after = null;

            while (min <= max) {
                var mid = Math.floor((min + max) / 2);
                var node = sortedHunks[mid];

                if (fromLineNumber < node.fromRange.low) {
                    after = node;
                    max = mid - 1;
                } else {
                    min = mid + 1;
                }
            }
            return after;
        }

        function hunkBeforeLine(sortedHunks, fromLineNumber) {
            var min = 0;
            var max = sortedHunks.length - 1;
            var before = null;

            while (min <= max) {
                var mid = Math.floor((min + max) / 2);
                var node = sortedHunks[mid];

                if (node.fromRange.low < fromLineNumber) {
                    before = node;
                    min = mid + 1;
                } else {
                    max = mid - 1;
                }
            }
            return before;
        }

        function setAnchoredFromLine(fromLineNum, animate) {
            if (diff.from.exists()) {
                setAnchoredLines(fromLineNum, diff.from.position[fromLineNum]);
                scrollToFocusedFromLine(fromLineNum, animate);
            }
        }

        function setAnchoredToLine(toLineNum, animate) {
            setAnchoredLines(diff.to.position[toLineNum], toLineNum);
            scrollToFocusedToLine(toLineNum, animate);
        }

        var setAnchoredLines = (function () {
            var $from = null;
            var $to = null;

            return function (fromLineNum, toLineNum) {
                var linesPerBlock = diff.pagesPerBlock * diff.linesPerPage;
                var fromLineNumWithinPage = (fromLineNum - 1) % linesPerBlock % diff.linesPerPage;
                var fromPageNum = Math.floor((fromLineNum - 1) % linesPerBlock / diff.linesPerPage);
                var fromBlockNum = Math.floor((fromLineNum - 1) / linesPerBlock);
                var toLineNumWithinPage = (toLineNum - 1) % linesPerBlock % diff.linesPerPage;
                var toPageNum = Math.floor((toLineNum - 1) % linesPerBlock / diff.linesPerPage);
                var toBlockNum = Math.floor((toLineNum - 1) / linesPerBlock);

                $from && $from.removeClass('anchored-line');
                $to && $to.removeClass('anchored-line');

                anchoredHunk = Hunk.ofLengths(fromLineNum, 1, toLineNum, 1);
                diff.ensureVisible(anchoredHunk, function () {
                    if (diff.from.exists()) {
                        $from =
                            $('#from-page-' + fromBlockNum + '-' + fromPageNum).children('pre:eq(' + fromLineNumWithinPage + ')').add(
                                $('#from-numbers-' + fromBlockNum + '-' + fromPageNum).children('pre:eq(' + fromLineNumWithinPage + ')'));
                        $from.addClass('anchored-line');
                    }
                    $to =
                        $('#to-page-' + toBlockNum + '-' + toPageNum).children('pre:eq(' + toLineNumWithinPage + ')').add(
                            $('#to-numbers-' + toBlockNum + '-' + toPageNum).children('pre:eq(' + toLineNumWithinPage + ')'));
                    $to.addClass('anchored-line');
                });
            };
        })();

        function scrollToFocusedFromLine(lineNum, animate) {
            if (diff.from.exists()) {
                var location = window.top.location;
                lineNum = Math.min(Math.max(1, lineNum), diff.from.numLines - 1);
                location.hash = '#from' + lineNum;
                var scrollTop = lineTopPx(lineNum - FOCUSED_LINE_OFFSET);
                var toBoxScrollTop = lineTopPx(diff.from.position[lineNum] - FOCUSED_LINE_OFFSET);
                if (animate) {
                    animateScrollTo($fromBox, scrollTop, toBoxScrollTop);
                } else {
                    syncMainPageScrollBar(toBoxScrollTop);
                    $fromBox.scrollTop(scrollTop);
                }
            }
        }

        function scrollToFocusedToLine(lineNum, animate) {
            var location = window.top.location;
            lineNum = Math.min(Math.max(1, lineNum), diff.to.numLines - 1);
            location.hash = '#to' + lineNum;
            var targetLine = lineNum - FOCUSED_LINE_OFFSET;
            var scrollTop = lineTopPx(targetLine < 0 ? 1 : targetLine);
            if (animate) {
                animateScrollTo($toBox, scrollTop);
            } else {
                syncMainPageScrollBar(scrollTop);
                $toBox.scrollTop(scrollTop);
            }
        }

        function syncMainPageScrollBar(scrollTop) {
            triggerOnParent('scroll-content', scrollTop);
        }

        function animateScrollTo($scrollBox, scrollTop, toBoxScrollTop) {
            var TOTAL_DURATION = 100;
            var SLEEP_DURATION = 10;
            var steps = TOTAL_DURATION / SLEEP_DURATION;
            var currentScrollTop = $scrollBox.data('prevScrollTop');
            var stepSize = (scrollTop - currentScrollTop) / steps;

            if (typeof toBoxScrollTop !== 'undefined') {
                var toBoxCurrentScrollTop = $toBox.data('prevScrollTop');
                var toBoxStepSize = (toBoxScrollTop - toBoxCurrentScrollTop) / steps;
            } else {
                toBoxScrollTop = scrollTop;
                toBoxCurrentScrollTop = currentScrollTop;
                toBoxStepSize = stepSize;
            }

            (function loop() {
                if (steps > 0) {
                    // Scroll to the exact final location so that other line calculations are accurate.
                    currentScrollTop += stepSize;
                    toBoxCurrentScrollTop += toBoxStepSize;

                    var nextScrollTop = steps === 1 ? scrollTop : currentScrollTop;
                    var nextToBoxScrollTop = steps === 1 ? toBoxScrollTop : toBoxCurrentScrollTop;

                    syncMainPageScrollBar(nextToBoxScrollTop);
                    $scrollBox.scrollTop(nextScrollTop);

                    steps -= 1;
                    setTimeout(loop, SLEEP_DURATION);
                }
            })();
        }

        $(document).ready(function () {
            $fromBox = $('#from-box');
            $toBox = $('#to-box');

            if (window.top.AJS) {
                window.top.AJS.bind('file-view-resize', function () {
                    FECRU.SBS.resize();
                });
            } else {
                $(window).resize(function () {
                    FECRU.SBS.resize();
                })
            }

            setPaneDimensions(true);
            // IE8 exhibits some race condition on the initial load that could cause it not ot resize properly.
            // Resizing it AFTER document.ready seems to workaround it until we determine the race condition.
            setTimeout(function () {
                setPaneDimensions(true);
            }, 1);

            if (diff.from.exists()) {
                initDimensions(diff.from, $fromBox);
            }
            initDimensions(diff.to, $toBox);

            // trigger event to the parent window to reset the iframe height
            triggerOnParent('file-view-resize-from-iframe');

            if (diff.from.exists()) {
                $fromBox.bind('scroll', makeScrollSynchHandler(diff.from.numLines, diff.from.position, $toBox[0]));
            }
            $toBox.bind('scroll', makeScrollSynchHandler(diff.to.numLines, diff.to.position, $fromBox[0]));
            renderDiffSegments();

            window.nextSegment = function () {
                var fromLineNumber = Math.floor($fromBox.data('prevScrollTop') / LINE_HEIGHT) + 1 + FOCUSED_LINE_OFFSET;
                var hunk = hunkAfterLine(diff.hunks, fromLineNumber);

                scrollToFocusedFromLine(hunk ? (diff.from.exists() ? hunk.fromRange.low : hunk.toRange.low) : (diff.from.exists() ? diff.from.numLines : diff.to.numLines) - 1);
            };

            window.prevSegment = function () {
                var fromLineNumber = Math.floor($fromBox.data('prevScrollTop') / LINE_HEIGHT) + 1 + FOCUSED_LINE_OFFSET;
                var hunk = hunkBeforeLine(diff.hunks, fromLineNumber);

                scrollToFocusedFromLine(hunk ? (diff.from.exists() ? hunk.fromRange.low : hunk.toRange.low) : 1);
            };

            // Scroll to requested position, otherwise the first hunk.
            var hash = window.top.location.hash;
            var lineNum = null;

            if (/^#seg\d+/.test(hash)) {
                // Support legacy #segN URL anchors to scroll to a specific hunk.
                var segment = parseInt(hash.replace(/^#seg(\d+).*$/, '$1'), 10);
                if (segment <= 0) {
                    lineNum = 1;
                } else if (segment > diff.hunks.length) {
                    lineNum = diff.from.numLines - 1;
                } else {
                    lineNum = diff.hunks[segment - 1].fromRange.low;
                }
                setAnchoredFromLine(lineNum);
            } else if (/^#(l|from)\d+/.test(hash)) {
                // Also support legacy #lN URL anchors to scroll to a specific line.
                lineNum = parseInt(hash.replace(/^#(l|from)(\d+).*$/, '$2'), 10);
                setAnchoredFromLine(lineNum);
            } else if (/^#to\d+/.test(hash)) {
                lineNum = parseInt(hash.replace(/^#to(\d+).*$/, '$1'), 10);
                // Workaround for Firefox scrolling the 'to' pane then giving
                // focus to the top of the 'from' pane.
                setTimeout(function () {
                    setAnchoredToLine(lineNum);
                }, 10);
            }

            // Scroll to the specified link on left-clicking the permalink.
            $('#from-numbers-box').delegate('a', 'click', function (e) {
                if (e.button === 0) {
                    var matches = /#from(\d+)$/.exec($(this).attr('href'));
                    var lineNumber = parseInt(matches[1], 10);

                    setAnchoredFromLine(lineNumber, true);
                    e.preventDefault();
                }
            });
            $('#to-numbers-box').delegate('a', 'click', function (e) {
                if (e.button === 0) {
                    var matches = /#to(\d+)$/.exec($(this).attr('href'));
                    var lineNumber = parseInt(matches[1], 10);

                    setAnchoredToLine(lineNumber, true);
                    e.preventDefault();
                }
            });

        });
    };

    function triggerOnParent(event, data) {
        var parent = window.parent;
        if (parent !== window) {
            parent.AJS && parent.AJS.trigger(event, data);
        }
    }

})(typeof AJS === 'undefined' ? jQuery : AJS.$);
/*[{!sbs_diff_js_dr0w52g!}]*/
;
/* END /2static/script/fe/sbs-diff.js */
/* START /2static/script/fecru/issue-dialog.js */
window.FECRU = window.FECRU || {};
FECRU.ISSUEDIALOG = (function () {

    var dialog;

    AJS.$(document).ready(function () {
        if (!FECRU.isJiraIntegrationPluginEnabled || // dont set up the issue dialog event when there is a JIRA 4.4 server (when the JIRA integration plugin is disabled)
            !window.top.jiraIntegration) { // if we're in an iframe with no outer window
            return;
        }

        var getDialog = function (self, e) {
            if (!dialog) {
                dialog = new window.top.jiraIntegration.JiraIssuesDialog({
                    oauthTriggerClass: 'ual-authenticate',
                    ajax: function (options) {
                        return AJS.$.ajax(AJS.$.extend({
                            cache: false // so IE doesnt cache it
                        }, options));
                    }
                });

                var onTransitioned = function (issueKey) {
                    setTimeout(function () {
                        CRU.UI.reloadInlineJiraIssues([issueKey]);
                        if (window.RIL && AJS.$('.jira-issues-report-row[data-jira-issue-key=' + issueKey + ']').length) {
                            RIL.insertReviewReport();
                        }
                    }, 0);
                };

                dialog.on('transitioned', onTransitioned);
            }
            dialog.on('authorizationRequired', function (authUrl, applicationName) {
                window.top.FECRU.OAUTH.getEventProducer(authUrl).authorized(function () {
                    window.top.FECRU.HOVER.invalidateCache(window.top.FECRU.HOVER.CACHE_FOREVER); // we dont know what key to remove, so remove all
                    if (typeof window.top.CRU !== 'undefined' && window.top.CRU.UI && window.top.CRU.UI.loadInlineJiraIssues) {
                        window.top.CRU.UI.loadInlineJiraIssues(); // might as well reload all issues
                    }
                    dialog.onAuthorizationSucceeded(authUrl);
                });
            });

            var issueKey;
            var $this = AJS.$(self);
            if ($this.is('a')) {
                issueKey = $this.text();
            } else {
                issueKey = $this.children('a').text();
            }

            if (typeof window.top.review !== 'undefined' && window.top.review.projectKey()) {
                dialog.setEntityKey('project.' + window.top.review.projectKey());
            } else if (window.top.FECRU && window.top.FECRU.INFO && window.top.FECRU.INFO.repoName) {
                dialog.setEntityKey('repository.' + window.top.FECRU.INFO.repoName);
            } else {
                dialog.setEntityKey(null);
            }

            dialog.setIssueKeys([issueKey]);
            dialog.setTitle('JIRA Issue \'' + issueKey + '\'');

            return dialog;
        };

        AJS.$('body').delegate('.jira-hover-trigger', 'click', function (e) {
            // Right click fires a click event in Firefox but not in Chrome
            if (FECRU.isRightClick(e) || !FECRU.openInSameTab(e)) {
                return;
            }
            e.stopPropagation();
            e.preventDefault();

            var dialog = getDialog(this, e);

            dialog.show();
        });
    });

})();
/*[{!issue_dialog_js_n95s53u!}]*/;
/* END /2static/script/fecru/issue-dialog.js */
/* START /2static/script/lib/ZeroClipboard-1.2.1.min.js */
/*!
* ZeroClipboard
* The ZeroClipboard library provides an easy way to copy text to the clipboard using an invisible Adobe Flash movie and a JavaScript interface.
* Copyright (c) 2013 Jon Rohan, James M. Greene
* Licensed MIT
* http://zeroclipboard.org/
* v1.2.1
*/
!function(){"use strict";var a,b=function(){var a=/\-([a-z])/g,b=function(a,b){return b.toUpperCase()};return function(c){return c.replace(a,b)}}(),c=function(a,c){var d,e,f,g,h,i;if(window.getComputedStyle?d=window.getComputedStyle(a,null).getPropertyValue(c):(e=b(c),d=a.currentStyle?a.currentStyle[e]:a.style[e]),"cursor"===c&&(!d||"auto"===d))for(f=a.tagName.toLowerCase(),g=["a"],h=0,i=g.length;i>h;h++)if(f===g[h])return"pointer";return d},d=function(a){if(p.prototype._singleton){a||(a=window.event);var b;this!==window?b=this:a.target?b=a.target:a.srcElement&&(b=a.srcElement),p.prototype._singleton.setCurrent(b)}},e=function(a,b,c){a.addEventListener?a.addEventListener(b,c,!1):a.attachEvent&&a.attachEvent("on"+b,c)},f=function(a,b,c){a.removeEventListener?a.removeEventListener(b,c,!1):a.detachEvent&&a.detachEvent("on"+b,c)},g=function(a,b){if(a.addClass)return a.addClass(b),a;if(b&&"string"==typeof b){var c=(b||"").split(/\s+/);if(1===a.nodeType)if(a.className){for(var d=" "+a.className+" ",e=a.className,f=0,g=c.length;g>f;f++)d.indexOf(" "+c[f]+" ")<0&&(e+=" "+c[f]);a.className=e.replace(/^\s+|\s+$/g,"")}else a.className=b}return a},h=function(a,b){if(a.removeClass)return a.removeClass(b),a;if(b&&"string"==typeof b||void 0===b){var c=(b||"").split(/\s+/);if(1===a.nodeType&&a.className)if(b){for(var d=(" "+a.className+" ").replace(/[\n\t]/g," "),e=0,f=c.length;f>e;e++)d=d.replace(" "+c[e]+" "," ");a.className=d.replace(/^\s+|\s+$/g,"")}else a.className=""}return a},i=function(){var a,b,c,d=1;return"function"==typeof document.body.getBoundingClientRect&&(a=document.body.getBoundingClientRect(),b=a.right-a.left,c=document.body.offsetWidth,d=Math.round(100*(b/c))/100),d},j=function(a){var b={left:0,top:0,width:0,height:0,zIndex:999999999},d=c(a,"z-index");if(d&&"auto"!==d&&(b.zIndex=parseInt(d,10)),a.getBoundingClientRect){var e,f,g,h=a.getBoundingClientRect();"pageXOffset"in window&&"pageYOffset"in window?(e=window.pageXOffset,f=window.pageYOffset):(g=i(),e=Math.round(document.documentElement.scrollLeft/g),f=Math.round(document.documentElement.scrollTop/g));var j=document.documentElement.clientLeft||0,k=document.documentElement.clientTop||0;b.left=h.left+e-j,b.top=h.top+f-k,b.width="width"in h?h.width:h.right-h.left,b.height="height"in h?h.height:h.bottom-h.top}return b},k=function(a,b){var c=!(b&&b.useNoCache===!1);return c?(-1===a.indexOf("?")?"?":"&")+"nocache="+(new Date).getTime():""},l=function(a){var b=[],c=[];return a.trustedOrigins&&("string"==typeof a.trustedOrigins?c.push(a.trustedOrigins):"object"==typeof a.trustedOrigins&&"length"in a.trustedOrigins&&(c=c.concat(a.trustedOrigins))),a.trustedDomains&&("string"==typeof a.trustedDomains?c.push(a.trustedDomains):"object"==typeof a.trustedDomains&&"length"in a.trustedDomains&&(c=c.concat(a.trustedDomains))),c.length&&b.push("trustedOrigins="+encodeURIComponent(c.join(","))),"string"==typeof a.amdModuleId&&a.amdModuleId&&b.push("amdModuleId="+encodeURIComponent(a.amdModuleId)),"string"==typeof a.cjsModuleId&&a.cjsModuleId&&b.push("cjsModuleId="+encodeURIComponent(a.cjsModuleId)),b.join("&")},m=function(a,b){if(b.indexOf)return b.indexOf(a);for(var c=0,d=b.length;d>c;c++)if(b[c]===a)return c;return-1},n=function(a){if("string"==typeof a)throw new TypeError("ZeroClipboard doesn't accept query strings.");return a.length?a:[a]},o=function(a,b,c,d,e){e?window.setTimeout(function(){a.call(b,c,d)},0):a.call(b,c,d)},p=function(a,b){if(a&&(p.prototype._singleton||this).glue(a),p.prototype._singleton)return p.prototype._singleton;p.prototype._singleton=this,this.options={};for(var c in s)this.options[c]=s[c];for(var d in b)this.options[d]=b[d];this.handlers={},p.detectFlashSupport()&&v()},q=[];p.prototype.setCurrent=function(b){a=b,this.reposition();var d=b.getAttribute("title");d&&this.setTitle(d);var e=this.options.forceHandCursor===!0||"pointer"===c(b,"cursor");return r.call(this,e),this},p.prototype.setText=function(a){return a&&""!==a&&(this.options.text=a,this.ready()&&this.flashBridge.setText(a)),this},p.prototype.setTitle=function(a){return a&&""!==a&&this.htmlBridge.setAttribute("title",a),this},p.prototype.setSize=function(a,b){return this.ready()&&this.flashBridge.setSize(a,b),this},p.prototype.setHandCursor=function(a){return a="boolean"==typeof a?a:!!a,r.call(this,a),this.options.forceHandCursor=a,this};var r=function(a){this.ready()&&this.flashBridge.setHandCursor(a)};p.version="1.2.1";var s={moviePath:"ZeroClipboard.swf",trustedOrigins:null,text:null,hoverClass:"zeroclipboard-is-hover",activeClass:"zeroclipboard-is-active",allowScriptAccess:"sameDomain",useNoCache:!0,forceHandCursor:!1};p.setDefaults=function(a){for(var b in a)s[b]=a[b]},p.destroy=function(){p.prototype._singleton.unglue(q);var a=p.prototype._singleton.htmlBridge;a.parentNode.removeChild(a),delete p.prototype._singleton},p.detectFlashSupport=function(){var a=!1;if("function"==typeof ActiveXObject)try{new ActiveXObject("ShockwaveFlash.ShockwaveFlash")&&(a=!0)}catch(b){}return!a&&navigator.mimeTypes["application/x-shockwave-flash"]&&(a=!0),a};var t=null,u=null,v=function(){var a=p.prototype._singleton,b=document.getElementById("global-zeroclipboard-html-bridge");if(!b){var c={};for(var d in a.options)c[d]=a.options[d];c.amdModuleId=t,c.cjsModuleId=u;var e=l(c),f='      <object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" id="global-zeroclipboard-flash-bridge" width="100%" height="100%">         <param name="movie" value="'+a.options.moviePath+k(a.options.moviePath,a.options)+'"/>         <param name="allowScriptAccess" value="'+a.options.allowScriptAccess+'"/>         <param name="scale" value="exactfit"/>         <param name="loop" value="false"/>         <param name="menu" value="false"/>         <param name="quality" value="best" />         <param name="bgcolor" value="#ffffff"/>         <param name="wmode" value="transparent"/>         <param name="flashvars" value="'+e+'"/>         <embed src="'+a.options.moviePath+k(a.options.moviePath,a.options)+'"           loop="false" menu="false"           quality="best" bgcolor="#ffffff"           width="100%" height="100%"           name="global-zeroclipboard-flash-bridge"           allowScriptAccess="always"           allowFullScreen="false"           type="application/x-shockwave-flash"           wmode="transparent"           pluginspage="http://www.macromedia.com/go/getflashplayer"           flashvars="'+e+'"           scale="exactfit">         </embed>       </object>';b=document.createElement("div"),b.id="global-zeroclipboard-html-bridge",b.setAttribute("class","global-zeroclipboard-container"),b.setAttribute("data-clipboard-ready",!1),b.style.position="absolute",b.style.left="-9999px",b.style.top="-9999px",b.style.width="15px",b.style.height="15px",b.style.zIndex="9999",b.innerHTML=f,document.body.appendChild(b)}a.htmlBridge=b,a.flashBridge=document["global-zeroclipboard-flash-bridge"]||b.children[0].lastElementChild};p.prototype.resetBridge=function(){return this.htmlBridge.style.left="-9999px",this.htmlBridge.style.top="-9999px",this.htmlBridge.removeAttribute("title"),this.htmlBridge.removeAttribute("data-clipboard-text"),h(a,this.options.activeClass),a=null,this.options.text=null,this},p.prototype.ready=function(){var a=this.htmlBridge.getAttribute("data-clipboard-ready");return"true"===a||a===!0},p.prototype.reposition=function(){if(!a)return!1;var b=j(a);return this.htmlBridge.style.top=b.top+"px",this.htmlBridge.style.left=b.left+"px",this.htmlBridge.style.width=b.width+"px",this.htmlBridge.style.height=b.height+"px",this.htmlBridge.style.zIndex=b.zIndex+1,this.setSize(b.width,b.height),this},p.dispatch=function(a,b){p.prototype._singleton.receiveEvent(a,b)},p.prototype.on=function(a,b){for(var c=a.toString().split(/\s/g),d=0;d<c.length;d++)a=c[d].toLowerCase().replace(/^on/,""),this.handlers[a]||(this.handlers[a]=b);return this.handlers.noflash&&!p.detectFlashSupport()&&this.receiveEvent("onNoFlash",null),this},p.prototype.addEventListener=p.prototype.on,p.prototype.off=function(a,b){for(var c=a.toString().split(/\s/g),d=0;d<c.length;d++){a=c[d].toLowerCase().replace(/^on/,"");for(var e in this.handlers)e===a&&this.handlers[e]===b&&delete this.handlers[e]}return this},p.prototype.removeEventListener=p.prototype.off,p.prototype.receiveEvent=function(b,c){b=b.toString().toLowerCase().replace(/^on/,"");var d=a,e=!0;switch(b){case"load":if(c&&parseFloat(c.flashVersion.replace(",",".").replace(/[^0-9\.]/gi,""))<10)return this.receiveEvent("onWrongFlash",{flashVersion:c.flashVersion}),void 0;this.htmlBridge.setAttribute("data-clipboard-ready",!0);break;case"mouseover":g(d,this.options.hoverClass);break;case"mouseout":h(d,this.options.hoverClass),this.resetBridge();break;case"mousedown":g(d,this.options.activeClass);break;case"mouseup":h(d,this.options.activeClass);break;case"datarequested":var f=d.getAttribute("data-clipboard-target"),i=f?document.getElementById(f):null;if(i){var j=i.value||i.textContent||i.innerText;j&&this.setText(j)}else{var k=d.getAttribute("data-clipboard-text");k&&this.setText(k)}e=!1;break;case"complete":this.options.text=null}if(this.handlers[b]){var l=this.handlers[b];"string"==typeof l&&"function"==typeof window[l]&&(l=window[l]),"function"==typeof l&&o(l,d,this,c,e)}},p.prototype.glue=function(a){a=n(a);for(var b=0;b<a.length;b++)-1==m(a[b],q)&&(q.push(a[b]),e(a[b],"mouseover",d));return this},p.prototype.unglue=function(a){a=n(a);for(var b=0;b<a.length;b++){f(a[b],"mouseover",d);var c=m(a[b],q);-1!=c&&q.splice(c,1)}return this},"function"==typeof define&&define.amd?define(["require","exports","module"],function(a,b,c){return t=c&&c.id||null,p}):"object"==typeof module&&module&&"object"==typeof module.exports&&module.exports?(u=module.id||null,module.exports=p):window.ZeroClipboard=p}();/*[{!ZeroClipboard_1_2_1_min_js_vsrm54r!}]*/;
/* END /2static/script/lib/ZeroClipboard-1.2.1.min.js */
/* START /2static/script/fecru/selection-history.js */
window.FECRU = window.FECRU || {};

FECRU.SELECTIONHISTORY = FECRU.SELECTIONHISTORY || {};

(function ($) {

    $(document).ready(function (e) {

        FECRU.SELECTIONHISTORY.displayDiff = function (revId, iframeheight) {
            var $iframeHolder = AJS.$('#iframe-holder');

            if (AJS.$('html').hasClass('safari')) {
                $iframeHolder.children().css('display', 'none');
            } else {
                $iframeHolder.children().css('visibility', 'hidden');
            }

            $iframeHolder.children('.aui-message').remove();
            var $iframe = $iframeHolder.children('#diff-' + revId);

            var $row = AJS.$('#revision-selection #rev-' + revId);
            var match = $row.data('match');
            var diff = $row.data('diff');
            var url = $row.find('.iframe-url').text().trim();

            var messageHeight = 0;
            if (!match) {
                // we need to display a message
                AJS.messages.warning($iframeHolder, {
                    id: "reselect-warning",
                    insert: "prepend",
                    title: "Time to rescope the search!",
                    body: "We've gone back so far that the lines have become a bit blurry. If you still haven't found what you're after, select the relevant lines from this revision."
                });
                messageHeight = $iframeHolder.children('.aui-message').outerHeight() + 20;
            } else if (!diff) {
                AJS.messages.info($iframeHolder, {
                    id: "reselect-warning",
                    insert: "prepend",
                    title: "We've hit the end!",
                    body: "This is the initial revision of this file. If you still haven't found what you're after, it may have come from a cross-file refactor. Have a look at the commit."
                });
                messageHeight = $iframeHolder.children('.aui-message').outerHeight() + 20;
            }

            if (!$iframe.length) {
                // we need to insert it
                //.attr('src', AJS.$(this).children('span').text());
                $iframeHolder.append(AJS.$('<iframe id="diff-' + revId + '" width="100%" height="' + (iframeheight - 101 - messageHeight) + 'px" src="' + url + '"></iframe>'))
            }

            if (AJS.$('html').hasClass('safari')) {
                $iframe.css('display', 'block');
            } else {
                $iframe.css('visibility', 'visible');
            }

        };

        if (!FECRU.isSelectionHistoryEnabled) {
            return;
        }

        if ($.browser.msie && $.browser.version.substring(0, 2) === '8.') {
            return; // don't support IE8 because it cant easily provide us with the selected lines
        }

        $('body').append('<div id="copy-clipboard">' +
            '<span id="clipboard-container">' +
            '<div id="clipboard-button">Copy</div>' +
            '</span>' +
            '<span id="super-blame">' +
            '<div id="blame-button">Blame</div>' +
            '</span>' +
            '</div>');

        ZeroClipboard.setDefaults({
            moviePath: FECRU.pageContext + '/' + FECRU.staticDirectory + '/2static/flash/ZeroClipboard-1.2.1.swf',
            hoverClass: 'zeroclipboard-is-hover',
            activeClass: "zeroclipboard-is-active"
        });
        var $clipboardButton = AJS.$('#clipboard-button');
        var clipboard = new ZeroClipboard($clipboardButton);

        clipboard.on('noflash', function () {
            $clipboardButton.addClass('hide');
        });
        clipboard.on('wrongflash', function () {
            $clipboardButton.addClass('hide');
        });
        clipboard.on('mouseup', function () {
            AJS.$("#copy-clipboard").css("left", "-999px");
        });

        $(document).delegate("body", "keyup", function (e) {
            if (e.keyCode === 27) {
                $("#copy-clipboard").hide();
            }
        });

        // fancy renderer
        $(document).delegate(".diff-container", "mouseup", function (e) {
            var nodes = getSelectedNodes(e);
            if (!nodes) {
                return true
            }

            var anchorLine = getLineNumberFancyRenderer(nodes.anchorNode);
            var focusLine = getLineNumberFancyRenderer(nodes.focusNode);

            var $diffContentBox = $(nodes.anchorNode).closest('.content-box');

            selectLines(e, anchorLine, focusLine, $diffContentBox.data('path'), $diffContentBox.data('revision'));

            return true;
        });

        // unified diff (single file + changeset)
        $(document).delegate(".annPane.view-diff, .changeset-page #panel-target", "mouseup", function (e) {
            var nodes = getSelectedNodes(e);
            if (!nodes) {
                return true
            }

            var anchorLine = getLineNumberForUnifiedDiff(nodes.anchorNode);
            var focusLine = getLineNumberForUnifiedDiff(nodes.focusNode);

            var $diffTable = $(nodes.anchorNode).closest('table.diff');

            selectLines(e, anchorLine, focusLine, $diffTable.data('path'), $diffTable.data('revision'));

            return true;
        });

        var selectLines = function (e, anchorLine, focusLine, path, revision) {
            var lowestLine = anchorLine < focusLine ? anchorLine : focusLine;
            var highestLine = anchorLine >= focusLine ? anchorLine : focusLine;

            var $copyClipboard = $("#copy-clipboard");
            $copyClipboard.show();
            $copyClipboard.css({
                top: e.pageY + 8,
                left: e.pageX + 8
            });
            $("#blame-button").data('lowLine', lowestLine)
                .data('highLine', highestLine)
                .data('path', path)
                .data('revision', revision);
        };

        window.top.FE.BLAME = window.top.FE.BLAME || {};

        AJS.$('#blame-button').click(function () {
            var $this = $(this);
            var highLine = $this.data('highLine');
            var lowLine = $this.data('lowLine');
            var path = $this.data('path');
            var revision = $this.data('revision');

            var url = FECRU.pageContext + '/line-history/' + window.top.FECRU.INFO.repoName + '/' + path + '?r=' + revision;
            url += '&from=' + lowLine + '&to=' + highLine;

            if (!window.top.FE.BLAME.$dialog) {
                window.top.FE.BLAME.$dialog = window.top.FECRU.DIALOG.ajaxDialog(1280, 768, {}, "super-blame");
                var iframeHeight = window.top.FE.BLAME.$dialog.height - 109;
                window.top.FE.BLAME.$dialog
                    .addHeader("Selection history for revision '" + revision + "' at lines " + lowLine + " to " + highLine)
                    .addPanel("Super Blame", "<div id='" + 'blame-panel' + "'></div>")
                    .addButton("Close", function (d) {
                        d.hide();
                    }, "cancelButton");
                window.top.AJS.$('#blame-panel').append(buildIframe(iframeHeight, url));
            } else {
                window.top.FE.BLAME.$dialog.addHeader("Selection history for revision '" + revision + "' at lines " + lowLine + " to " + highLine);
                iframeHeight = window.top.FE.BLAME.$dialog.height - 109;
                window.top.AJS.$('.selection-history-frame').remove();
                window.top.AJS.$('#blame-panel').append(buildIframe(iframeHeight, url));
            }
            window.top.FE.BLAME.$dialog.show();

            $("#copy-clipboard").hide();
        });

        var buildIframe = function (height, url) {
            return $("<iframe class='selection-history-frame' width='100%' height='" + height + "px' src='" + url + "&iframeHeight=" + height + "'/>");
        };

        var getLineNumberForUnifiedDiff = function (node) {
            var $row = $(node).closest('tr');
            var $commonLineNumbers = $row.children('.diffLineNumbers');
            var $toLineNumbers = $row.children('.diffLineNumbersB');
            var $fromLineNumbers = $row.children('.diffLineNumbersA');
            if ($commonLineNumbers.length) {
                return parseInt($($commonLineNumbers.get(0)).text(), 10);
            } else if ($toLineNumbers.length) {
                return parseInt($($toLineNumbers.get(1)).text(), 10);
            } else if ($fromLineNumbers.length) {
                return parseInt($($fromLineNumbers.get(0)).data("to-equiv"), 10);
            }
            return null;
        };

        var getLineNumberFancyRenderer = function (node) {
            var $row = $(node).closest('pre');
            return parseInt($row.children('.line-num').attr('title'), 10);
        };

        var getSelectedNodes = function (e) {
            var selection = window.getSelection();
            if (selection.anchorNode == null ||
                $(e.target).attr('id') === 'blame-button') {
                return null;
            }

            return {
                anchorNode: selection.anchorNode,
                focusNode: selection.focusNode
            }
        };

    });

})(AJS.$);
/*[{!selection_history_js_de2a546!}]*/;
/* END /2static/script/fecru/selection-history.js */
