/* CONCAT of
/2static/script/cru/patch-ui.js
/2static/script/cru/create/create.js
/2static/script/cru/create/create-event.js
*/
/* START /2static/script/cru/patch-ui.js */
window.CRU = window.CRU || {};
CRU.PATCHES = (function ($) {

    var fecruAjax = FECRU.AJAX;

    function ajaxCall($controls, params, callback) {
        if ($controls.is('.disabled')) {
            return;
        }

        params = params || {};
        if (params.patchId == null) {
            params.patchId = $controls.attr('id').replace('patch-controls-', '');
        }

        fecruAjax.startSpin($controls);
        $controls.find('select').prop('disabled', true);
        var $controlButtons = $controls.find('.patch-control-buttons');
        $controlButtons.addClass('disabled');
        var url = CRU.UTIL.jsonUrlBase(permaId) + '/anchor-patch/';

        var cancelled = false;
        var ended = false;

        fecruAjax.ajaxDo(url, params, function (resp) {
            $controls.data('cancel', null);
            if (cancelled) {
                return;
            }
            ended = true;

            //replace controls

            var $messagesContainer = $("#anchor-messages-container");
            $messagesContainer.html('');
            if (resp.showErrors) {
                var errorTitle;
                if (params && params.allrepos) {
                    errorTitle = 'No repository found to anchor patch to';
                } else if (params && params.anchorSource) {
                    errorTitle = 'Crucible cannot anchor the patch to this repository'
                } else {
                    errorTitle = null;
                }

                $.each(resp.errors, function (index, value) {
                    AJS.messages.warning($messagesContainer, {
                        title: errorTitle,
                        body: value
                    })
                });
            }

            if (resp.showMessages) {
                $.each(resp.messages, function (index, value) {
                    AJS.messages.success($messagesContainer, {
                        body: value
                    })
                });
            }

            endAjaxCall($controls, $controlButtons);
            callback && callback(resp);
        });

        $controls.data('cancel', function cancel() {
            if (ended) {
                return;
            }
            cancelled = true;
            callback && callback();
            endAjaxCall($controls, $controlButtons);
        });
    }

    function endAjaxCall($controls, $controlButtons) {
        fecruAjax.stopSpin($controls[0], 'span');

        $controls.find('select').prop('disabled', false);
        $controlButtons.removeClass('disabled');
    }

    function removePaths($repoSelect, $pathSelectSection) {
        $repoSelect.val('');
        $pathSelectSection.addClass('hidden').data('forRepo', '');
    }

    function populatePaths($repoSelect, $pathSelectSection, optionsString, anchorSource) {

        if ($pathSelectSection.data('forRepo') === anchorSource) {
            return;
        }

        if (optionsString == null) {
            removePaths($repoSelect, $pathSelectSection);
            return;
        }

        $repoSelect.val(anchorSource);

        var $pathSelect = $pathSelectSection.find("select.anchored-path-edit");
        if (optionsString !== "") {
            $pathSelect.html(optionsString);
            $pathSelectSection.removeClass('hidden');
        } else {
            $pathSelectSection.addClass('hidden');
        }
        $pathSelectSection.data('forRepo', anchorSource);
    }

    function anchorPatch($controls, params) {
        $controls.removeClass('editing viewing').addClass('anchoring');
        ajaxCall($controls, params, function (resp) {
            $controls.removeClass('anchoring');

            if (resp && resp.worked) {
                if (resp.anchorSucceeded) { // true if the anchor succeeds or the unanchor succeeds, but not if there are errors either way.
                    var anchored = !!resp.anchorRepo;
                    $controls.addClass('viewing')
                        .toggleClass('anchored', anchored)
                        .toggleClass('unanchored', !anchored);

                    var $currentAnchor = $controls.find('.current-anchor');
                    $currentAnchor.children('.anchored-source').text(resp.anchorRepo);
                    $currentAnchor.children('.anchored-path').text(resp.anchorPath);
                    updateIterablePatches(params)
                } else {
                    $controls.addClass('editing');
                    updateIterablePatches(null)
                }

                populatePaths(
                    $controls.find('.anchored-source-edit'),
                    $controls.find('.anchor-path-selection'),
                    resp.candidatePaths,
                    resp.anchorRepo || params && params.anchorSource);
            } else if (!resp) {
                // cancelled
                removePaths(
                    $controls.find('.anchored-source-edit'),
                    $controls.find('.anchor-path-selection'));
                updateIterablePatches(null)
            }
        });
    }

    function getPaths($controls, anchorSource, callback) {
        if (!anchorSource) {
            callback && callback();
            return;
        }

        var $pathSelectSection = $controls.find('.anchor-path-selection');
        if ($pathSelectSection.data('forRepo') === anchorSource) {
            callback && callback();
        } else {
            var params = {
                anchorSource: anchorSource,
                showCandidatePaths: true
            };
            ajaxCall($controls, params, function (resp) {
                if (resp && resp.worked) {
                    populatePaths(
                        $controls.find('.anchored-source-edit'),
                        $pathSelectSection,
                        resp.candidatePaths,
                        anchorSource);

                    callback && callback();
                } else if (!resp) {
                    // cancelled
                    removePaths(
                        $controls.find('.anchored-source-edit'),
                        $controls.find('.anchor-path-selection'));
                }
            });
        }
    }

    function updateIterablePatches(params) {
        var $choosePatch = $('#choose-existing-patch');
        if (!params) {
            $choosePatch.html('');
            $('#add-to-existing-patch').prop('disabled', true);
            $('#new-patch').prop('checked', true);
        } else {
            getIterablePatches($choosePatch, params.patchId)
        }
    }

    function getIterablePatches($target, patchId) {
        var url = CRU.UTIL.jsonUrlBase(permaId) + '/iterable-patches/';
        fecruAjax.startSpin($('#anchor-repository'));
        fecruAjax.ajaxDo(url, {patchId: patchId}, function (resp) {
            fecruAjax.stopSpin($('#anchor-repository'));
            if (resp.found === 'true') {
                $('#patch-action').show();
                $target.html(resp.payload);
                var $add = $("#add-to-existing-patch");
                $add.prop('disabled', false);
                $add.prop('checked', true);
                $target.find('input').first().prop('checked', 'true')
            } else {
                $target.html('');
            }
        });
    }

    return {
        getPaths: getPaths,
        anchorPatch: anchorPatch
    };
})(AJS.$);
/*[{!patch_ui_js_yvkx50u!}]*/;
/* END /2static/script/cru/patch-ui.js */
/* START /2static/script/cru/create/create.js */
window.CRU = window.CRU || {};
CRU.CREATE = {};

(function ($) {
    var cruCreate = CRU.CREATE;

    cruCreate.changesets = {}; // map of csid -> array of revids
    cruCreate.revid2csid = {};
    cruCreate.revidsInIteration = {};
    cruCreate.repnameInUse = "";
    cruCreate.explorer = {};

    cruCreate.addLatestRevision = function (frxId, revid) {
        var done = function (resp) {
            if (resp.worked) {
                $("#frx-outdated" + frxId).hide();
            }
        };
        return cruCreate.addRevisionFromView('add', frxId, revid, done);
    };

    cruCreate.addRevisionFromView = function (command, frxId, revid, done) {
        var cruFrx = CRU.FRX;
        var frx = review.frx(frxId);
        var params = {
            "revid": revid,
            "command": command,
            "frxId": frxId,
            "attachMethod": "ITERATION",     // string value of Review.AttachMethod.ITERATION
            "fromRev": frx.visibleFromRevision(),
            "toRev": frx.visibleToRevision()
        };
        $.extend(params, CRU.FRX.diffParamsMap(frxId));

        var url = CRU.UTIL.jsonUrlBase(permaId) + "/editRevisionsFromRevisionAjax/";

        cruFrx.dimFrx(frxId);
        var onComp = function (resp) {
            if (!resp.worked) {
                cruFrx.unDimFrx(frxId);
            } else {
                if (resp.reloadReview) {
                    // we are refreshing the entire review
                    CRU.REVIEW.UTIL.reloadReview(true);
                }
                if (resp.reviewDueDate) {
                    //update review due date text
                    $('#review-meta-info .review-due-text').html(resp.reviewDueDate);
                }
                if (resp.frxExists) {
                    var cruFrxAjax = cruFrx.AJAX;
                    cruFrxAjax.shelveFrxControls(frxId);
                    $('#frxouter' + frxId).html(resp.payload);
                    cruFrxAjax.unshelveFrxControls(frxId);
                    cruFrxAjax.reloadFrxModel(frxId, resp, false);
                    cruFrxAjax.updateFrxSlider(frxId, resp);
                    cruFrxAjax.updateFrxDiffControls(frxId, resp);
                    cruFrxAjax.updateFrxEditRevisionsDropdown(frxId);
                    commentator.reloadFrxCommentCount(review.frx(frxId));
                } else {
                    cruCreate.removeFrxFromPage(frxId);
                }
            }
            if (done) {
                done({worked: resp.worked});
            }
        };
        FECRU.AJAX.ajaxUpdate(url, params, null, onComp);
        return false;
    };

    //remove an frx from the page entirely - only should be done if the file was removed from the review.
    cruCreate.removeFrxFromPage = function (frxId) {
        //remove frx
        var frx = review.frx(frxId);
        // frx may not actually be in the page for any number of reasons. do a sanity check.
        if (!frx) {
            return;
        }

        var currentlyViewing;
        var currentFrxElem = CRU.FRX.NAV.getCurrentFrxElement();
        if (currentFrxElem) {
            var currentFrxElementId = $(currentFrxElem).attr('id');
            var id = currentFrxElementId !== 'generalComments' ?
                currentFrxElementId.replace(/^frxouter/, '') :
                currentFrxElementId;

            currentlyViewing = frxId == id; // eslint-disable-line eqeqeq
        }
        review.removeFrx(frx);
        var $toRemove = $('#frx-list-item' + frxId);
        var $selectNext;
        var $toRemoveFolderSpan = $toRemove.children(".folder");
        if ($toRemoveFolderSpan.length > 0) {
            var $toRemoveFolderFrxDirItem = $toRemoveFolderSpan.children(".frx-dir-item");
            //if this is an frx with children, dont remove it, just remove the classes on it
            $toRemove.removeClass("activeFrx");
            $toRemoveFolderSpan.removeClass("frx-incomplete");
            $toRemoveFolderFrxDirItem.replaceWith($toRemoveFolderFrxDirItem.html());
            $toRemoveFolderSpan.find('.removeFrx, .spinner').remove();
            if (currentlyViewing) {
                $selectNext = $toRemove.find('.frx:first');
            }
        } else {
            while ($toRemove.hasClass('frx-list-item') && $toRemove.siblings().length === 0) {
                if ($toRemove.parent().attr('id') === 'tree-root') {
                    break;
                }
                var _$toRemove = $toRemove.parents('.frx-list-item:first');
                if (_$toRemove.length === 1) {
                    $toRemove = _$toRemove;
                } else {
                    break;
                }
            }
            //get next frx to select
            if (currentlyViewing) {
                $selectNext = $toRemove.next().find('.frx:first');
            }
            if ($toRemove) {
                $toRemove.remove();
            }
        }

        if (currentlyViewing) {
            if ($selectNext.length !== 1) {
                $selectNext = $('#navigation-tree .frx').filter(':last');
            }
            if ($selectNext.length !== 1) {
                $('#scroll-to-general-comments').click();
            } else {
                $selectNext.find('.scroll-to-frx').click();
            }
        }
        $('#frxouter' + frxId).remove();
        $('#frxControlsContainer' + frxId).remove();

        CRU.FRX.NAV.visibleFrxsChanged();
        CRU.COMMENT.NAV.visibleCommentsChanged();
    };

    cruCreate.retrieveNewFrxs = function (done) {
        var url = CRU.UTIL.jsonUrlBase(permaId) + "/retrieveNewFrxsAjax/";

        var onComp = function (resp) {
            if (resp.worked) {
                var activeTreeElem = $('#navigation-tree .activeFrx').attr('id');
                $('#navigation-tree').html(resp.navTree);
                $('#navigation-tree .activeFrx').removeClass('activeFrx');
                $('#' + activeTreeElem).addClass('activeFrx');
                AJS.$.each(review.frxs(), function (idx, frx) {
                    frx.invalidateCachedSelectors();
                });

                var insertAfter = 'generalComments';
                var frxs = resp.frxs;
                var frxIds = [];
                for (var i = 0, len = frxs.length; i < len; i++) {
                    var frxId = frxs[i].frxId;
                    var frxHtml = frxs[i].frxHtml;
                    if (!review.frx(frxId)) {
                        $(frxHtml).insertAfter('#' + (insertAfter !== 'generalComments' ? 'frxouter' + insertAfter : insertAfter));
                        eval('var frxModelLoader = ' + frxs[i].frxModelLoader);
                        frxModelLoader(insertAfter);
                        frxIds.push(frxId);
                    }
                    if (review.frx(frxId)) {
                        insertAfter = frxId;
                    }
                }

                if (done) {
                    done();
                }

                CRU.FRX.AJAX.prioritisedFrxLoad(frxIds);
            }
        };

        FECRU.AJAX.ajaxUpdate(url, {}, null, onComp);
        return false;

    };

    var addRemoveRevisionToIter = function (add, revid) {
        var busyid = "busyRev" + revid;
        var nochangeid = "";
        var $revPath = $("#revPath" + revid);
        toggleNodeAndImage(busyid, true, false, true);
        if (add) {
            toggleNodeAndImage("addRev" + revid, false, true, true);
            nochangeid = "addRev" + revid;
            $revPath.css("textDecoration", "");
        } else {
            toggleNodeAndImage("remRev" + revid, false, true, true);
            nochangeid = "remRev" + revid;
            $revPath.css("textDecoration", "line-through");
        }
        var params = {
            "revid": revid,
            "command": add ? "add" : "remove",
            "attachMethod": $("#attachMethod").val(),
            "fromRevision": $("#fromRevision").val()
        };
        var url = CRU.UTIL.jsonUrlBase(permaId) + "/editRevisionsAjax/";
        return doAddRemoveCall(url, params, busyid, nochangeid);
    };

    cruCreate.addRevisionToIter = function (revid) {
        addRemoveRevisionToIter(true, revid);
    };

    cruCreate.removeRevisionFromIter = function (revid) {
        addRemoveRevisionToIter(false, revid);
    };

    cruCreate.addAllSearchRevisions = function (url, spinnerId) {
        $('#' + spinnerId).css('display', 'inline');
        url += "&command=addSearch";
        url += "&search=" + $("#qlStr").val();
        url += "&spage=" + $("#results.thisPageNum").val();
        url += "&attachMethod=" + $("#attachMethod").val();
        url += "&fromRevision=" + $("#fromRevision").val();
        FECRU.XSRF.postUri(url);
    };

    var doAddMultipleCall = function (url, params) {
        var done = function (resp) {
            if (!resp.worked || FECRU.AJAX.checkError(resp)) {
                return false;
            }
            updateRespMsgBusy(resp.msgHtml);

            var updatedChangesets = {};

            $.each(resp.addedRevids, function () {
                var addedRevid = this;
                updatedChangesets[cruCreate.revid2csid[addedRevid]] = 1;
                cruCreate.revidsInIteration[addedRevid] = 1;
                toggleNodeAndImage("addRev" + addedRevid, false, true, true);
                toggleNodeAndImage("remRev" + addedRevid, true, false, true);
            });
            for (var csid in updatedChangesets) {
                if (updatedChangesets.hasOwnProperty(csid)) {
                    updateChangesetAddRemove(csid);
                }
            }
        };

        FECRU.AJAX.ajaxDo(url, params, done);
    };

    cruCreate.addRevisionsToIter = function (permaId, revIdArray) {
        $.each(revIdArray, function () {
            $("#revPath" + this).css("textDecoration", "");
        });
        var params = {
            "revid": revIdArray,
            "command": "add",
            "attachMethod": $("#attachMethod").val(),
            "fromRevision": $("#fromRevision").val()
        };
        var url = CRU.UTIL.jsonUrlBase(permaId) + "/editRevisionsAjax/";

        return doAddMultipleCall(url, params);
    };


    var doAddRemoveCall = function (url, params, busyid, nochangeid, extraDone) {
        var done = function (resp) {
            if (!resp.worked || FECRU.AJAX.checkError(resp)) {
                toggleNodeAndImage(busyid, false, true, true);
                toggleNodeAndImage(nochangeid, true, false, true);
                return false;
            }
            updateRespMsgBusy(resp.msgHtml);

            var updatedChangesets = {};

            toggleNodeAndImage(busyid, false, true, true);
            toggleNodeAndImage(nochangeid, true, false, true);

            $.each(resp.addedRevids, function () {
                updatedChangesets[cruCreate.revid2csid[this]] = 1;
                cruCreate.revidsInIteration[this] = 1;
                toggleNodeAndImage("addRev" + this, false, true, true);
                toggleNodeAndImage("remRev" + this, true, false, true);
            });
            $.each(resp.removedRevids, function () {
                updatedChangesets[cruCreate.revid2csid[this]] = 1;
                cruCreate.revidsInIteration[this] = 0;
                toggleNodeAndImage("addRev" + this, true, false, true);
                toggleNodeAndImage("remRev" + this, false, true, true);
            });

            for (var csid in updatedChangesets) {
                if (updatedChangesets.hasOwnProperty(csid)) {
                    updateChangesetAddRemove(csid);
                }
            }

            extraDone && extraDone(resp);
        };

        FECRU.AJAX.ajaxDo(url, params, done);
    };

    /**
     *
     * @param csid
     * @param showRemove show a tick / everything is already in review
     * @param showSome show an orange box / some items are in review
     * @param showAdd show an empty box / no items are in review
     */
    var updateChangesetAddRemove = function (csid, showRemove, showSome, showAdd) {
        var revids = cruCreate.changesets[csid];
        if (!showRemove && !showSome && !showAdd) {
            if (!revids) {
                return;
            }
            var inCount = 0;
            $.each(revids, function () {
                if (cruCreate.revidsInIteration[this] == 1) { // eslint-disable-line
                    inCount++;
                }
            });
            showAdd = inCount < revids.length;
            showRemove = inCount > 0;
            showSome = showAdd && showRemove;
            if (showSome) {
                showAdd = false;
                showRemove = false;
            }
        }
        var $csidLi = AJS.$("#csid-" + csid);
        var isMetadataOnlyChange = $csidLi.data('metadataonlychange');
        var isPartialMetadataChange = $csidLi.data('partialmetadatachange');

        //partial metadata changes will never fully be selected
        showSome = showSome || (showRemove && isPartialMetadataChange);
        //partial metadata changes will never be fully selected
        showRemove = showRemove && !isPartialMetadataChange;
        //metadata only changes will never show the add all checkbox state
        showAdd = showAdd && !isMetadataOnlyChange;

        toggleNodeAndImage("addCs" + csid, showAdd, !showAdd, true);
        toggleNodeAndImage("remCs" + csid, showRemove, !showRemove, true);
        toggleNodeAndImage("containsSome" + csid, showSome, !showSome, true);
        toggleNodeAndImage("metadataOnlyCs" + csid, isMetadataOnlyChange, !isMetadataOnlyChange, true);
    };

    cruCreate.addChangesetToIter = function (csid) {
        addRemoveChangesetToIter(true, csid);
    };

    cruCreate.removeChangesetFromIter = function (csid) {
        addRemoveChangesetToIter(false, csid);
    };

    var addRemoveChangesetToIter = function (add, csid) {
        var addCsIsHidden = $("#addCs" + csid).is(":hidden");
        var isPartialMetadataChange = $("#csid-" + csid).data("partialmetadatachange");

        // used to revert the spinner
        var showRemove = !add;
        var showSome = add && addCsIsHidden;
        var showAdd = add && !addCsIsHidden;

        var busyid = "busyCs" + csid;
        var nochangeid = "";
        if (!add) {
            if (isPartialMetadataChange) {
                nochangeid = "containsSome" + csid;
            } else {
                nochangeid = "remCs" + csid;
            }
        } else if (addCsIsHidden) {
            nochangeid = "containsSome" + csid;
        } else {
            nochangeid = "addCs" + csid;
        }
        toggleNodeAndImage(nochangeid, false, true, true);
        toggleNodeAndImage(busyid, true, false, true);

        var params = {
            "csid": csid,
            "command": add ? "add" : "remove",
            "sourceName": cruCreate.repnameInUse,
            "attachMethod": $("#attachMethod").val(),
            "fromRevision": $("#fromRevision").val()
        };

        var url = CRU.UTIL.jsonUrlBase(permaId) + '/editRevisionsAjax/';

        var done = function (resp) {
            if (!!resp.csReviewState) { // otherwise revert the spinner
                showRemove = resp.csReviewState === 'FULL';
                showSome = resp.csReviewState === 'PARTIAL';
                showAdd = resp.csReviewState === 'NONE';
            }
            updateChangesetAddRemove(csid, showRemove, showSome, showAdd);
        };

        doAddRemoveCall(url, params, busyid, nochangeid, done);
    };

    cruCreate.removeAllRevs = function (done) {
        var pars = 'command=removeAll&sourceName=' + cruCreate.repnameInUse;
        var url = CRU.UTIL.jsonUrlBase(permaId) + '/editRevisionsAjax/';
        doAddRemoveCall(url, pars, null, null, done);
    };

    cruCreate.addSearchFileRevToReview = function (revisionId) {
        addRemoveRevisionToIter(true, revisionId);
    };

    cruCreate.removeSearchFileRevToReview = function (revisionId) {
        addRemoveRevisionToIter(false, revisionId);
    };

    cruCreate.dirListRevs = [];

    //this is for the file browse tab
    cruCreate.addFileRevisionToReview = function (latestRevId) {
        var newSelectedRevId = document.forms["selectRevisionForm" + latestRevId].revId.value;
        addRemoveFileRevisionReview(true, newSelectedRevId, latestRevId);
    };

    cruCreate.removeFileRevisionFromReview = function (latestRevId) {
        var newSelectedRevId = document.forms["selectRevisionForm" + latestRevId].revId.value;
        addRemoveFileRevisionReview(false, newSelectedRevId, latestRevId);
    };

    var addRemoveFileRevisionReview = function (add, revid, latestRevId, onEval) {
        var busyid = "busyRev" + latestRevId;
        var nochangeid = "";
        toggleNodeAndImage(busyid, true, false, true);
        if (add) {
            toggleNodeAndImage("addRev" + latestRevId, false, true, true);
            nochangeid = "addRev" + latestRevId;
        } else {
            toggleNodeAndImage("remRev" + latestRevId, false, true, true);
            nochangeid = "remRev" + latestRevId;
        }

        var params = {
            "revid": revid,
            "sourceName": cruCreate.repnameInUse,
            "command": add ? "add" : "remove",
            "attachMethod": $("#attachMethod").val(),
            "fromRevision": $("#fromRevision").val()
        };
        var url = CRU.UTIL.jsonUrlBase(permaId) + '/editRevisionsAjax/';

        return doAddRemoveFRCall(url, params, busyid, nochangeid, latestRevId, onEval);
    };

    var doAddRemoveFRCall = function (url, params, busyid, nochangeid, latestRevId, onEval) {
        var done = function (resp) {
            try {
                // take out the spinner image regardless of what the response is
                toggleNodeAndImage(busyid, false, true, true);
                toggleNodeAndImage(nochangeid, true, false, true);
                if (!resp.worked || FECRU.AJAX.checkError(resp)) {
                    return false;
                }
                updateRespMsgBusy(resp.msgHtml);
                //todo fix this looks wrong
                for (var i = 0; i < resp.removedRevids.length; i++) {
                    cruCreate.dirListRevs[latestRevId] = "";
                    toggleNodeAndImage("addRev" + latestRevId, true, false, true);
                    toggleNodeAndImage("remRev" + latestRevId, false, true, true);
                }
                for (i = 0; i < resp.addedRevids.length; i++) {
                    cruCreate.dirListRevs[latestRevId] = resp.addedRevids[i];
                    toggleNodeAndImage("addRev" + latestRevId, false, true, true);
                    toggleNodeAndImage("remRev" + latestRevId, true, false, true);
                }
                if (onEval) {
                    onEval();
                }
            } catch (error) {
                window.alert(error);
            }
        };

        FECRU.AJAX.ajaxDo(url, params, done);
    };

    var loadFullHistoryDropdown = function (latestRevId) {
        var url = CRU.UTIL.jsonUrlBase(permaId) + '/loadFullHistoryDropdownAjax/';
        var params = {"latestRevId": latestRevId};
        var elementIdToUpdate = "selectDiff" + latestRevId;

        return FECRU.AJAX.ajaxUpdate(url, params, elementIdToUpdate);
    };

    cruCreate.updateSelectedRev = function (latestRevId) {
        var selectBox = document.forms["selectRevisionForm" + latestRevId].revId;
        var formval = selectBox.value;
        if (formval === "__LOADFULL__") {
            FECRU.AJAX.startSpin(selectBox, "", true);
            loadFullHistoryDropdown(latestRevId);
            return;
        }
        var onEval = function () {
            addRemoveFileRevisionReview(true, formval, latestRevId);
        };
        addRemoveFileRevisionReview(false, cruCreate.dirListRevs[latestRevId], latestRevId, onEval);
    };

    /* patch file revision functions */
    cruCreate.patches = [];
    cruCreate.patchesInc = [];
    cruCreate.patchRevs = [];
    cruCreate.incPatchRevs = [];

    cruCreate.addAllPatch = function (patchId) {
        addRemoveAllPatch(true, patchId);
    };

    cruCreate.removeAllPatch = function (patchId) {
        addRemoveAllPatch(false, patchId);
    };

    // must match Source.SEPARATOR
    cruCreate.SOURCE_SEPARATOR = ":";

    var addRemoveAllPatch = function (add, patchID) {
        var incRevs = cruCreate.patchesInc[patchID];
        var revs = cruCreate.patches[patchID];
        $("#addAll" + patchID).hide();
        $("#remAll" + patchID).hide();
        $("#containsSome" + patchID).hide();
        $("#busy" + patchID).show();

        var params = {
            "revid": cruCreate.patches[patchID],
            "command": add ? "add" : "remove"
        };

        var url = CRU.UTIL.jsonUrlBase(permaId) + '/editRevisionsAjax/';

        var done = function (resp) {
            var remRev = function (revId) {
                incRevs[revId] = "";
            };
            var addRev = function (revId) {
                incRevs[revId] = revId;
            };
            updateRespMsgBusy(resp, "busy" + patchID);
            if (resp.worked) {
                updateRevTicks(resp.removedRevids, true, remRev);
                updateRevTicks(resp.addedRevids, false, addRev);
            }
            cruCreate.setAddRemAll(patchID, incRevs, revs);
        };

        FECRU.AJAX.ajaxDo(url, params, done);
    };

    cruCreate.setAddRemAll = function (patchID, incRevs, revs) {
        var $addAll = $("#addAll" + patchID).hide();
        var $remAll = $("#remAll" + patchID).hide();
        var $hasSome = $("#containsSome" + patchID).hide();

        var count = countSelected(incRevs);
        if (count === 0) {
            $addAll.show();
        } else if (count < revs.length) {
            $hasSome.show();
        } else {
            $remAll.show();
        }
    };

    var countSelected = function (incRevs) {
        if (!incRevs) {
            return 0;
        }

        var count = 0;
        for (var i = 0, len = incRevs.length; i < len; i++) {
            if (incRevs[i]) {
                count++;
            }
        }
        return count;
    };

    var updateRespMsgBusy = function (resp, busyId) {
        if (resp.worked) {
            resp.msgHtml && $("#messages").html(resp.msgHtml);
        }
        resp.errors && $("#error-container").html(resp.errors);
        if (busyId) {
            $("#" + busyId).hide();
        }
    };

    var updateRevTicks = function (ids, removed, forEachFunc) {
        $.each(ids, function () {
            if (removed) {
                $("#addRev" + this).show();
                $("#remRev" + this).hide();
            } else {
                $("#addRev" + this).hide();
                $("#remRev" + this).show();
            }
            if (forEachFunc) {
                forEachFunc(this);
            }
        });
    };

    cruCreate.addRemoveFileRevision = function (add, revid, imgPostfix, sourceName) {
        var create = cruCreate;
        var patchID = sourceName.split(create.SOURCE_SEPARATOR)[1];
        var incRevs = create.patchesInc[sourceName];
        var revs = create.patches[sourceName];
        var busyId = "busyRev" + imgPostfix;
        $("#addRev" + imgPostfix).hide();
        $("#remRev" + imgPostfix).hide();
        $("#" + busyId).show();

        var params = {
            "revid": revid,
            "command": add ? "add" : "remove"
        };

        var url = CRU.UTIL.jsonUrlBase(permaId) + "/editRevisionsAjax/";

        var done = function (resp) {
            var remRev = function (revId) {
                if (incRevs) {
                    incRevs[revId] = "";
                }
            };
            var addRev = function (revId) {
                if (incRevs) {
                    incRevs[revId] = revId;
                }
            };
            updateRespMsgBusy(resp, busyId);
            var resetCheckbox = function () {
                if (add) {
                    $("#addRev" + imgPostfix).show();
                } else {
                    $("#remRev" + imgPostfix).show();
                }
            };
            if (resp.worked) {
                updateRevTicks(resp.removedRevids, true, remRev);
                updateRevTicks(resp.addedRevids, false, addRev);
                if (resp.hasErrors) {
                    $("#error-container").html(resp.errors);
                    resetCheckbox();
                } else {
                    $("#error-container").html("");
                }
            } else {
                resetCheckbox();
            }
            create.setAddRemAll(patchID, incRevs, revs);
        };

        FECRU.AJAX.ajaxDo(url, params, done);
    };

    cruCreate.storeStickyPreference = function (key, value) {
        var params = {
            "key": key,
            "value": value
        };
        var url = CRU.UTIL.jsonUrlBase(permaId) + "/storeStickyPreferenceAjax/";

        FECRU.AJAX.ajaxDo(url, params);
    };

    cruCreate.setSpecificDiffVisible = function (attachMethod) {
        if (attachMethod === 'SPECIFIC_DIFF') {
            $('#specificDiff').show();
        } else {
            $('#specificDiff').hide();
        }
        cruCreate.storeStickyPreference('attachMethod', attachMethod);
    };

    cruCreate.submitDetailsForm = function () {
        var cruReviewUtil = CRU.REVIEW.UTIL;
        cruReviewUtil.postEditDetailsForm(function () {
            cruReviewUtil.reloadReview(true, function () {
                cruReviewUtil.unblockReviewUpdatePolling();
            });

            CRU.FRX.AJAX.unblockFrxLoading();
            CRU.UNSAVED.watchForUnsavedChanges();
        });
    };

    cruCreate.submitDetailsFormAndStart = function (done) {
        //reload the entire page for now - wont have to refresh when we can update via polling
        var approve = function () {
            if (done) {
                done();
            }
            CRU.UTIL.stateTransition('action:approveReview', permaId);
        };
        CRU.REVIEW.UTIL.postEditDetailsForm(approve);
    };

    cruCreate.markChanged = function () {
        CRU.UTIL.editDetailsFormChange = true;
    };

    cruCreate.checkEditForm = function (done) {
        return CRU.UTIL.checkEditForm(done);
    };

    cruCreate.cleanPlaceholders = function ($form) {
        $form.find("input").each(function () {
            var $this = $(this);
            if ($this.isPlaceholded()) {
                $this.val("");
            }
        });
    };

    cruCreate.checkEditAndSubmitThis = function (formElement) {
        var submitter = function () {
            var form = formElement.form || (formElement[0] && formElement[0].form);
            cruCreate.cleanPlaceholders($(form));
            $(form).submit();
        };
        FECRU.UI.swapDatesIfReversed(function (dateString) {
            return dateString.substring(0, dateString.indexOf("T"));
        });
        cruCreate.checkEditForm(submitter);
    };

    cruCreate.command = function (cmd, pid, button) {
        CRU.UTIL.command(cmd, pid, button);
    };

    //This validates the saneness of the team selection removing and disabling the
    //selection of author and moderator as reviewers.
    cruCreate.validateTeamSelection = function () {
        var form = document.editDetailsForm;
        var mod = form.newModerator.value;
        var auth = form.newAuthor.value;
        var reviewers = form.reviewers;
        if (reviewers) {
            for (var i = 0, len = reviewers.length; i < len; i++) {
                var reviewer = reviewers[i];
                if (reviewer.value === mod || reviewer.value === auth) {
                    reviewer.checked = false;
                    reviewer.disabled = true;
                } else {
                    reviewer.disabled = false;
                }
            }
        } else if (reviewers) {
            reviewers.checked = false;
            reviewers.disabled = true;
        }
    };

    cruCreate.addInvitee = function () {
        var $input = $("#inviteeInput");
        var invitee = $input.val();
        if (!invitee) {
            return;
        }
        var $invitees = $("#inviteeSpan");

        var $newInvitee = $("<input name='invitees' type='checkbox' checked='checked' tabindex='8'>")
            .val(invitee);

        var $textSpan = $("<span>" + invitee + "; </span>");

        var $newSpan = $("<span id='inv_" + invitee + "'></span>")
            .append($newInvitee)
            .append($textSpan);

        $invitees.append($newSpan);

        CRU.UTIL.editDetailsFormChange = true;
        $input.val('');
    };

    cruCreate.loadChangesets = function ($container, $activityLoading, $newerActivityBtn, explorer, callback) {
        if (cruCreate.explorer.loading) {
            return false;
        }
        cruCreate.explorer.loading = true;

        $.extend(cruCreate.explorer, explorer);

        function isNavigatePast() {
            return cruCreate.explorer.navigate === "past";
        }

        function isNavigateFuture() {
            return cruCreate.explorer.navigate === "future";
        }

        var url = AJS.contextPath() + "/cru/" + encodeURI(permaId) + "/edit-changelog-ajax";
        if (cruCreate.explorer.wbUrl) {
            url += cruCreate.explorer.wbUrl;
        } else {
            url += cruCreate.explorer.wbSpec + "/" + cruCreate.explorer.fullPath;
        }

        if (isNavigatePast()) {
            if (cruCreate.explorer.nextInPast) {
                url += "?toid=" + encodeURI(cruCreate.explorer.nextInPast) + "&inc=" + encodeURI(cruCreate.explorer.nextInPastIsInc);
            } else {
                delete cruCreate.explorer.navigate;
                cruCreate.explorer.loading = false;
                return false;
            }
        } else if (isNavigateFuture()) {
            if (cruCreate.explorer.nextInFuture) {
                url += "?fromid=" + encodeURI(cruCreate.explorer.nextInFuture) + "&inc=" + encodeURI(cruCreate.explorer.nextInFutureIsInc);
            } else {
                delete cruCreate.explorer.navigate;
                cruCreate.explorer.loading = false;
                return false;
            }
        } else {
            if (cruCreate.explorer.jumptoid) {
                url += "?jumptoid=" + cruCreate.explorer.jumptoid;
            }

            $container.html('');
        }

        $activityLoading.show();
        FECRU.AJAX.ajaxUpdate(url, {}, null, function (response) {
            $activityLoading.hide();
            if (isNavigatePast()) {
                if (response.size) {
                    $container.append(response.payload);
                }
                cruCreate.explorer = $.extend(response.explorer, {
                    nextInFuture: cruCreate.explorer.nextInFuture,
                    nextInFutureIsInc: cruCreate.explorer.nextInFutureIsInc
                })
            } else if (isNavigateFuture()) {
                if (response.size) {
                    $container.prepend(response.payload);
                }

                cruCreate.explorer = $.extend(response.explorer, {
                    nextInPast: cruCreate.explorer.nextInPast,
                    nextInPastIsInc: cruCreate.explorer.nextInPastIsInc
                })
            } else {
                $container.html(response.payload);
                cruCreate.explorer = response.explorer;
            }


            if (cruCreate.explorer.nextInFuture) {
                $newerActivityBtn.show();
            } else {
                $newerActivityBtn.hide();
            }

            cruCreate.explorer.loading = false;
            callback && callback(response);
        });

        return true;
    };
})(AJS.$);
/*[{!create_js_y8w2510!}]*/
;
/* END /2static/script/cru/create/create.js */
/* START /2static/script/cru/create/create-event.js */
(function ($) {

    $(document).ready(function () {

        var cruCreate = CRU.CREATE;
        var fecruAjax = FECRU.AJAX;
        var cruPatches = CRU.PATCHES;

        $(document).delegate(".changelist-link", "click", function (e) {
            e.preventDefault();
            cruCreate.loadChangesets($('#stream'), $('#activityLoadingTop'), $('.changelist-link-future'), {
                navigate: $(this).data('navigate')
            });
        });

        $(document).delegate("#changesetFilter", "submit", function (e) {
            cruCreate.cleanPlaceholders($(this));
            $('#changelog-warning').html('');
            $('#showid').val('');
            cruCreate.loadChangesets(AJS.$('#stream'), $('#activityLoadingTop'), $('.changelist-link-future'), {
                wbUrl: "/" + cruCreate.explorer.fullPath + "?" + $(this).serialize()
            });
            e.preventDefault();
        });


        $(document).delegate('.removeFrx:not(.disabled)', 'click', function () {
            var $x = $(this);
            var idBits = $x.attr('id').split('-');
            fecruAjax.startSpin($x);
            $x.hide();
            cruCreate.addRevisionFromView('remove', idBits[1], idBits[2], function () {
                fecruAjax.stopSpin($x);
                $x.show();
            });
            return false;
        });

        $(document).delegate('.frxSlider .deleteRev', 'click', function () {
            var $x = $(this);
            var xId = $x.attr('id');
            var idBits = xId.split('-');
            fecruAjax.startSpin($x);
            $x.hide();
            cruCreate.addRevisionFromView('removeRevisions', idBits[1], idBits[2], function () {
                var $x = $('#' + xId);
                fecruAjax.stopSpin($x);
                $x.show();
            });
        });

        $(document).delegate('.addRevision', 'click', function () {
            var $elem = $(this);
            var revId = $elem.attr('id').replace(/^addRev/, '');
            cruCreate.addRevisionToIter(revId);
        });

        $(document).delegate('.removeRevision', 'click', function () {
            var $elem = $(this);
            var revId = $elem.attr('id').replace(/^remRev/, '');
            cruCreate.removeRevisionFromIter(revId);
        });

        $(document).delegate('.addChangeSet', 'click', function () {
            var $elem = $(this);
            var csId = $elem.attr('id').replace(/^(addCs|containsSome)/, '');

            var isPartialMetadataChange = $('#csid-' + csId).data('partialmetadatachange');
            var isMetadataOnlyChange = $('#csid-' + csId).data('metadataonlychange');
            //If the user has added file revisions for the partial or full metadata changeset then
            //the only sensible action is to remove the changeset here
            if (!$elem.hasClass('addAllChangeSet') && (isPartialMetadataChange || isMetadataOnlyChange)) {
                cruCreate.removeChangesetFromIter(csId);
            } else {
                cruCreate.addChangesetToIter(csId);
            }
        });

        $(document).delegate('.removeChangeSet', 'click', function () {
            var $elem = $(this);
            var csId = $elem.attr('id').replace(/^remCs|removeSomeCs/, '');
            cruCreate.removeChangesetFromIter(csId);
        });

        $(document).delegate('.changeDiffAddRevision', 'click', function () {
            var $addButton = $(this);
            if (!$addButton.prop('disabled')) {
                var frxId = $addButton.attr('id').replace(/^changeDiffAddRevision/, '');
                var revId = $('#changeDiffSelect' + frxId).val();
                if (revId) {
                    $addButton.prop('disabled', true);
                    var ajax = fecruAjax;
                    ajax.startSpin($addButton, "edit-revision-spinner");
                    var done = function () {
                        ajax.stopSpin($addButton);
                        // Disabled status of button is handled by addRevisionFromView.
                    };
                    cruCreate.addRevisionFromView('add', frxId, revId, done);
                }
            }
        });

        cruCreate.bindUpdateFrxFromFormToggle = function (selector, frx) {
            var $items = $(selector);
            if ($items.data('updateFrxFromFormToggleBound')) {
                return; // avoid binding more than once
            } else {
                $items.data('updateFrxFromFormToggleBound', true);
            }

            AJS.InlineDialog(
                selector,
                'edit-revisions-inline-dialog-form-' + frx,
                function ($container, editRevisionLink, showPopup) {
                    var $editRevisionLink = $(editRevisionLink);
                    if ($editRevisionLink.is(".toggled-off")) {
                        return;
                    }
                    $editRevisionLink.addClass("toggled-off");

                    var frxId = $editRevisionLink.attr('id').replace('add-revisions-link-', '');
                    var $formSpan = $('#updateFrxFromFormSpan' + frxId);

                    if (!$formSpan.is('.allocated')) {
                        var url = CRU.UTIL.jsonUrlBase(permaId) + "/changeDiffDropdownAjax/";
                        var params = {frxId: frxId};
                        $editRevisionLink.parent().addClass('spinner');

                        fecruAjax.ajaxDo(url, params, function (resp) {
                            $editRevisionLink.parent().removeClass('spinner');
                            if (resp.worked) {
                                $formSpan
                                    .html(resp.msgHtml)
                                    .addClass('allocated');

                                $container.append($formSpan.show());
                                CRU.FRX.AJAX.updateFrxEditRevisionsDropdown(frxId);
                                showPopup();
                            }
                            $editRevisionLink.removeClass("toggled-off");
                        });
                    } else {
                        $container.append($formSpan.show());
                        showPopup();
                        $editRevisionLink.removeClass("toggled-off");
                    }
                },
                {
                    hideDelay: null,
                    width: 520,
                    offsetX: -10,
                    cacheContent: false,
                    initCallback: function () {
                        var inlineDialog = this;
                        $(document).bind('frx-deactive.edit-revisions', function () {
                            inlineDialog.hide();
                        });
                        inlineDialog.popup.find('.close').bind('click.edit-revisions', function () {
                            inlineDialog.hide();
                        });
                    },
                    hideCallback: function () {
                        $(document).unbind('frx-deactive.edit-revisions');
                        var $popup = this.popup;
                        $popup.find('.close').unbind('click.edit-revisions');
                        // Stash the form span away for the next time we need to show it.
                        $('body').append($popup.find('.updateFrxFromFormSpan').hide());
                    }
                }
            );
        };


        /* Patches */
        $(document).delegate('.addAllPatch', 'click', function () {
            var $this = $(this);
            var patchId = $this.data('patchid')
            cruCreate.addAllPatch(patchId);
        });

        $(document).delegate('.removeAllPatch', 'click', function () {
            var $this = $(this);
            var patchId = $this.data('patchid')
            cruCreate.removeAllPatch(patchId);
        });

        $(document).delegate('.remove-patch', 'click', function() {
            var $this = $(this);
            var patchId = $this.data('patch-id');
            var reviewId = $this.data('review-id');
            var $patchControls = AJS.$('#patch-controls-' + patchId);
            $patchControls.hide();
            AJS.$
                .ajax({
                    url: AJS.contextPath() + "/rest-service/reviews-v1/" + reviewId + "/patch/" + patchId,
                    dataType: 'json',
                    type: 'DELETE'
                })
                .fail(function(jqXHR, textStatus, errorThrown) {
                    $patchControls.show();
                    var msg;
                    try {
                        msg = JSON.parse(jqXHR.responseText).message;
                    } catch (e) {
                        msg = errorThrown;
                    }
                    AJS.messages.error({body: 'Something went wrong removing the patch. ' + msg});
                })
                .done(function(data) {
                    // update labels for the remaining groups
                    _.each(data.patchGroup, function(patchGroup) {
                        var patchId = patchGroup.sourceName.replace('PATCH:', '')
                        $('#patch-group-' + patchId + ' .patch-group-name').text(patchGroup.displayName);
                    });
                    $patchControls.remove();

                    // remove empty groups
                    $('.patch-group').each(function() {
                        if ($(this).find('.patch-controls').length === 0) {
                            $(this).remove();
                        }
                    });

                    // remove the whole 'Existing patches' section if empty
                    var $patchFilesSection = $('.existing-patch-files');
                    if ($patchFilesSection.find('.patch-group').length === 0) {
                        $patchFilesSection.remove();
                    }
                });
        });

        $(document).delegate('.addFileRevision', 'click', function () {
            var $this = $(this);
            var $fileRevision = $this.closest('.fileRevision');
            var sourceName = $fileRevision.attr('id').replace('fileRevision-', '');
            var revId = $this.attr('id').replace('addRev', '');
            cruCreate.addRemoveFileRevision(true, revId, revId, sourceName);
        });

        $(document).delegate('.removeFileRevision', 'click', function () {
            var $this = $(this);
            var $fileRevision = $this.closest('.fileRevision');
            var sourceName = $fileRevision.attr('id').replace('fileRevision-', '');
            var revId = $this.attr('id').replace('remRev', '');
            cruCreate.addRemoveFileRevision(false, revId, revId, sourceName);
        });

        var $anchorRepository = $("#anchor-repository");

        $anchorRepository.delegate('.anchored-path-edit', 'change', function () {
            var $this = $(this);
            if ($this.val() !== '') {
                var $controls = $this.closest('.patch-controls');
                var params = {
                    anchorSource: $controls.find('.anchored-source-value').val(),
                    anchorPath: $this.val(),
                    stripCount: $controls.find('.anchored-stripcount').val()
                };

                cruPatches.anchorPatch($controls, params);
            }
        });

        $anchorRepository.delegate('.anchored-source-edit', 'change', function () {
            var $this = $(this);

            var $controls = $this.closest('.patch-controls');
            if ($this.val() !== '') {
                var params = {
                    anchorSource: $this.val(),
                    search: true
                };

                cruPatches.anchorPatch($controls, params);
            } else {
                cruPatches.anchorPatch($controls, null);
            }
        });

        $anchorRepository.delegate('.edit-anchor, .find-anchor', 'click', function () {
            var $controls = $(this).closest('.patch-controls');
            if ($controls.is('.disabled')) {
                return;
            }

            var currentAnchorSource = $controls.find('.current-anchor > .anchored-source').text();

            $controls.removeClass('viewing');

            if (currentAnchorSource) {
                $controls.addClass('getting-paths');
                cruPatches.getPaths($controls, currentAnchorSource, function () {
                    $controls.removeClass('getting-paths').addClass('editing');
                });
            } else {
                $controls.addClass('editing');
            }
        });

        $anchorRepository.delegate('.cancel-edit', 'click', function () {
            var $controls = $(this).closest('.patch-controls');
            if ($controls.is('.disabled')) {
                return;
            }
            $controls.removeClass('editing').addClass('viewing');
        });

        $anchorRepository.delegate('.cancel-anchor', 'click', function () {
            var $controls = $(this).closest('.patch-controls');
            if ($controls.is('.disabled')) {
                return;
            }
            var cancel = $controls.data('cancel');
            cancel && cancel();
            $controls.removeClass('anchoring getting-paths').addClass('viewing');
        });

        $(document).delegate('.patch-revisions-expand', 'click', function () {
            var $this = $(this);
            var $patchRevisions = $this.parents('.patch-controls').find('.patch-revisions')
            $patchRevisions.slideToggle(200, function () {
                $this.toggleClass('expanded');
            });
        })

    });

})(AJS.$);
/*[{!create_event_js_091a50z!}]*/;
/* END /2static/script/cru/create/create-event.js */
