/* CONCAT of
/2static/script/fecru/profile.js
/global.js
/2static/script/lib/jquery/plugins/jquery.autocomplete.js
/2static/script/fecru/star.js
/2static/script/cru/util.js
/2static/script/fecru/ajax.js
*/
/* START /2static/script/fecru/profile.js */
window.FECRU = window.FECRU || {};
if (!FECRU.PROFILE) {
    FECRU.PROFILE = (function () {
        var makeDialogFor = function (url) {
            var windowWidth = AJS.$(window).width();
            var windowHeight = AJS.$(window).height();
            var width = (windowWidth < 1000) ? windowWidth - 120 : 800;
            var height = (windowHeight < 700) ? windowHeight - 100 : 700;
            var HEADER_HEIGHT = 55; //height of the dialog header, in px
            var BUTTON_HEIGHT = 50; //height of the buttons at bottom of dialog, in px.
            var BODY_PADDING = AJS.$('#adminpage').length ? 40 : 20; // needs to be the same as .aui-dialog .dialog-panel-body declaration in dialog.css
            var IFRAME_SPACING = 3; // under html5 the iframe gets arbtirary following spacing, and this removes the scrollbar it causes
            var OUTERHEIGHT = HEADER_HEIGHT + BUTTON_HEIGHT + BODY_PADDING + IFRAME_SPACING; // 110
            var iframeHeight = height - OUTERHEIGHT;
            var settingsDialog = FECRU.DIALOG.create(width, height, 'fecru-profile-settings-dialog');
            var deepProfileSettingsLink = url || FECRU.pageContext + "/profile";
            // hack: we're adding a random number to the iframe ID to work
            // around webkit bug: 24078 (http://lists.macosforge.org/pipermail/webkit-unassigned/2009-February/100941.html)
            var $iframe = AJS.$('<iframe/>');
            $iframe.attr({
                'id': 'fecru-iframe-' + (Math.ceil(Math.random() * 1000)),
                'frameborder': '0',
                'src': deepProfileSettingsLink,
                'style': 'width:100%;height:' + (iframeHeight) + 'px'
            });


            settingsDialog.addHeader("Profile settings");
            settingsDialog.addPanel("Display", $iframe);
            settingsDialog.addCancel("Close", function (dialog) {
                dialog.hide();

                //todo: fix up reloading?
                if (getDialogURL()) {
                    // Remove "dialog" parameter before reloading
                    var topURL = window.location.href;
                    topURL = topURL.replace(/\?dialog=[^&]*/, "?");
                    topURL = topURL.replace(/&dialog=[^&]*/, "");
                    topURL = topURL.replace(/\?$/, "");
                    window.location.replace(topURL);
                } else {
                    window.location.reload();
                }
            });
            return settingsDialog;
        };

        AJS.$(document).ready(function () {
            handleEmailChange();

            var toggleMappingSubmitButton = function () {
                var selectedIndex = AJS.$("#repositoryDropdown").attr("selectedIndex");
                var disabled = +selectedIndex === 0;

                AJS.$("#addMappingButton").prop("disabled", disabled);
            };
            AJS.$("#repositoryDropdown").change(toggleMappingSubmitButton);
            toggleMappingSubmitButton();    // set initial state

            var settingsDialog;
            //todo may be use live events?
            var $profileSettingsLink = AJS.$("a.dialog-settings").click(function (e) {
                e.preventDefault();
                FECRU.UI.hideClosestDropdown2(this);

                if (!settingsDialog) {
                    settingsDialog = makeDialogFor($profileSettingsLink.attr('href'));
                }
                settingsDialog.show();
            });

            var $form = AJS.$('form.autosubmit');
            $form.find('input,select').change(function (event) {
                var params = $form.serialize();
                var action = $form.attr('action');
                var $spinner = $form.find('.edit-settings-spinner').show();
                var saved = function () {
                    AJS.$('body').trigger('user.profile.change.save', event.currentTarget.name);
                    setTimeout(function () {
                        $spinner.hide();
                    }, 500); //show the spinner for slightly longer, so that the feedback is visible for longer
                };

                FECRU.AJAX.ajaxDo(action, params, saved);
            });

            $form.find('#clear-ignored-applinks').click(function () {
                var $spinner = AJS.$(".clear-ignored-applinks-spinner").show();
                FECRU.UAL.clearIgnoredAppLinks(function () {
                    setTimeout(function () {
                        $spinner.hide();
                        window.location.reload();
                    }, 500); //show the spinner for slightly longer, so that the feedback is visible for longer
                });
            });

            // If there's a dialog argument on our URL, open that dialog.
            var dialogURL = getDialogURL();
            if (dialogURL) {
                settingsDialog = makeDialogFor(FECRU.pageContext + dialogURL);
                settingsDialog.show();
            }

        });

        function getDialogURL() {
            // Don't match URLs which are login redirects
            if (location.search.match(/origUrl/)) {
                return null;
            }
            var matches = /[?&]dialog=([^&]*)/.exec(location.search);
            if (matches) {
                return decodeURIComponent(matches[1]);
            }
            return null;
        }

        /**
         * Handle email's field change.
         * In case it was modified user has to provide his password unless the password field is not rendered -
         *   password confirmation is not needed then.
         */
        function handleEmailChange() {
            var $emailSettingsForm = AJS.$('#profile-email-settings');
            var $password = $emailSettingsForm.find('#password');
            if ($password.length === 0) {
                return;
            }
            var $passwordGroup = $password.closest('.profile-settings-group');
            var $email = $emailSettingsForm.find('#email');
            var savedEmail = $emailSettingsForm.find('#savedEmail').val();
            var isPasswordEntered = function () {
                return $password.val().length > 0;
            };
            var isEmailModified = function () {
                return savedEmail !== $email.val().trim();
            };
            var updatePasswordConfirmationField = function () {
                if (isEmailModified()) {
                    $passwordGroup.stop(true, true).fadeIn(200);
                } else {
                    $passwordGroup.stop(true, true).fadeOut(200);
                }
            };

            $email.on('input', updatePasswordConfirmationField);
            $emailSettingsForm.on('submit', function (e) {
                if (isEmailModified() && !isPasswordEntered()) {
                    $password.focus();
                    e.preventDefault();
                }
            });
        }

        return true; //flag to stop multiple calls which adds multiple dialog boxes.
    })();
}
/*[{!profile_js_l3rx541!}]*/;
/* END /2static/script/fecru/profile.js */
/* START /global.js */
function toggleBasic(nodeName) {
    toggleNodeAndImage(nodeName, false, false, false);
}

function toggleNodeAndImage(nodeName, forceOpen, forceClose, inline) {
    nodeName = FECRU.sanitizeId(nodeName);
    var node = AJS.$("#" + nodeName);
    if (node.length === 0) {
        return false;
    }
    var img = AJS.$("#" + nodeName + 'img');
    var open = node.is(":hidden");
    open = (!forceClose) && (forceOpen || open);
    if (open) {
        if (node.is(":hidden")) {
            node.show();
            img.attr("src", FECRU.pageContext + '/' + FECRU.staticDirectory + '/images/arrow_open.gif');
        }
    } else if (node.is(":visible")) {
        node.hide();
        img.attr("src", FECRU.pageContext + '/' + FECRU.staticDirectory + '/images/arrow_closed.gif');
    }
    return false;
}
/*[{!global_js_gj6v4ug!}]*/;
/* END /global.js */
/* START /2static/script/lib/jquery/plugins/jquery.autocomplete.js */
/*
 * jQuery Autocomplete plugin 1.1
 *
 * Copyright (c) 2009 J̦rn Zaefferer
 *
 * Dual licensed under the MIT and GPL licenses:
 *   http://www.opensource.org/licenses/mit-license.php
 *   http://www.gnu.org/licenses/gpl.html
 *
 * Revision: $Id: jquery.autocomplete.js 14 2009-08-22 10:29:29Z joern.zaefferer $
 *
 * WARNING: This code is hacked to bits. Do not upgrade without a complete audit of changes.
 */

;(function($) {

$.fn.extend({
    autocomplete: function(urlOrData, options) {
        var isUrl = typeof urlOrData == "string";
        options = $.extend({}, $.Autocompleter.defaults, {
            url: isUrl ? urlOrData : null,
            data: isUrl ? null : urlOrData,
            delay: isUrl ? $.Autocompleter.defaults.delay : 10,
            max: options && !options.scroll ? 10 : 150
        }, options);

        // if highlight is set to false, replace it with a do-nothing function
        options.highlight = options.highlight || function(value) { return value; };

        // if the formatMatch option is not specified, then use formatItem for backwards compatibility
        options.formatMatch = options.formatMatch || options.formatItem;

        return this.each(function() {
            new $.Autocompleter(this, options);
        });
    },
    result: function(handler) {
        return this.bind("result", handler);
    },
    search: function(handler) {
        return this.trigger("search", [handler]);
    },
    flushCache: function() {
        return this.trigger("flushCache");
    },
    setOptions: function(options){
        return this.trigger("setOptions", [options]);
    },
    unautocomplete: function() {
        return this.trigger("unautocomplete");
    }
});

$.Autocompleter = function(input, options) {

    var KEY = {
        UP: 38,
        DOWN: 40,
        DEL: 46,
        TAB: 9,
        RETURN: 13,
        ESC: 27,
        COMMA: 188,
        PAGEUP: 33,
        PAGEDOWN: 34,
        BACKSPACE: 8
    };

    // Create $ object for input element
    var $input = $(input).attr("autocomplete", "off").addClass(options.inputClass);

    var timeout;
    var previousValue = "";
    var hasBeenReset = false;
    var cache = $.Autocompleter.Cache(options);
    var hasFocus = 0;
    var lastKeyPressCode;
    var config = {
        /* This used to use mouseDownOnSelect as a boolean that was set true on mousedown, and false on mouseup of the
        dropdown. It was referenced in the input's blur. Unfortunately, IE doesn't always run the blur before the
        mouseup. So sometimes I would get:
            mousedown
            mouseup
            blur

        Which meant that the dropdown would be hidden. Now I check that the user has mousedowned the dropdown within
        the last 1s or 100ms, which is shady, but doesn't depend on execution order (assuming 1s is enough time for the
        event handlers to all run in IE8, 100ms is not a problem in other browsers). */
        mouseDownOnSelect: new Date(0),
        blurOnInput: new Date(0),
        mouseDownNearBlurTimeout : $.browser.msie && $.browser.version < 9 ? 1000 : 100
    };
    var select = $.Autocompleter.Select(options, input, selectCurrent, config);

    var blockSubmit;

    // prevent form submit in opera when selecting with return key
    $.browser.opera && $(input.form).bind("submit.autocomplete", function() {
        if (blockSubmit) {
            blockSubmit = false;
            return false;
        }
    });

    // only opera doesn't trigger keydown multiple times while pressed, others don't work with keypress at all
    $input.bind(($.browser.opera ? "keypress" : "keydown") + ".autocomplete", function(event) {
        // a keypress means the input has focus
        // avoids issue where input had focus before the autocomplete was applied
        hasFocus = 1;
        // track last key pressed
        lastKeyPressCode = event.keyCode;
        switch(event.keyCode) {

            case KEY.UP:
                event.preventDefault();
                if ( select.visible() ) {
                    select.prev();
                } else {
                    onChange(0, true);
                }
                break;

            case KEY.DOWN:
                event.preventDefault();
                if ( select.visible() ) {
                    select.next();
                } else {
                    onChange(0, true);
                }
                break;

            case KEY.PAGEUP:
                event.preventDefault();
                if ( select.visible() ) {
                    select.pageUp();
                } else {
                    onChange(0, true);
                }
                break;

            case KEY.PAGEDOWN:
                event.preventDefault();
                if ( select.visible() ) {
                    select.pageDown();
                } else {
                    onChange(0, true);
                }
                break;

            // matches also semicolon
            case options.multiple && $.trim(options.multipleSeparator) == "," && KEY.COMMA:
            case KEY.TAB:
            case KEY.RETURN:
                if( select.visible()) {
                    if( selectCurrent() ) {
                        // stop default to prevent a form submit, Opera needs special handling
                        event.preventDefault();
                        blockSubmit = true;
                        return false;
                    }
                } else if (!hasBeenReset) {
                    onChange(0, true);
                }
                break;

            case KEY.ESC:
                select.hide();
                break;

            default:
                $input.trigger("autocomplete-search-started");
                $input.trigger("autocomplete-timeout-started");
                clearTimeout(timeout);
                timeout = setTimeout(function() {
                    onChange();
                }, options.delay);
                break;
        }
    }).bind("reset.autocomplete", function(){
        previousValue = "";
        $input.val('');
        select.hide();
        select.emptyList();
        hasBeenReset = true;
    }).focus(function(){

        //show the select on first focus
        if ((new Date() - config.mouseDownOnSelect) > config.mouseDownNearBlurTimeout && !hasFocus && options.searchOnFocus && !select.visible() ) {
            onChange(0, true);
        }
        // track whether the field has focus, we shouldn't process any
        // results if the field no longer has focus
        hasFocus++;
    }).blur(function() {
        hasFocus = 0;
        var now = new Date(), diff = now - config.mouseDownOnSelect;
        if (diff > config.mouseDownNearBlurTimeout) {
            hideResults();
        }
        config.blurOnInput = new Date();
    }).click(function() {
        // show select when clicking in a focused field
        if ( hasFocus++ > 1 && !select.visible() ) {
            onChange(0, true);
        }
    }).bind("search", function() {
        // TODO why not just specifying both arguments?
        var fn = (arguments.length > 1) ? arguments[1] : null;
        function findValueCallback(q, data) {
            var result;
            if( data && data.length ) {
                for (var i=0; i < data.length; i++) {
                    if( data[i].result.toLowerCase() == q.toLowerCase() ) {
                        result = data[i];
                        break;
                    }
                }
            }
            if( typeof fn == "function" ) fn(result);
            else $input.trigger("result", result && [result.data, result.value]);
        }
        $.each(trimWords($input.val()), function(i, value) {
            request(value, findValueCallback, findValueCallback);
        });
    }).bind("flushCache", function() {
        cache.flush();
    }).bind("setOptions", function() {
        $.extend(options, arguments[1]);
        // if we've updated the data, repopulate
        if ( "data" in arguments[1] )
            cache.populate();
    }).bind("unautocomplete", function() {
        select.unbind();
        $input.unbind();
        $(input.form).unbind(".autocomplete");
    }).bind("forceSearch", function () {
        $input.focus();
        startSearch(arguments[1]);
    });


    function selectCurrent() {
        var selected = select.selected();
        if( !selected || selected.disabled )
            return false;

        var v = selected.result;
        previousValue = v;

        if ( options.multiple ) {
            var words = trimWords($input.val());
            if ( words.length > 1 ) {
                var seperator = options.multipleSeparator.length;
                var cursorAt = $(input).selection().start;
                var wordAt, progress = 0;
                $.each(words, function(i, word) {
                    progress += word.length;
                    if (cursorAt <= progress) {
                        wordAt = i;
                        return false;
                    }
                    progress += seperator;
                });
                words[wordAt] = v;
                // TODO this should set the cursor to the right position, but it gets overriden somewhere
                //$.Autocompleter.Selection(input, progress + seperator, progress + seperator);
                v = words.join( options.multipleSeparator );
            }
            v += options.multipleSeparator;
        }

        $input.val(v);
        hideResultsNow();
        $input.trigger("result", [selected.data, selected.value]);
        return true;
    }

    function onChange(crap, skipPrevCheck) {
        $input.trigger("autocomplete-search-started");
        hasBeenReset = false;
        if( lastKeyPressCode == KEY.DEL ) {
            select.hide();
            return;
        }

        // IE will have val == placeholder value on focus.
        var currentValue = $input.isPlaceholded && $input.isPlaceholded() ? "" : $.trim($input.val());

        if ( !skipPrevCheck && (currentValue == previousValue && select.visible()) ) {
            return;
        }

        previousValue = currentValue;

        currentValue = lastWord(currentValue);
        if ( currentValue.length >= options.minChars) {
            startSearch(currentValue);
        } else {
            stopLoading();
            select.hide();
        }
    }

    function startSearch(value) {
        if ($input.is(":enabled")) {
            hasBeenReset = false;
            value = value || "";
            $input.addClass(options.loadingClass);
            if (!options.matchCase)
                value = value.toLowerCase();

            request(value, receiveData, hideResultsNow);
        }
    }

    function trimWords(value) {
        if (!value)
            return [""];
        if (!options.multiple)
            return [$.trim(value)];
        return $.map(value.split(options.multipleSeparator), function(word) {
            return $.trim(value).length ? $.trim(word) : null;
        });
    }

    function lastWord(value) {
        if ( !options.multiple )
            return $.trim(value);
        var words = trimWords(value);
        if (words.length == 1)
            return words[0];
        var cursorAt = $(input).selection().start;
        if (cursorAt == value.length) {
            words = trimWords(value)
        } else {
            words = trimWords(value.replace(value.substring(cursorAt), ""));
        }
        return words[words.length - 1];
    }

    // fills in the input box w/the first match (assumed to be the best match)
    // q: the term entered
    // sValue: the first matching result
    function autoFill(q, sValue){
        // autofill in the complete box w/the first match as long as the user hasn't entered in more data
        // if the last user key pressed was backspace, don't autofill
        if( options.autoFill && (lastWord($input.val()).toLowerCase() == q.toLowerCase()) && lastKeyPressCode != KEY.BACKSPACE ) {
            // fill in the value (keep the case the user has typed)
            $input.val($input.val() + sValue.substring(lastWord(previousValue).length));
            // select the portion of the value not typed by the user (so the next character will erase)
            $(input).selection(previousValue.length, previousValue.length + sValue.length);
        }
    }

    function cancelHide() {
        clearTimeout(timeout);
    }
    config.cancelHide = cancelHide;

    function hideResults() {
        clearTimeout(timeout);
        timeout = setTimeout(hideResultsNow, 200);
    }

    function hideResultsNow() {
        var wasVisible = select.visible();
        select.hide();
        clearTimeout(timeout);
        stopLoading();
        if (options.mustMatch) {
            // call search and run callback
            $input.search(
                function (result){
                    // if no value found, clear the input box
                    if( !result ) {
                        if (options.multiple) {
                            var words = trimWords($input.val()).slice(0, -1);
                            $input.val( words.join(options.multipleSeparator) + (words.length ? options.multipleSeparator : "") );
                        }
                        else {
                            $input.val( "" );
                            $input.trigger("result", null);
                        }
                    }
                }
            );
        }
    }

    function receiveData(q, data) {
        if ( hasFocus ) {
            var modifiedData = data;
            if (options.notFoundData && !(data && data.length)) {
                modifiedData = parse(options.notFoundData);
            }
            select.display(modifiedData, q);
            modifiedData && modifiedData.length && autoFill(q, modifiedData[0].value);
            if (select.show()) {
                stopLoading();
            } else {
                hideResultsNow();
            }
        } else {
            hideResultsNow();
        }
        $input.trigger("autocomplete-data-received", {"data": data, "query": q});
    }

    function request(term, success, failure) {
        if (!options.matchCase)
            term = term.toLowerCase();
        var data = undefined;
        if (!options.disableCache) {
            data = cache.load(term);
        }
        // recieve the cached data
        if (data && data.length) {
            success(term, data);
        // if an AJAX url has been supplied, try loading the data now
        } else if( (typeof options.url == "string") && (options.url.length > 0) ){

            var extraParams = {
                timestamp: +new Date()
            };
            $.each(options.extraParams, function(key, param) {
                extraParams[key] = typeof param == "function" ? param() : param;
            });

            $.ajax({
                // try to leverage ajaxQueue plugin to abort previous requests
                mode: "abort",
                // limit abortion to this input
                port: "autocomplete" + input.name,
                dataType: options.dataType,
                url: options.url,
                data: $.extend({
                    q: lastWord(term),
                    limit: options.max
                }, extraParams),
                success: function(data) {
                    if (hasBeenReset) {
                        hasBeenReset = false;
                        failure();
                        return;
                    }
                    var parsed = parse(data);
                    !options.disableCache && cache.add(term, parsed);
                    success(term, parsed);
                }
            }).error(function() {
                if (options.errorData) {
                    if (hasBeenReset) {
                        hasBeenReset = false;
                        failure();
                        return;
                    }
                    success(term, parse(options.errorData));
                }
            });
        } else {
            // if we have a failure, we need to empty the list -- this prevents the the [TAB] key from selecting the last successful match
            select.emptyList();
            failure(term);
        }
    }

    function parse(data) {
        if (options.parse) {
            return options.parse(data);
        }
        var parsed = [];
        var rows = data.split("\n");
        for (var i=0; i < rows.length; i++) {
            var row = $.trim(rows[i]);
            if (row) {
                row = row.split("|");
                parsed[parsed.length] = {
                    data: row,
                    value: row[0],
                    result: options.formatResult && options.formatResult(row, row[0]) || row[0]
                };
            }
        }
        return parsed;
    }

    function stopLoading() {
        $input.removeClass(options.loadingClass);
    }

};

$.Autocompleter.defaults = {
    inputClass: "ac_input",
    resultsClass: "ac_results ordinary_autocomplete",
    loadingClass: "ac_loading",
    minChars: 1,
    delay: 400,
    matchCase: false,
    matchSubset: true,
    matchContains: false,
    disableCache: false,
    cacheLength: 10,
    max: 100,
    mustMatch: false,
    extraParams: {},
    selectFirst: true,
    formatItem: function(row) { return row[0]; },
    formatMatch: null,
    autoFill: false,
    width: 0,
    multiple: false,
    multipleSeparator: ", ",
    highlight: function(value, term) {
        if (term == "") {
            return value;
        } else {
		    return value.replace(new RegExp("(?![^&;]+;)(?!<[^<>]*)(" + term.replace(/([\^\$\(\)\[\]\{\}\*\.\+\?\|\\])/gi, "\\$1") + ")(?![^<>]*>)(?![^&;]+;)", "gi"), "<strong>$1</strong>");
        }
	},
    scroll: true,
    scrollHeight: 180
};

$.Autocompleter.Cache = function(options) {

    var data = {};
    var length = 0;

    function matchSubset(s, sub) {
        if (!options.matchCase)
            s = s.toLowerCase();
        var i = s.indexOf(sub);
        if (options.matchContains == "word"){
            i = s.toLowerCase().search("\\b" + sub.toLowerCase());
        }
        if (i == -1) return false;
        return i == 0 || options.matchContains;
    }

    function add(q, value) {
        if (length > options.cacheLength){
            flush();
        }
        if (!data[q]){
            length++;
        }
        data[q] = value;
    }

    function populate(){
        if( !options.data ) return false;
        // track the matches
        var stMatchSets = {};

        // no url was specified, we need to adjust the cache length to make sure it fits the local data store
        if( !options.url ) options.cacheLength = 1;

        // track all options for minChars = 0
        stMatchSets[""] = [];

        // loop through the array and create a lookup structure
        for ( var i = 0, ol = options.data.length; i < ol; i++ ) {
            var rawValue = options.data[i];
            // if rawValue is a string, make an array otherwise just reference the array
            rawValue = (typeof rawValue == "string") ? [rawValue] : rawValue;

            var value = options.formatMatch(rawValue, i+1, options.data.length);
            if ( value === false )
                continue;

            var firstChar = value.charAt(0).toLowerCase();
            // if no lookup array for this character exists, look it up now
            if( !stMatchSets[firstChar] )
                stMatchSets[firstChar] = [];

            // if the match is a string
            var row = {
                value: value,
                data: rawValue,
                result: options.formatResult && options.formatResult(rawValue) || value
            };

            // push the current match into the set list
            stMatchSets[firstChar].push(row);

            // keep track of minChars zero items
            stMatchSets[""].push(row);
        }

        // add the data items to the cache
        $.each(stMatchSets, function(i, value) {
            // increase the cache size
            options.cacheLength++;
            // add to the cache
            add(i, value);
        });
    }

    // populate any existing data
    setTimeout(populate, 25);

    function flush(){
        data = {};
        length = 0;
    }

    return {
        flush: flush,
        add: add,
        populate: populate,
        load: function(q) {
            if (!options.cacheLength || !length)
                return null;
            /*
             * if dealing w/local data and matchContains than we must make sure
             * to loop through all the data collections looking for matches
             */
            var csub = [];
            if(!options.url && options.matchContains){
                // track all matches
                $.each(data[""], function(i, x) {
                    // if we've got a match, add it to the array
                    if (matchSubset(x.value, q)) {
                        csub.push(x);
                    }
                });
            } else if (data[q]) {
                // if the exact item exists, use it
                csub = data[q];
            } else if (options.matchSubset) {
                for (var i = q.length - 1; i >= options.minChars; i--) {
                    var c = data[q.substr(0, i)];
                    if (c) {
                        $.each(c, function(i, x) {
                            if (matchSubset(x.value, q)) {
                                csub[csub.length] = x;
                            }
                        });
                    }
                }
            }
            return csub;
        }
    };
};

$.Autocompleter.Select = function (options, input, select, config) {
    var CLASSES = {
        ACTIVE: "ac_over",
        DISABLED: "ac-disabled",
        HEADER: "ac-header",
        NOTICE: "ac-notice"
    };

    var listItems,
        active = -1,
        data,
        term = "",
        needsInit = true,
        element,
        list,
        header,
        headerIsVisible = false,
        footer,
        footerIsVisible = false;

    // Create results
    function init() {
        if (!needsInit)
            return;
        element = $("<div/>")
        .hide()
        .addClass(options.resultsClass)
        .css("position", "absolute")
        .appendTo(document.body);

        if (options.getHeaderElement) {
            header = $("<div class='ac-header'></div>").appendTo(element);
        }

        list = $("<ul/>").appendTo(element);
        element.mouseover( function(event) {
            if(target(event).nodeName && target(event).nodeName.toUpperCase() == 'LI') {
                active = $("li", list).removeClass(CLASSES.ACTIVE).index(target(event));
                $(target(event)).addClass(CLASSES.ACTIVE);
            }
        }).click(function(event) {
            var $target = $(target(event));
            if ($target.length && !$target.hasClass(CLASSES.DISABLED) && !$target.hasClass(CLASSES.HEADER)) {
                $target.addClass(CLASSES.ACTIVE);
                select();
            }

            input.focus();
            return false;
        }).mousedown(function() {
            config.mouseDownOnSelect = new Date();

            // a blur event happened on the input within 100ms of a mousedown on the select.
            // Cancel the hiding of the dropdown.
            if (config.mouseDownOnSelect - config.blurOnInput < config.mouseDownNearBlurTimeout) {
                config.cancelHide();
            }
        });

        if (options.getFooterElement) {
            footer = $("<div class='ac-footer'></div>").appendTo(element);
        }

        if( options.width > 0 )
            element.css("width", options.width);

        needsInit = false;
    }

    function target(event) {
        var element = event.target;
        while(element && element.tagName != "LI")
            element = element.parentNode;
        // more fun with IE, sometimes event.target is empty, just ignore it then
        if(!element)
            return [];
        return element;
    }

    function moveSelect(step) {
        var oldActive = active;
        listItems.slice(active, active + 1).removeClass(CLASSES.ACTIVE);

        var activeItem;
        do {
            movePosition(step);
            activeItem = listItems.slice(active, active + 1)
        } while ((activeItem.hasClass(CLASSES.HEADER)) && active != oldActive);
        //(activeItem.hasClass(CLASSES.DISABLED) ||
                activeItem.addClass(CLASSES.ACTIVE);
        if(options.scroll) {
            var offset = 0;
            listItems.slice(0, active).each(function() {
                offset += this.offsetHeight;
            });
            if((offset + activeItem[0].offsetHeight - list.scrollTop()) > list[0].clientHeight) {
                list.scrollTop(offset + activeItem[0].offsetHeight - list.innerHeight());
            } else if(offset < list.scrollTop()) {
                list.scrollTop(offset);
            }
        }
    }

    function movePosition(step) {
        active += step;
        if (active < 0) {
            active = listItems.size() - 1;
        } else if (active >= listItems.size()) {
            active = 0;
        }
    }

    function limitNumberOfItems(available) {
        return options.max && options.max < available
            ? options.max
            : available;
    }

    function fillList() {

        list.empty();
        var max = limitNumberOfItems(data ? data.length : 0);
        for (var i=0; i < max; i++) {
            var dataElement = data[i];
            if (!dataElement)
                continue;
            var formatted = options.formatItem(dataElement.data, i+1, max, dataElement.value, term);
            if ( formatted === false )
                continue;
            var li = $("<li/>").addClass(i%2 == 0 ? "ac_even" : "ac_odd");

            var escaper = AJS.escapeHtml;
            if (formatted && (formatted.jquery || formatted.nodeType === 1)) {
                //TODO - will fail to highlight if term crosses elements - sok cuz that never worked anyway.
                var contents = formatted;
                while((contents = contents.contents()).length) {
                    var textNodes = contents.filter(function() {
                        return this.nodeType === 3;
                    });
                    textNodes.each(function() {
                        var escapedTerm = escaper(term),
                            text = escaper(this.nodeValue),
                            highlighted = options.highlight(text, escapedTerm);
                        if (text !== highlighted) {
                            $(this).replaceWith(highlighted);
                        }
                    });
                }
                formatted.appendTo(li);
            } else {
                li.html(options.highlight(escaper(formatted), term));
            }

            li = li.appendTo(list)[0];
            if (dataElement.disabled === true) {
                $(li).addClass(CLASSES.DISABLED);
            }
            if (dataElement.isHeader === true) {
                $(li).addClass(CLASSES.HEADER);
            }
            if (dataElement.extraClass) {
                $(li).addClass(dataElement.extraClass);
            }
            $.data(li, "ac_data", dataElement);
        }

        /*
         *  to add a last item as the notice, if the total number is set and greater than the limit of results (50)
         *
         */
        if('totalItems' in data && data.totalItems > max)
        {
            var liLastNotice = ["<div class='entry'>",
                "<div> Displaying " + max + " of " + data.totalItems +" results.</div>",
                "<div>", data.hasQuerySpecified?"Continue":"Start"," typing to filter.</div>",
                "</div>"].join('');

            var li = $("<li/>").html(liLastNotice)
                    .addClass(CLASSES.DISABLED)
                    .addClass(CLASSES.NOTICE);
            li.appendTo(list);
        }


        listItems = list.find("li");
        if ( options.selectFirst && listItems.length ) {
            listItems.slice(0, 1).addClass(CLASSES.ACTIVE);
            active = 0;
        }
        // apply bgiframe if available
        if ( $.fn.bgiframe )
            list.bgiframe();
    }

    return {
        display: function(d, q) {
            init();
            data = d;
            term = q;
            fillList();
        },
        next: function() {
            moveSelect(1);
        },
        prev: function() {
            moveSelect(-1);
        },
        pageUp: function() {
            if (active != 0 && active - 8 < 0) {
                moveSelect( -active );
            } else {
                moveSelect(-8);
            }
        },
        pageDown: function() {
            if (active != listItems.size() - 1 && active + 8 > listItems.size()) {
                moveSelect( listItems.size() - 1 - active );
            } else {
                moveSelect(8);
            }
        },
        hide: function() {
            element && element.hide();
            listItems && listItems.removeClass(CLASSES.ACTIVE);
            active = -1;
        },
        visible : function() {
            return element && element.is(":visible");
        },
        current: function() {
            return this.visible() && (listItems.filter("." + CLASSES.ACTIVE)[0] || options.selectFirst && listItems[0]);
        },
        show: function() {
            var offset = $(input).offset();
            element.css({
                width: typeof options.width == "string" || options.width > 0 ? options.width : $(input).width(),
                top: offset.top + input.offsetHeight,
                left: offset.left
            });

            if (header) {
                var headerValue = $.isFunction(options.getHeaderElement) ?
                        options.getHeaderElement(data, term) :
                        options.getHeaderElement;
                if (headerValue) {
                    headerIsVisible = true;
                    header.empty().append(headerValue).removeClass('hidden');
                } else {
                    headerIsVisible = false;
                    header.addClass('hidden').empty();
                }
            }

            if (footer) {
                var footerValue = $.isFunction(options.getFooterElement) ?
                        options.getFooterElement(data, term) :
                        options.getFooterElement;
                if (footerValue) {
                    footerIsVisible = true;
                    footer.empty().append(footerValue).removeClass('hidden');
                } else {
                    footerIsVisible = false;
                    footer.addClass('hidden').empty();
                }
            }

            var hasData = data && data.length;
            if (!(hasData || headerIsVisible || footerIsVisible)) {
                return false;
            }

            list.toggleClass('hidden', !hasData);

            element.show();
            if(options.resultShown) {
                options.resultShown($(input), element);
            }

            if(options.scroll) {
                list.scrollTop(0);
                list.css({
                    maxHeight: options.scrollHeight,
                    overflow: 'auto'
                });

                if($.browser.msie && typeof document.body.style.maxHeight === "undefined") {
                    var listHeight = 0;
                    listItems.each(function() {
                        listHeight += this.offsetHeight;
                    });
                    var scrollbarsVisible = listHeight > options.scrollHeight;
                    list.css('height', scrollbarsVisible ? options.scrollHeight : listHeight );
                    if (!scrollbarsVisible) {
                        // IE doesn't recalculate width when scrollbar disappears
                        listItems.width( list.width() - parseInt(listItems.css("padding-left")) - parseInt(listItems.css("padding-right")) );
                    }
                }

            }

            return true;
        },
        selected: function() {
            var selected = listItems && listItems.filter("." + CLASSES.ACTIVE).removeClass(CLASSES.ACTIVE);
            return selected && selected.length && $.data(selected[0], "ac_data");
        },
        emptyList: function (){
            list && list.empty();
            listItems && listItems.removeClass(CLASSES.ACTIVE);
        },
        unbind: function() {
            element && element.remove();
        }
    };
};

$.fn.selection = function(start, end) {
    if (start !== undefined) {
        return this.each(function() {
            if( this.createTextRange ){
                var selRange = this.createTextRange();
                if (end === undefined || start == end) {
                    selRange.move("character", start);
                    selRange.select();
                } else {
                    selRange.collapse(true);
                    selRange.moveStart("character", start);
                    selRange.moveEnd("character", end);
                    selRange.select();
                }
            } else if( this.setSelectionRange ){
                this.setSelectionRange(start, end);
            } else if( this.selectionStart ){
                this.selectionStart = start;
                this.selectionEnd = end;
            }
        });
    }
    var field = this[0];
    if ( field.createTextRange ) {
        var range = document.selection.createRange(),
            orig = field.value,
            teststring = "<->",
            textLength = range.text.length;
        range.text = teststring;
        var caretAt = field.value.indexOf(teststring);
        field.value = orig;
        this.selection(caretAt, caretAt + textLength);
        return {
            start: caretAt,
            end: caretAt + textLength
        }
    } else if( field.selectionStart !== undefined ){
        return {
            start: field.selectionStart,
            end: field.selectionEnd
        }
    }
};

})(jQuery);
/*[{!jquery_autocomplete_js_9tcr54y!}]*/;
/* END /2static/script/lib/jquery/plugins/jquery.autocomplete.js */
/* START /2static/script/fecru/star.js */
/*eslint eqeqeq:0*/

window.FECRU = window.FECRU || {};

(function () {

    /**
     * html for the star edit dialog, to be inserted on demand.
     */
    var DIALOG_DEFAULT = "Describe your favourite";
    /*eslint-disable indent*/
    var DIALOG_HTML = [
        "<div id='astronomy'>",
            "<div id='astronomy-label'>",
                "<h4><span>Update favourite</span></h4>",
                "<span class='close'><a href='#' class='close-astronomy' id='close-astronomy'>X</a></span>",
                "<form action='#'>",
                    "<fieldset class='input'>",
                        "<label for='star-labels'>Name</label>",
                        "<input type='text' id='star-labels' value='Describe your favourite'>",
                    "</fieldset>",
                    "<fieldset class='button'>",
                        "<ul>",
                            "<li><button class='remove' id='remove-astronomy'>Remove</button></li>",
                            "<li class='odd'><input type='submit' id='save-star-label' value='Save label'></li>",
                        "</ul>",
                    "</fieldset>",
                "</form>",
            "</div>",
        "</div>"
    ].join("");
    /*eslint-enable*/

    ////// private functions

    var ON_ONLY = true;
    var OFF_ONLY = false;

    function starOnOffClassName(on) {
        return on ? "star-on" : "star-off";
    }

    function starAddRemoveText($star, on) {
        return $star.find(on ? "input.star-textRemove" : "input.star-textAdd").val();
    }

    /**
     * todo: see if this can be swapped with the throbber jquery plugin.
     */
    function makeThrobberControl($link, throbberSetting) {
        /**
         * Starts the throbber, which activates after noLatencyThreshold milliseconds have passed.
         * @return a function that will stop the throbber after minThrobberDisplay milliseconds have passed, ensuring no flicker.
         */
        var startThrob = function () {
            $link.data("throbbing", true);
            var timeout = setTimeout(function () {
                $link.addClass("star-throb");
            }, throbberSetting.noLatencyThreshold);

            return function () {
                $link.data("throbbing", false);
                clearTimeout(timeout);
                setTimeout(function () {
                    $link.removeClass("star-throb");
                }, throbberSetting.minThrobberDisplay);
            };
        };

        /**
         * stores a function to stop the throbber for the given $link
         */
        var stopThrob = undefined;
        return {
            start: function () {
                if (throbberSetting.showThrob && !stopThrob) {
                    stopThrob = startThrob();
                }
            },
            stop: function () {
                if (stopThrob) {
                    stopThrob();
                    stopThrob = undefined;
                }
            },
            isThrobbing: function () {
                return $link.data("throbbing");
            }
        };
    }

    /**
     *
     * @param link the jquery element of the link that was clicked
     * @param dialogControl an object to control the dialog. Its members should be:
     * - showDialog: a function with no arguments, which when invoked will display the dialog
     * - hideDialog: a function with no arguments, which when invoked will hide the dialog
     * - getDialog: a function with no arguments, which returns a jquery object that represents the dialog
     * @param options the list of options. Available options are:
     * - throbber : options for throbbing
     *
     */
    function starClicked(link, dialogControl, options) {
        var starId = getStarId(link);
        var starOn = AJS.$(link).hasClass('star-on');

        var starKeys = {};
        var $link = AJS.$(link);
        var throbberControl = makeThrobberControl($link, options.throbberSetting);
        //if throbbing already, then don't do anything.
        if (throbberControl.isThrobbing()) {
            return;
        }

        $link.children("span.inputs").children("input.starKey").each(function () {
            var key = AJS.$(this);
            starKeys[key.attr("name")] = key.val();
        });
        if (starOn && starId != null) {
            if (isDialogShown($link)) {
                // we are unstarring, pop up the edit box
                editStar(starId, dialogControl, throbberControl, $link);
            } else {
                //...or remove directly without anymore interaction
                doRemoveStar(starId, throbberControl);
            }
        } else {
            // we are adding a star
            addStar(starKeys, dialogControl, throbberControl);
        }

        // todo: fix this hack to make hoverpopups refresh after starring
        // just always invalidate all popups
        var fecruHover = FECRU.HOVER;
        fecruHover.invalidateCache(fecruHover.CACHE_FOREVER);

    }

    function getIdElement(link) {
        return AJS.$(link).children("span.inputs").children("input[name='id']");
    }

    function getStarId(link) {
        return getIdElement(link).val();
    }

    function allStars(on) {
        return AJS.$("a." + starOnOffClassName(on));
    }

    function setStarAttributes(on, $node) {
        var newClass = starOnOffClassName(on);
        var oldClass = starOnOffClassName(!on);
        $node.removeClass(oldClass)
            .addClass(newClass)
            .children("span.starText").text(starAddRemoveText($node, on));
    }

    /**
     * Turn on the Star with the given keys
     * @param keys
     */
    function addStar(keys, dialogControl, throbberControl) {
        var paramMap = {};
        for (var key in keys) {
            if (keys.hasOwnProperty(key)) {
                paramMap["key." + key] = keys[key];
            }
        }
        throbberControl.start();
        doStar(FECRU.pageContext + "/json/profile/addStarAjax.do", paramMap, function (newId) {
            allStars(OFF_ONLY).each(function () {
                var $node = AJS.$(this);
                var $inputs = $node.children("span.inputs");
                for (var key in keys) {
                    if (keys.hasOwnProperty(key)) {
                        var input = $inputs.children("input.starKey[name='" + key + "']");
                        if (input.length === 0 || input.val() != keys[key]) {
                            return;
                        }
                    }
                }
                setStarAttributes(true, $node);
                $inputs.append("<input type='hidden' name='id' value='" + newId + "'>");
            });
            var itemType = keys["itemType"];
            if (itemType == "atlassian-chart" || itemType == "atlassian-search" ||
                itemType == "atlassian-quicksearch") {
                editStar(newId, dialogControl, throbberControl);
            } else {
                // WARNING: epic hack
                // This is to work around an incorrect usage of InlineDialog. We are leveraging IDs triggers to load
                // star ajax dialog, but in some cases we are not actually showing the dialog. This leaves the internal
                // state of InlineDialog in tatters and further calls to show the dialogs won't work. This workaround
                // simply shows and immediately hides the dialog ensuring the internal state is correct. The hidden
                // visibility is to ensure that the browser doesn't render the dialog on the screen.
                var $dialog = AJS.$("#inline-dialog-star-inline-dialog");
                $dialog.css("visibility", "hidden");
                dialogControl.showDialog();
                dialogControl.hideDialog();
                $dialog.css("visibility", "visible");
            }
            throbberControl.stop();
        });
    }

    /**
     * Pop up a dialog box for a Star which is in the on state, allowing the user to set its label or to remove it.
     * @param starId the id of the Star to change.
     * @param dialogControl
     */
    function editStar(starId, dialogControl, throbberControl, $star) {
        // pop up our star edit dialog
        var onSuccess = function (resp) {
            if (resp.worked) {
                var __updateLabel = function (label) {
                    doSaveLabel(starId, label, throbberControl, $star);
                };
                var __removeStar = function () {
                    doRemoveStar(starId, throbberControl);
                };
                showStarDialog(dialogControl, __updateLabel, __removeStar, resp.payload);
            } else {
                //resp.worked is false, reset the star to an off star.
                turnOffStar(starId);
            }
            throbberControl.stop();
        };
        throbberControl.start();
        // get the label for this Star, to supply it to the dialog
        AJS.$.post(FECRU.pageContext + "/json/profile/getStarLabelAjax.do", {id: starId}, onSuccess, 'json');
    }

    function turnOffStar(starId) {
        allStars(ON_ONLY).each(function () {
            var id = getStarId(this);
            if (starId == id) {
                // represents the same star
                getIdElement(this).remove();
                var $node = AJS.$(this);
                setStarAttributes(false, $node);
            }
        });
    }

    /**
     * Send a new label value to the server.
     * @param id the id of the Star who's label has been changed
     * @param label a String holding the new label text
     */
    function doSaveLabel(id, label, throbberControl, $star) {
        var onDone = function (rsp) {
            if ($star && $star.find('[name=id]')) {
                var starId = $star.find('[name=id]').val();
                AJS.$('#star-label-' + starId).html(rsp.name);
            }
            throbberControl.stop();
        };
        throbberControl.start();
        AJS.$.post(FECRU.pageContext + "/json/profile/setStarLabelAjax.do", {id: id, label: label}, onDone, 'json');
    }

    /**
     * Unstar the star with the given id.
     *
     * @param id the id of the Star to unstar.
     */
    function doRemoveStar(id, throbberControl) {
        throbberControl.start();
        doStar(FECRU.pageContext + "/json/profile/removeStarAjax.do", {id: id}, function () {
            turnOffStar(id);
            throbberControl.stop();
        });
    }

    /**
     * Change the state of a set of stars, and refresh the 'my stars' dropdown.
     * @param url the URL to inform the server about the change
     * @param updateStars the function to call to change the state of the stars in the browser
     */
    function doStar(url, params, updateStars) {
        var done = function (resp) {
            if (resp.worked) {
                updateStars(resp.id);
                return true;
            }
        };
        FECRU.AJAX.ajaxDo(url, params, done, false);
    }

    //todo: use AUI inline dialog
    function createStarDialog(dialogHider) {
        var $dialog = AJS.$(DIALOG_HTML);
        //intialize the dialog buttons
        AJS.$("#close-astronomy", $dialog).click(function (e) {
            dialogHider && dialogHider();
            e.preventDefault();
        });

        var $starLabel = AJS.$("#star-labels", $dialog);

        $starLabel.keypress(function (e) {
            if ((e.which || e.keyCode) === AJS.$.ui.keyCode.ENTER) {// if return is clicked
                e.preventDefault();
                AJS.$("#save-star-label", $dialog).trigger('click');
            }
        }).attr("autocomplete", "off");

        return $dialog;
    }

    function showStarDialog(dialogController, updateLabel, removeStar, currentLabel) {
        var $dialog = dialogController.getDialog();
        var $starLabel = AJS.$("#star-labels", $dialog);

        if (currentLabel) {
            $starLabel.val(currentLabel).data("defaultValue", currentLabel).addClass("focussed");
        } else {
            $starLabel.val('').data("defaultValue", "");
        }

        AJS.$("#remove-astronomy", $dialog).unbind().click(function (e) {
            e.preventDefault();
            removeStar();
            dialogController.hideDialog();
            $starLabel.val(DIALOG_DEFAULT).removeClass("focussed");
        });

        AJS.$("#save-star-label", $dialog).unbind().click(function (e) {
            e.preventDefault();
            var newLabel = $starLabel.val();
            if (newLabel == 'Describe your favourite') {
                newLabel = '';
            }
            if (newLabel !== $starLabel.data("defaultValue")) {
                $starLabel.data("defaultValue", newLabel);
                updateLabel(newLabel);
            }
            dialogController.hideDialog();
        });
        dialogController.showDialog();
    }

    function isDialogShown(starLink) {
        return starLink.hasClass("showDialog");
    }

    /**
     * bind a live click event to the stars.
     */
    function bindStars() {
        var $dialog = undefined; //stores a reference to the jquery elmem
        var dialogHider = undefined;
        var PADDING = 5;
        var hoverOptions = {
            onHover: false,
            showArrow: true,
            fadeTime: 200,
            hideDelay: null,
            showDelay: 0,
            width: 240 + PADDING,
            offsetX: -8, //to get the arrow centred at the star's vertical asix
            offsetY: 4,
            container: "body",
            useLiveEvents: true,
            cacheContent: false,
            initCallback: function () {
                //implementation note: we need a way to hide the dialog on demand - this callback has a hook into
                //the hide function that inline-dialog uses internally, so this is saving a reference to that function
                //for use later.
                var that = this;
                dialogHider = function () {
                    that.hide();
                };
            }
        };
        var onStarClickedHandler = function ($contentDiv, trigger, showPopup) {
            var $link = AJS.$(trigger);
            var dialogControl = {
                showDialog: function () {
                    if (isDialogShown($link)) {
                        if ($dialog === undefined) {
                            $dialog = createStarDialog(this.hideDialog);
                        }
                        $dialog.appendTo($contentDiv).show();
                        var $starLabels = AJS.$("#star-labels");
                        $starLabels.placeholder('Describe your favourite');
                        showPopup();
                    }
                },
                hideDialog: function () {
                    dialogHider && dialogHider();
                },
                getDialog: function () {
                    if ($dialog === undefined) {
                        $dialog = createStarDialog(this.hideDialog);
                    }
                    return $dialog;
                }
            };
            var opts = {
                throbberSetting: {
                    showThrob: true,         //todo: customizable throbbing needed?
                    noLatencyThreshold: 150, //if the ajax call takes less than this milliseconds, then no throb shown
                    minThrobberDisplay: 200  //otherwise, show for at least this milliseconds.
                }
            };
            starClicked(trigger, dialogControl, opts);
        };
        AJS.InlineDialog(".starrable.showDialog", "star-inline-dialog", onStarClickedHandler, hoverOptions);
        AJS.$(document).delegate('.starrable:not(.showDialog)', 'click', function () {
            onStarClickedHandler(null, this, null);
        });
    }

    ////// onload events for stars
    AJS.toInit(function () {
        bindStars();
    });
})();
/*[{!star_js_v63d549!}]*/;
/* END /2static/script/fecru/star.js */
/* START /2static/script/cru/util.js */
/**
 * Crucible utility functions that can be used from any crucible page.
 */

window.CRU = window.CRU || {};
CRU.UTIL = {};

(function ($) {
    var cruUtil = CRU.UTIL;
    /**
     * Crucible base url (without trailing '/').
     *
     * @param permaId optional review id
     */
    cruUtil.urlBase = function (permaId) {
        if (permaId) {
            return FECRU.pageContext + '/cru/' + permaId;
        } else {
            return FECRU.pageContext + '/cru';
        }
    };

    /**
     * Crucible JSON base url (without trailing '/').
     *
     * @param permaId optional review id
     */
    cruUtil.jsonUrlBase = function (permaId) {
        if (permaId) {
            return FECRU.pageContext + '/json/cru/' + permaId;
        } else {
            return FECRU.pageContext + '/json/cru';
        }
    };

    cruUtil.isReviewPage = function () {
        return typeof review !== 'undefined';
    };


    cruUtil.startAjaxDialogSpin = function () {
        $('body').addClass('ajax-dialog');
        AJS.dim();
    };

    cruUtil.stopAjaxDialogSpin = function () {
        AJS.undim();
        $('body').removeClass('ajax-dialog');
    };

    cruUtil.isAjaxDialogSpinning = function () {
        return cruUtil.isDimmed() && $('body').hasClass('ajax-dialog');
    };

    var _onReviewStateTransitCallbacks = {};
    var triggerCallbacks = function (command, resp) {
        for (var id in _onReviewStateTransitCallbacks) {
            if (_onReviewStateTransitCallbacks.hasOwnProperty(id)) {
                _onReviewStateTransitCallbacks[id](command, resp);
            }
        }
    };
    /**
     * The callback will be called when the state of review transits.
     *
     * @param callbackId : string -- enable more than one callbacks to be bound
     * @param callback : function ( command, resp )
     */
    cruUtil.onReviewStateTransit = function (callbackId, callback) {
        _onReviewStateTransitCallbacks[callbackId] = callback;
    };

    cruUtil.ajaxDialog = function (url, params, isFromStateTransition) {
        cruUtil.startAjaxDialogSpin();
        FECRU.AJAX.ajaxDo(url, params || {}, function (resp) {
            var complete = function () {
                if (isFromStateTransition) {
                    triggerCallbacks(params.command, resp);
                }
            };

            if (resp.worked) {
                if (resp.showDialog) {
                    cruUtil.stopAjaxDialogSpin();
                    try {
                        FECRU.DIALOG.getAjaxDialogContainer().html(resp.payload);
                        FECRU.DIALOG.triggerAjaxDialogLoaded();

                        complete();
                    } catch (e) {
                        alert(e);
                    }
                } else if (resp.redirect) {
                    complete();
                    // no need to undim
                    window.location = resp.payload;
                }
            }
            // !resp.worked handled by ajaxDo
        });
        return false;
    };

    cruUtil.stateTransition = function (transition, permaId, params) {
        var util = cruUtil;
        var url = util.jsonUrlBase(permaId) + '/changeStateAjax';
        var unsaved = CRU.UNSAVED;

        // Make sure there aren't any unsaved inputs on the page, and if there are, then provide a warning
        // and give the user the ability to cancel and save their inputs.
        if (unsaved) {
            if (!unsaved.confirmUnsubmittedInputs()) {
                return;
            }
            unsaved.clearWatchForUnsavedChanges();
        }

        params = params || {};

        $.extend(params, {
            command: transition
        });

        if (util.isReviewPage() && $.inArray(transition, ['action:completeReview', 'action:summarizeReview', 'action:closeReview']) >= 0) {
            // If completing or summarizing we need to warn if the review has been updated.

            util.startAjaxDialogSpin();
            CRU.REVIEW.UTIL.reviewUpdatedAjax({
                done: function () {
                    var reviewUpdated = $('body').hasClass('review-updated');
                    if (reviewUpdated) {
                        CRU.REVIEW.UTIL.warnAboutReviewUpdates({reshowWarning: true});
                    }
                    util.stopAjaxDialogSpin();
                    return util.ajaxDialog(url, $.extend(params, {reviewUpdated: reviewUpdated}), true);
                }
            });
            return false;

        } else {
            return util.ajaxDialog(url, params, true);
        }
    };

    cruUtil.editDetailsFormChange = false;
    cruUtil.checkEditForm = function (done) {
        if (cruUtil.editDetailsFormChange) {
            CRU.REVIEW.UTIL.postEditDetailsForm(done);
        } else {
            if (done) {
                done();
            }
        }
        return false;//do a link action if called from <a>
    };

    cruUtil.command = function (cmd, pid, button) {
        var perma = pid || permaId;
        if (button) {
            button.disabled = true;
        }
        var donext = function () {
            var url = cruUtil.urlBase(perma);
            FECRU.XSRF.postUri(url + '/' + cmd);
        };
        //check and post the editDetailsForm if it has changed
        cruUtil.checkEditForm(donext);
    };


    cruUtil.createBlankReview = function (params) {
        var url = cruUtil.jsonUrlBase() + '/createReviewDialog';
        return cruUtil.ajaxDialog(url, params);
    };

    cruUtil.createSnippet = function (params) {
        var url = cruUtil.jsonUrlBase() + '/createSnippetDialog';
        return cruUtil.ajaxDialog(url, params);
    };

    cruUtil.addToReview = function (params) {
        var url = cruUtil.jsonUrlBase() + '/createDialog';
        return cruUtil.ajaxDialog(url, params);
    };

    cruUtil.isAnyDialogShowing = function () {
        return AJS && AJS.popup && typeof AJS.popup.current !== 'undefined' && AJS.popup.current !== null;
    };

    cruUtil.isAnyOverlayShowing = function () {
        return $('.review-overlay.review-overlay__open').length > 0;
    };

    cruUtil.isDimmed = function () {
        return !!AJS.dim.dim;
    };

    cruUtil.makeCssRule = function (selector, ruleBody) {
        var styleSheet = document.styleSheets[0];
        var index = 0;
        if (styleSheet.insertRule) {
            styleSheet.insertRule(selector + '{' + ruleBody + '}', index);
            return styleSheet.cssRules[index].style;
        } else {
            // Internet Explorer's version.
            styleSheet.addRule(selector, ruleBody, index);
            return styleSheet.rules[index].style;
        }
    };

    cruUtil.createIdeSrc = function (linkUrl, frxId) {
        var src = linkUrl + '&id=' + Math.floor(Math.random() * 1000);
        if (frxId) {
            src += '&line=' + CRU.REVIEW.UTIL.getTopVisibleLineNumber(frxId);
        }
        return src;
    };

    cruUtil.loadJiraIssueLink = function (issueKey, $target, params, done) {
        if (!issueKey) {
            throw "JIRA issue key required";
        }
        if (!$target) {
            throw "Target container to insert issue details into required";
        }

        var isReviewIssue = ($target.attr("data-review-jira-issue") === "true");
        var hideIssueTitle = ($target.attr("data-hide-issue-title") === "true");

        var defaults = {
            shouldGetIssueMetadata: isReviewIssue,
            hideIssueTitle: hideIssueTitle,
            maxTitleLength: 75,
            key: issueKey
        };

        var data = $.extend({}, defaults, params);

        var getIssueDetails = function () {
            AJS.$.ajax({
                url: FECRU.pageContext + '/json/action/issue-inline.do',
                data: data,
                type: "GET",
                dataType: "json",
                cache: false,
                success: function (resp) {
                    if (resp.foundIssue || (resp.credentialsRequired && resp.credentialsRequired.length)) {
                        // only display html if we found an issue (no errors)
                        $target.html(resp.html);
                    }

                    if (!$target.find(".ual-authenticate").length) {
                        $target.attr("data-jira-issue-lazy-load", "false");
                    }

                    $target.find(".ual-authenticate").bind("click", function () {
                        FECRU.OAUTH.getEventProducer($(this).attr("href")).authorized(function () {
                            FECRU.HOVER.invalidateCache(FECRU.HOVER.CACHE_FOREVER, issueKey);
                            CRU.UI.loadInlineJiraIssues();
                        });
                    });

                    if (data.shouldGetIssueMetadata) {
                        if (resp.canLogWork) {
                            AJS.$("#time-spent").addClass("submit-jira-time");
                            AJS.$("#linked-jira-log-work").show();
                        }
                        if (resp.subtasksConfigured && !resp.issueIsSubtask) {
                            AJS.$("body").addClass("jiraSubtasksVisible");
                        } else {
                            AJS.$("body").removeClass("jiraSubtasksVisible");
                        }
                    }

                    done && done($target);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    // dont display jira errors in the UI
                    $target.attr("data-jira-issue-lazy-load", "false");
                }
            });
        };

        getIssueDetails();
    };

    // this is a method to handle legacy "checkbox" style user pickers via autocomplete
    cruUtil.addUserCheckbox = function (id, user) {
        var userid = user.dbId;
        var $elTarget = AJS.$('#' + id + '_rc_' + userid);

        if (!$elTarget.length) {
            // checkbox doesnt exist yet
            $elTarget = AJS.$('<span><input type="checkbox"/><label></label></span>');
            $elTarget.attr('id', id + '_rc_' + userid);
            $elTarget.children('input')
                .attr('name', id)
                .attr('value', user.id);
            $elTarget.children('label')
                .attr('for', id + '_rc_' + userid)
                .text(user.displayPrimary);

            AJS.$('#' + id + '_checkboxes').append($elTarget);
        }
        $elTarget.children('input').attr('checked', 'checked');
        $elTarget.show();
    };

})(AJS.$);
/*[{!util_js_6z0350x!}]*/;
/* END /2static/script/cru/util.js */
/* START /2static/script/fecru/ajax.js */
window.FECRU = window.FECRU || {};

FECRU.AJAX = (function ($, window) {

    /**
     * We need to distinguish between two cases. A user clicking away to another page, cancelling an Ajax request. In that case we
     * want to do nothing. When the server refuses a connection, we want to display an error message.
     */
    var unloaded = false;
    $(window).bind('beforeunload', function () {
        unloaded = true;
    });

    /**
     * Factory method that creates a new SequentialAjaxExecutor instance.
     */
    function createSequentialExecutor() {
        return new SequentialAjaxExecutor();
    }

    /******************************************************************
     ******************** AJAX METHODS ********************************
     ******************************************************************/

    /**
     * This class represents a serial channel for ajax calls. An ajax call that
     * is submitted only gets run after the previous call has returned from the
     * server.
     * This is used by Crucible comments: when you click "post" while autosave
     * is waiting for the server to create and return the new commentId, the
     * Post action is queued and automatically gets evaluated after autosave
     * has returned (and populated the js comment model with the new commentId).
     */
    function SequentialAjaxExecutor() {

        var busy = false;
        var $jobs = $('<div></div>');   // private var to SequentialAjaxExecutor, never inserted into the document.

        /**
         * Makes an AJAX call, similar to FECRU.AJAX.ajaxDo(), but with the exception that
         * only one call can be active at any time. When this method is called
         * a second time, while the previous call has not yet finished, the new
         * call will be scheduled and executed automatically when the previous
         * call finishes.
         *
         * @param url
         * @param params
         * @param onCompleteFunc
         */
        this.executeAjax = function (url, params, onCompleteFunc, noDialog) {
            this.executeAjaxJob({
                url: url,
                params: params,
                callback: onCompleteFunc,
                noDialog: noDialog
            });
        };

        /**
         * Similar to SerializedAjaxDispatcher.executeAjax(), but takes a hash with
         * functions that allow callers to evaluate their url and query params
         * just-in-time.
         *
         * @param job
         */
        this.executeAjaxJob = function (job) {
            if (busy) {
                var dispatcher = this;
                $jobs.queue(function () {
                    dispatcher.executeAjaxJob(job);
                });
            } else {
                busy = true;
                ajaxDo(
                    $.isFunction(job.url) ? job.url() : job.url,
                    $.isFunction(job.params) ? job.params() : job.params,
                    function (resp) {
                        try {
                            if (job.callback) {
                                job.callback(resp);
                            }
                        } finally {
                            busy = false;
                            $jobs.dequeue();
                        }
                    },
                    $.isFunction(job.noDialog) ? job.noDialog() : job.noDialog);
            }
        };

        this.isPending = function () {
            return busy;
        };
    }

    function ajaxDo(url, params, onCompleteFunc, noDialog) {
        return ajaxUpdate(url, params, null, onCompleteFunc, noDialog);
    }

    /**
     * Makes a Ajax request with the specified parameters and runs the onCompleteFunc
     * function when the call returns. Optionally, a DOM element can be passed in
     * which will be updated with the payload of the Ajax response (the JSON response
     * object must contain a "payload" member.
     *
     * noDialog is optional: if falsy, the error message dialog is shown on error.
     * If it is a callback, it is invoked on error instead of showing the dialog.
     * Otherwise, if it is truthy, the dialog is not shown on error and no action
     * is taken. It makes sense to not report an error when the Ajax action is triggered by a timer, rather than by a
     * user action, or where the failure of the Ajax action doesn't affect what the user is doing. (e.g. ?)
     * TODO any other cases where we should not show an error?
     */
    function ajaxUpdate(url, params, elementIdToUpdate, onCompleteFunc, noDialog) {
        // Implemementation note:
        // jQuery does an eval(req.responseText) for us internally. We have an onSuccess callback to
        // intercept this, otherwise we end up eval'ing the response text twice (which is poor form).
        // The onComplete callback gives us access to the XmlHttpRequest and allows us to do extra
        // error handling if required.

        var data = false;
        var onSuccess = function (response) {
            data = response;
        };

        /*eslint-disable complexity*/
        var onComplete = function (req, textStatus) {
            // We do not want to proceed if the request was aborted
            if (textStatus === 'abort') {
                return;
            }

            var cleanUpOnFail = function () {
                if (onCompleteFunc) {
                    onCompleteFunc({worked: false});  //allow function to clean up
                }
            };
            try {

                if (req.status === 0) {
                    if (!unloaded) {
                        cleanUpOnFail();
                        if (!noDialog) {
                            showServerUnreachableBox();
                        }
                    }
                    //else this was caused by user navigating away, ignore it.
                    return;
                }
                if (!data || !isECMA(req)) {
                    noDialog || displayUnexpectedResponse(req);
                    cleanUpOnFail();
                    return;
                }

                var $updateMe;
                if (elementIdToUpdate) {
                    $updateMe = $("#" + elementIdToUpdate);
                }

                if (data.hasOwnProperty("worked") && !data.worked) {
                    if (!noDialog) {
                        appendErrorResponse(data.errorMsg, data.noEscape);
                        appendCredentialsRequests(data.credentialsRequired);
                        if (data.userError) {
                            showUserErrorBox();
                        } else {
                            showErrorBox();
                        }
                    }
                } else if ($updateMe && $updateMe.length === 1) {
                    if ($updateMe.is(':input')) {
                        $updateMe.val(data.payload);
                    } else {
                        $updateMe.html(data.payload);
                    }
                }
                if (onCompleteFunc) {
                    onCompleteFunc(data);
                }
            } catch (e) {
                console && console.error('ajaxUpdate failure: ' + e);
                displayUnexpectedResponse(req);
                cleanUpOnFail();
            }
        };
        /*eslint-enable*/

        return $.ajax({
            type: "post",
            url: url,
            data: params,
            dataType: "json",
            traditional: true, // serialize array params as rev=1&rev=2 rather than rev[]=1&rev[]=2
            success: onSuccess,
            complete: onComplete,
            beforeSend: function (req, settings) {
                req.url = settings.url;
            },
            error: noDialog ? ($.isFunction(noDialog) ? noDialog : NOOP) : ajaxFailure
        });
    }


    var NOOP = function () {
    };

    var ajaxFailure = function (req, textStatus, errorThrown) {
        try {
            if (!isECMA(req)) {
                displayUnexpectedResponse(req);
                return;
            }
            var resp = eval('(' + req.responseText + ')');
            var errorShown = false;
            if (!resp.worked || resp.errorMsg || resp.message) {
                appendErrorResponse(resp.errorMsg || resp.message, resp.noEscape);
                errorShown = true;
            }
            if (errorThrown) {
                appendErrorResponse(errorThrown);
                errorShown = true;
            }
            if (!errorShown) {
                appendErrorResponse("Unknown error");
            }
            showErrorBox();
        } catch (e) {
            console && console.error('ajaxFailure: ' + e);
            displayUnexpectedResponse(req);
        }
    };

    /******************************************************************
     ******************** HELPER METHODS ******************************
     ******************************************************************/

    var isECMA = function (req) {
        return isContentType(req, /^application\/(ecmascript|json)/);
    };

    var isHTML = function (req) {
        return isContentType(req, /^text\/html/);
    };

    var isContentType = function (req, targetType) {
        var respContentType = req.getResponseHeader("Content-Type");
        return respContentType != null && respContentType.match(targetType);
    };

    var isHTMLFrag = function (req) {
        var responseText = req.responseText;
        return responseText != null && !responseText.match(/<body/i);
    };

    //TODO use FECRU.htmlEscape || AJS.escapeHtml
    var ourHtmlEscape = function (input) {
        try {
            return input.replace(/&/g, '&amp;').
                replace(/>/g, '&gt;').
                replace(/</g, '&lt;').
                replace(/"/g, '&quot;');
        } catch (e) {
            console && console.error('escape failure: ' + e);
            return input.message || 'There was an error communicating with the server';
        }
    };

    /**
     * @deprecated use $.spin() instead which was introduced in AUI 5.0-fecru1
     */
    function startSpin(id, className, replace) {
        className = className ? className + " spinner" : "spinner";

        var $el = typeof(id) === 'object' ? $(id) : $("#" + id);
        if ($el.length === 1) {
            var $spinner = $(document.createElement("span"));
            $spinner.addClass(className)
                .html("<img src='" + FECRU.pageContext + "/" + FECRU.staticDirectory + "/2static/images/blank.gif'>");
            if (replace) {
                $el.replaceWith($spinner);
            } else {
                if (!$el.next().is('.spinner')) {
                    $spinner.insertAfter($el);
                }
            }
            return true;
        }
        return false;
    }

    /**
     * @deprecated use $.spinStop() instead which was introduced in AUI 5.0-fecru1
     */
    function stopSpin(id) {
        var $el = typeof(id) === 'object' ? $(id) : $("#" + id);

        if ($el.length === 1) {
            $el.nextAll(".spinner").remove();
        }
    }


    /******************************************************************
     ******************** ERROR HANDLING ******************************
     ******************************************************************/

    function checkError(resp) {
        return resp.error;
    }

    function appendErrorResponse(error, noEscape) {
        if (error) {
            appendErrorMessage(error + (error.stack ? ":\n" + error.stack : ""), noEscape);
        }
    }

    function appendCredentialsRequests(credentialsRequired) {
        if (credentialsRequired) {
            for (var i = 0; i < credentialsRequired.length; i++) {
                var creds = credentialsRequired[i];
                var msg = "Click <a onclick=\"FECRU.HOVER.invalidateCache(FECRU.HOVER.CACHE_FOREVER); return true;\" href='" + creds.authUrl + "' target='_new'>here</a> to authenticate with " + creds.name;
                appendErrorMessage(msg, true);
            }
        }
    }

    function appendErrorMessage(errorMsg, noEscape) {
        if (errorMsg) {
            var $err = $('#errorResponses');
            var errorCount = $err.find('.errorResponse').length;
            var escaped = (noEscape) ? errorMsg : ourHtmlEscape(errorMsg);

            var $existingErrors = $('#errorResponses .errorResponse');
            for (var i = 0, len = $existingErrors.length; i < len; i++) {
                if (escaped === $($existingErrors[i]).html()) {
                    return; // dont show an error if we have already seen it
                }
            }

            $err.show()
                .append($('<div class="errorResponse-count">Error' + (errorCount ? (' ' + ++errorCount) : '') + '</div>'))
                .append($('<div class="errorResponse"></div>').html(escaped));
        }
    }

    function appendNotificationMessage(message) {
        if (message) {
            var $err = $('#errorResponses');
            var $msg = $('<div class="notification-box-message"></div>');

            if (message.jquery) {
                $msg.append(message);
            } else {
                $msg.text(message);
            }
            $err.append($msg);
        }
    }

    var dialog = 0;

    function showErrorBox() {
        showNotificationBox('An error has occurred');
        $('#errorDetails').show();
    }

    function showUserErrorBox() {
        showNotificationBox('Cannot perform the requested action', 'usererror');
        $('#errorDetails').show();
    }

    function showServerUnreachableBox() {
        showNotificationBox('The server is not responding.');
        $('#errorDetails').show();
    }

    function showNotificationBox(title, severity) {
        severity = severity || "error";
        var util = CRU.UTIL;

        if (dialog === 0) {
            dialog = FECRU.DIALOG.create(640, 480, "error-dialog");
            dialog.addHeader(title)
                .addPanel("Information", $('#errorBox'))
                .addButton("Reload", function () {
                    window.location.reload();
                }, "reload-button")
                .addButton("Close", function () {
                    $('#errorResponses .errorResponse').remove();
                    $('#errorResponses .errorResponse-count').remove();
                    dialog.hide();
                }, "close-button");
        } else {
            dialog.addHeader(title);
        }
        var $dialog = $('#error-dialog');
        if (severity === 'error') {
            $dialog.addClass('error').removeClass('message usererror');
        } else if (severity === 'usererror' && !$dialog.hasClass('error')) {
            $dialog.find(".errorResponse-count").hide();
            $dialog.addClass('usererror').removeClass('message error');
        } else if (severity === 'message' && !$dialog.hasClass('error') && !$dialog.hasClass('usererror')) {
            $dialog.addClass('message').removeClass('error usererror');
        }

        // error overrides message and usererror, usererror overrides message
        if (severity === 'error') {
            override = true; // eslint-disable-line no-undef
        } else if (severity === 'usererror' && $dialog.hasClass('message')) {
            override = true; // eslint-disable-line no-undef
        }

        if (!util.isAnyDialogShowing()) {
            if (util.isAjaxDialogSpinning()) {
                util.stopAjaxDialogSpin();
            }
            dialog.show();
        }
        return false;
    }

    function displayUnexpectedResponse(req) {
        var error = {}; // message, noEscape, title, severity;
        if (isHTML(req) && isHTMLFrag(req)) {
            error.message = req.responseText;
        }
        else if (!req.responseText) {
            //no-op here: no responseText means most likely server is gone offline, which is handled in onComplete
        }
        else {
            try {
                var resp = eval('(' + req.responseText + ')');

                if (!resp.errorMessages[0]) {
                    resp.errorDetails = "<p>No further details were provided.</p>";
                }
                else {
                    resp.errorDetails = resp.errorMessages.join("<br>");
                }

                var startsWithVowel = resp.errorName && (-1 !== "aeiou".indexOf(resp.errorName.charAt(0).toLowerCase()));

                error.message = [
                    "<p>",
                    (resp.errorName ? (startsWithVowel ? "An " : "A ") + resp.errorName : "An error"),
                    " was encountered",
                    "</p>",
                    resp.errorDetails
                ].join("");
                error.noEscape = true;
            } catch (e) {
                if (req.status >= 400) {
                    error.message = req.status + ": " + req.statusText;
                    error.title = "Error communicating with the server";
                    error.severity = "error";
                }
            }
        }
        if (error.message) {
            appendErrorResponse("<p>URL: " + AJS.escapeHtml(req.url) + "</p>" + (error.noEscape ? error.message : AJS.escapeHtml(error.message)), true);
            if (error.title) {
                showNotificationBox(error.title, error.severity);
            } else {
                showErrorBox();
            }
        }
    }

    function displayErrorInResponse(err) {
        appendErrorResponse(err);
        showErrorBox();
    }

    return {
        createSequentialExecutor: createSequentialExecutor,

        ajaxDo: ajaxDo,
        ajaxUpdate: ajaxUpdate,

        /**
         * @deprecated use $.spin() instead which was introduced in AUI 5.0-fecru1
         */
        startSpin: startSpin,
        /**
         * @deprecated use $.spinStop() instead which was introduced in AUI 5.0-fecru1
         */
        stopSpin: stopSpin,

        checkError: checkError,

        appendErrorResponse: appendErrorResponse,
        appendErrorMessage: appendErrorMessage,
        showErrorBox: showErrorBox,
        showUserErrorBox: showUserErrorBox,
        showServerUnreachableBox: showServerUnreachableBox,
        appendNotificationMessage: appendNotificationMessage,
        showNotificationBox: showNotificationBox,
        ajaxFailure: ajaxFailure
    };
})(AJS.$, this);
/*[{!ajax_js_6oig53d!}]*/;
/* END /2static/script/fecru/ajax.js */
