/* CONCAT of
/admin.js
/script/common/global.js
/2static/script/cru/util.js
/2static/script/fecru/dialog.js
/2static/script/lib/jquery/plugins/jquery.tablesorter-2.0.3.min.js
/2static/script/lib/jquery/plugins/jquery.metadata-2.0.min.js
/2static/script/lib/jquery/plugins/jquery.scrollTo.js
*/
/* START /admin.js */
/*eslint eqeqeq:0*/

window.FE = window.FE || {};
if (FE.ADMIN === undefined) {
    FE.ADMIN = {};
}

(function () {

    FE.ADMIN.urlBase = function () {
        return FECRU.pageContext + '/admin/';
    };

    AJS.$(document).ready(function () {
        AJS.$("#createArchiveButton").click(function () {
            FE.ADMIN.createBackupDialog();
            return false;
        });
        AJS.$("#disableCheckbox").click(function () {
            FE.ADMIN.toggleEditScheduledBackupsProperties();
            return true;
        });
        AJS.$("#authUsingTrustedApps").click(function () {
            AJS.$("#trusted-subtask-warning").toggle();
        });
    });

    FE.ADMIN.createBackupDialog = function () {
        AJS.$("#createArchiveButton").prop("disabled", true);

        var params = "";
        AJS.$.each(AJS.$("#backupItemSelection :checkbox:checked"), function () {
            params += "includeItems=" + this.value + "&";
        });
        if (AJS.$(".field-group #path")) {
            params += "path=" + AJS.$(".field-group #path").attr("value");
        }

        var backupStarted = function(resp) {
            // show the progress dialog
            FECRU.DIALOG.create(840, 580)
                .addHeader('Creating Backup')
                .addPanel('All', "<iframe id='fecru-iframe' src='" + FE.ADMIN.urlBase() + "backupprogress.do' " +
                    "width='100%' height='100%' border='0' scrolling='no' frameborder='0'>")
                .addButton('Close', function (dialog) {
                    dialog.hide();
                    AJS.$("#createArchiveButton").prop("disabled", false);
                })
                .show();
        }
        FECRU.AJAX.ajaxDo("performBackup-start.do", params, backupStarted);
    };

    /** Open the db migration dialog.
     * @param redirectOnCompletion redirect URL once the migration finishes (successfully or not). */
    FE.ADMIN.migrateDialog = function (redirectOnCompletion) {

        FECRU.DIALOG.create(840, 550, "migrateDialog")
            .addHeader("Migrating Database")
            .addPanel("All", "<div id='dialogContentPane'>Loading...</div>")
            .addButton("Ok", function (dialog) {
                dialog.hide();
                window.location = redirectOnCompletion;
            }, "okButtonDialog")
            .show();
        AJS.$(".okButtonDialog", "#migrateDialog").prop('disabled', true);

        var done = function (resp) {
            AJS.$("textarea", "#dialogContentPane").scrollTo("max");
            if (resp.finished) {
                AJS.$(".okButtonDialog", "#migrateDialog").prop('disabled', false);
            } else {
                var url = FECRU.pageContext + "/setup/migrateDBProgressAjax";
                setTimeout(function () {
                        FECRU.AJAX.ajaxUpdate(url, {}, "dialogContentPane", done)
                    },
                    1000);  // poll once per second
            }
        };

        var url = FE.ADMIN.urlBase() + "migrateDialog.do";
        var params = AJS.$("#dbform").serializeArray();
        FECRU.AJAX.ajaxUpdate(url, params, "dialogContentPane", done);
    };

    FE.ADMIN.toggleEditScheduledBackupsProperties = function () {

        var checkbox = AJS.$("#disableCheckbox");
        var inputs = AJS.$("#editPane input, #editPane select")
            .filter(':not(#disableCheckbox, #saveButton, #cancelButton)');

        inputs.prop("disabled", checkbox.is(":checked"));
    };
})();


function showRepoAttribs(repo) {
    var storeDiffTrueElt = document.getElementById('repository_storeDifftrue');
    var storeDiffFalseElt = document.getElementById('repository_storeDifffalse');
    var cvsDiv = document.getElementById('cvsFields');
    var svnDiv = document.getElementById('svnFields');
    var p4Div = document.getElementById('p4Fields');
    var gitDiv = document.getElementById('gitFields');
    var ccDiv = document.getElementById('ccFields');
    var hgDiv = document.getElementById('hgFields');
    var selection = repo.options[repo.selectedIndex].value;
    if (selection == "cvs") {
        cvsDiv.style.display = '';
        svnDiv.style.display = 'none';
        p4Div.style.display = 'none';
        gitDiv.style.display = 'none';
        ccDiv.style.display = 'none';
        hgDiv.style.display = 'none';
        storeDiffTrueElt.disabled = true;
        storeDiffFalseElt.disabled = true;
    } else if (selection == "svn") {
        cvsDiv.style.display = 'none';
        svnDiv.style.display = '';
        p4Div.style.display = 'none';
        gitDiv.style.display = 'none';
        ccDiv.style.display = 'none';
        hgDiv.style.display = 'none';
        storeDiffTrueElt.disabled = false;
        storeDiffFalseElt.disabled = false;
    } else if (selection == "p4") {
        cvsDiv.style.display = 'none';
        svnDiv.style.display = 'none';
        p4Div.style.display = '';
        gitDiv.style.display = 'none';
        ccDiv.style.display = 'none';
        hgDiv.style.display = 'none';
        storeDiffTrueElt.disabled = false;
        storeDiffFalseElt.disabled = false;
    } else if (selection == "git") {
        cvsDiv.style.display = 'none';
        svnDiv.style.display = 'none';
        p4Div.style.display = 'none';
        gitDiv.style.display = '';
        ccDiv.style.display = 'none';
        hgDiv.style.display = 'none';
        storeDiffTrueElt.disabled = false;
        storeDiffFalseElt.disabled = false;
    } else if (selection == "clearcase") {
        cvsDiv.style.display = 'none';
        svnDiv.style.display = 'none';
        p4Div.style.display = 'none';
        gitDiv.style.display = 'none';
        ccDiv.style.display = '';
        hgDiv.style.display = 'none';
        storeDiffTrueElt.disabled = false;
        storeDiffFalseElt.disabled = false;
    } else if (selection == "hg") {
        cvsDiv.style.display = 'none';
        svnDiv.style.display = 'none';
        p4Div.style.display = 'none';
        gitDiv.style.display = 'none';
        ccDiv.style.display = 'none';
        hgDiv.style.display = '';
        storeDiffTrueElt.disabled = false;
        storeDiffFalseElt.disabled = false;
    } else {
        cvsDiv.style.display = 'none';
        svnDiv.style.display = 'none';
        p4Div.style.display = 'none';
        gitDiv.style.display = 'none';
        ccDiv.style.display = 'none';
        hgDiv.style.display = 'none';
        storeDiffTrueElt.disabled = false;
        storeDiffFalseElt.disabled = false;
    }
    showAdvRepoAttribs();
}

function showAdvRepoAttribs() {
    var commonAdv = document.getElementById('commonAdv');
    var cvsAdv = document.getElementById('cvsAdv');
    var svnAdv = document.getElementById('svnAdv');
    var p4Adv = document.getElementById('p4Adv');
    var gitAdv = document.getElementById('gitAdv');
    var ccAdv = document.getElementById('ccAdv');
    var hgAdv = document.getElementById('hgAdv');
    var repo = document.getElementById("repoTypeSelection");
    if (document.getElementById("advanced").value == 'Simple' /* indicates 'advanced' is selected */) {
        commonAdv.style.display = '';
        var selection = repo.options[repo.selectedIndex].value;
        if (selection == "cvs") {
            cvsAdv.style.display = '';
            svnAdv.style.display = 'none';
            p4Adv.style.display = 'none';
            gitAdv.style.display = 'none';
            ccAdv.style.display = 'none';
            hgAdv.style.display = 'none';
        } else if (selection == "svn") {
            cvsAdv.style.display = 'none';
            svnAdv.style.display = '';
            p4Adv.style.display = 'none';
            gitAdv.style.display = 'none';
            ccAdv.style.display = 'none';
            hgAdv.style.display = 'none';
        } else if (selection == "p4") {
            cvsAdv.style.display = 'none';
            svnAdv.style.display = 'none';
            p4Adv.style.display = '';
            gitAdv.style.display = 'none';
            ccAdv.style.display = 'none';
            hgAdv.style.display = 'none';
        } else if (selection == "git") {
            cvsAdv.style.display = 'none';
            svnAdv.style.display = 'none';
            p4Adv.style.display = 'none';
            gitAdv.style.display = '';
            ccAdv.style.display = 'none';
            hgAdv.style.display = 'none';
        } else if (selection == "clearcase") {
            cvsAdv.style.display = 'none';
            svnAdv.style.display = 'none';
            p4Adv.style.display = 'none';
            gitAdv.style.display = 'none';
            ccAdv.style.display = '';
            hgAdv.style.display = 'none';
        } else if (selection == "hg") {
            cvsAdv.style.display = 'none';
            svnAdv.style.display = 'none';
            p4Adv.style.display = 'none';
            gitAdv.style.display = 'none';
            ccAdv.style.display = 'none';
            hgAdv.style.display = '';
        } else {
            cvsAdv.style.display = 'none';
            svnAdv.style.display = 'none';
            p4Adv.style.display = 'none';
            gitAdv.style.display = 'none';
            ccAdv.style.display = 'none';
            hgAdv.style.display = 'none';
        }
    } else {
        commonAdv.style.display = 'none';
        cvsAdv.style.display = 'none';
        svnAdv.style.display = 'none';
        p4Adv.style.display = 'none';
        gitAdv.style.display = 'none';
        ccAdv.style.display = 'none';
        hgAdv.style.display = 'none';
    }
}
function toggleCCViewAttributes() {
    AJS.$(".ccAutoCreate").closest("tr").toggleClass('ccHide');
}
function toggleCCAttributes(stylesToToggle) {
    if (stylesToToggle == undefined) {
        stylesToToggle = ".ccUCM, .ccBase";
    }
    AJS.$(stylesToToggle).closest("tr").toggleClass('ccHide');
    AJS.$("label[for='clearcase_includeIntegrationActivities']").closest("tr").toggleClass('ccHide');
    var ucm_radio = AJS.$("#clearcase_ucmtrue")[0];
    if (ucm_radio.checked) {
        AJS.$("label[for='clearcase_integrationOnly']").text("Integration Streams Only?");
    } else {
        AJS.$("label[for='clearcase_integrationOnly']").text("Main Branches Only?");
    }
}

function svnSymDelRowEvent(a) {
    var tr = a.parentNode.parentNode;
    tr.parentNode.removeChild(tr);
    svnSymSetToCustom();
}
function svnSymAddRowEvent(stype) {
    svnSymAddRow(stype, false);
    svnSymSetToCustom();
}

function svnSymAddRow(stype, readonlyFields) {
    var tabBody = document.getElementById('svnsym' + stype);
    var idx = tabBody.getElementsByTagName("tr").length;

    var propPrefix = "svnSymbolic." + stype + "[" + idx + "]";

    var makesvnSymField = function (prop) {
        var field = document.createElement("input");
        field.type = "text";
        field.name = propPrefix + prop;
        field.size = "20";
        field.readOnly = readonlyFields;

        return field;
    };

    var newrow = document.createElement("tr");

    var addToRow = function (field) {
        var td = document.createElement("td");
        td.appendChild(field);
        newrow.appendChild(td);
    };

    var f1 = makesvnSymField(".regex");
    addToRow(f1);

    var f2 = makesvnSymField(".name");
    addToRow(f2);

    var f3 = makesvnSymField(".logical");
    addToRow(f3);

    var delAnchor = document.createElement("a");
    delAnchor.innerHTML = "Del";
    delAnchor.href = "#svnSymAnchor";
    delAnchor.onclick = function () {
        svnSymDelRowEvent(delAnchor);
    };
    addToRow(delAnchor);

    tabBody.appendChild(newrow);

    var result = {
        'regex': f1, 'name': f2, 'logical': f3
    };
    return result;
}

function svnSymSetToCustom() {
    var sel = document.getElementById("svnSymSelect");
    sel.value = "custom";
    svnSymTypeChange(sel);
}

function svnSymUpdateControls(body, readonly) {
    var fields = body.getElementsByTagName("input");
    for (var i = 0; i < fields.length; i++) {
        var f = fields[i];
        f.readOnly = false;
    }
}

function svnSymSetupRow(fields, reg, name, logical) {
    fields['regex'].value = reg;
    fields['name'].value = name;
    fields['logical'].value = logical;
}

function svnRemoveAllRows(svnParent) {
    var svnChildren = svnParent.rows;
    for (var i = 0; i < svnChildren.length; i++) {
        svnParent.removeChild(svnChildren[i]);
    }
}

function svnSymTypeChange(select) {
    var trunkd = document.getElementById('svnsymtrunk');
    var branchd = document.getElementById('svnsymbranch');
    var tagd = document.getElementById('svnsymtag');

    if (select.value == "custom") {
        svnSymUpdateControls(trunkd, false);
        svnSymUpdateControls(branchd, false);
        svnSymUpdateControls(tagd, false);
        return true;
    }

    svnRemoveAllRows(trunkd);
    svnRemoveAllRows(branchd);
    svnRemoveAllRows(tagd);

    if (select.value == "type1") {

        svnSymSetupRow(svnSymAddRow('trunk', true), "trunk(/|$)", "trunk", "");
        svnSymSetupRow(svnSymAddRow('branch', true), "branches/([^/]+)", "\${1}", "");
        svnSymSetupRow(svnSymAddRow('tag', true), "tags/([^/]+)", "\${1}", "");

    } else if (select.value == "type2") {

        svnSymSetupRow(svnSymAddRow('trunk', true), "([^/]+)/trunk(/|$)", "trunk", "\${1}");
        svnSymSetupRow(svnSymAddRow('branch', true), "([^/]+)/branches/([^/]+)", "\${1}-\${2}", "\${1}");
        svnSymSetupRow(svnSymAddRow('tag', true), "([^/]+)/tags/([^/]+)", "\${1}-\${2}", "\${1}");

    }
    return true;
}

// copied from crucibles global.js
function simpleSwap(toHide, toShow) {
    if (typeof(toHide) == 'object') {
        AJS.$(toHide).hide();
    } else {
        AJS.$("#" + toHide).hide();
    }
    if (typeof(toShow) == 'object') {
        AJS.$(toShow).show();
    } else {
        AJS.$("#" + toShow).show();
    }
}

// trim text fields of leading and trailing whitespace
function trimFormTextFields(form) {

    var inputs = AJS.$(form).find("input[type='text']");

    for (var i = 0, j = inputs.length; i < j; i++) {
        var inputElement = AJS.$(inputs[i]);
        inputElement.val(inputElement.val().replace(/^\s+|\s+$/g, ''));
    }

    return true;
}

// stack trace pretty

function expandStackTrace(tid) {
    toggleTrace(tid, true);
}

function collapseStackTrace(tid) {
    toggleTrace(tid, false);
}

function toggleTrace(tid, expand) {
    var expander = "#thread-" + tid + "-expander";
    var collapser = "#thread-" + tid + "-collapser";
    var stack = "#thread-" + tid;
    if (expand) {
        jQuery(expander).hide();
        jQuery(collapser).show();
        jQuery(stack).show();
    }
    else {
        jQuery(collapser).hide();
        jQuery(expander).show();
        jQuery(stack).hide();
    }
}

jQuery(document).ready(function () {
    jQuery(".stackElement", "#threaddump").each(function () {
        var traceLine = jQuery(this).text();
        if (traceLine.indexOf("cenqua") != -1 || traceLine.indexOf("atlassian") != -1) {
            jQuery(this).addClass("productCode");
            var threadId = jQuery(this.parentNode).attr("id");
            jQuery("#" + threadId + "-hl").addClass("productCodeHL");
        }
    });
});
/*[{!admin_js_dtip4ud!}]*/;
/* END /admin.js */
/* START /script/common/global.js */
//crucible global.js
var $dropdown = 0;
var dropdownTimer = 0;

function openDropDown(id) {
    clearTimeout(dropdownTimer);

    // Close the old menu if it's not the same menu as is already open
    if ($dropdown && (id instanceof AJS.$ ? ($dropdown.get(0) !== id.get(0)) : ($dropdown.attr("id") !== id))) {
        $dropdown.fadeOut(100);
    }

    // get new menu and show it
    var $menu = (id instanceof AJS.$) ? id : AJS.$("#" + id);
    $dropdown = $menu.show();
}

function closeDropDown() {
    if ($dropdown && $dropdown.length === 1) {
        dropdownTimer = setTimeout(function () {
            $dropdown.fadeOut(100);
        }, 200);
    }
}

function simpleSwap(toHide, toShow) {
    if (typeof(toHide) === 'object') {
        AJS.$(toHide).hide();
    } else {
        AJS.$("#" + toHide).hide();
    }
    if (typeof(toShow) === 'object') {
        AJS.$(toShow).show();
    } else {
        AJS.$("#" + toShow).show();
    }
}
function expandAll(ids, prefix) {
    toggleAll(ids, true, false, prefix);
}
function collapseAll(ids, prefix) {
    toggleAll(ids, false, true, prefix);
}
function expandSelected(allIds, selectedIds, prefix) {
    //first collapse all
    toggleAll(allIds, false, true, prefix);
    toggleAll(selectedIds, true, false, prefix);
}
function toggleType(ids, prefix) {
    toggleAll(ids, false, false, prefix);
}
function toggleBasic(nodeName) {
    toggleNodeAndImage(nodeName, false, false);
}
function collapseBasic(nodeName) {
    toggleNodeAndImage(nodeName, false, true);
}
function expandBasic(nodeName) {
    toggleNodeAndImage(nodeName, true, false);
}
function toggleAll(ids, forceOpen, forceClose, prefix) {
    prefix = prefix || '';
    for (var i = 0; i < ids.length; i++) {
        var theNode = prefix + ids[i];
        toggleNodeAndImage(theNode, forceOpen, forceClose);
    }
    return false;
}

function toggleNodeAndImage(nodeName, forceOpen, forceClose) {
    if (!nodeName) {
        return;
    }
    nodeName = FECRU.sanitizeId(nodeName);
    var $node = AJS.$("#" + nodeName);
    if ($node.length === 0) {
        return;
    }

    var img = AJS.$("#" + nodeName + 'img');
    if (img.length === 1) {
        var swapImage = true;
    }

    // Don't use is(":hidden") here, because we need to force things closed even if their parents are closed
    var shouldOpen = $node.css("display") === 'none';
    shouldOpen = (!forceClose) && (forceOpen || shouldOpen);
    if (shouldOpen) {
        $node.show();
        if (swapImage) {
            img.attr("src", FECRU.pageContext + '/' + FECRU.staticDirectory + '/images/arrow_open.gif');
        }
    } else {
        $node.hide();
        if (swapImage) {
            img.attr("src", FECRU.pageContext + '/' + FECRU.staticDirectory + '/images/arrow_closed.gif');
        }
    }
}

function rollover(obj) {
    if (obj.tagName === 'IMG') {
        var imgsrc = obj.src.replace(/\.gif$/, '');
        obj.src = imgsrc + '_over.gif';
    }
    return false;
}

function rollout(obj) {
    if (obj.tagName === 'IMG') {
        obj.src = obj.src.replace(/\_over\.gif$/, '.gif');
    }
    return false;
}

function toggleOverflow(handle, element) {
    var $el = AJS.$(element);
    var $hd = AJS.$(handle);
    if ($el.css("overflow") === 'hidden' || $el.css("overflow") === '') {
        $el.css({'overflow': 'visible', 'height': 'auto'});
        $hd.attr("src", $hd.attr("src").replace(/expand\.gif$/, 'collapse.gif'));
    } else {
        $el.css({'overflow': 'hidden', 'height': '1.3em'});
        $hd.attr("src", $hd.attr("src").replace(/collapse\.gif$/, 'expand.gif'));
    }
}


function submitDefaultForm(command) {
    document.defaultForm.command.value = command;
    document.defaultForm.submit();
}

function toggleWording(handle) {
    var $handleEl = AJS.$(handle);
    var handleText = $handleEl.html().substring(0, 4);
    switch (handleText) {
        case 'Show':
            $handleEl.html($handleEl.html().replace(/^Show/, 'Hide'));
            return true;
        case 'Hide':
            $handleEl.html($handleEl.html().replace(/^Hide/, 'Show'));
            return true;
        case 'Expa':
            $handleEl.html($handleEl.html().replace(/^Expand/, 'Collapse'));
            return true;
        case 'Coll':
            $handleEl.html($handleEl.html().replace(/^Collapse/, 'Expand'));
            return true;
        case 'More':
            $handleEl.html($handleEl.html().replace(/^More/, 'Less'));
            return true;
        case 'Less':
            $handleEl.html($handleEl.html().replace(/^Less/, 'More'));
            return true;
    }
    return false;
}

function show(toShow, bool) {
    AJS.$(toShow).toggle(bool);
}

var ovAnk = false; //tracks whether the mouse is over a "real" anchor
function toggleSensitively(id) {
    if (!ovAnk) {
        toggleBasic(id);
    }
}

// force IE8 to load icon fonts
// http://stackoverflow.com/questions/9809351/ie8-css-font-face-fonts-only-working-for-before-content-on-over-and-sometimes
(function ($) {
    if ($.browser.msie && $.browser.version <= 8) {
        AJS.$(function () {
            var head = document.getElementsByTagName('head')[0];
            var style = document.createElement('style');

            style.type = 'text/css';
            style.styleSheet.cssText = ':before,:after{content:none !important';
            head.appendChild(style);
            setTimeout(function () {
                head.removeChild(style);
            }, 0);
        });
    }
})(AJS.$);

// forces ie10 to redraw element for certain events
// we can remove this code after redesign of review page
(function ($, _) {
    var isIE11 = '-ms-scroll-limit' in document.documentElement.style && '-ms-ime-align' in document.documentElement.style;
    var isIE10 = $.browser.msie && $.browser.version === 10;
    if (isIE10 || isIE11) {
        document.documentElement.classList.add(isIE11 ? 'ie11' : 'ie10');

        $(function () {
            var classList = document.body.classList;
            var redrawBody = classList.toggle.bind(classList, 'oh-come-on-ie');
            var timeouts = {
                // aui2 dropdown2 sometimes needs 2 repaints
                'aui-dropdown2-show': [20, 100]
            };

            if (isIE10) {
                timeouts['aui-dropdown2-show'] = [20, 300];
                timeouts.showLayer = [200];
                timeouts.default = [50];
            }

            $(document).on(Object.keys(timeouts).join(' '), _.debounce(function (e) {
                redrawBody();
                var timeout = timeouts[e.type] || timeouts.default;
                timeout.forEach(setTimeout.bind(window, redrawBody));
            }, 50));
        });
    }

    if (isIE11) {
        // IE11 triggers focusin on body element after closing inline-dialog
        // "We need to stop him!"
        // should be fixed in AUI
        $(document).on('aui-dropdown2-show', function () {
            var $body = $(document.body);
            var blockFocusIn = function (e) {
                e.stopPropagation();
            };

            $body.on('focusin', blockFocusIn);
            setTimeout(function () {
                $body.off('focusin', blockFocusIn);
            }, 300);
        });
    }
})(AJS.$, _);
/*[{!global_js_ue575ef!}]*/;
/* END /script/common/global.js */
/* START /2static/script/cru/util.js */
/**
 * Crucible utility functions that can be used from any crucible page.
 */

window.CRU = window.CRU || {};
CRU.UTIL = {};

(function ($) {
    var cruUtil = CRU.UTIL;
    /**
     * Crucible base url (without trailing '/').
     *
     * @param permaId optional review id
     */
    cruUtil.urlBase = function (permaId) {
        if (permaId) {
            return FECRU.pageContext + '/cru/' + permaId;
        } else {
            return FECRU.pageContext + '/cru';
        }
    };

    /**
     * Crucible JSON base url (without trailing '/').
     *
     * @param permaId optional review id
     */
    cruUtil.jsonUrlBase = function (permaId) {
        if (permaId) {
            return FECRU.pageContext + '/json/cru/' + permaId;
        } else {
            return FECRU.pageContext + '/json/cru';
        }
    };

    cruUtil.isReviewPage = function () {
        return typeof review !== 'undefined';
    };


    cruUtil.startAjaxDialogSpin = function () {
        $('body').addClass('ajax-dialog');
        AJS.dim();
    };

    cruUtil.stopAjaxDialogSpin = function () {
        AJS.undim();
        $('body').removeClass('ajax-dialog');
    };

    cruUtil.isAjaxDialogSpinning = function () {
        return cruUtil.isDimmed() && $('body').hasClass('ajax-dialog');
    };

    var _onReviewStateTransitCallbacks = {};
    var triggerCallbacks = function (command, resp) {
        for (var id in _onReviewStateTransitCallbacks) {
            if (_onReviewStateTransitCallbacks.hasOwnProperty(id)) {
                _onReviewStateTransitCallbacks[id](command, resp);
            }
        }
    };
    /**
     * The callback will be called when the state of review transits.
     *
     * @param callbackId : string -- enable more than one callbacks to be bound
     * @param callback : function ( command, resp )
     */
    cruUtil.onReviewStateTransit = function (callbackId, callback) {
        _onReviewStateTransitCallbacks[callbackId] = callback;
    };

    cruUtil.ajaxDialog = function (url, params, isFromStateTransition) {
        cruUtil.startAjaxDialogSpin();
        FECRU.AJAX.ajaxDo(url, params || {}, function (resp) {
            var complete = function () {
                if (isFromStateTransition) {
                    triggerCallbacks(params.command, resp);
                }
            };

            if (resp.worked) {
                if (resp.showDialog) {
                    cruUtil.stopAjaxDialogSpin();
                    try {
                        FECRU.DIALOG.getAjaxDialogContainer().html(resp.payload);
                        FECRU.DIALOG.triggerAjaxDialogLoaded();

                        complete();
                    } catch (e) {
                        alert(e);
                    }
                } else if (resp.redirect) {
                    complete();
                    // no need to undim
                    window.location = resp.payload;
                }
            }
            // !resp.worked handled by ajaxDo
        });
        return false;
    };

    cruUtil.stateTransition = function (transition, permaId, params) {
        var util = cruUtil;
        var url = util.jsonUrlBase(permaId) + '/changeStateAjax';
        var unsaved = CRU.UNSAVED;

        // Make sure there aren't any unsaved inputs on the page, and if there are, then provide a warning
        // and give the user the ability to cancel and save their inputs.
        if (unsaved) {
            if (!unsaved.confirmUnsubmittedInputs()) {
                return;
            }
            unsaved.clearWatchForUnsavedChanges();
        }

        params = params || {};

        $.extend(params, {
            command: transition
        });

        if (util.isReviewPage() && $.inArray(transition, ['action:completeReview', 'action:summarizeReview', 'action:closeReview']) >= 0) {
            // If completing or summarizing we need to warn if the review has been updated.

            util.startAjaxDialogSpin();
            CRU.REVIEW.UTIL.reviewUpdatedAjax({
                done: function () {
                    var reviewUpdated = $('body').hasClass('review-updated');
                    if (reviewUpdated) {
                        CRU.REVIEW.UTIL.warnAboutReviewUpdates({reshowWarning: true});
                    }
                    util.stopAjaxDialogSpin();
                    return util.ajaxDialog(url, $.extend(params, {reviewUpdated: reviewUpdated}), true);
                }
            });
            return false;

        } else {
            return util.ajaxDialog(url, params, true);
        }
    };

    cruUtil.editDetailsFormChange = false;
    cruUtil.checkEditForm = function (done) {
        if (cruUtil.editDetailsFormChange) {
            CRU.REVIEW.UTIL.postEditDetailsForm(done);
        } else {
            if (done) {
                done();
            }
        }
        return false;//do a link action if called from <a>
    };

    cruUtil.command = function (cmd, pid, button) {
        var perma = pid || permaId;
        if (button) {
            button.disabled = true;
        }
        var donext = function () {
            var url = cruUtil.urlBase(perma);
            FECRU.XSRF.postUri(url + '/' + cmd);
        };
        //check and post the editDetailsForm if it has changed
        cruUtil.checkEditForm(donext);
    };


    cruUtil.createBlankReview = function (params) {
        var url = cruUtil.jsonUrlBase() + '/createReviewDialog';
        return cruUtil.ajaxDialog(url, params);
    };

    cruUtil.createSnippet = function (params) {
        var url = cruUtil.jsonUrlBase() + '/createSnippetDialog';
        return cruUtil.ajaxDialog(url, params);
    };

    cruUtil.addToReview = function (params) {
        var url = cruUtil.jsonUrlBase() + '/createDialog';
        return cruUtil.ajaxDialog(url, params);
    };

    cruUtil.isAnyDialogShowing = function () {
        return AJS && AJS.popup && typeof AJS.popup.current !== 'undefined' && AJS.popup.current !== null;
    };

    cruUtil.isAnyOverlayShowing = function () {
        return $('.review-overlay.review-overlay__open').length > 0;
    };

    cruUtil.isDimmed = function () {
        return !!AJS.dim.dim;
    };

    cruUtil.makeCssRule = function (selector, ruleBody) {
        var styleSheet = document.styleSheets[0];
        var index = 0;
        if (styleSheet.insertRule) {
            styleSheet.insertRule(selector + '{' + ruleBody + '}', index);
            return styleSheet.cssRules[index].style;
        } else {
            // Internet Explorer's version.
            styleSheet.addRule(selector, ruleBody, index);
            return styleSheet.rules[index].style;
        }
    };

    cruUtil.createIdeSrc = function (linkUrl, frxId) {
        var src = linkUrl + '&id=' + Math.floor(Math.random() * 1000);
        if (frxId) {
            src += '&line=' + CRU.REVIEW.UTIL.getTopVisibleLineNumber(frxId);
        }
        return src;
    };

    cruUtil.loadJiraIssueLink = function (issueKey, $target, params, done) {
        if (!issueKey) {
            throw "JIRA issue key required";
        }
        if (!$target) {
            throw "Target container to insert issue details into required";
        }

        var isReviewIssue = ($target.attr("data-review-jira-issue") === "true");
        var hideIssueTitle = ($target.attr("data-hide-issue-title") === "true");

        var defaults = {
            shouldGetIssueMetadata: isReviewIssue,
            hideIssueTitle: hideIssueTitle,
            maxTitleLength: 75,
            key: issueKey
        };

        var data = $.extend({}, defaults, params);

        var getIssueDetails = function () {
            AJS.$.ajax({
                url: FECRU.pageContext + '/json/action/issue-inline.do',
                data: data,
                type: "GET",
                dataType: "json",
                cache: false,
                success: function (resp) {
                    if (resp.foundIssue || (resp.credentialsRequired && resp.credentialsRequired.length)) {
                        // only display html if we found an issue (no errors)
                        $target.html(resp.html);
                    }

                    if (!$target.find(".ual-authenticate").length) {
                        $target.attr("data-jira-issue-lazy-load", "false");
                    }

                    $target.find(".ual-authenticate").bind("click", function () {
                        FECRU.OAUTH.getEventProducer($(this).attr("href")).authorized(function () {
                            FECRU.HOVER.invalidateCache(FECRU.HOVER.CACHE_FOREVER, issueKey);
                            CRU.UI.loadInlineJiraIssues();
                        });
                    });

                    if (data.shouldGetIssueMetadata) {
                        if (resp.canLogWork) {
                            AJS.$("#time-spent").addClass("submit-jira-time");
                            AJS.$("#linked-jira-log-work").show();
                        }
                        if (resp.subtasksConfigured && !resp.issueIsSubtask) {
                            AJS.$("body").addClass("jiraSubtasksVisible");
                        } else {
                            AJS.$("body").removeClass("jiraSubtasksVisible");
                        }
                    }

                    done && done($target);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    // dont display jira errors in the UI
                    $target.attr("data-jira-issue-lazy-load", "false");
                }
            });
        };

        getIssueDetails();
    };

    // this is a method to handle legacy "checkbox" style user pickers via autocomplete
    cruUtil.addUserCheckbox = function (id, user) {
        var userid = user.dbId;
        var $elTarget = AJS.$('#' + id + '_rc_' + userid);

        if (!$elTarget.length) {
            // checkbox doesnt exist yet
            $elTarget = AJS.$('<span><input type="checkbox"/><label></label></span>');
            $elTarget.attr('id', id + '_rc_' + userid);
            $elTarget.children('input')
                .attr('name', id)
                .attr('value', user.id);
            $elTarget.children('label')
                .attr('for', id + '_rc_' + userid)
                .text(user.displayPrimary);

            AJS.$('#' + id + '_checkboxes').append($elTarget);
        }
        $elTarget.children('input').attr('checked', 'checked');
        $elTarget.show();
    };

})(AJS.$);
/*[{!util_js_6z0350x!}]*/;
/* END /2static/script/cru/util.js */
/* START /2static/script/fecru/dialog.js */
window.FECRU = window.FECRU || {};
FECRU.DIALOG = {};

(function ($, namespace) {
    var safeDimensions = function (maxWidth, maxHeight, margin) {
        margin = margin || 50;
        return {
            height: Math.min($(window).height() - margin, maxHeight),
            width: Math.min($(window).width() - margin, maxWidth)
        };
    };

    var $container = null;

    function initAjaxContainer() {
        $container = $('<div id="ajax-dialog-container"></div>');
        $(document).ready(function () {
            $('body').append($container);
        });
    }

    function create(maxWidth, maxHeight, id, options) {
        var dimensions = safeDimensions(maxWidth, maxHeight);
        var dimensionsAndId = {
            width: dimensions.width,
            height: dimensions.height,
            id: id
        };

        options = options ?
            $.extend({}, options, dimensionsAndId) :
            dimensionsAndId;
        var dialog = new AJS.Dialog(options);
        // Add the height and width of the dialog as properties of the object
        $.extend(dialog, {width: dimensions.width, height: dimensions.height});
        return dialog;
    }

    function triggerAjaxDialogLoaded() {
        $(document).trigger('ajax-dialog-loaded');
    }

    function ajaxDialog(maxWidth, maxHeight, data, id) {
        var $container = getAjaxDialogContainer();

        var dialog = FECRU.DIALOG.create(maxWidth, maxHeight, id);
        $.each(
            $.extend({dialog: dialog}, data),
            function (k, v) {
                $container.data(k, v);
            }
        );
        return dialog;
    }

    function getAjaxDialogContainer() {
        if (!$container) {
            initAjaxContainer();
        }
        return $container;
    }

    $.extend(namespace, {
        create: create,
        ajaxDialog: ajaxDialog,
        triggerAjaxDialogLoaded: triggerAjaxDialogLoaded,
        getAjaxDialogContainer: getAjaxDialogContainer
    });
})(AJS.$, FECRU.DIALOG);
/*[{!dialog_js_eiaw53n!}]*/;
/* END /2static/script/fecru/dialog.js */
/* START /2static/script/lib/jquery/plugins/jquery.tablesorter-2.0.3.min.js */
(function($){$.extend({tablesorter:new function(){var parsers=[],widgets=[];this.defaults={cssHeader:"header",cssAsc:"headerSortUp",cssDesc:"headerSortDown",sortInitialOrder:"asc",sortMultiSortKey:"shiftKey",sortForce:null,sortAppend:null,textExtraction:"simple",parsers:{},widgets:[],widgetZebra:{css:["even","odd"]},headers:{},widthFixed:false,cancelSelection:true,sortList:[],headerList:[],dateFormat:"us",decimal:'.',debug:false};function benchmark(s,d){log(s+","+(new Date().getTime()-d.getTime())+"ms");}this.benchmark=benchmark;function log(s){if(typeof console!="undefined"&&typeof console.debug!="undefined"){console.log(s);}else{alert(s);}}function buildParserCache(table,$headers){if(table.config.debug){var parsersDebug="";}var rows=table.tBodies[0].rows;if(table.tBodies[0].rows[0]){var list=[],cells=rows[0].cells,l=cells.length;for(var i=0;i<l;i++){var p=false;if($.metadata&&($($headers[i]).metadata()&&$($headers[i]).metadata().sorter)){p=getParserById($($headers[i]).metadata().sorter);}else if((table.config.headers[i]&&table.config.headers[i].sorter)){p=getParserById(table.config.headers[i].sorter);}if(!p){p=detectParserForColumn(table,cells[i]);}if(table.config.debug){parsersDebug+="column:"+i+" parser:"+p.id+"\n";}list.push(p);}}if(table.config.debug){log(parsersDebug);}return list;};function detectParserForColumn(table,node){var l=parsers.length;for(var i=1;i<l;i++){if(parsers[i].is($.trim(getElementText(table.config,node)),table,node)){return parsers[i];}}return parsers[0];}function getParserById(name){var l=parsers.length;for(var i=0;i<l;i++){if(parsers[i].id.toLowerCase()==name.toLowerCase()){return parsers[i];}}return false;}function buildCache(table){if(table.config.debug){var cacheTime=new Date();}var totalRows=(table.tBodies[0]&&table.tBodies[0].rows.length)||0,totalCells=(table.tBodies[0].rows[0]&&table.tBodies[0].rows[0].cells.length)||0,parsers=table.config.parsers,cache={row:[],normalized:[]};for(var i=0;i<totalRows;++i){var c=table.tBodies[0].rows[i],cols=[];cache.row.push($(c));for(var j=0;j<totalCells;++j){cols.push(parsers[j].format(getElementText(table.config,c.cells[j]),table,c.cells[j]));}cols.push(i);cache.normalized.push(cols);cols=null;};if(table.config.debug){benchmark("Building cache for "+totalRows+" rows:",cacheTime);}return cache;};function getElementText(config,node){if(!node)return"";var t="";if(config.textExtraction=="simple"){if(node.childNodes[0]&&node.childNodes[0].hasChildNodes()){t=node.childNodes[0].innerHTML;}else{t=node.innerHTML;}}else{if(typeof(config.textExtraction)=="function"){t=config.textExtraction(node);}else{t=$(node).text();}}return t;}function appendToTable(table,cache){if(table.config.debug){var appendTime=new Date()}var c=cache,r=c.row,n=c.normalized,totalRows=n.length,checkCell=(n[0].length-1),tableBody=$(table.tBodies[0]),rows=[];for(var i=0;i<totalRows;i++){rows.push(r[n[i][checkCell]]);if(!table.config.appender){var o=r[n[i][checkCell]];var l=o.length;for(var j=0;j<l;j++){tableBody[0].appendChild(o[j]);}}}if(table.config.appender){table.config.appender(table,rows);}rows=null;if(table.config.debug){benchmark("Rebuilt table:",appendTime);}applyWidget(table);setTimeout(function(){$(table).trigger("sortEnd");},0);};function buildHeaders(table){if(table.config.debug){var time=new Date();}var meta=($.metadata)?true:false,tableHeadersRows=[];for(var i=0;i<table.tHead.rows.length;i++){tableHeadersRows[i]=0;};$tableHeaders=$("thead th",table);$tableHeaders.each(function(index){this.count=0;this.column=index;this.order=formatSortingOrder(table.config.sortInitialOrder);if(checkHeaderMetadata(this)||checkHeaderOptions(table,index))this.sortDisabled=true;if(!this.sortDisabled){$(this).addClass(table.config.cssHeader);}table.config.headerList[index]=this;});if(table.config.debug){benchmark("Built headers:",time);log($tableHeaders);}return $tableHeaders;};function checkCellColSpan(table,rows,row){var arr=[],r=table.tHead.rows,c=r[row].cells;for(var i=0;i<c.length;i++){var cell=c[i];if(cell.colSpan>1){arr=arr.concat(checkCellColSpan(table,headerArr,row++));}else{if(table.tHead.length==1||(cell.rowSpan>1||!r[row+1])){arr.push(cell);}}}return arr;};function checkHeaderMetadata(cell){if(($.metadata)&&($(cell).metadata().sorter===false)){return true;};return false;}function checkHeaderOptions(table,i){if((table.config.headers[i])&&(table.config.headers[i].sorter===false)){return true;};return false;}function applyWidget(table){var c=table.config.widgets;var l=c.length;for(var i=0;i<l;i++){getWidgetById(c[i]).format(table);}}function getWidgetById(name){var l=widgets.length;for(var i=0;i<l;i++){if(widgets[i].id.toLowerCase()==name.toLowerCase()){return widgets[i];}}};function formatSortingOrder(v){if(typeof(v)!="Number"){i=(v.toLowerCase()=="desc")?1:0;}else{i=(v==(0||1))?v:0;}return i;}function isValueInArray(v,a){var l=a.length;for(var i=0;i<l;i++){if(a[i][0]==v){return true;}}return false;}function setHeadersCss(table,$headers,list,css){$headers.removeClass(css[0]).removeClass(css[1]);var h=[];$headers.each(function(offset){if(!this.sortDisabled){h[this.column]=$(this);}});var l=list.length;for(var i=0;i<l;i++){h[list[i][0]].addClass(css[list[i][1]]);}}function fixColumnWidth(table,$headers){var c=table.config;if(c.widthFixed){var colgroup=$('<colgroup>');$("tr:first td",table.tBodies[0]).each(function(){colgroup.append($('<col>').css('width',$(this).width()));});$(table).prepend(colgroup);};}function updateHeaderSortCount(table,sortList){var c=table.config,l=sortList.length;for(var i=0;i<l;i++){var s=sortList[i],o=c.headerList[s[0]];o.count=s[1];o.count++;}}function multisort(table,sortList,cache){if(table.config.debug){var sortTime=new Date();}var dynamicExp="var sortWrapper = function(a,b) {",l=sortList.length;for(var i=0;i<l;i++){var c=sortList[i][0];var order=sortList[i][1];var s=(getCachedSortType(table.config.parsers,c)=="text")?((order==0)?"sortText":"sortTextDesc"):((order==0)?"sortNumeric":"sortNumericDesc");var e="e"+i;dynamicExp+="var "+e+" = "+s+"(a["+c+"],b["+c+"]); ";dynamicExp+="if("+e+") { return "+e+"; } ";dynamicExp+="else { ";}var orgOrderCol=cache.normalized[0].length-1;dynamicExp+="return a["+orgOrderCol+"]-b["+orgOrderCol+"];";for(var i=0;i<l;i++){dynamicExp+="}; ";}dynamicExp+="return 0; ";dynamicExp+="}; ";eval(dynamicExp);cache.normalized.sort(sortWrapper);if(table.config.debug){benchmark("Sorting on "+sortList.toString()+" and dir "+order+" time:",sortTime);}return cache;};function sortText(a,b){return((a<b)?-1:((a>b)?1:0));};function sortTextDesc(a,b){return((b<a)?-1:((b>a)?1:0));};function sortNumeric(a,b){return a-b;};function sortNumericDesc(a,b){return b-a;};function getCachedSortType(parsers,i){return parsers[i].type;};this.construct=function(settings){return this.each(function(){if(!this.tHead||!this.tBodies)return;var $this,$document,$headers,cache,config,shiftDown=0,sortOrder;this.config={};config=$.extend(this.config,$.tablesorter.defaults,settings);$this=$(this);$headers=buildHeaders(this);this.config.parsers=buildParserCache(this,$headers);cache=buildCache(this);var sortCSS=[config.cssDesc,config.cssAsc];fixColumnWidth(this);$headers.click(function(e){$this.trigger("sortStart");var totalRows=($this[0].tBodies[0]&&$this[0].tBodies[0].rows.length)||0;if(!this.sortDisabled&&totalRows>0){var $cell=$(this);var i=this.column;this.order=this.count++%2;if(!e[config.sortMultiSortKey]){config.sortList=[];if(config.sortForce!=null){var a=config.sortForce;for(var j=0;j<a.length;j++){if(a[j][0]!=i){config.sortList.push(a[j]);}}}config.sortList.push([i,this.order]);}else{if(isValueInArray(i,config.sortList)){for(var j=0;j<config.sortList.length;j++){var s=config.sortList[j],o=config.headerList[s[0]];if(s[0]==i){o.count=s[1];o.count++;s[1]=o.count%2;}}}else{config.sortList.push([i,this.order]);}};setTimeout(function(){setHeadersCss($this[0],$headers,config.sortList,sortCSS);appendToTable($this[0],multisort($this[0],config.sortList,cache));},1);return false;}}).mousedown(function(){if(config.cancelSelection){this.onselectstart=function(){return false};return false;}});$this.bind("update",function(){this.config.parsers=buildParserCache(this,$headers);cache=buildCache(this);}).bind("sorton",function(e,list){$(this).trigger("sortStart");config.sortList=list;var sortList=config.sortList;updateHeaderSortCount(this,sortList);setHeadersCss(this,$headers,sortList,sortCSS);appendToTable(this,multisort(this,sortList,cache));}).bind("appendCache",function(){appendToTable(this,cache);}).bind("applyWidgetId",function(e,id){getWidgetById(id).format(this);}).bind("applyWidgets",function(){applyWidget(this);});if($.metadata&&($(this).metadata()&&$(this).metadata().sortlist)){config.sortList=$(this).metadata().sortlist;}if(config.sortList.length>0){$this.trigger("sorton",[config.sortList]);}applyWidget(this);});};this.addParser=function(parser){var l=parsers.length,a=true;for(var i=0;i<l;i++){if(parsers[i].id.toLowerCase()==parser.id.toLowerCase()){a=false;}}if(a){parsers.push(parser);};};this.addWidget=function(widget){widgets.push(widget);};this.formatFloat=function(s){var i=parseFloat(s);return(isNaN(i))?0:i;};this.formatInt=function(s){var i=parseInt(s);return(isNaN(i))?0:i;};this.isDigit=function(s,config){var DECIMAL='\\'+config.decimal;var exp='/(^[+]?0('+DECIMAL+'0+)?$)|(^([-+]?[1-9][0-9]*)$)|(^([-+]?((0?|[1-9][0-9]*)'+DECIMAL+'(0*[1-9][0-9]*)))$)|(^[-+]?[1-9]+[0-9]*'+DECIMAL+'0+$)/';return RegExp(exp).test($.trim(s));};this.clearTableBody=function(table){if($.browser.msie){function empty(){while(this.firstChild)this.removeChild(this.firstChild);}empty.apply(table.tBodies[0]);}else{table.tBodies[0].innerHTML="";}};}});$.fn.extend({tablesorter:$.tablesorter.construct});var ts=$.tablesorter;ts.addParser({id:"text",is:function(s){return true;},format:function(s){return $.trim(s.toLowerCase());},type:"text"});ts.addParser({id:"digit",is:function(s,table){var c=table.config;return $.tablesorter.isDigit(s,c);},format:function(s){return $.tablesorter.formatFloat(s);},type:"numeric"});ts.addParser({id:"currency",is:function(s){return/^[£$€?.]/.test(s);},format:function(s){return $.tablesorter.formatFloat(s.replace(new RegExp(/[^0-9.]/g),""));},type:"numeric"});ts.addParser({id:"ipAddress",is:function(s){return/^\d{2,3}[\.]\d{2,3}[\.]\d{2,3}[\.]\d{2,3}$/.test(s);},format:function(s){var a=s.split("."),r="",l=a.length;for(var i=0;i<l;i++){var item=a[i];if(item.length==2){r+="0"+item;}else{r+=item;}}return $.tablesorter.formatFloat(r);},type:"numeric"});ts.addParser({id:"url",is:function(s){return/^(https?|ftp|file):\/\/$/.test(s);},format:function(s){return jQuery.trim(s.replace(new RegExp(/(https?|ftp|file):\/\//),''));},type:"text"});ts.addParser({id:"isoDate",is:function(s){return/^\d{4}[\/-]\d{1,2}[\/-]\d{1,2}$/.test(s);},format:function(s){return $.tablesorter.formatFloat((s!="")?new Date(s.replace(new RegExp(/-/g),"/")).getTime():"0");},type:"numeric"});ts.addParser({id:"percent",is:function(s){return/\%$/.test($.trim(s));},format:function(s){return $.tablesorter.formatFloat(s.replace(new RegExp(/%/g),""));},type:"numeric"});ts.addParser({id:"usLongDate",is:function(s){return s.match(new RegExp(/^[A-Za-z]{3,10}\.? [0-9]{1,2}, ([0-9]{4}|'?[0-9]{2}) (([0-2]?[0-9]:[0-5][0-9])|([0-1]?[0-9]:[0-5][0-9]\s(AM|PM)))$/));},format:function(s){return $.tablesorter.formatFloat(new Date(s).getTime());},type:"numeric"});ts.addParser({id:"shortDate",is:function(s){return/\d{1,2}[\/\-]\d{1,2}[\/\-]\d{2,4}/.test(s);},format:function(s,table){var c=table.config;s=s.replace(/\-/g,"/");if(c.dateFormat=="us"){s=s.replace(/(\d{1,2})[\/\-](\d{1,2})[\/\-](\d{4})/,"$3/$1/$2");}else if(c.dateFormat=="uk"){s=s.replace(/(\d{1,2})[\/\-](\d{1,2})[\/\-](\d{4})/,"$3/$2/$1");}else if(c.dateFormat=="dd/mm/yy"||c.dateFormat=="dd-mm-yy"){s=s.replace(/(\d{1,2})[\/\-](\d{1,2})[\/\-](\d{2})/,"$1/$2/$3");}return $.tablesorter.formatFloat(new Date(s).getTime());},type:"numeric"});ts.addParser({id:"time",is:function(s){return/^(([0-2]?[0-9]:[0-5][0-9])|([0-1]?[0-9]:[0-5][0-9]\s(am|pm)))$/.test(s);},format:function(s){return $.tablesorter.formatFloat(new Date("2000/01/01 "+s).getTime());},type:"numeric"});ts.addParser({id:"metadata",is:function(s){return false;},format:function(s,table,cell){var c=table.config,p=(!c.parserMetadataName)?'sortValue':c.parserMetadataName;return $(cell).metadata()[p];},type:"numeric"});ts.addWidget({id:"zebra",format:function(table){if(table.config.debug){var time=new Date();}$("tr:visible",table.tBodies[0]).filter(':even').removeClass(table.config.widgetZebra.css[1]).addClass(table.config.widgetZebra.css[0]).end().filter(':odd').removeClass(table.config.widgetZebra.css[0]).addClass(table.config.widgetZebra.css[1]);if(table.config.debug){$.tablesorter.benchmark("Applying Zebra widget",time);}}});})(jQuery);/*[{!jquery_tablesorter_2_0_3_min_js_mlxw55s!}]*/;
/* END /2static/script/lib/jquery/plugins/jquery.tablesorter-2.0.3.min.js */
/* START /2static/script/lib/jquery/plugins/jquery.metadata-2.0.min.js */
/*
 * Metadata - jQuery plugin for parsing metadata from elements
 *
 * Copyright (c) 2006 John Resig, Yehuda Katz, J�örn Zaefferer, Paul McLanahan
 *
 * Dual licensed under the MIT and GPL licenses:
 *   http://www.opensource.org/licenses/mit-license.php
 *   http://www.gnu.org/licenses/gpl.html
 *
 * Revision: $Id: jquery.metadata.js 3620 2007-10-10 20:55:38Z pmclanahan $
 *
 */
(function($){$.extend({metadata:{defaults:{type:'class',name:'metadata',cre:/({.*})/,single:'metadata'},setType:function(type,name){this.defaults.type=type;this.defaults.name=name;},get:function(elem,opts){var settings=$.extend({},this.defaults,opts);if(!settings.single.length)settings.single='metadata';var data=$.data(elem,settings.single);if(data)return data;data="{}";if(settings.type=="class"){var m=settings.cre.exec(elem.className);if(m)data=m[1];}else if(settings.type=="elem"){if(!elem.getElementsByTagName)return;var e=elem.getElementsByTagName(settings.name);if(e.length)data=$.trim(e[0].innerHTML);}else if(elem.getAttribute!=undefined){var attr=elem.getAttribute(settings.name);if(attr)data=attr;}if(data.indexOf('{')<0)data="{"+data+"}";data=eval("("+data+")");$.data(elem,settings.single,data);return data;}}});$.fn.metadata=function(opts){return $.metadata.get(this[0],opts);};})(jQuery);/*[{!jquery_metadata_2_0_min_js_6crt55n!}]*/;
/* END /2static/script/lib/jquery/plugins/jquery.metadata-2.0.min.js */
/* START /2static/script/lib/jquery/plugins/jquery.scrollTo.js */
/*!
 * jQuery.ScrollTo
 * Copyright (c) 2007-2014 Ariel Flesler - aflesler<a>gmail<d>com | http://flesler.blogspot.com
 * Licensed under MIT
 * http://flesler.blogspot.com/2007/10/jqueryscrollto.html
 * @projectDescription Easy element scrolling using jQuery.
 * @author Ariel Flesler
 * @version 1.4.11
 */

;(function(plugin) {
    // AMD Support
    if (typeof define === 'function' && define.amd) {
        define(['jquery'], plugin);
    } else {
        plugin(jQuery);
    }
}(function($) {

    var $scrollTo = $.scrollTo = function( target, duration, settings ) {
        return $(window).scrollTo( target, duration, settings );
    };

    $scrollTo.defaults = {
        axis:'xy',
        duration: parseFloat($.fn.jquery) >= 1.3 ? 0 : 1,
        limit:true
    };

    // Returns the element that needs to be animated to scroll the window.
    // Kept for backwards compatibility (specially for localScroll & serialScroll)
    $scrollTo.window = function( scope ) {
        return $(window)._scrollable();
    };

    // Hack, hack, hack :)
    // Returns the real elements to scroll (supports window/iframes, documents and regular nodes)
    $.fn._scrollable = function() {
        return this.map(function() {
            var elem = this,
                isWin = !elem.nodeName || $.inArray( elem.nodeName.toLowerCase(), ['iframe','#document','html','body'] ) != -1;

            if (!isWin)
                return elem;

            var doc = (elem.contentWindow || elem).document || elem.ownerDocument || elem;

            return /webkit/i.test(navigator.userAgent) || doc.compatMode == 'BackCompat' ?
                doc.body :
                doc.documentElement;
        });
    };

    $.fn.scrollTo = function( target, duration, settings ) {
        if (typeof duration == 'object') {
            settings = duration;
            duration = 0;
        }
        if (typeof settings == 'function')
            settings = { onAfter:settings };

        if (target == 'max')
            target = 9e9;

        settings = $.extend( {}, $scrollTo.defaults, settings );
        // Speed is still recognized for backwards compatibility
        duration = duration || settings.duration;
        // Make sure the settings are given right
        settings.queue = settings.queue && settings.axis.length > 1;

        if (settings.queue)
        // Let's keep the overall duration
            duration /= 2;
        settings.offset = both( settings.offset );
        settings.over = both( settings.over );

        return this._scrollable().each(function() {
            // Null target yields nothing, just like jQuery does
            if (target == null) return;

            var elem = this,
                $elem = $(elem),
                targ = target, toff, attr = {},
                win = $elem.is('html,body');

            switch (typeof targ) {
                // A number will pass the regex
                case 'number':
                case 'string':
                    if (/^([+-]=?)?\d+(\.\d+)?(px|%)?$/.test(targ)) {
                        targ = both( targ );
                        // We are done
                        break;
                    }
                    // Relative selector, no break!
                    targ = $(targ,this);
                    if (!targ.length) return;
                case 'object':
                    // DOMElement / jQuery
                    if (targ.is || targ.style)
                    // Get the real position of the target
                        toff = (targ = $(targ)).offset();
            }

            var offset = $.isFunction(settings.offset) && settings.offset(elem, targ) || settings.offset;

            $.each( settings.axis.split(''), function( i, axis ) {
                var Pos	= axis == 'x' ? 'Left' : 'Top',
                    pos = Pos.toLowerCase(),
                    key = 'scroll' + Pos,
                    old = elem[key],
                    max = $scrollTo.max(elem, axis);

                if (toff) {// jQuery / DOMElement
                    attr[key] = toff[pos] + ( win ? 0 : old - $elem.offset()[pos] );

                    // If it's a dom element, reduce the margin
                    if (settings.margin) {
                        attr[key] -= parseInt(targ.css('margin'+Pos)) || 0;
                        attr[key] -= parseInt(targ.css('border'+Pos+'Width')) || 0;
                    }

                    attr[key] += offset[pos] || 0;

                    if(settings.over[pos])
                    // Scroll to a fraction of its width/height
                        attr[key] += targ[axis=='x'?'width':'height']() * settings.over[pos];
                } else {
                    var val = targ[pos];
                    // Handle percentage values
                    attr[key] = val.slice && val.slice(-1) == '%' ?
                        parseFloat(val) / 100 * max
                        : val;
                }

                // Number or 'number'
                if (settings.limit && /^\d+$/.test(attr[key]))
                // Check the limits
                    attr[key] = attr[key] <= 0 ? 0 : Math.min( attr[key], max );

                // Queueing axes
                if (!i && settings.queue) {
                    // Don't waste time animating, if there's no need.
                    if (old != attr[key])
                    // Intermediate animation
                        animate( settings.onAfterFirst );
                    // Don't animate this axis again in the next iteration.
                    delete attr[key];
                }
            });

            animate( settings.onAfter );

            function animate( callback ) {
                $elem.animate( attr, duration, settings.easing, callback && function() {
                    callback.call(this, targ, settings);
                });
            };

        }).end();
    };

    // Max scrolling position, works on quirks mode
    // It only fails (not too badly) on IE, quirks mode.
    $scrollTo.max = function( elem, axis ) {
        var Dim = axis == 'x' ? 'Width' : 'Height',
            scroll = 'scroll'+Dim;

        if (!$(elem).is('html,body'))
            return elem[scroll] - $(elem)[Dim.toLowerCase()]();

        var size = 'client' + Dim,
            html = elem.ownerDocument.documentElement,
            body = elem.ownerDocument.body;

        return Math.max( html[scroll], body[scroll] )
            - Math.min( html[size]  , body[size]   );
    };

    function both( val ) {
        return $.isFunction(val) || typeof val == 'object' ? val : { top:val, left:val };
    };

    // AMD requirement
    return $scrollTo;
}));/*[{!jquery_scrollTo_js_ei1655r!}]*/;
/* END /2static/script/lib/jquery/plugins/jquery.scrollTo.js */
