/* CONCAT of
/2static/script/fecru/ui-block.js
/2static/script/fecru/search.js
/2static/script/fecru/gwtutil.js
/2static/script/lib/graphael/g.raphael.js
/2static/script/lib/graphael/g.bar.js
/2static/script/lib/graphael/g.pie.js
/2static/script/lib/graphael/g.line.js
/2static/script/lib/graphael/g.dot.js
/2static/script/fecru/raphaelCharts.js
/2static/script/fe/fisheye-changeset-nav.js
/2static/script/fe/fisheye-ui.js
/2static/script/fe/fisheye-changeset.js
/2static/script/fe/fisheye-history.js
/2static/script/lib/json2.min.js
/2static/script/lib/jquery/plugins/jquery.ba-throttle-debounce.min.js
/2static/script/fe/branch-tag-switcher.js
/2static/script/cru/util.js
/2static/script/cru/dialog/dialog-event.js
/2static/script/cru/review/review-history.js
*/
/* START /2static/script/fecru/ui-block.js */
(function ($, g, undefined) {
    // UIBlock requires the Spinner.js (http://fgnass.github.io/spin.js/)
    // which is included in latest AUI.
    var Spinner = window.Spinner;
    var UIBlock = function ($parent, opts) {
        var t = this;
        t.$parent = $parent;
        t.margin = $.extend({}, marginDefault, opts.margin);
    };

    var marginDefault = {
        left: 0,
        right: 0,
        bottom: 0,
        top: 0
    };

    UIBlock.prototype = {
        init: function (opts) {
            opts = opts || {};
            var t = this;
            var $mask = t.$mask = $('<div class="fecru-page-mask"><div class="spinner-wrap"></div></div>');
            t.$parent.append($mask);
            t.$parent.css('position', 'relative');
            $mask.css(t.margin);

            var spinnerOpts = $.extend({
                lines: 9, // The number of lines to draw
                length: 12, // The length of each line
                width: 6, // The line thickness
                radius: 13, // The radius of the inner circle
                corners: 1, // Corner roundness (0..1)
                rotate: 0, // The rotation offset
                direction: 1, // 1: clockwise, -1: counterclockwise
                color: '#666', // #rgb or #rrggbb
                speed: 1, // Rounds per second
                trail: 60, // Afterglow percentage
                shadow: false, // Whether to render a shadow
                hwaccel: false, // Whether to use hardware acceleration
                className: 'spinner', // The CSS class to assign to the spinner
                zIndex: 2e9, // The z-index (defaults to 2000000000)
                top: 'auto', // Top position relative to parent in px
                left: 'auto' // Left position relative to parent in px
            }, opts.spinner);

            t.spinner = new Spinner(spinnerOpts);
            t.spinner.spin();
            $mask.find('.spinner-wrap').append(t.spinner.el);
        },
        block: function () {
            var t = this;
            var $spinner = t.$mask.find('.spinner');

            clearTimeout(t.spinnerTimer);
            $spinner.stop();

            var height = $(window).height() - t.$parent.find('#quicksearch-pane').offset().top;
            t.$mask.find('.spinner-wrap').height(height);

            $('.activityLoading').css('opacity', 0);

            t.spinnerTimer = setTimeout(function () {
                $spinner.animate({opacity: 1});
            }, 500);
            $spinner.css({opacity: 0.1});
            t.$mask.css({
                'display': 'block',
                'opacity': 0.5
            });
        },
        unblock: function () {
            var t = this;
            var $spinner = t.$mask.find('.spinner');

            clearTimeout(t.spinnerTimer);
            $spinner.stop();
            t.$mask.animate({opacity: 0}, function () {
                t.$mask.css('display', 'none');
            });

            $('.activityLoading').css('opacity', 1);
        }
    };

    g.UIBlock = UIBlock;
})(AJS.$, window);
/*[{!ui_block_js_cyfg54a!}]*/;
/* END /2static/script/fecru/ui-block.js */
/* START /2static/script/fecru/search.js */
/*eslint eqeqeq:0*/

window.FECRU = window.FECRU || {};

FECRU.SEARCH = (function ($, History) {
    var resultCounts = {}; // result counts for the given query for different search types
    var searchParams = {}; // current search params (query, sort, type, repo, project), used to build the queries
    var stats = {}; // the search stats (time, result counts, pagination data)

    var pushingState = true;
    var applyingState = false;

    var allPlaceholder = '$$ALL$$';

    // TypeCounts for the effect for result counts
    var TypeCount = function (opts, list) {
        $.extend(this, opts);
    };

    $.extend(TypeCount, {
        createList: function (types) {
            var list = {};
            _.each(types, function (t) {
                list[t.type] = new TypeCount({
                    type: t.type,
                    $el: t.$el
                });
            });

            return {
                ellipsis: function () {
                    _.each(list, function (c) {
                        c.ellipsis();
                    })
                },
                setCounts: function (counts) {
                    var t = this;
                    _.each(counts, function (count, type) {
                        t.setCount(type, count);
                    })
                },
                setCount: function (type, count) {
                    list[type].setCount(count);
                },
                hide: function () {
                    _.each(list, function (c) {
                        c.hide();
                    })
                }
            }
        }
    });
    TypeCount.prototype = {
        defaultOpts: {}, // may not be used
        ellipsis: function () {
            var t = this;

            t.$el
                .attr('data-count', '.')
                .children('.after')
                .css({display: 'none'});
            t.$el.children('.before')
                .css({display: 'inline', opacity: 1})
        },
        setCount: function (count) {
            var t = this;

            if (t.$el.children('.after').css('display') !== 'none') {
                return;
            }

            var $before = t.$el
                .attr('data-count', count)
                .children('.before');
            $before.animate({opacity: 0}, 250, function () {
                $before.hide();

                t.$el.children('.after')
                    .html(count)
                    .css({opacity: 0, display: 'inline'})
                    .animate({opacity: 1}, 250);
            });
        },
        hide: function () {
            this.$el.removeAttr('data-count');
        }
    };

    function setupUserAutocomplete() {
        var onUserSelected = function ($input, data) {
            changeUser(data.id, data.displayPrimary);
        };

        var opts = {
            result: onUserSelected,
            searchOnFocus: false,
            url: AJS.contextPath() + "/json/fe/activeUserFinder.do?includeQueryAsEmail=true&allowEmpty=true",
            resultsClass: "ac_results aui-box-shadow",
            notFoundData: [
                {
                    displayPrimary: "No matching user or email found",
                    disabled: true,
                    extraClass: "no-results"
                }
            ]
        };
        var $input = $("#user-filter");

        $input.fecruAutocomplete(opts);
        $input.on('change', function (event, ui) {
            if (!$(this).val()) {
                delete FECRU.SEARCH.searchParams.userFilter;
            }
        });
    }

    var init = function () {
        History.Adapter.bind(window, 'statechange', function () {
            if (!FECRU.SEARCH.pushingState) {
                FECRU.SEARCH.applyingState = true;
                var state = History.getState();
                FECRU.SEARCH.searchParams = parseStateUrl(state.url);
                loadInitialResults(true, true);
                FECRU.SEARCH.applyingState = false;
            }
        });

        FECRU.SEARCH.defaultRepo = $('.advanced-search-link').data('default-repository');
        setupUserAutocomplete();
        $("#search-form").submit(function () {
            submit();
            return false;
        });
        $('#user-form').submit(function () {
            submit();
            return false;
        });

        setupPathAbbreviation();

        // ensure that the search box starts with the focus
        $("#search-input").focus();

        $('.search-results')
            .on('click', '.expand-search>a', function (e) { // handle expanding search
                e.preventDefault();
                changeProject('', true);
                changeRepository('', true);
                loadInitialResults(true);
            })
            .find('.quicksearch-type-switch').on('click', function (e) { // handle switching type (either via the buttons on the left or the 'no results' page)
                e.preventDefault();
                e.stopPropagation();
                var searchType = $(this).data('type');
                changeType(searchType);
            });

        $('#quicksearch-pane').on('click', '.redo-ignore-repo-limit', function (e) {
            FECRU.SEARCH.searchParams.ignoreReposLimit = true;
            loadInitialResults(false);
        });

        $('.quicksearch-sortorder-switch').click(function (e) { // handle switching sort
            e.preventDefault();
            var sortOrder = parseInt($(this).data('sort'));
            changeSort(sortOrder);
        });

        $('.quicksearch-timebucket-switch').click(function (e) {
            e.preventDefault();
            if (!$('.search-sidebar-timebuckets').hasClass('disabled')) {
                var timeBucket = $(this).data('time-bucket');
                changeTimeBucket(timeBucket);
            }
        });
    };

    var submit = function () {
        FECRU.SEARCH.searchParams.q = $('#search-input').val();
        return loadInitialResults(true);
    };

    // handles the user filter being changed, if donReload is true just refreshes the UI, without fethching new results
    var changeUser = function (user, displayName, dontReload) {
        if (!user) {
            displayName = '';
        }

        if (displayName != null) {
            $('#user-filter').val(displayName);
        }

        FECRU.SEARCH.searchParams.userFilter = user;
        if (!dontReload) {
            loadInitialResults(true);
        }
    };

    // handles the search type being changed - if dontReload is true just handle the ux part, without fetching new results
    var changeType = function (type, dontReload) {
        $('.search-sidebar-types .aui-nav-selected').removeClass('aui-nav-selected');
        $('.search-sidebar-list>li.type-' + type).addClass('aui-nav-selected');

        // hacky - hide date sort and filters for commiter search (SearchType.COMMITTERS)
        var $dateSort = $('.quicksearch-sortorder-switch[data-sort="0"]');
        var $lastModifiedFilter = $('.search-sidebar-timebuckets');
        var $userFilter = $('.search-sidebar-user');
        var $userAutocomplete = $('#user-filter');

        var $userTooltip = $('.search-sidebar-user-tooltip')
        if (type == 0 || type == 2 || type == 3 || type == 4) {
            $userFilter.addClass('disabled');
            $userAutocomplete.attr('disabled', 'disabled');
            $userTooltip.attr('title', 'The user filter is not available for the selected search type');
        } else {
            $userFilter.removeClass('disabled');
            $userAutocomplete.removeAttr('disabled');
            $userTooltip.removeAttr('title');
        }

        var $timebucketTooltip = $('.search-sidebar-timebuckets-tooltip');
        if (type == 4) {
            $dateSort.hide();
            $lastModifiedFilter.addClass('disabled');
            $timebucketTooltip.attr('title', 'The last modified filter is not available for the selected search type');
        } else {
            $dateSort.show();
            $lastModifiedFilter.removeClass('disabled');
            $timebucketTooltip.removeAttr('title');
        }

        FECRU.SEARCH.searchParams.t = type;
        if (!dontReload) {
            loadInitialResults(false);
        }
    };

    // replaces the current results with the ones for the given search type - if dontReload is true just handle the ux part, without fetching new results
    var changeSort = function (sortOrder, dontReload) {
        $('.qsearch-sort-order .aui-nav-selected').removeClass('aui-nav-selected');
        $('#sort-order-' + sortOrder).parent().addClass('aui-nav-selected');
        FECRU.SEARCH.searchParams.s = sortOrder;
        if (!dontReload) {
            loadInitialResults(false);
        }
    };

    var changeTimeBucket = function (timeBucket, dontReload) {
        $('.search-sidebar-timebuckets .aui-nav-selected').removeClass('aui-nav-selected');
        $('#time-bucket-' + timeBucket).parent().addClass('aui-nav-selected');
        FECRU.SEARCH.searchParams.bucket = timeBucket;
        if (!dontReload) {
            loadInitialResults(true);
        }
    };

    // cleans up the input from the autocomplete dropdowns
    var unifyAutoCompleteInput = function (input) {
        if (input && input.disabled) {
            return null;
        }

        if (input && input.id) {
            return input.id == allPlaceholder ? '' : input.id;
        }

        return input ? input : '';
    };

    // handles the repository being changed
    var changeRepository = function (repository, dontReload) {
        repository = unifyAutoCompleteInput(repository);
        if (repository === null) {
            return;
        }

        $('#repository-input').val(repository);
        FECRU.SEARCH.searchParams.repository = repository;

        var $advancedSearchLink = $('.advanced-search-link');
        if (repository || FECRU.SEARCH.defaultRepo) {
            $advancedSearchLink.attr('href', AJS.contextPath() + '/search/' + encodeURIComponent(repository ? repository : FECRU.SEARCH.defaultRepo));
            $advancedSearchLink.show();
        } else {
            $advancedSearchLink.hide();
        }

        var $currentRepoHeader = $('.source-dropdown-current');
        if (repository) {
            // hacky - updates the masthead
            $currentRepoHeader.find('input[name="currentRepositoryName"]').attr('value', repository);
            var $currentRepoLink = $currentRepoHeader.find('a');
            $currentRepoLink.attr('href', AJS.contextPath() + '/changelog/' + encodeURIComponent(repository));
            $currentRepoLink.attr('title', repository);
            $currentRepoLink.text(repository);

            $currentRepoHeader.show();
        } else {
            $currentRepoHeader.hide();
        }

        if (!dontReload) {
            delete FECRU.SEARCH.searchParams.project;
            $('#project-input').val('');
            loadInitialResults(true);
        }
    };

    // handles the project being changed
    var changeProject = function (project, dontReload) {
        project = unifyAutoCompleteInput(project);
        if (project === null) {
            return;
        }

        $('#project-input').val(project);
        FECRU.SEARCH.searchParams.project = project;

        if (!dontReload) {
            delete FECRU.SEARCH.searchParams.repository;
            $('#repository-input').val('');
            loadInitialResults(true);
        }
    };

    // abbreviates the shown paths, either on the whole page, or in $context
    var triggerPathAbbreviation = function (hint, $context) {
        if (FECRU.SEARCH.searchParams.t !== 0) {
            return;
        }

        var $paths = $(".file-path", $context ? $context : $("#search-results"));
        var $repoNames = $paths.parent().siblings('.repo-name');
        var maxRepoNameWidth = 0;

        $repoNames.each(function () {
            maxRepoNameWidth = Math.max(maxRepoNameWidth, $(this).width());
        });

        $paths.abbreviatePath({
            boundingWidthGetter: function ($this) {
                return $this.closest('li').width() - maxRepoNameWidth;
            },
            growingElementGetter: function ($this) {
                return $this.parent() /*span.abbreviate-path-grower*/;
            },
            directionHint: hint,
            resetBoundsWidth: true
        });
    };

    // adds a resize handler to perform path abbreviation if needed
    var setupPathAbbreviation = function () {
        //on resize
        var $window = $(window);
        var windowWidth = $window.width();

        FECRU.UI.setCompletedResizeTimeout($window, function () {
            var newWindowWidth = $window.width();
            var shouldRun = windowWidth !== newWindowWidth;
            var hint = windowWidth < newWindowWidth ? 'larger' : 'smaller';

            windowWidth = newWindowWidth;
            if (shouldRun) {
                triggerPathAbbreviation(hint);
            }
        }, 150);
    };

    // called after initial page load/refresh
    var lazyLoad = function (initialState) {
        FECRU.SEARCH.searchParams = parseStateUrl(History.getState().url); // get the proper params
        if (initialState && _.isEmpty(FECRU.SEARCH.searchParams)) {
            FECRU.SEARCH.searchParams = initialState;
        }
        loadInitialResults(true, true);
    };

    // saves the current url in history, so we can navigate to it
    var pushState = function (queryUrl, replace) {
        if (!FECRU.SEARCH.applyingState) {
            FECRU.SEARCH.pushingState = true;
            if (replace) {
                History.replaceState(null, null, queryUrl);
            } else {
                History.pushState(null, null, queryUrl);
            }
            FECRU.SEARCH.pushingState = false;
        }
    };


    /**
     * create the count list for setting counts for categories and a small animation when changing those
     * number.
     */
    var typeCounts;

    /**
     * Fetches the first page of the results, sets up subsequent searches and counts.
     * The first page should handle some additional metadata - search time, updating the ui if the server changed the query
     * @param queryChanged true if anything that'd affect the results has changed (query, repo, project)
     * @param initialLoad whether this is the first ever load
     * @return Sequence number of submitted request or false if request was not submitted
     */
    var requestSeq = 0;
    var loadInitialResults = function (queryChanged, initialLoad) {
        if (FECRU.SEARCH.forceQueryChanged) {
            delete FECRU.SEARCH.forceQueryChanged;
            queryChanged = true;
        }

        if (queryChanged) {
            delete FECRU.SEARCH.searchParams.ignoreReposLimit; // don't persist it across searches
        }

        var queryUrl = buildQueryUrl(FECRU.SEARCH.searchParams);

        pushState(queryUrl, initialLoad);

        if (initialLoad) {
            var types = $('.typecount').map(function () {
                var $t = $(this);
                return {
                    type: $t.data('type'),
                    $el: $t
                };
            });
            typeCounts = TypeCount.createList(types);
        }
        updatePageBeforeSearch(queryUrl, queryChanged);

        var seq = false;
        if (FECRU.SEARCH.searchParams.q !== undefined) {
            seq = ++requestSeq;
            // get the search results
            fetchResults(seq, queryUrl + '&resultsOnly=true', function (data) {
                if (seq != requestSeq) {
                    return;
                }

                FECRU.SEARCH.stats = data.stats;
                FECRU.SEARCH.searchParams.q = data.stats.query;

                updatePageAfterSearch(data, queryChanged);

                searchBlock.unblock();
                if (data.stats.numPages == data.stats.page) {
                    $('.activityLoading').hide();
                } else {
                    var loadMoreWhenScreenNotFull = function () {
                        if ($('.activityLoading').is(':in-viewport-vert(0)')) {
                            loadMoreResults(loadMoreWhenScreenNotFull);
                        }
                    };

                    loadMoreWhenScreenNotFull();
                }
            });

            if (queryChanged) {
                loadCounts(seq);
            }
        } else {
            FECRU.SEARCH.searchParams.q = '';
            FECRU.SEARCH.forceQueryChanged = true;
        }

        FECRU.SEARCH.loading = false;
        if (initialLoad) {
            FECRU.ACTIVITY.onScrollToBottom(function () {
                loadMoreResults();
            });
        }

        return seq;
    };

    var showSearchErrorMessages = function (messagesHtml) {
        $('.quicksearch-results').html('');
        $('.query-error-message').show();
        var $defaultMsg = $('.default-qsearch-error-message');
        var $serverMsg = $('.server-qsearch-error-messages');

        if (messagesHtml) {
            $defaultMsg.hide(0);
            $serverMsg.html(messagesHtml);
            $serverMsg.show(0);
        } else {
            $defaultMsg.show(0);
            $serverMsg.html('');
            $serverMsg.hide(0);
        }

        searchBlock.unblock();
        $('.activityLoading').hide();
    };

    // fetches the search results for the given url
    var fetchResults = function (seq, url, done) {
        $.getJSON(url + '&resultsOnly=true', {_nocache: new Date().getTime()}, function (result) {
            if (!result.worked) {
                showSearchErrorMessages(result.html);
            } else {
                done && done(result);
            }
            setResultsSeq(seq);
        }).fail(function (req, textStatus, errorThrown) {
            if (req.statusText !== 'abort') {
                showSearchErrorMessages();
                AJS.log('Error fetching results ' + textStatus + ' - ' + errorThrown);
            }
            setResultsSeq(seq);
        });
    };

    var setResultsSeq = function (seq) {
        if (seq == requestSeq) {
            $('#search-results').attr("seq", seq);
        }
    };

    var getResultsSeq = function () {
        return $('#search-results').attr("seq");
    };

    var updateInputs = function (query, sortOrdinal, typeOrdinal, timeBucket, user, userFilterDisplayName, repository) {
        $('#search-input').val(query);
        changeType(typeOrdinal, true);
        changeSort(sortOrdinal, true);
        changeTimeBucket(timeBucket, true);
        changeRepository(repository, true);
        changeUser(user, userFilterDisplayName, true);
    };

    // sets up the page ui after performing a search (based on results, stats) (see quicksearchresults.jsp)
    var updatePageAfterSearch = function updatePageAfterSearch(data, queryChanged) {
        updateInputs(data.stats.query, data.stats.sortOrdinal, data.stats.typeOrdinal, data.stats.timeBucket,
            data.stats.userFilter, data.stats.userFilterDisplayName, data.stats.repository);

        // results
        var $resultslist = $('.quicksearch-results');
        $resultslist.html(data.html);
        triggerPathAbbreviation(null, $resultslist);

        // counts
        typeCounts.setCount(data.stats.type, data.stats.count);

        if (data.stats.count > 0) {
            FECRU.SEARCH.resultCounts[data.stats.type] = data.stats.count;
        }

        $('#search-summary-text').html(
            AJS.template('<span id="total-count">{totalCount}</span> results for <strong>{query}</strong> <em>({time}s)</em>')
                .fill({
                    totalCount: FECRU.formatInt(getTotalResultCount()),
                    query: data.stats.query,
                    time: data.stats.time
                })
        );

        updateNoResultsMessage();

        // star
        if (data.stats.starrable) {
            var $star = $('.qs_star');
            if (queryChanged) {
                var $starLink = $('.qs_star>a');
                data.stats.starId ? $starLink.addClass('star-on').removeClass('star-off') : $starLink.removeClass('star-on').addClass('star-off');
                $star.find('input[name="stringKey1"]').attr('value', FECRU.SEARCH.searchParams.repository ? FECRU.SEARCH.searchParams.repository : '__ALL_REPOS__');
                $star.find('input[name="stringKey2"]').attr('value', FECRU.SEARCH.searchParams.q);
                $star.find('input[name="id"]').remove();
                if (data.stats.starId) {
                    $star.find('.inputs').append('<input class="starKey" type="hidden" name="id" value="' + data.stats.starId + '">')
                }
            }

            $star.show();
        }

        // repo limit
        if (data.stats.limitedRepos) {
            var $limitedRepos = $('.limited-repos-message');
            $limitedRepos.html(
                AJS.template.load('limited-repos-message').fill({limitedRepos: data.stats.limitedRepos})
            );
            $limitedRepos.show();
        }
    };

    var getTotalResultCount = function () {
        var totalCount = 0;
        for (var type in FECRU.SEARCH.resultCounts) {
            if (FECRU.SEARCH.resultCounts.hasOwnProperty(type)) {
                totalCount += FECRU.SEARCH.resultCounts[type];
            }
        }
        return totalCount;
    };

    // sets up the page ui before performing a search (based on searchParams)
    var updatePageBeforeSearch = function (queryUrl, queryChanged) {
        updateInputs(FECRU.SEARCH.searchParams.q, FECRU.SEARCH.searchParams.s, FECRU.SEARCH.searchParams.t, FECRU.SEARCH.searchParams.bucket,
            FECRU.SEARCH.searchParams.userFilter, null, FECRU.SEARCH.searchParams.repository);

        $('.qs_star').hide();
        $('.query-error-message').hide();
        var $permalink = $('a.permalink');
        var $doc = $(document);
        if (FECRU.SEARCH.searchParams.q === undefined) {
            $doc.attr('title', 'Search');
            searchBlock.unblock();
            $('.activityLoading').hide();
            $('.count').parent().hide();
            $('.empty-query-message').show();

            $('.quicksearch-results').empty();
            $permalink.hide();
            $('#search-summary-text').html('');
        } else {
            $doc.attr('title', 'Search' + (FECRU.SEARCH.searchParams.q ? ' - "' + FECRU.SEARCH.searchParams.q + '"' : ''));
            searchBlock.block();
            $('.activityLoading').show();
            $('.empty-query-message').hide();
            $permalink.attr('href', queryUrl);
            $permalink.show();
        }

        // update the links
        $('.quicksearch-type-switch').each(function () {
            $(this).attr('href', buildQueryUrl($.extend({}, FECRU.SEARCH.searchParams, {t: $(this).data('type')})));
        });
        $('.quicksearch-sortorder-switch').each(function () {
            $(this).attr('href', buildQueryUrl($.extend({}, FECRU.SEARCH.searchParams, {s: $(this).data('sort')})));
        });
        $('.quicksearch-timebucket-switch').each(function () {
            $(this).attr('href', buildQueryUrl($.extend({}, FECRU.SEARCH.searchParams, {bucket: $(this).data('time-bucket')})));
        });

        $('.limited-repos-message').hide();

        // reset counts if needed
        if (queryChanged && FECRU.SEARCH.searchParams.q !== undefined) {
            FECRU.SEARCH.resultCounts = {};
            typeCounts.ellipsis();
        } else if (FECRU.SEARCH.searchParams.q === undefined) {
            FECRU.SEARCH.resultCounts = {};
            typeCounts.hide();
        }

        FECRU.SEARCH.stats = {};
    };

    // build a searchParams object from a string url
    var parseStateUrl = function (url) {
        var context = AJS.contextPath() + '/qsearch';
        var contextIndex = url.indexOf(context);
        if (contextIndex >= 0) {
            var afterContext = url.substring(contextIndex).substring(context.length);
            if (afterContext) {
                var queryIndex = afterContext.indexOf('?');
                if (queryIndex >= 0) {
                    var path = afterContext.substring(0, queryIndex);
                    var repository = path.split('/').join('');
                    var query = afterContext.substring(queryIndex + 1);
                } else {
                    var repository = afterContext.split('/').join('');
                }
            }
        }

        var queryParams = {};
        if (query) {
            query = query.split('+').join('%20'); // $.deserialize doesn't handle spaces encoded as '+', instead of '%20', which is what the quicknav form does
            queryParams = $.deserialize(query)
        }
        return $.extend(queryParams, repository ? {repository: repository} : {});
    };

    // build a query url from the current searchParams object
    var buildQueryUrl = function (searchParams) {
        var url = AJS.contextPath() + '/qsearch';
        var queryParams = $.extend({}, searchParams);

        if (searchParams.repository) {
            url += '/' + encodeURIComponent(searchParams.repository);
        }
        delete queryParams['repository']; // repository is handle above as a part of the path
        delete queryParams['r']; // QuickSearch.enableRedirection - should only be enabled for the initial request from quicknav

        var query = $.param(queryParams);

        return query ? url + '?' + query : url;
    };

    // loads a next page of results
    var loadMoreResults = function (done) {
        if (!$.isEmptyObject(FECRU.SEARCH.stats) && !FECRU.SEARCH.loading && !$('.query-error-message').is(':visible')) {
            FECRU.SEARCH.loading = true;
            var currentPage = parseInt(FECRU.SEARCH.stats.page);
            var numPages = parseInt(FECRU.SEARCH.stats.numPages);
            if (currentPage < numPages) {
                fetchResults(requestSeq, buildQueryUrl(FECRU.SEARCH.searchParams) + '&page=' + (currentPage + 1), function (data) {
                    var $additionalResults = $(data.html).find('.quicksearch-result-list > li');
                    $('.quicksearch-result-list').append($additionalResults);
                    triggerPathAbbreviation(null, $additionalResults);
                    FECRU.SEARCH.stats = data.stats;
                    FECRU.SEARCH.resultCounts[data.stats.type] = data.stats.count;

                    FECRU.SEARCH.loading = false;
                    done && done();
                });
            } else {
                $('.activityLoading').hide();
                FECRU.SEARCH.loading = false;
            }
        }
    };

    // fire-off AJAX to get counts
    var loadCounts = function loadCounts(seq) {
        $.getJSON(buildQueryUrl(FECRU.SEARCH.searchParams) + '&countsOnly=true',
            {_nocache: new Date().getTime()}, function (data) {
                if (seq != requestSeq) {
                    return;
                }

                // the counts json is usually just an object with counts, and doesn't have the worked property if no error occured
                if (data.hasOwnProperty('worked') && !data.worked) {
                    AJS.log('Error getting result counts');
                    return;
                }

                for (var type in data) {
                    if (data.hasOwnProperty(type)) {

                        var count = data[type];

                        // update the side counters
                        typeCounts.setCount(type, count);

                        // if we have some search results for the current category
                        if (count > 0) {
                            FECRU.SEARCH.resultCounts[type] = count;
                        }
                    }
                }

                updateNoResultsMessage();

                // update the total count of the results
                $("#total-count").text(FECRU.formatInt(getTotalResultCount())).fadeIn(250);
            }).fail(function (req, textStatus, errorThrown) {
                AJS.log('Error fetching counts ' + textStatus + ' - ' + errorThrown);
            });
    };

    var updateNoResultsMessage = function () {
        // update the counters in the message shown when the current category has no results:
        // "No results here but n results available there"
        if (!$.isEmptyObject(FECRU.SEARCH.resultCounts)) {
            for (var type in FECRU.SEARCH.resultCounts) {
                if (FECRU.SEARCH.resultCounts.hasOwnProperty(type)) {
                    $("#typecount-" + type).show().children("em").text(FECRU.formatInt(FECRU.SEARCH.resultCounts[type]));
                }
            }
            $("#typecounts").fadeIn(250);
        }
    };

    var searchBlock;
    $(function () {
        searchBlock = new UIBlock($('#column-content .content-container'), {
            margin: {
                top: '40px'
            }
        });

        searchBlock.init();
    });


    return {
        changeRepository: changeRepository,
        changeProject: changeProject,
        submit: submit,
        init: init,
        lazyLoad: lazyLoad,
        resultCounts: resultCounts,
        searchParams: searchParams,
        stats: stats,
        pushingState: pushingState,
        applyingState: applyingState,
        parseStateUrl: parseStateUrl,
        buildQueryUrl: buildQueryUrl,
        getResultsSeq: getResultsSeq
    };
})(AJS.$, History);
/*[{!search_js_r15d545!}]*/;
/* END /2static/script/fecru/search.js */
/* START /2static/script/fecru/gwtutil.js */
window.FECRU = window.FECRU || {};

FECRU.GWT = {
    /**
     * Scroll to the element identified by selector
     * in the current window.
     * @param selector selector to get the element
     */
    scrollToId: function (selector) {
        AJS.$(window).scrollTo(AJS.$(selector));
    },
    /**
     * Scroll to the element identified by selector, scrolling
     * the element selected by container.
     *
     * @param selector selector to get the element
     * @param container scrollable container
     */
    scrollToIdInContainer: function (selector, container) {
        AJS.$(container).scrollTo(AJS.$(selector));
    }
};
/*[{!gwtutil_js_2brn53q!}]*/;
/* END /2static/script/fecru/gwtutil.js */
/* START /2static/script/lib/graphael/g.raphael.js */
/*
 * g.Raphael 0.2 - Charting library, based on Raphaël
 *
 * Copyright (c) 2009 Dmitry Baranovskiy (http://g.raphaeljs.com)
 * Licensed under the MIT (http://www.opensource.org/licenses/mit-license.php) license.
 */


(function () {
    Raphael.fn.g = Raphael.fn.g || {};
    Raphael.fn.g.markers = {
        disc: "disc",
        o: "disc",
        square: "square",
        s: "square",
        triangle: "triangle",
        t: "triangle",
        star: "star",
        "*": "star",
        cross: "cross",
        x: "cross",
        plus: "plus",
        "+": "plus",
        arrow: "arrow",
        "->": "arrow"
    };
    Raphael.fn.g.txtattr = {font: "12px Arial, sans-serif"};
    Raphael.fn.g.colors = [];
    var hues = [.6, .2, .05, .1333, .75, 0];
    for (var i = 0; i < 10; i++) {
        if (i < hues.length) {
            Raphael.fn.g.colors.push("hsb(" + hues[i] + ", .75, .75)");
        } else {
            Raphael.fn.g.colors.push("hsb(" + hues[i - hues.length] + ", 1, .5)");
        }
    }
    Raphael.fn.g.text = function (x, y, text) {
        return this.text(x, y, text).attr(this.g.txtattr);
    };
    Raphael.fn.g.labelise = function (label, val, total) {
        if (label) {
            return (label + "").replace(/(##+(?:\.#+)?)|(%%+(?:\.%+)?)/g, function (all, value, percent) {
                if (value) {
                    return (+val).toFixed(value.replace(/^#+\.?/g, "").length);
                }
                if (percent) {
                    return (val * 100 / total).toFixed(percent.replace(/^%+\.?/g, "").length) + "%";
                }
            });
        } else {
            return (+val).toFixed(0);
        }
    };

    Raphael.fn.g.finger = function (x, y, width, height, dir, ending, isPath) {
        // dir 0 for horisontal and 1 for vertical
        if ((dir && !height) || (!dir && !width)) {
            return isPath ? "" : this.path({});
        }
        ending = {square: "square", sharp: "sharp", soft: "soft"}[ending] || "round";
        var path;
        height = Math.round(height);
        width = Math.round(width);
        x = Math.round(x);
        y = Math.round(y);
        switch (ending) {
            case "round":
                if (!dir) {
                    var r = Math.floor(height / 2);
                    if (width < r) {
                        r = width;
                        path = ["M", x + .5, y + .5 - Math.floor(height / 2), "l", 0, 0, "a", r, Math.floor(height / 2), 0, 0, 1, 0, height, "l", 0, 0, "z"];
                    } else {
                        path = ["M", x + .5, y + .5 - r, "l", width - r, 0, "a", r, r, 0, 1, 1, 0, height, "l", r - width, 0, "z"];
                    }
                } else {
                    var r = Math.floor(width / 2);
                    if (height < r) {
                        r = height;
                        path = ["M", x - Math.floor(width / 2), y, "l", 0, 0, "a", Math.floor(width / 2), r, 0, 0, 1, width, 0, "l", 0, 0, "z"];
                    } else {
                        path = ["M", x - r, y, "l", 0, r - height, "a", r, r, 0, 1, 1, width, 0, "l", 0, height - r, "z"];
                    }
                }
                break;
            case "sharp":
                if (!dir) {
                    var half = Math.floor(height / 2);
                    path = ["M", x + .5, y + .5 + half, "l", 0, -height, Math.max(width - half, 0), 0, Math.min(half, width), half, -Math.min(half, width), half + (half * 2 < height), "z"];
                } else {
                    var half = Math.floor(width / 2);
                    path = ["M", x + half, y, "l", -width, 0, 0, -Math.max(height - half, 0), half, -Math.min(half, height), half + (half * 2 < height), Math.min(half, height), half, "z"];
                }
                break;
            case "square":
                if (!dir) {
                    path = ["M", x + .5, y + .5 + Math.floor(height / 2), "l", 0, -height, width, 0, 0, height, "z"];
                } else {
                    path = ["M", x + Math.floor(width / 2), y, "l", -width, 0, 0, -height, width, 0, "z"];
                }
                break;
            case "soft":
                var r;
                if (!dir) {
                    r = Math.min(width, Math.round(height / 5));
                    path = ["M", x + .5, y + .5 - Math.floor(height / 2), "l", width - r, 0, "a", r, r, 0, 0, 1, r, r, "l", 0, height - r * 2, "a", r, r, 0, 0, 1, -r, r, "l", r - width, 0, "z"];
                } else {
                    r = Math.min(Math.round(width / 5), height);
                    path = ["M", x - Math.floor(width / 2), y, "l", 0, r - height, "a", r, r, 0, 0, 1, r, -r, "l", width - 2 * r, 0, "a", r, r, 0, 0, 1, r, r, "l", 0, height - r, "z"];
                }
        }
        if (isPath) {
            return path.join(",");
        } else {
            return this.path({}, path);
        }
    };

    // Symbols
    Raphael.fn.g.disc = function (cx, cy, r) {
        return this.circle(cx, cy, r);
    };
    Raphael.fn.g.line = function (cx, cy, r) {
        return this.rect(cx - r, cy - r / 5, 2 * r, 2 * r / 5);
    };
    Raphael.fn.g.square = function (cx, cy, r) {
        r = r * .7;
        return this.rect(cx - r, cy - r, 2 * r, 2 * r);
    };
    Raphael.fn.g.triangle = function (cx, cy, r) {
        r *= 1.75;
        return this.path({}, "M".concat(cx, ",", cy, "m0-", r * .58, "l", r * .5, ",", r * .87, "-", r, ",0z"));
    };
    Raphael.fn.g.star = function (cx, cy, r, r2) {
        r2 = r2 || r * .5;
        var points = ["M", cx, cy + r2, "L"],
                R;
        for (var i = 1; i < 10; i++) {
            R = i % 2 ? r : r2;
            points = points.concat([(cx + R * Math.sin(i * Math.PI * .2)).toFixed(3), (cy + R * Math.cos(i * Math.PI * .2)).toFixed(3)]);
        }
        points.push("z");
        return this.path({}, points);
    };
    Raphael.fn.g.cross = function (cx, cy, r) {
        r = r / 2.5;
        return this.path({}, "M".concat(cx - r, ",", cy, "l", [-r, -r, r, -r, r, r, r, -r, r, r, -r, r, r, r, -r, r, -r, -r, -r, r, -r, -r, "z"]));
    };
    Raphael.fn.g.plus = function (cx, cy, r) {
        r = r / 2;
        return this.path({}, "M".concat(cx - r / 2, ",", cy - r / 2, "l", [0, -r, r, 0, 0, r, r, 0, 0, r, -r, 0, 0, r, -r, 0, 0, -r, -r, 0, 0, -r, "z"]));
    };
    Raphael.fn.g.arrow = function (cx, cy, r) {
        return this.path({}, "M".concat(cx - r * .7, ",", cy - r * .4, "l", [r * .6, 0, 0, -r * .4, r, r * .8, -r, r * .8, 0, -r * .4, -r * .6, 0], "z"));
    };

    // Tooltips
    Raphael.fn.g.tag = function (x, y, text, angle, r) {
        angle = angle || 0;
        r = r == null ? 5 : r;
        text = text == null ? "$9.99" : text;
        var R = .5522 * r,
                res = this.set(),
                d = 3;
        res.push(this.path({fill: "#000", stroke: "none"}));
        res.push(this.text(x, y, text).attr(this.g.txtattr).attr({fill: "#fff"}));
        res.update = function () {
            this.rotate(0, x, y);
            var bb = this[1].getBBox();
            if (bb.height >= r * 2) {
                this[0].attr({path: ["M", x, y + r, "a", r, r, 0, 1, 1, 0, -r * 2, r, r, 0, 1, 1, 0, r * 2, "m", 0, -r * 2 - d, "a", r + d, r + d, 0, 1, 0, 0, (r + d) * 2, "L", x + r + d, y + bb.height / 2 + d, "l", bb.width + 2 * d, 0, 0, -bb.height - 2 * d, -bb.width - 2 * d, 0, "L", x, y - r - d].join(",")});
            } else {
                var dx = Math.sqrt(Math.pow(r + d, 2) - Math.pow(bb.height / 2 + d, 2));
                // ["c", -R, 0, -r, R - r, -r, -r, 0, -R, r - R, -r, r, -r, R, 0, r, r - R, r, r, 0, R, R - r, r, -r, r]
                // "a", r, r, 0, 1, 1, 0, -r * 2, r, r, 0, 1, 1, 0, r * 2,
                this[0].attr({path: ["M", x, y + r, "c", -R, 0, -r, R - r, -r, -r, 0, -R, r - R, -r, r, -r, R, 0, r, r - R, r, r, 0, R, R - r, r, -r, r, "M", x + dx, y - bb.height / 2 - d, "a", r + d, r + d, 0, 1, 0, 0, bb.height + 2 * d, "l", r + d - dx + bb.width + 2 * d, 0, 0, -bb.height - 2 * d, "L", x + dx, y - bb.height / 2 - d].join(",")});
            }
            this[1].attr({x: x + r + d + bb.width / 2, y: y});
            angle = (360 - angle) % 360;
            this.rotate(angle, x, y);
            angle > 90 && angle < 270 && this[1].attr({x: x - r - d - bb.width / 2, y: y, rotation: [180 + angle, x, y]});
            return this;
        };
        res.update();
        return res;
    };
    Raphael.fn.g.popupit = function (x, y, set, dir, size) {
        dir = dir == null ? 2 : dir;
        size = size || 5;
        x = Math.round(x) + .5;
        y = Math.round(y) + .5;
        var bb = set.getBBox(),
                w = Math.round(bb.width / 2),
                h = Math.round(bb.height / 2),
                dx = [0, w + size * 2, 0, -w - size * 2],
                dy = [-h * 2 - size * 3, -h - size, 0, -h - size],
                p = ["M", x - dx[dir], y - dy[dir], "l", -size, (dir == 2) * -size, -Math.max(w - size, 0), 0, "a", size, size, 0, 0, 1, -size, -size,
                    "l", 0, -Math.max(h - size, 0), (dir == 3) * -size, -size, (dir == 3) * size, -size, 0, -Math.max(h - size, 0), "a", size, size, 0, 0, 1, size, -size,
                    "l", Math.max(w - size, 0), 0, size, !dir * -size, size, !dir * size, Math.max(w - size, 0), 0, "a", size, size, 0, 0, 1, size, size,
                    "l", 0, Math.max(h - size, 0), (dir == 1) * size, size, (dir == 1) * -size, size, 0, Math.max(h - size, 0), "a", size, size, 0, 0, 1, -size, size,
                    "l", -Math.max(w - size, 0), 0, "z"].join(","),
                xy = [
                    {
                        x: x,
                        y: y + size * 2 + h
                    },
                    {
                        x: x - size * 2 - w,
                        y: y
                    },
                    {
                        x: x,
                        y: y - size * 2 - h
                    },
                    {
                        x: x + size * 2 + w,
                        y: y
                    }
                ][dir];
        set.translate(xy.x - w - bb.x, xy.y - h - bb.y);
        return this.path({fill: "#000", stroke: "none"}, p).insertBefore(set.node ? set : set[0]);
    };
    Raphael.fn.g.popup = function (x, y, text, dir, size) {
        dir = dir == null ? 2 : dir;
        size = size || 5;
        text = text || "$9.99";
        var res = this.set(),
                d = 3;
        res.push(this.path({fill: "#000", stroke: "none"}));
        res.push(this.text(x, y, text).attr(this.g.txtattr).attr({fill: "#fff"}));
        res.update = function (X, Y, withAnimation) {
            X = X || x;
            Y = Y || y;
            var bb = this[1].getBBox(),
                    w = bb.width / 2,
                    h = bb.height / 2,
                    dx = [0, w + size * 2, 0, -w - size * 2],
                    dy = [-h * 2 - size * 3, -h - size, 0, -h - size],
                    p = ["M", X - dx[dir], Y - dy[dir], "l", -size, (dir == 2) * -size, -Math.max(w - size, 0), 0, "a", size, size, 0, 0, 1, -size, -size,
                        "l", 0, -Math.max(h - size, 0), (dir == 3) * -size, -size, (dir == 3) * size, -size, 0, -Math.max(h - size, 0), "a", size, size, 0, 0, 1, size, -size,
                        "l", Math.max(w - size, 0), 0, size, !dir * -size, size, !dir * size, Math.max(w - size, 0), 0, "a", size, size, 0, 0, 1, size, size,
                        "l", 0, Math.max(h - size, 0), (dir == 1) * size, size, (dir == 1) * -size, size, 0, Math.max(h - size, 0), "a", size, size, 0, 0, 1, -size, size,
                        "l", -Math.max(w - size, 0), 0, "z"].join(","),
                    xy = [
                        {
                            x: X,
                            y: Y + size * 2 + h
                        },
                        {
                            x: X - size * 2 - w,
                            y: Y
                        },
                        {
                            x: X,
                            y: Y - size * 2 - h
                        },
                        {
                            x: X + size * 2 + w,
                            y: Y
                        }
                    ][dir];
            if (withAnimation) {
                this[0].animate({path: p}, 500, ">");
                this[1].animate(xy, 500, ">");
            } else {
                this[0].attr({path: p});
                this[1].attr(xy);
            }
            return this;
        };
        return res.update(x, y);
    };
    Raphael.fn.g.flag = function (x, y, text, angle) {
        angle = angle || 0;
        text = text || "$9.99";
        var res = this.set(),
                d = 3;
        res.push(this.path({fill: "#000", stroke: "none"}));
        res.push(this.text(x, y, text).attr(this.g.txtattr).attr({fill: "#fff"}));
        res.update = function (x, y) {
            this.rotate(0, x, y);
            var bb = this[1].getBBox(),
                    h = bb.height / 2;
            this[0].attr({path: ["M", x, y, "l", h + d, -h - d, bb.width + 2 * d, 0, 0, bb.height + 2 * d, -bb.width - 2 * d, 0, "z"].join(",")});
            this[1].attr({x: x + h + d + bb.width / 2, y: y});
            angle = 360 - angle;
            this.rotate(angle, x, y);
            angle > 90 && angle < 270 && this[1].attr({x: x - r - d - bb.width / 2, y: y, rotation: [180 + angle, x, y]});
            return this;
        };
        return res.update(x, y);
    };
    Raphael.fn.g.label = function (x, y, text) {
        var res = this.set();
        res.push(this.rect(x, y, 10, 10).attr({stroke: "none", fill: "#000"}));
        res.push(this.text(x, y, text).attr(this.g.txtattr).attr({fill: "#fff"}));
        res.update = function () {
            var bb = this[1].getBBox(),
                    r = Math.min(bb.width + 10, bb.height + 10) / 2;
            this[0].attr({x: bb.x - r / 2, y: bb.y - r / 2, width: bb.width + r, height: bb.height + r, r: r});
        };
        res.update();
        return res;
    };
    Raphael.fn.g.labelit = function (set) {
        var bb = set.getBBox(),
                r = Math.min(20, bb.width + 10, bb.height + 10) / 2;
        return this.rect(bb.x - r / 2, bb.y - r / 2, bb.width + r, bb.height + r, r).attr({stroke: "none", fill: "#000"}).insertBefore(set[0]);
    };
    Raphael.fn.g.drop = function (x, y, text, size, angle) {
        size = size || 30;
        angle = angle || 0;
        var res = this.set();
        res.push(this.path({}, ["M", x, y, "l", size, 0, "A", size * .4, size * .4, 0, 1, 0, x + size * .7, y - size * .7, "z"]).attr({fill: "#000", stroke: "none", rotation: [22.5 - angle, x, y]}));
        angle = (angle + 90) * Math.PI / 180;
        res.push(this.text(x + size * Math.sin(angle), y + size * Math.cos(angle), text).attr(this.g.txtattr).attr({"font-size": size * 12 / 30, fill: "#fff"}));
        res.drop = res[0];
        res.text = res[1];
        return res;
    };
    Raphael.fn.g.blob = function (x, y, text, angle) {
        var angle = (+angle + 1 ? angle : 45) + 90,
                size = 12,
                rad = Math.PI / 180,
                fontSize = size * 12 / 12;
        var res = this.set();
        res.push(this.path({fill: "#000", stroke: "none"}));
        res.push(this.text(x + size * Math.sin((angle) * rad), y + size * Math.cos((angle) * rad) - fontSize / 2, text).attr(this.g.txtattr).attr({"font-size": fontSize, fill: "#fff"}));
        res.update = function (X, Y, withAnimation) {
            X = X || x;
            Y = Y || y;
            var bb = this[1].getBBox(),
                    w = Math.max(bb.width + fontSize, size * 25 / 12),
                    h = Math.max(bb.height + fontSize, size * 25 / 12),
                    x2 = X + size * Math.sin((angle - 22.5) * rad),
                    y2 = Y + size * Math.cos((angle - 22.5) * rad),
                    x1 = X + size * Math.sin((angle + 22.5) * rad),
                    y1 = Y + size * Math.cos((angle + 22.5) * rad),
                    dx = (x1 - x2) / 2,
                    dy = (y1 - y2) / 2,
                    rx = w / 2,
                    ry = h / 2,
                    k = -Math.sqrt(Math.abs(rx * rx * ry * ry - rx * rx * dy * dy - ry * ry * dx * dx) / (rx * rx * dy * dy + ry * ry * dx * dx)),
                    cx = k * rx * dy / ry + (x1 + x2) / 2,
                    cy = k * -ry * dx / rx + (y1 + y2) / 2;
            if (withAnimation) {
                this.animate({x: cx, y: cy, path: ["M", x, y, "L", x1, y1, "A", rx, ry, 0, 1, 1, x2, y2, "z"].join(",")}, 500, ">");
            } else {
                this.attr({x: cx, y: cy, path: ["M", x, y, "L", x1, y1, "A", rx, ry, 0, 1, 1, x2, y2, "z"].join(",")});
            }
            return this;
        };
        res.update(x, y);
        return res;
    };

    Raphael.fn.g.colorValue = function (value, total, s, b) {
        return "hsb(" + [Math.min((1 - value / total) * .4, 1), s || .75, b || .75] + ")";
    };

    Raphael.fn.g.snapEnds = function (from, to, steps) {
        var f = from,
                t = to;
        if (f == t) {
            return {from: f, to: t, power: 0};
        }
        function round(a) {
            return Math.abs(a - .5) < .25 ? Math.floor(a) + .5 : Math.round(a);
        }

        var d = (t - f) / steps,
                r = Math.floor(d),
                R = r,
                i = 0;
        if (r) {
            while (R) {
                i--;
                R = Math.floor(d * Math.pow(10, i)) / Math.pow(10, i);
            }
            i ++;
        } else {
            while (!r) {
                i = i || 1;
                r = Math.floor(d * Math.pow(10, i)) / Math.pow(10, i);
                i++;
            }
            i && i--;
        }
        var t = round(to * Math.pow(10, i)) / Math.pow(10, i);
        if (t < to) {
            t = round((to + .5) * Math.pow(10, i)) / Math.pow(10, i);
        }
        var f = round((from - (i > 0 ? 0 : .5)) * Math.pow(10, i)) / Math.pow(10, i);
        return {from: f, to: t, power: i};
    };
    Raphael.fn.g.axis = function (x, y, length, from, to, steps, orientation, labels, type, dashsize) {
        dashsize = dashsize == null ? 2 : dashsize;
        type = type || "t";
        steps = steps || 10;
        var path = type == "|" || type == " " ? ["M", x + .5, y, "l", 0, .001] : orientation == 1 || orientation == 3 ? ["M", x + .5, y, "l", 0, -length] : ["M", x, y + .5, "l", length, 0],
                ends = this.g.snapEnds(from, to, steps),
                f = ends.from,
                t = ends.to,
                i = ends.power,
                j = 0,
                text = this.set();
        d = (t - f) / steps;
        var label = f,
                rnd = i > 0 ? i : 0;
        dx = length / steps;
        if (+orientation == 1 || +orientation == 3) {
            var Y = y,
                    addon = (orientation - 1 ? 1 : -1) * (dashsize + 3 + !!(orientation - 1));
            while (Y >= y - length) {
                type != "-" && type != " " && (path = path.concat(["M", x - (type == "+" || type == "|" ? dashsize : !(orientation - 1) * dashsize * 2), Y + .5, "l", dashsize * 2 + 1, 0]));
                text.push(this.text(x + addon, Y, (labels && labels[j++]) || (Math.round(label) == label ? label : +label.toFixed(rnd))).attr(this.g.txtattr).attr({"text-anchor": orientation - 1 ? "start" : "end"}));
                label += d;
                Y -= dx;
            }
            if (Math.round(Y + dx - (y - length))) {
                type != "-" && type != " " && (path = path.concat(["M", x - (type == "+" || type == "|" ? dashsize : !(orientation - 1) * dashsize * 2), y - length + .5, "l", dashsize * 2 + 1, 0]));
                text.push(this.text(x + addon, y - length, (labels && labels[j]) || (Math.round(label) == label ? label : +label.toFixed(rnd))).attr(this.g.txtattr).attr({"text-anchor": orientation - 1 ? "start" : "end"}));
            }
        } else {
            var X = x,
                    label = f,
                    rnd = i > 0 ? i : 0,
                    addon = (orientation ? -1 : 1) * (dashsize + 9 + !orientation),
                    dx = length / steps,
                    txt = 0,
                    prev = 0;
            while (X <= x + length) {
                type != "-" && type != " " && (path = path.concat(["M", X + .5, y - (type == "+" ? dashsize : !!orientation * dashsize * 2), "l", 0, dashsize * 2 + 1]));
                text.push(txt = this.text(X, y + addon, (labels && labels[j++]) || (Math.round(label) == label ? label : +label.toFixed(rnd))).attr(this.g.txtattr));
                var bb = txt.getBBox();
                if (prev >= bb.x - 5) {
                    text.pop(text.length - 1).remove();
                } else {
                    prev = bb.x + bb.width;
                }
                label += d;
                X += dx;
            }
            if (Math.round(X - dx - x - length)) {
                type != "-" && type != " " && (path = path.concat(["M", x + length + .5, y - (type == "+" ? dashsize : !!orientation * dashsize * 2), "l", 0, dashsize * 2 + 1]));
                text.push(this.text(x + length, y + addon, (labels && labels[j]) || (Math.round(label) == label ? label : +label.toFixed(rnd))).attr(this.g.txtattr));
            }
        }
        var res = this.path({}, path);
        res.text = text;
        res.all = this.set([res, text]);
        res.remove = function () {
            this.text.remove();
            this.constructor.prototype.remove.call(this);
        };
        return res;
    };

    Raphael.el.lighter = function (times) {
        times = times || 2;
        var fs = [this.attrs.fill, this.attrs.stroke];
        this.fs = this.fs || [fs[0], fs[1]];
        fs[0] = Raphael.rgb2hsb(Raphael.getRGB(fs[0]).hex);
        fs[1] = Raphael.rgb2hsb(Raphael.getRGB(fs[1]).hex);
        fs[0].b = Math.min(fs[0].b * times, 1);
        fs[0].s = fs[0].s / times;
        fs[1].b = Math.min(fs[1].b * times, 1);
        fs[1].s = fs[1].s / times;
        this.attr({fill: "hsb(" + [fs[0].h, fs[0].s, fs[0].b] + ")", stroke: "hsb(" + [fs[1].h, fs[1].s, fs[1].b] + ")"});
    };
    Raphael.el.darker = function (times) {
        times = times || 2;
        var fs = [this.attrs.fill, this.attrs.stroke];
        this.fs = this.fs || [fs[0], fs[1]];
        fs[0] = Raphael.rgb2hsb(Raphael.getRGB(fs[0]).hex);
        fs[1] = Raphael.rgb2hsb(Raphael.getRGB(fs[1]).hex);
        fs[0].s = Math.min(fs[0].s * times, 1);
        fs[0].b = fs[0].b / times;
        fs[1].s = Math.min(fs[1].s * times, 1);
        fs[1].b = fs[1].b / times;
        this.attr({fill: "hsb(" + [fs[0].h, fs[0].s, fs[0].b] + ")", stroke: "hsb(" + [fs[1].h, fs[1].s, fs[1].b] + ")"});
    };
    Raphael.el.original = function () {
        if (this.fs) {
            this.attr({fill: this.fs[0], stroke: this.fs[1]});
            delete this.fs;
        }
    };
})();
/*[{!g_raphael_js_wgej54w!}]*/;
/* END /2static/script/lib/graphael/g.raphael.js */
/* START /2static/script/lib/graphael/g.bar.js */
/*
 * g.Raphael 0.2 - Charting library, based on Raphaël
 *
 * Copyright (c) 2009 Dmitry Baranovskiy (http://g.raphaeljs.com)
 * Licensed under the MIT (http://www.opensource.org/licenses/mit-license.php) license.
 */

Raphael.fn.g.barchart = function (x, y, width, height, values, isVertical, opts) {
    opts = opts || {};
    var type = {round: "round", sharp: "sharp", soft: "soft"}[opts.type] || "square",
            gutter = parseFloat(opts.gutter || "20%"),
            chart = this.set(),
            bars = this.set(),
            covers = this.set(),
            covers2 = this.set(),
            total = Math.max.apply(Math, values),
            stacktotal = [],
            paper = this,
            multi = 0,
            colors = opts.colors || this.g.colors,
            len = values.length;
    if (this.raphael.isArray(values[0])) {
        total = [];
        multi = len;
        len = 0;
        for (var i = values.length; i--;) {
            total.push(Math.max.apply(Math, values[i]));
            len = Math.max(len, values[i].length);
        }
        if (opts.stacked) {
            for (var i = len; i--;) {
                var tot = 0;
                for (var j = values.length; j--;) {
                    tot += + values[j][i] || 0;
                }
                stacktotal.push(tot);
            }
        }
        for (var i = values.length; i--;) {
            if (values[i].length < len) {
                for (var j = len; j--;) {
                    values[i].push(0);
                }
            }
        }
        total = Math.max.apply(Math, opts.stacked ? stacktotal : total);
    }

    total = (opts.to) || total;
    if (!isVertical) {
        var barwidth = width / (len * (100 + gutter) + gutter) * 100,
                barhgutter = barwidth * gutter / 100,
                barvgutter = typeof opts.vgutter == "undefined" ? 20 : opts.vgutter,
                stack = [],
                X = x + barhgutter,
                Y = (height - 2 * barvgutter) / total;
        if (!opts.stretch) {
            barhgutter = Math.round(barhgutter);
            barwidth = Math.floor(barwidth);
        }
        !opts.stacked && (barwidth /= multi || 1);
        for (var i = 0; i < len; i++) {
            stack = [];
            for (var j = 0; j < multi; j++) {
                var h = Math.round((multi ? values[j][i] : values[i]) * Y),
                        top = y + height - barvgutter - h,
                        bar;
                bars.push(bar = this.g.finger(Math.round(X + barwidth / 2), top + h, barwidth, opts.init ? 0 : h, true, type).attr({stroke: "none", fill: colors[multi ? j : i]}));
                bar.y = top;
                bar.x = Math.round(X + barwidth / 2);
                bar.w = barwidth;
                bar.h = h;
                bar.value = multi ? values[j][i] : values[i];
                opts.init && bar.animate({path: this.g.finger(Math.round(X + barwidth / 2), top + h, barwidth, h, true, type, 1)}, (+opts.init - 1) || 1000, ">");
                if (!opts.stacked) {
                    X += barwidth;
                } else {
                    stack.push(bar);
                }
            }
            if (opts.stacked) {
                var cvr;
                covers2.push(cvr = this.rect(stack[0].x - stack[0].w / 2, y, barwidth, height).attr({stroke: "none", fill: "#000", opacity: 0}));
                cvr.bars = [];
                for (var s = 0, ss = stack.length; s < ss; s++) {
                    cvr.bars.push(stack[s]);
                }
                stack.sort(function (a, b) {
                    return a.value - b.value;
                });
                var size = 0;
                for (var s = stack.length; s--;) {
                    stack[s].toFront();
                }
                for (var s = 0, ss = stack.length; s < ss; s++) {
                    var bar = stack[s],
                            cover,
                            h = (size + bar.value) * Y,
                            path = this.g.finger(bar.x, y + height - barvgutter - !!size * .5, barwidth, h, true, type, 1);
                    size && opts.init && bar.animate({path: path}, (+opts.init - 1) || 1000, ">");
                    size && !opts.init && bar.attr({path: path});
                    bar.h = h;
                    bar.y = y + height - barvgutter - !!size * .5 - h;
                    covers.push(cover = this.rect(bar.x - bar.w / 2, bar.y, barwidth, bar.value * Y).attr({stroke: "none", fill: "#000", opacity: 0}));
                    cover.bar = bar;
                    size += bar.value;
                }

                X += barwidth;
            }
            X += barhgutter;
        }
        covers2.toFront();
        X = x + barhgutter;
        if (!opts.stacked) {
            for (var i = 0; i < len; i++) {
                for (var j = 0; j < multi; j++) {
                    var cover;
                    covers.push(cover = this.rect(Math.round(X), y + barvgutter, barwidth, height - barvgutter).attr({stroke: "none", fill: "#000", opacity: 0}));
                    cover.bar = bars[i * (multi || 1) + j];
                    X += barwidth;
                }
                X += barhgutter;
            }
        }
        chart.label = function (labels, isBottom) {
            labels = labels || [];
            this.labels = paper.set();
            var L, l = -Infinity;
            if (opts.stacked) {
                for (var i = 0; i < len; i++) {
                    var tot = 0;
                    for (var j = 0; j < multi; j++) {
                        tot += multi ? values[j][i] : values[i];
                        if (j == multi - 1) {
                            var label = paper.g.labelise(labels[i], tot, total);
                            L = paper.g.text(bars[i * (multi || 1) + j].x, y + height - barvgutter / 2, label).insertBefore(covers[i * (multi || 1) + j]);
                            var bb = L.getBBox();
                            if (bb.x - 7 < l) {
                                L.remove();
                            } else {
                                this.labels.push(L);
                                l = bb.x + bb.width;
                            }
                        }
                    }
                }
            } else {
                for (var i = 0; i < len; i++) {
                    for (var j = 0; j < multi; j++) {
                        var label = paper.g.labelise(multi ? labels[j] && labels[j][i] : labels[i], multi ? values[j][i] : values[i], total);
                        L = paper.g.text(bars[i * (multi || 1) + j].x, isBottom ? y + height - barvgutter / 2 : bars[i * (multi || 1) + j].y - 10, label).insertBefore(covers[i * (multi || 1) + j]);
                        var bb = L.getBBox();
                        if (bb.x - 7 < l) {
                            L.remove();
                        } else {
                            this.labels.push(L);
                            l = bb.x + bb.width;
                        }
                    }
                }
            }
            return this;
        };
    } else {
        var barheight = Math.floor(height / (len * (100 + gutter) + gutter) * 100),
                bargutter = Math.floor(barheight * gutter / 100),
                stack = [],
                Y = y + bargutter,
                X = (width - 1) / total;
        !opts.stacked && (barheight /= multi || 1);
        for (var i = 0; i < len; i++) {
            stack = [];
            for (var j = 0; j < multi; j++) {
                var val = multi ? values[j][i] : values[i],
                        bar;
                bars.push(bar = this.g.finger(x, Y + barheight / 2, opts.init ? 0 : Math.round(val * X), barheight - 1, false, type).attr({stroke: colors[multi > 1 ? j : i], fill: colors[multi > 1 ? j : i]}));
                bar.x = x + Math.round(val * X);
                bar.y = Y + barheight / 2;
                bar.w = Math.round(val * X);
                bar.h = barheight;
                bar.value = +val;
                opts.init && bar.animate({path: this.g.finger(x, Y + barheight / 2, Math.round(val * X), barheight - 1, false, type, 1)}, (+opts.init - 1) || 500, ">");
                if (!opts.stacked) {
                    Y += barheight;
                } else {
                    stack.push(bar);
                }
            }
            if (opts.stacked) {
                stack.sort(function (a, b) {
                    return a.value - b.value;
                });
                var size = 0;
                for (var s = stack.length; s--;) {
                    stack[s].toFront();
                }
                for (var s = 0, ss = stack.length; s < ss; s++) {
                    var bar = stack[s],
                            cover,
                            val = Math.round((size + bar.value) * X),
                            path = this.g.finger(x, bar.y, val, barheight - 1, false, type, 1);
                    size && opts.init && bar.animate({path: path}, (+opts.init - 1) || 1000, ">");
                    size && !opts.init && bar.attr({path: path});
                    bar.w = val;
                    bar.x = x + val;
                    covers.push(cover = this.rect(x + size * X, bar.y - bar.h / 2, bar.value * X, barheight).attr({stroke: "none", fill: "#000", opacity: 0}));
                    cover.bar = bar;
                    size += bar.value;
                }
                Y += barheight;
            }
            Y += bargutter;
        }
        Y = y + bargutter;
        if (!opts.stacked) {
            for (var i = 0; i < len; i++) {
                for (var j = 0; j < multi; j++) {
                    covers.push(this.rect(x, Y, width, barheight).attr({stroke: "none", fill: "#000", opacity: 0}));
                    Y += barheight;
                }
                Y += bargutter;
            }
        }
        chart.label = function (labels, isRight) {
            labels = labels || [];
            this.labels = paper.set();
            for (var i = 0; i < len; i++) {
                for (var j = 0; j < multi; j++) {
                    var label = paper.g.labelise(multi ? labels[j] && labels[j][i] : labels[i], multi ? values[j][i] : values[i], total);
                    var X = isRight ? bars[i * (multi || 1) + j].x - barheight / 2 + 3 : x + 5,
                            A = isRight ? "end" : "start",
                            L;
                    this.labels.push(L = paper.g.text(X, bars[i * (multi || 1) + j].y, label).attr({"text-anchor": A}).insertBefore(covers[0]));
                    if (L.getBBox().x < x + 5) {
                        L.attr({x: x + 5, "text-anchor": "start"});
                    } else {
                        bars[i * (multi || 1) + j].label = L;
                    }
                }
            }
            return this;
        };
    }
    chart.hover = function (fin, fout) {
        covers2.hide();
        covers.show();
        fout = fout || function () {
        };
        covers.mouseover(fin).mouseout(fout);
        return this;
    };
    chart.hoverColumn = function (fin, fout) {
        covers.hide();
        covers2.show();
        fout = fout || function () {
        };
        covers2.mouseover(fin).mouseout(fout);
        return this;
    };
    chart.click = function (f) {
        covers2.hide();
        covers.show();
        covers.click(f);
        return this;
    };
    chart.clickColumn = function (f) {
        covers.hide();
        covers2.show();
        covers2.click(f);
        return this;
    };
    chart.push(bars, covers, covers2);
    chart.bars = bars;
    chart.covers = covers;
    return chart;
};
/*[{!g_bar_js_0cey54s!}]*/;
/* END /2static/script/lib/graphael/g.bar.js */
/* START /2static/script/lib/graphael/g.pie.js */
/*
 * g.Raphael 0.2 - Charting library, based on Raphaël
 *
 * Copyright (c) 2009 Dmitry Baranovskiy (http://g.raphaeljs.com)
 * Licensed under the MIT (http://www.opensource.org/licenses/mit-license.php) license.
 */

Raphael.fn.g.piechart = function (cx, cy, r, values, opts) {
    opts = opts || {};
    var paper = this,
            sectors = [],
            covers = this.set(),
            chart = this.set(),
            series = this.set(),
            order = [],
            len = values.length,
            angle = 0,
            total = 0,
            others = 0,
            cut = 9,
            defcut = true;
    chart.covers = covers;
    if (len == 1) {
        series.push(this.circle(cx, cy, r).attr({fill: this.g.colors[0], stroke: opt.stroke || "#fff", "stroke-width": opts.strokewidth == null ? 1 : opts.strokewidth}));
        covers.push(this.circle(cx, cy, r).attr({fill: "#000", opacity: 0, "stroke-width": 3}));
        total = values[0];
        values[0] = {value: values[0], order: 0, valueOf: function () {
            return this.value;
        }};
        series[0].middle = {x: cx, y: cy};
        series[0].mangle = 180;
    } else {
        function sector(cx, cy, r, startAngle, endAngle, fill) {
            var rad = Math.PI / 180,
                    x1 = cx + r * Math.cos(-startAngle * rad),
                    x2 = cx + r * Math.cos(-endAngle * rad),
                    xm = cx + r / 2 * Math.cos(-(startAngle + (endAngle - startAngle) / 2) * rad),
                    y1 = cy + r * Math.sin(-startAngle * rad),
                    y2 = cy + r * Math.sin(-endAngle * rad),
                    ym = cy + r / 2 * Math.sin(-(startAngle + (endAngle - startAngle) / 2) * rad),
                    res = ["M", cx, cy, "L", x1, y1, "A", r, r, 0, +(Math.abs(endAngle - startAngle) > 180), 1, x2, y2, "z"];
            res.middle = {x: xm, y: ym};
            return res;
        }

        for (var i = 0; i < len; i++) {
            total += values[i];
            values[i] = {value: values[i], order: i, valueOf: function () {
                return this.value;
            }};
        }
        values.sort(function (a, b) {
            return b.value - a.value;
        });
        for (var i = 0; i < len; i++) {
            if (defcut && values[i] * 360 / total <= 1.5) {
                cut = i;
                defcut = false;
            }
            if (i > cut) {
                defcut = false;
                values[cut].value += values[i];
                values[cut].others = true;
                others = values[cut].value;
            }
        }
        len = Math.min(cut + 1, values.length);
        others && values.splice(len) && (values[cut].others = true);
        for (var i = 0; i < len; i++) {
            var mangle = angle - 360 * values[i] / total / 2;
            if (!i) {
                angle = 90 - mangle;
                mangle = angle - 360 * values[i] / total / 2;
            }
            if (opts.init) {
                var ipath = sector(cx, cy, 1, angle, angle - 360 * values[i] / total).join(",");
            }
            var path = sector(cx, cy, r, angle, angle -= 360 * values[i] / total);
            var p = this.path({fill: opts.colors && opts.colors[i] || this.g.colors[i] || "#666", stroke: opts.stroke || "#fff", "stroke-width": opts.strokewidth == null ? 1 : opts.strokewidth, "stroke-linejoin": "round"}, opts.init ? ipath : path.join(","));
            p.value = values[i];
            p.middle = path.middle;
            p.mangle = mangle;
            sectors.push(p);
            series.push(p);
            opts.init && p.animate({path: path.join(",")}, (+opts.init - 1) || 1000, ">");
        }
        for (var i = 0; i < len; i++) {
            var p = paper.path({fill: "#000", opacity: 0, "stroke-width": 3}, sectors[i].attr("path"));
            opts.href && opts.href[i] && p.attr({href: opts.href[i]});
            p.attr = function () {
            };
            covers.push(p);
            series.push(p);
        }
    }

    chart.hover = function (fin, fout) {
        fout = fout || function () {
        };
        var that = this;
        for (var i = 0; i < len; i++) {
            (function (sector, cover, j) {
                var o = {
                    sector: sector,
                    cover: cover,
                    cx: cx,
                    cy: cy,
                    mx: sector.middle.x,
                    my: sector.middle.y,
                    mangle: sector.mangle,
                    r: r,
                    value: values[j],
                    total: total,
                    label: that.labels && that.labels[j]
                };
                cover.mouseover(function () {
                    fin.call(o);
                }).mouseout(function () {
                    fout.call(o);
                });
            })(series[i], covers[i], i);
        }
        return this;
    };
    chart.click = function (f) {
        var that = this;
        for (var i = 0; i < len; i++) {
            (function (sector, cover, j) {
                var o = {
                    sector: sector,
                    cover: cover,
                    cx: cx,
                    cy: cy,
                    mx: sector.middle.x,
                    my: sector.middle.y,
                    mangle: sector.mangle,
                    r: r,
                    value: values[j],
                    total: total,
                    label: that.labels && that.labels[j]
                };
                cover.click(function () {
                    f.call(o);
                });
            })(series[i], covers[i], i);
        }
        return this;
    };
    chart.inject = function (element) {
        element.insertBefore(covers[0]);
    };
    var legend = function (labels, otherslabel, mark, dir) {
        var x = cx + r + r / 5,
                y = cy,
                h = y + 10;
        labels = labels || [];
        dir = (dir && dir.toLowerCase && dir.toLowerCase()) || "east";
        mark = paper.g.markers[mark && mark.toLowerCase()] || "disc";
        chart.labels = paper.set();
        for (var i = 0; i < len; i++) {
            var clr = series[i].attr("fill"),
                    j = values[i].order,
                    txt;
            values[i].others && (labels[j] = otherslabel || "Others");
            labels[j] = paper.g.labelise(labels[j], values[i], total);
            chart.labels.push(paper.set());
            chart.labels[i].push(paper.g[mark](x + 5, h, 5).attr({fill: clr, stroke: "none"}));
            chart.labels[i].push(txt = paper.text(x + 20, h, labels[j] || values[j]).attr(paper.g.txtattr).attr({fill: opts.legendcolor || "#000", "text-anchor": "start"}));
            covers[i].label = chart.labels[i];
            h += txt.getBBox().height * 1.2;
        }
        var bb = chart.labels.getBBox(),
                tr = {
                    east: [0, -bb.height / 2],
                    west: [-bb.width - 2 * r - 20, -bb.height / 2],
                    north: [-r - bb.width / 2, -r - bb.height - 10],
                    south: [-r - bb.width / 2, r + 10]
                }[dir];
        chart.labels.translate.apply(chart.labels, tr);
        chart.push(chart.labels);
    };
    if (opts.legend) {
        legend(opts.legend, opts.legendothers, opts.legendmark, opts.legendpos);
    }
    chart.push(series, covers);
    chart.series = series;
    chart.covers = covers;
    return chart;
};
/*[{!g_pie_js_ousq54v!}]*/;
/* END /2static/script/lib/graphael/g.pie.js */
/* START /2static/script/lib/graphael/g.line.js */
/*
 * g.Raphael 0.2 - Charting library, based on Raphaël
 *
 * Copyright (c) 2009 Dmitry Baranovskiy (http://g.raphaeljs.com)
 * Licensed under the MIT (http://www.opensource.org/licenses/mit-license.php) license.
 */

Raphael.fn.g.linechart = function (x, y, width, height, valuesx, valuesy, opts) {
    function shrink(values, dim) {
        var k = values.length / dim,
                j = 0,
                l = k,
                sum = 0,
                res = [];
        while (j < values.length) {
            l--;
            if (l < 0) {
                sum += values[j] * (1 + l);
                res.push(sum / k);
                sum = values[j++] * -l;
                l += k;
            } else {
                sum += values[j++];
            }
        }
        return res;
    }

    opts = opts || {};
    if (!this.raphael.isArray(valuesx[0])) {
        valuesx = [valuesx];
    }
    if (!this.raphael.isArray(valuesy[0])) {
        valuesy = [valuesy];
    }
    var allx = Array.prototype.concat.apply([], valuesx),
            ally = Array.prototype.concat.apply([], valuesy),
            xdim = this.g.snapEnds(Math.min.apply(Math, allx), Math.max.apply(Math, allx), valuesx[0].length - 1),
            minx = xdim.from,
            maxx = xdim.to,
            gutter = opts.gutter || 10,
            kx = (width - gutter * 2) / (maxx - minx),
            ydim = this.g.snapEnds(Math.min.apply(Math, ally), Math.max.apply(Math, ally), valuesy[0].length - 1),
            miny = ydim.from,
            maxy = ydim.to,
            ky = (height - gutter * 2) / (maxy - miny),
            len = Math.max(valuesx[0].length, valuesy[0].length),
            symbol = opts.symbol || "",
            colors = opts.colors || Raphael.fn.g.colors,
            that = this,
            columns = null,
            dots = null,
            chart = this.set(),
            path = [];

    for (var i = 0, ii = valuesy.length; i < ii; i++) {
        len = Math.max(len, valuesy[i].length);
    }
    var shades = this.set();
    for (var i = 0, ii = valuesy.length; i < ii; i++) {
        if (opts.shade) {
            shades.push(this.path({stroke: "none", fill: colors[i], opacity: opts.nostroke ? 1 : .3}));
        }
        if (valuesy[i].length > width - 2 * gutter) {
            valuesy[i] = shrink(valuesy[i], width - 2 * gutter);
            len = width - 2 * gutter;
        }
        if (valuesx[i] && valuesx[i].length > width - 2 * gutter) {
            valuesx[i] = shrink(valuesx[i], width - 2 * gutter);
        }
    }
    var axis = this.set();
    if (opts.axis) {
        var ax = (opts.axis + "").split(/[,\s]+/);
        +ax[0] && axis.push(this.g.axis(x + gutter, y + gutter, width - 2 * gutter, minx, maxx, opts.axisxstep || Math.floor((width - 2 * gutter) / 20), 2));
        +ax[1] && axis.push(this.g.axis(x + width - gutter, y + height - gutter, height - 2 * gutter, miny, maxy, opts.axisystep || Math.floor((height - 2 * gutter) / 20), 3));
        +ax[2] && axis.push(this.g.axis(x + gutter, y + height - gutter, width - 2 * gutter, minx, maxx, opts.axisxstep || Math.floor((width - 2 * gutter) / 20), 0));
        +ax[3] && axis.push(this.g.axis(x + gutter, y + height - gutter, height - 2 * gutter, miny, maxy, opts.axisystep || Math.floor((height - 2 * gutter) / 20), 1));
    }
    var lines = this.set(),
            symbols = this.set(),
            line;
    for (var i = 0, ii = valuesy.length; i < ii; i++) {
        if (!opts.nostroke) {
            lines.push(line = this.path({
                stroke: colors[i],
                "stroke-width": opts.width || 2,
                "stroke-linejoin": "round",
                "stroke-linecap": "round",
                "stroke-dasharray": opts.dash || ""
            }));
        }
        var sym = this.raphael.isArray(symbol) ? symbol[i] : symbol;
        path = [];
        for (var j = 0, jj = valuesy[i].length; j < jj; j++) {
            var X = x + gutter + ((valuesx[i] || valuesx[0])[j] - minx) * kx;
            var Y = y + height - gutter - (valuesy[i][j] - miny) * ky;
            (Raphael.isArray(sym) ? sym[j] : sym) && symbols.push(this.g[Raphael.fn.g.markers[this.raphael.isArray(sym) ? sym[j] : sym]](X, Y, (opts.width || 2) * 3).attr({fill: colors[i], stroke: "none"}));
            path = path.concat([j ? "L" : "M", X, Y]);
        }
        if (opts.shade) {
            shades[i].attr({path: path.concat(["L", X, y + height - gutter, "L",  x + gutter + ((valuesx[i] || valuesx[0])[0] - minx) * kx, y + height - gutter, "z"]).join(",")});
        }
        !opts.nostroke && line.attr({path: path.join(",")});
    }
    function createColumns() {
        // unite Xs together
        var Xs = [];
        for (var i = 0, ii = valuesx.length; i < ii; i++) {
            Xs = Xs.concat(valuesx[i]);
        }
        Xs.sort();
        // remove duplicates
        var Xs2 = [],
                xs = [];
        for (var i = 0, ii = Xs.length; i < ii; i++) {
            Xs[i] != Xs[i - 1] && Xs2.push(Xs[i]) && xs.push(x + gutter + (Xs[i] - minx) * kx);
        }
        Xs = Xs2;
        ii = Xs.length;
        var cvrs = that.set();
        for (var i = 0; i < ii; i++) {
            var X = xs[i] - (xs[i] - (xs[i - 1] || x)) / 2,
                    w = ((xs[i + 1] || x + width) - xs[i]) / 2 + (xs[i] - (xs[i - 1] || x)) / 2,
                    C;
            cvrs.push(C = that.rect(X - 1, y, w + 1, height).attr({stroke: "none", fill: "#000", opacity: 0}));
            C.values = [];
            C.y = [];
            C.x = xs[i];
            C.axis = Xs[i];
            C.xIndex = i;
            for (var j = 0, jj = valuesy.length; j < jj; j++) {
                Xs2 = valuesx[j] || valuesx[0];
                for (var k = 0, kk = Xs2.length; k < kk; k++) {
                    if (Xs2[k] == Xs[i]) {
                        C.values.push(valuesy[j][k]);
                        C.y.push(y + height - gutter - (valuesy[j][k] - miny) * ky);
                    }
                }
            }
        }
        columns = cvrs;
    }

    function createDots() {
        var cvrs = that.set(),
                C;
        for (var i = 0, ii = valuesy.length; i < ii; i++) {
            for (var j = 0, jj = valuesy[i].length; j < jj; j++) {
                var X = x + gutter + ((valuesx[i] || valuesx[0])[j] - minx) * kx,
                        nearX = x + gutter + ((valuesx[i] || valuesx[0])[j ? j - 1 : 1] - minx) * kx,
                        Y = y + height - gutter - (valuesy[i][j] - miny) * ky;
                cvrs.push(C = that.circle(X, Y, Math.abs(nearX - X) / 2).attr({stroke: "none", fill: "#000", opacity: 0}));
                C.x = X;
                C.y = Y;
                C.value = valuesy[i][j];
                C.axis = (valuesx[i] || valuesx[0])[j];
            }
        }
        dots = cvrs;
    }

    chart.push(axis, columns, dots, lines, shades, symbols);
    chart.hoverColumn = function (fin, fout) {
        !columns && createColumns();
        columns.mouseover(fin).mouseout(fout);
        return this;
    };
    chart.clickColumn = function (f) {
        !columns && createColumns();
        columns.click(f);
        return this;
    };
    chart.hrefColumn = function (cols) {
        var hrefs = that.raphael.isArray(arguments[0]) ? arguments[0] : arguments;
        if (!(arguments.length - 1) && typeof cols == "object") {
            for (var x in cols) {
                for (var i = 0, ii = columns.length; i < ii; i++) if (columns[i].axis == x) {
                    columns[i].attr("href", cols[x]);
                }
            }
        }
        !columns && createColumns();
        for (var i = 0, ii = hrefs.length; i < ii; i++) {
            columns[i] && columns[i].attr("href", hrefs[i]);
        }
        return this;
    };
    chart.hoverDot = function (fin, fout) {
        !dots && createDots();
        dots.mouseover(fin).mouseout(fout);
        return this;
    };
    chart.clickDot = function (f) {
        !dots && createDots();
        dots.click(f);
        return this;
    };
    return chart;
};
/*[{!g_line_js_q6pl54u!}]*/;
/* END /2static/script/lib/graphael/g.line.js */
/* START /2static/script/lib/graphael/g.dot.js */
/*
 * g.Raphael 0.2 - Charting library, based on Raphaël
 *
 * Copyright (c) 2009 Dmitry Baranovskiy (http://g.raphaeljs.com)
 * Licensed under the MIT (http://www.opensource.org/licenses/mit-license.php) license.
 */

Raphael.fn.g.dotchart = function (x, y, width, height, valuesx, valuesy, size, opts) {
    function drawAxis(ax) {
        +ax[0] && (ax[0] = paper.g.axis(x + gutter, y + gutter, width - 2 * gutter, minx, maxx, opts.axisxstep || Math.floor((width - 2 * gutter) / 20), 2, opts.axisxlabels || null, opts.axisxtype || "t"));
        +ax[1] && (ax[1] = paper.g.axis(x + width - gutter, y + height - gutter, height - 2 * gutter, miny, maxy, opts.axisystep || Math.floor((height - 2 * gutter) / 20), 3, opts.axisylabels || null, opts.axisytype || "t"));
        +ax[2] && (ax[2] = paper.g.axis(x + gutter, y + height - gutter + maxR, width - 2 * gutter, minx, maxx, opts.axisxstep || Math.floor((width - 2 * gutter) / 20), 0, opts.axisxlabels || null, opts.axisxtype || "t"));
        +ax[3] && (ax[3] = paper.g.axis(x + gutter - maxR, y + height - gutter, height - 2 * gutter, miny, maxy, opts.axisystep || Math.floor((height - 2 * gutter) / 20), 1, opts.axisylabels || null, opts.axisytype || "t"));
    }

    opts = opts || {};
    var xdim = this.g.snapEnds(Math.min.apply(Math, valuesx), Math.max.apply(Math, valuesx), valuesx.length - 1),
            minx = xdim.from,
            maxx = xdim.to,
            gutter = opts.gutter || 10,
            ydim = this.g.snapEnds(Math.min.apply(Math, valuesy), Math.max.apply(Math, valuesy), valuesy.length - 1),
            miny = ydim.from,
            maxy = ydim.to,
            len = Math.max(valuesx.length, valuesy.length, size.length),
            symbol = this.g.markers[opts.symbol] || "disc",
            res = this.set(),
            series = this.set(),
            max = opts.max || 100,
            top = Math.max.apply(Math, size),
            R = [],
            paper = this,
            k = Math.sqrt(top / Math.PI) * 2 / max;

    for (var i = 0; i < len; i++) {
        R[i] = Math.min(Math.sqrt(size[i] / Math.PI) * 2 / k, max);
    }
    gutter = Math.max.apply(Math, R.concat(gutter));
    var axis = this.set(),
            maxR = Math.max.apply(Math, R);
    if (opts.axis) {
        var ax = (opts.axis + "").split(/[,\s]+/);
        drawAxis(ax);
        var g = [], b = [];
        for (var i = 0, ii = ax.length; i < ii; i++) {
            var bb = ax[i].all ? ax[i].all.getBBox()[["height", "width"][i % 2]] : 0;
            g[i] = bb + gutter;
            b[i] = bb;
        }
        gutter = Math.max.apply(Math, g.concat(gutter));
        for (var i = 0, ii = ax.length; i < ii; i++) if (ax[i].all) {
            ax[i].remove();
            ax[i] = 1;
        }
        drawAxis(ax);
        for (var i = 0, ii = ax.length; i < ii; i++) if (ax[i].all) {
            axis.push(ax[i].all);
        }
        res.axis = axis;
    }
    var kx = (width - gutter * 2) / ((maxx - minx) || 1),
            ky = (height - gutter * 2) / ((maxy - miny) || 1);
    for (var i = 0, ii = valuesy.length; i < ii; i++) {
        var sym = this.raphael.isArray(symbol) ? symbol[i] : symbol,
                X = x + gutter + (valuesx[i] - minx) * kx,
                Y = y + height - gutter - (valuesy[i] - miny) * ky;
        sym && R[i] && series.push(this.g[sym](X, Y, R[i]).attr({fill: opts.heat ? this.g.colorValue(R[i], maxR) : Raphael.fn.g.colors[0], "fill-opacity": opts.opacity ? R[i] / max : 1, stroke: "none"}));
    }
    var covers = this.set();
    for (var i = 0, ii = valuesy.length; i < ii; i++) {
        var X = x + gutter + (valuesx[i] - minx) * kx,
                Y = y + height - gutter - (valuesy[i] - miny) * ky;
        covers.push(this.circle(X, Y, maxR).attr({fill: "#000", stroke: "none", opacity: 0}));
        opts.href && opts.href[i] && covers[i].attr({href: opts.href[i]});
        covers[i].r = +R[i].toFixed(3);
        covers[i].x = +X.toFixed(3);
        covers[i].y = +Y.toFixed(3);
        covers[i].X = valuesx[i];
        covers[i].Y = valuesy[i];
        covers[i].value = size[i] || 0;
        covers[i].dot = series[i];
    }
    res.covers = covers;
    res.series = series;
    res.push(series, axis, covers);
    res.hover = function (fin, fout) {
        covers.mouseover(fin).mouseout(fout);
        return this;
    };
    res.click = function (f) {
        covers.click(f);
        return this;
    };
    res.href = function (map) {
        var cover;
        for (var i = covers.length; i--;) {
            cover = covers[i];
            if (cover.X == map.x && cover.Y == map.y && cover.value == map.value) {
                cover.attr({href: map.href});
            }
        }
    };
    return res;
};
/*[{!g_dot_js_ypf654t!}]*/;
/* END /2static/script/lib/graphael/g.dot.js */
/* START /2static/script/fecru/raphaelCharts.js */
window.FECRU = window.FECRU || {};
FECRU.RAPHAELCHARTS = {};

(function () {

    var LINE_COLOURS_PIE = ["#478ec7", "#769810", "#d8561f", "#d7e52e", "#0c4383", "#5fbe41", "#f5832b", "#edef00", "#0c87c9", "#ad2a15"];
    var LINE_COLOURS_XY = ["#d7561f", "#478ec7", "#769810", "#dee439", "#5fbe41", "#0c4383", "#f5832b", "#edef00", "#0c87c9", "#ad2a15", "#aebf47"];
    var REPOSITORY_COLOURS = ["#d7561f", "#769810", "#dee439", "#5fbe41", "#0c4383", "#f5832b", "#edef00", "#0c87c9", "#ad2a15", "#aebf47"];

    var months = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];

    var getClr = function (i) {
        return LINE_COLOURS_XY[i % LINE_COLOURS_XY.length];
    };

    function getMinY(bars) {
        var minY = bars[0].y;
        for (var i = 1, ii = bars.length; i < ii; i++) {
            minY = Math.min(bars[i].y, minY);
        }
        return minY;
    }

    function getMaxY(bars) {
        var maxY = 0;
        for (var i = 0, ii = bars.length; i < ii; i++) {
            maxY = Math.max(bars[i].y + bars[i].h, maxY);
        }
        return maxY;
    }

    function toComp(num) {
        var prefix = ["", , , "K", , , "M", , , "G", , , "T", , , "P", , , "E", , , "Z", , , "Y"];
        for (var i = 0, ii = prefix.length; i < ii; i++) {
            if (typeof prefix[i] === "string") {
                if (num < Math.pow(10, i + 3)) {
                    return Math.round(num / Math.pow(10, i)) + prefix[i];
                }
            }
        }
        return Math.round(num / Math.pow(10, i - 1)) + prefix[prefix.length - 1];
    }

    function initDiv(divName) {
        AJS.$("body").append('<div id="' + divName + '-child" style="display:block;position:absolute; left:-4000px;">&nbsp;</div>');
        return divName + '-child';
    }

    function finaliseDiv(divName) {
        var div = AJS.$('#' + divName + '-child');
        div.removeAttr("style");

        //div.insertAfter(AJS.$('#' + divName));
        AJS.$('#' + divName).replaceWith(div);

    }

    function drawLocCharts(xValuesLoc, yValuesLoc, seriesLabelsShort, seriesLabelsLong, pageUrl) {

        var txt = {"text-anchor": "start", "font-size": 11, fill: "#666"};
        var popup;
        var dateText;

        var formattedDates = [];
        for (var i = 0, ii = xValuesLoc.length; i < ii; i++) {
            formattedDates[i] = formatDate(xValuesLoc[i]);
        }

        function hin2() {
            axisSet.hide();
            if (popup) {
                popup.remove();
                tooltipSet.hide();
                popup = null;
            }
            if (dateText) {
                dateText.remove();
                dateText = null;
            }
            for (var i = 0, ii = this.values.length; i < ii; i++) {
                tooltipSet[i].attr({text: seriesLabelsShort[i] + ": " + toComp(this.values[i])});
            }
            tooltipSet.show();
            if (this.line) {
                this.line.show();
            } else {
                this.line = rMain.set();
                this.line.push(rMain.path({opacity: .3}, "M" + [Math.round(this.x) + .5, 10, "l", 0, 130]).insertBefore(this));
                for (var j = 0, jj = this.values.length; j < jj; j++) {
                    this.line.push(rMain.circle(Math.round(this.x) + .5, this.y[j], 3).insertBefore(this).attr({
                        fill: getClr(j),
                        stroke: "#fff"
                    }));
                }
            }
            popup = rMain.set();
            var maxy = Math.max.apply(0, this.y);
            var miny = Math.min.apply(0, this.y);
            popup.push(rMain.g.popupit(this.x, miny + (maxy - miny) / 2, tooltipSet, (this.x < 200) * 2 + 1).insertBefore(this).attr({
                fill: "#fff",
                stroke: "#666"
            }));
            tooltipSet.insertBefore(this);
            dateText = rMain.text(this.x, 150, (formattedDates[this.xIndex]));
        }

        function hout() {
            if (popup) {
                popup.remove();
                tooltipSet.hide();
                axisSet.show();
                popup = null;
                this.line.hide();
            }
            if (dateText) {
                dateText.remove();
                dateText = null;
            }
        }

        function fclick() {
            if (pageUrl) {
                var oldMaxDate = pageUrl.match(/maxDate=.*?(?=&|$)/);
                var newMaxDate = 'maxDate=' + xValuesLoc[this.xIndex];
                if (oldMaxDate) {
                    pageUrl = pageUrl.replace(oldMaxDate, newMaxDate);
                } else {
                    pageUrl += (pageUrl.indexOf("?") === -1) ? "?" : "&";
                    pageUrl += newMaxDate;
                }
                window.location = pageUrl;
            }
        }

        // draw sparkline

        var divSparkline = "locChartSparkline";
        var divSparklineChild = initDiv(divSparkline);

        var rSparkline = Raphael(divSparklineChild, 280, 37);
        rSparkline.g.linechart(0, 0, 280, 32, xValuesLoc, yValuesLoc, {colors: LINE_COLOURS_XY, width: 2});


        // draw main chart

        var divMain = "locChartMain";
        var divMainChild = initDiv(divMain);

        var bump = 20;
        var mainHeight = 150 + 10 + 20 * seriesLabelsLong.length;

        var rMain = Raphael(divMainChild, 280, mainHeight);

        // set up tooltip text
        var tooltipSet = rMain.set();
        for (var l = 0, ll = seriesLabelsLong.length; l < ll; l++) {
            tooltipSet.push(rMain.text(100, 30 + l * 15, "").attr({fill: getClr(l), "font-weight": 800}));
        }
        tooltipSet.hide();

        // draw legend
        for (var i = 0, ii = seriesLabelsLong.length; i < ii; i++) {
            rMain.g.disc(20, 150 + 20 * i + bump, 7).attr({stroke: "none", fill: getClr(i)});
            rMain.text(30, 150 + 20 * i + bump, seriesLabelsLong[i]).attr({"text-anchor": "start"});
        }

        rMain.path({opacity: .3}, "M" + [0, 130, "l", 276, 0]);

        // draw date axis
        var axisSet = rMain.set();

        var step = (276 - 9) / xValuesLoc.length;

        var dateWidth = 60;
        var lastX = -dateWidth / 2;

        for (var i = 0, ii = xValuesLoc.length; i < ii; i++) {

            var xVal = 12 + i * step;
            if (xVal - lastX > dateWidth) {
                lastX = xVal;
                //                axisSet.push(rMain.path({opacity: .3}, "M" + [xVal, 140, "l", 0, 5]));
                axisSet.push(rMain.text(xVal, 150, (formattedDates[i])));
            }
        }

        rMain.g.linechart(0, 10, 276, 130, xValuesLoc, yValuesLoc, {
            colors: LINE_COLOURS_XY,
            width: 2
        }).hoverColumn(hin2, hout).clickColumn(fclick);

        finaliseDiv(divSparkline);
        finaliseDiv(divMain);

    }

    function formatDate(ms) {

        var d = new Date(ms);

        var s = "";
        if (d.getDate() < 10) {
            s += '0';
        }
        s += (d.getDate()) + " ";

        s += months[d.getMonth()] + " ";

        var year = d.getYear() - 100;
        if (year < 10) {
            s += '0';
        }
        s += year;

        return s;
    }

    function drawCommitCharts(seriesLabels, sparklineLabels, sparklineData, commitsByDay, commitsByHour, activityCalendarYears, activityCalendarData) {

        var dayLabels = ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"];
        var hourLabels = ["00", "01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23"];
        var monthLabels = ["J", "F", "M", "A", "M", "J", "J", "A", "S", "O", "N", "D"];

        var divSparklineName = "sparklineSmall";
        var divSparklineChild = initDiv(divSparklineName);

        var rSmall = Raphael(divSparklineChild, 276, 32);
        rSmall.g.barchart(0, 0, 276, 32, sparklineData, false, {stacked: 1, vgutter: 0, colors: LINE_COLOURS_XY});
        rSmall.path({opacity: .3}, "M" + [0, 32, "l", 276, 0]);

        var divMainName = "mainCanvas";
        var divMainChild = initDiv(divMainName);
        var calendarHeight = 80 + 13 * activityCalendarYears.length;
        var mainHeight = 310 + calendarHeight;

        var r = Raphael(divMainChild, 300, mainHeight);

        // intialise tooltips
        var tooltipSet = r.set();
        for (var l = 0; l < seriesLabels.length; l++) {
            tooltipSet.push(r.text(100, 30 + l * 15, "").attr({fill: getClr(l), "font-weight": 800}));
        }
        tooltipSet.hide();

        var txt = {"text-anchor": "start", "font-size": 11, fill: "#666"};
        r.text(10, 10, "52 week commits volume").attr(txt);
        r.text(10, 110, "Commits by day").attr(txt);
        r.text(10, 200, "Commits by hour").attr(txt);
        r.text(10, 290, "Commit calendar").attr(txt);

        var hin = function () {
            for (var i = 0, ii = this.bars.length; i < ii; i++) {
                tooltipSet[i].attr({text: seriesLabels[i] + ": " + this.bars[i].value});
            }
            tooltipSet.show();
            this.popup = r.g.popupit(this.bars[0].x, getMinY(this.bars), tooltipSet, 2).insertBefore(this).attr({
                fill: "#fff",
                stroke: "#666"
            });
            tooltipSet.insertBefore(this);
        };

        var hin_below = function () {
            for (var i = 0, ii = this.bars.length; i < ii; i++) {
                tooltipSet[i].attr({text: seriesLabels[i] + ": " + this.bars[i].value});
            }
            tooltipSet.show();
            this.popup = r.g.popupit(this.bars[0].x, getMaxY(this.bars), tooltipSet, 0).insertBefore(this).attr({
                fill: "#fff",
                stroke: "#666"
            });
            tooltipSet.insertBefore(this);
        };

        var hout = function () {
            if (this.popup) {
                this.popup.remove();
                tooltipSet.hide();
                delete this.popup;
            }
        };


        r.g.barchart(0, 20, 276, 70, sparklineData, false, {stacked: 1, vgutter: 0, colors: LINE_COLOURS_XY});
        r.path({opacity: .3}, "M" + [0, 90, "l", 276, 0]);

        r.g.barchart(20, 110, 235, 70, commitsByDay, false, {
            stacked: 1,
            vgutter: 15,
            colors: LINE_COLOURS_XY,
            "font-size": 11,
            fill: "#666"
        }).label(dayLabels).hoverColumn(hin, hout);

        r.g.barchart(25, 200, 230, 70, commitsByHour, false, {
            stacked: 1,
            vgutter: 15,
            colors: LINE_COLOURS_XY,
            "font-size": 11,
            fill: "#666"
        }).label(hourLabels).hoverColumn(hin, hout);


        var data = [];
        var xs = [];
        var ys = [];

        for (var i = 0, ii = activityCalendarData.length; i < ii; i++) {
            for (var j = 0, jj = activityCalendarData[j].length; j < jj; j++) {
                xs.push(j);
                ys.push(ii - i);
                data.push(activityCalendarData[i][j]);
            }
        }

        r.g.dotchart(0, 300, 270, calendarHeight, xs, ys, data, {
            symbol: "o",
            max: 6,
            heat: true,
            axis: "0 0 1 1",
            axisxstep: monthLabels.length - 1,
            axisystep: activityCalendarYears.length - 1,
            axisxlabels: monthLabels,
            axisxtype: " ",
            axisytype: " ",
            axisylabels: activityCalendarYears.reverse()
        }).hover(function () {
            this.tag = this.tag || r.g.tag(this.x, this.y, this.value, 0, this.r + 2).insertBefore(this);
            this.tag.show();
        }, function () {
            this.tag && this.tag.hide();
        }).axis.attr({"font-size": 10, fill: "#666"});

        finaliseDiv(divMainName);
        finaliseDiv(divSparklineName);
    }

    FECRU.RAPHAELCHARTS.commitSparkline = function (divName, width, height, queryParams, contextPath) {

        AJS.$.getJSON(contextPath + '/fe/commitSparkline.do', queryParams,
            function (_52) {
                var r = Raphael(divName, width, height);

                r.g.barchart(0, 10, width, height - 10, _52.data, false, {
                    stacked: 1,
                    vgutter: 0,
                    colors: LINE_COLOURS_XY
                });
            });

    };

    FECRU.RAPHAELCHARTS.sidebarCharts = function (data, url) {
        drawLocCharts(data.locDataX, data.locDataY, data.seriesLabelsShort, data.seriesLabelsLong, url);
        drawCommitCharts(data.seriesLabelsShort, data.sparklineLabels, data.sparklineData, data.commitsByDay, data.commitsByHour, data.activityCalendarYears, data.activityCalendarData);
    };

    FECRU.RAPHAELCHARTS.sidebarChartsAjax = function (queryParams, contextPath, url) {

        AJS.$.getJSON(contextPath + '/fe/sidebarChartsJson.do', queryParams,
            function (data) {
                FECRU.RAPHAELCHARTS.sidebarCharts(data, url);
            });
    };


})();

/*[{!raphaelCharts_js_nulc542!}]*/;
/* END /2static/script/fecru/raphaelCharts.js */
/* START /2static/script/fe/fisheye-changeset-nav.js */
/**
 * To enabling the changeset page shortcuts 'j' & 'k'.
 *
 * html structure
 *
 *  #panel-target
 *      .stream
 *          .diffPaneChangeset
 *              // a non-diff line
 *              tr
 *              // a diff line
 *              tr.is-diff [data-index]
 *
 */
(function (g, $) {

    var selCodePanel = '#panel-target ';
    var selStream = selCodePanel + '.stream ';
    var selDiffContent = selStream + '.diffPaneChangeset ';
    var $diffs;
    var currDiffIndex;
    var $panel;
    var scrollPendingCallback;

    // true if there is currently a scrolling animation happening
    var isScrolling = false;

    var ChangesetNav = function () {
    };

    ChangesetNav.prototype = {
        init: function () {
            $panel = $('#panel-target');
            this.loadDiffs();
        },
        /**
         *
         * @param dir 'next' | 'prev'
         */
        scrollTo: function (dir, isFromPendingScroll) {
            if (!$panel || !$panel.is(":visible")) {
                return;
            }

            // Only one pending scrolling command is stored to avoid jumping crazily between diffs
            // if a user presses the nav keys for many times or continuously holds a key
            var _nav = this;

            if (isScrolling && !isFromPendingScroll) {
                // if it is currently scrolling and is not from pending scroll
                // push it to the next pending scroll
                scrollPendingCallback = function () {
                    _nav.scrollTo(dir, true);
                };
                return;
            }
            isScrolling = true;

            var $target = this.getNextDiff(dir, isFromPendingScroll);
            if (!$target) {
                return;
            }

            $panel
                .scrollTo($target, {
                    axis: 'y',
                    offset: -100,
                    onAfter: function () {
                        isScrolling = false;
                        if (scrollPendingCallback) {
                            // execute and clear next scrolling command
                            scrollPendingCallback();
                            scrollPendingCallback = null;
                        }
                        highlightElement($target);
                    }
                });
        },
        scrollToEdgeOfAll: function (dir) {
            var _this = this;
            _this._onEdgeOfAll(dir, function (isSameFile) {
                if (dir === 'first') {
                    _this.afterSwitchingFile('next', isSameFile);
                } else {
                    _this.afterSwitchingFile('prev', isSameFile);
                }
            });
        },
        /**
         * This method is for binding an onEdgeOfFile event handler.
         * The event will be triggered when scrollToEgdeOfAll() is called
         * It will require the top level js program to switch to the first/last file in the current changeset,
         * and let ChangeNav know when the switch is done.
         *
         * @param callback : function ( dir, edgeFileSelectedCallback )
         */
        bindEdgeOfAll: function (callback) {
            this._onEdgeOfAll = callback;
        },
        /**
         *
         * @param dir : string - 'first' | 'last'
         * @param edgeFileSelectedCallback : function ( isSameFile )
         * @private
         */
        _onEdgeOfAll: function (dir, edgeFileSelectedCallback) {
        },
        /**
         *
         * This method is for binding an onEdgeFile event handler
         * When the edge of a page, either top or bottom, is reached by using navigation shortcuts,
         * this event will be triggered.
         *
         * @param event function( pos )
         * pos: 'start' | 'end'
         */
        bindEdgeOfFile: function (callback) {
            this._onEdgeOfFile = callback;
        },
        /**
         *
         * @param dir : string - 'start' | 'end'
         * @param newFileSelectedCallback : function ( isSameFile )
         * @private
         */
        _onEdgeOfFile: function (dir, newFileSelectedCallback) {
        },
        afterSwitchingFile: function (dir, isSameFile) { // 'next' | 'prev'
            if (!isSameFile) {
                this.init();
            } else {
                if ($diffs.length === 0) {
                    isScrolling = false;
                    return;
                }
            }

            if (dir === 'prev') {
                currDiffIndex = $diffs.length;
                $panel.scrollTo('max', {
                    axis: 'y'
                });
                this.scrollTo('prev', true);
            } else if (dir === 'next') {
                currDiffIndex = -1;
                this.scrollTo('next', true);
            }
        },
        getNextDiff: function (dir, isFromPendingScroll) {
            var _this = this;
            var curr = _this.getCurrentDiffIndex(dir, isFromPendingScroll);
            if (dir === 'next') {
                curr++;
            } else {
                curr--;
            }
            if (curr < 0) {
                _this._onEdgeOfFile('start', function (isSameFile) {
                    _this.afterSwitchingFile('prev', isSameFile);
                });
            } else if (curr >= $diffs.length) {
                _this._onEdgeOfFile('end', function (isSameFile) {
                    _this.afterSwitchingFile('next', isSameFile);
                });
            }

            currDiffIndex = curr;
            return $diffs[currDiffIndex];
        },
        getCurrentDiffIndex: function (dir, isFromPendingScroll) {

            if (currDiffIndex < 0) {
                var closestDiffIndex = 0;
            } else if (currDiffIndex >= $diffs.length) {
                closestDiffIndex = $diffs.length - 1;
            } else {
                closestDiffIndex = currDiffIndex;
            }

            var $currDiff = $diffs[closestDiffIndex];
            if (!$currDiff) {
                return -1;
            }

            var currTop = $currDiff.position().top;
            var panelHeight = $panel.height();

            if (isFromPendingScroll || (currTop >= 0 && currTop <= panelHeight)) {
                return currDiffIndex;
            } else {
                for (var i = 0; i < $diffs.length; i++) {
                    if ($diffs[i].position().top > 0) {
                        currDiffIndex = i;
                        break;
                    }
                }

                if (dir === 'next') {
                    currDiffIndex--;
                } else {
                    currDiffIndex++;
                }
            }
            return currDiffIndex;

        },
        loadDiffs: function () {
            $diffs = [];
            var $tmpDiffs = $(selDiffContent).find('.is-diff');

            var prevIndex = -2;
            $tmpDiffs.each(function () {
                var $t = $(this);

                var ind = $t.attr('data-index');
                if (ind !== prevIndex + 1) {
                    $diffs.push($t);
                }
                prevIndex = parseInt(ind);
            });

            currDiffIndex = -1;
            return $diffs;
        }
    };

    // this function is also in crucible-ui
    var highlightElement = function ($elem) {
        $elem.children('td:visible').effect('highlight', {color: '#fffee8'}, 1000, function () {
            $(this).css('background-color', '');
        });
    };

    g.ChangesetNav = ChangesetNav;

})(window, AJS.$);
/*[{!fisheye_changeset_nav_js_16ci529!}]*/;
/* END /2static/script/fe/fisheye-changeset-nav.js */
/* START /2static/script/fe/fisheye-ui.js */
window.FE = window.FE || {};
FE.UI = FE.UI || {};
(function ($) {
    /**
     * Converts an id to a jquery object.
     *
     * @param el an element id, a jquery id selector (starting with '#'), or a jquery elem
     * @return an object
     */
    var ensureObject = function (el) {
        if (typeof el === "string") {
            if (el.charAt(0) !== "#") {
                el = '#' + el;
            }
            el = AJS.$(el);
        }

        return el;
    };

    /**
     * Returns the minimum height of an element (el) so that it is always at least at
     * the height of its parent element, and optionally takes into account the height/s of
     * any siblings when el is not specified as onlyChild.
     *
     * onlyChild should be used either where el has no sibling element, or where you want
     * el to not consider its siblings - where el and siblings might be floated, for example.
     *
     */
    var elementGetMinHeight = function (el, onlyChild) {
        var element = ensureObject(el);
        if (element.length === 0) {// If element doesn't exist on the page a length of 0 will be returned
            return 0
        }

        var parentHeight = AJS.$(window).height();
        var siblingsHeight = 0;

        if (!onlyChild) {
            var siblings = element.siblings();
            var siblingsCount = siblings.size();

            for (var i = 0; i < siblingsCount; i += 1) {
                var sibling = siblings.eq(i);
                if (sibling.is(":visible") && sibling.css('position').toLowerCase() !== 'absolute') {
                    siblingsHeight += sibling.outerHeight(true);
                }
            }
        }

        return parseInt(parentHeight, 10) - parseInt(siblingsHeight, 10);
    };
    FE.elementGetMinHeight = elementGetMinHeight;

    /**
     * Sets the minimum height of an element (el) to "height" and works hand in hand with
     * elementGetMinHeight.
     *
     * Rather than being part of a larger function which might set _and_ get, this usage
     * allows other functions to utilize the method, without having to determine el's parent and/or
     * sibling elements.
     *
     */
    var elementSetMinHeight = function (el, height) {
        var element = ensureObject(el);

        element.css({
            minHeight: outerHeightProperties(el, height)
        })
    };

    /**
     * Sets the height of an element (el) to "height" and works hand in hand with
     * elementGetMinHeight.
     *
     * Rather than being part of a larger function which might set _and_ get, this usage
     * allows other functions to utilize the method, without having to determine el's parent and/or
     * sibling elements.
     *
     */
    var elementSetHeight = function (el, height) {
        var element = ensureObject(el);

        element.height(outerHeightProperties(el, height))
    };

    /**
     * Determines whether an element (el) has style proprties that affect its outerHeight(true) value
     *
     * You can't set outerHeight so we need to take outerHeight effecting properties in to account, so we
     * accept a height parameter, test for any "outer" properties, and subtract any we find from the height given
     *
     */

    var outerHeightProperties = function (el, height) {
        var element = ensureObject(el);
        var outerProperties = ["borderTopWidth", "borderBottomWidth", "marginTop", "marginBottom", "paddingTop", "paddingBottom"];
        var properties = 0;

        for (var i = 0, l = outerProperties.length; i < l; i += 1) {
            var property = parseInt(element.css(outerProperties[i]), 10);

            if (property) {
                properties += property;
            }
        }

        return height - properties;
    };
    FE.outerHeightProperties = outerHeightProperties;

    var ieWidth = -1;
    var ieHeight = -1;

    var scrollbarWidth;
    var getScrollbarWidth = function () {
        if (!scrollbarWidth) {
            var div = AJS.$('<div style="width:50px;height:50px;overflow:hidden;position:absolute;top:-200px;left:-200px;"><div style="height:100px;"></div>');
            // Append our div, do our calculation and then remove it
            AJS.$('body').append(div);
            var w1 = AJS.$('div', div).innerWidth();
            div.css('overflow-y', 'scroll');
            var w2 = AJS.$('div', div).innerWidth();
            AJS.$(div).remove();
            scrollbarWidth = w1 - w2;
        }
        return scrollbarWidth;
    };

    var calculateStickyPoint = function () {
        STALKING_HEADER.stickyPoint = $('#columns').position().top
            + $('#header').outerHeight(true) + $('.slurp-warning').height();
    };

    var panelsSetMinHeight = function (forceIEResize) {
        if (AJS.$("#atlas").length > 0) {//makes that we only try to force the element sizing on pages that can benefit from it
            if (AJS.$("#columns").length > 0) {//threePanelPAgeContent.tag used
                var viewportHeight = $(window).height();
                var viewportWidth = $(window).width();

                if (FECRU.isChangesetPage) {

                    var $page = $('#page');

                    // calculate the fixed header of the content
                    STALKING_HEADER.commonHeaderHeight = $('.page-sub-header').outerHeight(true); // common fixed header height
                    STALKING_HEADER.contentHeaderHeight = $('#toolbar').outerHeight(true);
                    STALKING_HEADER.sidebarHeaderHeight = 0;
                    STALKING_HEADER.viewportHeight = viewportHeight;
                    var borderWidth = 1;

                    calculateStickyPoint();

                    // the height of footer should also be taken off
                    STALKING_HEADER.footerHeight = $('#footer').outerHeight(true);

                    // get the content height
                    var contentSectionHeight = viewportHeight - STALKING_HEADER.footerHeight - borderWidth;
                    var sidebarSectionHeight = contentSectionHeight - STALKING_HEADER.sidebarHeaderHeight
                        - borderWidth;
                    var contentHeight = contentSectionHeight - STALKING_HEADER.contentHeaderHeight;

                    elementSetHeight("content-navigation-panel", contentSectionHeight);
                    elementSetHeight(AJS.$('#content-resizable'), sidebarSectionHeight);
                    elementSetHeight(AJS.$('#panel-target'), contentHeight);
                } else if (FECRU.isSourcePage) {
                    var columnsHeight = $(window).height() - $('#content > .page-sub-header').outerHeight() - $('#footer').height();
                    var sidebarHeight = columnsHeight - $('#content-column-panel > .content-view').outerHeight();

                    $('#columns').height(columnsHeight);
                    $('#content-navigation-panel').height(sidebarHeight - 2); // 2 for border widths
                } else {
                    var isHorizontalScrollShowing = viewportWidth < AJS.$('#columns').width();

                    var headerHeight = 0;
                    var $header = $('header.aui-page-header');

                    if ($header.length) {
                        headerHeight = $header.outerHeight(true) + ($('div.page-sub-header').outerHeight(true) || 0);
                    } else {
                        headerHeight = $('#content-fixed').outerHeight(true)
                    }
                    headerHeight += $('nav.aui-navgroup-horizontal').outerHeight(true) || 0;

                    elementSetHeight("columns", elementGetMinHeight("#atlas", false)
                        - headerHeight
                        - (isHorizontalScrollShowing ? getScrollbarWidth() : 0)
                    );

                    // Using the specified height, not the computed height (which is what css('height') returns)
                    // So we have to go native (jQuery doesn't have a way to get the actual style for the element).
                    var columnsEl = document.getElementById("columns");
                    var columnHeight = parseInt(columnsEl.style.height, 10) // not .height()
                        - AJS.$("#content-sidebar-head").outerHeight() // Less the branch selector
                        - 2; // Less 2 pixels (from a border i think. Its cheaper hard coding this

                    // If we are on the annotation/diff view, restrict, otherwise let it expand
                    if (FECRU.restrictToWindowHeight) {
                        elementSetHeight("content-navigation-panel", columnHeight);
                        elementSetHeight("column-content", columnHeight);
                    } else {
                        elementSetMinHeight("content-navigation-panel", columnHeight);
                    }
                }
            } else if (AJS.$("#content-single").length > 0) {
                elementSetMinHeight("content-single", AJS.$(window).height()
                    - AJS.$('#header').outerHeight(true)
                    - AJS.$('#footer').outerHeight(true)
                );
            }
            AJS.trigger('fe-page-resize');
            FE.UI.setupStalkingHeader();
        }
    };

    /**
     * Bind a callback that fires when resizing is completed on matching elements.
     *
     * A resize is considered complete after completionDelay ms have passed since
     * the last resize event.
     *
     * This prevents firing the resize event handler multiple times before the resize
     * is actually complete.
     *
     * This should only be being utilised by Snippets pages and TODO deprecate in favour
     * of elementSetMinHeight
     */

    var hasSetupPageFillHeight = false;
    FE.setupPageFillHeight = function ($changeHeight, useMinHeight) {
        if (hasSetupPageFillHeight) {
            return;
        }

        var offset = ($changeHeight) ? $changeHeight.offset().top : 34;

        $changeHeight = $changeHeight || AJS.$("#atlas");
        hasSetupPageFillHeight = true;
        var onResize = function () {
            var windowHeight = AJS.$(window).height();
            var footerHeight = AJS.$("#footer").outerHeight();
            var borderAndPadding = $changeHeight.outerHeight() - $changeHeight.height();

            $changeHeight.css(useMinHeight ? 'min-height' : 'height', windowHeight - footerHeight - offset - borderAndPadding);
        };
        onResize();
        FECRU.UI.setCompletedResizeTimeout(window, onResize);
    };

    var columnResize = function (min) {
        AJS.$("#content-resizable").resizable({
            ghost: true,
            handles: "e",
            maxWidth: 600,
            minWidth: min || 310,
            start: function () {
                AJS.$(".tearout-tabs").append(AJS.$(document.createElement("div")).addClass("ui-resizable-helper"));
            },
            stop: function () {
                AJS.$(".tearout-tabs").children(".ui-resizable-helper").remove();
                AJS.$('#content-sidebar').css('width', AJS.$(this).css('width'));
                AJS.trigger("sidebar-resize");
            }
        });

        // This is being done on mousedown/mouseup instead of resizable.start/stop because of
        // strange behavior in Chrome (possibly others). The cursor switches to text during resize
        // instead of remaining e-resize. I don't know why.
        var selector = "#content-resizable .ui-resizable-handle, #content-shield, .shielded";
        AJS.$(document).delegate(selector, "mousedown", function () {
            AJS.$("html").addClass("shielded");
        }).delegate(selector, "mouseup", function () {
            AJS.$("html").removeClass("shielded");
        });
    };

    var setupWatch = function () {
        var $watchform = AJS.$("#watchform");
        var eventName = "click.watchform";
        if ($watchform.length > 0) {
            var $input = $watchform.children("input");
            AJS.$(".watch-on", $watchform).unbind(eventName).bind(eventName, function (evnt) {
                evnt.preventDefault();
                $input.val('off');
                $watchform.submit();
            });
            AJS.$(".watch-off", $watchform).unbind(eventName).bind(eventName, function (evnt) {
                evnt.preventDefault();
                $input.val('on');
                $watchform.submit();
            });
        }
    };

    var reloadFilePaneAndHeader = function (href) {
        var origUrl = AJS.$("#origUrl").val();
        var $spinner = AJS.$("#file-table-spinner");
        $spinner.removeClass('hidden');
        FECRU.AJAX.ajaxDo(FECRU.pageContext + "/json/fe/loadFilePane.do", {
            href: href,
            origUrl: origUrl
        }, function (resp) {
            if (resp.worked) {
                var replacement = AJS.$.clean([resp.fileTable], document);
                AJS.$("#browse-table").replaceWith(replacement);
                AJS.$("#dirlist-toolbar-bar").replaceWith(resp.taskBarBar);
                AJS.$("header.aui-page-header .aui-page-header-main > .header").replaceWith(resp.contentTitle);

                setupWatch();
                FECRU.RSS.setupRSSDialog();
            }
            $spinner.addClass('hidden');
        }, false);
    };

    /**
     * Find a link in the directory tree by its href
     */
    var $findLink = function (href) {
        return AJS.$("#navigation-tree").find("a.pathLink[href='" + href + "']");
    };

    FE.browseDirectoryPathLinkFunction = function (event) {
        var $node = AJS.$(event.target);
        var href = $node.attr("href");
        var toggled = function () {
        };
        var self = FE.browseDirectoryPathLinkFunction;
        if ($node.hasClass("browse-directory")) {
            // find the node in the tree with the same href as us
            var $selectedLink = $findLink(href);
            FECRU.BROWSE.selectLink($selectedLink, toggled, self);
        } else {
            FECRU.BROWSE.selectLink($node, toggled, self);
        }
        reloadFilePaneAndHeader(href);
        return false;
    };

    FE.setupTable = function (prefix, rowClickFn, extractionFn) {
        FE.resetupTable(prefix, extractionFn);
        FECRU.UI.tableRowClick(prefix, rowClickFn);
    };

    FE.resetupTable = function (prefix, extractionFn) {
        columnResize();
        FECRU.UI.tableSort(prefix, extractionFn);
    };

    FE.toggleTabs = function () {
        AJS.$(document).delegate(".tearout-tabs li", "click", function () {
            var active = AJS.$(this).hasClass("tearout-active") ? true : null;
            var tab = AJS.$(this).attr("class").split("-")[1];
            var panel = "#panel-" + tab;
            var content = AJS.$('#content');

            AJS.$(".tearout-tabs li").each(function () {
                AJS.$(this).removeClass("tearout-active");
                AJS.$(this).children("a").unbind();
            });

            AJS.$(".panel-tearout", "#content-navigation").each(function () {
                AJS.$(this).addClass("hidden");
            });
            // preference will be null if we are ignoring preferences
            var preference = AJS.$(this).children("input").val();
            if (active) {
                content.addClass('collapsed-sidebar');
                // hiding everything
                if (preference) {
                    FECRU.PREFS.setPreference("shp", "N");
                }
                AJS.trigger('sidebar-collapsed');
            } else {
                AJS.$(this).addClass("tearout-active");
                var wasCollapsed = content.hasClass('collapsed-sidebar');
                content.removeClass('collapsed-sidebar');
                AJS.$(panel).removeClass("hidden");
                if (preference) {
                    FECRU.PREFS.setPreferences({slp: preference, shp: "Y"});
                }
                wasCollapsed && AJS.trigger('sidebar-expanded');
            }
            // resize the pane when in changeset view
            if (AJS.$('#section-changeset-view').length > 0) {
                AJS.$(window).resize();
            }
        });
    };

    var hasSetupPanes = false;

    FE.setupPanes = function () {
        if (!hasSetupPanes) {
            columnResize(310);
            hasSetupPanes = true;
        }

        var $bottomToolbar = AJS.$("div.toolbar-bottom");

        if ($bottomToolbar.size() && $bottomToolbar.offset().top < AJS.$(window).height()) {
            $bottomToolbar.hide();
        }
    };

    FE.streamMoreFocus = function () {
        AJS.$(document).delegate("#stream a.more", "click", function () {
            AJS.$(this).closest(".stream").addClass("stream-focus");
            AJS.$("body").one("click", function () {
                AJS.$("#stream").find(".stream").removeClass("stream-focus");
            });
        });
    };

    var hasSetupStalkingHeader = false;
    var STALKING_HEADER = {
        stickyPoint: 0,
        scrollbarZone: 10,
        footerHeight: 0,
        contentHeaderHeight: 0,
        viewportHeight: 0,
        previousScrollType: '',
        changeScrollTypeTimer: undefined
    };
    /**
     * the function should be called when:
     *  size of content changed
     *
     * @param $targetArea
     */
    FE.UI.setupStalkingHeader = function () {
        var recountBodyHeight = function () {
            var contentHeight = $target.children('.stream').outerHeight(true);
            var $body = $('body');
            $body.css('height', Math.max(contentHeight + STALKING_HEADER.stickyPoint
                + STALKING_HEADER.footerHeight
                + STALKING_HEADER.scrollbarZone
                + STALKING_HEADER.contentHeaderHeight,
                STALKING_HEADER.stickyPoint + STALKING_HEADER.viewportHeight));
        };

        if (FECRU.isChangesetPage) {
            var $columns = $('#columns');
            var $window = $(window);
            var $target = $('#panel-target');
            var $footer = $('#footer');
            var $pageSubHeader = $('.page-sub-header');
            var $page = $('#page');


            if (!hasSetupStalkingHeader) {
                var scrollItem = function ($item, value) {
                    $item.scrollTop(value);
                };

                // handle the funny "frozen" scrollbar problem in chrome
                // todo: need to review this some time later review@2014-10 we should remove it once chrome has the issue fixed
                setTimeout(function () {
                    $window.scrollTop(1);
                    $window.scrollTop(0);
                }, 0);

                /**
                 * The previous scroll type is for preventing cycle-calling the scroll event handlers.
                 * @param type 'page' | 'content'
                 * @returns {boolean} true if the event is valid to be run, false if the event handler should not be triggered
                 */
                STALKING_HEADER.setPreviousScrollType = function (type, forceScroll) {
                    if (!forceScroll && STALKING_HEADER.previousScrollType && STALKING_HEADER.previousScrollType !== type) {
                        return false;
                    }

                    STALKING_HEADER.previousScrollType = type;
                    clearTimeout(STALKING_HEADER.changeScrollTypeTimer);
                    STALKING_HEADER.changeScrollTypeTimer = setTimeout(function () {
                        STALKING_HEADER.previousScrollType = '';
                    }, 300);
                    return true;
                };

                // binding scrolling event here
                STALKING_HEADER.windowScrollTopCallback = _.throttle(function () {
                    if (!STALKING_HEADER.setPreviousScrollType('page')) {
                        return;
                    }
                    var scrollTop = $window.scrollTop();
                    var $target = $('#panel-target');

                    if (scrollTop > STALKING_HEADER.stickyPoint) {

                        var contentScrollTop = scrollTop - STALKING_HEADER.stickyPoint;
                        $target.scrollTop(contentScrollTop);
                        $page.scrollTop(STALKING_HEADER.stickyPoint);
                    } else {
                        $target.scrollTop(0);
                        $page.scrollTop(scrollTop);
                    }
                }, 20, {
                    trailing: true
                });

                /**
                 * forceScroll - when the file is changed, we need to force synchronise the scrollbars
                 * @type {*}
                 */
                STALKING_HEADER.panelScrollTopCallback = _.throttle(function (e, forceScroll) {
                    if (!STALKING_HEADER.setPreviousScrollType('content', forceScroll)) {
                        return;
                    }
                    var $target = $('#panel-target');
                    var targetScrollTop = $target.scrollTop();

                    $page.scrollTop(STALKING_HEADER.stickyPoint);
                    $window.scrollTop(targetScrollTop + STALKING_HEADER.stickyPoint);
                }, 30, {
                    trailing: true
                });

                FE.UI.scrollPanelTarget = function (forceScroll) {
                    STALKING_HEADER.panelScrollTopCallback(null, forceScroll);
                };

                $window.scroll(STALKING_HEADER.windowScrollTopCallback);
                hasSetupStalkingHeader = true;
            }

            $('#panel-target')
                .unbind('scroll.stalking-header')
                .bind('scroll.stalking-header', function (e, force) {
                    var $self = $(this);
                    var selfScrollTop = this.scrollTop;

                    if ($self.data('lastScrollTop') === selfScrollTop) {
                        return;
                    }
                    $self.data('lastScrollTop', selfScrollTop);

                    STALKING_HEADER.panelScrollTopCallback(e, force);
                })
                .data('lastScrollTop', 0);

            $(document).on('aui-message-close', function (event, message) {
                // Once again - trick to detect whether analytics message has been closed
                if (typeof message === 'undefined') {
                    calculateStickyPoint();
                    recountBodyHeight();
                }
            });
            recountBodyHeight();
            STALKING_HEADER.windowScrollTopCallback();
        }
    };

    AJS.$(function () {
        // Give a warning if firebug is running
        FECRU.UI.warnAboutFirebug(function () {
            AJS.$(window).resize();
        });

        panelsSetMinHeight();
        // this lazy repaint is to fix the problem in ie and in same case the nav height cannot be got correctly
        setTimeout(function () {
            panelsSetMinHeight(true);
        }, 0);

        var panelsSetMinHeightWithThrottle = _.throttle(panelsSetMinHeight, 200, {
            trailing: true
        });
        $(window).resize(panelsSetMinHeightWithThrottle);

        var events = [
            'barracuda-ui-updated', 'commit-message-toggled'
        ];
        AJS.bind(events.join(' '), panelsSetMinHeightWithThrottle);

        //setup the watch links
        setupWatch();

        FE.setupPanes();

        if (!AJS.$.support.opacity) {
            FE.streamMoreFocus();
        }
    });
})(AJS.$);
/*[{!fisheye_ui_js_2o9r52d!}]*/;
/* END /2static/script/fe/fisheye-ui.js */
/* START /2static/script/fe/fisheye-changeset.js */
if (!FE.CHANGESET) {
    FE.CHANGESET = {};
}
(function (eventBusProvider) {
    var isInitialised = false;
    var currentPageNo = 0;

    /**
     * Set a property to indicate that the live events etc for the changeset page have been set up
     * @param newValue
     */
    var initialised = function (newValue) {
        if (newValue === undefined) {
            return isInitialised;
        }
        isInitialised = newValue;
        return newValue;
    };

    var pages = {};
    var pagesRequested = {};
    var currentPageRequest;

    var reloadChangesetPage = function (page, fileReloadCallback) {
        currentPageRequest = page;
        var beforeAjax = function () {
            var $panelTarget = AJS.$("#panel-target");
            var replacement = AJS.$('<div id="panel-target"><div></div></div>');
            FECRU.AJAX.startSpin(replacement.children('div'), 'source', true);
            replacement.css('height', $panelTarget.css('height'));
            $panelTarget.replaceWith(replacement);
        };

        var done = function (replacement) {
            if (currentPageRequest === page) {
                var $panelTarget = AJS.$("#panel-target");
                replacement.css('height', $panelTarget.css('height'));
                replacement.css('width', $panelTarget.css('width'));
                $panelTarget.replaceWith(replacement);
                setCurrentPageNo(page);
            }
        };
        var complete = function (isSameFile) {
            if (fileReloadCallback) {
                fileReloadCallback(isSameFile, currentPageRequest);
            } else {
                _onFileSelected(isSameFile, currentPageRequest);
            }
        };
        ajaxLoadChangeset(page, beforeAjax, done, complete);
    };

    var ajaxLoadChangeset = function (page, beforeAjax, done, complete) {
        if (page < 1 || page > getNoOfPages()) {
            return;
        }
        var csid = AJS.$("#csid").val();
        var currentPage = getCurrentPageNo();
        if (currentPage !== page) {
            var replacement = pages[page];
            if (replacement) {
                done && done(replacement);
                if (complete) {
                    complete(false);
                }
            } else {
                pagesRequested[page] = true;
                beforeAjax && beforeAjax();
                var params = {href: AJS.$("#baseClUrl").val(), csid: csid, pageNum: page};
                FECRU.AJAX.ajaxDo(FECRU.pageContext + "/json/fe/loadChangesetPage.do", params, function (resp) {
                    if (resp.worked) {
                        var replacement = AJS.$(AJS.$.clean([resp.changesetPage], document));
                        pages[page] = replacement;
                        done && done(replacement);
                        if (complete) {
                            complete(false);
                        }
                    }
                }, false);
            }
        } else {
            if (complete) {
                complete(true);
            }
        }
    };

    function getCurrentPageNo() {
        return currentPageNo;
    }

    function getNoOfPages() {
        return parseInt(AJS.$("#noOfPages").val(), 10);
    }

    function setNavClass(selector, enabled) {
        var links = AJS.$("span.cs-page a").filter(selector);
        if (enabled) {
            links.removeClass("disabled");
        } else {
            links.addClass("disabled");
        }
    }

    function setCurrentPageNo(newPageNo) {
        currentPageNo = newPageNo;
        setNavClass(".pagination-back, .pagination-first", newPageNo !== 1);
        setNavClass(".pagination-next, .pagination-last", newPageNo !== getNoOfPages());
    }

    function getAttrValue(node, name) {
        return node.children("input[name='" + name + "']").val();
    }

    FE.CHANGESET.changesetFileLinkFn = function (event) {
        var $node = AJS.$(event.target);
        if ($node.is('.fileLink')) {
            var $next = $node.closest('.file-li');
        } else {
            $next = FE.CHANGESET.getNextFile('#tree-root .file-li', $node);
        }
        FE.CHANGESET.selectNextFile($next, 1, 1);
        return false;
    };

    FE.CHANGESET.selectNextFile = function ($next, before, after, fileReloadCallback) {
        var $prev = AJS.$('#tree-root').find('.focused.tree-li').removeClass('focused');
        if ($prev.size()) {
            cancelPrevHightlights($prev.children('span'));
        }

        $next.addClass('focused');

        var $node = $next.children('span.file').children('a.fileLink:first');
        if ($node == null || $node.length === 0) {
            return false;
        }

        var page = parseInt(getAttrValue($node, "page"), 10);

        eventBusProvider().trigger('source-code:hidden', {key: page});

        reloadChangesetPage(page, fileReloadCallback);
        before = before || 0;
        after = after || 0;
        for (var i = 1; i <= before && page - i >= 1; i++) {
            if (!pagesRequested[page - i]) {
                ajaxLoadChangeset(page - i);
            }
        }
        var noOfPages = getNoOfPages();
        for (i = 1; i <= after && page + i <= noOfPages; i++) {
            if (!pagesRequested[page + i]) {
                ajaxLoadChangeset(page + i);
            }
        }

        return true;
    };

    FE.CHANGESET.changesetPathLinkFn = FE.CHANGESET.changesetFileLinkFn;

    FE.CHANGESET.changesetSubTreeArgs = function ($node) {
        return {csid: AJS.$("#csid").val()}
    };

    /**
     * Sets up the two detail blocks in the Changeset page and establishes the click responses and stickiness
     */
    function augmentDetails() {
        var $details = AJS.$("#changeset-details");
        var $terse = $details.children("h1.details-terse").children("span");
        var $verbose = $details.children("div.details-verbose");
        var $links = $details.find("a");
        var expandCsHeaderPref = 'xcsh';

        /**
         * Targets the single line "heading" and adds a click response to reveal the full details.
         * The !e.altKey checks the event properties to ensure that the alt/option key isn't being pressed. This
         * facilitates copy + paste actions
         */
        $terse.click(function (e) {
            if (!e.altKey && e.target.tagName.toLowerCase() !== "a") {
                $details.addClass('expand');
                FECRU.PREFS.setPreference(expandCsHeaderPref, 'Y');
            }
        });

        /**
         * Targets the multi line "details" and adds a click response to return to heading only.
         * The !e.altKey checks the event properties to ensure that the alt/option key isn't being pressed. This
         * facilitates copy + paste actions
         * The e.target checks ensure that only the text of the first line of the details will trigger the toggle
         */
        $verbose.click(function (e) {
            var target = e.target.tagName.toLowerCase();
            if (!e.altKey && target !== "a" && target !== "div") {
                if (target !== "p" || AJS.$(e.target).is(":first-child")) {
                    $details.removeClass('expand');
                    FECRU.PREFS.setPreference(expandCsHeaderPref, 'N');
                }
            }
        });

        /**
         * stops the link from firing if the user is trying to copy the link and also
         * stops the changelog commit message toggling so it won't bump if you're trying
         * to leave the page.
         */
        $links.click(function (e) {
            var $this = AJS.$(this);
            if (e.altKey || $this.hasClass('jira-hover-trigger') || $this.parent().hasClass('jira-hover-trigger')) {
                e.preventDefault();
                return true;
            }

            e.stopPropagation();
        });
    }

    /**
     * Maintains the UI show/hide principles by checking to see whether this element has any non-whitespace content
     * and displaying if any is found.
     */

    function showCustomDetails() {
        var $custom = AJS.$("td.custom-details");
        var $customDetails = $custom.find("dd");
        var customDetailsHtml = $customDetails.html();
        var details = false;

        if (customDetailsHtml && customDetailsHtml.replace(/\s/g, "").length > 0) {
            $custom.show();
        }
    }


    var _onFileSelected = function () {
    };

    // This is for binding the default onFileSelected callback.
    // The callback function will be triggered after reloadChangesetPage() successfully loads a file.
    FE.CHANGESET.bindFileSelected = function (callback) {
        _onFileSelected = callback;
    };

    FE.CHANGESET.init = function () {
        if (!initialised()) {
            var selectNextFile = false;
            if (getNoOfPages() > 0) {
                var selectNextFile = FE.CHANGESET.selectNextFile(AJS.$('#tree-root .file-li:first'), 0, 4);
            }

            if (!selectNextFile) {
                var $panelTarget = AJS.$("#panel-target");
                $panelTarget.addClass("inactive");
                $panelTarget.find(" .source").removeClass("spinner");
            }
            augmentDetails();
            showCustomDetails();

            var ajsFecruUi = FECRU.UI;

            ajsFecruUi.registerMetadataExpanders(AJS.$(".changeset-head"));

            initialised(true)
        }
    };

    FE.CHANGESET.getFirstFile = function (selector) {
        return FE.CHANGESET.getNextFile(selector);
    };

    FE.CHANGESET.getLastFile = function (selector) {
        return FE.CHANGESET.getPrevFile(selector);
    };

    FE.CHANGESET.getNextFile = function (selector, $focused) {
        var index;
        var items = jQuery(selector).add($focused);

        if (!$focused || $focused.length === 0) {
            $focused = jQuery(selector + ":first");
        } else {
            index = jQuery.inArray($focused.get(0), items);
            if (index < items.length - 1) {
                index = index + 1;
                $focused = items.eq(index);
            } else {
                $focused = jQuery(selector + ":first");
            }
        }
        return $focused;
    };

    FE.CHANGESET.getPrevFile = function (selector, $focused) {
        var index;
        var items = jQuery(selector).add($focused);

        if (!$focused || $focused.length === 0) {
            $focused = jQuery(selector + ":last");
        } else {
            index = jQuery.inArray($focused.get(0), items);
            if (index > 0) {
                index = index - 1;
                $focused = items.eq(index);
            } else {
                $focused = jQuery(selector + ":last");
            }
        }
        return $focused;
    };

    var cancelPrevHightlights = function ($elem) {
        $elem.stop().css('background-color', '');
    }
})(
    function () {
        return FECRU.eventBus
    }
);
/*[{!fisheye_changeset_js_lcm852a!}]*/;
/* END /2static/script/fe/fisheye-changeset.js */
/* START /2static/script/fe/fisheye-history.js */
(function ($) {

    var article = FE.ARTICLE;

    var revIdKey = 'revision-id';

    var revisionIdForRow = function ($revision) {
        return $revision.data(revIdKey);
    };

    var rowForRevisionId = function (revisionId) {
        return $("#revision-" + revisionId).closest(".revision");
    };

    // Cache the focused row as it can be too slow to do $("tr.history-focus");
    var $focusedRow;
    var focusedRevisionData;
    var blurFocusedRow = function () {
        if ($focusedRow && focusedRevisionData) {
            focusedRevisionData.focussed = false;
            $focusedRow.removeClass("history-focus");
        }
    };

    var setRowFocus = function (revisionData) {
        blurFocusedRow();

        //make the switch
        focusedRevisionData = revisionData;
        $focusedRow = rowForRevisionId(revisionData.id);

        //focus the new
        focusedRevisionData.focussed = true;
        if ($focusedRow.length) {
            $focusedRow.addClass("history-focus");
            $(window).scrollTo(rowForRevisionId(focusedRevisionData.id), {
                axis: 'y',
                offset: -50
            });
        } else {
            var pageToLoad = getPageForRevisionId(focusedRevisionData.id);
            if (pageToLoad != null) {
                loadRevisionsPage(pageToLoad, focusedRevisionData.id);
            } else {
                //TODO: Remove our js error handling from the FECRU."AJAX" namespace...
                FECRU.AJAX.appendErrorMessage("Couldn't find the revision " + revisionData.revision + ".  Try reloading.");
                FECRU.AJAX.showErrorBox();
            }
        }
    };

    var revisionDataForId = function (revisionId) {
        var arrayIndex = historyTableData.revisionKeyValueIndexMap[revisionId];
        return historyTableData.revisions[arrayIndex];
    };

    var setRevisionDataCheckedFlag = function (revision, value) {
        var revisionId = historyTableData.revisionToRevisionIdMap[revision];
        var revisionData = revisionDataForId(revisionId);

        revisionData.checked = value;
    };

    /**
     * Handle revisions selection change and update the UI according to it.
     */
    var setupDiffCheckboxes = function () {
        var $revisions = $('#history-revisions');
        var $diffButton = $('#diff-selected-button');
        var baseUrl = $diffButton.data('baseurl');
        var queue = [];

        var setRevisionInputCheckedFlag = function (revision, value) {
            $revisions.find('.revision-check[value="' + revision + '"]').prop('checked', value);
        };

        var getRevisionIndexInQueue = function (revision) {
            return queue.indexOf(revision);
        };

        var diffButtonClickHandler = function () {
            var href = $diffButton.data('href');
            if (href) {
                window.location.href = href;
            }
        };

        var revisionSelectionChangeHandler = function () {
            var revision = this.value;
            var revisionInQueueIndex = getRevisionIndexInQueue(revision);
            var isInQueue = revisionInQueueIndex !== -1;
            var toBeUnchecked = [];

            setRevisionDataCheckedFlag(revision, this.checked);

            if (this.checked) {
                queue.push(revision);
            } else if (isInQueue) {
                toBeUnchecked.push.apply(toBeUnchecked, queue.splice(revisionInQueueIndex, 1));
            }

            if (queue.length > 2) {
                toBeUnchecked.push.apply(toBeUnchecked, queue.splice(0, queue.length - 2));
            }

            toBeUnchecked.forEach(function (revision) {
                setRevisionDataCheckedFlag(revision, false);
                setRevisionInputCheckedFlag(revision, false);
            });

            var r1 = queue[0];
            var r2 = queue[1];
            var isQueueLengthValid = queue.length === 2;
            var title = isQueueLengthValid ?
                'View the diff between ' + r1 + ' and ' + r2 :
                'Select two revisions to view their diff';

            $diffButton
                .data('href', baseUrl + '?r1=' + r1 + '&r2=' + r2)
                .attr('aria-disabled', !isQueueLengthValid)
                .prop('disabled', !isQueueLengthValid)
                .prop('title', title);
        };

        $diffButton.on('click', diffButtonClickHandler);
        $revisions.on('change', '.revision-check', revisionSelectionChangeHandler);
    };

    var getRevisionFromUrl = function () {
        var hash = document.location.hash;
        if (!hash) {
            return null;
        }
        // remove the '#r' from the anchor
        return hash.substring(2);
    };

    var getRevisionIdFromUrl = function () {
        return historyTableData.revisionToRevisionIdMap[getRevisionFromUrl()];
    };

    var setupFocusedRevision = function (revisionIdToFocus) {
        if (!revisionIdToFocus) {
            return;
        }

        var revisionData = revisionDataForId(revisionIdToFocus);
        setRowFocus(revisionData);
    };

    var currentPage = null;
    var REVISIONS_PER_PAGE = 30;

    var getTotalPageCount = function () {
        return Math.ceil(historyTableData.revisions.length / REVISIONS_PER_PAGE);
    };

    /**
     * Ensures that the navigation buttons (next/previous revisions) are synchronised -- ie, that they are enabled/disabled
     * when required.
     */
    var syncPaginationButtons = function () {
        var $firstLink = $("a.pagination-first");
        var $prevLink = $("a.pagination-back");
        var $nextLink = $("a.pagination-next");
        var $lastLink = $("a.pagination-last");

        var totalPageCount = getTotalPageCount();
        var show = true;

        if (totalPageCount <= 1) {
            $firstLink.addClass("disabled");
            $prevLink.addClass("disabled");
            $nextLink.addClass("disabled");
            $lastLink.addClass("disabled");
            show = false;
        } else if (currentPage <= 1) {
            $firstLink.removeClass("disabled");
            $prevLink.removeClass("disabled");
            $nextLink.addClass("disabled");
            $lastLink.addClass("disabled");
        } else if (currentPage >= totalPageCount) {
            $firstLink.addClass("disabled");
            $prevLink.addClass("disabled");
            $nextLink.removeClass("disabled");
            $lastLink.removeClass("disabled");
        } else {
            $firstLink.removeClass("disabled");
            $prevLink.removeClass("disabled");
            $nextLink.removeClass("disabled");
            $lastLink.removeClass("disabled");
        }
        var topPagination = $("span.taskbar-pagination");
        var bottomPagination = $("div.toolbar-bottom");
        if (show) {
            topPagination.show();
            bottomPagination.show();
        } else {
            topPagination.hide();
            bottomPagination.hide();
        }

        $(".pagination-text").text(currentPage + "/" + totalPageCount);
    };

    function getPageForRevisionId(revisionId) {
        var revIndex = null;
        Array.first(historyTableData.revisions, function (revision, index) {
            if (revision.id === revisionId) {
                revIndex = index;
                return true;
            }
            return false;
        });
        if (revIndex === null) {
            return null;
        }

        return Math.floor(revIndex / REVISIONS_PER_PAGE) + 1;
    }

    /**
     * Loads revisions into the history table for display. This method will lazily load extra information from the server
     * if it isn't available locally (such as rendered commit messages).
     * @param pageNumber page to render
     */
    var loadRevisionsPage = function (pageNumber, revisionIdToFocus) {
        if (currentPage === pageNumber) {
            throw new Error("Trying to load current page.");
        }

        pageNumber = pageNumber || 1;
        currentPage = pageNumber;

        var totalPageCount = getTotalPageCount();
        if (pageNumber > totalPageCount) {
            pageNumber = totalPageCount;
        }

        blurFocusedRow();

        var allRevisions = historyTableData.revisions;
        var $historyTable = $("#history-revisions");
        $historyTable
            .removeClass("data-loaded")
            .addClass("data-loading")
            .empty();

        var startPoint = (pageNumber - 1) * REVISIONS_PER_PAGE;
        if (startPoint < 0) {
            startPoint = 0;
        }
        var endPoint = startPoint + REVISIONS_PER_PAGE;

        var revIdsToLoad = [];

        for (var c = 0, i = startPoint, revCount = allRevisions.length;
             i < endPoint && i < revCount;
             i++, c++) {
            var rev = allRevisions[i];

            if (!rev.loaded) {
                revIdsToLoad.push(rev.id);
            }
        }

        syncPaginationButtons();

        loadRevisionData(revIdsToLoad, function () {
            var $revisionElementsToInsert = $([]);

            for (var c = 0, i = startPoint, revCount = allRevisions.length;
                 i < endPoint && i < revCount;
                 i++, c++) {
                var rev = allRevisions[i];

                var $revElem = $(rev.htmlContent).data(revIdKey, rev.id);
                article.setExpanded($revElem, !rev.collapsed);

                if (rev.focussed) {
                    $revElem.addClass("history-focus");
                }

                $revisionElementsToInsert.push($revElem.get(0));
            }
            $historyTable.append($revisionElementsToInsert);

            $historyTable
                .addClass("data-loaded")
                .removeClass("data-loading");


            if (revisionIdToFocus) {
                setupFocusedRevision(revisionIdToFocus);
            }
        });
    };

    /**
     * Sends a list of revisions to the server for extra data which is required for displaying complete data for each
     * revision to the user. Upon completion of the ajax call, retrieved data is stored locally for later reuse.
     * @param revisions array of revisions to complete
     * @param onDone callback function
     */
    var loadRevisionData = function (revisions, onDone) {
        if (!revisions || revisions.length === 0) {
            onDone && onDone();
            return;
        }
        var done = function (resp) {
            var revs = resp.revisions;
            if (!revs) {
                return;
            }
            for (var i = 0, len = revs.length; i < len; i++) {
                var rev = revs[i];

                // Update the data structure
                var revisionData = revisionDataForId(rev.id);

                revisionData.htmlContent = rev.htmlContent;
                revisionData.loaded = !!revisionData.htmlContent;
            }
            onDone && onDone();
        };

        var params = {
            content: true,
            rev: revisions
        };

        var pathName = window.location.pathname;
        pathName = pathName.substring(FECRU.pageContext.length);
        var url = FECRU.pageContext + "/json" + pathName;

        FECRU.AJAX.ajaxDo(url, params, done);
    };

    /**
     * Create a map between each revision id and it's index in the {{historyTableData.revisions}} array. This method
     * should be called whenever the order of the revisions data is changed, such as on sorting.
     *
     * This data structure is used so that we can efficiently look up revisionData objects and update them as we lazily
     * retrieve expensive data from the server.
     */
    var createRevisionKeyIndexMap = function () {
        var allRevisions = historyTableData.revisions;
        var revisionKeyValueIndexMap = {};
        var revisionToRevisionIdMap = {};
        if (allRevisions) {
            for (var i = 0, len = allRevisions.length; i < len; i++) {
                var rev = allRevisions[i];
                revisionKeyValueIndexMap[rev.id] = i;
                revisionToRevisionIdMap[rev.revision] = rev.id;
            }
        }
        historyTableData.revisionKeyValueIndexMap = revisionKeyValueIndexMap;
        historyTableData.revisionToRevisionIdMap = revisionToRevisionIdMap;
    };

    var expandCollapseCallback = function ($article, isExpanded) {
        var revData = revisionDataForId(revisionIdForRow($article));
        revData.collapsed = !isExpanded;
    };

    FE.setupFileHistoryPage = function () {
        createRevisionKeyIndexMap();

        setupDiffCheckboxes();

        var pageNumberToLoad = 1; // We start at 1
        var revisionIdToLoad = getRevisionIdFromUrl();
        if (revisionIdToLoad) {
            var arrayIndexToLoad = historyTableData.revisionKeyValueIndexMap[revisionIdToLoad];
            pageNumberToLoad = Math.floor(arrayIndexToLoad / REVISIONS_PER_PAGE) + 1; // pageNumber starts at 1
        }

        loadRevisionsPage(pageNumberToLoad, revisionIdToLoad);

        $("a.pagination-back").click(function () {
            if ($(this).hasClass("disabled")) {
                return false;
            }
            loadRevisionsPage(currentPage + 1); // next page
            return false;
        });
        $("a.pagination-next").click(function () {
            if ($(this).hasClass("disabled")) {
                return false;
            }
            loadRevisionsPage(currentPage - 1); // previous page
            return false;
        });
        $("a.pagination-last").click(function () {
            if ($(this).hasClass("disabled")) {
                return false;
            }
            loadRevisionsPage(1); // last page
            return false;
        });
        $("a.pagination-first").click(function () {
            if ($(this).hasClass("disabled")) {
                return false;
            }
            var totalPageCount = getTotalPageCount();
            loadRevisionsPage(totalPageCount); // first page
            return false;
        });

        var $historyRevisions = $("#history-revisions");

        article.initialize($historyRevisions, {
            expandCollapseCallback: expandCollapseCallback
        });

        $('#expand-all-revisions').on('click', function () {
            var allRevisions = historyTableData.revisions;
            var hasRevisions = allRevisions && allRevisions.length > 0;
            if (hasRevisions) {
                var $el = $(this).toggleClass('active');
                var shouldExpand = $el.hasClass('active');
                var $articles = $historyRevisions.children('.article');

                article.setAllExpanded($articles, shouldExpand);

                allRevisions.forEach(function (rev) {
                    rev.collapsed = shouldExpand;
                });
            }
        });

        FECRU.UI.registerMetadataExpanders($historyRevisions);

        // handle IE7 z-index bug for positioned elements
        if ($.browser.msie && $.browser.version < 8) {
            $(".aui-dd-link").live("click", function () {
                var $this = $(this);

                // restore the default z-index for all the revisions
                $(".revision.ie-zindex-fixer").removeClass("ie-zindex-fixer");

                // make the parent revision above the subsequent one(s) and the dropdown above the subsequent "more" button
                var $revision = $this.closest(".revision").addClass("ie-zindex-fixer");

                // bind a IE-specific event handler to know when the dropdown becomes hidden
                // (unbind first to prevent duplicate bindings if the user clicks several times)
                var dropdown = $(this).siblings(".aui-dropdown");
                dropdown.unbind("propertychange").bind("propertychange", function () { // does not work with .live()
                    var $dropdown = $(this);
                    if ($dropdown.is(":not(:visible)")) {
                        $revision.removeClass("ie-zindex-fixer");
                        $dropdown.unbind("propertychange");
                    }
                });
            });
        }

        // setup local-link links
        $(document).delegate("a.local-link", 'click', function (e) {
            var href = $(this).attr("href");
            var revision = href.substring(href.lastIndexOf("#") + 2);
            var revisionId = historyTableData.revisionToRevisionIdMap[revision];
            var revisionData = revisionDataForId(revisionId);
            if (revisionId) {
                setRowFocus(revisionData);
            }
            e.preventDefault();
        });
    };

    // Following methods not used for the file history - move them elsewhere
    FE.fileHistoryPathLinkFn = function (event) {
        event.stopPropagation();
        return true;
    };
})(AJS.$);
/*[{!fisheye_history_js_rk6s52b!}]*/;
/* END /2static/script/fe/fisheye-history.js */
/* START /2static/script/lib/json2.min.js */
/* json2.js
 * 2008-01-17
 * Public Domain
 * No warranty expressed or implied. Use at your own risk.
 * See http://www.JSON.org/js.html
*/
if(!this.JSON){JSON=function(){function f(n){return n<10?'0'+n:n;}
Date.prototype.toJSON=function(){return this.getUTCFullYear()+'-'+
f(this.getUTCMonth()+1)+'-'+
f(this.getUTCDate())+'T'+
f(this.getUTCHours())+':'+
f(this.getUTCMinutes())+':'+
f(this.getUTCSeconds())+'Z';};var m={'\b':'\\b','\t':'\\t','\n':'\\n','\f':'\\f','\r':'\\r','"':'\\"','\\':'\\\\'};function stringify(value,whitelist){var a,i,k,l,r=/["\\\x00-\x1f\x7f-\x9f]/g,v;switch(typeof value){case'string':return r.test(value)?'"'+value.replace(r,function(a){var c=m[a];if(c){return c;}
c=a.charCodeAt();return'\\u00'+Math.floor(c/16).toString(16)+
(c%16).toString(16);})+'"':'"'+value+'"';case'number':return isFinite(value)?String(value):'null';case'boolean':case'null':return String(value);case'object':if(!value){return'null';}
if(typeof value.toJSON==='function'){return stringify(value.toJSON());}
a=[];if(typeof value.length==='number'&&!(value.propertyIsEnumerable('length'))){l=value.length;for(i=0;i<l;i+=1){a.push(stringify(value[i],whitelist)||'null');}
return'['+a.join(',')+']';}
if(whitelist){l=whitelist.length;for(i=0;i<l;i+=1){k=whitelist[i];if(typeof k==='string'){v=stringify(value[k],whitelist);if(v){a.push(stringify(k)+':'+v);}}}}else{for(k in value){if(typeof k==='string'){v=stringify(value[k],whitelist);if(v){a.push(stringify(k)+':'+v);}}}}
return'{'+a.join(',')+'}';}}
return{stringify:stringify,parse:function(text,filter){var j;function walk(k,v){var i,n;if(v&&typeof v==='object'){for(i in v){if(Object.prototype.hasOwnProperty.apply(v,[i])){n=walk(i,v[i]);if(n!==undefined){v[i]=n;}}}}
return filter(k,v);}
if(/^[\],:{}\s]*$/.test(text.replace(/\\./g,'@').replace(/"[^"\\\n\r]*"|true|false|null|-?\d+(?:\.\d*)?(?:[eE][+\-]?\d+)?/g,']').replace(/(?:^|:|,)(?:\s*\[)+/g,''))){j=eval('('+text+')');return typeof filter==='function'?walk('',j):j;}
throw new SyntaxError('parseJSON');}};}();}/*[{!json2_min_js_em0l54n!}]*/;
/* END /2static/script/lib/json2.min.js */
/* START /2static/script/lib/jquery/plugins/jquery.ba-throttle-debounce.min.js */
/*
 * jQuery throttle / debounce - v1.1 - 3/7/2010
 * http://benalman.com/projects/jquery-throttle-debounce-plugin/
 * 
 * Copyright (c) 2010 "Cowboy" Ben Alman
 * Dual licensed under the MIT and GPL licenses.
 * http://benalman.com/about/license/
 */
(function(b,c){var $=b.jQuery||b.Cowboy||(b.Cowboy={}),a;$.throttle=a=function(e,f,j,i){var h,d=0;if(typeof f!=="boolean"){i=j;j=f;f=c}function g(){var o=this,m=+new Date()-d,n=arguments;function l(){d=+new Date();j.apply(o,n)}function k(){h=c}if(i&&!h){l()}h&&clearTimeout(h);if(i===c&&m>e){l()}else{if(f!==true){h=setTimeout(i?k:l,i===c?e-m:e)}}}if($.guid){g.guid=j.guid=j.guid||$.guid++}return g};$.debounce=function(d,e,f){return f===c?a(d,e,false):a(d,f,e!==false)}})(this);/*[{!jquery_ba_throttle_debounce_min_js_59nc554!}]*/;
/* END /2static/script/lib/jquery/plugins/jquery.ba-throttle-debounce.min.js */
/* START /2static/script/fe/branch-tag-switcher.js */
var FE = FE || {};
FE.BRANCH_TAG_SWITCHER = (function ($, Backbone, fecruAjax) {
    'use strict';

    var ResultEntry = Backbone.Model.extend({});
    var DataSet = Backbone.Collection.extend({
        model: ResultEntry,
        currentRequest: undefined,
        initialLoading: true,
        initialize: function (name, options) {
            this.name = name;
            Backbone.Collection.prototype.initialize([], options);
        },
        parse: function (response) {
            this.totalItems = response.totalItems;
            return response.items;
        },
        query: function (query) {
            if (this.currentQuery === query) {
                return;
            }
            var self = this;
            this.currentQuery = query;
            this.trigger('loading');
            if (this.currentRequest) {
                this.currentRequest.abort();
            }
            this.currentRequest = this.fetch({
                reset: true,
                data: {
                    q: query || ''
                }
            });
            this.currentRequest.always(function () {
                self.currentRequest = undefined;
            });
        }
    });
    var BranchTagSwitcher = Backbone.Model.extend({
        defaults: {
            phrase: '',
            searchType: 'branches'
        },
        initialize: function (options) {
            this.dataSets = {
                branches: new DataSet('branches', {
                    url: options.branchesSource
                }),
                tags: new DataSet('tags', {
                    url: options.tagsSource
                })
            };

            var onResponse = function (dataSetName, dataSet) {
                if (this.getSearchType() === dataSetName) {
                    this.trigger('results', dataSet, dataSetName);
                }
            };
            _.each(this.dataSets, function (dataSet, dataSetName) {
                dataSet.on('sync', $.proxy(onResponse, this, dataSetName));
            }, this);
        },
        search: function (phrase) {
            phrase = phrase || '';
            var dataSet = this.getCurrentDataSet();
            this.set('phrase', phrase);
            dataSet.query(phrase);
        },
        getPhrase: function () {
            return this.get('phrase');
        },
        setSearchType: function (searchType) {
            this.set('searchType', searchType);
        },
        getSearchType: function () {
            return this.get('searchType');
        },
        getCurrentDataSet: function () {
            return this.dataSets[this.getSearchType()];
        },
        getDataSets: function () {
            return this.dataSets;
        }
    });

    var DefaultView = (function () {
        var View = function () {
            this.$container = $('#branch-selector');
            this.$button = this.$container.find('.aui-dropdown2-trigger');
            this.$dropdown = $('#branch-selector-dropdown');
            this.$searchContainer = $('#branch-selector-search');
            this.$searchForm = this.$searchContainer.find('form');
            this.$searchInput = this.$searchForm.find('input');
            this.$allBranchesLink = $('#switch-all-branches');
            this.lists = {
                branches: $('#search-branches'),
                tags: $('#search-tags')
            };

            this.includeBranchHeadParam = this.$container.data('include-branch-head-param');

            this.$loader = $('<span class="aui-icon aui-icon-wait loading">Wait</span>');
            this.$listLoader = $('<li class="loading-wrapper"><span class="aui-icon aui-icon-wait loading">Wait</span></li>');

            this.switcher = new BranchTagSwitcher({
                branchesSource: this.lists.branches.data('url'),
                tagsSource: this.lists.tags.data('url')
            });

            this.selectedIndex = -1;
            this.selectableElements = this.$allBranchesLink;

            this.baseUrl = this.$container.data('url');

            this.initResultHandling();
            this.initDropdown();
            this.initSearchInput();
            this.initLoading();
            this.initTabs();
            this.initAutoFocus();
            this.initSelection();
        };

        View.prototype.initDropdown = function () {
            var self = this;
            this.$dropdown.one('aui-dropdown2-show', function () {
                self.switcher.search();
                self._refreshSelectableElements();
            });
        };

        View.prototype.initResultHandling = function () {
            var self = this;
            var templates = {
                noResults: _.template('<li class="no-results">No <%= type %> found</li>'),
                moreElements: _.template('<li class="total-results">' +
                    'Displaying <%= maxResults %> of <%= totalResults %> results.<br/>' +
                    '<%= secondPartOfMessage %>' +
                    '</li>'),
                entry: _.template('<li>' +
                    '<a class="interactive" href="<%= url %>">' +
                    '<span class="aui-icon aui-icon-small aui-iconfont-devtools-<%= icon%>"><%= icon %></span>' +
                    '<span class="reference-name"><%- name %></span>' +
                    '</a>' +
                    '</li>')
            };

            this.switcher.on('results', function (dataSet, searchType) {
                var list = self.lists[searchType].find('ul').get(0);
                var icon = (searchType === 'branches' ? 'branch' : 'tag');
                var dataset = self.switcher.getCurrentDataSet();
                var hasMore = dataSet.totalItems > dataSet.length;
                var resultHtml = '';

                list.setAttribute('data-query', dataSet.currentQuery);
                dataSet.each(function (element) {
                    var url = self.baseUrl + (searchType === 'branches' ? '?wbbr=' : '?wbtag=');
                    url += encodeURIComponent(element.get('displayPrimary'));
                    url += '&wbjump=jump&brjump=jump';
                    if (self.includeBranchHeadParam) {
                        url += '&' + self.includeBranchHeadParam + '=true';
                    }
                    resultHtml += templates.entry({
                        name: element.get('displayPrimary'),
                        icon: icon,
                        url: url
                    });
                });

                if (dataSet.length === 0) {
                    resultHtml += templates.noResults({type: searchType});
                }

                if (hasMore) {
                    resultHtml += templates.moreElements({
                        maxResults: dataset.length,
                        totalResults: dataset.totalItems,
                        secondPartOfMessage: self.switcher.getPhrase() ? 'Continue typing to filter.' : 'Start typing to filter.'
                    });
                }

                list.innerHTML = resultHtml;
                self._refreshSelectableElements();
            });
        };

        View.prototype.initSearchInput = function () {
            var self = this;
            this.$searchInput.keyup($.debounce(200, function () {
                if (this.value !== self.switcher.getPhrase()) {
                    self.switcher.search(this.value);
                }
            }));
        };

        View.prototype.initLoading = function () {
            var self = this;
            var currentlyLoading = 0;
            var dataSets = this.switcher.getDataSets();
            var onLoading = function () {
                currentlyLoading++;
                if (this.initialLoading) {
                    var list = self.lists[this.name].find('ul');
                    if (list.find('.loading-wrapper').length === 0) {
                        list.append(self.$listLoader.clone());
                    }
                } else if (currentlyLoading === 1) {
                    self.$searchForm.append(self.$loader);
                }
            };
            var onSync = function () {
                currentlyLoading--;
                if (currentlyLoading === 0) {
                    self.$loader.remove();
                }
            };
            var onError = function (dataset, request) {
                currentlyLoading--;
                // request.status === 0 if aborted
                if (request.status === 0) {
                    return;
                }

                fecruAjax.appendErrorMessage('Cannot fetch results for branch/tag switcher. ' +
                    'Please check your internet connection or try again later');
                fecruAjax.showErrorBox();

                if (this.initialLoading) {
                    removeInitialLoading.call(this);
                } else {
                    onSync();
                }
            };
            var removeInitialLoading = function () {
                self.lists[this.name].find('ul .loading-wrapper').remove();
                this.initialLoading = false;
            };

            _.each(dataSets, function (dataSet) {
                dataSet.on('loading', onLoading);
                dataSet.on('sync', onSync);
                dataSet.once('sync', removeInitialLoading);
                dataSet.on('error', onError);
            });
        };

        View.prototype.initTabs = function () {
            var self = this;
            this.$searchContainer.on('tabSelect', function (e, eventData) {
                var searchType = eventData.pane.attr('id') === 'search-branches' ? 'branches' : 'tags';
                self.$searchInput.attr('placeholder', 'Filter ' + searchType);
                self.switcher.setSearchType(searchType);
                self.switcher.search(self.switcher.getPhrase());
                self._refreshSelectableElements();
            });
        };

        View.prototype.initAutoFocus = function () {
            var self = this;
            var autoFocus = function () {
                self.$searchInput.focus();
            };

            this.$searchContainer.on('tabSelect', autoFocus);
            this.$dropdown.on('aui-dropdown2-show', autoFocus);
        };

        View.prototype._refreshSelectableElements = function () {
            this.selectableElements = this.$searchContainer.find('.active-pane li > a').add(this.$allBranchesLink);
            this.selectedIndex = -1;
        };

        View.prototype.initSelection = function () {
            var self = this;
            var keyCode = AJS.$.ui.keyCode;
            var $document = $(document);
            var setSelected = function (index) {
                self.selectedIndex = index;
                self.selectableElements.removeClass('active');
                if (index !== -1) {
                    self.selectableElements.eq(index).addClass('active');
                }
            };
            var moveUp = function () {
                var newIndex = self.selectedIndex - 1;
                if (newIndex <= -1) {
                    newIndex = self.selectableElements.length - 1;
                }
                setSelected(newIndex);
            };
            var moveDown = function () {
                var newIndex = self.selectedIndex + 1;
                if (newIndex >= self.selectableElements.length) {
                    newIndex = 0;
                }
                setSelected(newIndex);
            };
            var onKeyDown = function (e) {
                e.stopImmediatePropagation();
                if (!self.selectableElements.length) {
                    return;
                }
                switch (e.keyCode) {
                    case keyCode.TAB:
                        e.shiftKey ? moveUp() : moveDown();
                        break;

                    case keyCode.DOWN:
                        moveDown();
                        break;

                    case keyCode.UP:
                        moveUp();
                        break;

                    case keyCode.ENTER:
                        e.preventDefault();
                        select();
                        break;
                }
            };
            var select = function () {
                if (self.selectedIndex < 0) {
                    return;
                }
                var $link = self.selectableElements.eq(self.selectedIndex);
                var buttonText = $link.is(self.$allBranchesLink) ? $link.html() : $link.find('.reference-name').html();

                self.$button
                    .prop('disabled', true)
                    .trigger('aui-button-invoke')
                    .find('.button-text').html(buttonText).end()
                    .find('.aui-icon').attr('class', 'aui-icon aui-icon-wait');

                // without setTimeout safari won't repaint dropdown and dropdown button
                setTimeout(function () {
                    document.location.href = $link.attr('href');
                }, 0);
            };

            var selectableElementsSelector = '.active-pane li > a, #switch-all-branches';
            this.$dropdown
                .on('aui-dropdown2-show', function () {
                    $document.on('keydown', onKeyDown);
                })
                .on('aui-dropdown2-hide', function () {
                    $document.off('keydown', onKeyDown);
                })
                .on('mouseover', selectableElementsSelector, function (e) {
                    self.selectedIndex = self.selectableElements.index(e.currentTarget);
                })
                // prevent deselection of results when hover on tabs
                .on('mousemove', '.tabs-menu a', function (e) {
                    e.stopImmediatePropagation();
                })
                .on('click', selectableElementsSelector, function (e) {
                    e.preventDefault();
                    select();
                });

            var selectFirst = $.proxy(setSelected, undefined, 0);
            this.switcher.on('results', selectFirst);
            this.$searchContainer.on('tabSelect', selectFirst);
            this.$dropdown.on('aui-dropdown2-show', function () {
                // required to prevent AUI dropdown2 from selecting (therefore deselecting our choice) "first" item
                setTimeout(selectFirst, 0);
            });
        };

        return View;
    })();

    return {
        init: function () {
            return (new DefaultView).switcher
        }
    };

})(AJS.$, Backbone, FECRU.AJAX);
/*[{!branch_tag_switcher_js_b0o6524!}]*/;
/* END /2static/script/fe/branch-tag-switcher.js */
/* START /2static/script/cru/util.js */
/**
 * Crucible utility functions that can be used from any crucible page.
 */

window.CRU = window.CRU || {};
CRU.UTIL = {};

(function ($) {
    var cruUtil = CRU.UTIL;
    /**
     * Crucible base url (without trailing '/').
     *
     * @param permaId optional review id
     */
    cruUtil.urlBase = function (permaId) {
        if (permaId) {
            return FECRU.pageContext + '/cru/' + permaId;
        } else {
            return FECRU.pageContext + '/cru';
        }
    };

    /**
     * Crucible JSON base url (without trailing '/').
     *
     * @param permaId optional review id
     */
    cruUtil.jsonUrlBase = function (permaId) {
        if (permaId) {
            return FECRU.pageContext + '/json/cru/' + permaId;
        } else {
            return FECRU.pageContext + '/json/cru';
        }
    };

    cruUtil.isReviewPage = function () {
        return typeof review !== 'undefined';
    };


    cruUtil.startAjaxDialogSpin = function () {
        $('body').addClass('ajax-dialog');
        AJS.dim();
    };

    cruUtil.stopAjaxDialogSpin = function () {
        AJS.undim();
        $('body').removeClass('ajax-dialog');
    };

    cruUtil.isAjaxDialogSpinning = function () {
        return cruUtil.isDimmed() && $('body').hasClass('ajax-dialog');
    };

    var _onReviewStateTransitCallbacks = {};
    var triggerCallbacks = function (command, resp) {
        for (var id in _onReviewStateTransitCallbacks) {
            if (_onReviewStateTransitCallbacks.hasOwnProperty(id)) {
                _onReviewStateTransitCallbacks[id](command, resp);
            }
        }
    };
    /**
     * The callback will be called when the state of review transits.
     *
     * @param callbackId : string -- enable more than one callbacks to be bound
     * @param callback : function ( command, resp )
     */
    cruUtil.onReviewStateTransit = function (callbackId, callback) {
        _onReviewStateTransitCallbacks[callbackId] = callback;
    };

    cruUtil.ajaxDialog = function (url, params, isFromStateTransition) {
        cruUtil.startAjaxDialogSpin();
        FECRU.AJAX.ajaxDo(url, params || {}, function (resp) {
            var complete = function () {
                if (isFromStateTransition) {
                    triggerCallbacks(params.command, resp);
                }
            };

            if (resp.worked) {
                if (resp.showDialog) {
                    cruUtil.stopAjaxDialogSpin();
                    try {
                        FECRU.DIALOG.getAjaxDialogContainer().html(resp.payload);
                        FECRU.DIALOG.triggerAjaxDialogLoaded();

                        complete();
                    } catch (e) {
                        alert(e);
                    }
                } else if (resp.redirect) {
                    complete();
                    // no need to undim
                    window.location = resp.payload;
                }
            }
            // !resp.worked handled by ajaxDo
        });
        return false;
    };

    cruUtil.stateTransition = function (transition, permaId, params) {
        var util = cruUtil;
        var url = util.jsonUrlBase(permaId) + '/changeStateAjax';
        var unsaved = CRU.UNSAVED;

        // Make sure there aren't any unsaved inputs on the page, and if there are, then provide a warning
        // and give the user the ability to cancel and save their inputs.
        if (unsaved) {
            if (!unsaved.confirmUnsubmittedInputs()) {
                return;
            }
            unsaved.clearWatchForUnsavedChanges();
        }

        params = params || {};

        $.extend(params, {
            command: transition
        });

        if (util.isReviewPage() && $.inArray(transition, ['action:completeReview', 'action:summarizeReview', 'action:closeReview']) >= 0) {
            // If completing or summarizing we need to warn if the review has been updated.

            util.startAjaxDialogSpin();
            CRU.REVIEW.UTIL.reviewUpdatedAjax({
                done: function () {
                    var reviewUpdated = $('body').hasClass('review-updated');
                    if (reviewUpdated) {
                        CRU.REVIEW.UTIL.warnAboutReviewUpdates({reshowWarning: true});
                    }
                    util.stopAjaxDialogSpin();
                    return util.ajaxDialog(url, $.extend(params, {reviewUpdated: reviewUpdated}), true);
                }
            });
            return false;

        } else {
            return util.ajaxDialog(url, params, true);
        }
    };

    cruUtil.editDetailsFormChange = false;
    cruUtil.checkEditForm = function (done) {
        if (cruUtil.editDetailsFormChange) {
            CRU.REVIEW.UTIL.postEditDetailsForm(done);
        } else {
            if (done) {
                done();
            }
        }
        return false;//do a link action if called from <a>
    };

    cruUtil.command = function (cmd, pid, button) {
        var perma = pid || permaId;
        if (button) {
            button.disabled = true;
        }
        var donext = function () {
            var url = cruUtil.urlBase(perma);
            FECRU.XSRF.postUri(url + '/' + cmd);
        };
        //check and post the editDetailsForm if it has changed
        cruUtil.checkEditForm(donext);
    };


    cruUtil.createBlankReview = function (params) {
        var url = cruUtil.jsonUrlBase() + '/createReviewDialog';
        return cruUtil.ajaxDialog(url, params);
    };

    cruUtil.createSnippet = function (params) {
        var url = cruUtil.jsonUrlBase() + '/createSnippetDialog';
        return cruUtil.ajaxDialog(url, params);
    };

    cruUtil.addToReview = function (params) {
        var url = cruUtil.jsonUrlBase() + '/createDialog';
        return cruUtil.ajaxDialog(url, params);
    };

    cruUtil.isAnyDialogShowing = function () {
        return AJS && AJS.popup && typeof AJS.popup.current !== 'undefined' && AJS.popup.current !== null;
    };

    cruUtil.isAnyOverlayShowing = function () {
        return $('.review-overlay.review-overlay__open').length > 0;
    };

    cruUtil.isDimmed = function () {
        return !!AJS.dim.dim;
    };

    cruUtil.makeCssRule = function (selector, ruleBody) {
        var styleSheet = document.styleSheets[0];
        var index = 0;
        if (styleSheet.insertRule) {
            styleSheet.insertRule(selector + '{' + ruleBody + '}', index);
            return styleSheet.cssRules[index].style;
        } else {
            // Internet Explorer's version.
            styleSheet.addRule(selector, ruleBody, index);
            return styleSheet.rules[index].style;
        }
    };

    cruUtil.createIdeSrc = function (linkUrl, frxId) {
        var src = linkUrl + '&id=' + Math.floor(Math.random() * 1000);
        if (frxId) {
            src += '&line=' + CRU.REVIEW.UTIL.getTopVisibleLineNumber(frxId);
        }
        return src;
    };

    cruUtil.loadJiraIssueLink = function (issueKey, $target, params, done) {
        if (!issueKey) {
            throw "JIRA issue key required";
        }
        if (!$target) {
            throw "Target container to insert issue details into required";
        }

        var isReviewIssue = ($target.attr("data-review-jira-issue") === "true");
        var hideIssueTitle = ($target.attr("data-hide-issue-title") === "true");

        var defaults = {
            shouldGetIssueMetadata: isReviewIssue,
            hideIssueTitle: hideIssueTitle,
            maxTitleLength: 75,
            key: issueKey
        };

        var data = $.extend({}, defaults, params);

        var getIssueDetails = function () {
            AJS.$.ajax({
                url: FECRU.pageContext + '/json/action/issue-inline.do',
                data: data,
                type: "GET",
                dataType: "json",
                cache: false,
                success: function (resp) {
                    if (resp.foundIssue || (resp.credentialsRequired && resp.credentialsRequired.length)) {
                        // only display html if we found an issue (no errors)
                        $target.html(resp.html);
                    }

                    if (!$target.find(".ual-authenticate").length) {
                        $target.attr("data-jira-issue-lazy-load", "false");
                    }

                    $target.find(".ual-authenticate").bind("click", function () {
                        FECRU.OAUTH.getEventProducer($(this).attr("href")).authorized(function () {
                            FECRU.HOVER.invalidateCache(FECRU.HOVER.CACHE_FOREVER, issueKey);
                            CRU.UI.loadInlineJiraIssues();
                        });
                    });

                    if (data.shouldGetIssueMetadata) {
                        if (resp.canLogWork) {
                            AJS.$("#time-spent").addClass("submit-jira-time");
                            AJS.$("#linked-jira-log-work").show();
                        }
                        if (resp.subtasksConfigured && !resp.issueIsSubtask) {
                            AJS.$("body").addClass("jiraSubtasksVisible");
                        } else {
                            AJS.$("body").removeClass("jiraSubtasksVisible");
                        }
                    }

                    done && done($target);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    // dont display jira errors in the UI
                    $target.attr("data-jira-issue-lazy-load", "false");
                }
            });
        };

        getIssueDetails();
    };

    // this is a method to handle legacy "checkbox" style user pickers via autocomplete
    cruUtil.addUserCheckbox = function (id, user) {
        var userid = user.dbId;
        var $elTarget = AJS.$('#' + id + '_rc_' + userid);

        if (!$elTarget.length) {
            // checkbox doesnt exist yet
            $elTarget = AJS.$('<span><input type="checkbox"/><label></label></span>');
            $elTarget.attr('id', id + '_rc_' + userid);
            $elTarget.children('input')
                .attr('name', id)
                .attr('value', user.id);
            $elTarget.children('label')
                .attr('for', id + '_rc_' + userid)
                .text(user.displayPrimary);

            AJS.$('#' + id + '_checkboxes').append($elTarget);
        }
        $elTarget.children('input').attr('checked', 'checked');
        $elTarget.show();
    };

})(AJS.$);
/*[{!util_js_6z0350x!}]*/;
/* END /2static/script/cru/util.js */
/* START /2static/script/cru/dialog/dialog-event.js */
(function () {

    var $container = FECRU.DIALOG.getAjaxDialogContainer();

    var dialogHandler = function (callbacks) {
        return function (event) {
            var dialog = $container.data('dialog');
            var permaId = $container.data('permaId');

            if (CRU.UTIL.isReviewPage() && callbacks.review) {
                return callbacks.review(dialog, permaId, event);
            } else if (!CRU.UTIL.isReviewPage() && callbacks.external) {
                return callbacks.external(dialog, permaId, event);
            }
        };
    };

    var viewFiltersHandler = function (filters) {
        return dialogHandler({
            review: function (dialog) {
                if (AJS.$('body').hasClass('review-updated')) {
                    window.location.hash = 'f-' + filters.join(',');
                    window.location.reload(true);
                } else {
                    CRU.REVIEW.UTIL.filterAndExpandFrxs(filters);
                    dialog.remove();
                }
            },
            external: function (dialog, permaId) {
                window.location = CRU.UTIL.urlBase(permaId) + '#f-' + filters.join(',');
            }
        });
    };

    var batchProcessDraftComments = function (action, permaId, onComplete) {
        var url = CRU.UTIL.jsonUrlBase(permaId) + '/draftCommentsAjax';
        var params = {
            action: action
        };
        var done = function (resp) {
            if (onComplete) {
                onComplete(resp);
            }
        };
        FECRU.AJAX.ajaxDo(url, params, done, true);
    };

    var draftCommentsHandler = function (action) {
        return dialogHandler({
            review: function (dialog, permaId) {
                function toggleSpinner(spinnerSelector) {
                    var spinner = AJS.$(spinnerSelector);
                    if (spinner.is(':hidden')) {
                        spinner.removeClass('hidden');
                        spinner.spin();
                    } else {
                        spinner.spinStop();
                        spinner.addClass('hidden');
                    }
                }

                var successMsg;
                var failMsg;
                var closeButton = AJS.$('#' + dialog.id).find('.button-panel-button');
                closeButton.prop('disabled', true);

                if (action === 'publish') {
                    closeButton.text('Posting drafts');
                    toggleSpinner('#dialog-post-drafts-spinner');

                    successMsg = 'Your draft comments have been posted.';
                    failMsg = 'Posting some of your draft comments failed with an error: ';
                }

                batchProcessDraftComments(action, permaId, function (resp) {
                    AJS.$('#dialog-drafts-links').hide();
                    closeButton.prop('disabled', false);
                    if (resp.worked) {
                        AJS.$('#dialog-drafts-message').html(successMsg);
                        closeButton.text('Close');
                        CRU.REVIEW.UTIL.reloadReview(true);
                    } else {
                        var msg;
                        if (resp.errorMsg) {
                            msg = failMsg + '<br/>' + resp.errorMsg;
                        } else {
                            msg = "Request has failed with an status error: " + resp.status;
                        }
                        AJS.$('#dialog-drafts-message').html(msg);
                        closeButton.text('Close Anyway');
                    }
                });
            },
            external: function (dialog, permaId) {
                batchProcessDraftComments(action, permaId, function (resp) {
                    if (resp.worked) {
                        AJS.$('#dialog-drafts-links').hide();
                    } else {
                        // TODO Show error message within dialog panel.
                    }
                });
            }
        });
    };

    var resolveUnresolvedJiras = function () {
        var doIt = function (dialog, permaId) {
            AJS.$('#dialog-unresolved-jiras-controls').hide();
            var url = CRU.UTIL.jsonUrlBase(permaId) + '/resolveAllSubtasksAjax';
            var params = {};
            AJS.$('#dialog-unresolved-jiras-spinner').show();
            var done = function (resp) {
                AJS.$('#dialog-unresolved-jiras-spinner').hide();
                if (resp.worked) {
                    AJS.$('#dialog-unresolved-jiras-title').html("There are no unresolved subtasks.").show();
                } else {
                    AJS.$('#dialog-unresolved-jiras-results').addClass("jira-error").html(resp.errorMsg).show();
                }
            };
            FECRU.AJAX.ajaxDo(url, params, done, true);
        };
        return dialogHandler({review: doIt, external: doIt});
    };

    AJS.$(document).ready(function () {
        var $document = AJS.$(document);
        $document.delegate('#dialog-view-drafts', 'click', viewFiltersHandler(['draftcomments']));
        $document.delegate('#dialog-view-unread-comments', 'click', viewFiltersHandler(['unreadcomments']));
        $document.delegate('#dialog-view-incomplete-frxs', 'click', viewFiltersHandler(['incomplete']));
        $document.delegate('#dialog-view-unresolved-jiras', 'click', viewFiltersHandler(['unresolvedsubtasks']));

        $document.delegate('#dialog-post-drafts', 'click', draftCommentsHandler('publish'));
        $document.delegate('#dialog-resolve-unresolved-jiras', 'click', resolveUnresolvedJiras());
    });

})();
/*[{!dialog_event_js_bq41511!}]*/;
/* END /2static/script/cru/dialog/dialog-event.js */
/* START /2static/script/cru/review/review-history.js */
window.CRU = window.CRU || {};
if (!CRU.REVIEW) {
    CRU.REVIEW = {};
}
if (!CRU.REVIEW.HISTORY) {
    CRU.REVIEW.HISTORY = {};
}

(function ($) {
    var historyDialog = null;

    CRU.REVIEW.HISTORY.showPage = function (permaId) {
        if (AJS.dropDown.current) {
            AJS.dropDown.current.hide();
        }

        if (!permaId) {
            AJS.log("I don't know which review to give you history for.");
            return;
        }

        historyDialog && historyDialog.remove();
        historyDialog = FECRU.DIALOG.create(1200, 700, "cru-review-history-dialog");

        var iframeStyle = "style='overflow:hidden;width:100%;height:" + (historyDialog.height - 48 - 44 - 23 - 17) + "px'"; // @2ADG (-17) for adg purposes
        var cs = "<iframe frameborder='0' id='reviewHistoryIframe' name='reviewHistoryIframe' scrolling='no' src='" + CRU.UTIL.urlBase(permaId) + "/reviewHistoryWrapper" + "' " + iframeStyle + "></iframe>";

        var header = "History of Review " + permaId;
        historyDialog.addHeader(header)
            .addPanel("History", cs);

        historyDialog.addButton("Done", function (dialog) {
            dialog.hide();
        }).show();

        AJS.$("#cru-review-history-dialog").data("dialog", historyDialog);//stores the object so we can access it from its contents
    };

    CRU.REVIEW.HISTORY.setupLinks = function () {
        var $document = AJS.$(document);
        $document.delegate("a.action-link", "click", function () {
            parent.top.AJS.$("#cru-review-history-dialog").data("dialog").hide();
        });
        $document.delegate("a.comment-link", "click", function () {
            var comment_nav = parent.top.CRU.COMMENT.NAV;
            var comment_id = AJS.$(this).prop('hash').replace('#c', '');

            var scrollToMap = comment_nav.navigateFindComment({commentId: comment_id});
            comment_nav.navigateDirectlyToElement({commentId: comment_id}, scrollToMap);
        });
        $document.delegate("a.frx-link", "click", function () {
            var frx_id = AJS.$(this).prop('hash').replace('#CFR-','');

            parent.top.CRU.FRX.NAV.gotoFrx({frxId: frx_id, destination: ''});
        });

    };
})(AJS.$);
/*[{!review_history_js_4j3b51c!}]*/;
/* END /2static/script/cru/review/review-history.js */
