/* CONCAT of
/2static/script/lib/jquery/plugins/jquery.editable-select.js
/2static/script/lib/jquery/plugins/jquery.getscrollbarwidth.js
/2static/script/lib/jquery/plugins/jquery.ba-hashchange.min.js
/2static/script/cru/unsaved-changes.js
/2static/script/cru/crucible-ui.js
/2static/script/cru/util.js
/2static/script/cru/review/editableHeader.js
/2static/script/cru/patch-ui.js
/2static/script/cru/review/review-history.js
/2static/script/cru/review/widgets/sliders.js
/2static/script/cru/review/widgets/scroll-tracker.js
/2static/script/cru/review/wiki/wiki-preview.js
/2static/script/cru/review/util.js
/2static/script/cru/review/model/review-pending.js
/2static/script/cru/review/model/review.js
/2static/script/cru/review/model/frx.js
/2static/script/cru/review/model/comment.js
/2static/script/cru/review/model/reviewer.js
/2static/script/cru/review/model/review-observer.js
/2static/script/cru/review/model/user.js
/2static/script/cru/review/review-event.js
/2static/script/cru/review/submit-time.js
/2static/script/cru/review/nav.js
/2static/script/cru/review/comment/comment-ajax.js
/2static/script/cru/review/comment/comment-event.js
/2static/script/cru/review/comment/comment-issue.js
/2static/script/cru/review/comment/comment-form.js
/2static/script/cru/review/comment/commentator.js
/2static/script/cru/review/comment/commentator-init.js
/2static/script/cru/review/comment/comment-nav.js
/2static/script/cru/review/comment/comment-tetris.js
/2static/script/cru/review/comment/comment-thread.js
/2static/script/cru/review/diff/diff-nav.js
/2static/script/cru/review/frx/frx.js
/2static/script/cru/review/frx/frx-event.js
/2static/script/cru/review/frx/frx-ajax.js
/2static/script/cru/review/frx/frx-nav.js
/2static/script/cru/review/wikihelp.js
/2static/script/cru/create/create.js
/2static/script/cru/create/create-analytics.js
/2static/script/cru/create/create-browse.js
/2static/script/cru/create/create-event.js
/2static/script/cru/dialog/dialog-event.js
/2static/script/cru/review/review-analytics.js
*/
/* START /2static/script/lib/jquery/plugins/jquery.editable-select.js */
/**
 * Copyright (c) 2009 Anders Ekdahl (http://coffeescripter.com/)
 * Dual licensed under the MIT (http://www.opensource.org/licenses/mit-license.php)
 * and GPL (http://www.opensource.org/licenses/gpl-license.php) licenses.
 *
 * Version: 1.3.1
 *
 * Demo and documentation: http://coffeescripter.com/code/editable-select/
 */
(function($) {
  var instances = [];
  $.fn.editableSelect = function(options) {
    var defaults = { bg_iframe: false,
                     onSelect: false,
                     items_then_scroll: 10,
                     case_sensitive: false,
                     selectStrategy: false
    };
    var settings = $.extend(defaults, options);
    // Only do bg_iframe for browsers that need it
    if(settings.bg_iframe && !$.browser.msie) {
      settings.bg_iframe = false;
    }
    var instance = false;
    $(this).each(function() {
      var i = instances.length;
        var $this = $(this);
        // this works around http://dev.jquery.com/ticket/6304
        var ignored = $this.data();
        if(typeof $this.data('editable-selecter') == 'undefined') {
        instances[i] = new EditableSelect(this, settings);
        $(this).data('editable-selecter', i);
      }
    });
    return $(this);
  };
  $.fn.editableSelectInstances = function() {
    var ret = [];
    $(this).each(function() {
      if(typeof $(this).data('editable-selecter') != 'undefined') {
        ret[ret.length] = instances[$(this).data('editable-selecter')];
      }
    });
    return ret;
  };

  var EditableSelect = function(select, settings) {
    this.init(select, settings);
  };
  EditableSelect.prototype = {
    settings: false,
    text: false,
    select: false,
    wrapper: false,
    list_item_height: 20,
    list_height: 0,
    list_is_visible: false,
    hide_on_blur_timeout: false,
    bg_iframe: false,
    current_value: '',
    init: function(select, settings) {
      this.settings = settings;
      this.select = $(select);
      this.text = $('<input type="text">');
      this.text.attr('name', this.select.attr('name'));
      this.text.data('editable-selecter', this.select.data('editable-selecter'));
      // Because we don't want the value of the select when the form
      // is submitted
      this.select.attr('disabled', 'disabled');
      var id = this.select.attr('id');
      if(!id) {
        id = 'editable-select'+ instances.length;
      }
      this.text.attr('id', id);
      this.text.attr('autocomplete', 'off');
      this.text.addClass('editable-select');
      this.select.attr('id', id +'_hidden_select');
      this.initInputEvents(this.text);
      this.duplicateOptions();
      this.positionElements();
      this.setWidths();

      if(this.settings.bg_iframe) {
        this.createBackgroundIframe();
      }
    },
    duplicateOptions: function() {
      var context = this;
      var wrapper = $(document.createElement('div'));
      wrapper.addClass('editable-select-options');
      var option_list = $(document.createElement('ul'));
      wrapper.append(option_list);
      var options = this.select.find('option');
      options.each(function() {
          var $this = $(this);
          if ($this.attr('selected')) {
              context.text.val($.trim($this.text()));
              context.current_value = $this.val();
          }
          if (!($this.attr("disabled") === "disabled" || $this.attr("disabled") === "true")) {//
              var li = $('<li>' + $this.text() + '<input value="' + $this.val() + '" type="hidden"></li>');
              context.initListItemEvents(li);
              option_list.append(li);
          }
      });
      this.wrapper = wrapper;
      this.checkScroll();
    },
    checkScroll: function() {
      var options = this.wrapper.find('li');
      if(options.length > this.settings.items_then_scroll) {
        this.list_height = this.list_item_height * this.settings.items_then_scroll;
        this.wrapper.css('height', this.list_height +'px');
        this.wrapper.css('overflow', 'auto');
      } else {
        this.wrapper.css('height', 'auto');
        this.wrapper.css('overflow', 'visible');
      }
    },
    addOption: function(value) {
      var li = $('<li>'+ value +'</li>');
      var option = $('<option>'+ value +'</option>');
      this.select.append(option);
      this.initListItemEvents(li);
      this.wrapper.find('ul').append(li);
      this.setWidths();
      this.checkScroll();
    },
    initInputEvents: function(text) {
      var context = this;
      var timer = false;
      $(document.body).click(
        function() {
//          context.clearSelectedListItem();
          context.hideList();
        }
      );
      text.focus(
        function() {
          // Can't use the blur event to hide the list, because the blur event
          // is fired in some browsers when you scroll the list
          context.showList();
          context.highlightSelected();
        }
      ).click(
        function(e) {
          e.stopPropagation();
          context.showList();
          context.highlightSelected();
        }
      ).keydown(
        // Capture key events so the user can navigate through the list
        function(e) {
          switch(e.keyCode) {
            // Down
            case 40:
              if(!context.listIsVisible()) {
                context.showList();
                context.highlightSelected();
              } else {
                e.preventDefault();
                context.selectNewListItem('down');
              }
              break;
            // Up
            case 38:
              e.preventDefault();
              context.selectNewListItem('up');
              break;
            // Tab
            case 9:
              context.pickListItem(context.selectedListItem());
              break;
            // Esc
            case 27:
              e.preventDefault();
              context.hideList();
              return false;
              break;
            // Enter, prevent form submission
            case 13:
              e.preventDefault();
              if (context.listIsVisible()) {
                context.pickListItem(context.selectedListItem());
              }
              return false;
            default:
              context.hideList();
              break;
          }
        }
      ).keyup(
        function(e) {
          // Prevent lots of calls if it's a fast typer
          if(timer !== false) {
            clearTimeout(timer);
            timer = false;
          }
          timer = setTimeout(
            function() {
              // If the user types in a value, select it if it's in the list
              if(context.text.val() != context.current_value) {
                context.current_value = context.text.val();
                context.highlightSelected();
              }
            },
            200
          );
        }
      ).keypress(
        function(e) {
          if(e.keyCode == 13) {
            // Enter, prevent form submission
            e.preventDefault();
            return false;
          }
        }
      );
    },
    initListItemEvents: function(list_item) {
      var context = this;
      list_item.mouseover(
        function() {
          context.clearSelectedListItem();
          context.selectListItem(list_item);
        }
      ).mousedown(
        // Needs to be mousedown and not click, since the inputs blur events
        // fires before the list items click event
        function(e) {
          e.stopPropagation();
          context.pickListItem(context.selectedListItem());
        }
      );
    },
    selectNewListItem: function(direction) {
      var li = this.selectedListItem();
      if(!li.length) {
        li = this.selectFirstListItem();
      }
      var sib;
      if(direction == 'down') {
        sib = li.next();
      } else {
        sib = li.prev();
      }
      if(sib.length) {
        this.selectListItem(sib);
        this.scrollToListItem(sib);
        this.unselectListItem(li);
      }
    },
    selectListItem: function(list_item) {
      this.clearSelectedListItem();
      list_item.addClass('selected');
    },
    selectFirstListItem: function() {
      this.clearSelectedListItem();
      var first = this.wrapper.find('li:first');
      first.addClass('selected');
      return first;
    },
    unselectListItem: function(list_item) {
      list_item.removeClass('selected');
    },
    selectedListItem: function() {
      return this.wrapper.find('li.selected');
    },
    clearSelectedListItem: function() {
      this.wrapper.find('li.selected').removeClass('selected');
    },
    pickListItem: function(list_item) {
      if(list_item.length) {
        this.text.val(list_item.text());
        this.current_value = this.text.val();
      }
      if(typeof this.settings.onSelect == 'function') {
        this.settings.onSelect.call(this, list_item);
      }
      this.hideList();
    },
    listIsVisible: function() {
      return this.list_is_visible;
    },
    showList: function() {
      this.refreshOffset();
      this.wrapper.show();
      this.hideOtherLists();
      this.list_is_visible = true;
      if(this.settings.bg_iframe) {
        this.bg_iframe.show();
      }
    },
    highlightSelected: function() {
        if (this.selectedListItem().length === 0) {
            this.highlightValue(this.text.val());
        } else {
            this.scrollToListItem(this.selectedListItem());
        }
    },
    highlightValue:function(val) {
      var context = this;
      var current_value = val;
      if(current_value.length < 0) {
        if(highlight_first) {
          this.selectFirstListItem();
        }
        return;
      }
      if(!context.settings.case_sensitive) {
        current_value = current_value.toLowerCase();
      }
      var best_candiate = false;
      var value_found = false;
      var list_items = this.wrapper.find('li');
      list_items.each(
        function() {
          if(!value_found) {
            var text = $(this).text();
            if(!context.settings.case_sensitive) {
              text = text.toLowerCase();
            }
            if(text == current_value) {
              value_found = true;
              context.clearSelectedListItem();
              context.selectListItem($(this));
              context.scrollToListItem($(this));
              return false;
            } else if(text.indexOf(current_value) === 0 && !best_candiate) {
              // Can't do return false here, since we still need to iterate over
              // all list items to see if there is an exact match
              best_candiate = $(this);
            }
          }
        }
      );
      if(best_candiate && !value_found) {
        context.clearSelectedListItem();
        context.selectListItem(best_candiate);
        context.scrollToListItem(best_candiate);
      } else if(!best_candiate && !value_found) {
          if (context.settings.selectStrategy) {
              context.settings.selectStrategy(this);
          } else {
              this.selectFirstListItem();
          }
      }
    },
    scrollToListItem: function(list_item) {
      if(this.list_height) {
        this.wrapper.scrollTop(list_item[0].offsetTop - (this.list_height / 2));
      }
    },
    hideList: function() {
      this.wrapper.hide();
      this.list_is_visible = false;
      if(this.settings.bg_iframe) {
        this.bg_iframe.hide();
      }
    },
    hideOtherLists: function() {
      for(var i = 0; i < instances.length; i++) {
        if(i != this.select.data('editable-selecter')) {
          instances[i].hideList();
        }
      }
    },
    refreshOffset: function() {
        var elem = this.select;
        if (!elem.is(':visible')) {
            elem = this.text;
        }
        var offset = elem.offset();

        // NB dialog offset is wacked
        var dialog = elem.parents(".aui-dialog, .dialog");
        if (dialog.length > 0) {
            this.wrapper.css({
                top: elem.outerHeight(),
                left: 0
            })
        } else {
            offset.top += elem[0].offsetHeight;
            this.wrapper.css({top: offset.top +'px', left: offset.left +'px'});
        }
    },
    positionElements: function() {
      this.refreshOffset();
      this.select.after(this.text);
      this.select.hide();
      this.select.parent().append(this.wrapper);
      // Need to do this in order to get the list item height
      this.wrapper.css('visibility', 'hidden');
      this.wrapper.show();
      this.list_item_height = this.wrapper.find('li')[0].offsetHeight;
      this.wrapper.css('visibility', 'visible');
      this.wrapper.hide();
    },
    setWidths: function() {
      // The text input has a right margin because of the background arrow image
      // so we need to remove that from the width
      var width = this.select.width() + 2;
      var padding_right = parseInt(this.text.css('padding-right').replace(/px/, ''), 10);
      this.text.width(width - padding_right);
      this.wrapper.width(width + 2);
      if(this.bg_iframe) {
        this.bg_iframe.width(width + 4);
      }
    },
    createBackgroundIframe: function() {
      var bg_iframe = $('<iframe frameborder="0" class="editable-select-iframe" src="about:blank;"></iframe>');
      this.select.parent().append(bg_iframe);
      bg_iframe.width(this.select.width() + 2);
      bg_iframe.height(this.wrapper.height());
      bg_iframe.css({top: this.wrapper.css('top'), left: this.wrapper.css('left')});
      this.bg_iframe = bg_iframe;
    }
  };
})(jQuery);/*[{!jquery_editable_select_js_esjm55a!}]*/;
/* END /2static/script/lib/jquery/plugins/jquery.editable-select.js */
/* START /2static/script/lib/jquery/plugins/jquery.getscrollbarwidth.js */
/*! Copyright (c) 2008 Brandon Aaron (brandon.aaron@gmail.com || http://brandonaaron.net)
 * Dual licensed under the MIT (http://www.opensource.org/licenses/mit-license.php) 
 * and GPL (http://www.opensource.org/licenses/gpl-license.php) licenses.
 */

/**
 * Gets the width of the OS scrollbar
 */
(function($) {
	var scrollbarWidth = 0;
	$.getScrollbarWidth = function() {
		if ( !scrollbarWidth ) {
			if ( $.browser.msie ) {
				var $textarea1 = $('<textarea cols="10" rows="2"></textarea>')
						.css({ position: 'absolute', top: -1000, left: -1000 }).appendTo('body'),
					$textarea2 = $('<textarea cols="10" rows="2" style="overflow: hidden;"></textarea>')
						.css({ position: 'absolute', top: -1000, left: -1000 }).appendTo('body');
				scrollbarWidth = $textarea1.width() - $textarea2.width();
				$textarea1.add($textarea2).remove();
			} else {
				var $div = $('<div />')
					.css({ width: 100, height: 100, overflow: 'auto', position: 'absolute', top: -1000, left: -1000 })
					.prependTo('body').append('<div />').find('div')
						.css({ width: '100%', height: 200 });
				scrollbarWidth = 100 - $div.width();
				$div.parent().remove();
			}
		}
		return scrollbarWidth;
	};
})(jQuery);
/*[{!jquery_getscrollbarwidth_js_dt1855j!}]*/;
/* END /2static/script/lib/jquery/plugins/jquery.getscrollbarwidth.js */
/* START /2static/script/lib/jquery/plugins/jquery.ba-hashchange.min.js */
/*
 * jQuery hashchange event - v1.3 - 7/21/2010
 * http://benalman.com/projects/jquery-hashchange-plugin/
 * 
 * Copyright (c) 2010 "Cowboy" Ben Alman
 * Dual licensed under the MIT and GPL licenses.
 * http://benalman.com/about/license/
 */
(function($,e,b){var c="hashchange",h=document,f,g=$.event.special,i=h.documentMode,d="on"+c in e&&(i===b||i>7);function a(j){j=j||location.href;return"#"+j.replace(/^[^#]*#?(.*)$/,"$1")}$.fn[c]=function(j){return j?this.bind(c,j):this.trigger(c)};$.fn[c].delay=50;g[c]=$.extend(g[c],{setup:function(){if(d){return false}$(f.start)},teardown:function(){if(d){return false}$(f.stop)}});f=(function(){var j={},p,m=a(),k=function(q){return q},l=k,o=k;j.start=function(){p||n()};j.stop=function(){p&&clearTimeout(p);p=b};function n(){var r=a(),q=o(m);if(r!==m){l(m=r,q);$(e).trigger(c)}else{if(q!==m){location.href=location.href.replace(/#.*/,"")+q}}p=setTimeout(n,$.fn[c].delay)}$.browser.msie&&!d&&(function(){var q,r;j.start=function(){if(!q){r=$.fn[c].src;r=r&&r+a();q=$('<iframe tabindex="-1" title="empty"/>').hide().one("load",function(){r||l(a());n()}).attr("src",r||"javascript:0").insertAfter("body")[0].contentWindow;h.onpropertychange=function(){try{if(event.propertyName==="title"){q.document.title=h.title}}catch(s){}}}};j.stop=k;o=function(){return a(q.location.href)};l=function(v,s){var u=q.document,t=$.fn[c].domain;if(v!==s){u.title=h.title;u.open();t&&u.write('<script>document.domain="'+t+'"<\/script>');u.close();q.location.hash=v}}})();return j})()})(jQuery,this);/*[{!jquery_ba_hashchange_min_js_3nx2552!}]*/;
/* END /2static/script/lib/jquery/plugins/jquery.ba-hashchange.min.js */
/* START /2static/script/cru/unsaved-changes.js */
window.CRU = window.CRU || {};
if (!CRU.UNSAVED) {
    CRU.UNSAVED = {};
}

(function ($) {
    var unsaved = CRU.UNSAVED;

    var watchedInputs = [];

    unsaved.clearWatchForUnsavedChanges = function () {
        watchedInputs = [];
    };

    unsaved.watchForUnsavedChanges = function ($input, fieldName) {
        var input = $input ? $input[0] : undefined;
        if (!input) {
            return;
        }

        if ($input.siblings(".backup").length === 0) {
            return;
        }

        $input.data("fieldName", fieldName);

        if ($.inArray(input, watchedInputs) === -1) {
            watchedInputs.push(input);
        }
    };

    /**
     * Shows a confirm dialog if there are unsubmitted input elements on the page.
     * @return true if the user wants to continue
     */
    unsaved.confirmUnsubmittedInputs = function () {
        var warning = getUnsubmittedInputsWarning();
        if (warning) {
            var txt = "Are you sure you want to navigate away from this page?\n\n" +
                warning + "\n\n" +
                "Press OK to continue, or Cancel to stay on the current page.";
            return confirm(txt);
        }
        return true;
    };

    var getUnsubmittedInputsWarning = function () {
        var unsubmitted = getUnsubmittedInputs();
        var warning = null;
        var length = unsubmitted.length;
        if (length > 0) {
            var fields = "";
            for (var i = 0; i < length; i++) {
                if (fields.length > 0) {
                    if (i === length - 1) {
                        fields += " and "
                    } else {
                        fields += ", ";
                    }
                }
                fields += unsubmitted[i].data("fieldName");
            }

            warning = "The " + fields + (length === 1 ? " field has " : " fields have ") + "not been saved.";
        }
        return warning;
    };

    var getUnsubmittedInputs = function () {
        var unsubmitted = [];
        try {
            for (var i = 0, len = watchedInputs.length; i < len; i++) {
                var w = watchedInputs[i];
                // May have been removed from the DOM, so be defensive.
                if (!w) {
                    continue;
                }
                var $input = $(w);
                var $backup = $input.siblings(".backup");
                if ($input.val() !== $backup.val()) {
                    unsubmitted.push($input);
                }
            }
        } catch (e) {
            AJS.log("There was an error getting unsubmitted values: " + e);
        }
        return unsubmitted;
    };

    // Check that we don't have any unsubmitted input fields before unloading the page.
    $(window).bind('beforeunload', function (e) {
        e = e || window.event;

        var txt = getUnsubmittedInputsWarning();
        if (txt) {
            if (e) {
                // Firefox/IE
                e.returnValue = txt;
            }
            // Safari
            return txt;
        }
    });
})(AJS.$);
/*[{!unsaved_changes_js_y2o550w!}]*/;
/* END /2static/script/cru/unsaved-changes.js */
/* START /2static/script/cru/crucible-ui.js */
window.CRU = window.CRU || {};
if (!CRU.UI) {
    CRU.UI = {};
}

(function ($, cssJs) {
    var cruUi = CRU.UI;
    var $window = $(window);
    var reviewCSSRules = cssJs('review-styles');

    /**
     * Bind textarea to trigger resize events
     *
     * @param {DOMElement} textarea
     *
     */
    var makeTextareaResizable = function (textarea) {
        var $textarea = $(textarea);
        var $document = $(document);

        textarea = $textarea.get(0);

        // it's impossible to resize textarea via mouse without support for resize property
        if (!('resize' in textarea.style)) {
            return;
        }

        var checkIfResized = $.proxy(function () {
            var previousWidth = this.dataset.lastWidth;
            var previousHeight = this.dataset.lastHeight;
            var currentWidth = $textarea.width().toFixed(0);
            var currentHeight = $textarea.height().toFixed(0);

            if (previousWidth !== currentWidth || previousHeight !== currentHeight) {
                this.dataset.lastWidth = currentWidth;
                this.dataset.lastHeight = currentHeight;
                $textarea.trigger('textarea-resize', +currentWidth, +currentHeight);
            }
        }, textarea);

        $textarea
            .on('mouseover', function () {
                this.dataset.lastWidth = $textarea.width().toFixed(0);
                this.dataset.lastHeight = $textarea.height().toFixed(0);
                $document.on('mousemove', checkIfResized);
            })
            .on('blur mouseup', function () {
                $document.off('mousemove', checkIfResized);
            });
    };

    var pageScrolling = (function () {
        var dimensions = {
            reviewToolbarHeight: 0,
            pageHeaderHeight: 0,
            headerHeight: 0,
            footerHeight: 0,
            reviewHeaderHeight: 77, // yep it's constant
            switchToStickyPoint: 0,
            bodyMinHeight: 0,
            messageHeight: 0,
            reviewSubHeaderButtons: 0,
            windowHeight: 0
        };

        var elements = {
            $sidebar: undefined,
            frxPane: undefined,
            $body: undefined,
            page: undefined,
            scrollable: undefined
        };

        var isSticky = false;
        var isScrollTriggeredByWindow = false;
        var isScrolling = false;

        var initStaticDimensions = function () {
            dimensions.reviewToolbarHeight = $('#review-info-container').height();
            dimensions.footerHeight = $('#footer').height();
            dimensions.pageHeaderHeight = $('.aui-page-header').outerHeight(true);
            dimensions.reviewHeaderHeight = $('.review-header').outerHeight(true);
            dimensions.headerHeight = $('#header').outerHeight(true);
            dimensions.messageHeight = $('#content > .aui-message').outerHeight(true);
            dimensions.reviewSubHeaderButtons = $('.review-header--buttons').height();
            dimensions.evalBar = $('.evalBar').height();
            dimensions.licenseStatusBanner = $('#stp-licenseStatus-banner').outerHeight(true);
            dimensions.switchToStickyPoint = dimensions.pageHeaderHeight + dimensions.headerHeight +
                dimensions.reviewHeaderHeight + dimensions.messageHeight - dimensions.reviewSubHeaderButtons +
                dimensions.evalBar + dimensions.licenseStatusBanner;

            $('body').data('switchToStickyPoint', dimensions.switchToStickyPoint);
        };

        var initDynamicDimensions = function () {
            // recount body height if review content height changes
            var contentHeightChangeEvents = [
                'comment-form-added', 'comment-form-removed', 'comment-added', 'comment-removed',
                'comment-collapsed', 'comment-expanded', 'comment-reply-added',
                'objectives-updated', 'objectives-form-visible', 'objectives-form-hidden',
                'summary-updated', 'summary-form-visible', 'summary-form-hidden',
                'review-details-updated', 'diff-mode-changed', 'view-range-change',
                'wiki-preview-on', 'wiki-preview-off',
                'tracked-branch:removed', 'tracked-branch:added'
            ].join(' ');
            var contentDimensionsChangeEvents = ['review-details-updated', 'editable-title-updated', 'comment-view-type-changed'].join(' ');
            var recountPageHeight = function () {
                if (!elements.scrollable) {
                    return;
                }

                var targetHeight = elements.scrollable.scrollHeight;
                if (elements.scrollable.id !== 'generalComments') {
                    targetHeight += dimensions.reviewHeaderHeight;
                }
                setBodyHeight(targetHeight);
            };

            var recountPageHeightWithThrottle = _.throttle(recountPageHeight, 200, {trailing: true});
            var recountPageHeightWithThrottleForWindowsResize = _.throttle(function () {
                dimensions.reviewHeaderHeight = $('.review-header').outerHeight(true);
                initStaticDimensions();
                recountPageHeight();
            }, 400, {trailing: true});

            var imageChangeEvents = ['frx-visible', 'comment-added', 'summary-updated', 'objectives-updated',
                'comment-reply-added'].join(' ');

            var loadImageWithThrottle = _.throttle(function () {
                $(elements.frxPane).find('img').each(function () {
                    var $t = $(this);
                    if (!$t.data('loaded')) {
                        $t.data('loaded', true);
                        $t.load(function () {
                            $(elements.frxPane).trigger('image-loaded');
                        })
                    }
                })
            }, 200, {trailing: true});

            var resizeReviewScrollableContentIfHeaderIsHigherThanNormal = function () {
                var headerHeight = $('.frxouter.activeFrx .frx-header-container').height();
                var $frxInner = $('.frxouter.activeFrx .frxinner');

                if (!$frxInner.length) {
                    return;
                }
                if (headerHeight > 80) { // if is higher than normal
                    var reviewContentHeight = $window.height() - dimensions.footerHeight
                        - dimensions.reviewToolbarHeight - dimensions.reviewSubHeaderButtons;
                    $frxInner.height(reviewContentHeight - headerHeight)
                        .data('hasCustomHeight', true);
                } else if ($frxInner.data('hasCustomHeight')) {
                    $frxInner.height('').data('hasCustomHeight', false);
                }
            };

            $(elements.frxPane)
                .on('frx-visible diff-mode-changed view-range-change current-frx-loaded', '.frxouter.activeFrx', function () {
                    if (this.id === 'generalComments') {
                        elements.scrollable = $('#generalCommentsInner').get(0);
                        return;
                    }
                    elements.scrollable = $(this).find('.frxinner').get(0);
                    CRU.COMMENT.reinitializeScrollTrackerForElement(elements.scrollable);
                    $(elements.scrollable).on('scroll', onScrollableElementScroll);
                })
                // setting body height immediately is very important for those events so they have higher priority
                .on('frx-visible current-frx-loaded', recountPageHeight)
                .on(contentHeightChangeEvents, '.frxouter.activeFrx', recountPageHeightWithThrottle)
                .on(imageChangeEvents, '.frxouter.activeFrx', loadImageWithThrottle)
                .on('image-loaded', recountPageHeightWithThrottle)
                .on(contentDimensionsChangeEvents, initStaticDimensions)
                .on(contentDimensionsChangeEvents, recountPageHeightWithThrottle)
                .on('comment-form-added', function (e) {
                    var $textarea = $(e.target).find('textarea');
                    makeTextareaResizable($textarea);
                    $textarea.on('textarea-resize', recountPageHeightWithThrottle);
                })
                .on('frx-header-unshelved view-range-change diff-mode-changed',
                resizeReviewScrollableContentIfHeaderIsHigherThanNormal);

            $window.on('resize', recountPageHeightWithThrottleForWindowsResize)
                .on('resize', _.throttle(resizeReviewScrollableContentIfHeaderIsHigherThanNormal, 100));


            setBodyHeight($window.height() - dimensions.reviewToolbarHeight - dimensions.footerHeight);

            // Fix the layout when STP banner added/removed
            AJS.bind('stp-licenseStatus-banner:created stp-licenseStatus-banner:destroyed', function () {
                initStaticDimensions();
                recountPageHeight();
            });

            $(document).on('aui-message-close', function (event, messageElement) {
                // analytics plugin does not deliver information about message element
                // so we use this fact to detect that analytics acknowlegment message has been closed
                if (typeof messageElement === 'undefined') {
                    initStaticDimensions();
                    recountPageHeight();
                }
            });
        };

        var initScroll = function () {
            $window.on('scroll', _.throttle(onScroll, 20, {trailing: true}));
        };

        var setBodyHeight = function (height) {
            dimensions.windowHeight = $window.height();
            dimensions.bodyMinHeight = dimensions.switchToStickyPoint + dimensions.windowHeight;
            var targetHeight = height + dimensions.switchToStickyPoint +
                dimensions.reviewToolbarHeight + dimensions.footerHeight + dimensions.reviewSubHeaderButtons;
            elements.$body.css({
                height: targetHeight < dimensions.bodyMinHeight ? dimensions.bodyMinHeight : targetHeight
            });
        };

        var onScroll = function () {
            triggerScrollStart();
            var windowScrollTop = $window.scrollTop();
            if (windowScrollTop >= dimensions.switchToStickyPoint) {
                if (!isSticky) {
                    isSticky = true;
                    elements.$body.trigger('sticky-headers-change', true);
                    movePage(dimensions.switchToStickyPoint);
                }
                setScrollableElementScrollPositionFromWindowScrollTop(windowScrollTop);
            } else {
                movePage(windowScrollTop);
                if (isSticky) {
                    isSticky = false;
                    elements.$body.trigger('sticky-headers-change', false);
                    setScrollableElementScrollPositionFromWindowScrollTop(windowScrollTop);
                }
            }
            triggerScrollEnd();
        };

        var setScrollableElementScrollPositionFromWindowScrollTop = function (windowScrollTop) {
            if (elements.scrollable) {
                isScrollTriggeredByWindow = true;
                if (windowScrollTop >= dimensions.switchToStickyPoint) {
                    elements.scrollable.scrollTop = windowScrollTop - dimensions.switchToStickyPoint;
                } else {
                    elements.scrollable.scrollTop = 0;
                }
                turnOffWindowScrollingFlag();
            }
        };

        var triggerScrollStart = function () {
            if (!isScrolling) {
                $window.trigger('scrollstart');
                isScrolling = true;
            }
        };

        var triggerScrollEnd = _.debounce(function () {
            if (isScrolling) {
                $window.trigger('scrollend');
                isScrolling = false;
            }
        }, 200);

        var turnOffWindowScrollingFlag = _.debounce(function () {
            isScrollTriggeredByWindow = false;
        }, 200);

        var onScrollableElementScroll = function (e) {
            if (isScrollTriggeredByWindow) {
                return;
            }
            var $target = $(e.target);
            var targetScrollTop = e.target.scrollTop;

            if ($target.data('lastScrollTop') === targetScrollTop) {
                // that means user scrolls horizontally so we don't care
                return;
            }
            $target.data('lastScrollTop', targetScrollTop);
            exports.scrollToPosition(targetScrollTop);
        };

        var movePage = function (position) {
            elements.page.scrollTop = position;
        };

        /**
         * Handle hiding of .frxSlider element during scrolling to improve IE9 rendering performance
         */
        var speedUpIE9 = function () {
            $window
                .on('scrollstart', function () {
                    $('.frxSlider').addClass('hidden');
                })
                .on('scrollend', function () {
                    $('.frxSlider').removeClass('hidden');
                });
        };

        var exports = {
            init: function () {
                elements.$sidebar = $('#content-resizable');
                elements.frxPane = document.getElementById('frx-pane');
                elements.$body = $(document.body);
                elements.page = document.getElementById('page');
                initStaticDimensions();
                initDynamicDimensions();
                initScroll();

                if ($.browser.msie && $.browser.version === '9.0') {
                    speedUpIE9();
                }
            },
            scrollToPosition: function (positionTop) {
                $window.scrollTop(positionTop + dimensions.switchToStickyPoint);
            },
            ensureElementVisible: function (element, options) {
                options = options || {};
                var $element = $(element);
                element = $element[0];//we handle element as string or DOM
                var distanceFromScrollTop = element.getBoundingClientRect().top - elements.scrollable.getBoundingClientRect().top;
                var elementHeight = $element.height();
                if (distanceFromScrollTop < 0 || elementHeight >= elements.scrollable.clientHeight) {
                    this.scrollToElement(element, options);
                }
                else if (distanceFromScrollTop + elementHeight > elements.scrollable.clientHeight) {
                    options.offset = elements.scrollable.clientHeight - elementHeight - options.offset;
                    this.scrollToElement(element, options);
                }
                else {
                    $element.trigger('scroll-to-element:finished');
                    if (options.onAfter) {
                        options.onAfter();
                    }
                }

            },
            scrollToElement: function (element, options) {
                // We have to set position of scrollable element properly
                // since it might not be synchronized with window scroll YET
                // Example case: switching between frxes
                setScrollableElementScrollPositionFromWindowScrollTop($window.scrollTop());
                options = options || {};
                element = $(element)[0];
                var scrollOffset = options && options.offset || 0;

                var elementTopInsideScrollable = element.getBoundingClientRect().top - elements.scrollable.getBoundingClientRect().top + elements.scrollable.scrollTop;
                var scrollToPosition = elementTopInsideScrollable + dimensions.switchToStickyPoint - scrollOffset;
                if (scrollToPosition < dimensions.switchToStickyPoint) {
                    scrollToPosition = dimensions.switchToStickyPoint;
                }

                var triggerScrollToElementFinished = function () {
                    $(element).trigger('scroll-to-element:finished');
                };
                if (options && options.initialScroll) {
                    // this has to be done to prevent browser to set saved scroll position before refresh
                    if (document.location.hash) {
                        $window.one('scroll', function (e) {
                            e.stopImmediatePropagation();
                            $window.scrollTop(scrollToPosition);
                        });
                    } else {
                        $window.scrollTop(scrollToPosition);
                        triggerScrollToElementFinished();
                    }
                } else {
                    var jQueryScrollToOptions = {
                        onAfter: FECRU.sequence(options.onAfter, triggerScrollToElementFinished)
                    };
                    //noinspection JSCheckFunctionSignatures Idea thinks that this is window.scrollTo(x,y)
                    $window.stop(true).scrollTo(scrollToPosition, jQueryScrollToOptions);
                }
            },
            getContentScrollTop: function () {
                var position = $window.scrollTop() - dimensions.switchToStickyPoint;
                return position < 0 ? 0 : position;
            }
        };
        return exports;
    })();

    CRU.UI.scrollReviewContentTo = pageScrolling.scrollToPosition;
    CRU.UI.ensureElementVisible = pageScrolling.ensureElementVisible;
    CRU.UI.scrollToElement = _.debounce(pageScrolling.scrollToElement, 100);
    CRU.UI.getReviewContentScrollTopPosition = pageScrolling.getContentScrollTop;

    cruUi.columnFillHeight = function () {
        var foot = $('#footer').outerHeight();
        //window - footer - subheaders buttons - roundingerrorhack
        var windowHeight = $(window).height() - foot - 1.3 - $('.review-header--buttons').height();
        var contentHeight = windowHeight + 1; // TODO where does this +1 come from
        var toolbarHeight = $('#review-navigation-top').outerHeight(true);
        var targetHeight = windowHeight - toolbarHeight;

        $("#content-shield").css({
            height: contentHeight
        });

        $("#content-navigation-panel, #frx-pane").css({
            height: targetHeight
        });

        cruUi.frxFillPane(targetHeight);
        reviewCSSRules.set('.frxinner', {
            height: (targetHeight - 77) + 'px'
        });
    };

    cruUi.initColumnResize = function (min) {
        $("#content-resizable").resizable({
            ghost: true,
            handles: "e",
            maxWidth: 600,
            minWidth: min || 310
        });

        var selector = "#content-resizable .ui-resizable-handle, #content-shield, .shielded";
        $(document).delegate(selector, "mousedown", function () {
            $("html").addClass("shielded");
        }).delegate(selector, "mouseup", function () {
            $("html").removeClass("shielded");
        });
    };

    cruUi.toggleTree = function () {
        var $pane = $("#content-resizable");
        if ($pane.is(".collapsed")) {
            $pane.width($pane.data("expandedWidth"))
                .removeClass("collapsed")
                .removeData("expandedWidth");
        } else {
            $pane.data("expandedWidth", $pane.width())
                .width("25px")
                .addClass("collapsed");
        }
        $(window).trigger('panes-resized');
    };

    cruUi.highlightElements = function ($elem, type) {
        var setBackgroundImage = function (value) {
            $elem.css('background-color', value);
        };
        var doHighlight = function (color, duration, delay) {
            if (delay) {
                setBackgroundImage(color);
                doHighlight(color, delay);
            }
            $elem.effect('highlight', {color: color}, duration, function () {
                setBackgroundImage('');
            });
        };

        switch (type) {
            case 'with-delay':
                doHighlight('#fffddd', 500, 2000);
                break;
            default:
                doHighlight('#fffee8', 1000);
                break;
        }
    };

    cruUi.frxFillPane = function (pane) {
        var isCompliant = !!$.support.opacity;// w3c or IE
        var full = (isCompliant ? pane : (pane - 1)) + "px";
        var half = (pane * 0.5) + "px";

        reviewCSSRules.set('#frxs .frxouter:last-child .frxbackground', {
            marginBottom: half
        });

        reviewCSSRules.set('#generalCommentsInner', {
            height: full
        });
    };

    // list of all issues that we have loaded so far
    var $loadedIssues = $();

    cruUi.loadInlineJiraIssues = function (issueKey, callback) {
        var $linkedIssues = $(".jira-issue-lazy-load").filter("[data-jira-issue-lazy-load='true']");
        if (issueKey) {
            $linkedIssues = $linkedIssues.filter("[data-jira-key='" + issueKey + "']");
        }
        $loadedIssues = $loadedIssues.add($linkedIssues);
        $linkedIssues.each(function (index) {
            var $issue = $(this);
            var jiraIssueKey = $issue.data("jira-key");
            var cruProjKey = $issue.data("cru-project-key");
            if (jiraIssueKey) {
                var params = {};
                if (cruProjKey) {
                    params.projectKey = cruProjKey;
                }
                CRU.UTIL.loadJiraIssueLink(jiraIssueKey, $issue, params, callback);
            }
        });
    };

    cruUi.reloadInlineJiraIssues = function (issueKeys, callback) {
        $loadedIssues.each(function (index) {
            var $issue = $(this);
            var jiraIssueKey = $issue.data("jira-key");
            var cruProjKey = $issue.data("cru-project-key");
            if (jiraIssueKey && (!issueKeys || issueKeys.indexOf(jiraIssueKey) !== -1)) {
                var params = {};
                if (cruProjKey) {
                    params.projectKey = cruProjKey;
                }
                CRU.UTIL.loadJiraIssueLink(jiraIssueKey, $issue, params, callback);
            }
        });
    };

    $(document).ready(function () {
        if ($("#content").length === 0) {
            // IT'S A TRAP! (might be an iframe that we're loading from)
            return;
        }
        // Give a warning if firebug is running
        // NB: do this before columnFillHeight() because this function may insert content into the page
        FECRU.UI.warnAboutFirebug(function () {
            cruUi.columnFillHeight();
        });

        // When resizing the window, resize the panes
        var resizeDelay = 200;
        FECRU.UI.setCompletedResizeTimeout(window, function () {
            cruUi.columnFillHeight();
            $window.trigger('panes-resized');
        }, resizeDelay);

        $("#content-resizable").bind('resizestop', function () {
            $window.trigger('panes-resized');
        });


        // And make sure the page is setup appropriately on first load
        cruUi.initColumnResize();
        cruUi.columnFillHeight();
        cruUi.loadInlineJiraIssues();
        pageScrolling.init();
    });
})(AJS.$, cssJs);
/*[{!crucible_ui_js_lxtg50s!}]*/;
/* END /2static/script/cru/crucible-ui.js */
/* START /2static/script/cru/util.js */
/**
 * Crucible utility functions that can be used from any crucible page.
 */

window.CRU = window.CRU || {};
CRU.UTIL = {};

(function ($) {
    var cruUtil = CRU.UTIL;
    /**
     * Crucible base url (without trailing '/').
     *
     * @param permaId optional review id
     */
    cruUtil.urlBase = function (permaId) {
        if (permaId) {
            return FECRU.pageContext + '/cru/' + permaId;
        } else {
            return FECRU.pageContext + '/cru';
        }
    };

    /**
     * Crucible JSON base url (without trailing '/').
     *
     * @param permaId optional review id
     */
    cruUtil.jsonUrlBase = function (permaId) {
        if (permaId) {
            return FECRU.pageContext + '/json/cru/' + permaId;
        } else {
            return FECRU.pageContext + '/json/cru';
        }
    };

    cruUtil.isReviewPage = function () {
        return typeof review !== 'undefined';
    };


    cruUtil.startAjaxDialogSpin = function () {
        $('body').addClass('ajax-dialog');
        AJS.dim();
    };

    cruUtil.stopAjaxDialogSpin = function () {
        AJS.undim();
        $('body').removeClass('ajax-dialog');
    };

    cruUtil.isAjaxDialogSpinning = function () {
        return cruUtil.isDimmed() && $('body').hasClass('ajax-dialog');
    };

    var _onReviewStateTransitCallbacks = {};
    var triggerCallbacks = function (command, resp) {
        for (var id in _onReviewStateTransitCallbacks) {
            if (_onReviewStateTransitCallbacks.hasOwnProperty(id)) {
                _onReviewStateTransitCallbacks[id](command, resp);
            }
        }
    };
    /**
     * The callback will be called when the state of review transits.
     *
     * @param callbackId : string -- enable more than one callbacks to be bound
     * @param callback : function ( command, resp )
     */
    cruUtil.onReviewStateTransit = function (callbackId, callback) {
        _onReviewStateTransitCallbacks[callbackId] = callback;
    };

    cruUtil.ajaxDialog = function (url, params, isFromStateTransition) {
        cruUtil.startAjaxDialogSpin();
        FECRU.AJAX.ajaxDo(url, params || {}, function (resp) {
            var complete = function () {
                if (isFromStateTransition) {
                    triggerCallbacks(params.command, resp);
                }
            };

            if (resp.worked) {
                if (resp.showDialog) {
                    cruUtil.stopAjaxDialogSpin();
                    try {
                        FECRU.DIALOG.getAjaxDialogContainer().html(resp.payload);
                        FECRU.DIALOG.triggerAjaxDialogLoaded();

                        complete();
                    } catch (e) {
                        alert(e);
                    }
                } else if (resp.redirect) {
                    complete();
                    // no need to undim
                    window.location = resp.payload;
                }
            }
            // !resp.worked handled by ajaxDo
        });
        return false;
    };

    cruUtil.stateTransition = function (transition, permaId, params) {
        var util = cruUtil;
        var url = util.jsonUrlBase(permaId) + '/changeStateAjax';
        var unsaved = CRU.UNSAVED;

        // Make sure there aren't any unsaved inputs on the page, and if there are, then provide a warning
        // and give the user the ability to cancel and save their inputs.
        if (unsaved) {
            if (!unsaved.confirmUnsubmittedInputs()) {
                return;
            }
            unsaved.clearWatchForUnsavedChanges();
        }

        params = params || {};

        $.extend(params, {
            command: transition
        });

        if (util.isReviewPage() && $.inArray(transition, ['action:completeReview', 'action:summarizeReview', 'action:closeReview']) >= 0) {
            // If completing or summarizing we need to warn if the review has been updated.

            util.startAjaxDialogSpin();
            CRU.REVIEW.UTIL.reviewUpdatedAjax({
                done: function () {
                    var reviewUpdated = $('body').hasClass('review-updated');
                    if (reviewUpdated) {
                        CRU.REVIEW.UTIL.warnAboutReviewUpdates({reshowWarning: true});
                    }
                    util.stopAjaxDialogSpin();
                    return util.ajaxDialog(url, $.extend(params, {reviewUpdated: reviewUpdated}), true);
                }
            });
            return false;

        } else {
            return util.ajaxDialog(url, params, true);
        }
    };

    cruUtil.editDetailsFormChange = false;
    cruUtil.checkEditForm = function (done) {
        if (cruUtil.editDetailsFormChange) {
            CRU.REVIEW.UTIL.postEditDetailsForm(done);
        } else {
            if (done) {
                done();
            }
        }
        return false;//do a link action if called from <a>
    };

    cruUtil.command = function (cmd, pid, button) {
        var perma = pid || permaId;
        if (button) {
            button.disabled = true;
        }
        var donext = function () {
            var url = cruUtil.urlBase(perma);
            FECRU.XSRF.postUri(url + '/' + cmd);
        };
        //check and post the editDetailsForm if it has changed
        cruUtil.checkEditForm(donext);
    };


    cruUtil.createBlankReview = function (params) {
        var url = cruUtil.jsonUrlBase() + '/createReviewDialog';
        return cruUtil.ajaxDialog(url, params);
    };

    cruUtil.createSnippet = function (params) {
        var url = cruUtil.jsonUrlBase() + '/createSnippetDialog';
        return cruUtil.ajaxDialog(url, params);
    };

    cruUtil.addToReview = function (params) {
        var url = cruUtil.jsonUrlBase() + '/createDialog';
        return cruUtil.ajaxDialog(url, params);
    };

    cruUtil.isAnyDialogShowing = function () {
        return AJS && AJS.popup && typeof AJS.popup.current !== 'undefined' && AJS.popup.current !== null;
    };

    cruUtil.isAnyOverlayShowing = function () {
        return $('.review-overlay.review-overlay__open').length > 0;
    };

    cruUtil.isDimmed = function () {
        return !!AJS.dim.dim;
    };

    cruUtil.makeCssRule = function (selector, ruleBody) {
        var styleSheet = document.styleSheets[0];
        var index = 0;
        if (styleSheet.insertRule) {
            styleSheet.insertRule(selector + '{' + ruleBody + '}', index);
            return styleSheet.cssRules[index].style;
        } else {
            // Internet Explorer's version.
            styleSheet.addRule(selector, ruleBody, index);
            return styleSheet.rules[index].style;
        }
    };

    cruUtil.createIdeSrc = function (linkUrl, frxId) {
        var src = linkUrl + '&id=' + Math.floor(Math.random() * 1000);
        if (frxId) {
            src += '&line=' + CRU.REVIEW.UTIL.getTopVisibleLineNumber(frxId);
        }
        return src;
    };

    cruUtil.loadJiraIssueLink = function (issueKey, $target, params, done) {
        if (!issueKey) {
            throw "JIRA issue key required";
        }
        if (!$target) {
            throw "Target container to insert issue details into required";
        }

        var isReviewIssue = ($target.attr("data-review-jira-issue") === "true");
        var hideIssueTitle = ($target.attr("data-hide-issue-title") === "true");

        var defaults = {
            shouldGetIssueMetadata: isReviewIssue,
            hideIssueTitle: hideIssueTitle,
            maxTitleLength: 75,
            key: issueKey
        };

        var data = $.extend({}, defaults, params);

        var getIssueDetails = function () {
            AJS.$.ajax({
                url: FECRU.pageContext + '/json/action/issue-inline.do',
                data: data,
                type: "GET",
                dataType: "json",
                cache: false,
                success: function (resp) {
                    if (resp.foundIssue || (resp.credentialsRequired && resp.credentialsRequired.length)) {
                        // only display html if we found an issue (no errors)
                        $target.html(resp.html);
                    }

                    if (!$target.find(".ual-authenticate").length) {
                        $target.attr("data-jira-issue-lazy-load", "false");
                    }

                    $target.find(".ual-authenticate").bind("click", function () {
                        FECRU.OAUTH.getEventProducer($(this).attr("href")).authorized(function () {
                            FECRU.HOVER.invalidateCache(FECRU.HOVER.CACHE_FOREVER, issueKey);
                            CRU.UI.loadInlineJiraIssues();
                        });
                    });

                    if (data.shouldGetIssueMetadata) {
                        if (resp.canLogWork) {
                            AJS.$("#time-spent").addClass("submit-jira-time");
                            AJS.$("#linked-jira-log-work").show();
                        }
                        if (resp.subtasksConfigured && !resp.issueIsSubtask) {
                            AJS.$("body").addClass("jiraSubtasksVisible");
                        } else {
                            AJS.$("body").removeClass("jiraSubtasksVisible");
                        }
                    }

                    done && done($target);
                },
                error: function (jqXHR, textStatus, errorThrown) {
                    // dont display jira errors in the UI
                    $target.attr("data-jira-issue-lazy-load", "false");
                }
            });
        };

        getIssueDetails();
    };

    // this is a method to handle legacy "checkbox" style user pickers via autocomplete
    cruUtil.addUserCheckbox = function (id, user) {
        var userid = user.dbId;
        var $elTarget = AJS.$('#' + id + '_rc_' + userid);

        if (!$elTarget.length) {
            // checkbox doesnt exist yet
            $elTarget = AJS.$('<span><input type="checkbox"/><label></label></span>');
            $elTarget.attr('id', id + '_rc_' + userid);
            $elTarget.children('input')
                .attr('name', id)
                .attr('value', user.id);
            $elTarget.children('label')
                .attr('for', id + '_rc_' + userid)
                .text(user.displayPrimary);

            AJS.$('#' + id + '_checkboxes').append($elTarget);
        }
        $elTarget.children('input').attr('checked', 'checked');
        $elTarget.show();
    };

})(AJS.$);
/*[{!util_js_6z0350x!}]*/;
/* END /2static/script/cru/util.js */
/* START /2static/script/cru/review/editableHeader.js */
window.CRU = window.CRU || {};
if (!CRU.REVIEW) {
    CRU.REVIEW = {};
}
if (!CRU.REVIEW.INLINE) {
    CRU.REVIEW.INLINE = {};
}

(function ($) {
    var reviewInline = CRU.REVIEW.INLINE;
    var CON_titleAndButtonsMargin = 90;
    var keyCode = AJS.$.ui.keyCode;

    var headerAlreadySetup = false;
    var reSetupTitle = null;
    /**
     *
     * @param name the name of the field to be used in user error messages
     * @param display selector for the normal display
     * @param input selector for the input field
     */
    reviewInline.setUpEditableHeader = function (name, display, input, isUpdate) {
        if (headerAlreadySetup && !isUpdate) {
            return;
        }
        headerAlreadySetup = true;
        var $reviewHeadInput = AJS.$(input);
        var $inputField = $reviewHeadInput.children('.input');
        var $submitTitle = $reviewHeadInput.children('.submit-title');

        AJS.$(display + '.editable').click(function (e) {
            var $target = AJS.$(e.target);
            if ($target.closest('a').length === 1) {
                return true;
            }
            AJS.$(this).hide();
            $reviewHeadInput.show();
            $inputField.focus();
        });

        CRU.UNSAVED.watchForUnsavedChanges($inputField, name);

        $inputField.keypress(function (e) {
            if (e.keyCode === keyCode.ENTER) {
                updateReviewTitle();
                e.preventDefault();
            } else if (e.keyCode === keyCode.ESCAPE) {
                discardNewTitle();
            }
        });

        var discardNewTitle = function () {
            if ($submitTitle.hasClass('spinner')) {
                return;
            }
            $reviewHeadInput.hide();
            AJS.$(display).show();

            // this needs a timeout because of a conflict with leaving the input box (or something like that)
            setTimeout(function () {
                var title = $reviewHeadInput.children('.backup').val();
                $inputField.val(title);
            }, 200);
        };

        var updateReviewTitle = function () {
            $submitTitle.addClass('spinner');
            var util = CRU.UTIL;
            var url = util.jsonUrlBase(permaId) + '/updateReviewTitleAjax';
            var params = {
                title: $inputField.val()
            };
            FECRU.AJAX.ajaxDo(url, params, function (resp) {
                $submitTitle.removeClass('spinner');
                if (resp.worked) {
                    AJS.$(display).children('.title').html(resp.titleHtml).attr('title', resp.title);
                    $reviewHeadInput.children('.backup, .input').val(resp.title);
                    discardNewTitle();
                }
            });
        };

        $submitTitle.click(updateReviewTitle);
        $reviewHeadInput.children('.discard-title').click(discardNewTitle);

        if (!reSetupTitle) {
            reSetupTitle = function () {
                reviewInline.setUpEditableHeader(name, display, input, true);
            }
        }
    };

    reviewInline.reSetupEditableTitle = function () {
        reSetupTitle && reSetupTitle();
    };

    var hasAdjustedReviewTitle = false;
    reviewInline.adjustReviewTitle = function () {
        var resizeReviewTitle = function () {
            var $buttons = $('#page-actions');

            if (!$buttons.length) {
                $buttons = $('#context-navigation')
            }

            var buttonLeft = $buttons.position().left;
            var titleWidth = buttonLeft - CON_titleAndButtonsMargin;
            $('#reviewHead, #reviewHeadInput').width(titleWidth);
        };
        if (!hasAdjustedReviewTitle) {
            $(window).bind('resize', AJS.$.throttle(400, function () {
                resizeReviewTitle();
            }));
            hasAdjustedReviewTitle = true;
        }
        resizeReviewTitle();
    };

    // from here is the logic of setting up the new editable title on review page
    // these change should be soon applied to snippet page when its page header is changed
    reviewInline.setUpReviewEditableTitle = function (name, $title) {
        var $titleInput = $title.find('.title-input > input');
        var title = $titleInput.val();

        $title.on('click', 'a', function (e) {            // Right click fires a click event in Firefox but not in Chrome
            if ($(this).parent().is('.jira-hover-trigger')) {
                // according to the UserTextRender, the jira issue links will be encapsulated in a span.jira-hover-trigger
                if (FECRU.isRightClick(e) || !FECRU.openInSameTab(e)) {
                    return;
                } else {
                    e.preventDefault();
                }
            } else {
                e.stopPropagation();
            }
        });

        $title.click(function (e) {
            var $target = $(e.target);
            if ($target.parent().is('.jira-hover-trigger')) {
                return;
            }

            if ($title.is('.read-mode')) {
                var width = $title.width();
                $titleInput.css('width', width);
                $title.removeClass('read-mode');
                $titleInput.select();
            }

            e.stopPropagation();
        });

        var submitAndSaveTitle = function () {
            var newTitle = $titleInput.val();
            if (newTitle === title) {
                $title.addClass('read-mode');
                return;
            }

            $title.removeClass('read-mode')
                .addClass('saving-mode');
            var util = CRU.UTIL;
            var url = util.jsonUrlBase(permaId) + '/updateReviewTitleAjax';
            var params = {
                title: newTitle,
                adgified: true
            };

            newTitle = $.trim(newTitle);

            if (newTitle) {
                $title.find('.title-content').text(newTitle);
            } else {
                $title.find('.title-content').html('<em>Untitled</em>');
            }

            FECRU.AJAX.ajaxDo(url, params, function (resp) {
                if (resp.worked) {
                    $title.replaceWith(resp.titleHtml);
                    $('#frx-pane').trigger('editable-title-updated');
                }
            });
        };

        $title.find('.aui-button.submit').click(function (e) {
            submitAndSaveTitle();
            e.stopPropagation();
        });

        $title.find('.aui-button.cancel').click(function (e) {
            $title.addClass('read-mode');
            $titleInput.val(title);
            e.stopPropagation();
        });

        $titleInput.keydown(function (e) {
            if (e.keyCode === keyCode.ENTER) {
                submitAndSaveTitle();
                e.stopPropagation();
                e.preventDefault();
            }
        });

        $(document).click(function () {
            if (!$title.is('.read-mode') && !$title.is('.saving-mode')) {
                submitAndSaveTitle();
            }
        });

        return {
            setTitle: function (newTitle, newTitleHtml) {
                $title.find('.title-content').html(newTitleHtml);
                title = newTitle;
                $titleInput.val(newTitle);
            }
        }
    }


})(AJS.$);
/*[{!editableHeader_js_td3k516!}]*/;
/* END /2static/script/cru/review/editableHeader.js */
/* START /2static/script/cru/patch-ui.js */
window.CRU = window.CRU || {};
CRU.PATCHES = (function ($) {

    var fecruAjax = FECRU.AJAX;

    function ajaxCall($controls, params, callback) {
        if ($controls.is('.disabled')) {
            return;
        }

        params = params || {};
        if (params.patchId == null) {
            params.patchId = $controls.attr('id').replace('patch-controls-', '');
        }

        fecruAjax.startSpin($controls);
        $controls.find('select').prop('disabled', true);
        var $controlButtons = $controls.find('.patch-control-buttons');
        $controlButtons.addClass('disabled');
        var url = CRU.UTIL.jsonUrlBase(permaId) + '/anchor-patch/';

        var cancelled = false;
        var ended = false;

        fecruAjax.ajaxDo(url, params, function (resp) {
            $controls.data('cancel', null);
            if (cancelled) {
                return;
            }
            ended = true;

            //replace controls

            var $messagesContainer = $("#anchor-messages-container");
            $messagesContainer.html('');
            if (resp.showErrors) {
                var errorTitle;
                if (params && params.allrepos) {
                    errorTitle = 'No repository found to anchor patch to';
                } else if (params && params.anchorSource) {
                    errorTitle = 'Crucible cannot anchor the patch to this repository'
                } else {
                    errorTitle = null;
                }

                $.each(resp.errors, function (index, value) {
                    AJS.messages.warning($messagesContainer, {
                        title: errorTitle,
                        body: value
                    })
                });
            }

            if (resp.showMessages) {
                $.each(resp.messages, function (index, value) {
                    AJS.messages.success($messagesContainer, {
                        body: value
                    })
                });
            }

            endAjaxCall($controls, $controlButtons);
            callback && callback(resp);
        });

        $controls.data('cancel', function cancel() {
            if (ended) {
                return;
            }
            cancelled = true;
            callback && callback();
            endAjaxCall($controls, $controlButtons);
        });
    }

    function endAjaxCall($controls, $controlButtons) {
        fecruAjax.stopSpin($controls[0], 'span');

        $controls.find('select').prop('disabled', false);
        $controlButtons.removeClass('disabled');
    }

    function removePaths($repoSelect, $pathSelectSection) {
        $repoSelect.val('');
        $pathSelectSection.addClass('hidden').data('forRepo', '');
    }

    function populatePaths($repoSelect, $pathSelectSection, optionsString, anchorSource) {

        if ($pathSelectSection.data('forRepo') === anchorSource) {
            return;
        }

        if (optionsString == null) {
            removePaths($repoSelect, $pathSelectSection);
            return;
        }

        $repoSelect.val(anchorSource);

        var $pathSelect = $pathSelectSection.find("select.anchored-path-edit");
        if (optionsString !== "") {
            $pathSelect.html(optionsString);
            $pathSelectSection.removeClass('hidden');
        } else {
            $pathSelectSection.addClass('hidden');
        }
        $pathSelectSection.data('forRepo', anchorSource);
    }

    function anchorPatch($controls, params) {
        $controls.removeClass('editing viewing').addClass('anchoring');
        ajaxCall($controls, params, function (resp) {
            $controls.removeClass('anchoring');

            if (resp && resp.worked) {
                if (resp.anchorSucceeded) { // true if the anchor succeeds or the unanchor succeeds, but not if there are errors either way.
                    var anchored = !!resp.anchorRepo;
                    $controls.addClass('viewing')
                        .toggleClass('anchored', anchored)
                        .toggleClass('unanchored', !anchored);

                    var $currentAnchor = $controls.find('.current-anchor');
                    $currentAnchor.children('.anchored-source').text(resp.anchorRepo);
                    $currentAnchor.children('.anchored-path').text(resp.anchorPath);
                    updateIterablePatches(params)
                } else {
                    $controls.addClass('editing');
                    updateIterablePatches(null)
                }

                populatePaths(
                    $controls.find('.anchored-source-edit'),
                    $controls.find('.anchor-path-selection'),
                    resp.candidatePaths,
                    resp.anchorRepo || params && params.anchorSource);
            } else if (!resp) {
                // cancelled
                removePaths(
                    $controls.find('.anchored-source-edit'),
                    $controls.find('.anchor-path-selection'));
                updateIterablePatches(null)
            }
        });
    }

    function getPaths($controls, anchorSource, callback) {
        if (!anchorSource) {
            callback && callback();
            return;
        }

        var $pathSelectSection = $controls.find('.anchor-path-selection');
        if ($pathSelectSection.data('forRepo') === anchorSource) {
            callback && callback();
        } else {
            var params = {
                anchorSource: anchorSource,
                showCandidatePaths: true
            };
            ajaxCall($controls, params, function (resp) {
                if (resp && resp.worked) {
                    populatePaths(
                        $controls.find('.anchored-source-edit'),
                        $pathSelectSection,
                        resp.candidatePaths,
                        anchorSource);

                    callback && callback();
                } else if (!resp) {
                    // cancelled
                    removePaths(
                        $controls.find('.anchored-source-edit'),
                        $controls.find('.anchor-path-selection'));
                }
            });
        }
    }

    function updateIterablePatches(params) {
        var $choosePatch = $('#choose-existing-patch');
        if (!params) {
            $choosePatch.html('');
            $('#add-to-existing-patch').prop('disabled', true);
            $('#new-patch').prop('checked', true);
        } else {
            getIterablePatches($choosePatch, params.patchId)
        }
    }

    function getIterablePatches($target, patchId) {
        var url = CRU.UTIL.jsonUrlBase(permaId) + '/iterable-patches/';
        fecruAjax.startSpin($('#anchor-repository'));
        fecruAjax.ajaxDo(url, {patchId: patchId}, function (resp) {
            fecruAjax.stopSpin($('#anchor-repository'));
            if (resp.found === 'true') {
                $('#patch-action').show();
                $target.html(resp.payload);
                var $add = $("#add-to-existing-patch");
                $add.prop('disabled', false);
                $add.prop('checked', true);
                $target.find('input').first().prop('checked', 'true')
            } else {
                $target.html('');
            }
        });
    }

    return {
        getPaths: getPaths,
        anchorPatch: anchorPatch
    };
})(AJS.$);
/*[{!patch_ui_js_yvkx50u!}]*/;
/* END /2static/script/cru/patch-ui.js */
/* START /2static/script/cru/review/review-history.js */
window.CRU = window.CRU || {};
if (!CRU.REVIEW) {
    CRU.REVIEW = {};
}
if (!CRU.REVIEW.HISTORY) {
    CRU.REVIEW.HISTORY = {};
}

(function ($) {
    var historyDialog = null;

    CRU.REVIEW.HISTORY.showPage = function (permaId) {
        if (AJS.dropDown.current) {
            AJS.dropDown.current.hide();
        }

        if (!permaId) {
            AJS.log("I don't know which review to give you history for.");
            return;
        }

        historyDialog && historyDialog.remove();
        historyDialog = FECRU.DIALOG.create(1200, 700, "cru-review-history-dialog");

        var iframeStyle = "style='overflow:hidden;width:100%;height:" + (historyDialog.height - 48 - 44 - 23 - 17) + "px'"; // @2ADG (-17) for adg purposes
        var cs = "<iframe frameborder='0' id='reviewHistoryIframe' name='reviewHistoryIframe' scrolling='no' src='" + CRU.UTIL.urlBase(permaId) + "/reviewHistoryWrapper" + "' " + iframeStyle + "></iframe>";

        var header = "History of Review " + permaId;
        historyDialog.addHeader(header)
            .addPanel("History", cs);

        historyDialog.addButton("Done", function (dialog) {
            dialog.hide();
        }).show();

        AJS.$("#cru-review-history-dialog").data("dialog", historyDialog);//stores the object so we can access it from its contents
    };

    CRU.REVIEW.HISTORY.setupLinks = function () {
        var $document = AJS.$(document);
        $document.delegate("a.action-link", "click", function () {
            parent.top.AJS.$("#cru-review-history-dialog").data("dialog").hide();
        });
        $document.delegate("a.comment-link", "click", function () {
            var comment_nav = parent.top.CRU.COMMENT.NAV;
            var comment_id = AJS.$(this).prop('hash').replace('#c', '');

            var scrollToMap = comment_nav.navigateFindComment({commentId: comment_id});
            comment_nav.navigateDirectlyToElement({commentId: comment_id}, scrollToMap);
        });
        $document.delegate("a.frx-link", "click", function () {
            var frx_id = AJS.$(this).prop('hash').replace('#CFR-','');

            parent.top.CRU.FRX.NAV.gotoFrx({frxId: frx_id, destination: ''});
        });

    };
})(AJS.$);
/*[{!review_history_js_4j3b51c!}]*/;
/* END /2static/script/cru/review/review-history.js */
/* START /2static/script/cru/review/widgets/sliders.js */
/**
 * Range slider where the handles meet at a point (but don't overlap).
 */

CRU.WIDGETS = {};
(function () {
    function draggableRangeSlider(options) {

        var $slider = AJS.$(options.elem);
        var activeNub;
        var leftNub;
        var rightNub;

        var prevLeftValue;
        var prevRightValue;
        var prevLeftSlideValue;
        var prevRightSlideValue;

        function focused(nub) {
            return activeNub === nub;
        }

        /*
         * When mutating the slider values, don't cache the values of the slider
         * since mutating causes slider change events to be triggered.
         */
        function val(nub, value) {
            if (value !== undefined) {
                return $slider.slider('values', nub === leftNub ? 0 : 1, value);
            } else {
                return $slider.slider('values', nub === leftNub ? 0 : 1);
            }
        }

        $slider.slider({
            orientation: 'horizontal',
            range: true,
            min: options.min,
            max: options.max,
            values: options.values,

            start: function (event, ui) {
                activeNub = event.target || event.srcElement;
                if (options.fixedMin && focused(leftNub)) {
                    event.preventDefault();
                    event.stopPropagation();
                    return;
                }
                prevLeftValue = prevLeftSlideValue = val(leftNub);
                prevRightValue = prevRightSlideValue = val(rightNub);
            },

            slide: function (event, ui) {
                // Prevent the nubs from overlapping, effectively bumping them along.
                if (val(leftNub) === val(rightNub)) {
                    if (focused(leftNub)) {
                        val(rightNub, val(rightNub) + 1);
                    }
                    if (focused(rightNub)) {
                        val(leftNub, val(leftNub) - 1);
                    }
                } else if (val(rightNub) < options.STEP) {
                    if (options.fixedMin) {
                        event.preventDefault();
                        event.stopPropagation();
                        return;
                    }
                }
            },

            change: function (event, ui) {
                // Prevent the nubs from overlapping at each end.
                if (focused(leftNub) && val(leftNub) === options.max) {
                    val(leftNub, val(leftNub) - 1);
                } else if (focused(rightNub) && val(rightNub) === options.min) {
                    val(rightNub, val(rightNub) + 1);
                }

                if (!(val(leftNub) === prevLeftSlideValue && val(rightNub) === prevRightSlideValue)) {
                    prevLeftSlideValue = val(leftNub);
                    prevRightSlideValue = val(rightNub);
                    return options.slide(val(leftNub), val(rightNub));
                }
            },

            stop: function (event, ui) {
                if (!(val(leftNub) === prevLeftValue && val(rightNub) === prevRightValue)) {
                    return options.change(val(leftNub), val(rightNub));
                }
            }
        });

        var $leftNub = $slider.find('.ui-slider-handle:first');
        leftNub = $leftNub[0];
        rightNub = $slider.find('.ui-slider-handle:last')[0];

        if (options.fixedMin) {
            $leftNub.addClass('ui-slider-handle-locked')
        }
    }

    /**
     * Slider for a given set of datapoints.
     */
    CRU.WIDGETS.datapointSlider = (function () {

        // Must be odd so that there is no single median tickmark between adjacent datapoints.
        var STEP = 6 + 1;

        function tickmarks(datapoints) {
            var result = [];
            for (var i = 0, len = datapoints.length; i < len; i++) {
                result.push(STEP * i + 1);
            }
            return result;
        }

        function quantizeTick(tick) {
            return Math.round((tick - 1) / STEP) * STEP + 1;
        }

        function leftTick(val) {
            return val + 1;
        }

        function leftVal(tick) {
            return tick - 1;
        }

        function rightTick(val) {
            return val;
        }

        function rightVal(tick) {
            return tick;
        }

        function createSet() {
            var result = {};
            var i;
            var len;

            for (i = 0, len = arguments.length; i < len; i++) {
                if (arguments[i]) {
                    result[arguments[i]] = true;
                }
            }
            return result;
        }

        return function (settings) {
            var datapoints = settings.datapoints;
            var tick2dp = {};
            var dp2tick = {};
            (function () {
                var ticks = tickmarks(datapoints);
                for (var i = 0, len = ticks.length; i < len; i++) {
                    tick2dp[ticks[i]] = datapoints[i];
                    dp2tick[datapoints[i]] = ticks[i];
                }
            })();

            var selectedDPs = {
                start: settings.start || datapoints[0],
                end: settings.end || datapoints[datapoints.length - 1]
            };
            var activeDPs = createSet(selectedDPs.start, selectedDPs.end);

            draggableRangeSlider({
                elem: settings.elem,
                min: leftVal(1),
                max: rightVal((datapoints.length - 1) * STEP + 1),
                values: [leftVal(dp2tick[selectedDPs.start]), rightVal(dp2tick[selectedDPs.end])],
                fixedMin: settings.fixedMin,
                STEP: STEP,

                slide: function (leftVal, rightVal) {
                    var newDPs = createSet(tick2dp[quantizeTick(leftTick(leftVal))], tick2dp[quantizeTick(rightTick(rightVal))]);
                    var dp;

                    for (dp in activeDPs) {
                        if (!newDPs[dp]) {
                            settings.inactive(dp);
                        }
                    }
                    for (dp in newDPs) {
                        if (!activeDPs[dp]) {
                            settings.active(dp);
                        }
                    }

                    activeDPs = newDPs;
                },

                change: function (left, right) {
                    var start = tick2dp[quantizeTick(leftTick(left))];
                    var end = tick2dp[quantizeTick(rightTick(right))];

                    // Snap nubs to the exact corresponding slider value for each datapoint.
                    AJS.$(settings.elem).slider('values', 0, leftVal(dp2tick[start]));
                    AJS.$(settings.elem).slider('values', 1, rightVal(dp2tick[end]));

                    if (start && end && !(start === selectedDPs.start && end === selectedDPs.end)) {
                        selectedDPs.start = start;
                        selectedDPs.end = end;
                        return settings.change(selectedDPs.start, selectedDPs.end);
                    }
                }
            });

            (function () {
                for (var dp in activeDPs) {
                    if (activeDPs.hasOwnProperty(dp)) {
                        settings.active(dp);
                    }
                }
            })();

        };
    })();
})();
/*[{!sliders_js_sdt6522!}]*/;
/* END /2static/script/cru/review/widgets/sliders.js */
/* START /2static/script/cru/review/widgets/scroll-tracker.js */
(function () {
    /**
     * Bind a callback that fires when scrolling is completed on matching elements.
     *
     * A scroll is considered complete after completionDelay ms have passed since
     * the last scroll event.
     */
    var setCompletedScrollTimeout = function ($object, callback, completionDelay) {
        completionDelay = completionDelay || 100;
        var timeout;

        $object.scroll(function () {
            if (completionDelay > 0 && timeout) {
                clearTimeout(timeout);
            }
            timeout = setTimeout(callback, completionDelay);
        });
    };

    /**
     * Bind a scroll tracker that monitors a scrollable container for matching
     * elements.
     *
     * After each completed scroll, if the currently active element is still in
     * the viewport/container, it remains active; if no longer in the viewport,
     * the top most element becomes active. If no tracked elements are in
     * the container, the active element prior to the completed scroll (if any)
     * remains active.
     *
     * The options.active and options.deactive callbacks are fired when the newly
     * calculated active element differs from the previously active element. The
     * options.outofview callback is called the first time the active element
     * becomes out of view (even partially).
     *
     * @param {jQuery selector|callback} options.selector expression/callback for elements to track
     * @param {jQuery selector} options.containerId id of scrollable container (or the window if unspecified) where the tracked elements live
     * @param {Number} options.threshold maximum number of px from the top/bottom of the container to start tracking elements
     * @param {Function} options.active callback where <tt>this</tt> is bound to the active element
     * @param {Function} options.deactive optional callback where <tt>this</tt> is bound to the previously active element
     * @param {Function} options.outofview optional callback where <tt>this</tt> is bound to the active element
     * @param {Number} options.delay optional delay (in ms) before a scroll is considered completed
     * @return {object} handle to the scroll tracker with methods to manipulate it's behaviour
     */
    CRU.WIDGETS.makeScrollTracker = function (options) {
        var trackingEnabled = true;
        var trackedElements;
        var currentElement;
        var hasBeenOutOfView = false;
        var ignoreNextScroll = false;
        var sticky = false;

        var $container;
        options.containerId = options.containerId || '';
        if (options.containerId) {
            $container = AJS.$('#' + options.containerId);
        } else {
            $container = AJS.$(window);
        }
        options.threshold = options.threshold || 0;

        function lookupElements() {
            trackedElements = AJS.$.isFunction(options.selector) ? options.selector() : AJS.$(options.selector);
        }

        function filterElements(threshold) {
            threshold = typeof threshold === 'number' ? threshold : calcThreshold();
            var result;
            trackedElements.each(function (i) {
                if (AJS.$(this).filter(':in-viewport-vert(' + threshold + ', ' + options.containerId + ')').length === 1) {
                    result = this;
                    return false;  // break
                }
            });
            return result;
        }

        function calcThreshold() {
            return Math.min($container.scrollTop(), options.threshold);
        }

        function topMostElement() {
            if (!trackedElements) {
                lookupElements();
            }
            return filterElements();
        }

        function updateCurrentElementAndFireEvents(newCurrentElement, shouldFireActivation) {
            if (currentElement && options.deactive) {
                options.deactive.call(currentElement);
            }
            currentElement = newCurrentElement;
            hasBeenOutOfView = false;
            if (currentElement && shouldFireActivation) {
                options.active.call(currentElement);
            }
        }

        function fireEventsIfOutOfView() {
            if (options.outofview && isOutOfView(currentElement)) {
                options.outofview.call(currentElement);
                hasBeenOutOfView = true;
            }
        }

        function isOutOfView(element) {
            var $element = AJS.$(element);
            var offset = $element.offset();

            return offset.top < $container.scrollTop() || $container.scrollTop() + $container.height() < offset.top + $element.height();
        }

        function mainloop() {
            if (!trackingEnabled) {
                return;
            }

            if (ignoreNextScroll) {
                ignoreNextScroll = false;
                return;
            }

            var topElement;
            if (!(currentElement && sticky && AJS.$(currentElement).is(':in-viewport-vert(' + calcThreshold() + ', ' + options.containerId + ')'))) {
                topElement = topMostElement();
                if (topElement && topElement !== currentElement) {
                    sticky = false;
                    updateCurrentElementAndFireEvents(topElement, true);
                }
            }
            if (currentElement && !hasBeenOutOfView) {
                fireEventsIfOutOfView();
            }
        }

        setCompletedScrollTimeout(
            $container,
            mainloop,
            options.delay
        );

        AJS.$(document).ready(function () {
            lookupElements();
        });

        return {

            /**
             * Ignore the next scroll event.
             *
             * Useful for when you're programatically scrolling the page and don't want
             * the scroll tracker to recalculate the active element after that scroll.
             *
             * A typical calling pattern might be:
             * <pre>
             *     scrollTracker.ignoreNextScroll();
             *     // programatically scroll to `elem`
             *     scrollTracker.setCurrentElement(elem);
             * </pre>
             *
             * @see setCurrentElement
             */
            ignoreNextScroll: function () {
                ignoreNextScroll = true;
            },

            /**
             * Set the currently active element.
             *
             * Useful after calling ignoreNextScroll to programatically scroll
             * to a specific element.
             *
             * If element is not equal to getCurrentElement() this:
             * - will fire options.deactive,
             * - depending on fireActivation, may or may not fire options.active,
             * - depending on whether the element is out of view, may fire
             *   options.outofview
             *
             * @param {DOMElement} element the element to set as the active one
             * @param {Boolean} fireActivation whether to fire options.active (if applicable) for element (defaults to false)
             *
             * @see ignoreNextScroll
             */
            setCurrentElement: function (element, fireActivation) {
                fireActivation = fireActivation || false;

                if (element !== currentElement) {
                    updateCurrentElementAndFireEvents(element, fireActivation);
                }
                fireEventsIfOutOfView();
            },

            /**
             * Return the currently active element or undefined if there is none.
             */
            getCurrentElement: function () {
                return currentElement;
            },

            /**
             * Reevaluate the set of tracked elements, using the originally
             * provided selector expression/callback.
             *
             * Useful when tracked elements are removed from- or added to the DOM,
             * or their visiblity changes.
             */
            rescan: function () {
                lookupElements();
                // Calculate the new current element.
                mainloop();
            },

            /**
             * Returns the top most element visible in the actual container.
             *
             * @param threshold optional margin for the 'viewport'
             */
            getAbsoluteTopElement: function (threshold) {
                return filterElements(threshold || 0);
            },

            /**
             * Make the current element sticky, so that as long as it is in the viewport
             * it remains the current element.
             */
            makeCurrentElementSticky: function () {
                sticky = true;
            },

            setTrackingEnabled: function (enabled, ignoreNext) {
                trackingEnabled = enabled;
                ignoreNext = ignoreNext || false;
                if (ignoreNext === true) {
                    this.ignoreNextScroll();
                }
            }
        };
    };
})();
/*[{!scroll_tracker_js_09xq521!}]*/;
/* END /2static/script/cru/review/widgets/scroll-tracker.js */
/* START /2static/script/cru/review/wiki/wiki-preview.js */
(function () {
    window.CRU = window.CRU || {};
    CRU.REVIEW = CRU.REVIEW || {};
    var getWikiPreviewStruct = function ($container, filter) {
        var $previewButton = $container.find(".wiki-preview-button");
        var $textarea = $container.find("textarea" + (filter || ""));
        var $editOnly = $container.find(".edit-only");
        var $previewPane = $container.find(".wiki-preview-pane" + (filter || ""));
        var $previewSpinner = $container.find(".wiki-preview-button-spinner");
        var wikiText = $textarea.val();

        return {
            container: $container,
            previewButton: $previewButton,
            textarea: $textarea,
            editOnly: $editOnly,
            previewPane: $previewPane,
            previewSpinner: $previewSpinner,
            wikiText: wikiText
        };
    };

    CRU.REVIEW.WIKI = CRU.REVIEW.WIKI || {
            resetPreview: function (parentId) {
                var struct = getWikiPreviewStruct(AJS.$((parentId ? ("#" + parentId + " ") : "") + "div a.wiki-preview-button")
                    .closest(".comment, .wiki-preview-wrapper"));
                var $previewButton = struct.previewButton;
                var $textarea = struct.textarea;
                var $editOnly = struct.editOnly;
                var $previewPane = struct.previewPane;
                var $previewSpinner = struct.previewSpinner;

                $previewPane.hide()
                    .text("")
                    .data("isInPreview", false);
                $previewButton.show();
                $previewSpinner.removeClass("wiki-preview-pane-spin");
                $textarea.show();
                $editOnly.removeClass('hidden');
            }
        };

    AJS.$(document).ready(function () {
        AJS.$(document).delegate("div a.wiki-preview-button", "click", function () {
            var struct = getWikiPreviewStruct(AJS.$(this).closest(".comment, .wiki-preview-wrapper"), ":first");
            var $previewButton = struct.previewButton;
            var $textarea = struct.textarea;
            var $editOnly = struct.editOnly;
            var $previewPane = struct.previewPane;
            var $previewSpinner = struct.previewSpinner;
            var wikiText = struct.wikiText;

            var previewController = {
                toggleOn: function (html) {
                    $textarea.hide();
                    $editOnly.addClass('hidden');
                    $previewPane.html(html)
                        .show()
                        .data("isInPreview", true);
                    $previewPane.trigger('wiki-preview-on')
                },
                toggleOff: function () {
                    $previewPane.hide()
                        .text("")
                        .data("isInPreview", false);
                    $textarea.show();
                    $editOnly.removeClass('hidden');
                    $previewPane.trigger('wiki-preview-off');
                }
            };

            if ($previewPane.data("isInPreview") === true) {
                previewController.toggleOff();
            } else {
                if (wikiText) {
                    var url = CRU.UTIL.jsonUrlBase(permaId) + "/wikiPreviewJson";
                    var onComplete = function (resp) {
                        $previewSpinner.removeClass("wiki-preview-pane-spin");
                        $previewButton.show();
                        previewController.toggleOn(resp.html);
                    };
                    previewController.toggleOff();
                    $previewButton.hide();
                    $previewSpinner.addClass("wiki-preview-pane-spin");
                    FECRU.AJAX.ajaxDo(url, {wikiText: wikiText}, onComplete, true);
                }
            }
        });

        // live event for the comment post/cancel buttons
        AJS.$(document).delegate("form fieldset.comment-toolbar-holder button", "click.previewReset", function () {
            CRU.REVIEW.WIKI.resetPreview();
        });
    });
})();
/*[{!wiki_preview_js_hwzj523!}]*/;
/* END /2static/script/cru/review/wiki/wiki-preview.js */
/* START /2static/script/cru/review/util.js */
if (!CRU.REVIEW) {
    CRU.REVIEW = {};
}
if (!CRU.REVIEW.UTIL) {
    CRU.REVIEW.UTIL = {};
}
if (!CRU.REVIEW.TIMER) {
    CRU.REVIEW.TIMER = {};
}

CRU.REVIEW.MAX_FRXS_LOADED = 30;

(function ($, eventBusProvider) {
    var cruReviewUtil = CRU.REVIEW.UTIL;
    var cruReviewTimer = CRU.REVIEW.TIMER;
    var cruUtil;
    var cruFrx;
    var fecruAjax;

    // none of these are ready yet, so initialise them on ready
    AJS.$(document).ready(function () {
        cruUtil = CRU.UTIL;
        cruFrx = CRU.FRX;
        fecruAjax = FECRU.AJAX;
    });

    var displayCredentialsRequiredMessage = function (div, crm, success) {
        var template = AJS.template('<span>{msg} <a>Click here</a> to authenticate.</span>');
        AJS.$(div).empty().append(
            AJS.$('' + template.fill({"msg:html": crm.msgHtml})));

        AJS.$(div).find("a").click(function () {
            var eventProducer = FECRU.OAUTH.authorize(crm.authUrl);
            if (success) {
                eventProducer.authorized(success);
            }
        });
    };

    var displayOauthIgnoredMessage = function (div, oauthIgnored, success) {
        var template = AJS.template(
            "Accessing this issue requires authentication with <a target='_blank' href='{url}'>{name}</a> " +
            "however you have chosen to ignore these authentication requests. " +
            "<a class='jirahover-clear-ignored-applinks-link' href='#'>Click here</a> to stop ignoring.");
        var data = {url: oauthIgnored.jiraServerUrl, name: oauthIgnored.jiraServerName};

        AJS.$(div).empty().append(template.fill(data));
        AJS.$(div).find(".jirahover-clear-ignored-applinks-link").click(function () {
            FECRU.HOVER.invalidateCache(FECRU.HOVER.CACHE_FOREVER);
            fecruAjax.startSpin("jiraDisplaySpinner");
            FECRU.UAL.clearIgnoredAppLinks(function () {
                setTimeout(function () {
                    AJS.$(".linked-issue-error").empty();
                    fecruAjax.stopSpin("jiraDisplaySpinner");
                    success();
                }, 500);
            });
            return false;
        });
    };

    cruReviewUtil.findJiraIssue = function () {
        var jiraIssueKey = AJS.$.trim(AJS.$("#jiraIssueKeyField").val());
        if (!jiraIssueKey) {
            return;
        }
        var url = cruUtil.jsonUrlBase(permaId) + "/findJiraIssueAjax";
        var params = {jiraIssueKey: jiraIssueKey, autoLink: true};
        var $button = AJS.$("#jiraFindButton").prop("disabled", true);

        fecruAjax.startSpin("jiraFindButton");

        var done = function (resp) {
            var credentialsRequired = resp.credentialsRequired && resp.credentialsRequired.length > 0;
            if (credentialsRequired) {
                var crm = resp.credentialsRequired[0];
                displayCredentialsRequiredMessage(".linked-issue-error", crm, function () {
                    // retry after approval:
                    cruReviewUtil.findJiraIssue();
                });
                AJS.$("#frx-filter-subtasks,#frx-filter-unresolvedsubtasks").addClass("disabled");
            } else if (resp.oauthIgnored) {
                displayOauthIgnoredMessage(".linked-issue-error", resp.oauthIgnored, function () {
                    // retry after approval:
                    cruReviewUtil.findAndLinkJiraIssue(jiraIssueKey);
                });
            } else if (resp.worked) {
                if (resp.canLogWork) {
                    AJS.$("#time-spent").addClass("submit-jira-time");
                }
                AJS.$("#linked-issue-container").html(resp.jiraEditHtml);
                AJS.$("#jiraDisplayDiv").replaceWith(resp.jiraDisplayHtml);
                AJS.$("#frx-filter-subtasks,#frx-filter-unresolvedsubtasks").removeClass("disabled");
            } else {
                AJS.$(".linked-issue-error").html(resp.errorMsg);
                $button.removeProp("disabled");
                AJS.$("#frx-filter-subtasks,#frx-filter-unresolvedsubtasks").addClass("disabled");
            }

            $button.removeProp("disabled");
            fecruAjax.stopSpin($button);
        };

        fecruAjax.ajaxDo(url, params, done, true);
    };

    cruReviewUtil.unlinkJiraIssue = function () {
        var url = cruUtil.jsonUrlBase(permaId) + '/findJiraIssueAjax';
        var params = {unlinkJira: true};

        var $button = AJS.$("#jiraClearButton").prop('disabled', true);

        var done = function (resp) {
            if (resp.worked) {
                AJS.$("#time-spent").removeClass("submit-jira-time");
                AJS.$("#linked-issue-container").html(resp.jiraEditHtml);
                AJS.$("#jiraDisplayDiv").replaceWith(resp.jiraDisplayHtml);
                AJS.$("#frx-filter-subtasks,#frx-filter-unresolvedsubtasks").removeClass("disabled");
            } else {
                $button.removeProp("disabled");
            }
        };

        fecruAjax.ajaxDo(url, params, done, true);
    };

    /**
     * This function is used from review details dialog to quickly link the review
     * to a jira issue that was suggested by Crucible.
     *
     * @param jiraIssueKey
     */
    cruReviewUtil.findAndLinkJiraIssue = function (jiraIssueKey) {
        var url = cruUtil.jsonUrlBase(permaId) + "/findJiraIssueAjax";
        var params = {jiraIssueKey: jiraIssueKey, autoLink: true};

        AJS.$("#jiraFindButton").prop("disabled", true);

        var ajax = fecruAjax;

        ajax.startSpin("jiraDisplaySpinner");

        ajax.ajaxDo(url, params, function (resp) {
            ajax.stopSpin(AJS.$("#jiraDisplaySpinner"));
            var credentialsRequired = resp.credentialsRequired && resp.credentialsRequired.length > 0;
            if (credentialsRequired) {
                var crm = resp.credentialsRequired[0];
                displayCredentialsRequiredMessage(".linked-issue-error", crm, function () {
                    // retry after approval:
                    AJS.$(".linked-issue-error").empty();
                    cruReviewUtil.findAndLinkJiraIssue(jiraIssueKey);
                });
                AJS.$("#frx-filter-subtasks,#frx-filter-unresolvedsubtasks").addClass("disabled");
            } else if (resp.oauthIgnored) {
                displayOauthIgnoredMessage(".linked-issue-error", resp.oauthIgnored, function () {
                    // retry after approval:
                    cruReviewUtil.findAndLinkJiraIssue(jiraIssueKey);
                });
            } else if (resp.worked) {
                if (resp.canLogWork) {
                    AJS.$("#time-spent").addClass("submit-jira-time");
                }
                AJS.$("#linked-issue-container").html(resp.jiraEditHtml);
                AJS.$("#jiraDisplayDiv").html(resp.jiraDisplayHtml);
                AJS.$("#jiraIssueQuickLink").hide();
                AJS.$("#frx-filter-subtasks,#frx-filter-unresolvedsubtasks").removeClass("disabled");
            } else {

                var $linkedIssueError = AJS.$(".linked-issue-error");
                $linkedIssueError.empty();
                var $error = AJS.$(AJS.messages.warning($linkedIssueError, {
                    title: 'Linking issue to review failed.',
                    body: 'There ' + (resp.jiraExceptions.length === 1 ? 'was an error' : ('were ' + resp.jiraExceptions.length + ' errors')) + ' communicating with JIRA. <a class="details">Details</a>'
                }));

                $linkedIssueError.find('.details').click(function () {
                    for (var i = 0; i < resp.jiraExceptions.length; i++) {
                        var exception = resp.jiraExceptions[i];
                        var exceptionTemplate = AJS.template('<span>{msg} <a href="{url}">Go to \'{name}\'</a> or see your administrator.</span>');
                        var data = {url: exception.serverUrl, name: exception.name, "msg:html": exception.msgHtml};
                        FECRU.AJAX.appendErrorMessage(AJS.$('' + exceptionTemplate.fill(data)), true);
                    }
                    FECRU.AJAX.showNotificationBox('Errors communicating with JIRA', 'message');
                });

                AJS.$("#frx-filter-subtasks,#frx-filter-unresolvedsubtasks").addClass("disabled");
            }
        }, true);

        AJS.$("#jiraFindButton").removeProp("disabled");
    };

    cruReviewUtil.postEditDetailsForm = function (onCompleteFunc) {
        var url = cruUtil.jsonUrlBase(permaId) + '/postDetails';
        var $form = AJS.$('#editDetailsForm');

        var $title = AJS.$("#reviewTitle");
        if ($title.isPlaceholded()) {
            $title.val("");
        }

        if ($form.length === 0) {
            onCompleteFunc && onCompleteFunc();
            return false;
        }

        var params = $form.serialize() + '&command=norender';
        fecruAjax.ajaxDo(url, params, onCompleteFunc);
        return false;
    };

    cruReviewUtil.closeReviewAjax = function () {
        var params = {
            summary: AJS.$("#reviewSummaryInput").val()
        };

        cruUtil.stateTransition('action:closeReview', permaId, params);
        return false;
    };

    cruReviewUtil.postLinkedReview = function () {
        var newParentId = AJS.$("#parentReviewId").val();
        if (!newParentId) {
            return;
        }
        var url = cruUtil.jsonUrlBase(permaId) + '/linkReview';
        var params = '&parentReviewId=' + newParentId;
        var $button = AJS.$("#linkReviewSaveButton").prop('disabled', true);

        var ajax = fecruAjax;

        ajax.startSpin("linkedReviewSpinner");

        var done = function (resp) {
            if (resp.worked) {
                AJS.$("#unlinkReview").html(resp.unlinkHtml).show();
                AJS.$("#linkReviewForm").hide();
            }
            ajax.stopSpin(AJS.$('#linkedReviewSpinner'));
            $button.removeProp('disabled');
        };

        ajax.ajaxDo(url, params, done);
    };

    cruReviewUtil.postUnlinkReview = function () {
        var url = cruUtil.jsonUrlBase(permaId) + '/linkReview';
        var params = {unlinkParent: true};

        var ajax = fecruAjax;

        ajax.startSpin("linkedReviewSpinner");
        var $button = AJS.$("#linkReviewUnlinkButton").prop('disabled', true);

        var done = function (resp) {
            if (resp.worked) {
                AJS.$("#unlinkReview").hide().html("");
                AJS.$("#linkReviewForm").show();
            }
            ajax.stopSpin(AJS.$('#linkedReviewSpinner'));
            $button.removeProp('disabled');
        };

        ajax.ajaxDo(url, params, done);
    };

    cruReviewUtil.filterAndExpandFrxs = function (filters) {
        var $filterOptions = AJS.$('#frxFilterOptions');
        AJS.$.each(filters, function (i, filter) {
            $filterOptions.find('li[id=frx-filter-' + filter + ']').addClass('selected');
        });
        cruFrx.changedFrxFilter();
    };

    /**
     * @param opts.done called when the request was successful
     * @param opts.error see noDialog param of fecruAjax.ajaxUpdate
     */
    cruReviewUtil.warnAboutReviewUpdates = function (opts) {
        opts = opts || {};
        var notShownYet = !AJS.$('body').hasClass('review-updated');
        cruReviewUtil.reviewUpdatedAjax({
            done: function () {
                if (AJS.$('body').hasClass('review-updated')) {
                    if (notShownYet || opts.reshowWarning) {
                        AJS.$('#review-updated-warning').slideDown('fast');
                    }
                }
                opts.done && opts.done();
            },
            error: opts.error
        });
    };

    cruReviewUtil.reorderParticipants = function () {
        var parent = AJS.$("#participant-list-runner");
        var children = parent.children();

        var sortedReviewers = review.getReviewersSortedByCompletedness();

        for (var i = 0, len = children.length; i < len; i++) {
            var idExpected = sortedReviewers[i].getId();
            var child = children[i];
            if (child.id !== ('review-participant-' + idExpected)) {
                AJS.$(child).before(AJS.$('#review-participant-' + idExpected, parent));
                children = parent.children();
            }
        }

        var reviewerCompleted = {};
        for (i = sortedReviewers.length; i-- > 0;) {
            reviewerCompleted[sortedReviewers[i].getId()] = sortedReviewers[i];
        }

        $('#reviewers .review-avatar, #inline-dialog-more-reviewers .review-avatar').each(function () {
            var $avatar = $(this);
            var id = $avatar.data('user-id');

            $avatar.toggleClass('completed', !!(reviewerCompleted[id] && reviewerCompleted[id].m_hasCompleted));
        })
    };

    cruReviewUtil.redrawStatePercentComplete = function (complete) {
        var $statusBar = AJS.$('.status-open');
        $statusBar.closest('ul').attr('title', complete + '% complete');
        //12 is the minimum, 180 is the width including the first 12, so we need to * by 180 - 12 = 168
        var completeChunk = (12 + (complete / 100 * 168));
        $statusBar.css({
            "background-position": completeChunk + "px 0px"
        });
    };

    /**
     * If on the review page, checks if the review has been updated since last refresh.
     *
     * If the review has been updated, the body has the class `review-updated` added.
     * Silently fails if the Ajax request fails.
     *
     * @param opts.done no arg callback called regardless of whether the request is made.
     * @param opts.checkOwnActions tell the UpdateAction to not disregard actions made by the currently logged in user
     * @param opts.force ensure the review is updated even if the review isn't loaded
     * @param opts.error see noDialog param of fecruAjax.ajaxUpdate
     */
    cruReviewUtil.reviewUpdatedAjax = function (opts) {
        opts = opts || {};

        var util = cruUtil;
        if (!util.isReviewPage() || (!opts.force && !review.isLoaded())) {
            opts.done && opts.done();
            return;
        }

        var url = util.jsonUrlBase(review.id()) + '/reviewUpdatedAjax';

        var timeSpent = cruReviewTimer.getAndReset();
        var params = {
            reviewRenderTime: review.getRenderTime().getTime(),
            reviewStateName: review.getStateName(),
            backingOff: backingOff,
            timeSpent: timeSpent,
            checkOwnActions: opts.checkOwnActions ? true : false
        };

        /*eslint-disable complexity, max-depth*/
        fecruAjax.ajaxDo(url, params, function (resp) {
            if (resp.worked) {
                var pending = review.getPending();
                var noticedChanged = pending.getUpdatedReviewCommentIds().length !== resp.updatedReviewComments.length ||
                    pending.getUpdatedFileCommentIds().length !== resp.updatedFileComments.length ||
                    pending.getUpdatedInlineCommentIds().length !== resp.updatedInlineComments.length ||
                    pending.isReloadRequired() !== resp.reloadRequired ||
                    pending.getAddedFrxIds().length !== resp.frxsAdded.length ||
                    pending.getUpdatedFrxIds().length !== resp.frxsUpdated.length ||
                    pending.getRemovedFrxIds().length !== resp.frxsRemoved.length ||
                    pending.getPendingStateName() !== resp.stateName ||
                    pending.getReviewersToBeAddedCount() !== resp.addedReviewersCount ||
                    pending.getReviewersToBeRemovedCount() !== resp.removedReviewersCount ||
                    pending.getAuthorChanged() !== resp.authorChanged ||
                    pending.getModeratorChanged() !== resp.moderatorChanged ||
                    pending.getRoleChanged() !== resp.roleChanged ||
                    pending.hasBeenUncompleted() !== resp.hasBeenUncompleted;

                review.setLastCheckedUpdateTime(new Date(resp.renderTime));
                pending.setUpdatedReviewCommentIds(resp.updatedReviewComments)
                    .setUpdatedFileCommentIds(resp.updatedFileComments)
                    .setUpdatedInlineCommentIds(resp.updatedInlineComments)
                    .setReloadRequired(resp.reloadRequired)
                    .setDetailsChanged(resp.detailsChanged)
                    .setUpdatedFrxIds(resp.frxsUpdated)
                    .setAddedFrxIds(resp.frxsAdded)
                    .setRemovedFrxIds(resp.frxsRemoved)
                    .setUnreadFrxIds(resp.unreadFrxs)
                    .setPendingStateName(resp.stateName)
                    .setPendingMetaStateName(resp.metaStateName)
                    .setHasBeenUncompleted(resp.hasBeenUncompleted)
                    .setReviewersToBeAddedCount(resp.addedReviewersCount)
                    .setReviewersToBeRemovedCount(resp.removedReviewersCount)
                    .setAuthorChanged(resp.authorChanged)
                    .setModeratorChanged(resp.moderatorChanged)
                    .setRoleChanged(resp.roleChanged)
                    .setLastLogItemTimestamp(resp.lastLogItemTimestamp);

                $('#frx-pane').trigger('review-pending-update', pending);

                if (resp.alsoViewingHtml) {
                    cruReviewUtil.displayAlso(resp.alsoViewingHtml);
                } else {
                    AJS.$('#also-viewing').hide();
                }

                var $timeSpentInput = AJS.$('#time-spent-input');
                if (resp.timeSpent && !cruReviewTimer.editing) {
                    $timeSpentInput.val(resp.timeSpent).show();
                }

                if (pending.isPendingClosed()) {
                    AJS.$('#time-spent').addClass('disabled')
                        .removeClass('enabled');
                    $timeSpentInput.prop('disabled', true)
                        .addClass('disabled')
                        .removeClass('enabled');
                } else {
                    AJS.$('#time-spent').removeClass('disabled')
                        .addClass('enabled');
                    $timeSpentInput.removeProp('disabled')
                        .removeClass('disabled')
                        .addClass('enabled');
                }

                AJS.$('#review-updated-warning div.more-info').html(resp.updateMessageHtml);

                var details = resp.participantDetails;
                if (details) {
                    var completednessChanged = false;
                    for (var i = 0, len = details.length; i < len; i++) {
                        var values = details[i];
                        var user = values.user;
                        var percentage = values.percentage;
                        var isComplete = values.isComplete;
                        var chunk = 100 - percentage;

                        var changed = review.updateReviewerCompleteness(user, percentage, isComplete);

                        var $detailsParticipantRow = AJS.$("#details-participant-" + user);
                        if (changed) {
                            var $headerParticipant = AJS.$("#review-participant-" + user);
                            $detailsParticipantRow.find('.reviewer').toggleClass("completedReviewer", isComplete);
                            $headerParticipant.toggleClass("completedReviewer", isComplete);
                            var $progress = $headerParticipant.children(".reviewer-progressbar");
                            var $detailsProgress = $detailsParticipantRow.find('.reviewer-progressbar');
                            if ($progress.length > 0) {
                                $progress.css({"background-position": chunk + "% 0%"});
                                $progress.attr('title', percentage + '% reviewed');
                                $detailsProgress.css({"background-position": chunk + "% 0%"});
                                $detailsProgress.attr('title', percentage + '% reviewed');
                                $detailsParticipantRow.find('.role-progress').text(percentage);
                            }
                            completednessChanged = true;
                        }
                        if (values.timeSpent) {
                            $detailsParticipantRow.children('.timeSpent').text(values.timeSpent);
                        }
                    }
                    AJS.$('#details-participants-total').children('.timeSpent').text(resp.totalTimeSpent);
                    if (completednessChanged) {
                        cruReviewUtil.reorderParticipants();
                    }

                    reloadCommentDetails(details);
                }

                if (resp.reviewStatePercentComplete !== review.getStatePercentComplete()) {
                    review.setStatePercentComplete(resp.reviewStatePercentComplete);
                    cruReviewUtil.redrawStatePercentComplete(review.getStatePercentComplete());
                }

                if (resp.issueKey !== review.issueKey()) {
                    review.setIssueKey(resp.issueKey);
                }

                if (resp.showMessage) {
                    if (!opts.recheck) {
                        AJS.$('body').addClass('review-updated');
                    }
                } else {
                    AJS.$('body').removeClass('review-updated');
                }

                if (noticedChanged) {
                    AJS.$('#review-updated-warning')
                        .removeClass('collapsed')
                        .find('a.collapse')
                        .text('Collapse');
                }
            } else {
                //on error, roll time that should have been logged back into the timer for the next update
                cruReviewTimer.elapsedTime += timeSpent;
            }
            opts.done && opts.done();
        }, opts.error);
    };
    /*eslint-enable*/

    var reloadCommentDetails = function (participantCommentDetails) {
        var participantTotalComments = 0;
        var participantTotalDefects = 0;
        for (var i = 0, len = participantCommentDetails.length; i < len; i++) {
            var participant = participantCommentDetails[i];
            var userId = participant.user;
            var detailsParticipant = AJS.$('#details-participant-' + userId);

            detailsParticipant.find('.latest-comment').html(participant.latestComment || '');
            detailsParticipant.find('.authored-comments').text(participant.authoredComments || '');

            participantTotalComments += participant.authoredCommentCount;
            participantTotalDefects += participant.authoredDefectCount;
        }
        //update comment total
        var totalDefectString;
        switch (participantTotalDefects) {
            case 0:
                totalDefectString = '';
                break;
            case 1:
                totalDefectString = ' (' + participantTotalDefects + ' defect)';
                break;
            default:
                totalDefectString = ' (' + participantTotalDefects + ' defects)';
                break;
        }
        AJS.$('#details-participants-total').find('.authored-comments').text(participantTotalComments + totalDefectString);
    };


    var DELAY_MIN = 1000 * 20;
    var DELAY_MAX = 1000 * 60 * 60;
    var DELAY_MULTIPLIER = 1.25;
    var INACTIVITY_BEFORE_BACKOFF = 1000 * 60 * 5;

    var lastActivityMs = new Date().getTime();
    var backingOff = false;
    var pollingDelay = DELAY_MIN;

    /**
     * For the first INACTIVITY_BEFORE_BACKOFF ms (e.g., 5 min) since the last activity, poll
     * every DELAY_MIN ms (e.g., 20 sec). After the INACTIVITY_BEFORE_BACKOFF, start backing
     * off the polling period to a maximum of DELAY_MAX ms (e.g., 1 hr).
     *
     * The backoff is required, e.g., if you leave your browser open overnight.
     */
    function calcTimeout() {

        var t = new Date().getTime() - lastActivityMs;
        if (t < INACTIVITY_BEFORE_BACKOFF) {
            backingOff = false;
            pollingDelay = DELAY_MIN;
        } else {
            backingOff = true;
            pollingDelay *= DELAY_MULTIPLIER;
            //also stop time-tracking if backing off
            cruReviewTimer.stop();
        }

        if (pollingDelay > DELAY_MAX) {
            pollingDelay = DELAY_MAX;
        } else if (pollingDelay < DELAY_MIN) {
            pollingDelay = DELAY_MIN;
        }
        return pollingDelay;
    }

    var pollingTimer;
    var pollRequestActive = false;


    function doPollingLoop() {
        var rutil = cruReviewUtil;
        if (!pollRequestActive) {
            pollRequestActive = true;
            rutil.warnAboutReviewUpdates({
                done: chainPollingLoop,
                // Continue requesting when the server is down in case it comes back up.
                error: chainPollingLoop
            });
        }
    }

    function chainPollingLoop() {
        pollingTimer = setTimeout(doPollingLoop, calcTimeout());
        pollRequestActive = false;
    }

    cruReviewUtil.resetInactivityTimer = function () {
        lastActivityMs = new Date().getTime();
    };

    var pollingIsBlocked = false;

    cruReviewUtil.blockReviewUpdatePolling = function () {
        cruReviewUtil.stopPollingForReviewUpdates();
        pollingIsBlocked = true;
    };

    cruReviewUtil.unblockReviewUpdatePolling = function () {
        pollingIsBlocked = false;
        cruReviewUtil.startPollingForReviewUpdates();
    };

    cruReviewUtil.startPollingForReviewUpdates = function () {
        if (pollingIsBlocked) {
            return;
        }
        cruReviewUtil.stopPollingForReviewUpdates();
        doPollingLoop();
    };

    cruReviewUtil.stopPollingForReviewUpdates = function () {
        if (pollingTimer) {
            clearTimeout(pollingTimer);
            pollingTimer = undefined;
        }
    };

    // also-viewing
    cruReviewUtil.displayAlso = function (viewing) {
        AJS.$("#bottom-status-notifications").css({
            bottom: AJS.$('#footer').outerHeight() + 15
        });
        AJS.$('#also-viewing').html(viewing).show();
    };

    // time-tracking
    cruReviewTimer.startTime = new Date().getTime();
    cruReviewTimer.elapsedTime = 0;
    cruReviewTimer.running = false;
    cruReviewTimer.editing = false;

    /* Start the timer (no-effect if already running) */
    cruReviewTimer.start = function () {
        var timer = cruReviewTimer;
        if (!timer.running) {
            timer.startTime = new Date().getTime();
            timer.running = true;
        }
    };

    /* Stop the timer (no-effect if not running) */
    cruReviewTimer.stop = function () {
        var timer = cruReviewTimer;
        if (timer.running) {
            timer.elapsedTime += new Date().getTime() - timer.startTime;
            timer.running = false;
        }
    };

    /* Get the counted ms and reset the timer */
    cruReviewTimer.getAndReset = function () {
        var timer = cruReviewTimer;
        if (timer.editing) {
            return 0;
        }
        timer.stop();
        var count = timer.elapsedTime;
        timer.elapsedTime = 0;
        timer.start();
        return count;
    };

    /* User is currently editing time spent - time is accrued, but not logged during this time */
    cruReviewTimer.startEditing = function () {
        cruReviewTimer.editing = true;
    };

    /* User has finished editing - ditch the accrued time if update was successful */
    cruReviewTimer.stopEditing = function (updated) {
        var timer = cruReviewTimer;
        timer.editing = false;
        if (updated) {
            timer.getAndReset();
        }
    };

    /* debug - I suspect we'll need this again
     cruReviewTimer.log = function (msg) {
     console.log(msg + " count=" + cruReviewTimer.count + " running=" + cruReviewTimer.running +
     " startTime=" + cruReviewTimer.startTime);
     };
     */

    var rowClassMatchFrom = /.*\bfrom(\d+)\b.*/;
    var rowClassMatchTo = /.*\bto(\d+)\b.*/;

    /**
     * get the line number of a tr.sourceLine
     *
     * @param $line an AJS.$('tr.sourceLine') with either a 'fromN' or 'toN' class
     * @param to true to get the to line number, false to get the from line number
     */
    cruReviewUtil.getLineNumber = function ($line, to) {
        if (!$line || $line.length === 0) {
            return null;
        }
        var classMatcher = to ? rowClassMatchTo : rowClassMatchFrom;
        var matches = $line[0].className.match(classMatcher);
        if (matches && matches.length > 1) {
            return parseInt(matches[1]);
        }
        return null;
    };

    cruReviewUtil.getTopVisibleLineNumber = function (frxId) {
        var $sourceLines = AJS.$('#sourceTable' + frxId).children('tbody').children('tr.sourceLine');
        var high = $sourceLines.length;
        var low = 0;
        var middle = low + Math.floor((high - low) / 2);
        var found = false;

        while (middle > low && middle < high && !found) {
            var $middleLine = AJS.$($sourceLines[middle]);
            if ($middleLine.is(':in-viewport-vert(80, frx-pane)')) {
                found = true;
                break;
            } else if ($middleLine.is(':above-the-top(80, frx-pane)')) {
                low = middle;
            } else {
                high = middle;
            }
            middle = low + Math.floor((high - low) / 2);
        }

        if (!found) {
            return 0;
        } else {
            while (middle > 0 && $middleLine.is(':in-viewport-vert(80, frx-pane)')) {
                middle--;
                $middleLine = AJS.$($sourceLines[middle]);
            }
            if ($middleLine.hasClass('toLine')) {
                return cruReviewUtil.getLineNumber($middleLine, true);
            } else {
                return cruReviewUtil.getLineNumber($middleLine, false);
            }
        }
    };

    //opt can have the following properties:
    // - newValue
    // - wikiInputFieldSelector
    // - htmlOutputElementSelector
    cruReviewUtil.updateReviewField = function (type, urlSuffix, opt, callback) {
        var url = CRU.UTIL.jsonUrlBase(permaId) + urlSuffix;

        opt = opt || {};

        var $fieldDiv = AJS.$('#' + type + '-input');
        var $inputFields = $fieldDiv.children('.input');
        var $outputFields = AJS.$('#' + type + '-markup');
        var newValue = opt.newValue !== undefined ? opt.newValue : $inputFields.val();

        //add the extra input fields
        if (opt.wikiInputFieldSelector) {
            $inputFields = $inputFields.add(opt.wikiInputFieldSelector);
        }
        //sync them up
        $inputFields.val(newValue);

        //add the extra output fields
        if (opt.htmlOutputElementSelector) {
            $outputFields = $outputFields.add(opt.htmlOutputElementSelector);
        }
        var $submitTitle = $inputFields.find('.submit-' + type + '');
        $submitTitle.addClass('spinner');

        FECRU.AJAX.ajaxDo(url, {input: newValue}, function (resp) {
            $submitTitle.removeClass('spinner');
            if (resp.worked) {
                AJS.$('#' + type + '-markup').html(resp.payloadHtml);
                $inputFields.add($fieldDiv.children('.backup')).val(resp.payload);
                $outputFields.html(resp.payloadHtml);
                cruReviewUtil.discardNewField(type);
                callback && callback();
            }
        });
    };

    cruReviewUtil.discardNewField = function (type) {
        var $inputField = AJS.$('#' + type + '-input');
        if ($inputField.find('.submit-' + type + '').hasClass('spinner')) {
            return;
        }
        $inputField.hide();
        CRU.REVIEW.WIKI.resetPreview(type + '-input');
        AJS.$('#' + type + '-markup').show();
        //this needs a timeout because of a conflict with leaving the input box (or something like that)
        $inputField.trigger(type + '-form-hidden');
        setTimeout(function () {
            var objectives = $inputField.children('.backup').val();
            $inputField.find('.input').val(objectives);
        }, 200);
    };


    cruReviewUtil.triggerSourceCodeShown = function (frxId) {
        if (commentator.showSource) {
            eventBusProvider().trigger('source-code:shown', {
                key: frxId,
                page: 'review'
            });
        }
    };

    cruReviewUtil.triggerSourceCodeHidden = function (frxId) {
        eventBusProvider().trigger('source-code:hidden', {key: frxId});
    };

    cruReviewUtil.triggerSourceCodeReset = function (frxId) {
        eventBusProvider().trigger('source-code:reset', {key: frxId});
    };

    AJS.$(document).ready(function () {

        // Poll immediately on focus and start the polling loop.
        AJS.$(window).focus(function () {
            if (review.isLoaded()) {
                // Restart polling for updates.
                cruReviewUtil.resetInactivityTimer();
                cruReviewUtil.startPollingForReviewUpdates();
                cruReviewTimer.start();
            } else {
                // Once all FRXs are loaded, frx.js calls startPollingForReviewUpdates.
            }
        });

        // Resetting on keypress (of shortcuts) is handled by keynav.js since it prevents propagation.
        AJS.$('body').click(function () {
            cruReviewUtil.resetInactivityTimer();
            cruReviewTimer.start();
        });

        // Don't poll at all when the window doesn't have focus.
        AJS.$(window).blur(function () {
            cruReviewUtil.stopPollingForReviewUpdates();
            cruReviewTimer.stop();
        });

        /* because $(window).blur() is inneffective when switching tabs in FF */
        AJS.$(document).blur(function () {
            //todo should we add AJS_review_util.stopPollingForReviewUpdates(); here?
            cruReviewTimer.stop();
        });

        var removeAndReloadFrxs = function () {
            var pending = review.getPending();
            var toBeRemovedFrxIds = pending.getRemovedFrxIds();
            var removeFrxFromPage = CRU.CREATE.removeFrxFromPage;
            for (var i = 0, len = toBeRemovedFrxIds.length; i < len; i++) {
                removeFrxFromPage(toBeRemovedFrxIds[i]);
            }

            var pendingUnreadFrxIds = pending.getUnreadFrxIds();
            for (i = 0, len = pendingUnreadFrxIds.length; i < len; i++) {
                cruFrx.AJAX.changeFileReadStatusClass(pendingUnreadFrxIds[i], false, 'unread');
            }

            AJS.$('#review-meta-links .file-count').text(review.frxs().length);

            pending.setAddedFrxIds([]);
            cruFrx.reloadFrxs({}, pending.getUpdatedFrxIds());
        };

        var processUpdatedComments = function (commentsToRetrieve, updatedComments, commentsToRemove, type, commentContainer) {
            for (var i = 0, len = updatedComments.length; i < len; i++) {
                var commentResp = updatedComments[i];

                if (type === 'revision') {
                    var $beforeElem = $('#fileCommentForm' + (commentResp.frxId || ''));
                }
                commentator.replaceOrInsertComment(type,
                    commentResp.id,
                    commentResp.commentHtml,
                    commentContainer + (commentResp.frxId || ''), {
                        $beforeElem: $beforeElem
                    });
                commentator.createOrUpdateComment(commentResp);
                var comment = review.comment(commentResp.id);
                deleteCommentIdsFromList(commentsToRemove, comment);
                commentsToRetrieve.pop(commentResp.id);

                if (type === 'revision') {
                    var $revisionComments = AJS.$('#revision_comments_frxinner' + commentResp.frxId);
                    $revisionComments.toggleClass('hidden', review.frx(commentResp.frxId).fileComments().length === 0);
                }
            }
        };

        var deleteCommentIdsFromList = function (commentsToRemove, comment) {
            delete commentsToRemove[comment.id()];
            for (var i = 0, len = comment.getReplies().length; i < len; i++) {
                deleteCommentIdsFromList(commentsToRemove, comment.getReplies()[i]);
            }
        };

        AJS.$(document).delegate('#review-updated-warning a.reload', 'click', function () {
            cruReviewUtil.reloadReview();
            return false;
        });

        cruReviewUtil.reloadReview = function (forceAndCheckOwnActions, onReloadComplete) {
            FECRU.eventBus.trigger('review:before:reload');
            var frxId = cruFrx.NAV.getCurrentFrxId();
            var commentForm = commentator.getDisplayingCommentForm();
            if (commentForm) {
                var frxOuterId = commentator.getDisplayingCommentForm().getTextBox().closest('.frxouter').attr('id');
                var scrollToFrxId = frxOuterId !== 'generalComments' ? frxOuterId.replace(/^frxouter/, '') : frxOuterId;
                cruFrx.NAV.gotoFrx({frxId: scrollToFrxId, destination: ''});
                commentForm.getTextBox().focus();
                AJS.$('#review-updated-warning .comment-warning').show();
                onReloadComplete && onReloadComplete();
                return false;
            } else {
                AJS.$('#review-updated-warning .comment-warning').hide();
            }
            if (review.frx(frxId)) {
                window.location.hash = 'CFR-' + frxId;
            }
            if (review.getPending().isReloadRequired()) {
                window.location.reload();
            } else {
                cruReviewUtil.reviewUpdatedAjax({
                    checkOwnActions: forceAndCheckOwnActions,
                    force: forceAndCheckOwnActions,
                    done: function () {
                        // review is now up to date - update render times as though
                        // entire page was loaded at the last check time
                        // If there was no last check, set it to now.
                        var lastChecked = review.getLastCheckedUpdateTime();

                        var pending = review.getPending();

                        if (pending.hasBeenUncompleted()) {
                            var $uncompleteButton = AJS.$('.stateAction.uncomplete');
                            $uncompleteButton.unbind('click')
                                .attr('onclick', '')
                                .click(function () {
                                    cruUtil.stateTransition('action:completeReview', permaId);
                                })
                                .removeClass('uncomplete')
                                .addClass('complete')
                                .text('Complete');
                            pending.setHasBeenUncompleted(false);
                        }

                        var detailsOpts = {};
                        if (pending.getReviewersToBeAddedCount() > 0 ||
                            pending.getReviewersToBeRemovedCount() > 0 ||
                            pending.getAuthorChanged() ||
                            pending.getModeratorChanged()) {
                            detailsOpts.getParticipants = true;
                        }

                        if (pending.getDetailsChanged()) {
                            detailsOpts.getDetails = true;
                        }

                        if (!AJS.$.isEmptyObject(detailsOpts)) {
                            reloadDetails(detailsOpts);
                        }

                        if (pending.getUpdatedReviewCommentIds().length > 0 ||
                            pending.getUpdatedFileCommentIds().length > 0 ||
                            pending.getUpdatedInlineCommentIds().length > 0) {
                            removeAndReloadComments();
                        }

                        if (pending.getAddedFrxIds().length > 0) {
                            CRU.CREATE.retrieveNewFrxs(function () {
                                pending.setAddedFrxIds([]);
                                removeAndReloadFrxs();
                                onReloadComplete && onReloadComplete();
                            });
                        } else {
                            removeAndReloadFrxs();
                            onReloadComplete && onReloadComplete();
                        }
                        if (lastChecked) {
                            review.setRenderTime(lastChecked);
                        }
                        FECRU.eventBus.trigger('review:reload', pending);
                    },
                    recheck: true
                });
            }
            AJS.$('body').removeClass('review-updated');
        };

        /**
         * @param {Object} opts to specify which details to load. Currently supports getParticipants and getDetails
         */
        var reloadDetails = function (opts) {
            var url = cruUtil.jsonUrlBase(permaId) + '/retrieveReviewDetailsAjax';

            fecruAjax.ajaxDo(url, opts, function (resp) {
                var participants = resp.participants;
                if (resp.participants) {
                    AJS.$("#participant-table").replaceWith(participants.participantTable);
                    AJS.$(".review-header--metadata--participants").replaceWith(participants.reviewExtraParticipants);
                    review.clearReviewers();
                    review.getPending()
                        .setReviewersToBeAddedCount(0)
                        .setReviewersToBeRemovedCount(0)
                        .setAuthorChanged(false)
                        .setModeratorChanged(false);

                    var reviewers = participants.reviewers;
                    for (var i = 0, len = reviewers.length; i < len; i++) {
                        var r = reviewers[i];
                        review.setReviewer(r.id, r.userName, r.displayName, r.percentageComplete, r.isComplete, r.avatarUrl);
                    }
                    cruReviewUtil.reorderParticipants();

                    var author = participants.author;
                    review.setAuthor(author.id, author.userName, author.displayName, author.avatarUrl);

                    var moderator = participants.moderator;
                    if (moderator) {
                        review.setModerator(moderator.id, moderator.userName, moderator.displayName, moderator.avatarUrl);
                    }
                }

                if (resp.reviewActions) {
                    AJS.$('#page-actions').html(resp.reviewActions);
                }
                $(document).trigger('ajax-dialog-loaded');
                var details = resp.details;
                if (details) {
                    if (details.reviewDueDateHtml) {
                        var $reviewDueDate = AJS.$('.review-header--metadata--due-date');
                        if ($reviewDueDate.length) {
                            $reviewDueDate.replaceWith(details.reviewDueDateHtml);
                        } else {
                            AJS.$('.review-header--metadata .review-header--metadata--section:first-child')
                                .append(details.reviewDueDateHtml);
                        }
                    }
                    if (details.reviewHead) {
                        CRU.REVIEW.reviewTitle.setTitle(details.reviewHeadRaw, details.reviewHead);
                    }

                    if (details.reviewMetaLinks) {
                        AJS.$("#review-meta-links").html(details.reviewMetaLinks);
                    }

                    if (details.objectives) {
                        var $objectives = AJS.$("#objectives");

                        $objectives.find("#objectives-markup")
                            .toggleClass('editable', details.objectives.editable)
                            .html(details.objectives.markup);

                        $objectives.find("#objectives-input > .input")
                            .val(details.objectives.editable);

                        $objectives.find("#objectives-backup")
                            .val(details.objectives.editable);
                    }
                }
                $('#frx-pane').trigger('review-details-updated');
                review.setLastUpdatedTime(review.getLastCheckedUpdateTime());
            });
        };

        var removeAndReloadComments = function () {
            var commentator = CRU.COMMENT;
            var url = cruUtil.jsonUrlBase(permaId) + '/retrieveCommentsAjax';

            var pending = review.getPending();
            var reviewCommentsToRetrieve = pending.getUpdatedReviewCommentIds();
            var fileCommentsToRetrieve = pending.getUpdatedFileCommentIds();
            var inlineCommentsToRetrieve = pending.getUpdatedInlineCommentIds();

            var params = {};
            if (reviewCommentsToRetrieve && reviewCommentsToRetrieve.length) {
                params.reviewCommentsToRetrieve = reviewCommentsToRetrieve;
            }
            if (fileCommentsToRetrieve && fileCommentsToRetrieve.length) {
                params.fileCommentsToRetrieve = fileCommentsToRetrieve;
            }
            if (inlineCommentsToRetrieve && inlineCommentsToRetrieve.length) {
                params.inlineCommentsToRetrieve = inlineCommentsToRetrieve;
                var frxIds = [];
                var frxFromRevs = [];
                var frxToRevs = [];
                AJS.$.each(review.frxs(), function (i, frx) {
                    frxIds.push(frx.id());
                    frxFromRevs.push(frx.visibleFromRevision() || frx.visibleToRevision());
                    frxToRevs.push(frx.visibleToRevision());
                });
                params.frxIds = frxIds;
                params.frxFromRevs = frxFromRevs;
                params.frxToRevs = frxToRevs;
            }

            /*eslint-disable complexity, max-depth*/
            fecruAjax.ajaxDo(url, params, function (resp) {
                if (resp.worked) {
                    var commentsToRemove = {}; //add all comments to retrieve, then remove each as we retrieve them. remove any comments still in the list
                    var i;
                    var len;

                    for (i = 0, len = reviewCommentsToRetrieve.length; i < len; i++) {
                        commentsToRemove[reviewCommentsToRetrieve[i]] = true;
                    }
                    for (i = 0, len = fileCommentsToRetrieve.length; i < len; i++) {
                        commentsToRemove[fileCommentsToRetrieve[i]] = true;
                    }
                    for (i = 0, len = inlineCommentsToRetrieve.length; i < len; i++) {
                        commentsToRemove[inlineCommentsToRetrieve[i]] = true;
                    }

                    processUpdatedComments(reviewCommentsToRetrieve, resp.updatedReviewComments, commentsToRemove, 'general', 'general-comments-container');
                    pending.clearUpdatedReviewCommentIds();

                    processUpdatedComments(fileCommentsToRetrieve, resp.updatedFileComments, commentsToRemove, 'revision', 'revision_comments_frxinner');
                    pending.clearUpdatedFileCommentIds();

                    var updatedInlineComments = resp.updatedInlineComments;

                    for (i = 0, len = updatedInlineComments.length; i < len; i++) {
                        var commentResp = updatedInlineComments[i];
                        var commentRespId = commentResp.id;

                        //remove the old comment if it exists
                        if (review.comment(commentRespId)) {
                            commentator.removeCommentHtml(review.comment(commentRespId));
                        }

                        var frx = review.frx(commentResp.frxId);

                        //insert 'above' comment
                        AJS.$("#inline_comments_frxinner" + frx.id()).append(commentResp.aboveCommentHtml);

                        var isFromOnSkippedLines = false;
                        var isToOnSkippedLines = false;
                        var isOnSkippedLines = false;
                        if (!commentResp.hidden) {
                            var lastTo = commentResp.lastTo;
                            var lastFrom = commentResp.lastFrom;
                            var $sourceFrxInner = AJS.$("#sourcefrxinner" + frx.id());
                            var $lastToLine = $sourceFrxInner.find("tr.to" + lastTo + '.sourceLine');
                            var $lastFromLine = $sourceFrxInner.find("tr.from" + lastFrom + '.sourceLine');


                            //if lastFromLine or lastToLine is not found, look in skipped sections
                            if ($lastToLine.length === 0 || $lastFromLine.length === 0) {
                                var $startOfDiff = $sourceFrxInner.find("#diffStart" + frx.id());
                                var $firstFromLine = $sourceFrxInner.find(".sourceLine.commentableLine.fromLine:first");
                                var $firstToLine = $sourceFrxInner.find(".sourceLine.commentableLine.toLine:first");
                                if ($firstFromLine.length === 1) {
                                    var firstFromLine = cruReviewUtil.getLineNumber($firstFromLine, false);
                                    if (lastFrom <= firstFromLine) {
                                        $lastFromLine = $startOfDiff;
                                        isFromOnSkippedLines = true;
                                    }
                                }
                                if ($firstToLine.length === 1) {
                                    var firstToLine = cruReviewUtil.getLineNumber($firstToLine, true);
                                    if (lastTo <= firstToLine) {
                                        $lastToLine = $startOfDiff;
                                        isToOnSkippedLines = true;
                                    }
                                }

                                var $skippedSections = $sourceFrxInner.find('tr.diffSkipped');
                                for (var sectionIndex = 0, sectionLength = $skippedSections.length; sectionIndex < sectionLength; sectionIndex++) {
                                    if ($lastToLine.length > 0 && $lastFromLine.length > 0) {
                                        break;
                                    }
                                    var $skippedSection = AJS.$($skippedSections[sectionIndex]);
                                    var skippedSectionIdBits = $skippedSection.attr('id').split('_');
                                    if (lastFrom > 0 && $lastFromLine.length === 0) {
                                        var nextFrom = parseInt(skippedSectionIdBits[1], 10);
                                        if (lastFrom <= nextFrom) {
                                            $lastFromLine = $skippedSection;
                                            isFromOnSkippedLines = true;
                                        }
                                    }
                                    if (lastTo > 0 && $lastToLine.length === 0) {
                                        var nextTo = parseInt(skippedSectionIdBits[2], 10);
                                        if (lastTo <= nextTo) {
                                            $lastToLine = $skippedSection;
                                            isToOnSkippedLines = true;
                                        }
                                    }
                                }

                                if ($lastToLine.length === 0 && lastTo !== 0) { //there is supposed to be a to line but we cant see it
                                    $lastToLine = $sourceFrxInner.find("tr:last");
                                    isToOnSkippedLines = true;
                                }
                                if ($lastFromLine.length === 0 && lastFrom !== 0) { //there is supposed to be a from line but we cant see it
                                    $lastFromLine = $sourceFrxInner.find("tr:last");
                                    isFromOnSkippedLines = true;
                                }
                            }

                            //get the last of lastFromLine and lastToLine
                            var lastSelectedLine;
                            if ($lastToLine.length === 0) {
                                lastSelectedLine = $lastFromLine;
                                isOnSkippedLines = isFromOnSkippedLines;
                            } else if ($lastFromLine.length === 0) {
                                lastSelectedLine = $lastToLine;
                                isOnSkippedLines = isToOnSkippedLines;
                            } else {
                                // Find all the lines *after* the lastToLine. if the lastFromLine is not in this resultset,
                                // then the last physical line must be the lastToLine, otherwise it must be the lastFromLine
                                var $subsequentSiblings = $lastToLine.nextAll();
                                if ($subsequentSiblings.index($lastFromLine) < 0) {
                                    lastSelectedLine = $lastToLine;
                                    isOnSkippedLines = isToOnSkippedLines;
                                } else {
                                    lastSelectedLine = $lastFromLine;
                                    isOnSkippedLines = isFromOnSkippedLines;
                                }
                            }

                            //insert the comment in line
                            if (lastSelectedLine) {
                                var colSpan = frx.colspan();
                                var $cell = AJS.$("<td colspan='" + colSpan + "'><div class='comment-list'></div></td>");
                                $cell.children('div').html(commentResp.inlineCommentHtml);
                                AJS.$("<tr class='comment-row'></tr>")
                                    .append($cell)
                                    .insertAfter(lastSelectedLine);
                                $cell.trigger('comment-added');
                            }
                        }

                        //update review-model and arrays
                        commentator.createOrUpdateComment(commentResp);
                        inlineCommentsToRetrieve.pop(commentRespId);
                        delete commentsToRemove[commentRespId];
                        var replyComments = commentResp.replyComments;
                        if (replyComments) {
                            for (var k = 0, kk = replyComments.length; k < kk; k++) {
                                delete commentsToRemove[replyComments[k].id];
                            }
                        }

                        tetrisCommentController.renderTetrisCommentMarkersForComment(commentRespId);

                        //set 'skipped line' message
                        if (lastSelectedLine && isOnSkippedLines) {
                            var $resp = AJS.$('#' + review.comment(commentRespId).domId());
                            $resp.find('.comment-actions-primary')
                                .append('<span class="moreComments">' +
                                '<a class="comment-skipped" id="comment-skipped' + commentRespId + '" ' +
                                'title="click to show full context">Comment on skipped line ' +
                                (lastTo === 0 ? lastFrom : lastTo) + (lastTo === 0 ? '(revision ' +
                                commentResp.fromRevString + ')' : '') + '</a>' +
                                '</span>');
                        }
                    }
                    pending.clearUpdatedInlineCommentIds();

                    // delete any comments not returned
                    for (var commentId in commentsToRemove) {
                        if (commentsToRemove.hasOwnProperty(commentId)) {
                            var comment = review.comment(commentId);
                            if (comment) {
                                commentator.removeCommentHtml(review.comment(commentId));
                                review.removeComment(comment);

                                if (comment.frx()) {
                                    commentator.checkGeneralCommentsWarning(comment.frx().id());
                                } else {
                                    commentator.checkGeneralCommentsWarning();
                                }
                            }
                        }
                    }
                    commentator.updateCommentCount();

                    // update participant comment details
                    reloadCommentDetails(resp.participantCommentDetails);

                    // update comments width
                    commentator.setCommentWidths(null, true);
                }

            });
        };
        /*eslint-enable*/

        //start time-tracking
        cruReviewTimer.start();
    });

})(
    AJS.$,
    function () {
        return FECRU.eventBus
    }
);
/*[{!util_js_oi5d51e!}]*/;
/* END /2static/script/cru/review/util.js */
/* START /2static/script/cru/review/model/review-pending.js */
function ReviewPending() {
    this.m_reloadRequired = false;
    this.m_detailsChanged = false;
    this.m_addedFrxIds = [];
    this.m_updatedFrxIds = [];
    this.m_removedFrxIds = [];
    this.m_unreadFrxIds = [];
    this.m_updatedReviewCommentIds = []; // ids
    this.m_updatedFileCommentIds = []; // ids
    this.m_updatedInlineCommentIds = []; // ids
    this.m_reviewersToBeAdded = 0;
    this.m_reviewersToBeRemoved = 0;
    this.m_authorChanged = false;
    this.m_moderatorChanged = false;
    this.m_roleChanged = false;
    this.m_pendingStateName = undefined;
    this.m_pendingMetaStateName = undefined;
    this.m_hasBeenUncompleted = false;
}

ReviewPending.prototype.getPendingStateName = function () {
    return this.m_pendingStateName;
};

ReviewPending.prototype.setPendingStateName = function (stateName) {
    this.m_pendingStateName = stateName;
    return this;
};

ReviewPending.prototype.isPendingClosed = function () {
    return this.getPendingMetaStateName() === 'CLOSED';
};

ReviewPending.prototype.getPendingMetaStateName = function () {
    return this.m_pendingMetaStateName;
};

ReviewPending.prototype.setPendingMetaStateName = function (stateName) {
    this.m_pendingMetaStateName = stateName;
    return this;
};

ReviewPending.prototype.hasBeenUncompleted = function () {
    return this.m_hasBeenUncompleted;
};

ReviewPending.prototype.setHasBeenUncompleted = function (uncompleted) {
    this.m_hasBeenUncompleted = uncompleted;
    return this;
};

ReviewPending.prototype.isReloadRequired = function () {
    return this.m_reloadRequired;
};

ReviewPending.prototype.setReloadRequired = function (reloadRequired) {
    this.m_reloadRequired = reloadRequired;
    return this;
};

ReviewPending.prototype.getDetailsChanged = function () {
    return this.m_detailsChanged;
};

ReviewPending.prototype.setDetailsChanged = function (changed) {
    this.m_detailsChanged = changed;
    return this;
};

ReviewPending.prototype.getAddedFrxIds = function () {
    return this.m_addedFrxIds;
};

ReviewPending.prototype.setAddedFrxIds = function (frxIds) {
    this.m_addedFrxIds = frxIds || [];
    return this;
};

ReviewPending.prototype.getUpdatedFrxIds = function () {
    return this.m_updatedFrxIds;
};

ReviewPending.prototype.setUpdatedFrxIds = function (frxIds) {
    this.m_updatedFrxIds = frxIds || [];
    return this;
};

ReviewPending.prototype.getRemovedFrxIds = function () {
    return this.m_removedFrxIds;
};

ReviewPending.prototype.setRemovedFrxIds = function (frxIds) {
    this.m_removedFrxIds = frxIds || [];
    return this;
};

ReviewPending.prototype.getUnreadFrxIds = function () {
    return this.m_unreadFrxIds;
};

ReviewPending.prototype.setUnreadFrxIds = function (frxIds) {
    this.m_unreadFrxIds = frxIds;
    return this;
};

ReviewPending.prototype.getUpdatedReviewCommentIds = function () {
    return this.m_updatedReviewCommentIds;
};

ReviewPending.prototype.getUpdatedFileCommentIds = function () {
    return this.m_updatedFileCommentIds;
};

ReviewPending.prototype.getUpdatedInlineCommentIds = function () {
    return this.m_updatedInlineCommentIds;
};

ReviewPending.prototype.setUpdatedReviewCommentIds = function (comments) {
    this.m_updatedReviewCommentIds = comments || [];
    return this;
};

ReviewPending.prototype.setUpdatedFileCommentIds = function (comments) {
    this.m_updatedFileCommentIds = comments || [];
    return this;
};

ReviewPending.prototype.setUpdatedInlineCommentIds = function (commentIds) {
    this.m_updatedInlineCommentIds = commentIds || [];
    return this;
};

ReviewPending.prototype.clearUpdatedReviewCommentIds = function () {
    return this.setUpdatedReviewCommentIds([]);
};

ReviewPending.prototype.clearUpdatedFileCommentIds = function () {
    return this.setUpdatedFileCommentIds([]);
};

ReviewPending.prototype.clearUpdatedInlineCommentIds = function () {
    return this.setUpdatedInlineCommentIds([]);
};

ReviewPending.prototype.setReviewersToBeAddedCount = function (count) {
    this.m_reviewersToBeAdded = count;
    return this;
};

ReviewPending.prototype.setReviewersToBeRemovedCount = function (count) {
    this.m_reviewersToBeRemoved = count;
    return this;
};

ReviewPending.prototype.getReviewersToBeAddedCount = function () {
    return this.m_reviewersToBeAdded;
};

ReviewPending.prototype.getReviewersToBeRemovedCount = function () {
    return this.m_reviewersToBeRemoved;
};

ReviewPending.prototype.setAuthorChanged = function (changed) {
    this.m_authorChanged = changed;
    return this;
};

ReviewPending.prototype.getAuthorChanged = function () {
    return this.m_authorChanged;
};

ReviewPending.prototype.setModeratorChanged = function (changed) {
    this.m_moderatorChanged = changed;
    return this;
};

ReviewPending.prototype.getModeratorChanged = function () {
    return this.m_moderatorChanged;
};

ReviewPending.prototype.setRoleChanged = function (changed) {
    this.m_roleChanged = changed;
    return this;
};

ReviewPending.prototype.getRoleChanged = function () {
    return this.m_roleChanged;
};

ReviewPending.prototype.setLastLogItemTimestamp = function (timestamp) {
    this.m_lastLogItemTimestamp = timestamp;
};

ReviewPending.prototype.getLastLogItemTimestamp = function () {
    return this.m_lastLogItemTimestamp;
};
/*[{!review_pending_js_gnr551x!}]*/;
/* END /2static/script/cru/review/model/review-pending.js */
/* START /2static/script/cru/review/model/review.js */
function Review() {
    // Member variables
    this.m_permaId = undefined;
    this.m_projectKey = undefined;
    this.m_frxs = {};
    this.m_firstFrx = undefined;
    this.m_lastFrx = undefined;
    this.m_frxCacheDirty = true;
    this.m_frxArrayCache = []; // Optimisation array, should never be accessed directly but through this.frxs()
    this.m_comments = {};
    this.m_commentCacheDirty = true;
    this.m_commentArrayCache = []; // Optimisation array, should never be accessed directly but through this.comments()
    this.m_loaded = false;
    this.m_writable = false;
    this.m_commentable = false; // true if the user is allowed to add comments and mark comments as read/unread.
    this.m_stateName = undefined;
    this.m_stateVerbage = undefined;
    this.m_metaStateName = undefined;
    this.m_name = undefined;
    this.m_summarize = undefined;
    this.m_renderTime = undefined;
    this.m_lastUpdatedTime = undefined;
    this.m_lastCheckedUpdateTime = undefined;
    this.m_commentFrxId = {};
    this.m_author = undefined;
    this.m_moderator = undefined;
    this.m_reviewerCompleteness = {};
    this.m_statePercentComplete = 0;
    this.m_loggedInUser = undefined;
    this.m_autoMarkFilesRead = true;
    this.m_issueKey = undefined;
    this.m_activityItems = [];

    this.recentlyViewedFrxIds = new FECRU.DATA_STRUCTURES.LeastRecentlyUsedQueue();

    this.m_pending = new ReviewPending();
}
AJS.$.extend(Review.prototype, FECRU.MIXINS.EventProducer);

Review.prototype.getPending = function () {
    return this.m_pending;
};

// Function which maps an array of [FRX|Comment] -> array of object ids
Review.prototype.idArray = function (obj) {
    return AJS.$.map(obj, function (obj) {
        return obj.id();
    });
};

// Convert to a plain array instead of associative
Review.prototype.map2array = function (map) {
    var array = [];
    AJS.$.each(map, function () {
        array.push(this);
    });

    return array;
};

Review.prototype.id = function () {
    return this.m_permaId;
};


Review.prototype.setId = function (id) {
    this.m_permaId = id;
    return this;
};

Review.prototype.projectKey = function () {
    return this.m_projectKey;
};

Review.prototype.setProjectKey = function (projectKey) {
    this.m_projectKey = projectKey;
    return this;
};

Review.prototype.isLoaded = function () {
    return this.m_loaded;
};

Review.prototype.setLoaded = function (loaded) {
    this.m_loaded = loaded;
    return this;
};

Review.prototype.writable = function () {
    return this.m_writable;
};

Review.prototype.setWritable = function (writable) {
    this.m_writable = writable;
    return this;
};

Review.prototype.commentable = function () {
    return this.m_commentable;
};

Review.prototype.setCommentable = function (commentable) {
    this.m_commentable = commentable;
    return this;
};

Review.prototype.isOpen = function () {
    return this.getMetaStateName() === 'OPEN';
};

Review.prototype.isClosed = function () {
    return this.getMetaStateName() === 'CLOSED';
};

Review.prototype.isDraft = function () {
    return this.getMetaStateName() === 'DRAFT';
};

Review.prototype.getStateName = function () {
    return this.m_stateName;
};

Review.prototype.setStateName = function (stateName) {
    this.m_stateName = stateName;
    return this;
};

Review.prototype.getStateVerbage = function () {
    return this.m_stateVerbage;
};

Review.prototype.setStateVerbage = function (stateVerbage) {
    this.m_stateVerbage = stateVerbage;
    return this;
};

Review.prototype.getMetaStateName = function () {
    return this.m_metaStateName;
};

Review.prototype.setMetaStateName = function (metaStateName) {
    this.m_metaStateName = metaStateName;
    return this;
};

Review.prototype.isOverdue = function () {
    return this.m_overdue;
};

Review.prototype.setOverdue = function (overdue) {
    this.m_overdue = overdue;
    return this;
};

Review.prototype.isEmpty = function () {
    return this.frxs().length === 0;
};

Review.prototype.setName = function (name) {
    this.m_name = name;
    return this;
};

Review.prototype.setLoggedInUser = function (user) {
    if (this.m_author && user && this.m_author.id === user.id) {
        this.m_author = user;
    }
    if (this.m_moderator && user && this.m_moderator.id === user.id) {
        this.m_moderator = user;
    }

    this.m_loggedInUser = user;
    return this;
};

Review.prototype.autoMarkFilesRead = function () {
    return this.m_autoMarkFilesRead;
};

Review.prototype.setAutoMarkFilesRead = function (autoMarkFilesRead) {
    this.m_autoMarkFilesRead = autoMarkFilesRead;
    return this;
};

Review.prototype.getLoggedInUser = function () {
    return this.m_loggedInUser;
};

Review.prototype.isSummarize = function () {
    return this.m_summarize;
};

Review.prototype.setSummarize = function (summarize) {
    this.m_summarize = summarize;
    return this;
};

Review.prototype.issueKey = function () {
    return this.m_issueKey;
};

Review.prototype.setIssueKey = function (issueKey) {
    this.m_issueKey = issueKey;
    return this;
};

Review.prototype.activityItems = function () {
    return this.m_activityItems;
};

Review.prototype.addActivityItem = function (activityItem) {
    this.m_activityItems.push(activityItem);
    return this;
};

Review.prototype.addActivityItems = function (activityItems) {
    this.m_activityItems = this.m_activityItems.concat(activityItems);
    return this;
};

Review.prototype.clearActivityItems = function () {
    this.m_activityItems = [];
    return this;
};

Review.prototype.setRenderTime = function (date) {
    this.m_renderTime = new Date(date.getTime());
    return this;
};

Review.prototype.getRenderTime = function () {
    return (this.m_renderTime) ? new Date(this.m_renderTime.getTime()) : null;
};

Review.prototype.setLastUpdatedTime = function (date) {
    this.m_lastUpdatedTime = new Date(date.getTime());
    return this;
};

Review.prototype.getLastUpdatedTime = function () {
    return (this.m_lastUpdatedTime) ? new Date(this.m_lastUpdatedTime.getTime()) : null;
};

Review.prototype.setLastCheckedUpdateTime = function (date) {
    this.m_lastCheckedUpdateTime = new Date(date.getTime());
    return this;
};

Review.prototype.getLastCheckedUpdateTime = function () {
    if (!this.m_lastCheckedUpdateTime) {
        return undefined;
    }
    return new Date(this.m_lastCheckedUpdateTime.getTime());
};

/******************
 ****   FRXS   ****
 ******************/

Review.prototype.frxs = function () {
    if (this.m_frxCacheDirty) {
        this.m_frxArrayCache = this.frxArray();
        this.m_frxCacheDirty = false;
    }
    return this.m_frxArrayCache;
};

Review.prototype.frxArray = function () {
    var array = [];
    var nextFrx = this.m_firstFrx;
    while (nextFrx) {
        array.push(nextFrx);
        nextFrx = nextFrx.getNextFrx();
    }
    return array;
};

Review.prototype.frxMap = function () {
    return this.m_frxs;
};

Review.prototype.frx = function (frxId) {
    return this.m_frxs[frxId];
};

Review.prototype.frxIds = function () {
    return this.idArray(this.frxs());
};

Review.prototype.addFrx = function (frx, prevFrxId) {
    var id = frx.id();
    var existingFrx = this.frx(id);
    var prevFrx = this.frx(prevFrxId);

    //first remove any existing frx with the same id
    if (existingFrx) {
        prevFrx = existingFrx.getPrevFrx();
        prevFrxId = prevFrx ? prevFrx.id() : 'generalComments';
        this.removeFrx(existingFrx);
    }

    if (prevFrxId === 'generalComments') {
        if (this.m_firstFrx) {
            frx.setNextFrx(this.m_firstFrx);
            this.m_firstFrx.setPrevFrx(frx);
            this.m_firstFrx = frx;
        } else {
            //the only frx
            this.m_firstFrx = frx;
            this.m_lastFrx = frx;
        }
    } else {
        if (!prevFrx) {
            //if no prev - append to the end
            prevFrx = this.m_lastFrx;
        }
        if (!prevFrx) {
            //if still no prevFrx - this is the only frx
            this.m_firstFrx = frx;
            this.m_lastFrx = frx;
        } else {
            //insert frx between prevFrx and prevFrx.next
            var nextFrx = prevFrx.getNextFrx();
            prevFrx.setNextFrx(frx);
            frx.setPrevFrx(prevFrx);
            frx.setNextFrx(nextFrx);
            if (!nextFrx) {
                //there was no next frx - frx is the new last
                this.m_lastFrx = frx;
            } else {
                nextFrx.setPrevFrx(frx);
            }
        }
    }

    frx.setNavItemSelector(id === 'generalComments' ? '#frx-overview' : '#frx-list-item' + id);
    frx.setFrxControlsSelector(id === 'generalComments' ? null : '#frxControlsContainer' + id);
    frx.setFrxOuterSelector(id === 'generalComments' ? '#generalComments' : '#frxouter' + id);
    frx.setFrxInnerSelector(id === 'generalComments' ? '#generalCommentsInner' : '#frxinner' + id);

    this.m_frxs[frx.id()] = frx;
    this.m_frxCacheDirty = true;
    return this;
};

Review.prototype.removeFrx = function (frx) {
    var that = this;
    AJS.$.each(frx.comments(), function () {
        that.removeComment(this);
    });
    var prevFrx = frx.getPrevFrx();
    var nextFrx = frx.getNextFrx();
    if (prevFrx) {
        prevFrx.setNextFrx(frx.getNextFrx());
    } else {
        this.m_firstFrx = frx.getNextFrx();
    }
    if (nextFrx) {
        nextFrx.setPrevFrx(frx.getPrevFrx());
    } else {
        this.m_lastFrx = frx.getPrevFrx();
    }

    frx.dispose();

    delete this.m_frxs[frx.id()];
    this.m_frxCacheDirty = true;
    return this;
};

Review.prototype.completeFrxs = function () {
    return AJS.$.grep(this.frxs(), function (frx) {
        return frx.isComplete();
    });
};

Review.prototype.completeFrxIds = function () {
    return this.idArray(this.completeFrxs());
};

Review.prototype.incompleteFrxs = function () {
    return AJS.$.grep(this.frxs(), function (frx) {
        return !frx.isComplete();
    });
};

Review.prototype.incompleteFrxIds = function () {
    return this.idArray(this.incompleteFrxs());
};

Review.prototype.visibleFrxIdsWithComments = function () {
    return this.idArray(AJS.$.grep(this.frxs(), function (frx) {
        return frx.hasComments() && !frx.isFiltered();
    }));
};

/******************
 **** COMMENTS ****
 ******************/
Review.prototype.addComment = function (comment) {
    this.m_comments[comment.id()] = comment;
    this.m_commentCacheDirty = true;
    return this;
};

Review.prototype.removeComment = function (comment) {
    comment.clearReplies();
    if (comment.isReply()) {
        // remove the dead comment from the parent's children list
        var siblings = comment.replyTo().getReplies();
        for (var i = 0, len = siblings.length; i < len; i++) {
            if (siblings[i] === comment) {
                siblings.splice(i, 1);
                break;
            }
        }
    }
    delete this.m_comments[comment.id()];
    if (comment.frx()) {
        comment.frx().removeComment(comment);
    }
    this.m_commentCacheDirty = true;
    return this;
};

Review.prototype.comment = function (id) {
    return this.m_comments[id];
};

Review.prototype.comments = function () {
    if (this.m_commentCacheDirty) {
        this.m_commentArrayCache = this.map2array(this.m_comments);
        this.m_commentCacheDirty = false;
    }
    return this.m_commentArrayCache;
};

Review.prototype.commentIds = function () {
    return this.idArray(this.comments());
};

Review.prototype.generalComments = function () {
    return AJS.$.grep(this.comments(), function (comment) {
        return /^general/.test(comment.type());
    });
};

Review.prototype.domOrderedGeneralComments = function () {
    var commentArray = [];
    var idSelectors = [];
    AJS.$.each(this.generalComments(), function () {
        idSelectors.push("#" + this.visibleDomId());
    });
    if (idSelectors.length > 0) {
        var $commentObjects = AJS.$(idSelectors.join(','));
        for (var i = 0, len = $commentObjects.length; i < len; i++) {
            var commentDom = $commentObjects[i];
            var commentId = commentDom.id.replace(/\D+/, '');
            var comment = this.m_comments[commentId];
            if (comment) {
                commentArray.push(comment);
            }
        }
    }
    return commentArray;
};

Review.prototype.unreadGeneralComments = function () {
    return AJS.$.grep(this.generalComments(), function (comment) {
        return comment.status() === 'unread' || comment.status() === 'leaveUnread';
    });
};

Review.prototype.generalCommentIds = function () {
    return this.idArray(this.generalComments());
};

Review.prototype.fileComments = function () {
    return AJS.$.grep(this.comments(), function (comment) {
        return /^revision/.test(comment.type());
    });
};

Review.prototype.fileCommentIds = function () {
    return this.idArray(this.fileComments());
};

Review.prototype.inlineComments = function () {
    return AJS.$.grep(this.comments(), function (comment) {
        return /^inline/.test(comment.type());
    });
};

Review.prototype.inlineCommentIds = function () {
    return this.idArray(this.inlineComments());
};

Review.prototype.unreadComments = function () {
    return AJS.$.grep(this.comments(), function (comment) {
        return comment.status() === 'unread' || comment.status() === 'leaveUnread';
    });
};

Review.prototype.draftComments = function () {
    return AJS.$.grep(this.comments(), function (comment) {
        return comment.draft();
    });
};

/** Should only be used when generating the initial response. */
Review.prototype.setCommentFrxId = function (commentId, frxId) {
    this.m_commentFrxId[commentId] = frxId;
    return this;
};

/** @return undefined if it is not an frx or inline comment. */
Review.prototype.getCommentFrxId = function (commentId) {
    var comment = review.comment(commentId);
    if (comment) {
        var frx = comment.frx();
        return frx ? frx.id() : undefined;
    } else {
        return this.m_commentFrxId[commentId];
    }
};

Review.prototype.setAuthor = function (id, username, displayName, avatarUrl) {
    //if we already have a user object for this id under the other role, use it.
    if (this.m_moderator && this.m_moderator.id === id) {
        this.m_author = this.m_moderator;
    }
    if (this.m_loggedInUser && this.m_loggedInUser.id === id) {
        this.m_author = this.m_loggedInUser;
    }

    if (this.m_author && this.m_author.id === id) {
        this.m_author.update(username, displayName);
    } else {
        this.m_author = new User(id, username, displayName);
    }
    this.m_author.setAvatarUrl(avatarUrl);

    return this;
};

Review.prototype.getAuthor = function () {
    return this.m_author;
};

Review.prototype.setModerator = function (id, username, displayName, avatarUrl) {
    //if we already have a user object for this id under the other role, use it.
    if (this.m_author && this.m_author.id === id) {
        this.m_moderator = this.m_author;
    }
    if (this.m_loggedInUser && this.m_loggedInUser.id === id) {
        this.m_moderator = this.m_loggedInUser;
    }

    if (this.m_moderator && this.m_moderator.id === id) {
        this.m_moderator.update(username, displayName);
    } else {
        this.m_moderator = new User(id, username, displayName);
    }
    this.m_moderator.setAvatarUrl(avatarUrl);

    return this;
};

Review.prototype.getModerator = function () {
    return this.m_moderator;
};

Review.prototype.setReviewer = function (id, username, displayName, percentComplete, isCompleted, avatarUrl) {
    this.m_reviewerCompleteness[id] = new Reviewer(id, username, displayName, percentComplete, isCompleted);
    this.m_reviewerCompleteness[id].setAvatarUrl(avatarUrl);

    var self = this;
    this.m_reviewerCompleteness[id].bind("reviewerCompletenessChanged", function (e) {
        self.trigger("reviewerCompletenessChanged", {reviewer: e.reviewer, review: self});
    });
};

// returns true if the values have changed
Review.prototype.updateReviewerCompleteness = function (id, percentComplete, isCompleted) {
    var reviewer = this.m_reviewerCompleteness[id];
    if (!reviewer) {
        // this is a reviewer that has been added to the review, we're not displaying new reviewers so we should ignore it
        return false;
    } else {
        return reviewer.updateReviewer(percentComplete, isCompleted);
    }
};

Review.prototype.clearReviewers = function () {
    this.m_reviewerCompleteness = {};
};

Review.prototype.setStatePercentComplete = function (percent) {
    this.m_statePercentComplete = percent;
};

Review.prototype.getStatePercentComplete = function () {
    return this.m_statePercentComplete;
};

Review.prototype.getBlockers = function () {
    var m_reviewerCompleteness = this.m_reviewerCompleteness;
    var userList = [];
    for (var reviewerId in m_reviewerCompleteness) {
        if (m_reviewerCompleteness.hasOwnProperty(reviewerId)) {
            var reviewer = m_reviewerCompleteness[reviewerId];
            if (reviewer !== undefined && !reviewer.getHasCompleted()) {
                var user = {
                    type: 'user',
                    id: reviewer.getUserName(),
                    avatarUrl: reviewer.getAvatarUrl(),
                    displayPrimary: reviewer.getDisplayName()
                };
                userList.push(user);
            }
        }
    }
    if (!userList.length) {
        // then the moderator / author is the blocker
        var blocker = this.getModerator() || this.getAuthor();
        userList.push({
            type: 'user',
            id: blocker.getUserName(),
            avatarUrl: blocker.getAvatarUrl(),
            displayPrimary: blocker.getDisplayName()
        })
    }
    return userList;
};

Review.prototype.getReviewersSortedByCompletedness = function () {
    var m_reviewerCompleteness = this.m_reviewerCompleteness;
    var reviewerList = [];
    for (var reviewerId in m_reviewerCompleteness) {
        if (m_reviewerCompleteness.hasOwnProperty(reviewerId)) {
            var reviewer = m_reviewerCompleteness[reviewerId];
            if (reviewer !== undefined) {
                reviewerList.push(reviewer);
            }
        }
    }
    reviewerList.sort(function (reviewerA, reviewerB) {
        //if a reviewer has completed, their weighting should be more than 100%
        var aCompleted = reviewerA.getHasCompleted() ? 101 : reviewerA.getPercentageComplete();
        var bCompleted = reviewerB.getHasCompleted() ? 101 : reviewerB.getPercentageComplete();

        var diff = aCompleted - bCompleted;
        if (diff !== 0) {
            return diff;
        }
        if (reviewerA.getSortName() === reviewerB.getSortName()) {
            return 0;
        } else if (reviewerA.getSortName() < reviewerB.getSortName()) {
            return -1;
        } else {
            return 1;
        }
    });
    return reviewerList;
};

// Both variables are populated in elementIds.jspf
var review = new Review();
var permaId;
/*[{!review_js_1eq551y!}]*/;
/* END /2static/script/cru/review/model/review.js */
/* START /2static/script/cru/review/model/frx.js */
function Frx(id, review) {
    this.m_id = id;
    this.m_review = review;

    this.m_prevFrx = undefined;
    this.m_nextFrx = undefined;

    this.m_readStatus = undefined;
    this.m_readStatusLocked = false;
    this.m_colspan = 4;
    this.m_isLoaded = false;
    this.m_isLoading = false;
    this.m_isExpanded = false;
    this.m_isFiltered = false;
    this.m_isBinary = false;
    this.m_isDirectory = false;
    this.m_isNewSinceComplete = false;
    this.m_toBeRemoved = false;

    this.m_path = undefined;
    this.m_pathTruncated = undefined;
    this.m_branch = undefined;
    this.m_sourceName = undefined;

    // revision stuff
    this.m_frxRevisions = [];
    this.m_sliderFrxRevisions = undefined;
    this.m_visibleFromRevision = undefined;
    this.m_visibleToRevision = undefined;
    this.m_visibleFromSCMRevision = undefined;
    this.m_visibleToSCMRevision = undefined;
    this.m_frxRevisionToCruRevisionMap = {};

    this.m_commentCacheDirty = true;
    this.m_commentArrayCache = []; // Optimisation array, should never be accessed directly but through this.comments()
    this.m_comments = {};

    // diff opts
    this.m_context = undefined;
    this.m_whitespace = undefined;
    this.m_diffLayout = undefined;
    this.m_ignoreBlankLines = undefined;

    this.m_lastScrollTop = 0;

    //DOM pointers
    this.m_navItemSelector = undefined;
    this.m_frxControlsSelector = undefined;
    this.m_frxOuterSelector = undefined;
    this.m_frxInnerSelector = undefined;

}

Frx.prototype.getContext = function () {
    return this.m_context;
};

Frx.prototype.getWhitespace = function () {
    return this.m_whitespace;
};

Frx.prototype.getDiffLayout = function () {
    return this.m_diffLayout;
};

Frx.prototype.setContext = function (context) {
    this.m_context = context;
    return this;
};

Frx.prototype.setWhitespace = function (whitespace) {
    this.m_whitespace = whitespace;
    return this;
};

Frx.prototype.setDiffLayout = function (diffLayout) {
    this.m_diffLayout = diffLayout;
    return this;
};

Frx.prototype.getIgnoreBlankLines = function () {
    return this.m_ignoreBlankLines;
};

Frx.prototype.setIgnoreBlankLines = function (ignoreBlankLines) {
    this.m_ignoreBlankLines = ignoreBlankLines;
    return this;
};

Frx.prototype.getLastScrollTop = function () {
    return this.m_lastScrollTop;
};

Frx.prototype.setLastScrollTop = function (lastScrollTop) {
    this.m_lastScrollTop = lastScrollTop;
    return this;
};

// Methods
Frx.prototype.id = function () {
    return this.m_id;
};

Frx.prototype.review = function () {
    return this.m_review;
};

Frx.prototype.getPrevFrx = function () {
    return this.m_prevFrx;
};

Frx.prototype.setPrevFrx = function (frx) {
    this.m_prevFrx = frx;
    return this;
};

Frx.prototype.getNextFrx = function () {
    return this.m_nextFrx;
};

Frx.prototype.setNextFrx = function (frx) {
    this.m_nextFrx = frx;
    return this;
};

Frx.prototype.isComplete = function () {
    return this.m_readStatus === "read";
};

Frx.prototype.colspan = function () {
    return this.m_colspan;
};

Frx.prototype.setColspan = function (colspan) {
    this.m_colspan = colspan;
    return this;
};

Frx.prototype.isLoaded = function () {
    return this.m_isLoaded;
};

Frx.prototype.setLoaded = function (loaded) {
    this.m_isLoaded = loaded;
    return this;
};

Frx.prototype.isLoading = function () {
    return this.m_isLoading;
};

Frx.prototype.setLoading = function (loading) {
    this.m_isLoading = loading;
    return this;
};

Frx.prototype.isExpanded = function () {
    return this.m_isExpanded;
};

Frx.prototype.setExpanded = function (expanded) {
    this.m_isExpanded = expanded;
    return this;
};

Frx.prototype.isFiltered = function () {
    return this.m_isFiltered;
};

Frx.prototype.setFiltered = function (filtered) {
    this.m_isFiltered = filtered;
    return this;
};

Frx.prototype.isBinary = function () {
    return this.m_isBinary;
};

Frx.prototype.setBinary = function (binary) {
    this.m_isBinary = binary;
    return this;
};

Frx.prototype.isDirectory = function () {
    return this.m_isDirectory;
};

Frx.prototype.setDirectory = function (directory) {
    this.m_isDirectory = directory;
    return this;
};

Frx.prototype.isNewSinceComplete = function () {
    return this.m_isNewSinceComplete;
};

Frx.prototype.setNewSinceComplete = function (newSinceComplete) {
    this.m_isNewSinceComplete = newSinceComplete;
    return this;
};

Frx.prototype.path = function () {
    return this.m_path;
};

Frx.prototype.setPath = function (path) {
    this.m_path = path;
    return this;
};

Frx.prototype.pathTruncated = function () {
    return this.m_pathTruncated;
};

Frx.prototype.setPathTruncated = function (pathTruncated) {
    this.m_pathTruncated = pathTruncated;
    return this;
};

Frx.prototype.branch = function () {
    return this.m_branch;
};

Frx.prototype.setBranch = function (branch) {
    this.m_branch = branch;
    return this;
};

Frx.prototype.sourceName = function () {
    return this.m_sourceName;
};

Frx.prototype.setSourceName = function (sourceName) {
    this.m_sourceName = sourceName;
    return this;
};

// FRX Revision Stuff
Frx.prototype.addFrxRevision = function (frxRev) {
    this.m_frxRevisions.push(frxRev);
    return this;
};

Frx.prototype.frxRevisions = function () {
    return this.m_frxRevisions;
};

Frx.prototype.setSliderFrxRevisions = function (revs) {
    this.m_sliderFrxRevisions = AJS.$.makeArray(revs);
    return this;
};

Frx.prototype.getSliderFrxRevisions = function () {
    return this.m_sliderFrxRevisions;
};

Frx.prototype.setVisibleFromRevision = function (frxRev) {
    this.m_visibleFromRevision = frxRev;
    return this;
};

Frx.prototype.setVisibleToRevision = function (frxRev) {
    this.m_visibleToRevision = frxRev;
    return this;
};

Frx.prototype.setVisibleFromSCMRevision = function (rev) {
    this.m_visibleFromSCMRevision = rev;
    return this;
};

Frx.prototype.setVisibleToSCMRevision = function (rev) {
    this.m_visibleToSCMRevision = rev;
    return this;
};

Frx.prototype.visibleFromRevision = function () {
    return this.m_visibleFromRevision;
};

Frx.prototype.visibleToRevision = function () {
    return this.m_visibleToRevision;
};

Frx.prototype.visibleFromSCMRevision = function () {
    return this.m_visibleFromSCMRevision;
};

Frx.prototype.visibleToSCMRevision = function () {
    return this.m_visibleToSCMRevision;
};

Frx.prototype.setFrxRevisionToCruRevisionMap = function (map) {
    this.m_frxRevisionToCruRevisionMap = map;
    return this;
};

Frx.prototype.frxRevisionToCruRevisionMap = function () {
    return this.m_frxRevisionToCruRevisionMap;
};

Frx.prototype.hasComments = function () {
    return this.comments().length > 0;
};

Frx.prototype.hasDefects = function () {
    return this.defects().length > 0;
};

Frx.prototype.hasUnreadComments = function () {
    return this.unreadComments().length > 0;
};

Frx.prototype.defects = function () {
    return AJS.$.grep(this.comments(), function (comment) {
        return comment.defect();
    });
};

Frx.prototype.addComment = function (comment) {
    this.m_comments[comment.id()] = comment;
    this.m_commentCacheDirty = true;
    return this;
};

Frx.prototype.comments = function () {
    if (this.m_commentCacheDirty) {
        this.m_commentArrayCache = [];
        var that = this;
        AJS.$.each(this.m_comments, function () {
            that.m_commentArrayCache.push(this);
        });
        this.m_commentCacheDirty = false;
    }
    return this.m_commentArrayCache;
};

Frx.prototype.domOrderedComments = function () {
    var commentArray = [];
    var idSelectors = [];
    AJS.$.each(this.m_comments, function () {
        idSelectors.push("#" + this.visibleDomId());
    });
    if (idSelectors.length > 0) {
        var $commentObjects = AJS.$(idSelectors.join(','));
        for (var i = 0, len = $commentObjects.length; i < len; i++) {
            var commentDom = $commentObjects[i];
            var commentId = commentDom.id.replace(/\D+/, '');
            var comment = this.m_comments[commentId];
            if (comment) {
                commentArray.push(comment);
            }
        }
    }
    return commentArray;
};

Frx.prototype.unreadComments = function () {
    return AJS.$.grep(this.comments(), function (comment) {
        return comment.status() === 'unread' || comment.status() === 'leaveUnread';
    });
};

Frx.prototype.fileComments = function () {
    return AJS.$.grep(this.comments(), function (comment) {
        return /^revision/.test(comment.type());
    });
};

Frx.prototype.removeComment = function (comment) {
    delete this.m_comments[comment.id()];
    this.m_commentCacheDirty = true;
    return this;
};

Frx.prototype.readStatus = function () {
    return this.m_readStatus;
};

Frx.prototype.setReadStatus = function (status) {
    this.m_readStatus = status;
    return this;
};

Frx.prototype.isReadStatusLocked = function () {
    return this.m_readStatusLocked;
};

Frx.prototype.lockReadStatus = function () {
    this.m_readStatusLocked = true;
    return this;
};

Frx.prototype.unlockReadStatus = function () {
    this.m_readStatusLocked = false;
    return this;
};

Frx.prototype.navItem = function () {
    var navItem = AJS.$(this.m_navItemSelector);
    if (navItem.length) {
        this.navItem = function () {
            return navItem;
        };
        return this.navItem();
    }
    return navItem;
};
Frx.prototype.setNavItemSelector = function (value) {
    this.m_navItemSelector = value;
    delete this.navItem;
    return this;
};

Frx.prototype.frxControls = function () {
    var frxControls = AJS.$(this.m_frxControlsSelector);
    if (frxControls.length) {
        this.frxControls = function () {
            return frxControls;
        };
        return this.frxControls();
    }
    return frxControls;
};
Frx.prototype.setFrxControlsSelector = function (value) {
    this.m_frxControlsSelector = value;
    delete this.frxControls;
    return this;
};

Frx.prototype.frxOuter = function () {
    var frxOuter = AJS.$(this.m_frxOuterSelector);
    if (frxOuter.length) {
        this.frxOuter = function () {
            return frxOuter;
        };
        return this.frxOuter();
    }
    return frxOuter;
};
Frx.prototype.setFrxOuterSelector = function (value) {
    this.m_frxOuterSelector = value;
    delete this.navItem;
    return this;
};

Frx.prototype.frxInner = function () {
    var frxInner = AJS.$(this.m_frxInnerSelector);
    if (frxInner.length) {
        this.frxInner = function () {
            return frxInner;
        };
        return this.frxInner();
    }
    return frxInner;
};
Frx.prototype.setFrxInnerSelector = function (value) {
    this.m_frxInnerSelector = value;
    delete this.frxInner;
    return this;
};

/**
 * Unload references to DOM elements to avoid memory leaks.
 * The frx is no longer in a usable state once this method is called.
 * */
Frx.prototype.dispose = function () {
    this.setNavItemSelector(null);
    this.setFrxControlsSelector(null);
    this.setFrxOuterSelector(null);
    this.setFrxInnerSelector(null);
};

/** Forces re-executing selectors for these items on next request */
Frx.prototype.invalidateCachedSelectors = function () {
    delete this.frxOuter;
    delete this.frxInner;
    delete this.navItem;
    delete this.frxControls;
};
/*[{!frx_js_t1nr51w!}]*/;
/* END /2static/script/cru/review/model/frx.js */
/* START /2static/script/cru/review/model/comment.js */
/**
 * @param {Number} id
 * @param {String} type
 * @class Comment
 */
function Comment(id, type) {
    this.m_id = id;
    this.m_type = type;
    this.m_domId = this.m_type + this.m_id;
    this.m_contentDomId = this.m_type.replace('reply', 'comment') + 'Content' + this.m_id;
    this.m_frx = undefined;
    this.m_review = undefined;
    this.m_replyTo = undefined;
    this.m_replies = [];
    this.m_status = undefined;
    this.m_message = undefined;
    this.m_messageAsHtml = undefined;
    this.m_defect = false;
    this.m_fromLineRange = undefined;
    this.m_toLineRange = undefined;
    this.m_draft = false;
    this.m_commentColor = undefined;
    this.m_gutterLine = undefined; // int
    this.m_fromRevId = undefined;
    this.m_toRevId = undefined;
    this.m_metrics = [];
    this.m_issueKey = undefined;
    this.m_issueStatus = undefined;
    this.m_date = undefined;
    this.m_author = undefined;
}

Comment.prototype.id = function () {
    return this.m_id;
};

/**
 * Returns the DOM ID of the comment's content and replies container.
 *
 * <p>
 * For source comments, this returns the inline version of the DOM ID.
 * You will need to regexp replace <code>inline</code> with <code>above</code>
 * to get the DOM ID for the above version of the comment.
 * </p>
 */
Comment.prototype.domId = function () {
    return this.m_domId; // if you update the HTML structure of comments, update visiblePosition()
};

/**
 * Returns the DOM ID of the comment's content container.
 *
 * <p>
 * For source comments, this returns the inline version of the DOM ID.
 * You will need to regexp replace <code>inline</code> with <code>above</code>
 * to get the DOM ID for the above version of the comment.
 * </p>
 *
 * <p>
 * Use this in favour of, e.g., <code>jQuery(comment.domId()).children('div.comment')</code>.
 * </p>
 */
Comment.prototype.contentDomId = function () {
    return this.m_contentDomId;
};

Comment.prototype.getDomElement = function () {
    return AJS.$('#' + this.domId());
};

Comment.prototype.getContentDomElement = function () {
    return AJS.$('#' + this.contentDomId());
};


// It is possible for the comment object to exist, but not be in the dom - eg when we autosave comments.
Comment.prototype.domIdExists = function () {
    return this.getDomElement().length > 0;
};

Comment.prototype.frx = function () {
    return this.m_frx;
};

Comment.prototype.setFrx = function (frx) {
    this.m_frx = frx;
    this.m_review = frx.review();
    return this;
};

Comment.prototype.review = function () {
    return this.m_review;
};

Comment.prototype.setReview = function (review) {
    this.m_review = review;
    return this;
};

Comment.prototype.type = function () {
    return this.m_type;
};

/**
 * the location of the comment: either general, revision or inline.
 */
Comment.prototype.position = function () {
    return this.isReply() ? this.m_type.replace(/reply$/, "") : this.m_type.replace(/comment$/, "");
};

/**
 * Returns the position of the comment which is visible.
 * @return either 'general', 'revision', 'inline' or 'above' depending on which comment is visible. If the comment
 * is hidden, an empty string is returned. If both inline and above comments are shown, the result is indeterminant.
 */
Comment.prototype.visiblePosition = function () {
    var position = this.position();
    var place = this.isReply() ? 'reply' : 'comment';
    if (AJS.$("#" + position + place + this.m_id).is(":visible")) {
        return position;
    } else if (this.isInline()) {
        position = 'above';
        if (AJS.$('#' + position + place + this.m_id).is(":visible")) {
            return position;
        }
    }
    return '';
};

Comment.prototype.visibleDomId = function () {
    if (this.isInline() && AJS.$('body').hasClass('show-above-comments')) {
        return this.m_domId.replace('inline', 'above');
    } else {
        return this.m_domId;
    }
};

Comment.prototype.status = function () {
    return this.m_status;
};

Comment.prototype.setStatus = function (status) {
    this.m_status = status;
    return this;
};

Comment.prototype.isReply = function () {
    return !!this.m_replyTo;
};

Comment.prototype.replyTo = function () {
    return this.m_replyTo;
};

Comment.prototype.setReplyTo = function (replyTo) {
    this.m_replyTo = replyTo;
    return this;
};

Comment.prototype.hasReplies = function () {
    return this.m_replies.length > 0;
};

Comment.prototype.addReply = function (comment) {
    var alreadyAdded = this.getReplies()
        .some(function (reply) {
            return reply.id() === comment.id();
        });
    if (!alreadyAdded) {
        this.m_replies.push(comment);
    }
    return this;
};

Comment.prototype.getReplies = function () {
    return this.m_replies;
};

Comment.prototype.clearReplies = function () { //recursive
    var replies_copy = this.m_replies.slice(); // use a copy because review.removeComment() modifies this.m_replies
    for (var i = 0, len = replies_copy.length; i < len; i++) {
        var reply = replies_copy[i];
        if (reply) {
            reply.clearReplies();
            review.removeComment(reply);
        }
    }
    this.m_replies = [];
};

Comment.prototype.isInline = function () {
    return /^inline/.test(this.m_type);
};

Comment.prototype.isHidden = function () {
    return this.isInline() && !this.fromLineRange() && !this.toLineRange();
};

Comment.prototype.message = function () {
    return this.m_message;
};

Comment.prototype.setMessage = function (message) {
    this.m_message = message;
    return this;
};

Comment.prototype.messageAsHtml = function () {
    return this.m_messageAsHtml;
};

Comment.prototype.setMessageAsHtml = function (message) {
    this.m_messageAsHtml = message;
    return this;
};

Comment.prototype.defect = function () {
    return this.m_defect;
};

Comment.prototype.setDefect = function (defect) {
    this.m_defect = defect;
    return this;
};

Comment.prototype.draft = function () {
    return this.m_draft;
};

Comment.prototype.setDraft = function (draft) {
    this.m_draft = draft;
    return this;
};

Comment.prototype.fromLineRange = function () {
    return this.m_replyTo ? this.m_replyTo.fromLineRange() : this.m_fromLineRange;
};

Comment.prototype.setFromLineRange = function (lr) {
    this.m_fromLineRange = lr;
    return this;
};

Comment.prototype.toLineRange = function () {
    return this.m_replyTo ? this.m_replyTo.toLineRange() : this.m_toLineRange;
};

Comment.prototype.setToLineRange = function (lr) {
    this.m_toLineRange = lr;
    return this;
};

Comment.prototype.fromRevId = function () {
    return this.isReply() ? this.m_replyTo.fromRevId() : this.m_fromRevId;
};

Comment.prototype.setFromRevId = function (id) {
    this.m_fromRevId = id;
    return this;
};

Comment.prototype.toRevId = function () {
    return this.m_replyTo ? this.m_replyTo.toRevId() : this.m_toRevId;
};

Comment.prototype.setToRevId = function (id) {
    this.m_toRevId = id;
    return this;
};

Comment.prototype.commentColor = function () {
    return this.m_commentColor;
};

Comment.prototype.setCommentColor = function (color) {
    this.m_commentColor = color;
    return this;
};

Comment.prototype.gutterLine = function () {
    return this.m_replyTo ? this.m_replyTo.gutterLine() : this.m_gutterLine;
};

Comment.prototype.setGutterLine = function (gutterLine) {
    this.m_gutterLine = gutterLine;
    return this;
};

Comment.prototype.metrics = function () {
    return this.m_metrics;
};

Comment.prototype.setMetrics = function (metrics) {
    this.m_metrics = metrics || [];
    return this;
};

Comment.prototype.issueKey = function () {
    return this.m_issueKey;
};

Comment.prototype.setIssueKey = function (issueKey) {
    this.m_issueKey = issueKey;
    return this;
};

Comment.prototype.issueStatus = function () {
    return this.m_issueStatus;
};

Comment.prototype.setIssueStatus = function (issueStatus) {
    this.m_issueStatus = issueStatus;
    return this;
};

/**
 * @param {Date} date
 * @return {Comment}
 */
Comment.prototype.setDate = function (date) {
    if (typeof date !== 'undefined' && !(date instanceof Date)) {
        throw new Error('Comment date must be an instance of Date');
    }
    this.m_date = date;
    return this;
};

/**
 * @return {(Date|undefined)}
 */
Comment.prototype.date = function () {
    return this.m_date;
};

/**
 * @return {(User|undefined)}
 */
Comment.prototype.author = function () {
    return this.m_author;
};

/**
 * @param {User} author
 * @return {Comment}
 */
Comment.prototype.setAuthor = function (author) {
    if (typeof author !== 'undefined' && !(author instanceof User)) {
        throw new Error('Author must be an instance of User');
    }
    this.m_author = author;
    return this;
};
/*[{!comment_js_yz0j51v!}]*/;
/* END /2static/script/cru/review/model/comment.js */
/* START /2static/script/cru/review/model/reviewer.js */
var Reviewer = (function (mixins, navBuilder) {

    function calcPercentageComplete(percentageComplete) {
        percentageComplete = Math.floor(percentageComplete / 20) * 20;
        if (isNaN(percentageComplete)) {
            return 0;
        }
        return percentageComplete;
    }

    function Reviewer(id, username, displayName, percentageComplete, hasCompleted) {
        this.m_id = parseInt(id, 10);
        this.m_username = username;
        this.m_displayName = displayName;
        this.m_percentageComplete = calcPercentageComplete(percentageComplete);
        this.m_hasCompleted = hasCompleted;
    }

    AJS.$.extend(Reviewer.prototype, mixins.EventProducer);

    // returns true if the values have changed
    Reviewer.prototype.updateReviewer = function (percentageComplete, hasCompleted) {
        var oldPercent = this.m_percentageComplete;
        var oldCompleted = this.m_hasCompleted;

        this.m_percentageComplete = calcPercentageComplete(percentageComplete);

        var previouslyCompleted = this.m_hasCompleted;
        this.m_hasCompleted = hasCompleted;
        if (previouslyCompleted !== hasCompleted) {
            this.trigger("reviewerCompletenessChanged", {reviewer: this});
        }
        return oldPercent !== this.m_percentageComplete || oldCompleted !== this.m_hasCompleted;
    };

    Reviewer.prototype.getId = function () {
        return this.m_id;
    };

    Reviewer.prototype.getUserName = function () {
        return this.m_username;
    };

    Reviewer.prototype.getDisplayName = function () {
        return this.m_displayName;
    };

    Reviewer.prototype.getAvatarUrl = function () {
        return this.avatarUrl || navBuilder.avatar(this.m_username);
    };

    Reviewer.prototype.setAvatarUrl = function (avatarUrl) {
        this.avatarUrl = avatarUrl;
        return this;
    };

    Reviewer.prototype.getSortName = Reviewer.prototype.getUserName;

    Reviewer.prototype.getPercentageComplete = function () {
        return this.m_percentageComplete;
    };

    Reviewer.prototype.getHasCompleted = function () {
        return this.m_hasCompleted;
    };

    return Reviewer;

})(FECRU.MIXINS, FECRU.NAVBUILDER);
/*[{!reviewer_js_84vh51z!}]*/;
/* END /2static/script/cru/review/model/reviewer.js */
/* START /2static/script/cru/review/model/review-observer.js */
function reviewObserver(eventBus) {
    var callBeforeMethod = function (object, methodName, callback) {

        var originalMethod = object[methodName];
        object[methodName] = function () {
            //todo temporary fix while synchronisation is not fully working
            try {
                callback.apply(this, arguments);
            } catch (e) {
                console.log("Error in callback: " + e)
            }
            return originalMethod.apply(this, arguments);
        };
    };

    callBeforeMethod(Review.prototype, 'addComment', function (comment) {
        eventBus.trigger('comment:add', comment);
    });

    callBeforeMethod(Review.prototype, 'removeComment', function (comment) {
        eventBus.trigger('comment:remove', comment);
    });

    callBeforeMethod(Comment.prototype, 'setStatus', function (status) {
        eventBus.trigger('comment:setStatus', this.m_id, status);
    });

    callBeforeMethod(Comment.prototype, 'setMessageAsHtml', function (message) {
        eventBus.trigger('comment:setMessageAsHtml', this.m_id, message);
    });

    callBeforeMethod(Comment.prototype, 'setMetrics', function (metrics) {
        eventBus.trigger('comment:setMetrics', this.m_id, metrics);
    });

    callBeforeMethod(Comment.prototype, 'setDraft', function (isDraft) {
        eventBus.trigger('comment:setDraft', this.m_id, isDraft);
    });

    callBeforeMethod(Comment.prototype, 'setDefect', function (isDefect) {
        eventBus.trigger('comment:setDefect', this.m_id, isDefect);
    });
};
/* END /2static/script/cru/review/model/review-observer.js */
/* START /2static/script/cru/review/model/user.js */
var User = (function (navBuilder) {
    var _usersIndex = Object.create(null);

    /**
     * @param {Number} id
     * @param {String} userName
     * @param {String} displayName
     * @param {String} avatarUrl
     * @class User
     */
    function User(id, userName, displayName, avatarUrl) {
        this.id = id;
        this.userName = userName;
        this.displayName = displayName;
        this.avatarUrl = avatarUrl;
    }

    /**
     * Updates username and display name
     *
     * @deprecated use setUsername and setDisplayName
     *
     * @param {String} userName
     * @param {String} displayName
     */
    User.prototype.update = function (userName, displayName) {
        this.userName = userName;
        this.displayName = displayName;
    };

    User.prototype.getId = function () {
        return this.id;
    };

    User.prototype.getUserName = function () {
        return this.userName;
    };

    /**
     * @param {String} userName
     * @return {User}
     */
    User.prototype.setUserName = function (userName) {
        this.userName = userName;
        return this;
    };

    User.prototype.getDisplayName = function () {
        return this.displayName;
    };

    /**
     * @param {String} displayName
     * @return {User}
     */
    User.prototype.setDisplayName = function (displayName) {
        this.displayName = displayName;
        return this;
    };

    User.prototype.getAvatarUrl = function () {
        return this.avatarUrl || navBuilder.avatar(this.userName);
    };

    User.prototype.setAvatarUrl = function (avatarUrl) {
        this.avatarUrl = avatarUrl;
        return this;
    };

    /**
     * @typedef {Object} User.data
     * @property {String} userName
     * @property {String} displayName
     * @property {String} avatarUrl
     */

    /**
     * Returns an instance of User object for given id if it exists in local index.
     * Otherwise creates it, populate the index and returns it.
     *
     * @param {Number} id
     * @param {User.data} userData
     * @return {User}
     */
    User.getFromLocalIndexOrCreate = function (id, userData) {
        var user = _usersIndex[id];
        if (!user) {
            user = new User(id);
            _usersIndex[id] = user;
        }

        user.setUserName(userData.userName)
            .setDisplayName(userData.displayName)
            .setAvatarUrl(userData.avatarUrl);

        return user;
    };
    return User;

})(FECRU.NAVBUILDER);
/*[{!user_js_m92i520!}]*/;
/* END /2static/script/cru/review/model/user.js */
/* START /2static/script/cru/review/review-event.js */
if (!CRU.REVIEW.EVENTS) {
    CRU.REVIEW.EVENTS = {};
}

(function () {
    var $document = AJS.$(document);
    $document.ready(function () {
        var cru_util = CRU.UTIL;
        var cru_review = CRU.REVIEW;
        var cru_review_util = CRU.REVIEW.UTIL;

        var $frxPane = AJS.$("#frx-pane");

        $frxPane.delegate('.frxouter:not(.activeFrx)', 'mousedown', function (e) {
            var $target = AJS.$(e.target || e.srcElement);
            if ($target.is('#generalComments, .frx-actions')
                || $target.parents('.frx-actions').length === 1) {
                return true;
            }
            CRU.FRX.NAV.setCurrentFrx(this, {sticky: true});
            var $parentRow = $target.closest('tr');
            if ($parentRow.length > 0 && !e.altKey) {
                return commentator.selectLine_down($parentRow, true);
            }
            return true;
        });

        var mouseDown = false;
        var onMouseOver = function () {
            return commentator.selectLine_over(AJS.$(this));
        };

        $frxPane.delegate('.activeFrx .inlineSource .commentableLine td:not(.tetrisColumn, .diffNav, .author, .revision)', "mousedown", function (e) {
            // only accept left clicks
            if (e.altKey || e.which !== 1) {
                return true;
            }

            if (!mouseDown) {
                // Event delegation for frx commentable lines.
                // Huge performance boost for reviews with thousands of lines of frx lines
                // Listener is needed only when mouse button is pressed
                $frxPane.delegate('.activeFrx .commentableLine', "mouseover", onMouseOver);
            }
            mouseDown = true;
            return commentator.selectLine_down(AJS.$(this).closest('tr.commentableLine'));
        });

        $frxPane.delegate('.activeFrx', "mouseup", function () {
            if (mouseDown) {
                mouseDown = false;
                $frxPane.undelegate('.activeFrx .commentableLine', "mouseover", onMouseOver);
                var frxId = this.id.replace('frxouter', '');
                var $inlineSource = AJS.$('#sourcefrxinner' + frxId).children('.inlineSource');
                return commentator.selectLine_up($inlineSource);
            }
            return true;
        });

        AJS.$("#parentReviewId, #linkReviewSaveButton").keypress(function (e) {
            var key = e.which || e.keyCode;
            var el = e.target || e.srcElement;
            if ((key === AJS.$.ui.keyCode.ENTER || key === AJS.$.ui.keyCode.TAB) && el.type !== 'textarea') {
                if (cru_review_util.postLinkedReview) {
                    cru_review_util.postLinkedReview();
                }
                return false;
                //TODO: Port to jQuery events and e.stopPropagation();
            }
        });

        $document.delegate("#linkReviewSaveButton", "click", function () {
            cru_review_util.postLinkedReview();
            return false;
        });

        $document.delegate("#linkReviewUnlinkButton", "click", function () {
            cru_review_util.postUnlinkReview();
            return false;
        });

        $document.delegate("#addInviteeButton", "click", function () {
            CRU.CREATE.addInvitee();
        });

        // Jira links get loaded by Ajax
        $document.delegate("#jiraIssueQuickLink", "click", function () {
            var suggestedIssueKey = AJS.$(this).siblings("input[name=suggestedIssueKey]").val();
            cru_review_util.findAndLinkJiraIssue(suggestedIssueKey);
            return false;
        });

        $document.delegate("#jiraFindButton", "click", function () {
            cru_review_util.findJiraIssue();
            return false;
        });

        $document.delegate("#jiraClearButton", "click", function () {
            cru_review_util.unlinkJiraIssue();
            return false;
        });

        var toggleAndResize = function ($elem) {
            $elem.toggle();
            CRU.UI.columnFillHeight();
        };

        AJS.$("#patchList").click(function () {
            toggleAndResize(AJS.$(this).siblings(".expandable"));
        });

        AJS.$('#clear-filter-link').click(function () {
            AJS.$('#frxFilterOptions li.selected').removeClass("selected");
            CRU.FRX.changedFrxFilter();
        });

        $document.delegate('#frxFilterOptions li.frx-filter-option:not(.disabled)', 'click', function (e) {
            AJS.$(this).toggleClass("selected");
            CRU.FRX.changedFrxFilter();
            e.stopPropagation(); // Don't let the menu be closed when selecting options
        });

        $document.delegate('#element-navigation', 'click', function (e) {
            if (e.target.id === 'element-navigation') {
                AJS.$('#element-link').click();
            }
        });

        $document.delegate('#element-navigation li.search-option', 'click', function (e) {
            var $option = AJS.$(this);
            // Only allow toggling of the item if one or more of the other options is still selected, to avoid being
            // able to select none of them (which is nonsensical)
            if ($option.siblings(".selected").length > 0) {
                $option.toggleClass("selected");
            }
            e.stopPropagation();
        });

        AJS.$('#next-element-link').click(function () {
            CRU.FRX.goToNextElement('next', AJS.$('#next-element-link'));
        });

        AJS.$('#prev-element-link').click(function () {
            CRU.FRX.goToNextElement('previous', AJS.$('#prev-element-link'));
        });

        AJS.$("#set-inline-comments a").click(function () {
            commentator.toggleComments('inline');
            CRU.COMMENT.NAV.visibleCommentsChanged();
        });

        AJS.$("#set-above-comments a").click(function () {
            commentator.toggleComments('top');
            CRU.COMMENT.NAV.visibleCommentsChanged();
        });

        AJS.$("#set-hidden-comments a").click(function () {
            commentator.toggleComments('none');
            CRU.COMMENT.NAV.visibleCommentsChanged();
        });

        AJS.$("#set-side-by-side-diffs a").click(function () {
            AJS.$("#set-unified-diffs").removeClass("selected");
            AJS.$("#set-side-by-side-diffs").addClass("selected");
            CRU.FRX.toggleAllFrxsDiffMode('s');
        });

        AJS.$("#set-unified-diffs a").click(function () {
            AJS.$("#set-side-by-side-diffs").removeClass("selected");
            AJS.$("#set-unified-diffs").addClass("selected");
            CRU.FRX.toggleAllFrxsDiffMode('u');
        });

        AJS.$("#set-soft-wrapping-on a").click(function () {
            AJS.$("#set-soft-wrapping-off").removeClass("selected");
            AJS.$("#set-soft-wrapping-on").addClass("selected");
            CRU.FRX.toggleAllFrxsSoftWrapping(true);
        });

        AJS.$("#set-soft-wrapping-off a").click(function () {
            AJS.$("#set-soft-wrapping-on").removeClass("selected");
            AJS.$("#set-soft-wrapping-off").addClass("selected");
            CRU.FRX.toggleAllFrxsSoftWrapping(false);
        });

        $document.delegate("#mark-comments-read-button:not(.disabled)", "click", function () {
            CRU.COMMENT.markAllCommentsRead();
        });

        $document.delegate("#addReviewCommentLink:not(.disabled)", "click", function () {
            cru_review.WIKI.resetPreview();
            commentator.displaySimpleCommentForm(null, 'generalCommentForm');
            AJS.$(this).hide();
        });

        $document.delegate(".addFileCommentLink:not(.disabled)", "click", function () {
            var frxId = this.id.replace('addFileCommentLink', '');
            cru_review.WIKI.resetPreview();
            commentator.displayFileCommentForm(null, 'fileCommentForm' + frxId, frxId);
        });

        $document.delegate("#review-updated-warning .close", "click", function () {
            AJS.$('#review-updated-warning').slideUp('fast');
            AJS.$('body').removeClass('review-updated');
        });

        $document.delegate("#review-updated-warning .collapse", "click", function () {
            var warning = AJS.$('#review-updated-warning');
            if (warning.hasClass('collapsed')) {
                warning.removeClass('collapsed');
                AJS.$('#review-updated-warning a.collapse').text('Collapse');
            } else {
                warning.addClass('collapsed');
                AJS.$('#review-updated-warning a.collapse').text('Expand');
            }
        });

        /** previous value of time-tracking field, in case of invalid update **/
        var prevMins = null;
        /** has current value of time-tracking field value been posted to server **/
        var savedMins = false;

        AJS.$("#time-spent-input")
            .live("click", function () {
                prepTimeSpentForInput();
            })
            .bind("blur", function () {
                saveUpdatedTimeSpent();
            })
            .keypress(function (e) {
                if (e.which === AJS.$.ui.keyCode.ENTER) {
                    e.preventDefault();
                    saveUpdatedTimeSpent();
                }
            });

        /** truncate 'minutes' from editable time field **/
        var prepTimeSpentForInput = function () {
            if (!cru_review.TIMER.editing) {
                cru_review.TIMER.startEditing();
                var $in = AJS.$("#time-spent-input");
                prevMins = $in.val();
                $in.parent().addClass("edit");
                savedMins = false;
            }
        };

        /** dispatch updated time spent to server (if valid) **/
        var saveUpdatedTimeSpent = function () {
            if (savedMins) {
                return; //don't dispatch twice
            }
            savedMins = true;

            var $in = AJS.$("#time-spent-input");
            var $container = $in.parent();

            $in.prop("disabled", true);
            $container.addClass('spinner');

            var url = cru_util.jsonUrlBase(permaId) + "/updateTimeTrackingAjax";
            var params = {timeText: $in.val()};
            FECRU.AJAX.ajaxUpdate(url, params, 'time-spent-input', function (resp) {
                $container.removeClass('spinner');
                cru_review.TIMER.stopEditing(resp.worked);
                if (!resp.worked) {
                    $container.css('background-color', 'pink');
                    setTimeout(function () {
                        $container.css('background-color', '');
                        $in.val(prevMins);
                    }, 750);
                } else {
                    $in.val(resp.payload);
                }
                $in.removeProp("disabled");
                $in.parent().removeClass("edit");
                //ensure focus is removed (e.g. when switching tabs/windows blur is triggered, but the input is still selected)
                $in.blur();
            }, true);
        };

        $document.delegate(".submit-time-dialog .submit-time-button", "click", function () {
            var $contentDiv = AJS.$(this).closest(".contents");
            $contentDiv.find(".submit-time-spinner").show();
            var url = cru_util.jsonUrlBase(review.id()) + '/updateJiraTimeAjax-post';
            var params = {
                "comment": $contentDiv.find("#time-comment").val(),
                "timeToSubmit": $contentDiv.find("#time-amount").val()
            };
            var done = function (resp) {
                /** todo - maybe show a little fade-in/fade-out "time has been updated" message on completeion **/
                var dialogHider = $contentDiv.data("dialogHider");
                dialogHider.hideDialog();
                $contentDiv.find("#time-comment").val(""); //clear comment (may have been customised)
                dialogHider.refreshContentDiv($contentDiv); //refresh contents on submit
                $contentDiv.find(".submit-time-spinner").hide();
            };
            FECRU.AJAX.ajaxDo(url, params, done, false);
        });

        /**
         * name of the cookie that is used to if the "Add Content" dialog has shown
         * @type {String}
         */
        var COOKIE_NAME_ADD_CONTENT_SHOWN = "editReviewShown";

        /**
         * name of the cookie that is used to record if the "Shown Details" dialog has shown
         * @type {String}
         */
        var COOKIE_NAME_REVIEW_DETAIL_SHOWN = "editReviewDetailShown";

        /**
         * Whether the edit review dialog has been shown during this browser session.
         *
         * Used to make sure a user is presented with this at least once for draft reviews.
         */
        var hasReviewPopupBeenShown = function (cookieName) {
            return AJS.$.inArray(review.id(), reviewIdsPopupShownFor(cookieName)) >= 0;
        };

        var reviewIdsPopupShownFor = function (cookieName) {
            var popupShown = AJS.$.cookie(cookieName);
            var ids = popupShown ? popupShown.split(',') : [];
            return ids;
        };


        /**
         * Capable of storing approximately 15 draft reviews
         * The total size for editReviewShown & editReviewDetailShown will be kept around 400 bytes.
         *
         * @type {Number}
         */
        var MAX_COOKIE_LIST_SIZE = 180;

        var addReviewIdToCookie = function (cookieName, reviewId) {
            var popupShown = reviewIdsPopupShownFor(cookieName);
            if (AJS.$.inArray(reviewId, popupShown) < 0) {
                popupShown.push(reviewId);
                writePopupShownToCookie(cookieName, popupShown);
            }
        }

        /**
         * This method will try to concatenate items with ','.
         * Meanwhile, the total size will be restricted to a certain limit. (MAX_COOKIE_LIST)
         * If it exceeds the limit, drop some item following FIFO rule.
         * Finally, the result string will be written to cookie.
         *
         * @param cookieName : string
         *  'editReviewShown' | 'editReviewDetailShown'
         * @param items : []
         *  _: string
         *
         */
        var writePopupShownToCookie = function (cookieName, items, skipLimitCheck) {
            items = items || [];
            var cookieValue = items.join(',');
            while (cookieValue.length > MAX_COOKIE_LIST_SIZE && !skipLimitCheck) {
                items.shift();
                cookieValue = items.join(',');
            }

            AJS.$.cookie(cookieName, cookieValue, {path: FECRU.pageContext + '/cru/'});
        };

        /**
         * Remove a review id from the cookie once the review is started
         */
        var removePopupShownFromCookie = function () {
            var reviewId = review.id();

            var removeCookie = function (cookieName, ids) {
                var index = AJS.$.inArray(reviewId, ids);
                if (index > -1) {
                    ids.splice(index, 1);
                    writePopupShownToCookie(cookieName, ids, true);
                }
            };
            removeCookie(COOKIE_NAME_ADD_CONTENT_SHOWN, reviewIdsPopupShownFor(COOKIE_NAME_ADD_CONTENT_SHOWN));
            removeCookie(COOKIE_NAME_REVIEW_DETAIL_SHOWN, reviewIdsPopupShownFor(COOKIE_NAME_REVIEW_DETAIL_SHOWN));
        };

        /**
         * When the review transits from draft to started,
         * we will remove the review id from cookie as it will not be used any more.
         */
        CRU.UTIL.onReviewStateTransit("remove-popup-shown-cookie", function (command, resp) {
            if ((command === 'action:approveReview' && resp.showDialog === false)
                || (command === 'confirmApprove')) {
                removePopupShownFromCookie();
            }
        });

        cru_review.baseUrlSuffix = '';

        $document.delegate('#add-content-methods .method:not(.disabled)', 'click', function () {
            var $self = AJS.$(this);
            $self.trigger('add-content-item-selected.review');
            manageFiles('/edit-' + $self.attr('id'), $self.data('url'));
        });

        var manageFilesDialog;

        var removeManageFilesDialog = function () {
            if (manageFilesDialog) {
                manageFilesDialog.remove();
                manageFilesDialog = null;
            }
            if (cru_review.EDIT) {
                cru_review.EDIT.closeSuggestions();
            }
        };

        cru_review.showManageFilesDialog = function (callback) {
            if (manageFilesDialog) {
                cru_util.stopAjaxDialogSpin();
                manageFilesDialog.show();
                callback && callback();
            }
        };

        var cachedAddContentPage;

        var getAddContentPage = function () {
            if (!cachedAddContentPage) {
                cachedAddContentPage = AJS.$(AJS.template.load("add-content-popup").toString());
            }
            return cachedAddContentPage;
        };

        //only add it if it exists in the tools dropdown
        var addTransitionIfExists = function (manageFilesDialog, $toolMenuBar, actionName, actionFunction) {
            var $button = $toolMenuBar.find(".action-" + actionName);
            if ($button.length > 0) {
                manageFilesDialog.addButton($button.first().text(), actionFunction);
            }
        };
        var performActionOnReview = function (action) {
            var done = function () {
                removeManageFilesDialog();
                cru_util.stateTransition('action:' + action, permaId);
            };
            cru_review_util.postEditDetailsForm(done);
        };
        /**
         * Returns a function that calls targetFunction in current context with given arguments
         *
         * @param {Function} targetFunction
         * @param {...*} targetFunctionArguments
         * @return {Function}
         */
        var prepopulateFunctionArguments = function (targetFunction, targetFunctionArguments) {
            var args = Array.prototype.slice.call(arguments, 1);
            return function () {
                return targetFunction.apply(this, args);
            };
        };

        var bindDetailsHovers = function () {
            var $dialog = AJS.$('#dialog-response-holder');
            $dialog.delegate('#reviewers-chosen .reviewer-span-holder', 'mouseenter', function () {
                AJS.$(this).find('.remove-reviewer').show();
            }).delegate('#reviewers-chosen .reviewer-span-holder', 'mouseleave', function () {
                AJS.$(this).find('.remove-reviewer').hide();
            });

            $dialog.delegate('#linked-issue-container', 'mouseenter', function () {
                AJS.$('#jiraClearButton').show();
            }).delegate('#linked-issue-container', 'mouseleave', function () {
                AJS.$('#jiraClearButton').hide();
            });

            $dialog.delegate('#linked-review-container', 'mouseenter', function () {
                AJS.$('#linkReviewUnlinkButton').show();
            }).delegate('#linked-review-container', 'mouseleave', function () {
                AJS.$('#linkReviewUnlinkButton').hide();
            });
        };

        var manageFiles = function (editPage, customUrl) {

            var userIntendedAction;
            var userIntendedActionContext;
            var setUserIntendedAction = function (func, context) {
                userIntendedAction = func;
                userIntendedActionContext = context || window;
            };
            var getIframe = function () {
                return document.getElementById('editReviewIframe')
            };
            var doesIframeHasOnBeforeUnload = function () {
                var iframe = getIframe();
                return !!(iframe && iframe.contentWindow && iframe.contentWindow.onbeforeunload);
            };
            var confirmIframeClose = function () {
                var iframe = getIframe();
                // there is no such thing for iframe like "unload",
                // so in order to simulate "unload" we must change the SRC of the iframe
                iframe.src = 'about:blank';
            };
            var listenOnIframeUnload = function () {
                var iframe = getIframe();
                var iframeWindow = iframe.contentWindow;

                // do not duplicate event handlers
                iframeWindow.removeEventListener('unload', callUserIntendedAction);
                iframeWindow.addEventListener('unload', callUserIntendedAction);
            };
            var callUserIntendedAction = function () {
                var iframe = getIframe();
                iframe.contentWindow.removeEventListener('unload', callUserIntendedAction);
                if (!userIntendedAction) {
                    return;
                }
                // necessary to prevent safari from crash
                setTimeout(function () {
                    userIntendedAction.call(userIntendedActionContext);
                }, 0);
            };
            var confirmIframeCloseBeforeExecutingAnAction = function (actionFunction) {
                if (doesIframeHasOnBeforeUnload()) {
                    setUserIntendedAction(actionFunction, this);
                    listenOnIframeUnload();
                    confirmIframeClose();
                } else {
                    actionFunction.call(this);
                }
            };
            var createButtonHandlerThatConfirmsIframeClose = function (realButtonHandler) {
                return prepopulateFunctionArguments(confirmIframeCloseBeforeExecutingAnAction, realButtonHandler);
            };

            // Clear the watches on the unsaved fields, since edit details/add content will reload this content
            CRU.UNSAVED.clearWatchForUnsavedChanges();
            CRU.FRX.AJAX.blockFrxLoading();
            cru_review_util.blockReviewUpdatePolling();

            removeManageFilesDialog();
            cru_util.startAjaxDialogSpin();
            var reviewId = review.id();
            addReviewIdToCookie(COOKIE_NAME_ADD_CONTENT_SHOWN, reviewId);


            var isAddContent = editPage === '/add-content-method';
            var isEditDetails = editPage === '/edit-details';
            var dialogName = isAddContent ? 'cru-add-content-dialog' : (isEditDetails ? 'cru-edit-details-dialog' : 'cru-manage-files-dialog');
            var HEADER_HEIGHT = 56; //height of the dialog header, in px
            var BUTTON_HEIGHT = 51; //height of the buttons at bottom of dialog, in px.
            var BODY_PADDING = 20; // needs to be the same as .aui-dialog .dialog-panel-body declaration in dialog.css
            var IFRAME_SPACING = 5; // under html5 the iframe gets arbtirary following spacing, and this removes the scrollbar it causes
            var OUTERHEIGHT = HEADER_HEIGHT + BUTTON_HEIGHT + BODY_PADDING + IFRAME_SPACING;

            manageFilesDialog = FECRU.DIALOG.create(1200, 700, dialogName);

            var iframeHeight = manageFilesDialog.height - OUTERHEIGHT;
            var iframeStyle = "style='width:100%;height:" + (iframeHeight) + "px'";

            var url;
            var params;
            var done;
            var cs;

            if (customUrl) {
                customUrl = customUrl.replace(/{baseUrlSuffix}/g, cru_review.baseUrlSuffix);
                cs = "<iframe frameborder='0' id='editReviewIframe' name='editReviewIframe' src='" + customUrl + "' " + iframeStyle + "></iframe>";
            } else {
                cs = "<div id='dialog-response-holder'></div>";
                if (!isAddContent) {
                    url = cru_util.jsonUrlBase(permaId) + editPage + cru_review.baseUrlSuffix;
                    params = {};
                    done = function (resp) {
                        cru_util.stopAjaxDialogSpin();
                        if (resp.worked) {
                            AJS.$('#dialog-response-holder').html(resp.payloadHtml);

                            cru_review.baseUrlSuffix = resp.baseUrlSuffix;
                            FECRU.DIALOG.triggerAjaxDialogLoaded();
                            manageFilesDialog.show();
                            bindDetailsHovers();
                        }
                    };
                }
            }

            var header = (isEditDetails ? 'Edit Review Details' : 'Add content to Review') + ' ' + review.id();
            manageFilesDialog.addHeader(header)
                .addPanel("Manage", cs);

            if (url) {
                FECRU.AJAX.ajaxDo(url, params, done);
            }

            if (isEditDetails) {
                manageFilesDialog.addButton("Add content", function () {
                    cru_review_util.postEditDetailsForm();
                    removeManageFilesDialog();
                    addContent();
                });
            } else {
                if (!isAddContent) {
                    manageFilesDialog.addButton("Add More Content",
                        createButtonHandlerThatConfirmsIframeClose(
                            function () {
                                removeManageFilesDialog();
                                addContent();
                            }
                        )
                    );
                }
                manageFilesDialog.addButton("Edit Details",
                    createButtonHandlerThatConfirmsIframeClose(
                        function () {
                            removeManageFilesDialog();
                            editReview();
                        }
                    )
                );
            }

            var $toolMenuBar = AJS.$("#page-actions");
            if (review.isEmpty() || review.isDraft()) {
                addTransitionIfExists(manageFilesDialog, $toolMenuBar, "abandonReview",
                    createButtonHandlerThatConfirmsIframeClose(
                        prepopulateFunctionArguments(performActionOnReview, "abandonReview")
                    )
                );
            }

            if (review.isDraft()) {
                addTransitionIfExists(manageFilesDialog, $toolMenuBar, "approveReview",
                    createButtonHandlerThatConfirmsIframeClose(
                        prepopulateFunctionArguments(performActionOnReview, "approveReview")
                    )
                );
                addTransitionIfExists(manageFilesDialog, $toolMenuBar, "submitReview",
                    createButtonHandlerThatConfirmsIframeClose(
                        prepopulateFunctionArguments(performActionOnReview, "submitReview")
                    )
                );
                addTransitionIfExists(manageFilesDialog, $toolMenuBar, "rejectReview",
                    createButtonHandlerThatConfirmsIframeClose(
                        prepopulateFunctionArguments(performActionOnReview, "rejectReview")
                    )
                );
            }

            manageFilesDialog.addButton("Done",
                createButtonHandlerThatConfirmsIframeClose(function () {
                        CRU.CREATE.submitDetailsForm();
                        removeManageFilesDialog();
                    }
                )
            );

            if (isAddContent) {
                var $dialog = AJS.$('#dialog-response-holder');
                $dialog.html(getAddContentPage());

                cru_util.stopAjaxDialogSpin();
                manageFilesDialog.show();
                $document.trigger('add-content-dialog-shown.review');
            } else if (customUrl) {
                AJS.$('#editReviewIframe').load(function () {
                    var wnd = this.contentWindow;
                    CRU.REVIEW.showManageFilesDialog(wnd.onIframeContentLoaded);
                });
            }
        };

        // Live event: button is replaced by ajax content load after saving an edited review
        $document.delegate("#edit-review-link:not(.disabled)", "click", function () {
            editReview();
            return false;
        });

        // Live event: button is replaced by ajax content load after saving an edited review
        $document.delegate(".add-content-link:not(.disabled)", "click", function () {
            addContent();
            return false;
        });

        $document.delegate("#toggle-tree", "click", function () {
            CRU.UI.toggleTree();
        });

        AJS.$("#content-resizable").bind('resizestart', function (event, ui) {
            // The collapsed class forces a fixed width, which we don't want to do when resizing. This lets us resize when expanded.
            AJS.$(this).removeClass("collapsed");
        });

        $document.delegate(".edit-content-link:not(.disabled)", "click", function () {
            var $body = AJS.$('body');
            var $this = AJS.$(this);
            if ($body.hasClass('edit-mode')) {
                $body.removeClass('edit-mode');
                $this.attr('title', 'Edit the content in this review');
                AJS.$('#navigation-tree').find('.edit-mode-help').slideUp('fast');
            } else {
                //going into edit mode
                //show inline dialog if cookie is set
                $body.addClass('edit-mode');
                $this.attr('title', 'Stop editing the content in this review');
                AJS.$('#navigation-tree').find('.edit-mode-help').slideDown('fast');
            }
        });

        $document.delegate('.edit-mode-help h3', 'click', function () {
            var $info = AJS.$('#navigation-tree').find('.edit-mode-help').find('.info');
            if ($info.filter(':visible').length > 0) {
                FECRU.PREFS.setPreferences({
                    semh: "N"
                });
                AJS.$(this).addClass('closed').removeClass('open');
                $info.slideUp('fast');
            } else {
                FECRU.PREFS.setPreferences({
                    semh: "Y"
                });
                AJS.$(this).removeClass('closed').addClass('open');
                $info.slideDown('fast');
            }
        });

        var editReviewDone = function() {
            var reviewId = review.id();
            addReviewIdToCookie(COOKIE_NAME_REVIEW_DETAIL_SHOWN, reviewId);
        };

        var editReview = function () {
            editReviewDone();
            manageFiles('/edit-details');
        };

        var addContent = function () {
            manageFiles('/add-content-method');
        };

        var addContentWithMethod = function (addContentMethod) {
            editReviewDone();
            var addContentMethodSelector = ".method." + addContentMethod;
            var addContentMethodUrlWithReviewParam = getAddContentPage().find(addContentMethodSelector).first().data().url;
            manageFiles(null, addContentMethodUrlWithReviewParam + "&" + location.search.substring(1));
        };

        var summarizeDialog = 0;
        cru_review.createSummarizeDialog = function () {
            summarizeDialog = FECRU.DIALOG.ajaxDialog(640, 485, {}, "summarize-dialog");
            summarizeDialog.addHeader("Summarize Review")
                .addPanel("Summarize", AJS.$("#closingComment"));

            if (AJS.$('#action-menu-link-primary').find('.tools-trans .action-reopenReview').length > 0) {
                summarizeDialog.addButton("Reopen Review", function (summarizeDialog) {
                    var opt = {summary: AJS.$("#reviewSummaryInput").val()};
                    cru_util.stateTransition('action:reopenReview', permaId, opt);
                    summarizeDialog.hide();
                });
            }
            summarizeDialog.addButton("Continue Without Closing", function (summarizeDialog) {
                var opt = {newValue: AJS.$("#reviewSummaryInput").val()};
                cru_review_util.updateReviewField('summary', '/updateReviewSummaryAjax', opt);
                summarizeDialog.hide();
            })
                .addButton("Close Review", function (summarizeDialog) {
                    cru_review_util.closeReviewAjax();
                    summarizeDialog.hide();
                });
        };

        cru_review.openSummarizeDialog = function () {
            if (summarizeDialog === 0) {
                cru_review.createSummarizeDialog();
            }
            summarizeDialog.show();
        };

        if (AJS.$('#reviewpage').length === 1 && review.writable()) {
            var addContentMethod = FECRU.parseUri(window.location.href).params.addContentMethod;
            if (addContentMethod) {
                addContentWithMethod(addContentMethod);
                FECRU.removeQueryParams(['addContentMethod', 'projectKey', 'origin', 'changesetId', 'repositoryName']);
            } else if (review.isDraft()) {
                if (review.isEmpty() && !hasReviewPopupBeenShown(COOKIE_NAME_ADD_CONTENT_SHOWN)) {
                    addContent();
                } else if (!hasReviewPopupBeenShown(COOKIE_NAME_REVIEW_DETAIL_SHOWN)) {
                    editReview();
                }
            } else if (review.isSummarize()) {
                cru_review.openSummarizeDialog();
            }
        }

        cru_review_util.reorderParticipants();

        $document.delegate('.show-source-button', 'click', function () {
            CRU.FRX.toggleSource();
        });

        /*
         Use to clear all set FRX viewing filters on the review
         */
        $document.delegate("#filter-frxs-clear:not(.disabled)", "click", function (e) {
            AJS.$(this).addClass("disabled");
            AJS.$("#frxFilterOptions").find("li.selected").removeClass("selected");
            CRU.FRX.changedFrxFilter();
            e.preventDefault();
        });

        FECRU.UI.filterToggle("#frxFilterOptions");
    });
})();
/*[{!review_event_js_ilq351b!}]*/
;
/* END /2static/script/cru/review/review-event.js */
/* START /2static/script/cru/review/submit-time.js */
(function () {

    AJS.$(document).ready(function () {

        var isSubmittingTime = false;

        AJS.$(document).delegate("#submit-time-jira", "click", function (e) {
            if (!isSubmittingTime) {
                submitTimeToJira(this);
            }
            e.preventDefault();
        });

        /* Concerning the JIRA time submit from the Summarize process */
        var submitTimeToJira = function (submitButton) {
            var $this = AJS.$(submitButton);
            var $container = AJS.$("#linked-jira-log-work > dd");
            var $submitterTime = AJS.$("#submitterTime");
            var $toolbar = $this.closest(".aui-toolbar");
            var $toolbarGroup = $this.closest(".toolbar-group");
            var url = CRU.UTIL.jsonUrlBase(review.id()) + '/updateJiraTimeAjax-post';
            var succeeded = false;
            var params = {
                comment: "Time submitted by " + review.getLoggedInUser().userName + " for review " + review.id(),
                timeToSubmit: $submitterTime.val(),
                username: review.getLoggedInUser().userName
            };
            var setError = function (errorMsg) {
                $toolbar.hide();
                AJS.messages.error($container, {
                    body: errorMsg || "An unknown error occurred.",
                    closeable: false
                });
            };
            var unsetError = function () {
                $container.children('.error').remove();
            };
            var done = function (data) {
                if (data.worked) {
                    succeeded = true;
                    $toolbar.hide();
                    var $message = $container.children(".already-logged-message");
                    if ($message.length === 0) {
                        $message = AJS.$("<span>")
                            .addClass("already-logged-message")
                            .appendTo($container);
                    }
                    if (data.timeSubmitted) {
                        $message.text("You have logged " + data.timeSubmitted);
                    } else {
                        $message.text("Logged " + params.timeToSubmit);
                    }
                } else {
                    setError(data.errorMsg);

                    if (data.credentialsRequired && data.credentialsRequired.length) {
                        // listen for any authorization and try again.
                        var eventProducers = [];
                        var reenableButtonOnCredentialsAcquired = function () {
                            Array.each(eventProducers, function (eventProducer) {
                                eventProducer.unbind('success', reenableButtonOnCredentialsAcquired);
                            });

                            // reshow the button
                            $this.prop("disabled", false);
                            $toolbarGroup.removeClass("loading");
                            unsetError();
                            $toolbar.removeClass("disabled").show();
                        };

                        Array.each(data.credentialsRequired, function (credentialsRequiredMessage) {
                            if (credentialsRequiredMessage.authUrl) {
                                var eventProducer = FECRU.OAUTH.getEventProducer(credentialsRequiredMessage.authUrl);
                                eventProducer.authorized(reenableButtonOnCredentialsAcquired);
                                eventProducers.push(eventProducer);
                            }
                        });
                    }
                }
                isSubmittingTime = false;
            };

            $this.attr("disabled", true).blur();
            $toolbar.addClass("disabled");
            $toolbarGroup.addClass("loading");

            // todo fix error handling
            isSubmittingTime = true;
            FECRU.AJAX.ajaxDo(url, params, done, true);
        };

        var hidden = true;

        /* Concerning the JIRA time submit inline hover from the review toolbar */
        var dialogHider = {
            boundToTrigger: false,
            refreshContentDiv: function ($contentDiv) {
                // aui fires off a bunch of these events, we need to track it ourselves
                if (hidden) {
                    hidden = false;
                    var url = CRU.UTIL.jsonUrlBase(review.id()) + '/updateJiraTimeAjax';
                    var params = {"username": review.getLoggedInUser().userName};
                    var done = function (resp) {
                        if (resp.worked) {
                            if (resp.timeSubmitted) {
                                $contentDiv.find("#time-sofar").html("(" + resp.timeSubmitted + " already submitted)");
                            }
                            $contentDiv.find(".submit-time-issue-label").text(resp.issueKey).attr("href", resp.issueUrl);
                            $contentDiv.find("#time-amount").val(resp.timeToSubmit);
                            $contentDiv.find("#time-issue").val(resp.issueKey);
                            var timeComment = $contentDiv.find("#time-comment");
                            if (timeComment.val() === "") {
                                //set comment if unset (e.g. on init)
                                timeComment.val("Review by " + review.getLoggedInUser().displayName);
                            }
                        }
                        $contentDiv.find(".submit-time-spinner").hide();
                    };

                    $contentDiv.find(".submit-time-spinner").show();
                    FECRU.AJAX.ajaxDo(url, params, done, false);
                    $contentDiv.data("dialogHider", dialogHider);
                }
            }
        };

        var contentHandler = function ($contentDiv, trigger, showPopup) {
            AJS.$(".submit-time-template").removeClass("submit-time-template").appendTo($contentDiv).show();
            dialogHider.refreshContentDiv($contentDiv);
            showPopup();
        };

        var options = {
            onHover: true,
            showArrow: true,
            fadeTime: 200,
            hideDelay: null,
            showDelay: 200,
            width: 393,
            offsetX: 0,
            offsetY: 7,
            container: "body",
            useLiveEvents: true,
            cacheContent: true, //we cache contents until the user submits the time logged
            upfrontCallback: function () {
                //provide a hook into the hide function
                var that = this;
                dialogHider.hideDialog = function () {
                    that.hide();
                };
                //refresh some contents on reload
                dialogHider.refreshContentDiv(that.popup.find(".contents"));
            },
            hideCallback: function () {
                hidden = true;
            }
        };

        AJS.InlineDialog(".submit-jira-time", "submit-time-inline-dialog", contentHandler, options);
    });

})();
/*[{!submit_time_js_yf4q51d!}]*/;
/* END /2static/script/cru/review/submit-time.js */
/* START /2static/script/cru/review/nav.js */
/** General review navigation */
CRU.NAV = {};

(function () {

    CRU.NAV.CONST = {
        DESTINATIONS: {
            LAST_ELEMENT: 'last',
            FIRST_ELEMENT: 'first'
        }
    };

    /**
     * Locates the next element (currently frx/comment/defect/diff) to display when navigating using next and previous arrows.
     * Also called for predicting next frxes to load after the initial call.
     * @param opts search options, @see CRU.FRX.goToNextElement()
     * @return {*} { frxId, type='comment'/'comment-unloaded'/'diff'/'frx', nextFrxId }, null if nothing found
     */
    /*eslint-disable complexity, max-depth, eqeqeq*/
    CRU.NAV.findNextElement = function (opts) {
        // WARNING: there is a known issue with this function that it returns
        // same comment element under some circumstances, e.g. when being
        // called with 'previous' direction and starting frx of generalComments.
        // This can lead to infinite loops.
        // See frx-tests.js test for more details.
        var frxIds = review.frxIds();
        frxIds.unshift("generalComments");

        var forwards = opts.destination === 'next' || opts.destination === 'first';
        if (!forwards) {
            frxIds.reverse();
        }

        // start with opts.startingFrxId if it's in the review
        var startingFrxId = opts.startingFrxId;
        var i = AJS.$.inArray(startingFrxId, frxIds);
        if (i === -1) {
            i = 0;
        }

        // for each frx
        for (var len = frxIds.length; i < len; i++) {
            var frxId = frxIds[i];
            var frx = review.frx(frxId);

            // skipping reviewed frxes
            if (frx && (frx.isFiltered() ||
                opts.skipCompleteFrxs && frx.isComplete())) {
                continue;
            }

            // if going forward and, stopping on frxes and this is not the starting one, that's our result
            if (forwards && opts.findFrx && (frxId != startingFrxId)) {
                return {
                    gotoElem: frxId,
                    frxId: frxId,
                    type: 'frx'
                };
            }

            // if searching for comments and  the frx has no comments (or only read comments) skip it
            if (!opts.findFrx && frx && !opts.findDiff && (
                !frx.hasComments() ||
                (opts.findDefect && !opts.findComment && !frx.hasDefects()) ||
                (opts.skipReadComments && !frx.hasUnreadComments()))) {
                continue;
            }

            if (opts.findComment || opts.findDefect || opts.findDiff) {
                var nextFrxId = (i + 1 < frxIds.length ? frxIds[i + 1] : null);
                // we hit an unloaded frx, return with that, and have it loaded
                if (frx && !frx.isLoaded()) {
                    return {
                        frxId: frxId,
                        type: 'comment-unloaded',
                        nextFrxId: nextFrxId
                    };
                }

                var nextDiff;
                if (opts.findDiff) {
                    nextDiff = CRU.DIFF.NAV.findNextDiff(frx, forwards, nextFrxId, opts);

                    // if we're not looking for comments and we have a diff, that's our result
                    if (nextDiff != null && !opts.findDefect && !opts.findComment) {
                        return nextDiff;
                    }
                }

                if (opts.findComment || opts.findDefect) {
                    var nextComment = CRU.COMMENT.NAV.findNextComment(frxId, startingFrxId, forwards, opts, nextFrxId);
                    if (nextComment != null) {
                        if (!opts.findDiff || nextDiff == null) {
                            // if we're not looking for diffs, or don't have a diff in the current frx, the comment is our result
                            return nextComment;
                        } else {
                            // we got both a diff and a comment, pick closest to top/bottom
                            var $nextDiff = AJS.$(nextDiff.gotoElem);
                            var $nextComment = AJS.$('#' + review.comment(nextComment.gotoElem).domId());
                            var diffAfterComment = CRU.DIFF.NAV.diffAfterComment($nextDiff, $nextComment, forwards);
                            if (diffAfterComment) {
                                return nextComment;
                            } else {
                                return nextDiff;
                            }
                        }
                    } else if (opts.findDiff && nextDiff != null) {
                        // we got no comment, but got a diff, return that
                        return nextDiff;
                    }
                }
            }

            // if going backwards, and stopping at frxes, stop at the frx even if we found nothing else
            if (!forwards && opts.findFrx && (frxId != startingFrxId) && !opts.stopIfNothingFound) {
                return {
                    gotoElem: frxId,
                    frxId: frxId,
                    type: 'frx'
                };
            }
        }

        // Nothing found in all the frxes
        return null;
    };
    /*eslint-enable*/

})();
/*[{!nav_js_vpu251a!}]*/;
/* END /2static/script/cru/review/nav.js */
/* START /2static/script/cru/review/comment/comment-ajax.js */
window.CRU = window.CRU || {};
CRU.COMMENT = {};

var commentAjaxController = (function () {
    /*****************
     * PRIVATE STUFF *
     *****************/
    function isEmptyComment(form, nameprefix) {
        var empty = false;
        var newText = form['newText'];

        if (newText && /^\s*$/.test(newText.value)) {
            empty = true;
            AJS.$("#" + nameprefix + "AutosaveMsg").html("Cannot save or post an empty comment.");
            AJS.$(form).removeClass('disabled');
        }

        return empty;
    }

    function progressIssueLinkClass(commentId, from, to) {
        getCommentElements(commentId, 'commentIssueKey_')
            .removeClass('commentIssueKey' + from)
            .addClass('commentIssueKey' + to);
        getCommentElements(commentId, 'commentIssueStatus_')
            .removeClass('commentIssueStatus' + from)
            .addClass('commentIssueStatus' + to);
        if (to === "Linking") {
            getCommentElements(commentId, 'busyCommentIssue').show();
        } else {
            getCommentElements(commentId, 'busyCommentIssue').hide();
        }
    }

    function getCommentElements(commentId, elementSuffix) {
        var comment = review.comment(commentId);
        if (comment.isInline()) {
            return AJS.$('#above' + elementSuffix + commentId +
                ',#inline' + elementSuffix + commentId);
        } else if (comment.frx()) {
            return AJS.$('#revision' + elementSuffix + commentId);
        } else {
            return AJS.$('#general' + elementSuffix + commentId);
        }
    }

    function commentButtonSyncWrapper(callback) {
        return function (resp) {
            if (callback) {
                callback(resp);
            }
            commentator.syncCommentButtons();
        };
    }

    /*****************
     * PUBLIC  STUFF *
     *****************/
    var res = {
        // General comment methods
        publishComment: function (commentId, permaId, done) {
            var url = CRU.UTIL.jsonUrlBase(permaId) + '/publishCommentAjax/';
            var params = {"commentId": commentId};

            var onDone = function (resp) {
                if (done) {
                    done(commentId, resp);
                    // Re-enable child draft post links
                    var children = review.comment(commentId).getReplies();
                    for (var i = 0, len = children.length; i < len; i++) {
                        var child = children[i];
                        if (child.draft()) {
                            AJS.$("#generaldraftPublish" + child.id() + "," +
                                "#revisiondraftPublish" + child.id() + "," +
                                "#inlinedraftPublish" + child.id()).removeClass("disabled");
                        }
                    }
                }
            };
            var onComplete = commentButtonSyncWrapper(onDone);
            FECRU.AJAX.ajaxDo(url, params, onComplete);
            return false;
        },

        addReply: function (permaId, form, draft) {
            var $form = AJS.$(form);
            $form.addClass('disabled');
            $form.find('textarea').blur();
            if (!isEmptyComment(form, "reply")) {

                var done = function (resp) {

                    $form.removeClass('disabled');
                    if (resp.worked) {
                        commentator.insertAjaxReply(resp);
                        commentator.updateCommentCount(resp);
                        var readCommentIds = resp.readCommentIds;
                        for (var i = 0, len = readCommentIds.length; i < len; i++) {
                            var readCommentId = readCommentIds[i];
                            var readComment = review.comment(readCommentId);
                            if (readComment) { // just being defensive
                                commentator.changeCommentStatus(readCommentId, "read", readComment.status());
                            }
                        }
                        CRU.COMMENT.NAV.setCurrentComment(resp.comment.id);

                        var $commentElement = AJS.$('.comment' + resp.comment.id + ' .comment');
                        $commentElement.trigger('comment-reply-added');
                    }
                };
                var onComplete = commentButtonSyncWrapper(done);
                CRU.COMMENT.commentAjaxExecutor.executeAjaxJob({
                    url: CRU.UTIL.jsonUrlBase(permaId) + '/replyAjax/',
                    params: function () {
                        return $form.serialize() + "&draft=" + (draft ? draft : false);
                    },
                    callback: onComplete
                });
            }
            return false;
        },

        addGeneralComment: function (permaId, $form, draft) {
            // todo: need a spinner?
            $form.addClass('disabled');
            $form.find('textarea').blur();
            if (!isEmptyComment($form.get(0), "general")) {

                var done = function (resp) {
                    $form.removeClass('disabled');
                    commentator.insertAjaxGeneralComment(resp); //checks worked
                };
                var onComplete = commentButtonSyncWrapper(done);
                CRU.COMMENT.commentAjaxExecutor.executeAjaxJob({
                    url: CRU.UTIL.jsonUrlBase(permaId) + '/generalCommentAjax/',
                    params: function () {
                        return $form.serialize() + "&draft=" + (draft ? draft : false);
                    },
                    callback: onComplete
                });
            }
            return false;
        },

        addRevisionComment: function (permaId, form, draft, namePrefix) {
            var $form = AJS.$(form);
            if (!isEmptyComment(form, namePrefix)) {
                $form.addClass('disabled');
                $form.find('textarea').blur();
                var done = function (resp) {
                    $form.removeClass('disabled');
                    commentator.insertRevisionComment(resp); //checks worked
                    if (resp.worked) {
                        tetrisCommentController.renderTetrisCommentMarkersForComment(resp.comment.id);
                    }
                };
                var onComplete = commentButtonSyncWrapper(done);
                CRU.COMMENT.commentAjaxExecutor.executeAjaxJob({
                    url: CRU.UTIL.jsonUrlBase(permaId) + '/revisionCommentAjax/',
                    params: function () {
                        return $form.serialize() + "&draft=" + (draft ? draft : false);
                    },
                    callback: onComplete
                });
            }
            return false;
        },

        autoSaveReply: function (permaId, form, done) {
            var url = CRU.UTIL.jsonUrlBase(permaId) + '/replyAjax/';
            var params = AJS.$(form).serialize() + "&draft=true";
            CRU.COMMENT.commentAjaxExecutor.executeAjax(url, params, done, true);
        },

        autoSaveGeneralComment: function (permaId, form, done) {
            var url = CRU.UTIL.jsonUrlBase(permaId) + '/generalCommentAjax/';
            var params = AJS.$(form).serialize() + "&draft=true";
            CRU.COMMENT.commentAjaxExecutor.executeAjax(url, params, done, true);
        },

        autoSaveRevisionComment: function (permaId, form, done) {
            var url = CRU.UTIL.jsonUrlBase(permaId) + '/revisionCommentAjax/';
            var params = AJS.$(form).serialize() + "&draft=true";
            CRU.COMMENT.commentAjaxExecutor.executeAjax(url, params, done, true);
        },

        deleteComment: function (commentId, permaId, done) {
            var url = CRU.UTIL.jsonUrlBase(permaId) + '/deleteCommentAjax/';
            var params = {"commentId": commentId};
            var onComplete = commentButtonSyncWrapper(done);
            FECRU.AJAX.ajaxDo(url, params, onComplete);
            return false;
        },

        // Comment read status
        updateCommentReadStatus: function (commentId, permaId, markAsRead, done) {
            // Prevent simultaneous requests.

            var url = CRU.UTIL.jsonUrlBase(permaId) + '/commentReadStatusAjax/';
            var params = {"commentId": commentId, "markAsRead": markAsRead};
            var onComplete = commentButtonSyncWrapper(done);

            return FECRU.AJAX.ajaxDo(url, params, onComplete);
        },

        markAllCommentsRead: function (updatedComments, permaId, done) {
            if (updatedComments.length > 0) {
                var url = CRU.UTIL.jsonUrlBase(permaId) + '/commentReadStatusAjax/';
                var params = {
                    markAsRead: true,
                    cid: AJS.$.map(updatedComments, function (comment) {
                        return comment.id();
                    })
                };

                var onComplete = commentButtonSyncWrapper(done);
                FECRU.AJAX.ajaxDo(url, params, onComplete);
            }
            return false;
        },

        loadCommentIssueStatuses: function (frxId) {
            var commentIdsWithLinkedIssues = [];
            var comments;
            if (frxId) {
                comments = review.frx(frxId).comments();
            } else {
                comments = review.generalComments();
            }
            AJS.$.each(comments, function () {
                var comment = review.comment(this.id());
                if (comment.issueKey() && comment.issueKey() !== "") {
                    commentIdsWithLinkedIssues.push(comment.id());
                }
            });
            if (commentIdsWithLinkedIssues.length === 0) {
                return;
            }
            var url = CRU.UTIL.jsonUrlBase(permaId) + '/getCommentIssueStatusAjax/';
            var params = {"commentIds": commentIdsWithLinkedIssues};
            var done = function (resp) {
                if (resp.worked) {
                    var issues = resp.issues;
                    for (var i = 0, len = issues.length; i < len; i++) {
                        var issue = issues[i];
                        res.processStatusText(issue.commentId, issue);
                    }
                }
            };
            FECRU.AJAX.ajaxDo(url, params, done);
        },

        resolveIssue: function (commentId) {
            getCommentElements(commentId, 'busyCommentIssue_').show();
            getCommentElements(commentId, 'commentIssueResolve_').hide();

            var url = CRU.UTIL.jsonUrlBase(permaId) + '/resolveCommentIssueAjax/';
            var params = {"commentId": commentId};
            var done = function (resp) {
                res.processStatusText(commentId, resp);
            };
            FECRU.AJAX.ajaxDo(url, params, done);
        },

        processStatusText: function (commentId, resp) {
            var $statusElems = getCommentElements(commentId, 'commentIssueStatus_');
            if (resp.worked) {
                var key = getCommentElements(commentId, 'commentIssueKey_').find('.jira-hover-trigger').children('a').text();
                FECRU.HOVER.invalidateCache(FECRU.HOVER.CACHE_FOREVER, key);
                $statusElems.text(resp.issueStatus);
                review.comment(commentId).setIssueStatus(resp.issueStatus);
            }
            var $statusElem = $statusElems.filter(':first');
            var statusElemText = $statusElem.text().toLowerCase();
            if (statusElemText === 'resolved' || statusElemText === 'closed' || statusElemText === 'error') {
                getCommentElements(commentId, 'commentIssueResolve_').hide();
            } else {
                getCommentElements(commentId, 'commentIssueResolve_').show();
            }
            getCommentElements(commentId, 'busyCommentIssue_').hide();
        },

        linkIssue: function (issueDialog) {
            var summary = issueDialog.find(".create-issue-summary").val();
            var commentId = issueDialog.find(".create-issue-comment-id").val();
            var assignee = issueDialog.find(".create-issue-assignee").val();
            getCommentElements(commentId, 'busyCommentIssue_').show();
            progressIssueLinkClass(commentId, 'Unlinked', 'Linking');
            var url = CRU.UTIL.jsonUrlBase(permaId) + '/linkCommentIssueAjax/';
            var params = {"commentId": commentId, "summary": summary, "assignee": assignee};
            var done = function (resp) {
                if (resp.worked) {
                    var comment = review.comment(commentId);
                    getCommentElements(commentId, 'commentIssueKey_').html(resp.issueHoverHtml);
                    comment.setIssueKey(resp.issueKey);
                    progressIssueLinkClass(commentId, 'Linking', 'Linked');

                    res.processStatusText(commentId, resp);
                } else {
                    progressIssueLinkClass(commentId, 'Linking', 'Unlinked');
                }
                getCommentElements(commentId, 'busyCommentIssue_').hide();
            };
            FECRU.AJAX.ajaxDo(url, params, done);
        }

    };
    return res;
})();
/*[{!comment_ajax_js_35np51i!}]*/;
/* END /2static/script/cru/review/comment/comment-ajax.js */
/* START /2static/script/cru/review/comment/comment-event.js */
(function ($) {
    var $document = $(document);
    // On load
    $document.ready(function () {

        var $panelTarget = $('#panel-target');

        $panelTarget.delegate("input[name='defect']", 'click', function () {
            var $this = $(this);
            var $fields = $this.parent().siblings(".defectFields");
            var isChecked = $this.is(':checked');
            $this.val(isChecked);
            if (isChecked) {
                $fields.show();
            } else {
                $fields.hide();
            }
        });

        $panelTarget.delegate(".commentForm .copyCode", 'click', function () {
            var $lines = $(this).closest('.inlineSource').find('.lineHighlighted .lineContent');

            var text = "{code}";
            for (var i = 0, len = $lines.length; i < len; i++) {
                if (i !== 0) {
                    text += '\n';
                }
                text += $($lines[i]).text();
            }
            text += '{code}';

            var $textarea = $(this).closest('.commentForm').find('.commentTextarea');
            $textarea.val($textarea.val() + '\n' + text);
        });

        var isCommentToggling = false;
        //comment collapse live event
        $panelTarget.delegate(".comment:not(.hover-comment) .author, .comment:not(.hover-comment) .reply-count",
            "click.collapse_comment", function () {
                var comment = $(this).closest(".comment");
                var commentContainer = comment.parent();
                if (isCommentToggling) {
                    return;
                }
                isCommentToggling = true;

                //check whether the edit comment form is being displayed on a comment that is a child of the comment being
                //collapsed, and if it is, stop the collapse - lest we lose the edit
                var commentForm = commentator.getDisplayingReplyForm();
                if (commentForm) {
                    var $commentForm = $(commentForm.getForm());
                    var containsOpenEditForm = $commentForm.closest("#" + commentContainer.attr("id")).length > 0;
                    if (containsOpenEditForm) {
                        $commentForm.find(".autosavemessage").text("please save or cancel before collapsing a comment");
                        commentForm.getTextBox().focus();
                        return;
                    }
                }

                var commentBody = comment.find(".comment-body");
                var excerpt = comment.find(".excerpt");
                var replyContainer = commentContainer.children(".reply-container");
                var height;
                var COLLAPSED_HEIGHT = 60;

                if (commentContainer.hasClass("comment-collapsed")) {
                    commentContainer.addClass('comment-expanding')
                        .removeClass("comment-collapsed");
                    height = commentContainer.data('old-height');
                    commentContainer.height(height);

                    setTimeout(function () {
                        commentContainer.height('auto')
                            .removeClass('comment-expanding');
                        isCommentToggling = false;
                        commentBody.trigger('comment-collapsed');
                    }, 800);

                } else {
                    var count = replyContainer.find(".comment").length;
                    if (count > 0) {
                        var replyCountContainer = excerpt.find(".reply-count");
                        replyCountContainer.html('<span class="aui-badge">' + count + '</span><span class="link">'
                            + (count === 1 ? "reply" : "replies") + ' hidden</span>');
                    }
                    height = commentContainer.height();
                    commentContainer.data('old-height', height)
                        .height(height);
                    var newHeight = COLLAPSED_HEIGHT;

                    setTimeout(function () {
                        commentContainer.height(newHeight);
                        commentContainer.addClass('comment-collapsing');
                        setTimeout(function () {
                            commentContainer.removeClass('comment-collapsing')
                                .addClass("comment-collapsed");
                            isCommentToggling = false;
                            commentBody.trigger('comment-collapsed');
                        }, 800);
                    }, 20);
                }
            });

        $panelTarget.delegate('.hover-comment .comment-permalink', 'click', function () {
            var comment_nav = CRU.COMMENT.NAV;
            var commentId = $(this).attr('href').replace(/[^0-9]+/g, '');
            var scrollToMap = comment_nav.navigateFindComment({commentId: commentId});
            comment_nav.navigateDirectlyToElement({commentId: commentId}, scrollToMap);
        });

        // Click to focus comments and mark as read.
        $panelTarget.delegate('#frxs .frxouter .comment', 'click', function () {
            var commentId = this.id.replace(/(general|revision|inline|above)commentContent/, '');
            if (!$(this).is('.hover-comment')) {
                CRU.COMMENT.NAV.setCurrentComment(commentId, {sticky: true});
            }
        });

        $panelTarget.delegate(".comment a.publishComment:not(.disabled)", "click", function () {
            var comment = CRU.COMMENT.commentFromInnerElement(this);
            commentator.publishComment(comment.id(), permaId);
        });

        $panelTarget.delegate(".comment a.replyToComment", "click", function () {
            var cru = CRU;
            var comment = cru.COMMENT.commentFromInnerElement(this);
            var visiblePos = comment.visiblePosition();
            var id = comment.id();
            var handleId = visiblePos + "replyFormDiv" + id + "Handle";
            var parentId = visiblePos + "replyFormDiv" + id;
            commentator.displayReplyCommentForm(handleId, parentId, comment.id());
            cru.REVIEW.WIKI.resetPreview();
        });

        $panelTarget.delegate(".comment a.editComment", "click", function () {
            var cru = CRU;
            var comment = cru.COMMENT.commentFromInnerElement(this);
            var commentId = comment.id();
            var position = comment.visiblePosition();
            var handleId = position + "commentContent" + commentId;
            var parentId = position + "commentEdit" + commentId;

            var isReply = comment.isReply();
            var $p = $("#" + parentId);
            cru.REVIEW.WIKI.resetPreview();

            if (isReply) {
                commentator.displayReplyCommentForm(handleId, parentId, comment.replyTo().id(), commentId);
            } else {
                var frx = comment.frx();
                if (frx) {
                    var frxId = frx.id();
                    if (comment.isInline()) {
                        commentator.displayRevisionCommentForm(handleId, parentId, frxId, commentId);
                    } else {
                        commentator.displayFileCommentForm(handleId, parentId, frxId, commentId);
                    }
                } else {
                    commentator.displaySimpleCommentForm(handleId, parentId, commentId);
                }
            }
        });

        $panelTarget.delegate(".comment a.deleteComment:not(.disabled)", "click", function () {
            var comment = CRU.COMMENT.commentFromInnerElement(this);
            commentator.deleteComment(comment.id(), permaId);
        });

        $panelTarget.delegate(".comment a.toggleCommentRead", "click", function () {
            var comment = CRU.COMMENT.commentFromInnerElement(this);
            commentator.toggleCommentRead(comment.id(), true);
        });

        $document.delegate(".create-issue-dialog input.create-issue-button", "click", function () {
            var dialog = $(this).closest(".contents");
            commentAjaxController.linkIssue(dialog);
            dialog.data("dialogHider").hideDialog();
        });

        $document.delegate(".create-issue-dialog span.issue-assign-to-me", "click", function () {
            $(this).closest(".contents").find(".create-issue-assignee").val(review.getLoggedInUser().userName);
        });

        $document.delegate(".create-issue-dialog span.close", "click", function () {
            $(this).closest(".contents").data("dialogHider").hideDialog();
        });

        $panelTarget.delegate(".comment a.commentIssueResolveButton", "click", function () {
            var comment = CRU.COMMENT.commentFromInnerElement(this);
            commentAjaxController.resolveIssue(comment.id());
        });

        $panelTarget.delegate("a.comment-skipped", "click", function () {
            var commentId = this.id.replace('comment-skipped', '');
            var comment = review.comment(commentId);

            // Presumably, this should never happen - you can't have a skipped comment which isn't inline
            if (!comment || !comment.frx()) {
                return;
            }

            var done = function () {
                CRU.COMMENT.NAV.scrollDirectlyToComment(comment.domId());
            };

            // show full context for the frx
            CRU.FRX.toggleDiffModeAjax(review.id(), comment.frx().id(), '-1', done);
        });
    });

})(AJS.$);
/*[{!comment_event_js_nqut51j!}]*/;
/* END /2static/script/cru/review/comment/comment-event.js */
/* START /2static/script/cru/review/comment/comment-issue.js */
(function () {

    AJS.$(document).ready(function () {
        var dialogHider = {};

        var contentHandler = function ($contentDiv, trigger, showPopup) {
            var $trigger = AJS.$(trigger);
            var MAX_SUMMARY_LENGTH = 255;
            AJS.$(".create-issue-template").removeClass("create-issue-template").appendTo($contentDiv).show();
            var comment = CRU.COMMENT.commentFromInnerElement($trigger);
            $contentDiv.find(".create-issue-comment-id").val(comment.id());
            var summary = comment.message();
            if (summary && summary.length > MAX_SUMMARY_LENGTH) {
                summary = summary.substr(0, MAX_SUMMARY_LENGTH - 3) + "...";
            }
            $contentDiv.find(".create-issue-summary").val(summary);

            var url = CRU.UTIL.jsonUrlBase(review.id()) + '/assignableUsersForSubtaskAjax/';
            var params = {"commentId": comment.id()};

            var done = function (resp) {
                if (resp.worked) {
                    var assigneeSelect = $contentDiv.find(".create-issue-assignee");
                    assigneeSelect.children(".from-server").remove();
                    var assignees = resp.users;
                    for (var i = 0; i < assignees.length; i++) {
                        var assignee = assignees[i];
                        assigneeSelect.append(AJS.$("<option class='from-server' />")
                            .val(assignee.username)
                            .text(assignee.display));
                    }
                    var assignToMe = $contentDiv.find(".issue-assign-to-me");
                    if (resp.sharedUserBase && review.getLoggedInUser()) {
                        assignToMe.show();
                    } else {
                        assignToMe.hide();
                    }
                }
                $contentDiv.find(".issue-assignee-spinner").hide();
            };

            $contentDiv.find(".issue-assignee-spinner").show();
            FECRU.AJAX.ajaxDo(url, params, done, false);

            $contentDiv.data("dialogHider", dialogHider);
            showPopup();
        };

        var options = {
            onHover: false,
            showArrow: true,
            fadeTime: 200,
            hideDelay: 200,
            showDelay: 200,
            width: 393,
            container: "body",
            useLiveEvents: true,
            cacheContent: false,
            upfrontCallback: function () {
                //provide a hook into the hide function
                var that = this;
                dialogHider.hideDialog = function () {
                    that.hide();
                };
            }
        };

        AJS.InlineDialog(".commentIssueKeyUnlinked", "create-issue-inline-dialog", contentHandler, options);
    });

})();
/*[{!comment_issue_js_foev51l!}]*/;
/* END /2static/script/cru/review/comment/comment-issue.js */
/* START /2static/script/cru/review/comment/comment-form.js */
CRU.COMMENT.FORMS = {};

(function ($) {

    /**
     * CommentForm class
     * Base commentForm class extend for specific forms
     */
    var CommentForm = function (id) {
        var name = id;
        var $form;
        var $textBox;
        this.inited = false;

        this.con = function (id) {
            name = id;
        };

        this._init = function () {
            if (!this.inited) {
                var formSourceHtml = CRU.COMMENT.TEMPLATES[name];
                if (formSourceHtml) {
                    $form = AJS.$(formSourceHtml);
                    this.inited = true;
                }
                $form.on('keydown', 'textarea', function (e) {
                    if ((e.metaKey || e.ctrlKey) && e.keyCode === AJS.keyCode.ENTER) {
                        $form.find('.postButton').trigger('click');
                    }
                })
                return false;
            }
            return true;
        };

        this.init = function () {
            return this._init();
        };

        this.getForm = function (skipInit) {
            if (!skipInit) {
                this.init();
            }
            return $form;
        };

        this.getFormElement = function (name) {
            this.init();
            return $form.find('[name=' + name + ']');
        };

        this.getTextBox = function () {
            if (!$textBox || $textBox.length !== 1) {
                $textBox = this.getFormElement('newText');
            }
            return $textBox;
        };

        this.setTextChangeListener = function (l) {
            this.getTextBox().keyup(l);
        };

        this.getCommentText = function () {
            return this.getTextBox().val();
        };

        this.setDefaultFocus = function () {
            (this.getTextBox()[0]).focus();
        };

        this.clearForm = function () {
            this.resetButtons();
            var clear = function (element) {
                try {
                    var $element = AJS.$(element);
                    var type = $element.attr("type");
                    if (type === "checkbox") {
                        $element.removeAttr("checked");
                        $element.val(false);
                    } else if (type === "button" || type === "submit") {
                        // don't do anything to button's values
                        // (in IE6/7, clearing .value clears the button text)
                        $element.removeProp("disabled"); // but make sure they are enabled
                    } else {
                        $element.val("");
                    }
                } catch (e) {
                    //ignore. happens in safari/konqueror when comment form is cleared when not displayed
                }
            };

            // this.getForm().find('input, select, textarea') fails under
            // Safari 3.2 and jQuery 1.3.2 when the form is not yet in the DOM.
            // See http://dev.jquery.com/ticket/4554
            var $form = this.getForm();

            var i;
            var len;
            var $inputs;

            $inputs = $form.find('input')
                .add($form.find('textarea'))
                .add($form.find('select'));

            for (i = 0, len = $inputs.length; i < len; i++) {
                clear($inputs[i]);
            }
        };

        this.resetButtons = function () {
            this.toggleButtons(true);
            this.getFormElement("saveAsDraft").text("Save as draft");
            this.getFormElement("cancelComment").show();
            this.getFormElement("discardComment").hide();
        };

        this.activateAutosaveButtons = function () {
            this.getFormElement("saveAsDraft").text("Keep as draft");
            this.getFormElement("cancelComment").hide();
            this.getFormElement("discardComment").show();
        };

        this.toggleButtons = function (enable) {
            this.getForm().find("button").each(function () {
                try {
                    this.disabled = !enable;
                } catch (e) {
                    //ignore. happens in safari/konqueror when comment form is cleared when not displayed
                }
            });
        };

        this.hasCommentId = function () {
            var cid = this.getCommentId();
            return cid !== "" && cid !== "-1";
        };

        this.getCommentId = function () {
            return this.getFormElement("commentId").val();
        };

        this.setFormVal = function (name, val) {
            this.init();
            try {
                var $formEl = this.getFormElement(name);
                if ($formEl.attr("type") === "checkbox") {
                    $formEl.prop("checked", val);
                }
                $formEl.val(val);
            } catch (e) {
                //ignore. happens in safari/konqueror when comment form is cleared when not displayed
            }
        };

        this.setFormElementVis = function (name, val) {
            this.init();
            try {
                this.getFormElement(name).css("display", val);
            } catch (e) {
                //ignore. happens in safari/konqueror when comment form is cleared when not displayed
            }
        };

        this.showMetrics = function (prefix, show) {
            var nodeName = prefix + "DefectFields";
            toggleNodeAndImage(nodeName, show, !show, true);
        };
    };

    /**
     * CommentForm class
     * This holds a single revision comment form and controls access to the form as well as providing
     * useful methods
     */
    var RevisionCommentForm = function (n) {
        this.con(n);

        this.setFromLines = function (fromLines) {
            this.setFormVal("fromLineRange", fromLines);
        };

        this.init = function () {
            if (this._init()) {
                return;
            }
            var $form = this.getForm(true);
            var permaId = review.id();

            $form
                .on('click', '.postButton', function () {
                    commentAjaxController.addRevisionComment(permaId, $form, false, 'revision');
                }).on('click', '[name=saveAsDraft]', function () {
                    commentAjaxController.addRevisionComment(permaId, $form, true, 'revision');
                }).on('click', '[name=cancelComment]', function () {
                    commentator.clearRevisionCommentBox();
                }).on('click', '[name=discardComment]', function () {
                    var commentId = $form.find('[name=commentId]').val();
                    commentator.discardRevisionCommentBox(commentId, permaId);
                });
        };

        this.setToLines = function (toLines) {
            this.setFormVal("toLineRange", toLines);
        };

        this.setFrxId = function (id) {
            this.setFormVal("frxId", id);
        };

        this.setFromFrxRevision = function (id) {
            this.setFormVal("fromFrxRevisionId", id);
        };

        this.setToFrxRevision = function (id) {
            this.setFormVal("toFrxRevisionId", id);
        };

        this.clearComment = function () {
            this.clearForm();
            this.showMetrics("revision", false);
            this.setFormElementVis("saveAsDraft", "");
        };

        this.populateFromComment = function (comment) {
            this.setFormVal("newText", comment.message());
            this.setFormVal("commentId", comment.id());
            this.setFormVal("toLineRange", comment.toLineRange());
            this.setFormVal("fromLineRange", comment.fromLineRange());
            this.setFormVal("defect", comment.defect());
            var rcf = this;
            AJS.$.each(comment.metrics(), function () {
                rcf.setFormVal(this.key, this.value);
            });
            this.showMetrics("revision", comment.defect());
            if (!comment.draft()) {
                this.setFormElementVis("saveAsDraft", "none");
            }
        };
    };
    RevisionCommentForm.prototype = new CommentForm();

    CRU.COMMENT.FORMS.RevisionCommentForm = RevisionCommentForm;


    var FileCommentForm = function (n) {
        this.con(n);

        this.setFrxId = function (id) {
            this.setFormVal("frxId", id);
        };

        this.clearComment = function () {
            this.clearForm();
            this.showMetrics("file", false);
            this.setFormElementVis("saveAsDraft", "");
        };


        this.init = function () {
            if (this._init()) {
                return;
            }
            var $form = this.getForm(true);
            var permaId = review.id();

            $form.on('click', '.postButton', function () {
                commentAjaxController.addRevisionComment(permaId, $form, false, 'file');
            }).on('click', '[name=saveAsDraft]', function () {
                commentAjaxController.addRevisionComment(permaId, $form, true, 'file');
            }).on('click', '[name=cancelComment]', function () {
                commentator.clearFileCommentForm();
            }).on('click', '[name=discardComment]', function () {
                var commentId = $form.find('[name=commentId]').val();
                commentator.discardFileCommentBox(commentId, permaId);
            });
        };

        this.populateFromComment = function (comment) {
            this.setFormVal("newText", comment.message());
            this.setFormVal("commentId", comment.id());
            this.setFormVal("defect", comment.defect());
            var rcf = this;
            var metrics = comment.metrics();
            for (var i = 0, len = metrics.length; i < len; i++) {
                var m = metrics[i];
                rcf.setFormVal(m.key, m.value);
            }
            this.showMetrics("file", comment.defect());
            if (!comment.draft()) {
                this.setFormElementVis("saveAsDraft", "none");
            }
        };
    };
    FileCommentForm.prototype = new CommentForm();

    CRU.COMMENT.FORMS.FileCommentForm = FileCommentForm;

    var GeneralCommentForm = function (n) {
        this.con(n);

        this.clearComment = function () {
            this.clearForm();
            this.showMetrics("general", false);
            this.setFormElementVis("saveAsDraft", "");
        };

        this.init = function () {
            if (this._init()) {
                return;
            }
            var $form = this.getForm(true);
            var permaId = review.id();

            $form.on('click', '.postButton', function () {
                commentAjaxController.addGeneralComment(permaId, $form, false);
            }).on('click', '[name=saveAsDraft]', function () {
                commentAjaxController.addGeneralComment(permaId, $form, true);
            }).on('click', '[name=cancelComment]', function () {
                commentator.clearGeneralCommentForm();
            }).on('click', '[name=discardComment]', function () {
                var commentId = $form.find('[name=commentId]').val();
                commentator.discardGeneralCommentForm(commentId, permaId);
            });
        };

        this.populateFromComment = function (comment) {
            this.setFormVal("newText", comment.message());
            this.setFormVal("commentId", comment.id());
            this.setFormVal("defect", comment.defect());
            var gcf = this;
            var metrics = comment.metrics();
            for (var i = 0, len = metrics.length; i < len; i++) {
                var m = metrics[i];
                gcf.setFormVal(m.key, m.value);
            }
            this.showMetrics("general", comment.defect());
            if (!comment.draft()) {
                this.setFormElementVis("saveAsDraft", "none");
            }
        };
    };

    GeneralCommentForm.prototype = new CommentForm();

    CRU.COMMENT.FORMS.GeneralCommentForm = GeneralCommentForm;

    var ReplyCommentForm = function (n) {
        this.con(n);

        this.clearComment = function () {
            this.clearForm();
            this.setFormElementVis("saveAsDraft", "");
        };

        this.init = function () {
            if (this._init()) {
                return;
            }
            var $form = this.getForm(true);
            var permaId = review.id();

            $form.on('click', '.postButton', function () {
                commentAjaxController.addReply(permaId, $form, false);
            }).on('click', '[name=saveAsDraft]', function () {
                commentAjaxController.addReply(permaId, $form, true);
            }).on('click', '[name=cancelComment]', function () {
                commentator.clearReplyCommentForm();
            }).on('click', '[name=discardComment]', function () {
                var commentId = $form.find('[name=commentId]').val();
                commentator.discardReplyCommentForm(commentId, permaId);
            });
        };

        this.setReplyToId = function (replyToId) {
            this.setFormVal("replyToId", replyToId);
        };

        this.populateFromComment = function (comment) {
            this.setFormVal("newText", comment.message());
            this.setFormVal("commentId", comment.id());
            if (!comment.draft()) {
                this.setFormElementVis("saveAsDraft", "none");
            }
        };
    };
    ReplyCommentForm.prototype = new CommentForm();

    CRU.COMMENT.FORMS.ReplyCommentForm = ReplyCommentForm;
    var $commentFormsHolder = null;

    /**
     * This is a CommentForm handler class that looks after inserting/removing a comment form inside a parent element
     * It also manages other elements you wish to hide or unhide while displaying the element
     */
    var CommentFormWrangler = function (commentform, namePrefix, autosaveFuncName) {
        var that = this;
        var $switchElement;
        var $frxPane;
        var cForm = commentform;
        var $insertParent;
        var $insertPoint;
        var insertRow = false;
        var displaying = false;
        var $wrapperDiv;
        var divWidth;
        var inited = false;
        var changeParentDisplay = false;
        var autosaveChecksEnabled = false;
        var lastAutosaveDate = new Date();
        var lastTextChangeDate = new Date();
        var lastAutosaveText = "";

        var TableRow = function (id) {
            var $cell = AJS.$(document.createElement('td'));
            var $row = AJS.$(document.createElement('tr'))
                .attr('id', id)
                .append($cell);

            this.setSpan = function (colSpan) {
                $cell.attr('colSpan', colSpan);
            };

            this.getCell = function () {
                return $cell;
            };

            this.getRow = function () {
                return $row;
            };
        };

        function init() {
            if (!inited) {
                $wrapperDiv = $('<div class="commentForm"></div>');
                $wrapperDiv.append(cForm.getForm());
                cForm.setTextChangeListener(that.autosaveTextChanged);
                inited = true;
            }
        }

        this.getCommentForm = function () {
            init();
            return cForm;
        };

        this.setWidth = function (width) {
            $wrapperDiv.width(width);
            divWidth = width;
        };

        this.unsetWidth = function () {
            $wrapperDiv.width('');
            divWidth = null;
        };

        this.setInsertPoint = function (parent, insertAfter) {
            init();
            $insertParent = AJS.$(parent);
            $insertPoint = AJS.$(insertAfter);
            insertRow = $insertParent.is('TABLE') || ($insertParent.is('TBODY') );
        };


        this.setSwitchElement = function (elementId) {
            init();
            $switchElement = AJS.$("#" + elementId);
        };

        this.isDisplaying = function () {
            if (!inited) {
                return false;
            }
            return displaying;
        };

        this.getParent = function () {
            return $insertParent;
        };

        this.isDisplayingRow = function () {
            if (!inited) {
                return false;
            }
            return insertRow;
        };

        function switchParentOn() {
            if ($insertParent.is(":hidden")) {
                changeParentDisplay = true;
                $insertParent.show();
            } else {
                changeParentDisplay = false;
            }
            $switchElement.hide();
        }

        function switchParentOff() {
            if (changeParentDisplay) {
                $insertParent.hide();
            }
            changeParentDisplay = false;
            $switchElement.show();
        }

        /*
         insert/append the element to the parent and hide all the switch elements
         */
        this.insertAndSwitch = function (opts) {
            init();
            if (!displaying) {
                $wrapperDiv.prependTo($insertParent);
                $wrapperDiv.show();
                switchParentOn();
                displaying = true;

                var $generalCommentContainer = $wrapperDiv.parents('#general-comments-container');
                if (!$generalCommentContainer.length) {
                    commentator.setCommentWidths($wrapperDiv.closest('.comment-list'), true);
                } else {
                    $generalCommentContainer.toggleClass('no-comment',
                        !$generalCommentContainer.find('div.comment:visible').length);
                }
            }
            var $wrapperRow = $wrapperDiv.closest('.comment-row');
            $wrapperRow.removeClass('hidden');
            CRU.UI.ensureElementVisible($wrapperDiv, {offset:55});

            var $generalCommentContainer = $wrapperDiv.closest('#generalCommentForm');
            if ($generalCommentContainer.length) {
                $generalCommentContainer.siblings('.comment-form-placeholder').addClass('hidden');
            }
            $wrapperDiv.trigger('comment-form-added');
        };

        this.getCommentRow = function ($lastRow) {
            // Calculate the span of the row
            var $earlierTds = $lastRow.children();
            var colSpan = 0;
            for (var i = 0, len = $earlierTds.length; i < len; i++) {
                var $td = AJS.$($earlierTds[i]);
                var span = parseInt($td.attr('colspan'), 10);
                if (span) {
                    colSpan += span;
                } else {
                    colSpan++;
                }
            }

            var $wrapperRow = $('<tr class="comment-row"><td><div class="comment-list"></div></td></tr>');
            $wrapperRow.find('td').attr('colspan', colSpan);
            return $wrapperRow;
        };

        this.removeAndSwitch = function (opts) {
            init();
            opts = opts || {};

            if (displaying) {
                var $wrapperRow = $wrapperDiv.closest('.comment-row');
                if (!$commentFormsHolder) {
                    $commentFormsHolder = $('<div id="comment-forms-holder"></div>').appendTo('body');
                }

                var $generalCommentContainer = $wrapperDiv.closest('#generalCommentForm');
                if ($generalCommentContainer.length) {
                    $generalCommentContainer.siblings('.comment-form-placeholder').removeClass('hidden');
                }

                $wrapperDiv.appendTo($commentFormsHolder);
                if (opts.isMoving) {
                    if ($wrapperRow.find('> td > .comment-list > .comment-container').children('.comment:visible').length === 0) {
                        $wrapperRow.addClass('hidden');
                    }
                } else {
                    if ($wrapperRow.find('> td > .comment-list').children().length === 0) {
                        $wrapperRow.remove();
                    }
                    switchParentOff();
                    var $commentWrapperRow = $switchElement.closest('.comment-row');
                    $commentWrapperRow.removeClass('hidden');
                }
                displaying = false;
                $('#frx-pane .frxouter.activeFrx').trigger('comment-form-removed');
            }
        };

        /* remove the element from current insertpoint restoring all current switch elements and
         put it in the new insert point with the new switch and display
         */
        this.exchange = function (parent, insertBefore, newSwitchElementId, withoutCommentList) {
            init(withoutCommentList);
            var requireResetParent = !$insertParent || parent.get(0) !== $insertParent.get(0);
            if (displaying && requireResetParent) {
                this.removeAndSwitch();
            }
            this.setSwitchElement(newSwitchElementId);
            if (requireResetParent) {
                this.setInsertPoint(parent, insertBefore);
            }
            this.insertAndSwitch();
        };

        this.move = function ($parent, insertBefore) {
            this.setInsertPoint($parent, insertBefore);
            this.removeAndSwitch({
                isMoving: true
            });
            this.insertAndSwitch({
                isMoving: true
            });
        };

        this.formOpened = function (isdraft) {
            cForm.resetButtons();
            autosaveChecksEnabled = isdraft;
            AJS.$("#" + namePrefix + "AutosaveMsg").html("");
            if (autosaveChecksEnabled) {
                if (cForm.hasCommentId()) {
                    cForm.activateAutosaveButtons();
                }
                lastAutosaveDate = new Date();
                lastTextChangeDate = new Date();
                lastAutosaveText = cForm.getCommentText();
            }
        };

        this.formClosed = function () {
            autosaveChecksEnabled = false;
        };

        /**
         * Converts a date object to a string in the format of HH:MM [AM|PM]
         * @param d date object to stringify
         */
        var date2TimeOfDay = function (d) {
            var s = "AM";
            var h = d.getHours();
            var m = d.getMinutes();

            if (h === 12) {
                s = "PM";
            } else if (h > 12) {
                s = "PM";
                h = h - 12;
            }
            m = "" + m;
            if (m.length < 2) {
                m = "0" + m;
            }
            return h + ":" + m + " " + s;
        };

        this.autosaveTimerPing = function () {
            if (!autosaveChecksEnabled || CRU.COMMENT.commentAjaxExecutor.isPending() || !that.isDisplaying()) {
                return;
            }

            var now = new Date();
            var sinceLastSave = now.getTime() - lastAutosaveDate.getTime();
            var sinceLastEdit = now.getTime() - lastTextChangeDate.getTime();

            if ((sinceLastSave < 30000) && (sinceLastEdit < 2000)) {
                // don't bother saving if they have edited in the last 2s
                // until 30s passes
                return;
            }

            var currentText = cForm.getCommentText();
            if (currentText === lastAutosaveText) {
                return;
            }

            if (/^\s*$/.test(currentText)) {
                return; // you can't save empty comments at the moment
            }

            lastAutosaveText = currentText;
            lastAutosaveDate = now;

            cForm.toggleButtons(false);

            var done = function (resp) {
                cForm.toggleButtons(true);

                if (resp.worked) {
                    resp.autoSaveAction = true;

                    AJS.$("#" + namePrefix + "AutosaveMsg").text("Autosaved at " + date2TimeOfDay(new Date()));
                    cForm.setFormVal("commentId", resp.comment.id);
                    commentator.createOrUpdateComment(resp);
                    commentator.updateCommentCount(resp);

                    cForm.activateAutosaveButtons();
                } else {
                    AJS.$("#" + namePrefix + "AutosaveMsg").text("problem autosaving");
                }
            };

            var autosaveFunc = eval(autosaveFuncName);
            autosaveFunc(permaId, cForm.getForm(), done); // NB: permaId is a global
            AJS.$("#" + namePrefix + "AutosaveMsg").text("Autosaving...");
        };

        this.autosaveTextChanged = function () {
            if (!autosaveChecksEnabled) {
                return;
            }
            var currentText = cForm.getCommentText();
            if (currentText === lastAutosaveText) {
                return;
            }

            lastTextChangeDate = new Date();

            var $autosaveMsg = AJS.$("#" + namePrefix + "AutosaveMsg");
            var msg = $autosaveMsg.text();
            if (msg !== "" && !/\*$/.test(msg)) {
                // put an astrix at the end when it is unsaved
                $autosaveMsg.text(msg + " *");
            }
            msg = "changed, not saved";
        };
    };

    CRU.COMMENT.FORMS.CommentFormWrangler = CommentFormWrangler;
})(AJS.$);
/*[{!comment_form_js_c5hu51k!}]*/;
/* END /2static/script/cru/review/comment/comment-form.js */
/* START /2static/script/cru/review/comment/commentator.js */
(function ($) {
    CRU.COMMENT = (function () {
        var g_mousedown = false;
        var g_modeSelecting = false;
        var g_currentTable = null;
        var g_mouseDownFirstRow = null;
        var lastSelectedLine = null;
        var firstTimeDisplayingInlineForm = true;
        var frxPaneWidth = null;
        var commentDivPrefixes = ['general', 'revision', 'inline', 'above', 'defect'];
        var statusXhrs = {};

        var commentFormNS = CRU.COMMENT.FORMS;
        var scFormWrangler = new commentFormNS.CommentFormWrangler(new commentFormNS.GeneralCommentForm('simpleCommentForm'), 'general', 'commentAjaxController.autoSaveGeneralComment');
        var rcFormWrangler = new commentFormNS.CommentFormWrangler(new commentFormNS.RevisionCommentForm('revisionCommentForm'), 'revision', 'commentAjaxController.autoSaveRevisionComment');
        var fcFormWrangler = new commentFormNS.CommentFormWrangler(new commentFormNS.FileCommentForm('fileCommentForm'), 'file', 'commentAjaxController.autoSaveRevisionComment');
        var replyFormWrangler = new commentFormNS.CommentFormWrangler(new commentFormNS.ReplyCommentForm('replyCommentForm'), 'reply', 'commentAjaxController.autoSaveReply');

        commentFormNS.CommentFormWrangler.forms = [
            scFormWrangler, rcFormWrangler, fcFormWrangler, replyFormWrangler
        ];

        var highlightedLines = [];
        var editingRCHandleId;

        var selectTR = function (tr, select) {
            var $tr = AJS.$(tr);
            if ($tr.hasClass('commentableLine')) {
                $tr.toggleClass('lineHighlighted', select)
                    .toggleClass('sourceLine', !select);
                if (!select) {
                    $tr.removeClass('hoveringComment');
                }
            }
        };

        var clearSelectedRows = function () {
            g_modeSelecting = false;
            if (g_currentTable) {
                AJS.$(g_currentTable).find("tr.lineHighlighted").each(function () {
                    selectTR(this, false);
                });
            } else {
                AJS.$("tr.lineHighlighted").each(function () {
                    selectTR(this, false);
                });
            }
            rcFormWrangler.getCommentForm().clearComment();
            g_modeSelecting = false;
            g_currentTable = null;
            g_mouseDownFirstRow = null;
            firstTimeDisplayingInlineForm = true;
        };

        /**
         * Convert array of line number into simpler more readable form
         * Example:
         *  [1,2,3] => '1-3'
         *
         * @param {Array.<string>} lines
         * @return {string}
         */
        var convertLinesToRange = function (lines) {
            var ranges = [];
            lines = lines.map(function (line) {
                return +line;
            });

            var rangeStart;
            var rangeEnd;
            for (var i = 0; i < lines.length; i++) {
                rangeStart = lines[i];
                rangeEnd = rangeStart;
                while (lines[i + 1] === lines[i] + 1) {
                    rangeEnd = lines[i + 1];
                    i++;
                }
                ranges.push(rangeStart === rangeEnd ? rangeStart : (rangeStart + '-' + rangeEnd));
            }
            return ranges.join(', ');
        };

        var convertRangeToLines = function (ranges) {
            var lines = [];
            if (!ranges) {
                return lines;
            }
            var range = ranges.split(",");
            for (var i = 0, len = range.length; i < len; i++) {
                var s = range[i].split("-");
                var s0 = s[0];
                if (s.length === 1) {
                    lines.push(parseInt(s0, 10));
                } else {
                    for (var b = 0; b <= (s[1] - s0); b++) {
                        lines.push(parseInt(s0, 10) + b);
                    }
                }
            }
            return lines;
        };

        var displayCommentForm = function (handleId, parentId, commentId, wrangler, exchanger) {
            var parent = AJS.$("#" + parentId);
            //display before setting the new values because safari/konqueror don't let you change the values
            //if not attached to the document unlike IE and FF
            if (exchanger) {
                exchanger();
            } else {
                wrangler.exchange(parent, null, handleId);
            }
            var isDraft = true;
            if (commentId) {
                var comment = review.comment(commentId);
                wrangler.getCommentForm().populateFromComment(comment);
                isDraft = comment.draft();
            } else {
                wrangler.getCommentForm().clearComment();
            }
            wrangler.formOpened(isDraft);
            wrangler.getCommentForm().setDefaultFocus();
        };

        var clearForm = function (wrangler) {
            wrangler.removeAndSwitch();
            wrangler.getCommentForm().clearComment();
        };

        var copyCommentAttributes = function (sourceComment, destinationComment) {
            var author = User.getFromLocalIndexOrCreate(sourceComment.author.id, sourceComment.author);
            destinationComment.setMessage(sourceComment.message)
                .setMessageAsHtml(sourceComment.messageAsHtml)
                .setToLineRange(sourceComment.toLineRange)
                .setFromLineRange(sourceComment.fromLineRange)
                .setGutterLine(sourceComment.gutterLine)
                .setToRevId(sourceComment.toRevId)
                .setFromRevId(sourceComment.fromRevId)
                .setDefect(sourceComment.defect)
                .setDraft(sourceComment.draft)
                .setMetrics(sourceComment.metrics)
                .setIssueKey(sourceComment.issueKey)
                .setStatus(sourceComment.status)
                .setAuthor(author)
                .setDate(new Date(sourceComment.createDate));

        };

        /******************************************************************
         ******************** INLINE COMMENTS *****************************
         ******************************************************************/

        var rowClassMatchFrom = /.*\bfrom(\d+)\b.*/;
        var rowClassMatchTo = /.*\bto(\d+)\b.*/;

        var getInlineCommentContainer = function (lastSelected) {
            var $lastSelected = $(lastSelected);

            var $container;
            if ($lastSelected.next().is('.comment-row')) {
                $container = $lastSelected.next();
            } else {
                $container = $(rcFormWrangler.getCommentRow($lastSelected)).insertAfter($lastSelected);
            }
            return $container.find('> td > .comment-list');
        };

        var checkInlineCommentBox = function ($tableElement, forceFormExchange) {
            if (res.commentLock) {
                return false;
            }
            var toLinesSelected = [];
            var fromLinesSelected = [];
            var lastSelected = null;

            $tableElement.children('tbody').children("tr.lineHighlighted:not(.hoveringComment)").each(function () {
                var className = this.className;
                var fromMatches = className.match(rowClassMatchFrom);
                var toMatches = className.match(rowClassMatchTo);

                if (fromMatches && fromMatches.length > 1) {
                    fromLinesSelected.push(fromMatches[1]);
                }
                if (toMatches && toMatches.length > 1) {
                    toLinesSelected.push(toMatches[1]);
                }
                lastSelected = this;
            });

            var commentForm = rcFormWrangler.getCommentForm();
            if (lastSelected != null) {
                var $table = AJS.$(lastSelected).closest("table");
                var frxId = $table.attr("id").replace("sourceTable", "");
                //must display first before setting values or safari/konqueror bork
                //can't use .is(':hidden') on a form element: it has height & width of 0px, so is always hidden.
                //use .is(':hidden') on its parent (the wrapper div) instead.
                var formHidden = commentForm.getForm().parent().is(":hidden");
                var $container = getInlineCommentContainer(lastSelected);

                if (forceFormExchange || formHidden) {
                    if (formHidden) {
                        rcFormWrangler.exchange($container, lastSelected, null);
                    } else {
                        rcFormWrangler.move($container, lastSelected);
                    }

                }
                //only if displaying for the first time do we want to clear the comment text
                //so that if they click a line after entering text it doesn't clear
                if (firstTimeDisplayingInlineForm) {
                    commentForm.clearComment();
                    commentForm.setDefaultFocus();
                    rcFormWrangler.formOpened(true);
                    firstTimeDisplayingInlineForm = false;
                }
                commentForm.setFromLines(convertLinesToRange(fromLinesSelected));
                commentForm.setToLines(convertLinesToRange(toLinesSelected));
                commentForm.setFrxId(frxId);
                var frx = review.frx(frxId);
                commentForm.setFromFrxRevision(frx.visibleFromRevision());
                commentForm.setToFrxRevision(frx.visibleToRevision());
                if (rcFormWrangler.isDisplayingRow()) {
                    rcFormWrangler.setWidth(getInlineCommentFormWidth());
                } else {
                    rcFormWrangler.unsetWidth();
                }
                lastSelectedLine = lastSelected;
            } else {
                //clean up
                if (commentForm.getTextBox().val() !== '') {
                    var popupDeleteResponse = window.confirm("You've deselected all lines\n\n" +
                        "Delete the comment?\n");
                    if (popupDeleteResponse) {
                        if (commentForm.hasCommentId()) {
                            commentator.deleteComment(commentForm.getCommentId(), permaId);
                        }
                        res.clearRevisionCommentBox();
                    }
                } else {
                    res.clearRevisionCommentBox();
                }
            }
            return false;
        };

        var insertAjaxRevisionComment = function (resp) {
            fcFormWrangler.removeAndSwitch();
            AJS.$('#addFileCommentLink' + fcFormWrangler.getCommentForm().getFormElement('frxId').val()).show();
            if (resp.worked) {
                var commentId = resp.comment.id;
                var containerId = 'revision_comments_frxinner' + resp.frxId;
                var $commentFormPlaceholder = $('#' + containerId).children('.fileCommentForm');
                var $comment = $(resp.commentHtml);
                commentator.replaceOrInsertComment('revision', commentId, $comment,
                    'revision_comments_frxinner' + resp.frxId,
                    {
                        $beforeElem: $commentFormPlaceholder
                    });
            }
        };

        var triggerCommentAddedEvent = function (commentDivId) {
            var $comment = $('#' + commentDivId);
            $comment.trigger('comment-added');
        };

        var triggerEventOnCommentsFrxElement = function (commentId, eventName) {
            var frx = review.comment(commentId).frx();
            var $targetFrx;
            if (frx) {
                $targetFrx = frx.frxOuter();
            } else {
                $targetFrx = $('#generalComments');
            }
            $targetFrx.trigger(eventName);
        };

        /*eslint-disable max-depth*/
        var insertAjaxInlineComment = function (resp) {
            if (resp.worked) {
                res.clearRevisionCommentBox();
                var commentId = resp.comment.id;
                var $oldComment = AJS.$('#inlinecomment' + commentId);
                var isEdit = $oldComment.length === 1;

                var createNewRow = true;

                var $comment = AJS.$(resp.inlineCommentHtml);
                var commentDivId = $comment.attr('id');

                // comment exists, let's update it
                if (isEdit) {
                    if (lastSelectedLine) {
                        var $row = $oldComment.closest("tr");
                        // check to see if the updated comment is on a different last line.
                        var $oldLastLine = $row.prevAll(".sourceLine:first");
                        if ($oldLastLine.length === 1) {
                            var sameLastLine = $oldLastLine[0].className === lastSelectedLine.className;
                            if (sameLastLine) {
                                $oldComment.replaceWith($comment);
                                createNewRow = false;
                            } else {
                                var $commentList = $oldComment.closest('.comment-list');
                                $oldComment.remove();
                                if (!$commentList.children('.comment-container').length) {
                                    $commentList.closest('.comment-row').remove();
                                }
                            }
                        }
                        editingRCHandleId = null;
                    } else {
                        // the parent is the td which holds the contents of the inline comment
                        $oldComment.parent().html($comment);
                        AJS.log("TODO: Check how this gets called");
                    }
                }

                if (createNewRow) {
                    if (lastSelectedLine) {
                        var $container = getInlineCommentContainer(lastSelectedLine);

                        var frx = review.frx(resp.frxId);
                        var colSpan = frx.colspan();
                        $container.prepend($comment);
                    }
                }


                if (isEdit) {
                    // aboveCommentHtml contains the edit div too, so just remove it
                    AJS.$("#abovecommentEdit" + commentId).remove();
                    AJS.$("#abovecomment" + commentId).replaceWith(resp.aboveCommentHtml);
                } else {
                    AJS.$("#inline_comments_frxinner" + resp.frxId).append(resp.aboveCommentHtml);
                }
                res.setCommentWidths('inlinecomment' + commentId, true);
                triggerCommentAddedEvent(commentDivId);
            }
        };
        /*eslint-enable*/

        var leaveCommentUnread = function (commentId) {
            if (canChangeCommentStatus(commentId, 'leaveUnread')) {
                res.updateCommentReadStatus(commentId, permaId, false);
            }
        };

        var canChangeCommentStatus = function (commentId, status) {
            var comment = review.comment(commentId);
            var $comment = AJS.$(res.commentContainerDivs(commentId)).children('.comment');
            return review.commentable() && !($comment.hasClass('readStatusLocked') || comment.status() === status);
        };

        var autosaveTimer = function () {
            try {
                rcFormWrangler.autosaveTimerPing();
                scFormWrangler.autosaveTimerPing();
                fcFormWrangler.autosaveTimerPing();
                replyFormWrangler.autosaveTimerPing();
            } finally {
                setTimeout(autosaveTimer, 10000); // every 10s
            }
        };

        var calculateFrxPaneWidth = function () {
            // Leave room for the scrollbar.
            return AJS.$('#frx-pane').width() - 8;
        };

        var getInlineCommentFormWidth = function () {
            var commentFormIndent = 30;
            var wikiPreviewIconWidth = 22;
            if (review.frxs()) {
                var currentWidth = calculateFrxPaneWidth();
                if (frxPaneWidth !== currentWidth) {
                    frxPaneWidth = currentWidth;
                }
            }
            return frxPaneWidth - commentFormIndent - 21 - wikiPreviewIconWidth;
        };

        var deleteComments = function (midFix, commentId) {
            for (var i = 0, len = commentDivPrefixes.length; i < len; i++) {
                var prefix = commentDivPrefixes[i];
                var comment = AJS.$("#" + prefix + midFix + commentId);
                var $commentParent = comment.parent();
                var $table = comment.closest('table');

                comment.remove();

                // check if the comment parent is a top-level comment,
                // remove the comment row if it is.
                if (!$commentParent.children().length && $commentParent.parent().is('td')) {
                    $commentParent.closest('tr').remove();
                } else if ($commentParent.is('.revision_comments_frxinner')
                    && !$commentParent.children('.comment-container').length) {
                    $commentParent.addClass('hidden');
                }

                triggerEventOnCommentsFrxElement(commentId, 'comment-removed');
            }
            res.clearCommentedLines();
        };

        var updateRevisionSliderCounts = function (comment, totalDelta, unreadDelta) {
            if (comment.isInline()) {
                if (comment.fromRevId()) {
                    updateCommentCountImpl('frxRev', comment.fromRevId(), totalDelta, true);
                    updateUnreadCommentCountImpl('frxRev', comment.fromRevId(), unreadDelta, true);
                }
                if (comment.toRevId() && comment.fromRevId() !== comment.toRevId()) {
                    updateCommentCountImpl('frxRev', comment.toRevId(), totalDelta, true);
                    updateUnreadCommentCountImpl('frxRev', comment.toRevId(), unreadDelta, true);
                }
            }
        };

        var updateFRXCommentCountImpl = function (frxId, commentCount, isDelta) {
            updateCommentCountImpl('frx', frxId, commentCount, isDelta);
            updateCommentCountImpl('frxpath', frxId, commentCount, isDelta);
            var hiddenCount = 0;
            var comments = review.frx(frxId).comments();
            for (var i = 0, len = comments.length; i < len; i++) {
                if (comments[i].isHidden()) {
                    hiddenCount++;
                }
            }
            AJS.$('#frxpathHiddenCommentCount' + frxId).html(hiddenCount === 0 ? '' : '&mdash; ' + hiddenCount + ' hidden')
        };

        var updateFRXUnreadCommentCount = function (frxId, unreadCommentCount, isDelta) {
            updateUnreadCommentCountImpl('frx', frxId, unreadCommentCount, isDelta);
            updateUnreadCommentCountImpl('frxpath', frxId, unreadCommentCount, isDelta);
        };

        // Comment counts
        var updateUnreadCommentCountImpl = function (idPrefix, idSuffix, unreadCommentCount, isDelta) {
            // Don't do complicated stuff if the change is nil
            if (isDelta && unreadCommentCount === 0) {
                return;
            }

            var $commentCount = AJS.$('#' + idPrefix + 'CommentCount' + idSuffix);
            var unreadCount = isDelta ? (parseInt($commentCount.attr('data-unread') || 0, 10) + unreadCommentCount) : unreadCommentCount;

            // different implementation for comment counts in review header

            $commentCount.attr('data-unread', unreadCount > 0 ? unreadCount : 0);
            if (idPrefix === 'frxpath') {
                var $realCommentCount = $commentCount.parent();
                $realCommentCount.find('.count-unread').text(unreadCount);
                $realCommentCount.find('.unreadCommentCount').toggleClass('hidden', unreadCount <= 0)
            } else {
                $commentCount.toggleClass('aui-badge-subtle', unreadCount <= 0);
            }
        };

        var updateCommentCountImpl = function (idPrefix, idSuffix, commentCount, isDelta) {
            // Don't do complicated stuff if the change is nil
            if (isDelta && commentCount === 0) {
                return;
            }
            var $commentCount = AJS.$('#' + idPrefix + 'CommentCount' + idSuffix);
            var currentTotal = parseInt($commentCount.attr('data-count') || 0, 10);
            var newCommentCount = isDelta ? currentTotal + commentCount : commentCount;

            $commentCount.text(newCommentCount)
                .attr('data-count', newCommentCount > 0 ? newCommentCount : 0);
            if (idPrefix === 'frxpath') {
                $commentCount
                    .toggleClass('hidden', newCommentCount <= 0)
                    .parent()
                    .toggleClass('hidden', newCommentCount <= 0);
            } else {
                $commentCount
                    .text(newCommentCount);
            }
        };

        var updateGeneralCommentCount = function (resp) {
            if (resp.worked) {
                var commentCountDelta = resp.generalCommentCountDelta;
                var unreadCommentCountDelta = resp.generalUnreadCommentCountDelta;
                updateCommentCountImpl('general', '', commentCountDelta, true);
                updateUnreadCommentCountImpl('general', '', unreadCommentCountDelta, true);
            }
        };

        var modifyIndicatorDisplay = function (midFix, commentId, value) {
            AJS.$.each(commentator.commentDivPrefixes, function () {
                AJS.$("#" + this + midFix + commentId).css('display', value);
            });
        };

        var removeCommentAction = function (commentId, selector) {
            AJS.$('#' + commentId).find(selector).closest('li').remove();
        }

        var res = {
            showCommentsInline: function () {
                return AJS.$("body").hasClass("show-inline-comments");
            },
            showCommentsAbove: function () {
                return AJS.$("body").hasClass("show-above-comments");
            },
            hideSourceComments: function () {
                return AJS.$("body").hasClass("hide-comments");
            },
            showSource: true,
            commentDivPrefixes: commentDivPrefixes,
            g_pageCompletelyLoaded: false,
            commentLock: false,

            /**
             *
             * @param commentType 'revision' | 'reply' | 'general'
             * @param commentId
             * @param commentHtml the comment html returning from backend
             * @param containerId the id of the container which will hold the comments
             * @param opts : {}
             *  $beforeElem: jquery object -- before which the comment shall be inserted
             */
            replaceOrInsertComment: function (commentType, commentId, commentHtml, containerId, opts) {
                var $oldComment = AJS.$('#' + commentType + 'comment' + commentId);
                if ($oldComment.length > 0) {
                    // commentHtml contains the edit div too, so just remove it
                    var $commentEdit = AJS.$('#' + commentType + 'commentEdit' + commentId);
                    $commentEdit.remove();
                    $oldComment.replaceWith(commentHtml);
                } else {
                    if (commentType === 'general') {
                        $('#general-comments-container .comment-form-placeholder')
                            .before(commentHtml);
                    } else {
                        if (opts.$beforeElem) {
                            opts.$beforeElem.before(commentHtml);
                        } else {
                            $('#' + containerId).prepend(commentHtml);
                        }
                    }
                }
            },

            /******************************************************************
             ******************** HELPER METHODS ******************************
             ******************************************************************/

            showCommentedLines: function (frxId, fromLineRange, toLineRange) {
                highlightedLines = res.getCommentedLines(frxId, fromLineRange, toLineRange);
                AJS.$(highlightedLines).addClass('lineHighlighted hoveringComment');
            },

            clearCommentedLines: function () {
                AJS.$(highlightedLines).removeClass('lineHighlighted hoveringComment');
                highlightedLines = [];
            },

            getHighlightedLines: function () {
                return highlightedLines;
            },

            /******************************************************************
             ******************** COMMON METHODS ******************************
             ******************************************************************/

            checkGeneralCommentsWarning: function (frxId) {
                if (frxId) {
                    if (review.frx(frxId).fileComments().length === 0) {
                        AJS.$('#addFileCommentLink' + frxId).hide();
                    } else {
                        AJS.$('#addFileCommentLink' + frxId).show();
                    }
                }
            },

            changeCommentStatus: function (commentId, newStatus, oldStatus) {
                AJS.$(res.commentContainerDivs(commentId))
                    .children('.comment')
                    .removeClass(oldStatus)
                    .addClass(newStatus);
                review.comment(commentId).setStatus(newStatus);
            },

            displaySimpleCommentForm: function (handleId, parentId, commentId) {
                displayCommentForm(handleId, parentId, commentId, scFormWrangler);
            },

            createOrUpdateComment: function (resp) {
                if (resp.worked) {
                    var commentResp = resp.comment;

                    var comment = review.comment(commentResp.id);
                    if (!comment) {
                        var position = 'general';
                        if (resp.replyToId) {
                            position = review.comment(resp.replyToId).position();
                        } else if (resp.frxId) {
                            if (resp.whole) {
                                position = 'revision';
                            } else {
                                position = 'inline';
                            }
                        }
                        var type = resp.replyToId ? 'reply' : 'comment';
                        var commentType = position + type;

                        comment = new Comment(commentResp.id, commentType);

                        if (resp.replyToId) {
                            var parent = review.comment(resp.replyToId);
                            comment.setReplyTo(parent);
                            parent.addReply(comment);
                        }
                        copyCommentAttributes(commentResp, comment);
                        comment.setReview(review);
                        if (resp.frxId) {
                            var frx = review.frx(resp.frxId);
                            comment.setFrx(frx);
                            frx.addComment(comment);
                        }
                        review.addComment(comment);
                    } else {
                        copyCommentAttributes(commentResp, comment);
                    }

                    if (!resp.frxId && !resp.autoSaveAction) {
                        res.checkGeneralCommentsWarning();
                    }

                    var replyComments = resp.replyComments;
                    if (replyComments) {
                        comment.clearReplies();
                        for (var i = 0, len = replyComments.length; i < len; i++) {
                            var replyComment = replyComments[i];
                            var replyParent = review.comment(replyComment.replyToId);
                            if (replyParent) {
                                replyParent.addReply(commentator.createOrUpdateComment(replyComment));
                            }
                        }
                    }

                    return comment;
                }
            },

            updateCommentCount: function (resp) {
                if (resp && resp.worked) {
                    res.updateTotalCommentCount(resp.totalCommentCountDelta, true);
                    res.updateTotalUnreadCommentCount(resp.totalUnreadCommentCountDelta, true);
                    if (resp.frxId) {
                        res.updateFRXCommentCount(resp);
                    } else {
                        updateGeneralCommentCount(resp);
                    }
                } else if (!resp) {
                    res.updateTotalCommentCount(review.comments().length, false);
                    res.updateTotalUnreadCommentCount(review.unreadComments().length, false);
                    updateCommentCountImpl('general', '', review.generalComments().length, false);
                    updateUnreadCommentCountImpl('general', '', review.unreadGeneralComments().length, false);
                    var frxs = review.frxs();
                    for (var i = 0, len = frxs.length; i < len; i++) {
                        res.reloadFrxCommentCount(frxs[i]);
                    }
                }
            },

            reloadFrxCommentCount: function (frx) {
                var comments = frx.comments();
                updateFRXCommentCountImpl(frx.id(), comments.length, false);
                updateFRXUnreadCommentCount(frx.id(), frx.unreadComments().length, false);
                var frxRevCommentCounts = {};
                var frxRevUnreadCommentCounts = {};
                var j;
                var innerLen;

                for (j = 0, innerLen = comments.length; j < innerLen; j++) {
                    var comment = comments[j];
                    if (comment.isInline()) {
                        var toRevId = comment.toRevId();
                        var toRevCount = frxRevCommentCounts[toRevId];
                        var toRevUnreadCount = frxRevUnreadCommentCounts[toRevId];
                        if (!toRevCount) {
                            toRevCount = 0;
                        }
                        if (!toRevUnreadCount) {
                            toRevUnreadCount = 0;
                        }
                        toRevCount++;
                        if (comment.status() === 'unread' || comment.status() === 'leaveUnread') {
                            toRevUnreadCount++;
                        }
                        frxRevCommentCounts[toRevId] = toRevCount;
                        frxRevUnreadCommentCounts[toRevId] = toRevUnreadCount;

                        var fromRevId = comment.fromRevId();
                        if (fromRevId !== toRevId) {
                            var fromRevCount = frxRevCommentCounts[fromRevId];
                            var fromRevUnreadCount = frxRevUnreadCommentCounts[fromRevId];
                            if (!fromRevCount) {
                                fromRevCount = 0;
                            }
                            if (!fromRevUnreadCount) {
                                fromRevUnreadCount = 0;
                            }
                            fromRevCount++;
                            if (comment.status() === 'unread' || comment.status() === 'leaveUnread') {
                                fromRevUnreadCount++;
                            }
                            frxRevCommentCounts[fromRevId] = fromRevCount;
                            frxRevUnreadCommentCounts[fromRevId] = fromRevUnreadCount;
                        }
                    }
                }
                var frxRevs = frx.frxRevisions();
                for (j = 0, innerLen = frxRevs.length; j < innerLen; j++) {
                    var revId = frxRevs[j];
                    updateCommentCountImpl('frxRev', revId, frxRevCommentCounts[revId] || 0, false);
                    updateUnreadCommentCountImpl('frxRev', revId, frxRevUnreadCommentCounts[revId] || 0, false);
                }
            },

            updateTotalCommentCount: function (count, isDelta) {
                var $total = AJS.$("#totalCommentCount");

                var total = parseInt($total.attr('data-count'), 10);
                if (isDelta) {
                    total += count;
                }
                $total.attr('data-count', total > 0 ? total : 0)
                    .html(total);
            },

            updateTotalUnreadCommentCount: function (count, isDelta) {
                var $total = AJS.$("#totalCommentCount");
                var unread = parseInt($total.attr('data-unread') || 0, 10);
                if (isDelta) {
                    unread += count;
                }
                $total.attr('data-unread', unread > 0 ? unread : 0)
                    .toggleClass('aui-badge-subtle', unread <= 0);
            },

            updateTreeFolderCommentCount: function ($folder, totalDelta, unreadDelta) {
                // Don't do expensive calculations if there are no comments
                if (review.comments().length === 0) {
                    return;
                }
                var $parent = $folder.parent();
                var parentDomId = $parent.attr("id");
                var isFrxDir = parentDomId.indexOf("folder-list-item") === -1;

                var frx;
                var folderId = parentDomId.replace(/^\D+/, "");
                var prefix = isFrxDir ? 'frx' : 'folder';

                // If the folder is open, we need to hide any comment counts
                if ($folder.is(".open")) {
                    // If we are opening a directory which is an frx, then we should use it's comment counts
                    if (isFrxDir) {
                        frx = review.frx(folderId);
                        updateCommentCountImpl(prefix, folderId, frx.comments().length, false);
                        updateUnreadCommentCountImpl(prefix, folderId, frx.unreadComments().length, false);
                    } else {
                        updateCommentCountImpl(prefix, folderId, 0, false);
                        updateUnreadCommentCountImpl(prefix, folderId, 0, false);
                    }
                } else {
                    // If we have explicitly been given the changes in the total/unread, then use them. Otherwise, calculate the
                    // comment counts to be used.
                    if (totalDelta !== undefined && unreadDelta !== undefined) {
                        updateCommentCountImpl(prefix, folderId, totalDelta, true);
                        updateUnreadCommentCountImpl(prefix, folderId, unreadDelta, true);
                    } else {
                        var total = 0;
                        var unread = 0;

                        function addChildCounts($elem) {
                            var $span = $elem.children("span");

                            // add the comment counts for this item (may be unnecessary)
                            var $frxLink = $span.children("a.scroll-to-frx");
                            if ($frxLink.length > 0) {
                                var frxId = $frxLink.attr("id").replace("scroll-to-frx", "");
                                var frx = review.frx(frxId);
                                if (frx) {
                                    total += frx.comments().length;
                                    unread += frx.unreadComments().length;
                                }
                            }

                            var subtrees = $elem.children("ul").children();
                            for (var i = 0, len = subtrees.length; i < len; i++) {
                                addChildCounts(AJS.$(subtrees[i]));
                            }
                        }

                        addChildCounts($parent);

                        updateCommentCountImpl(prefix, folderId, total, false);
                        updateUnreadCommentCountImpl(prefix, folderId, unread, false);
                    }
                }
            },

            discardComment: function (commentId) {
                var comment = review.comment(commentId);
                review.removeComment(comment);
                var $comment = comment.getDomElement()
                var $commentContainer = $comment.closest('.comment-list');
                if (!$comment.closest('.reply-container').length) {
                    if (!$commentContainer.children('.comment:visible').length) {
                        if ($commentContainer.parent().is('td')) {
                            $commentContainer.closest('.comment-row').remove();
                        } else if ($commentContainer.is('.revision_comments_frxinner')) {
                            $commentContainer.addClass('hidden');
                        }
                    }
                }
                $comment.remove();

            },

            discardFileCommentBox: function (commentId, permaId) {
                res.clearFileCommentBox();
                var done = function () {
                    commentator.discardComment(commentId);
                };
                commentAjaxController.deleteComment(commentId, permaId, done);
            },

            discardRevisionCommentBox: function (commentId, permaId) {
                res.clearRevisionCommentBox();
                var done = function () {
                    commentator.discardComment(commentId);
                };
                commentAjaxController.deleteComment(commentId, permaId, done);
            },

            clearFileCommentBox: function () {
                AJS.$('#addFileCommentLink' + fcFormWrangler.getCommentForm().getFormElement('frxId').val()).show();
                clearForm(fcFormWrangler);
                fcFormWrangler.formClosed();
            },

            clearRevisionCommentBox: function () {
                if (rcFormWrangler.isDisplaying()) {
                    //a little inefficient, but effective.
                    rcFormWrangler.removeAndSwitch();
                    clearSelectedRows();
                    if (editingRCHandleId) {
                        AJS.$("#" + editingRCHandleId).show();
                        editingRCHandleId = null;
                    }
                    rcFormWrangler.formClosed();
                }
            },

            /** Returns all occurences of the container divs. Needed due to inline/above. */
            commentContainerDivs: function (commentId) {
                var comment = review.comment(commentId);
                var domId = comment.domId();
                var domIds = ['#' + domId];
                if (/^inline/.test(comment.type())) {
                    domIds.push('#' + domId.replace('inline', 'above'));
                    domIds.push('.comment' + commentId);
                }
                return AJS.$(domIds.join(',')).get();
            },

            replyToComment: function (commentId) {
                var comment = review.comment(commentId);
                if (!comment) {
                    return;
                }
                if (comment.isReply()) {
                    comment = comment.replyTo(); // get the thread parent
                }
                var $commentElem = AJS.$("#" + comment.domId());
                $commentElem.find("div.comment:first div.comment-actions .replyToComment:first").click();
            },

            /******************************************************************
             ******************** COMMENT EDITING *****************************
             ******************************************************************/

            publishComment: function (commentId, permaId) {
                var done = function (commentId, resp) {
                    if (resp.worked) {
                        var commentDomId = review.comment(commentId).domId();
                        removeCommentAction(commentDomId, '> .comment .publishComment');
                        removeCommentAction(commentDomId, '> .comment .draft-indicator');

                        review.comment(commentId).setDraft(false);
                        var commentElement = AJS.$('.comment' + commentId + ' > .comment');
                        commentElement.removeClass('draft');
                        commentElement.find(".replyToComment").removeClass('disabled');
                        commentator.updateCommentCount(resp);

                    }
                };
                commentAjaxController.publishComment(commentId, permaId, done);
                return false;
            },

            /******************************************************************
             ******************** COMMENT DELETING ****************************
             ******************************************************************/

            deleteComment: function (commentId, permaId) {
                var done = function (resp) {
                    if (resp.worked) {
                        var comment = review.comment(commentId);
                        res.removeCommentHtml(comment);
                        if (comment.isInline()) {
                            updateRevisionSliderCounts(comment, -1, 0);
                        }
                        var parent = comment.replyTo(); // will be undefined for root comments
                        review.removeComment(comment);
                        res.updateCommentCount(resp);

                        res.checkGeneralCommentsWarning();

                        if (parent && !parent.hasReplies()) {
                            // Enable the delete link in the parent
                            AJS.$("#" + parent.domId() + " a.deleteComment:first")
                                .removeClass("disabled")
                                .removeAttr("title");
                        }

                        CRU.COMMENT.NAV.visibleCommentsChanged();
                    }
                };
                commentAjaxController.deleteComment(commentId, permaId, done);
                return false;
            },

            removeCommentHtml: function (comment) {
                var commentId = comment.id();
                //turn off all displayed comments with comment ID
                deleteComments("comment", commentId); // TODO optimise
                deleteComments("reply", commentId);   // TODO optimise

                if (comment.isInline()) {
                    tetrisCommentController.deleteTetrisCommentMarkers(commentId);
                }
            },

            /******************************************************************
             ******************** REPLY COMMENTS ******************************
             ******************************************************************/

            insertAjaxReply: function (resp) {
                replyFormWrangler.removeAndSwitch();
                if (resp.worked) {

                    var replyId = resp.comment.id;
                    var idPrefix = resp.type;
                    var isInline = idPrefix === 'inline';

                    var oldComment = review.comment(replyId);

                    // if we are editing, we want to replace the existing replies
                    if (oldComment && oldComment.domIdExists()) {
                        // html contains the edit div too, so just remove it
                        AJS.$("#" + idPrefix + "commentEdit" + replyId).remove();
                        AJS.$("#" + idPrefix + "reply" + replyId).replaceWith(resp.html[idPrefix]);

                        if (isInline) {
                            AJS.$("#abovecommentEdit" + replyId).remove();
                            AJS.$("#abovereply" + replyId).replaceWith(resp.html['above']);
                        }
                    } else {
                        var parentId = resp.replyToId;
                        AJS.$("#" + idPrefix + "replys" + parentId).append(resp.html[idPrefix]);

                        if (isInline) {
                            AJS.$("#abovereplys" + parentId).append(resp.html['above']);
                        }
                    }

                    res.createOrUpdateComment(resp);

                    // Disable the delete link in the parent
                    var parent = review.comment(resp.replyToId);
                    if (parent.hasReplies()) {
                        AJS.$("#" + parent.domId() + " > div.comment a.deleteComment")
                            .addClass("disabled")
                            .attr("title", "You cannot delete this comment as long as it has replies.");
                    }

                    CRU.COMMENT.NAV.visibleCommentsChanged();
                }
            },

            displayReplyCommentForm: function (handleId, parentId, replyToId, commentId) {
                if (replyFormWrangler.isDisplaying() && AJS.$("#" + parentId)[0] === replyFormWrangler.getParent()[0]) {
                    return;//already displaying here so do nothing
                }
                displayCommentForm(handleId, parentId, commentId, replyFormWrangler);
                //replyToId must be set or it ain't a reply
                replyFormWrangler.getCommentForm().setReplyToId(replyToId);

                // Disable the "Post" button for repies on drafts:
                AJS.$("#replyCommentForm .postButton")
                    .prop('disabled', review.comment(replyToId).draft());
            },

            discardReplyCommentForm: function (commentId, permaId) {
                res.clearReplyCommentForm();
                var done = function () {
                    commentator.discardComment(commentId);
                };
                commentAjaxController.deleteComment(commentId, permaId, done);
            },

            clearReplyCommentForm: function () {
                clearForm(replyFormWrangler);
                replyFormWrangler.formClosed();
            },

            /******************************************************************
             ******************** GENERAL COMMENTS ****************************
             ******************************************************************/

            insertAjaxGeneralComment: function (resp) {
                scFormWrangler.removeAndSwitch();
                if (resp.worked) {

                    var commentId = resp.comment.id;
                    var oldComment = review.comment(commentId);
                    res.replaceOrInsertComment('general', commentId, resp.commentHtml, 'general-comments-container');
                    res.createOrUpdateComment(resp);
                    res.updateCommentCount(resp);
                    CRU.COMMENT.NAV.visibleCommentsChanged();
                    triggerCommentAddedEvent(AJS.$(resp.commentHtml).attr('id'));
                }
            },

            discardGeneralCommentForm: function (commentId, permaId) {
                res.clearGeneralCommentForm();
                var done = function () {
                    commentator.discardComment(commentId);
                    res.checkGeneralCommentsWarning();
                };
                commentAjaxController.deleteComment(commentId, permaId, done);
            },

            clearGeneralCommentForm: function () {
                clearForm(scFormWrangler);
                scFormWrangler.formClosed();
                res.checkGeneralCommentsWarning();
            },

            clearFileCommentForm: function () {
                var frxId = fcFormWrangler.getCommentForm().getFormElement('frxId').val();
                AJS.$('#addFileCommentLink' + frxId).show();
                var $fileForm = fcFormWrangler.getCommentForm().getForm();
                var $parent = $fileForm.closest('.comment-list');

                clearForm(fcFormWrangler);
                if (!$parent.children('.comment-container').length) {
                    $parent.addClass('hidden');
                }

                fcFormWrangler.formClosed();
            },

            /******************************************************************
             ******************** REVISION COMMENTS ***************************
             ******************************************************************/

            displayFileCommentForm: function (handleId, parentId, frxId, commentId) {
                AJS.$('#addFileCommentLink' + frxId).hide();

                var $parent = $('#' + parentId);
                if (!$parent.is(':visible')) {
                    $parent.parent().removeClass('hidden');
                }
                displayCommentForm(handleId, parentId, commentId, fcFormWrangler);
                fcFormWrangler.getCommentForm().setFrxId(frxId);

                fcFormWrangler.unsetWidth();
            },

            /**
             * display a comment form as a child of parent with the details in the comment object
             *
             * @param handleId the switch you want to hide while displaying the form
             * @param parentId div/containing block id to display form in
             * @param commentId comment dom id
             */
            displayRevisionCommentForm: function (handleId, parentId, frxId, commentId) {
                clearSelectedRows();

                var comment = review.comment(commentId);
                if (comment) {
                    editingRCHandleId = handleId;
                    var lines = res.getCommentedLines(frxId, comment.fromLineRange(), comment.toLineRange());
                    AJS.$.each(lines, function (i) {
                        var $line = AJS.$(this);
                        if (i === 0) {
                            g_currentTable = $line.parent()[0];
                        }
                        selectTR(this, true);
                        lastSelectedLine = this;
                    });
                }

                var exchanger = function () {
                    var $container = $('#' + handleId).next('.comment-edit-form');
                    rcFormWrangler.exchange($container, lastSelectedLine, handleId);
                };
                displayCommentForm(handleId, parentId, commentId, rcFormWrangler, exchanger);

                var commentForm = rcFormWrangler.getCommentForm();
                commentForm.setFrxId(frxId);

                if (/^inline/.test(parentId)) {
                    var frx = review.frx(frxId);
                    commentForm.setFromFrxRevision(frx.visibleFromRevision());
                    commentForm.setToFrxRevision(frx.visibleToRevision());
                    firstTimeDisplayingInlineForm = false;
                } else {
                    rcFormWrangler.unsetWidth();
                    firstTimeDisplayingInlineForm = true;
                }
            },

            insertRevisionComment: function (resp) {
                if (resp.worked) {
                    if (resp.whole) {
                        insertAjaxRevisionComment(resp);
                    } else {
                        insertAjaxInlineComment(resp);
                    }
                    res.createOrUpdateComment(resp);
                    res.updateCommentCount(resp);
                    CRU.COMMENT.NAV.visibleCommentsChanged();
                }
            },

            /******************************************************************
             ******************** COMMENT READ STATUS *************************
             ******************************************************************/

            toggleCommentRead: function (commentId, force) {
                var comment = review.comment(commentId);
                if (!comment) {
                    return;
                }
                var oldStatus = comment.status();
                if (oldStatus === 'read' || oldStatus === 'unread') {
                    leaveCommentUnread(commentId);
                } else {
                    res.markCommentRead(commentId, force);
                }
            },

            markCommentRead: function (commentId, force) {
                var comment = review.comment(commentId);
                if (!comment || comment.draft()) {
                    return;
                }
                var leaveUnread = comment.status() === 'leaveUnread';
                if ((!leaveUnread || force) && canChangeCommentStatus(commentId, 'read')) {
                    res.updateCommentReadStatus(commentId, permaId, true);
                }
            },

            leaveCommentUnread: function (commentId) {
                if (canChangeCommentStatus(commentId, 'leaveUnread')) {
                    res.updateCommentReadStatus(commentId, permaId, false);
                }
            },

            markAllCommentsRead: function (frxId) {
                var updatedComments = [];
                var i;
                var len;
                var comment;
                var comments;

                if (!frxId) {
                    comments = review.comments();
                } else if (review.frx(frxId)) {
                    comments = review.frx(frxId).comments();
                } else {
                    comments = review.generalComments();
                }

                for (i = 0, len = comments.length; i < len; i++) {
                    comment = comments[i];
                    if (canChangeCommentStatus(comment.id(), 'read')) {
                        updatedComments.push(comment);
                    }
                }

                var done = function (resp) {
                    if (resp.worked) {
                        var _res = res; // store a local variable of the outer scope instance

                        for (i = 0, len = updatedComments.length; i < len; i++) {
                            comment = updatedComments[i];
                            _res.changeCommentStatus(comment.id(), 'read', comment.status());
                        }

                        _res.updateCommentCount();
                    }
                };

                commentAjaxController.markAllCommentsRead(updatedComments, permaId, done);
                return false;
            },

            // Comment read status
            updateCommentReadStatus: function (commentId, permaId, markAsRead) {
                var comment = review.comment(commentId);
                var oldStatus = comment.status();
                var newStatus = markAsRead ? 'read' : 'leaveUnread';
                var statusXhr = statusXhrs[commentId];
                var done = function (resp) {
                    if (resp.worked) {
                        commentator.updateCommentCount(resp);
                        if (comment.isInline()) {
                            commentator.updateFrxRevisionUnreadCommentCount(comment, resp.frxUnreadCommentCountDelta);
                        }
                    }
                };

                if (statusXhr) {
                    statusXhr.abort();
                    delete statusXhrs[commentId];
                }

                res.changeCommentStatus(commentId, newStatus, oldStatus);
                statusXhrs[commentId] = commentAjaxController.updateCommentReadStatus(commentId, permaId, markAsRead, done);

                return false;
            },

            /******************************************************************
             ******************** MISC METHODS    *****************************
             ******************************************************************/

            toggleComments: function (view) {
                AJS.$('.show-comment-container').removeClass('show-comment-container');

                AJS.$("#set-inline-comments, #set-above-comments, #set-hidden-comments").removeClass("selected");
                var $reviewpage = AJS.$("#reviewpage");
                $reviewpage.removeClass("hide-comments").removeClass("show-inline-comments").removeClass("show-above-comments");

                if (view === 'none') {
                    $reviewpage.addClass("hide-comments");
                    AJS.$("#set-hidden-comments").addClass("selected");
                } else if (view === 'inline') {
                    $reviewpage.addClass("show-inline-comments");
                    AJS.$("#set-inline-comments").addClass("selected");
                    if ($reviewpage.hasClass("hide-source")) {
                        AJS.$("#show_source_button").children("a").click();
                    }
                } else {
                    $reviewpage.addClass("show-above-comments");
                    AJS.$('#frxs').trigger('show-above-comments')
                    AJS.$("#set-above-comments").addClass("selected");
                }
                $('#frx-pane').trigger('comment-view-type-changed');
            },

            checkEmptyCommentList: function ($commentList) {
                if ($commentList.children('.comment-container').length) {
                    $commentList.removeClass('hidden');
                } else {
                    $commentList.addClass('hidden');
                }
            },

            convertRangeToLines: convertRangeToLines,

            /**
             * Returns a list of row objects which are to commented
             * line ranges are in the format of "1-3,5-9,14,16-25"
             */
            getCommentedLines: function (frxId, fromLineRange, toLineRange) {
                var commentedLines = [];

                if (!g_modeSelecting && (fromLineRange || toLineRange )) {
                    highlightedLines = [];

                    var $rows = AJS.$('#sourceTable' + frxId).find("tr.sourceLine");

                    // to/from line ranges are sorted
                    var toLines = convertRangeToLines(toLineRange);
                    var fromLines = convertRangeToLines(fromLineRange);

                    var currentToLine = toLines.length > 0 ? toLines.shift() : null;
                    var currentFromLine = fromLines.length > 0 ? fromLines.shift() : null;

                    $rows.each(function () {
                        if (!currentToLine && !currentFromLine) {
                            return false;
                        }

                        var thisFrom = -1;
                        var thisTo = -1;

                        var className = this.className;
                        var fromMatches = className.match(rowClassMatchFrom);
                        var toMatches = className.match(rowClassMatchTo);

                        if (fromMatches && fromMatches.length > 1) {
                            thisFrom = parseInt(fromMatches[1], 10);
                        }
                        if (toMatches && toMatches.length > 1) {
                            thisTo = parseInt(toMatches[1], 10);
                        }

                        var added = false;
                        while (currentToLine && currentToLine <= thisTo) {
                            if (currentToLine === thisTo) {
                                commentedLines.push(this);
                                added = true;
                            }
                            // pop the next to row number from the stack
                            currentToLine = toLines.length > 0 ? toLines.shift() : null;
                        }
                        while (currentFromLine && currentFromLine <= thisFrom) {
                            // Don't add the same row twice
                            if (!added && currentFromLine === thisFrom) {
                                commentedLines.push(this);
                            }
                            // pop the next from row number from the stack
                            currentFromLine = fromLines.length > 0 ? fromLines.shift() : null;
                        }
                    });
                }
                return commentedLines;
            },

            /**
             * set comment widths to the browser window width instead of the width of the overflowing div
             * it is contained in
             * @param commentId (optional) the id of the individual comment you wish to set the width of as used in ajax updated comments
             * @param forceUpdate (optional) force the comment widths to be set even if the width hasn't changed as used in ajax updates of frx's
             */
            setCommentWidths: function (commentId, forceUpdate) {
                var $commentToUpdate;
                if (commentId) {
                    if (commentId.jquery) {
                        $commentToUpdate = commentId;
                    } else {
                        $commentToUpdate = $("#" + commentId).closest('.comment-list');
                    }
                }
                var commentIndent = 27;
                var replyIndent = 57;

                if (review.frxs()) {
                    var currentWidth = calculateFrxPaneWidth();

                    if ($commentToUpdate) {
                        if (frxPaneWidth !== currentWidth || forceUpdate) {
                            frxPaneWidth = currentWidth;
                            $commentToUpdate.width(frxPaneWidth - commentIndent);
                        }
                    } else if (forceUpdate || frxPaneWidth !== currentWidth || !res.g_pageCompletelyLoaded) {
                        frxPaneWidth = currentWidth;
                        AJS.$.each(review.inlineComments().concat(review.fileComments()), function (i, comment) {
                            $('#' + comment.domId()).closest('.comment-list')
                                .width(frxPaneWidth - commentIndent);
                        });
                    }
                }
                return true;
            },

            updateFRXCommentCount: function (resp) {
                if (resp.worked) {
                    var frxId = resp.frxId;
                    var frxCommentCountDelta = resp.frxCommentCountDelta;
                    var frxUnreadCommentCountDelta = resp.frxUnreadCommentCountDelta;
                    updateFRXCommentCountImpl(frxId, frxCommentCountDelta, true);
                    updateFRXUnreadCommentCount(frxId, frxUnreadCommentCountDelta, true);

                    var parentItems = AJS.$("#frx-list-item" + frxId).parents("li.frx-list-item");
                    for (var i = 0, len = parentItems.length; i < len; i++) {
                        var $item = AJS.$(parentItems[i]);
                        var $folder = $item.children(".folder");
                        if ($folder.is(".closed")) {
                            res.updateTreeFolderCommentCount($folder, frxCommentCountDelta, frxUnreadCommentCountDelta);
                        }
                    }

                    if (resp.comment) {
                        var comment = review.comment(resp.comment.id);
                        updateRevisionSliderCounts(comment, frxCommentCountDelta, frxUnreadCommentCountDelta);
                    }
                }
            },

            updateFrxRevisionUnreadCommentCount: function (comment, unreadDelta) {
                updateRevisionSliderCounts(comment, 0, unreadDelta);
            },

            selectLine_down: function ($row, dontActuallySelectThisRow) {
                var $parent = $row.parents(":first");
                var parent = $parent[0];
                g_mousedown = true;
                if (g_currentTable !== parent) {
                    if (g_currentTable) {
                        clearSelectedRows();
                    }
                    g_currentTable = parent;
                }
                g_modeSelecting = !$row.hasClass("lineHighlighted");
                var row = $row.get(0);
                g_mouseDownFirstRow = row;
                if (!dontActuallySelectThisRow) {
                    selectTR(row, g_modeSelecting);
                    return false;
                } else {
                    return true;
                }
            },

            selectLine_over: function ($obj) {
                if (g_mouseDownFirstRow != null) {
                    selectTR(g_mouseDownFirstRow, g_modeSelecting);
                }
                if (g_mousedown) {
                    selectTR($obj.get(0), g_modeSelecting);
                    return false;
                }
                return true;
            },

            selectLine_up: function ($tableElement) {
                checkInlineCommentBox($tableElement, true);
                g_mouseDownFirstRow = null;
                return false;
            },

            commentFromInnerElement: function (button) {
                var id = AJS.$(button).closest(".comment-container")
                    .attr("id")
                    .replace(/^\D*/, "");
                return review.comment(id);
            },

            syncCommentButtons: function () {
                // Sync the comment nav buttons
                var hasUnread = review.unreadComments().length > 0;
                AJS.$("#mark-comments-read-button").toggleClass("disabled", !hasUnread);
                // If we have unread comments, then we obviously have comments...
                var $toolbars = AJS.$("#frxs").find("div.toolbar");
                if (hasUnread) {
                    $toolbars.find(".prev-comment-button, .next-comment-button").removeClass("disabled");
                } else {
                    // otherwise check if we actually have comments
                    var hasComments = review.comments().length > 0;
                    $toolbars.find(".prev-comment-button, .next-comment-button").toggleClass("disabled", !hasComments);
                }
            },

            getDisplayingCommentForm: function () {
                var forms = res.getDisplayingForms();
                if (forms.length > 0) {
                    return forms[0];
                } else {
                    return null;
                }
            },

            getDisplayingForms: function () {
                var forms = [];
                if (scFormWrangler.isDisplaying()) {
                    forms.push(scFormWrangler.getCommentForm());
                }
                if (fcFormWrangler.isDisplaying()) {
                    forms.push(fcFormWrangler.getCommentForm());
                }
                if (rcFormWrangler.isDisplaying()) {
                    forms.push(rcFormWrangler.getCommentForm());
                }
                if (replyFormWrangler.isDisplaying()) {
                    forms.push(replyFormWrangler.getCommentForm());
                }
                return forms;
            },

            getDisplayingReplyForm: function () {
                if (replyFormWrangler.isDisplaying()) {
                    return replyFormWrangler.getCommentForm();
                } else {
                    return null;
                }
            },
            reinitializeScrollTrackerForElement: (function () {
                var selectorFunction = function () {
                    var ids = [];
                    var comments;
                    var comment;
                    var domId;
                    var i;
                    var len;
                    var frxs = review.frxs();
                    var $body = AJS.$("body");
                    var isMultiFrxView = $body.hasClass("multi-frx-view");
                    var hideSourceComments = $body.hasClass("hide-comments");
                    var aboveComments = $body.hasClass("show-above-comments");

                    // Go over general comments when general comments are visible
                    // Since general comments are always at the top, we should use this exclusively if we can
                    if (AJS.$("#generalComments").hasClass("activeFrx")) {
                        comments = review.generalComments();
                        for (i = 0, len = comments.length; i < len; i++) {
                            comment = comments[i];
                            domId = comment.contentDomId();
                            ids.push("#" + domId);
                        }
                    }
                    // Go over frx comments when the frx is visible
                    else {
                        for (i = 0, len = frxs.length; i < len; i++) {
                            var frx = frxs[i];
                            if (!frx.isLoaded() || frx.isFiltered()) {
                                continue;
                            }

                            if (isMultiFrxView && !frx.isExpanded()) {
                                continue;
                            }

                            var $frxElement = AJS.$("#frxouter" + frx.id());
                            if (!$frxElement.hasClass("activeFrx")) {
                                continue;
                            }
                            comments = hideSourceComments ? frx.fileComments() : frx.comments();
                            for (var j = 0, clen = comments.length; j < clen; j++) {
                                comment = comments[j];
                                domId = comment.contentDomId();
                                if (comment.isInline() && aboveComments) {
                                    ids.push("#" + domId.replace('inline', 'above'));
                                } else {
                                    ids.push("#" + domId);
                                }
                            }
                        }
                    }
                    return AJS.$(ids.length > 0 ? ids.join(",") : []);
                };
                var activeFunction = function () {
                    CRU.COMMENT.NAV.setCurrentComment(this.parentNode);
                };
                var scrollTrackers = {};

                return function (element) {
                    var elementId = element.id;
                    if (!scrollTrackers[elementId]) {
                        scrollTrackers[elementId] = CRU.WIDGETS.makeScrollTracker({
                            threshold: 70,  // height of frx header
                            containerId: elementId,
                            selector: selectorFunction,
                            active: activeFunction
                        });
                    }
                    CRU.COMMENT.commentScrollTracker = scrollTrackers[elementId];
                    return scrollTrackers[elementId];
                }
            })(),
            // very nasty thing - but in order to test untestable code we need to do this
            convertLinesToRange: convertLinesToRange,
            // Another 2 ugly assignment - without them we are unable to split commentator definition
            // from initialization and thus get easy unit testing
            onMouseUp: function() {
                g_mousedown = false;
            },
            autosaveTimer: autosaveTimer
        };

        return res;
    })();

    if (!window.commentator) {
        var commentator = window.commentator = CRU.COMMENT;
        window.commentator.commentAjaxExecutor = FECRU.AJAX.createSequentialExecutor();
    }
})(AJS.$);
/*[{!commentator_js_94ay51p!}]*/;
/* END /2static/script/cru/review/comment/commentator.js */
/* START /2static/script/cru/review/comment/commentator-init.js */
(function($, _) {
    var cruComment = CRU.COMMENT;
    $(document).ready(function () {
        $("body.crucible").mouseup(function () {
            cruComment.onMouseUp();
        });

        var $frxs = $('#frxs').on('comment-added comment-removed frx-visible current-frx-loaded show-above-comments',
            _.throttle(function () {
                cruComment.checkEmptyCommentList($frxs.find('.activeFrx .above-comments'));
            }, 250, {
                trailing: true
            }));

        setTimeout(cruComment.autosaveTimer.bind(cruComment), 5000); // 5s after page load

        cruComment.syncCommentButtons();
        cruComment.toggleComments("inline");
    });
})(AJS.$, _);;
/* END /2static/script/cru/review/comment/commentator-init.js */
/* START /2static/script/cru/review/comment/comment-nav.js */
CRU.COMMENT.NAV = (function () {

    var currentCommentId = null;
    var $previouslyHighlightedComment = null;

    function asCommentId(comment) {
        if (comment instanceof AJS.$) {
            comment = comment[0];
        }

        if (!comment) {
            return null;
        } else if (comment.nodeType) {
            return comment.id.replace(/(general|revision|inline|above)(comment|reply)(Content)?/, '');
        } else if (comment instanceof Comment) {
            return comment.id();
        } else if (typeof comment === 'string' ||
            typeof comment === 'number') {
            return comment;
        }
        return null;
    }

    var getCommentDomElements = function (opts, frxId) {
        var inlineComment = /^inlinecomment/;
        var inlineReply = /^inlinereply/;
        if (commentator.showCommentsAbove()) {
            inlineComment = /^abovecomment/;
            inlineReply = /^abovereply/;
        }

        // cache opts values into local variables for faster lookups
        var nextThread = opts.nextThread;

        var comments = frxId ?
            (
                commentator.hideSourceComments() ?
                    review.frx(frxId).fileComments() :
                    review.frx(frxId).comments()
            ) :
            review.generalComments();
        var commentDomIds = []; // List of comment ids to traverse over
        AJS.$.each(comments, function () {
            if (this.frx() && this.frx().isFiltered()) {
                return true;
            }
            var commentDomId = this.domId();
            if (commentator.showCommentsAbove() && /^inline/.test(this.type())) { // if it's an inline comment and they're shown above, change the id
                commentDomId = commentDomId.replace('inline', 'above');
            }

            if (nextThread) {
                if (inlineComment.test(commentDomId) ||
                    /^revisioncomment[0-9]/.test(commentDomId) ||
                    /^generalcomment[0-9]/.test(commentDomId)
                ) {
                    commentDomIds.push("#" + commentDomId);
                }
                // we need to make sure the current reply is also added to the comments
                // so we can find the next comment thread from the reply.
                else if (opts.commentId && opts.commentId == this.id()) { // eslint-disable-line eqeqeq
                    commentDomIds.push("#" + commentDomId);
                }
            }
            else if (inlineComment.test(commentDomId) ||
                inlineReply.test(commentDomId) ||
                /^revisioncomment[0-9]/.test(commentDomId) ||
                /^generalcomment[0-9]/.test(commentDomId) ||
                /^generalreply[0-9]/.test(commentDomId) ||
                /^revisionreply[0-9]/.test(commentDomId)
            ) {
                commentDomIds.push("#" + commentDomId);
            }
        });
        return AJS.$(commentDomIds.length > 0 ? commentDomIds.join(",") : []);
    };

    var scrollDirectlyToCommentImpl = function (destinationCommentId) {
        // ensure destination comment is visible
        var destId = destinationCommentId.replace(/[0-9]+/, '');
        var scrollToCommentId = destinationCommentId.replace(destId, '');
        var destinationComment;
        var $destinationComment;
        if (destId === 'unknownfrx' || destId === 'unknownfrxreply') {
            $destinationComment = AJS.$('#' + review.comment(scrollToCommentId).domId());
            destinationComment = $destinationComment[0];
        } else {
            $destinationComment = AJS.$('#' + destinationCommentId);
            destinationComment = $destinationComment[0];
        }

        //expand comment / comment's parent if it is collapsed, up the tree. Then do the scroll as callback
        CRU.COMMENT.THREAD.expandCommentThread($destinationComment.children("div.comment"), function () {
            var cruFrxNav = CRU.FRX.NAV;
            // scroll to the comment's frx
            var frx;
            if (scrollToCommentId && (frx = review.comment(scrollToCommentId).frx())) {
                cruFrxNav.setCurrentFrx(frx.id(), {
                    scroll: false,
                    changeHash: false
                });
            } else {
                cruFrxNav.setCurrentFrx('generalComments');
            }
            res.scrollToComment(destinationComment);
            window.location.hash = "c" + scrollToCommentId;
        });
    };

    var res = {
        scrollDirectlyToComment: function (destinationCommentId) {
            if (!destinationCommentId) {
                return;
            }
            // ensure destination comment is visible
            var scrollToCommentId = typeof(destinationCommentId) === 'number' ?
                destinationCommentId :
                destinationCommentId.replace(/[^0-9]+/, '');

            var comment = review.comment(scrollToCommentId);
            var frx = comment && comment.frx();

            if ((comment && comment.isHidden()) || (frx && !frx.isLoaded())) {
                var loadOpts;
                loadOpts = {};
                var $sliderRevs = AJS.$(frx.getSliderFrxRevisions());
                var commentFromRevId = comment.fromRevId() ? comment.fromRevId() : comment.toRevId();
                var commentFromRevIndex = $sliderRevs.index(commentFromRevId);
                var visibleToRevIndex = $sliderRevs.index(frx.visibleToRevision());
                if (commentFromRevIndex < visibleToRevIndex) {
                    loadOpts.fromRev = commentFromRevId;
                    loadOpts.toRev = frx.visibleToRevision();
                } else {
                    loadOpts.toRev = comment.toRevId() ? comment.toRevId() : comment.fromRevId();
                    loadOpts.fromRev = frx.visibleFromRevision();
                }

                loadOpts.isForcedReload = true;
                loadOpts.diffMode = CRU.FRX.diffParamsMap(comment.frx().id(), {});

                CRU.FRX.AJAX.prioritisedFrxLoad(frx.id(), function () {
                    scrollDirectlyToCommentImpl(destinationCommentId);
                }, loadOpts);
            } else {
                scrollDirectlyToCommentImpl(destinationCommentId);
            }
        },

        getCurrentCommentDomId: function () {
            if (currentCommentId) {
                var comment = review.comment(currentCommentId);
                if (comment) {
                    if (comment.isInline() && commentator.showCommentsAbove()) {
                        return comment.domId().replace('inline', 'above');
                    } else {
                        return comment.domId();
                    }
                }
                return null;
            } else {
                return null;
            }
        },

        getCurrentCommentContentDomId: function () {
            if (currentCommentId) {
                var comment = review.comment(currentCommentId);
                // The current comment can be deleted
                if (!comment) {
                    return null;
                } else if (comment.isInline() && commentator.showCommentsAbove()) {
                    return comment.contentDomId().replace('inline', 'above');
                } else {
                    return comment.contentDomId();
                }
            } else {
                return null;
            }
        },

        setCurrentComment: function (comment, options) {
            var commentId = asCommentId(comment);
            this.setCurrentCommentById(commentId, options);
        },

        setCurrentCommentById: function (commentId, options) {
            options = AJS.$.extend({sticky: false}, options);
            var scrollTracker = CRU.COMMENT.commentScrollTracker;
            if (currentCommentId !== commentId) {
                // Lookup the previous current comment in case it was deleted.
                if (review.comment(currentCommentId)) {
                    AJS.$('#' + res.getCurrentCommentContentDomId()).removeClass("current_comment");
                }
                currentCommentId = commentId;
                if (commentId) {
                    var $commentContent = AJS.$('#' + res.getCurrentCommentContentDomId())
                        .addClass("current_comment");
                    commentator.markCommentRead(commentId);
                    if (scrollTracker) {
                        scrollTracker.setCurrentElement($commentContent[0]);
                        if (options.sticky) {
                            scrollTracker.makeCurrentElementSticky();
                        }
                    }
                }
            }
        },

        visibleCommentsChanged: function () {
            var scrollTracker = CRU.COMMENT.commentScrollTracker;
            if (scrollTracker) {
                scrollTracker.rescan();
            } else {
                var frxId = CRU.FRX.NAV.getCurrentFrxId();
                var $commentElems = getCommentDomElements({}, frxId === 'generalComments' ? null : frxId);
                if ($commentElems.length > 0) {
                    // Lookup the previous current comment in case it was deleted.
                    if (review.comment(currentCommentId)) {
                        var $currentComment = AJS.$('#' + res.getCurrentCommentContentDomId());
                        if (AJS.$.inArray($currentComment[0], $commentElems.get()) < 0) {
                            res.setCurrentComment($commentElems[0]);
                        }
                    } else {
                        res.setCurrentComment($commentElems[0]);
                    }
                } else {
                    res.setCurrentComment(null);
                }
            }
        },

        scrollToComment: function (commentHandle) {
            var comment = review.comment(asCommentId(commentHandle));
            if (comment) {
                var scrollTracker = CRU.COMMENT.commentScrollTracker;
                var ui = CRU.UI;
                var $comment;

                scrollTracker && scrollTracker.ignoreNextScroll();
                $comment = AJS.$('#' + comment.contentDomId());
                $comment.closest('.comment-container').addClass('show-comment-container');

                if ($comment.length === 1) {
                    ui.scrollToElement($comment[0], {
                        offset: 55
                    });
                }
                res.setCurrentComment(comment.id());

                if ($previouslyHighlightedComment) {
                    $previouslyHighlightedComment.stop(true, true);
                }

                ui.highlightElements($comment, 'with-delay');
                $previouslyHighlightedComment = $comment;
            }
        },

        checkCommentAnchor: function () {
            if (/^#c/.test(window.location.hash)) {
                var commentId = res.commentIdFromAnchor(window.location.hash.replace(/^#/, ''));
                var comment = review.comment(commentId);
                var frxId = review.getCommentFrxId(commentId);

                //navigate to frx first to show frx loading spinner
                if (review.frx(frxId)) {
                    CRU.FRX.NAV.setCurrentFrx(frxId, {
                        initialScroll: false,
                        scroll: false,
                        changeHash: false
                    });
                }

                //then navigate to comment
                var isInlineButNotLoaded = !comment && frxId && !review.frx(frxId).isLoaded();
                if (comment || isInlineButNotLoaded) {
                    var scrollToMap = res.navigateFindComment({commentId: commentId});
                    res.navigateDirectlyToElement({commentId: commentId}, scrollToMap);
                    return scrollToMap.frxId || -1; // -1 for general comment
                } else {
                    window.location.hash = '';
                    CRU.FRX.NAV.setCurrentFrx('generalComments');
                }
            }
            return null;
        },

        nextComment: function (current) {
            current = current || res.getCurrentCommentDomId();
            var opts = {destination: 'next'};
            res.navigateToComment(opts);
        },

        prevComment: function (current) {
            current = current || res.getCurrentCommentDomId();
            var opts = {destination: 'previous'};
            res.navigateToComment(opts);
        },

        nextCommentThread: function (current) {
            current = current || res.getCurrentCommentDomId();
            var opts = {destination: 'next', nextThread: true};
            res.navigateToComment(opts);
        },

        previousCommentThread: function (current) {
            current = current || res.getCurrentCommentDomId();
            var opts = {destination: 'previous', nextThread: true};
            res.navigateToComment(opts);
        },

        /**
         * @param {String} opts.destination location to scroll to - may be <tt>first</tt>, <tt>last</tt>, <tt>previous</tt> or <tt>next</tt>.
         * @param {String} opts.commentId the id of the comment to scroll to. This value overrides the <tt>opts.destination</tt> is <tt>first</tt> and <tt>last</tt>.
         * @param {Boolean} opts.skipReadComments if true, comments which have been marked as read will be passed over and ignored.
         * @param {Boolean} opts.nextThread if true, comment replies will be passed over and ignored.
         * @return the frxId of the frx of the comment if it has one
         */

        navigateToComment: function (opts) {
            var $elementWithSpinner;
            if (opts.destination === 'first' || opts.destination === 'next') {
                $elementWithSpinner = AJS.$('#next-element-link');
            } else {
                $elementWithSpinner = AJS.$('#prev-element-link');
            }
            res.navigateDirectlyToElement(opts, res.navigateFindComment(opts), $elementWithSpinner);
        },

        navigateDirectlyToElementInner: function (opts, scrollToMap, scrollToCommentDomId, $elementWithSpinner) {
            if (scrollToCommentDomId) {
                res.scrollDirectlyToComment(scrollToCommentDomId);
            } else {
                opts.startingFrxId = scrollToMap.frxId;
                opts.startingCommentDomId = null;
                var nextElementMap = CRU.NAV.findNextElement(opts);
                if (nextElementMap && nextElementMap.type === 'comment-unloaded') {
                    // if we landed on another unloaded frx, the navigation is requeued here
                    res.navigateDirectlyToElement(opts, nextElementMap, $elementWithSpinner);
                    return;
                }
                if (nextElementMap && nextElementMap.type === 'frx') {
                    CRU.FRX.scrollFrxPane(nextElementMap.frxId);
                    return;
                }
                if (nextElementMap && nextElementMap.type === 'diff') {
                    CRU.DIFF.NAV.gotoDiff(nextElementMap)
                    return;
                }
                if (!nextElementMap || nextElementMap.type !== 'comment') {
                    AJS.log('no comment found in frx ' + scrollToMap.frxId + ' with ' + opts);
                    return;
                }
                var destCommentId = nextElementMap.gotoElem;
                var destCommentModel = review.comment(destCommentId);
                var destinationComment = AJS.$('#' + destCommentModel.visibleDomId()).get(0);
                if (!destinationComment || !destinationComment.id) {
                    AJS.log('no comment found in frx ' + scrollToMap.frxId + ' with ' + opts);
                    return;
                }
                res.scrollDirectlyToComment(destinationComment.id);
            }
        },

        navigateDirectlyToElement: function (opts, scrollToMap, $elementWithSpinner) {
            if (scrollToMap.type === 'frx') {
                CRU.FRX.scrollFrxPane(scrollToMap.frxId);
            }
            var scrollToComment = review.comment(scrollToMap.gotoElem);
            var scrollToCommentDomId = scrollToComment ? scrollToComment.visibleDomId() : null;
            if (!scrollToMap.frxId) {
                res.scrollDirectlyToComment(scrollToCommentDomId);
            } else {
                var frx = review.frx(scrollToMap.frxId);
                if (frx.isLoaded()) {
                    res.navigateDirectlyToElementInner(opts, scrollToMap, scrollToCommentDomId, $elementWithSpinner);
                } else {
                    //load frx here
                    if ($elementWithSpinner) {
                        $elementWithSpinner.find('span').addClass('spinner');
                    }
                    var onDone = function () {
                        if ($elementWithSpinner) {
                            $elementWithSpinner.find('span').removeClass('spinner');
                        }
                        res.navigateDirectlyToElementInner(opts, scrollToMap, scrollToCommentDomId, $elementWithSpinner);
                    };
                    CRU.FRX.AJAX.prioritisedFrxLoad(frx.id(), onDone);
                }
            }
        },

        /*eslint-disable complexity*/
        findNextComment: function (frxId, startingFrxId, forwards, opts, nextFrxId) {
            var comments;
            var frx = review.frx(frxId);
            if (frxId === "generalComments") {
                comments = review.domOrderedGeneralComments();
            } else {
                comments = frx.domOrderedComments();
            }
            if (!forwards) {
                comments.reverse();
            }

            var j = 0;
            if (frxId === startingFrxId) {
                var startingCommentDomId = opts.startingCommentDomId;
                var startingComment = startingCommentDomId ? review.comment(startingCommentDomId.replace(/^\D*/, "")) : null;
                if (startingCommentDomId) {
                    var $startingComment = AJS.$('#' + startingCommentDomId);
                    j = AJS.$.inArray(startingComment, comments);
                    if (j === -1 ||
                        (forwards && $startingComment.filter(':below-the-fold(5, frx-pane)').length === 0) ||
                        (!forwards && $startingComment.filter(':above-the-top(5, frx-pane)').length === 0)) {
                        j++;
                    }
                } else {
                    // if the previous item we went to was a diff, try to find the next comment from it
                    var currentDiffId = CRU.DIFF.NAV.getCurrentDiffId(frxId);
                    if (currentDiffId != null) {
                        var $diff = CRU.DIFF.NAV.getDiffs(frx).eq(currentDiffId);
                        while ($diff && comments[j] && comments[j].domId() && CRU.DIFF.NAV.diffAfterComment($diff, frx.frxInner().find('#' + comments[j].domId()), forwards)) {
                            j++;
                        }
                    }
                }
            }

            for (var jlen = comments.length; j < jlen; j++) {
                var comment = comments[j];

                if ((opts.findDefect && !opts.findComment) && !comment.defect()) {
                    continue;
                }
                if (opts.skipReadComments && comment.status() === 'read') {
                    continue;
                }
                if (opts.nextThread && comment.isReply()) {
                    continue;
                }
                return {
                    gotoElem: comment.id(),
                    frxId: comment.frx() ? comment.frx().id() : null,
                    type: 'comment',
                    nextFrxId: nextFrxId
                };
            }
        },
        /*eslint-enable*/

        navigateFindComment: function (opts) {
            if (opts.commentId) {
                var comment = review.comment(opts.commentId);
                if (comment) {
                    return {
                        gotoElem: comment.id(),
                        frxId: comment.frx() ? comment.frx().id() : null
                    };
                }
            }

            opts.findComment = true;
            if (opts.destination !== 'first' && opts.destination !== 'last') {
                opts.startingFrxId = CRU.FRX.NAV.getCurrentFrxId();
                opts.startingCommentDomId = res.getCurrentCommentDomId();
            }

            var nextElementMap = CRU.NAV.findNextElement(opts);
            return nextElementMap ? nextElementMap : {};
        },

        // TODO Deprecate, everything should be using the Comment Object
        commentIdFromAnchor: function (commentId) {
            return commentId.replace(/^\D*/, "");
        },

        commentIdFromDomId: function (commentDomId) {
            return commentDomId.replace(/^\D*(\d+)$/, '$1');
        }
    };

    return res;
})();
/*[{!comment_nav_js_ezf451m!}]*/;
/* END /2static/script/cru/review/comment/comment-nav.js */
/* START /2static/script/cru/review/comment/comment-tetris.js */
//TODO Arguments should be review-model objects, not ids.
var tetrisCommentController = (function () {

    var createAndShowHoverComment = function ($cell, $row) {
        var $hovercommentWrapper = $row.data("hoverCommentWrapper");
        if (!$hovercommentWrapper || $hovercommentWrapper.length === 0) {
            $hovercommentWrapper = AJS.$('<div>').addClass('hovercommentWrapper').hide();
            $hovercommentWrapper.hover(function () {
                openDropDown($hovercommentWrapper);
            }, function () {
                closeDropDown();
            });
            $row.data("hoverCommentWrapper", $hovercommentWrapper);
        }

        //only show the hover for comments where this is its first line
        var cellCommentArray = $row.data("tetrisCellVisibleFirstCount");
        if (!cellCommentArray) {
            cellCommentArray = $row.data("tetrisCellInvisibleCommentCount");
        }

        AJS.$.each(cellCommentArray, function () {
            //copy the above comment and make it a hover comment
            var $comment = AJS.$('#hovercomment' + this);
            if ($comment.length === 0) {
                $comment = AJS.$('#abovecomment' + this).clone().attr('id', 'hovercomment' + this);
                //remove comment buttons (edit, delete, etc)
                $comment.find('td.commentButton').replaceWith('<td>&nbsp;</td>');
                $comment.find('td.commentIssueKeyUnlinked').replaceWith('<td>&nbsp;</td>');
                //remove replyFormDivs
                $comment.find('#abovereplyFormDiv' + this).remove();
            }
            var $replyContainers = $comment.children(".reply-container").children(".comment-container");
            for (var i = 0, len = $replyContainers.length; i < len; i++) {
                var replyContainer = AJS.$($replyContainers[i]);
                var countReplies = replyContainer.find(".reply-container .comment").length;
                if (countReplies > 0) {
                    var excerpt = replyContainer.children('.comment').find(".excerpt");
                    var replyCountContainer = excerpt.find(".reply-count");
                    replyCountContainer.text(" ... " + countReplies + " " + (countReplies === 1 ? "reply" : "replies") + " hidden");
                }
            }

            $hovercommentWrapper.append($comment);
            $comment.find('.comment').addClass('hover-comment');
        });

        $cell.append($hovercommentWrapper);
        openDropDown($hovercommentWrapper);
    };

    var addElementToSetData = function ($o, name, element) {
        var array = $o.data(name);
        if (!array) {
            array = [];
        }
        if (AJS.$.inArray(element, array) === -1) {
            array.push(element);
        }
        $o.data(name, array);
    };

    var removeElementFromSetData = function ($o, name, element) {
        var array = $o.data(name);
        if (array) {
            var index = AJS.$.inArray(element, array);
            if (index >= 0) {
                array.splice(index, 1);
            }
        }
        $o.data(name, array);
    };

    var cleanupEmptyTetrisCell = function (array, $row, className, comment) {
        //if there are no more comments in this cell
        if (!array || array.length === 0) {
            var $cell = $row.children(".tetrisColumn");
            $cell.removeClass(className).removeClass(comment.commentColor()).unbind();
        }
        var hoverCommentWrapper = $row.data("hoverCommentWrapper");
        if (hoverCommentWrapper) {
            hoverCommentWrapper.remove();
        }
        $row.removeData("hoverCommentWrapper");

        if (className === 'tetrisCommentHidden') {
            $row.children(".tetrisColumn").children('.tetrisCommentHidden').remove();
        }
    };

    var res = {
        /**
         * Renders the comment markers for all comments in the specified FRX.
         */
        renderTetrisCommentMarkersForFrx: function (frxId) {
            var frxComments = review.frx(frxId).comments();
            AJS.$.each(frxComments, function () {
                if (this.isInline()) {
                    res.renderTetrisCommentMarkersForComment(this.id());
                }
            });
        },

        /**
         * given the comment id, return a jquery object of the first row that the comment is on.
         * @param commentId
         */
        getFirstCommentedLine: function (commentId) {
            var comment = review.comment(commentId);
            if (!comment) {
                return;
            }
            var frxId = comment.frx().id();
            var toLineNum = comment.toLineRange().split(',')[0].split('-')[0];
            var fromLineNum = comment.fromLineRange().split(',')[0].split('-')[0];
            var $srcTable = AJS.$('#sourceTable' + frxId);
            var $toRow = $srcTable.find('.to' + toLineNum);
            var $fromRow = $srcTable.find('.from' + fromLineNum);
            var $firstLine;
            if ($fromRow.length === 0) { //no from, use to
                $firstLine = $toRow;
            } else if ($toRow.length === 0) { //no to, use from
                $firstLine = $fromRow;
            } else {
                var allRows = $toRow.parent().children();
                if (allRows.index($toRow) < allRows.index($fromRow)) {
                    $firstLine = $toRow;
                } else {
                    $firstLine = $fromRow;
                }
            }
            return $firstLine;
        },

        /**
         * Renders the comment markers for the given comment.
         * TODO: commentator.getCommentedLines method runs in O(n) where n == frx line count. We _MUST_ improve this.
         */
        renderTetrisCommentMarkersForComment: function (commentId) {
            if (!commentId) {
                return;
            }
            var comment = review.comment(commentId);
            var frxId = comment.frx().id();
            var fromLines = [];
            var toLines = [];
            var allLines;
            var className = "tetrisCommentVisible";
            var cellCounterName = "tetrisCellVisibleFirstCount";
            var $firstLine;
            if (comment.isHidden()) {
                toLines = commentator.getCommentedLines(frxId, "", comment.gutterLine());
                if (toLines.length === 0) {
                    toLines.push(AJS.$('#' + frxId + '_last_line').attr('id', frxId + '_last_line')[0]);
                }
                className = "tetrisCommentHidden";
                cellCounterName = "tetrisCellInvisibleCommentCount";
                allLines = fromLines.concat(toLines);
            } else {
                //allLines = getAllCommentLines(comment, frxId);
                $firstLine = res.getFirstCommentedLine(commentId);
                $firstLine.find('.tetrisColumn').addClass('firstTetrisBlock');
                allLines = $firstLine;
                addElementToSetData($firstLine, cellCounterName, commentId);
            }
            var updateCellCounters = function (lines) {
                AJS.$(lines).each(function () {
                    var $row = AJS.$(this);
                    addElementToSetData($row, cellCounterName, commentId);
                    var $cell = $row.children(".tetrisColumn");
                    $cell.addClass(className).unbind();
                    //if it is a 'first' cell or it is a hidden comment, show hover
                    if ($cell.hasClass('firstTetrisBlock') || className === 'tetrisCommentHidden') {
                        var onMouseover = function () {
                            createAndShowHoverComment($cell, $row);
                        };
                        var onMouseout = function () {
                            closeDropDown();
                        };
                        $cell.hover(onMouseover, onMouseout);
                        if (className === 'tetrisCommentHidden') {
                            if ($cell.find('span').length !== 1) {
                                AJS.$('<span>').html('&nbsp;').addClass(className).appendTo($cell);
                            }
                        } else {
                            $cell.addClass(comment.commentColor());
                        }
                    }
                });
            };
            updateCellCounters(allLines);
        },

        deleteTetrisCommentMarkers: function (commentId) {
            var comment = review.comment(commentId);
            if (!comment) {
                return;
            }
            var frxId = comment.frx().id();
            var fromLines = [];
            var toLines = [];
            var allLines;
            var className = "tetrisCommentVisible";
            var cellCounterName = "tetrisCellVisibleFirstCount";
            if (comment.isHidden()) {
                toLines = commentator.getCommentedLines(frxId, "", comment.gutterLine());
                if (toLines.length === 0) {
                    toLines.push(AJS.$('#' + frxId + '_last_line').attr('id', frxId + '_last_line')[0]);
                }
                className = "tetrisCommentHidden";
                cellCounterName = "tetrisCellInvisibleCommentCount";
                allLines = fromLines.concat(toLines);
            } else {
                var $firstLine = res.getFirstCommentedLine(commentId);
                allLines = $firstLine;
                if ($firstLine.data(cellCounterName)) {
                    removeElementFromSetData($firstLine, cellCounterName, commentId)
                    cleanupEmptyTetrisCell($firstLine.data(cellCounterName), $firstLine, className, comment);
                }
            }
            var updateCellCounters = function (lines) {
                AJS.$.each(lines, function () {
                    var $row = AJS.$(this);
                    removeElementFromSetData($row, cellCounterName, commentId)
                    cleanupEmptyTetrisCell($row.data(cellCounterName), $row, className, comment);
                });
            };
            updateCellCounters(allLines);
        }
    };
    return res;
})();
/*[{!comment_tetris_js_x1zb51n!}]*/;
/* END /2static/script/cru/review/comment/comment-tetris.js */
/* START /2static/script/cru/review/comment/comment-thread.js */
(function ($) {
    var delay = "normal";
    var type = "swing";
    window.CRU = window.CRU || {};
    CRU.COMMENT = CRU.COMMENT || {};
    CRU.COMMENT.THREAD = CRU.COMMENT.THREAD || {
            expandCommentThread: function ($comment, afterExpandCallback) {
                //get the chain of collapsed comments, and open each one of them up.
                var collapsed = $comment.parents(".comment-collapsed");
                collapsed.each(function () {
                    $(this)
                        .height('auto')
                        .removeClass('comment-collapsed');
                });
                if (afterExpandCallback) {
                    afterExpandCallback();
                }
            }
        };
})(AJS.$);
/*[{!comment_thread_js_vum751o!}]*/;
/* END /2static/script/cru/review/comment/comment-thread.js */
/* START /2static/script/cru/review/diff/diff-nav.js */
CRU.DIFF = {};
CRU.DIFF.NAV = {};

(function () {
    var currentDiffId = null;
    var currentFrxId = null;

    var diffClasses = '.ediffContentA,.ediffContentB,.diffContentA,.diffContentB';

    CRU.DIFF.NAV.getCurrentDiffId = function (frxId) {
        if (currentFrxId === frxId && CRU.FRX.NAV.getCurrentFrxId() === currentFrxId) {
            return currentDiffId;
        } else {
            return null;
        }
    };

    CRU.DIFF.NAV.setCurrentDiffId = function (frxId, diffId) {
        currentFrxId = frxId;
        currentDiffId = diffId;
    };

    CRU.DIFF.NAV.getDiffs = function (frx) {
        if (frx == null) {
            return null;
        }

        // select diff anchors that are in rows with an actual diff class content
        var diffSelector = 'tr:has(' + diffClasses + ') a[id^=frx' + frx.id() + '_seg]';
        // TODO: cache this for a given frx possibly
        return frx.frxInner().find(diffSelector);
    };

    // determines the order between a diff and comment selector
    CRU.DIFF.NAV.diffAfterComment = function ($diff, $comment, forwards) {
        if (!$diff) {
            return !forwards;
        }
        if (!$comment) {
            return forwards;
        }

        var diffRowIndex = $diff.parents("tr").first().index();
        var commentRowIndex = $comment.parents("tr").first().index();
        return forwards ? diffRowIndex > commentRowIndex : diffRowIndex <= commentRowIndex;
    };

    // find the next diff in the frx
    CRU.DIFF.NAV.findNextDiff = function (frx, forwards, nextFrxId, opts) {
        var diffs = CRU.DIFF.NAV.getDiffs(frx);

        if (diffs == null || diffs.length === 0) {
            return null;
        }

        var currentDiff = CRU.DIFF.NAV.getCurrentDiffId(frx.id());
        if (currentDiff == null && frx.id() === opts.startingFrxId && (opts.findComment || opts.findDefect) && opts.startingCommentDomId) {
            var $previousComment = frx.frxInner().find('#' + opts.startingCommentDomId);
            if ($previousComment) {
                // if we were on a comment previously we want to have the next/previous diff from that
                // determine the last diff before the comment and go off that
                var lastDiffBeforeComment = forwards ? -1 : diffs.length;
                do {
                    var nextCandidate = forwards ? lastDiffBeforeComment + 1 : lastDiffBeforeComment - 1;
                    currentDiff = lastDiffBeforeComment;
                    if (CRU.DIFF.NAV.diffAfterComment(diffs.eq(nextCandidate), $previousComment, forwards)) {
                        break;
                    }
                    lastDiffBeforeComment = nextCandidate;
                } while (lastDiffBeforeComment >= 0 && lastDiffBeforeComment < diffs.length)
            }
        }

        var nextDiff;
        if (currentDiff == null) {
            nextDiff = forwards ? 0 : diffs.length - 1;
        } else {
            nextDiff = forwards ? currentDiff + 1 : currentDiff - 1;
            if (nextDiff >= diffs.length || nextDiff < 0) {
                return null;
            }
        }

        return {
            frxId: frx.id(),
            diffId: nextDiff,
            type: 'diff',
            gotoElem: diffs[nextDiff],
            nextFrxId: nextFrxId
        };
    };

    CRU.DIFF.NAV.gotoDiff = function (nextElementMap) {
        if (nextElementMap.frxId !== CRU.FRX.NAV.getCurrentFrxId()) {
            CRU.FRX.NAV.setCurrentFrx(nextElementMap.frxId);
        }

        CRU.DIFF.NAV.scrollToDiff(nextElementMap);
    };

    CRU.DIFF.NAV.scrollToDiff = function (nextElementMap) {
        CRU.DIFF.NAV.setCurrentDiffId(nextElementMap.frxId, nextElementMap.diffId);
        CRU.UI.scrollToElement(nextElementMap.gotoElem, {
            offset: 55,
            onAfter: function() {
                var $diffRow = AJS.$(nextElementMap.gotoElem).parents('tr').first();
                var $visibleChildren = $diffRow.find('td:visible');
                CRU.UI.highlightElements($visibleChildren);
            }
        });
        window.location.hash = 'd' + nextElementMap.gotoElem.getAttribute('id'); // using an existing anchor (without the 'd') adds additional popping
    };
})();/*[{!diff_nav_js_0exh51q!}]*/;
/* END /2static/script/cru/review/diff/diff-nav.js */
/* START /2static/script/cru/review/frx/frx.js */
CRU.FRX = (function ($, reviewUtil) {
    var postPostLoadSummarize;
    var postPostLoadFunc = function () {
        review.setLoaded(true);
        reviewUtil.startPollingForReviewUpdates();
        // This is executed after all diffs are finished.
        if (postPostLoadSummarize) {
            res.toggleSource();
        }
        commentator.setCommentWidths(null, true);
        commentator.g_pageCompletelyLoaded = true;
    };

    /*eslint-disable complexity, max-depth*/
    var optimizedFrxList = function (alreadyLoadedFrx, frxIdsToList) {
        var frxsToList;
        if (frxIdsToList) {
            frxsToList = [];
            for (var idIndex = 0; idIndex < frxIdsToList.length; idIndex++) {
                frxsToList[frxsToList.length] = review.frx(frxIdsToList[idIndex]);
            }
        } else { // default to all
            frxsToList = review.frxs();
        }

        var currentFrxId = CRU.FRX.NAV.getCurrentFrxId();
        var loadingCurrentFrxId = false;

        var idsWithUnreadDefects = [];
        var idsWithUnreadComments = [];
        var idsIncomplete = [];
        var idsWithDefects = [];
        var idsWithComments = [];
        var idsWithoutComments = [];
        var idsThatAreDirs = []; // less likely that we want these really

        for (var i = 0, len = frxsToList.length; i < len; i++) {
            var frx = frxsToList[i];
            if (frx) {
                var id = frx.id();
                if (id === alreadyLoadedFrx) {
                    continue;
                }
                if (id === currentFrxId) {
                    loadingCurrentFrxId = true;
                    continue;
                }

                var unreadComments = frx.unreadComments();
                if (unreadComments.length > 0) {
                    var hasUnreadDefect;
                    for (var j = 0; j < unreadComments.length; j++) {
                        hasUnreadDefect = unreadComments[j].defect();
                        if (hasUnreadDefect) {
                            break;
                        }
                    }
                    (hasUnreadDefect ? idsWithUnreadDefects : idsWithUnreadComments).push(id);
                } else if (!frx.isComplete()) {
                    idsIncomplete.push(id);
                } else if (frx.hasDefects()) {
                    idsWithDefects.push(id);
                } else if (frx.hasComments()) {
                    idsWithComments.push(id);
                } else if (frx.isDirectory()) {
                    idsThatAreDirs.push(id);
                } else {
                    idsWithoutComments.push(id);
                }
            }
        }

        return (loadingCurrentFrxId ? [currentFrxId] : [])
            .concat(idsWithUnreadDefects)
            .concat(idsWithUnreadComments)
            .concat(idsIncomplete)
            .concat(idsWithDefects)
            .concat(idsWithComments)
            .concat(idsWithoutComments)
            .concat(idsThatAreDirs);
    };
    /*eslint-enable*/

    var filterFrxsFromHash = function () {
        if (/^#f-/.test(window.location.hash)) {
            var csv = window.location.hash.replace(/^#f-/, '');
            reviewUtil.filterAndExpandFrxs(csv.split(','));
        }
    };

    var activateFirstUnfilteredFrx = function () {
        var frxToActivate;
        var $generalComments = $('#generalComments');

        if (!$generalComments.hasClass('filtered')) {
            frxToActivate = $generalComments[0];
        } else {
            var nonFilteredFrxs = $.grep(review.frxs(), function (frx) {
                return !frx.isFiltered();
            });
            if (nonFilteredFrxs.length > 0) {
                frxToActivate = $('#frxouter' + nonFilteredFrxs[0].id())[0];
            }
        }

        if (frxToActivate) {
            CRU.FRX.NAV.setCurrentFrxAndScroll(frxToActivate);
        }
    };
    var activateFirstUnfilteredComment = function (filter, currentFrx) {
        var frxComments;
        var $generalComments = $('#generalComments');

        if (currentFrx && !currentFrx.isFiltered()) { // stay on the current frx if it's unfiltered
            frxComments = currentFrx.comments();
        } else if (!$generalComments.hasClass('filtered')) {
            frxComments = review.generalComments();
        } else {
            var nonFilteredFrxs = $.grep(review.frxs(), function (frx) {
                return !frx.isFiltered();
            });
            if (nonFilteredFrxs.length > 0) {
                frxComments = nonFilteredFrxs[0].comments();
            }
        }

        // scroll to the first matching comment in the first unfiltered frx
        if (frxComments) {
            for (var i = 0, len = frxComments.length; i < len; i++) {
                var comment = frxComments[i];
                if (commentMatchesFilter(comment, filter)) {
                    CRU.COMMENT.NAV.scrollDirectlyToComment(comment.domId());
                    break;
                }
            }
        }
    };

    function showFrx(frx) {
        frx.navItem().removeClass('filtered');
        frx.frxOuter().removeClass('filtered');
        frx.setFiltered(false);
    }

    function hideFrx(frx) {
        frx.navItem().addClass('filtered');
        frx.frxOuter().addClass('filtered');
        frx.setFiltered(true);
    }

    function getFrxFilter() {
        var filterItems = $('li.selected', document.getElementById('frxFilterOptions'));
        var filter = {
            isEnabled: !!filterItems.length
        };

        for (var i = 0, l = filterItems.length; i < l; i++) {
            filter[filterItems[i].id.replace("frx-filter-", "")] = true;
        }
        return filter;
    }

    function isCommentLevelFilter(filter) {
        return filter.unreadcomments ||
            filter.subtasks ||
            filter.unresolvedsubtasks ||
            filter.draftcomments ||
            filter.defects;
    }

    function frxMatchesFilter(frx, filter) {
        //if any frx-level filters do not match, hide this frx
        if ((filter.incomplete && frx.isComplete()) ||
            (filter.comments && !frx.hasComments()) ||
            (filter.binary && !frx.isBinary()) ||
            (filter.nonbinary && frx.isBinary()) ||
            (filter.nondirectory && frx.isDirectory()) ||
            (filter.newsincecomplete && !frx.isNewSinceComplete())) {
            return false;
        }
        if (isCommentLevelFilter(filter)) {
            var matchesCommentFilter = false;
            //on a comment-level filter, hide if no comments
            var frxComments = frx.comments();
            for (var j = 0, cLen = frxComments.length; j < cLen; j++) {
                var frxComment = frxComments[j];
                //show this frx if any comment matches all the comment-level filters
                if (commentMatchesFilter(frxComment, filter)) {
                    matchesCommentFilter = true;
                    break;
                }
            }
            if (!matchesCommentFilter) {
                return false;
            }
        }

        //matches all filters
        return true;
    }

    function generalCommentsFrxMatchesFilter(filter) {
        if (isCommentLevelFilter(filter)) {
            //on a comment-level filter, hide if no comments
            var frxComments = review.generalComments();
            for (var j = 0, cLen = frxComments.length; j < cLen; j++) {
                var frxComment = frxComments[j];
                //show this frx if any comment matches all the comment-level filters
                if (commentMatchesFilter(frxComment, filter)) {
                    return true;
                }
            }
            return false;
        } else {
            return true;
        }
    }

    function commentMatchesFilter(comment, filter) {
        var status = comment.issueStatus();
        if (status) {
            status = status.toLowerCase();
        }

        return !(
            filter.unreadcomments && !(comment.status() === 'unread' || comment.status() === 'leaveUnread') ||
            filter.subtasks && !(comment.issueKey() && comment.issueKey() !== '') ||
            filter.unresolvedsubtasks && !(comment.issueKey() && status !== 'resolved' && status !== 'closed') ||
            filter.draftcomments && !(comment.draft()) ||
            filter.defects && !(comment.defect())
        );
    }

    var filter = null;

    function changedFrxFilter() {
        filter = getFrxFilter();

        if (filter.isEnabled) {
            $("#filter-frxs-clear").removeClass("disabled");
        } else {
            $("#filter-frxs-clear").addClass("disabled");
        }

        filterFrxs(null, true);
    }

    function filterFrxs(frxs, jumpToFirstUnfiltered) {
        filter = filter || getFrxFilter();

        var isCommentLevel = isCommentLevelFilter(filter);

        if (!frxs) {
            frxs = review.frxs();
            var $generalComments = $('#scroll-to-general-comments').closest('li').add('#generalComments');

            //We should filter out general comments as well if it doesn't match a comment filter
            $generalComments.toggleClass('filtered', !generalCommentsFrxMatchesFilter(filter));
        }
        for (var i = 0, len = frxs.length; i < len; ++i) {
            var frx = frxs[i];
            if (frxMatchesFilter(frx, filter)) {
                showFrx(frx);
            } else {
                hideFrx(frx);
            }
        }

        CRU.COMMENT.NAV.visibleCommentsChanged();
        CRU.FRX.NAV.visibleFrxsChanged();
        if (jumpToFirstUnfiltered) {
            if (isCommentLevel) {
                activateFirstUnfilteredComment(filter, review.frx(CRU.FRX.NAV.getCurrentFrxId()));
            } else {
                var $currentFrx = $(CRU.FRX.NAV.getCurrentFrxElement());
                if (!$currentFrx.hasClass('frxouter') || $currentFrx.hasClass('filtered')) {
                    activateFirstUnfilteredFrx();
                }
            }
        }
        var navigationTree = $('#navigation-tree');
        $('.folder', navigationTree).parent().addClass('filtered');
        $('.frx-list-item:has(li.frx-list-item:not(.filtered))', navigationTree).removeClass('filtered');
        CRU.FRX.updateFiltererdFrxCount();
    }

    //unload an frx to save on heap space
    function unloadFrx(frxId) {
        var frx = review.frx(frxId);
        if (frx) {
            reviewUtil.triggerSourceCodeReset(frxId);
            frx.setLoaded(false)
                .frxInner()
                .empty()
                .append('<div id="frxLoadDiff' + frxId + '" class="frx-unloaded">' +
                '<a onclick="CRU.FRX.AJAX.frxLoad(' + frxId + ');return false;">Click to load diff</a>' +
                '</div>');
        }
    }

    var res = {

        reloadFrxs: function (opts, frxIds) {
            frxIds = optimizedFrxList(null, frxIds);

            //reset some global vars to reload the diffs
            for (var i = 0, len = frxIds.length; i < len; i++) {
                var frxId = frxIds[i];
                var frx = review.frx(frxId);
                reviewUtil.triggerSourceCodeReset(frxId);
                frx.setLoaded(false);
            }
            commentator.g_pageCompletelyLoaded = false;
            var loadOpts = {
                diffMode: opts.diffOpts,
                isForcedReload: true
            };
            CRU.FRX.AJAX.prioritisedFrxLoad(frxIds, null, loadOpts);
        },

        unloadFrx: unloadFrx,

        updateFiltererdFrxCount: function () {
            var unfilteredCount = $('#navigation-tree .frx-list-item:not(.filtered) > .frx').length;
            var filteredCount = $('#navigation-tree .frx-list-item.filtered > .frx').length;

            $('#filter-frxs-shown-count').text(unfilteredCount);
            $('#filter-frxs-unshown-count').text(filteredCount);

            if ($('#frxFilterOptions li.selected').length > 0) {
                $("#navigation-filter-link").parent().addClass("filter-enabled");
            } else {
                $("#navigation-filter-link").parent().removeClass("filter-enabled");
            }

            if (review.frxs().length > 0 && unfilteredCount === 0) {
                $('#frxs-filtered-warning').show();
            } else {
                $('#frxs-filtered-warning').hide();
            }
        },

        /**
         *
         * @param destination
         * This is for determining how the navigation is done. e.g. scroll to the next element..
         * possible values: 'first' | 'last' | 'next' | 'previous'
         *
         * @param $elementWithSpinner
         * This is the buttons of "navigation up / down"
         * In crucible, when a user reaches the bottom or top of the review, if he tries to go further, he will cycle up
         * the elements, and this $elementWithSpinner will get highlighted to notice the user.
         *
         * @param opts : {} -- the opts will contain two callback functions. When a user reaches the edge of the review,
         *                  -- this callback functions will be triggered
         *      navFirst :  function ()
         *          -- when a user reaches the top and try go "previous"
         *      navLast :   function ()
         *          -- when a user reaches the bottom and try go "next"
         */
        goToNextElement: function (destination, $elementWithSpinner, opts) {
            var numPredictedFrxsToLoad = 2;
            var comment_nav = CRU.COMMENT.NAV;

            opts = $.extend({
                startingCommentDomId: comment_nav.getCurrentCommentDomId(),
                destination: destination,
                findFrx: $('#search-file').hasClass('selected'),
                findComment: $('#search-comment').hasClass('selected'),
                findDefect: $('#search-defect').hasClass('selected'),
                findDiff: $('#search-diff').hasClass('selected'),
                startingFrxId: CRU.FRX.NAV.getCurrentFrxId(),
                stopIfNothingFound: false
            }, opts);

            var navigateForwards = destination === 'first' || destination === 'next';
            var nextElementMap = CRU.NAV.findNextElement(opts);

            CRU.COMMENT.commentScrollTracker && CRU.COMMENT.commentScrollTracker.setTrackingEnabled(false);

            var preloadNextFrxes = function () {
                opts.startingFrxId = nextElementMap.frxId;
                var predictions = CRU.FRX.getPredictedFrxsToLoad(opts, numPredictedFrxsToLoad);
                predictions.unshift(nextElementMap.frxId);
                CRU.FRX.AJAX.prioritisedFrxLoad(predictions);
            };
            if (nextElementMap && (nextElementMap.type === 'comment' ||
                nextElementMap.type === 'comment-unloaded')) {
                preloadNextFrxes();
                var scrollToComment = review.comment(nextElementMap.gotoElem);
                comment_nav.navigateDirectlyToElement(opts, {
                    gotoElem: scrollToComment ? scrollToComment.id() : null,
                    frxId: nextElementMap.frxId,
                    type: 'comment'
                }, $elementWithSpinner);
                CRU.DIFF.NAV.setCurrentDiffId(null, null);
            } else if (nextElementMap && nextElementMap.type === 'diff' && nextElementMap.gotoElem && nextElementMap.frxId) {
                preloadNextFrxes();
                comment_nav.setCurrentComment(null);
                CRU.DIFF.NAV.gotoDiff(nextElementMap);
            } else if (nextElementMap) {
                preloadNextFrxes();
                // prevent focusing comments and scrolling to the last position
                comment_nav.setCurrentComment(null);
                CRU.FRX.NAV.setCurrentFrx(nextElementMap.frxId, {gotoTop: true});
            } else {

                if (navigateForwards) {
                    if (opts.navFirst) {
                        opts.navFirst();
                    }
                } else {
                    if (opts.navLast) {
                        opts.navLast();
                    }
                }

                var $button = $('#' + (navigateForwards ? 'next' : 'prev') + '-element-link');
                $button.effect('highlight', {color: '#f00'}, 800);
            }

            CRU.COMMENT.commentScrollTracker && CRU.COMMENT.commentScrollTracker.setTrackingEnabled(true, true);
        },

        getPredictedFrxsToLoad: function (opts, count) {
            var options = $.extend({}, opts);
            var predictNext = [];
            if (options.destination === 'bidirectional') {
                options.destination = 'next';
                predictNext = CRU.FRX.getPredictedFrxsToLoad(options, count);
                options.destination = 'previous';
                predictNext = predictNext.concat(CRU.FRX.getPredictedFrxsToLoad(options, count));
            } else {
                // if there is only one frx on the review and the count is 2, the loop would be infinite.
                // so count can't be larger than number of existent frxes
                count = Math.min(count, review.frxIds().length);
                var prevGotoElem = null;
                while (count) {
                    var nextElementMap = CRU.NAV.findNextElement(options);
                    if (!nextElementMap) {
                        break;
                    }
                    nextElementMap.frxId = nextElementMap.frxId || "generalComments";
                    nextElementMap.nextFrxId = nextElementMap.nextFrxId || "generalComments";

                    if ($.inArray(nextElementMap.frxId, predictNext) === -1) {
                        predictNext.push(nextElementMap.frxId);
                        count--;
                    }

                    var gotoElem = nextElementMap.gotoElem;
                    if (gotoElem === prevGotoElem) {
                        break; // loop detected, same comment as in the previous run
                    }
                    prevGotoElem = gotoElem;

                    //we only care about frxs, so skip ahead to the next frxId on anything else
                    options.startingFrxId = nextElementMap.type !== 'frx' ? nextElementMap.nextFrxId : nextElementMap.frxId;
                }
            }
            return predictNext;
        },

        changedFrxFilter: changedFrxFilter,
        filterFrxs: filterFrxs,

        postPostLoadFunc: postPostLoadFunc,

        defaultPostLoad: function (summarize) {
            postPostLoadSummarize = summarize;
            $(window).bind('panes-resized', function () {
                commentator.setCommentWidths(null, true);
            });
        },

        revPostLoad: function (summarize) {
            CRU.COMMENT.commentScrollTracker && CRU.COMMENT.commentScrollTracker.setTrackingEnabled(false);
            var MAX_FRX_AUTOLOAD = 10; // The number of FRXs to automatically load when the the initial review page has loaded.

            res.defaultPostLoad(summarize);
            var cru = CRU;
            var cru_frx = cru.FRX;
            var anchoredFrx = cru_frx.NAV.checkFrxAnchor();
            if (!anchoredFrx) {
                anchoredFrx = cru.COMMENT.NAV.checkCommentAnchor();
            }
            if (!anchoredFrx) {
                filterFrxsFromHash();
            }
            if (!anchoredFrx) {
                anchoredFrx = res.checkSegmentAnchor();
            }
            if (!anchoredFrx && window.location.hash.replace('#', '')) {
                CRU.FRX.scrollFrxPane('generalComments', window.location.hash.replace('#', ''));
                CRU.UI.highlightElements($(window.location.hash).children('.overview-item'));
            }
            cru_frx.AJAX.setIsInitialFrxLoad();
            cru_frx.AJAX.frxLoad(optimizedFrxList(anchoredFrx).slice(0, MAX_FRX_AUTOLOAD));
            CRU.COMMENT.commentScrollTracker && CRU.COMMENT.commentScrollTracker.setTrackingEnabled(true, true);
        },

        checkSegmentAnchor: function () {
            var m = /^#frx([0-9]+)_seg/.exec(window.location.hash);
            if (m) {
                var frxId = m[1];
                var frx = review.frx(frxId);
                var $segment = $(window.location.hash);

                var isInlineButNotLoaded = $segment.length === 0;
                if (isInlineButNotLoaded) {
                    if (frx.isLoaded()) {
                        res.scrollToSegment(frxId, window.location.hash);
                    } else {
                        var onDone = function () {
                            res.scrollToSegment(frxId, window.location.hash);
                        };
                        CRU.FRX.AJAX.prioritisedFrxLoad(frx.id(), onDone);
                    }
                    return frxId;
                } else {
                    window.location.hash = '';
                    CRU.FRX.NAV.setCurrentFrxAndScroll('generalComments');
                }
            }
            return null;
        },

        //todo: use this method instead of hashes to jump between them - for now this is only used when loading the page
        scrollToSegment: function (frxId, segId) {
            CRU.FRX.NAV.setCurrentFrx(frxId);
            var $seg = $(segId);
            if ($seg.length > 0) {
                CRU.UI.scrollToElement($seg[0], {
                    offset: 43
                });
            }
        },

        toggleAllFrxsSoftWrapping: function (enabled) {
            if (enabled) {
                $('#reviewpage').removeClass('noWrapping').addClass('wrapping');
            } else {
                $('#reviewpage').addClass('noWrapping').removeClass('wrapping');
            }
        },

        toggleAllFrxsDiffMode: function (mode) {
            res.reloadFrxs({diffOpts: {diffLayout: mode}});
        },

        toggleSource: function () {
            var currentFrxId = CRU.FRX.NAV.getCurrentFrxId();
            if (commentator.showSource) {
                commentator.showSource = false;
                $('#reviewpage').addClass("hide-source");
                $('#show_source_button').removeClass('selected');

                reviewUtil.triggerSourceCodeHidden(currentFrxId);
                commentator.toggleComments("above");
            } else {
                commentator.showSource = true;
                $('#reviewpage').removeClass("hide-source");
                $('#show_source_button').addClass('selected');

                reviewUtil.triggerSourceCodeShown(currentFrxId);
            }
        },

        changeBlankLines: function (permaId, frxId, bl) {
            res.changeWhitespace(permaId, frxId, null, bl);
        },

        changeWhitespace: function (permaId, frxId, ws, bl) {
            var params = res.diffParams(frxId, {whiteSpace: ws, blankLines: bl}) + "&showDiffContextBar=true";
            params += CRU.FRX.AJAX.frxRevisionParams(frxId);
            CRU.FRX.AJAX.toggleSourceType(permaId, frxId, false, params);
        },

        whiteSpaceParams: function (frx, ws) {
            if (ws) {
                frx.setWhitespace(ws);
            } else {
                ws = frx.getWhitespace();
            }
            return ws;
        },

        blankLinesParams: function (frx, bl) {
            if (bl !== null && bl !== undefined) {
                frx.setIgnoreBlankLines(bl);
            } else {
                bl = frx.getIgnoreBlankLines();
            }
            return bl;
        },

        contextParams: function (frx, context) {
            if (context) {
                frx.setContext(context);
            } else {
                context = frx.getContext();
            }
            return context;
        },

        diffLayoutParams: function (frx, opt) {
            if (opt) {
                frx.setDiffLayout(opt);
            } else {
                opt = frx.getDiffLayout();
            }
            return opt;
        },

        diffParamsMap: function (frxId, map) {
            var frx = review.frx(frxId);
            map = map || {};
            if (frx) {
                map.context = res.contextParams(frx, map.context);
                map.diffLayout = res.diffLayoutParams(frx, map.diffLayout);
                map.blankLines = res.blankLinesParams(frx, map.blankLines);
                map.whiteSpace = res.whiteSpaceParams(frx, map.whiteSpace);
            }
            return map;
        },

        diffParams: function (frxId, map) {
            map = res.diffParamsMap(frxId, map);
            var result = '';
            if (map.context) {
                result += '&u=' + map.context;
            }
            if (map.diffLayout) {
                result += '&fv=' + map.diffLayout;
            }
            // this is a boolean value, so a value of false would be ignored here
            if (map.blankLines !== undefined && map.blankLines !== null) {
                result += '&bl=' + map.blankLines;
            }
            if (map.whiteSpace) {
                result += '&ws=' + map.whiteSpace;
            }
            return result;
        },

        reloadSingleFrx: function (permaId, frxId, diffLayout) {
            var params = res.diffParams(frxId, {'diffLayout': diffLayout}) + "&showDiffContextBar=true";
            params += CRU.FRX.AJAX.frxRevisionParams(frxId);
            CRU.FRX.AJAX.toggleSourceType(permaId, frxId, false, params, null);
        },

        toggleDiffModeAjax: function (permaId, frxId, u, done) {
            var params = res.diffParams(frxId, {'context': u});
            params += CRU.FRX.AJAX.frxRevisionParams(frxId);
            CRU.FRX.AJAX.toggleSourceType(permaId, frxId, false, params, done);
        },

        frxActivated: function (frxOuter, options) {
            var cruFrx = CRU.FRX;
            var cruFrxNav = cruFrx.NAV;
            var cruFrxAjax = cruFrx.AJAX;
            var cruCommentNav = CRU.COMMENT.NAV;

            options = $.extend({
                changeHash: true
            }, options);
            var frxId = frxOuter.id.replace('frxouter', '');
            if (frxId === 'generalComments') {
                $('#frx-overview').addClass("activeFrx");
                $('#generalComments').addClass("activeFrx");
                $(frxOuter).trigger('frx-visible');
            } else {
                var frx = review.frx(frxId);
                var $frxOuter = frx.frxOuter();
                var $navItem = frx.navItem();

                $navItem.addClass("activeFrx");
                $frxOuter.addClass("activeFrx");

                if (options.changeHash) {
                    window.location.hash = "#CFR-" + frxId;
                }

                if (frx.isLoaded()) {
                    cruCommentNav.visibleCommentsChanged();
                    $(frxOuter).trigger('frx-visible');
                } else {
                    // If the frx hasn't loaded yet, then we should push it to the top of the load stack.
                    cruFrxAjax.prioritisedFrxLoad(frxId, function () {
                        $(frxOuter).trigger('frx-visible');
                    });
                }

                if (!cruFrxAjax.isFrxControlsRendered(frxId)) {
                    cruFrxAjax.unshelveFrxControls(frxId);
                }
            }
            cruFrxNav.visibleFrxsChanged();

        },

        frxDeactivated: function (frxOuter) {
            if (!frxOuter) {
                return;
            }
            var frxId = frxOuter.id.replace('frxouter', '');
            $(frxOuter).removeClass("activeFrx");

            if (frxId === 'generalComments') {
                // general controls
                $("#frx-overview").removeClass("activeFrx");
            } else {
                var $prev = $("#frx-list-item" + frxId).removeClass("activeFrx");
                cancelPrevHightlights($prev.children('span'));
            }
        },

        dimFrxContent: function () {
            var $inner = $("#frx-content");
            var $blanket = $("#frx-dim-content");
            if ($blanket.length > 0) {
                return;
            }
            $blanket = $("<div id='frx-dim-content' class='frx-dim'><div id='frx-dim-msg' class='frx-dim-msg'>Updating source...</div></div>");
            $inner.append($blanket);
        },

        unDimFrxContent: function () {
            var $blanket = $("#frx-dim-content");
            if ($blanket.length > 0) {
                $blanket.remove();
            }
        },

        dimFrx: function (frxId) {
            // sanity check
            if (!review.frx(frxId)) {
                return;
            }
            var $inner = $("#sourcefrxinner" + frxId);

            var $blanket = $("#frx-dim-" + frxId);
            if ($blanket.length > 0) {
                return;
            }

            $blanket = $("<div id='frx-dim-" + frxId + "' class='frx-dim'><div id='frx-dim-msg-" + frxId + "' class='frx-dim-msg'>Updating source...</div></div>");

            $blanket.css({
                height: $inner.height(),
                width: $("#sourceTable" + frxId).width() // Source table can push out from parent dimensions
            });
            $inner.prepend($blanket);
        },

        unDimFrx: function (frxId) {
            // sanity check
            if (!review.frx(frxId)) {
                return;
            }
            var $blanket = $("#frx-dim-" + frxId);
            if ($blanket.length > 0) {
                $blanket.remove();
            }
        },

        scrollFrxPane: function (containerId, innerId) {
            var cruFrxNav = CRU.FRX.NAV;
            if (innerId) {
                cruFrxNav.setCurrentFrx(containerId);
                var $inner = $(cruFrxNav.getCurrentFrxElement()).find('#' + innerId);
                if ($inner.length === 1) {
                    CRU.UI.scrollToElement($inner[0]);
                }
            } else {
                cruFrxNav.setCurrentFrxAndScroll(containerId);
            }
        }
    };

    var setFrxDimHeight = function (frxId) {
        $("#frx-dim" + frxId).css("height", $("#sourcefrxinner" + frxId).height());
    };

    var highlightElement = function ($elem, color) {
        $elem.effect("highlight", {color: color}, 1200, function () {
            $(this).css("background-color", "");
        });
        $elem.css('background-image', '');
    };

    var cancelPrevHightlights = function ($elem) {
        $elem.stop().css('background-color', '');
    };

    return res;
})(
    AJS.$,
    CRU.REVIEW.UTIL
);

/*[{!frx_js_o47d51u!}]*/;
/* END /2static/script/cru/review/frx/frx.js */
/* START /2static/script/cru/review/frx/frx-event.js */
AJS.$(document).ready(function () {

    var cruFrx = CRU.FRX;
    var cruFrxNav = cruFrx.NAV;
    var cruFrxAjax = cruFrx.AJAX;
    var cruUi = CRU.UI;

    cruFrx.updateFiltererdFrxCount(); // Setup the count in the filter div

    // Clicking on nav tree directories:
    //   1. If we click on the actual link, then if it is an FRX directory, activate it
    //      (handled by .scroll-to-frx live event).
    //   2. Otherwise, toggle the subtree
    //   3. If we click on the parent span.folder, then toggle it (dont activate the frx)

    var $frxPane = AJS.$("#frx-pane");
    var $navTree = AJS.$("#navigation-tree");

    $navTree.delegate(".tree span.folder", 'click', function (event) {
        var $folder = AJS.$(this);
        var $icon = $folder.find('.node-icon');
        var frxLinkClicked = AJS.$(event.target).is('a.frx-dir-item');

        // Don't close when clicking the link of an frxdir
        if ($folder.hasClass("open") && frxLinkClicked) {
            return;
        }

        if ($folder.hasClass("open")) {
            $folder.removeClass("open")
                .addClass("closed");

            $icon.removeClass('aui-iconfont-devtools-folder-open')
                .addClass('aui-iconfont-devtools-folder-closed');
        } else {
            $folder.removeClass("closed")
                .addClass("open");

            $icon.removeClass('aui-iconfont-devtools-folder-closed')
                .addClass('aui-iconfont-devtools-folder-open')
        }
        $folder.next('.tree').toggle();
        commentator.updateTreeFolderCommentCount($folder);
    });

    $frxPane.delegate("a.diff-segment-link", 'click', function (event) {
        var dest = AJS.$(this).attr("href");
        var frx = dest.replace("#frx", '').replace(/_seg\d+/, '');
        CRU.UI.scrollToElement(AJS.$(dest), {
            offset: 55
        });
        event.preventDefault();
        return false;
    });

    $frxPane.delegate(".frxControls a.toggleFileRead,.frxControls a.toggleFileRead-manual", "click", function () {
        var frx = review.frx(AJS.$(this).closest('.frxControls').attr('id').replace('frxControls', ''));
        cruFrx.AJAX.toggleFileRead(frx.id(), true);
    });

    function scrollToGeneralComments(innerId) {
        cruFrx.scrollFrxPane('generalComments', innerId);
        cruFrxNav.scrollToCommentForm();
    }

    var initUnreadCommentTooltips = function () {
        var tooltipOptions = {
            live: true,
            gravity: 'w',
            title: function () {
                var unreadCount = parseInt(this.dataset.unread || 0, 10);
                if (unreadCount > 0) {
                    return unreadCount + ' unread comment' + (unreadCount > 1 ? 's' : '');
                }
                return '';
            }
        };

        AJS.$('.aui-badge', AJS.$('#tree-root'))
            .tooltip(tooltipOptions);

        AJS.$('.aui-badge', AJS.$('#review-meta'))
            .tooltip(tooltipOptions);
    };


    if (AJS.$('#reviewpage').length === 1) {
        $navTree.delegate('.frx-list-item:not(.filtered) > span > a.scroll-to-frx', 'click', function () {
            var frxId = AJS.$(this).attr('id').replace(/scroll-to-frx/, '');
            cruFrxNav.setCurrentFrx(frxId);
            cruFrxNav.scrollToCommentForm();
            //we should load the nearest frxs ahead of time in case they click around
            var predictionOpts = {
                startingCommentDomId: null,
                destination: 'bidirectional',
                findFrx: true,
                findComment: false,
                findDefect: false,
                findDiff: false,
                startingFrxId: frxId
            };
            cruFrxAjax.prioritisedFrxLoad(cruFrx.getPredictedFrxsToLoad(predictionOpts, 1));
        });

        var $document = AJS.$(document);
        var changeHashAndBlockScroll = function (link) {
            var $link = AJS.$(link);
            var $window = AJS.$(window);
            var scrollTop = $window.scrollTop();

            document.location.hash = $link.attr('href');
            $window.scrollTop(scrollTop);
        };

        $document.delegate('#frx-overview:not(.filtered) .comments a', 'click', function (e) {
            e.preventDefault();
            changeHashAndBlockScroll(this);
            scrollToGeneralComments('general-comments');
            cruUi.highlightElements(AJS.$('#general-comments').children('.overview-item'));
        });

        $document.delegate('#frx-overview:not(.filtered) .details a', 'click', function (e) {
            e.preventDefault();
            changeHashAndBlockScroll(this);
            scrollToGeneralComments('details');
            cruUi.highlightElements(AJS.$('#details').children('.overview-item'));
        });

        $document.delegate('#frx-overview:not(.filtered) .objectives a', 'click', function (e) {
            e.preventDefault();
            changeHashAndBlockScroll(this);
            scrollToGeneralComments('objectives');
            cruUi.highlightElements(AJS.$('#objectives').children('.overview-item'));
        });

        $document.delegate('#frx-overview:not(.filtered) .summary a', 'click', function (e) {
            e.preventDefault();
            changeHashAndBlockScroll(this);
            scrollToGeneralComments('summary');
            cruUi.highlightElements(AJS.$('#summary').children('.overview-item'));
        });

        $document.delegate('#frx-overview:not(.filtered) .notifications a', 'click', function (e) {
            e.preventDefault();
            changeHashAndBlockScroll(this);
            scrollToGeneralComments('notifications');
            cruUi.highlightElements(AJS.$('#notifications').children('.overview-item'));
        });


        initUnreadCommentTooltips();

        if (!window.location.hash && AJS.$('#frx-pane').length > 0) {
            CRU.FRX.NAV.setCurrentFrx('generalComments');
        }
    }
});
/*[{!frx_event_js_snix51s!}]*/;
/* END /2static/script/cru/review/frx/frx-event.js */
/* START /2static/script/cru/review/frx/frx-ajax.js */
CRU.FRX.AJAX = (function (reviewUtil) {

    var FRXS_FOR_LOAD = [];
    var IS_AUTO_LOADING = false;
    var IS_INITIAL_FRX_LOAD = false;

    var setFrxRevisionParams = function (frxId, from, to) {
        to = to || "";
        from = from || "";
        review
            .frx(frxId)
            .setVisibleFromRevision(from)
            .setVisibleToRevision(to);
    };

    var setFrxToBeLoadedHtml = function (frxId) {
        var html = [
            "<div id='frxDisplayDiff" + frxId + "' class='frx-unloaded'>",
            "<div class='preAjaxLoad'>Loading diff...</div>",
            "</div>"
        ].join("");

        AJS.$("#frxinner" + frxId).html(html);
    };

    var frxLoadDiff = function (frxId, onCompleteFunc, loadOpts) {
        loadOpts = loadOpts || {};

        var cruFrx = CRU.FRX;
        var cruFrxNav = cruFrx.NAV;

        var frx = review.frx(frxId);

        //frx could have been removed in the meantime
        if (!frx) {
            if (onCompleteFunc) {
                onCompleteFunc();
            }
            return;
        }

        var fromRev = loadOpts.fromRev || frx.visibleFromRevision();
        var toRev = loadOpts.toRev || frx.visibleToRevision();

        var changeDiff = !(fromRev === frx.visibleFromRevision() && toRev === frx.visibleToRevision());
        var shouldReload = !frx.isLoading() && (!frx.isLoaded() || loadOpts.isForcedReload || changeDiff);

        var onComplete = function (resp) {
            if (resp) {
                AJS.$("#frxinner" + frxId).removeClass("frx-loading");
                frx.setLoading(false);
            }
            if (resp && resp.worked && shouldReload) {
                res.reloadFrxModel(frxId, resp, false);
                res.updateFrxDiffControls(frxId, resp);
                res.updateFrxSlider(frxId, resp);
                res.updateNavListClasses(frxId, resp);
                rebindEventsAndRefreshComments(frxId);
                if (loadOpts.rescanComments || cruFrxNav.getCurrentFrxId() === frxId) {
                    CRU.COMMENT.NAV.visibleCommentsChanged();
                }
                // need to get the new object out of review
                frx = review.frx(frxId);
                AJS.$('#frxControls' + frxId).removeClass('read unread leaveUnread').addClass(frx.readStatus());
                frx.setLoaded(true);
                commentator.reloadFrxCommentCount(frx);

                review.recentlyViewedFrxIds.save(frxId);
                while (review.recentlyViewedFrxIds.length() > CRU.REVIEW.MAX_FRXS_LOADED) {
                    CRU.FRX.unloadFrx(review.recentlyViewedFrxIds.remove());
                }

                // trigger lazy loading of any JIRA issue details
                CRU.UI.loadInlineJiraIssues();
                CRU.FRX.NAV.frxDiffLoaded(frxId);
            }

            if (onCompleteFunc) {
                onCompleteFunc();
            }
        };

        if (shouldReload) {
            frx.setLoading(true);
            setFrxToBeLoadedHtml(frxId);
            cruFrx.dimFrx(frxId);
            var elementIdToUpdate = 'frxinner' + frxId;
            var url = CRU.UTIL.jsonUrlBase(permaId) + '/loadFrxAjax';
            var diffModeOpts = cruFrx.diffParams(frxId, loadOpts.diffMode);
            var noCacheRand = Math.floor(Math.random() * 999999);
            setFrxRevisionParams(frxId, fromRev, toRev);
            var pars = 'frxid=' + frxId + '&dontCache=' + noCacheRand + diffModeOpts + res.frxRevisionParams(frxId);
            FECRU.AJAX.ajaxUpdate(url, pars, elementIdToUpdate, onComplete);
        } else {
            onComplete(null); //allow the onComplete to finish despite not loading.
        }
    };

    var inFrxLoadQueue = function (frxId) {
        var queue = FRXS_FOR_LOAD;
        for (var i = 0, len = queue.length; i < len; i++) {
            if (frxId === queue[i].id) {
                return i;
            }
        }
        return -1;
    };

    var isFrxLoadBlocked = false;

    var frxIdsToFilter = [];

    // Initial frxs which are loaded are limited to 20 in CRU.FRX.optimizedFrxList()
    var doSerialisedFrxLoad = function () {

        if (isFrxLoadBlocked) {
            IS_AUTO_LOADING = false;
            return;
        }

        IS_AUTO_LOADING = true;

        // load and chain
        if (FRXS_FOR_LOAD.length > 0) {
            // We store either an integer id or a map of id/onDone in the array, so here we check for the objects
            var frxOpts = FRXS_FOR_LOAD[0];
            var frxId = frxOpts.id;
            var loadOpts = frxOpts.loadOpts;

            var onComp = function () {
                // onDone might have change since it's been queued
                var onDone = frxOpts.onDone;

                CRU.CREATE.bindUpdateFrxFromFormToggle('#add-revisions-link-' + frxId, frxId);
                if (CRU.FRX.NAV.getCurrentFrxId() === frxId && review.autoMarkFilesRead()) {
                    res.markFile(true, frxId, false);
                }

                // Order of FRX load queue may have changed, so we need to do a lookup.
                // we do this before the onDone() call, because the frx is now considered to be loaded
                var queueIndex = inFrxLoadQueue(frxId);
                if (queueIndex >= 0) {
                    // This should always be the case, since only this method should remove items from the queue.
                    FRXS_FOR_LOAD.splice(queueIndex, 1);
                }

                frxIdsToFilter.push(frxId);

                // Execute the callback if it exists
                onDone && onDone();
                doSerialisedFrxLoad(); // chain
            };

            frxLoadDiff(frxId, onComp, loadOpts); // load
        } else { // when finished chaining
            if (IS_INITIAL_FRX_LOAD) {
                var cru_frx = CRU.FRX;

                if (cru_frx.postPostLoadFunc) {
                    cru_frx.postPostLoadFunc();
                }
                AJS.$("#show_source_button").removeClass("disabled").addClass("selected").children("a").click(function () {
                    cru_frx.toggleSource();
                });
                commentator.setCommentWidths(null, true);
                commentAjaxController.loadCommentIssueStatuses();
                IS_INITIAL_FRX_LOAD = false;
            }

            IS_AUTO_LOADING = false;
            CRU.FRX.filterFrxs(AJS.$.map(frxIdsToFilter, function (frxId) {
                return review.frx(frxId) || null;
            }));
            frxIdsToFilter = [];
        }
    };

    var rebindEventsAndRefreshComments = function (frxId) {
        tetrisCommentController.renderTetrisCommentMarkersForFrx(frxId);
        commentAjaxController.loadCommentIssueStatuses(frxId);
    };

    var res = {
        blockFrxLoading: function () {
            isFrxLoadBlocked = true;
        },
        unblockFrxLoading: function () {
            isFrxLoadBlocked = false;
            doSerialisedFrxLoad();
        },
        frxRevisionParams: function (frxId) {
            var frx = review.frx(frxId);
            var params = "";
            if (!frx) {
                return params;
            }
            if (frx.visibleFromRevision()) {
                params += "&fromRev=" + frx.visibleFromRevision();
            }
            params += "&toRev=" + frx.visibleToRevision();
            return params;
        },

        updateFrxView: function (from, to, frxId) {
            setFrxRevisionParams(frxId, from, to);
            CRU.FRX.dimFrx(frxId);
            var url = CRU.UTIL.jsonUrlBase(permaId) + '/updateFrxViewAjax';
            var pars = "frxid=" + frxId + res.frxRevisionParams(frxId) + CRU.FRX.diffParams(frxId);

            reviewUtil.triggerSourceCodeReset(frxId);

            var onComp = function (origRequest) {
                if (!origRequest.worked) {
                    CRU.FRX.unDimFrx(frxId);
                } else {
                    res.shelveFrxControls(frxId);
                    var $frxOuter = AJS.$('#frxouter' + frxId);
                    $frxOuter.html(origRequest.payload);
                    res.unshelveFrxControls(frxId);
                    res.reloadFrxModel(frxId, origRequest, true);
                    commentator.setCommentWidths(null, true);
                    commentator.reloadFrxCommentCount(review.frx(frxId));
                    res.updateFrxDiffControls(frxId, origRequest);
                    rebindEventsAndRefreshComments(frxId);
                    CRU.COMMENT.NAV.visibleCommentsChanged();
                    $frxOuter.trigger('view-range-change');
                    reviewUtil.triggerSourceCodeShown(frxId);
                }
            };
            FECRU.AJAX.ajaxUpdate(url, pars, null, onComp);
            return false;
        },

        isFrxControlsRendered: function (frxId) {
            return AJS.$('#frx-context-info-' + frxId).children('.frxControls:first').length === 1;
        },

        shelveFrxControls: function (frxId) {
            var $frxControls = AJS.$('#frx-context-info-' + frxId).children('.frxControls:first');
            $frxControls.append(AJS.$('#add-revisions-link-' + frxId));
            AJS.$('#frxControlsContainer' + frxId).append($frxControls);
        },

        unshelveFrxControls: function (frxId) {
            AJS.$('#add-revisions-link-box-' + frxId).append(AJS.$('#add-revisions-link-' + frxId));
            AJS.$('#frx-context-info-' + frxId).append(AJS.$('#frxControlsContainer' + frxId).children('.frxControls:first'));
            AJS.$('#frxouter' + frxId).trigger('frx-header-unshelved');
        },

        reloadFrxModel: function (frxId, resp, keepSliderRevs) {
            var oldFrx = review.frx(frxId);
            var isExpanded = oldFrx.isExpanded();
            if (keepSliderRevs) {
                var sliderFrxRevisions = oldFrx.getSliderFrxRevisions();
            }

            eval('var frxModelLoader = ' + resp.frxModelLoader);
            frxModelLoader();

            var newFrx = review.frx(frxId);
            newFrx
                .setLoaded(true)
                .setExpanded(isExpanded);
            if (keepSliderRevs) {
                newFrx.setSliderFrxRevisions(sliderFrxRevisions);
            }
            commentator.reloadFrxCommentCount(newFrx);
        },

        updateFrxDiffControls: function (frxId, frxAjaxResp) {
            var contents = frxAjaxResp.diff;
            if (contents) {
                AJS.$('#diffOptionsFormPlaceholder' + frxId).html(frxAjaxResp.diff);
            } else {
                AJS.$('#diffOptionsFormPlaceholder' + frxId).hide();
            }
            // reset the fisheye diff link
            var toRev = review.frx(frxId).visibleToSCMRevision();
            var fromRev = review.frx(frxId).visibleFromSCMRevision();
            if (toRev === fromRev) {
                AJS.$('#fisheyeDiffUrl' + frxId).hide();
            } else {
                AJS.$('#fisheyeDiffUrl' + frxId + ' a')
                    .attr('href', AJS.$('#baseFisheyeDiffUrl' + frxId).val() + '?r1=' + fromRev + '&r2=' + toRev);
                AJS.$('#fisheyeDiffUrl' + frxId).show();
            }
        },

        updateFrxSlider: function (frxId, frxAjaxResp) {
            var $sliderDiv = AJS.$('#frxSliderDiv-' + frxId);
            $sliderDiv.html(frxAjaxResp.slider);
            // Sliders in the edit content panel of manage files should be disabled
            if ($sliderDiv.hasClass('editContent')) {
                AJS.$('#frxSlider_' + frxId).slider('disable');
            }
        },

        updateFrxEditRevisionsDropdown: function (frxId) {
            // Synchronize the edit revisions select options.
            var frx = review.frx(frxId);
            var $revisionSelect = AJS.$('#changeDiffSelect' + frxId);
            if ($revisionSelect.length === 1) {
                var crucibleRevision = frx.frxRevisionToCruRevisionMap();
                $revisionSelect.find('option:disabled').prop('disabled', false);
                $revisionSelect.find(
                    AJS.$.map(frx.frxRevisions(), function (frxRevision) {
                        return 'option[value=' + crucibleRevision[frxRevision] + ']';
                    }).join()
                ).prop('disabled', true);
                // Select the option that says "select a revision to add"
                $revisionSelect[0].selectedIndex = 0;
                AJS.$('#changeDiffAddRevision' + frxId).attr(
                    'disabled',
                    $revisionSelect.find('option:enabled').length === 0
                );
            }
        },

        updateNavListClasses: function (frxId, frxAjaxResp) {
            AJS.$('#frx-list-item' + frxId + ' > span, #frx-list-item' + frxId + ' > span')
                .removeClass('frx-added frx-copied frx-deleted frx-changed frx-complete frx-incomplete')
                .addClass(frxAjaxResp.navListClasses);
        },

        /**
         * Causes an frx to be marked for immediate loading from the server. If there is a queue of frxs to be loaded, then it
         * is prepended to the front of the list, otherwise it is automatically loaded.
         * @param {Array} frxIds the ids of the frxs to load. May be a single frx id.
         * @param {Function} onDone callback to execute after each frx has been loaded
         * @param {Object} loadOpts options to pass to the server for loading of the frx
         */
        prioritisedFrxLoad: function (frxIds, onDone, loadOpts) {
            frxIds = AJS.$.makeArray(frxIds);
            // Reverse through the list to preserve original order as we push onto the front of the array
            for (var i = frxIds.length - 1; i >= 0; i--) {
                var frxId = frxIds[i];
                var queueIndex = inFrxLoadQueue(frxId);
                if (queueIndex < 0) {
                    // Push this frxId to the front of the list of loading frxs
                    FRXS_FOR_LOAD.unshift({
                        id: frxId,
                        onDone: onDone,
                        loadOpts: loadOpts,
                        rescanComments: i === 0 && !IS_AUTO_LOADING // only rescan comments for the first frx if we aren't already loading
                    });
                } else {
                    if (queueIndex > 0) {
                        // Move to the front if not already there.
                        var frxOpts = FRXS_FOR_LOAD.splice(queueIndex, 1)[0];
                        FRXS_FOR_LOAD.unshift(frxOpts);
                    }

                    // attach the passed onDone handler, to make sure the spinner is cleaned up, and navigation happens
                    var firstFrx = FRXS_FOR_LOAD[0];
                    if (onDone) {
                        var originalOnDone = firstFrx.onDone;
                        if (!originalOnDone) {
                            firstFrx.onDone = onDone;
                        } else {
                            firstFrx.onDone = function () {
                                originalOnDone();
                                onDone();
                            }
                        }
                    }
                }
            }
            if (!IS_AUTO_LOADING) {
                doSerialisedFrxLoad();
            }
        },

        /**
         * Causes an frx to be marked for loading from the server. If there is a queue of frxs to be loaded, then it
         * is pushed to the back of the list, otherwise it is automatically loaded.
         * @param {Array} frxIds the ids of the frxs to load. May be a single frx id.
         * @param {Function} onDone callback to execute after each frx has been loaded
         * @param {Object} loadOpts options to pass to the server for loading of the frx
         */
        frxLoad: function (frxIds, onDone, loadOpts) {
            frxIds = AJS.$.makeArray(frxIds);
            for (var i = 0, len = frxIds.length; i < len; i++) {
                var frxId = frxIds[i];
                var queueIndex = inFrxLoadQueue(frxId);
                if (queueIndex < 0) {
                    var frx = review.frx(frxId);

                    // Add the loading spinner to the frx
                    if (frx && !frx.isLoaded()) {
                        setFrxToBeLoadedHtml(frxId);
                    }

                    // Push this frxId to the end of the list of loading frxs
                    FRXS_FOR_LOAD.push({
                        id: frxId,
                        onDone: onDone,
                        loadOpts: loadOpts,
                        rescanComments: i === 0 && !IS_AUTO_LOADING // only rescan comments for the first frx if we aren't already loading
                    });
                }
            }
            if (!IS_AUTO_LOADING) {
                doSerialisedFrxLoad();
            }
        },

        setIsInitialFrxLoad: function () {
            IS_INITIAL_FRX_LOAD = true;
        },

        toggleFileRead: function (frxId, force) {
            var frx = review.frx(frxId);
            if (!frx) {
                return;
            }
            var oldStatus = frx.readStatus();

            if (oldStatus === 'read' || (oldStatus === 'unread' && review.autoMarkFilesRead())) {
                res.markFile(false, frxId);
            } else {
                res.markFile(true, frxId, force);
            }
        },

        changeFileReadStatusClass: function (frxId, markAsRead, newStatus) {
            var frx = review.frx(frxId);
            // sanity check
            if (!frx) {
                return;
            }
            var $frxControls = AJS.$('#frxControls' + frxId);
            var oldStatus = frx.readStatus();
            if (oldStatus === newStatus) {
                return;
            }
            $frxControls.removeClass(oldStatus).addClass(newStatus);
            var toggleCompleteSelectors = "#frx-list-item" + frxId + " > span.frx," +
                "#frx-list-item" + frxId + " > span.folder," +
                "#frxouter" + frxId;
            var $frxElems = AJS.$(toggleCompleteSelectors);
            if (markAsRead) {
                $frxElems.removeClass("frx-incomplete")
                    .addClass("frx-complete");
            } else {
                $frxElems.addClass("frx-incomplete")
                    .removeClass("frx-complete");
            }

            frx.setReadStatus(newStatus);

            // if we're filtering on unreviewed, we need to
            // update the styling in the navigation pane
            CRU.FRX.filterFrxs([frx]);
        },

        updateFileReadStatus: function (frxId, permaId, markAsRead) {
            var frx = review.frx(frxId);
            var oldStatus = frx.readStatus();
            var newStatus = markAsRead ? 'read' : (review.autoMarkFilesRead() ? 'leaveUnread' : 'unread');
            if (!review.writable() || frx.isReadStatusLocked() || oldStatus === newStatus) {
                return false;
            }
            // Prevent simultaneous requests.
            frx.lockReadStatus();

            var $frxControls = AJS.$('#frxControls' + frxId)
                .removeClass(oldStatus)
                .addClass('readStatusLocked');

            var done = function (resp) {
                $frxControls.removeClass('readStatusLocked');
                if (resp.worked) {
                    res.changeFileReadStatusClass(frxId, markAsRead, newStatus);
                } else {
                    $frxControls.addClass(oldStatus);
                }
                frx.unlockReadStatus();
            };

            var url = CRU.UTIL.jsonUrlBase(permaId) + '/fileReadStatusAjax/';
            var params = {"frxId": frxId, "markAsRead": markAsRead};

            FECRU.AJAX.ajaxDo(url, params, done);

            return false;
        },

        markFile: function (read, frxId, force) {
            if (read && review.isDraft()) {
                return;
            }
            var frx = review.frx(frxId);
            if (!frx) {
                return;
            }
            var leaveUnread = frx.readStatus() === 'leaveUnread'; // with manual complete, this is never true
            if (!read || !leaveUnread || force) {
                res.updateFileReadStatus(frxId, permaId, read);
            }
        },

        toggleSourceType: function (permaId, frxId, showAnnotation, params, handler) {
            CRU.FRX.dimFrx(frxId);
            var url = CRU.UTIL.jsonUrlBase(permaId) + '/toggleSourceTypeAjax';
            var showAnnotationStr = '';
            var $dof = AJS.$('#diffOptionsForm');
            var $diffContextToggle = AJS.$('#diffControlsToggle' + frxId);

            reviewUtil.triggerSourceCodeReset(frxId);

            var onComp = function (origRequest) {
                if (!origRequest.worked) {
                    CRU.FRX.unDimFrx(frxId);
                } else {
                    res.shelveFrxControls(frxId);
                    var $frxOuter = AJS.$('#frxouter' + frxId);
                    $frxOuter.html(origRequest.payload);
                    res.unshelveFrxControls(frxId);
                    res.reloadFrxModel(frxId, origRequest, true);
                    commentator.setCommentWidths(null, true);
                    commentator.reloadFrxCommentCount(review.frx(frxId));
                    res.updateFrxDiffControls(frxId, origRequest);
                    rebindEventsAndRefreshComments(frxId);
                    CRU.COMMENT.NAV.visibleCommentsChanged();
                    $frxOuter.trigger('diff-mode-changed');
                    reviewUtil.triggerSourceCodeShown(frxId);
                    if (handler) {
                        handler(origRequest);
                    }
                }
            };
            if (showAnnotation) {
                showAnnotationStr = '&showAnnotation=true';
                $dof.hide();
                $diffContextToggle.hide();
            } else {
                $dof.show();
                $diffContextToggle.show();
            }
            var pars = 'frxid=' + frxId + showAnnotationStr + params;
            FECRU.AJAX.ajaxUpdate(url, pars, null, onComp);
            return false;
        }
    };
    return res;
})(CRU.REVIEW.UTIL);
/*[{!frx_ajax_js_9miu51r!}]*/;
/* END /2static/script/cru/review/frx/frx-ajax.js */
/* START /2static/script/cru/review/frx/frx-nav.js */
CRU.FRX.NAV = {};

(function (reviewUtil) {

    var currentFrxId = null;

    function asFrxId(frxHandle) {
        if (frxHandle instanceof AJS.$) {
            frxHandle = frxHandle[0];
        }
        if (!frxHandle) {
            return null;
        } else if (frxHandle.nodeType) {
            return frxHandle.id.replace(/(frxouter|frxinner)/, '');
        } else if (typeof frxHandle === 'string') {
            return frxHandle;
        }
        return null;
    }

    CRU.FRX.NAV.setCurrentFrxAndScroll = function (frxHandle, options) {
        CRU.FRX.NAV.setCurrentFrx(frxHandle, AJS.$.extend({
            scroll: true
        }, options || {}));
    };

    CRU.FRX.NAV.setCurrentFrx = function (frxHandle, options) {
        var cruFrx = CRU.FRX;
        var cruFrxAjax = cruFrx.AJAX;
        var cruFrxNav = cruFrx.NAV;

        options = AJS.$.extend({
            scroll: false,
            gotoTop: false,
            changeHash: true
        }, options);

        var currentFrx = review.frx(currentFrxId);
        var frxId = asFrxId(frxHandle);

        if (currentFrxId !== frxId) {
            reviewUtil.triggerSourceCodeHidden(currentFrxId);

            if (currentFrxId !== null) {
                currentFrx && currentFrx.setLastScrollTop(CRU.UI.getReviewContentScrollTopPosition());
                var $currentOuter = AJS.$(cruFrxNav.getCurrentFrxElement());
                cruFrx.frxDeactivated($currentOuter[0]);
                AJS.$(document).trigger('frx-deactive', [frxId]);
            }

            currentFrxId = frxId;

            cruFrx.dimFrxContent();
            //trick to force rendering The Dimmer Spinner
            setTimeout(function() {
                if (frxId !== null) {
                    var $itemOuter = AJS.$(cruFrxNav.getCurrentFrxElement());

                    cruFrx.frxActivated($itemOuter[0], {
                        changeHash: options.changeHash
                    });

                    var frx = review.frx(frxId);
                    if (frx && frx.isLoaded()) {
                        if (frxId !== 'generalComments') {
                            reviewUtil.triggerSourceCodeShown(frxId);
                        }

                        if (review.autoMarkFilesRead()) {
                            cruFrxAjax.markFile(true, frxId);
                        }

                        if (options.scroll) {
                            if (!options.gotoTop) {
                                CRU.UI.scrollReviewContentTo(frx.getLastScrollTop());
                            } else {
                                frx.setLastScrollTop(0); // get's re-executed from the hashchange event handler
                                CRU.UI.scrollReviewContentTo(0);
                            }
                        }
                    }
                }
                cruFrx.unDimFrxContent();
                scrollNavigationTreeToFrxLink(frxId);
            }, 0);
        } else {
            // Process the options on the current FRX.
            if (options.scroll) {
                if (currentFrx && currentFrx.isLoaded()) {
                    CRU.UI.scrollReviewContentTo(currentFrx.getLastScrollTop());
                } else {
                    CRU.UI.scrollToElement(cruFrxNav.getCurrentFrxElement());
                }
            }
        }

        review.recentlyViewedFrxIds.save(currentFrxId);
    };

    var scrollNavigationTreeToFrxLink = function (frxId) {
        var scrollToId = frxId === 'generalComments' ? 'frx-overview' : ('frx-list-item' + frxId);
        var threshold = 40;
        var $link = AJS.$('#' + scrollToId);
        if ($link.filter(':in-viewport-vert(' + threshold + ', content-navigation-panel)').length === 0) {
            var offset = -threshold;
            if ($link.filter(':above-the-top(' + threshold + ', content-navigation-panel)').length === 0) {
                offset = threshold - AJS.$('#content-navigation-panel').height();
            }
            AJS.$('#content-navigation-panel').scrollTo($link[0], {
                axis: 'y',
                offset: offset
            });
        }
    };

    CRU.FRX.NAV.visibleFrxsChanged = function () {
        var cruFrx = CRU.FRX;
        var cruFrxNav = cruFrx.NAV;

        // We always have at least the general comments.
        var frxs = [document.getElementById("generalComments")];
        AJS.$.each(review.frxs(), function () {
            frxs.push.apply(frxs, this.frxOuter().get());
        });

        if (currentFrxId) {
            if (AJS.$.inArray(cruFrxNav.getCurrentFrxElement(), frxs) < 0) {
                cruFrxNav.setCurrentFrx(frxs[0]);
            }
        } else {
            cruFrxNav.setCurrentFrx(frxs[0]);
        }
        AJS.$(window).trigger('panes-resized');
        AJS.$('#navigation-tree .file-count').text(review.frxs().length);
    };

    CRU.FRX.NAV.getCurrentFrxId = function () {
        return currentFrxId;
    };

    CRU.FRX.NAV.getCurrentFrxElement = function () {
        if (currentFrxId) {
            var domId = currentFrxId === 'generalComments' ? 'generalComments' : 'frxouter' + currentFrxId;
            return AJS.$('#' + domId)[0];
        } else {
            return null;
        }
    };

    var defaultOpts = {
        destination: 'first',
        skipCompleteFrxs: false
    };

    /**
     * @param {String} opts.destination location to scroll to - may be <tt>first</tt>, <tt>last</tt>, <tt>previous</tt> or <tt>next</tt>.
     * @param {String} opts.frxId the frx id of the frx to scroll to. This value is ignored if the <tt>opts.destination</tt> is <tt>first</tt> or <tt>last</tt>.
     * @param {Boolean} opts.skipCompleteFrxs if true, frxs which have been marked as complete will be passed over and ignored.
     */
    CRU.FRX.NAV.gotoFrx = function (opts) {
        var frx = review.frx(opts.frxId);
        // if the frx is loaded, just go to it
        if (!frx || frx.isLoaded()) {
            scrollToFrx(opts);
            return;
        }

        // otherwise, we must make sure to load the frx first
        var onComp = function () {
            commentator.setCommentWidths(null, true);
            scrollToFrx(opts);
        };
        CRU.FRX.AJAX.prioritisedFrxLoad(opts.frxId, onComp);
    };

    CRU.FRX.NAV.getGotoFrxId = function (opts) {
        return getScrollToFrxId(opts);
    };

    /**
     * Scroll to a comment form if one exists inside the current frx
     *
     */
    CRU.FRX.NAV.scrollToCommentForm = function () {
        var frxId = CRU.FRX.NAV.getCurrentFrxId();

        //if there is a comment form open, scroll to it
        var forms = commentator.getDisplayingForms();
        for (var i = 0, len = forms.length; i < len; i++) {
            var $form = forms[i].getForm();
            var $frxouter = $form.closest('.frxouter');
            if ($frxouter.length > 0) {
                var commentFormFrxId = $frxouter.attr('id').replace('frxouter', '');
                if (commentFormFrxId === frxId) {
                    //scroll to it
                    CRU.UI.scrollToElement($form, {
                        offset: 55
                    });
                    $form.find('.commentTextarea').focus();
                    break;
                }
            }
        }
    };

    CRU.FRX.NAV.checkFrxAnchor = function () {
        var frxId;
        if (/^#CFR-\d+/.test(window.location.hash)) {
            frxId = window.location.hash.replace(/^#CFR-(\d+).*$/, '$1');
            if (review.frx(frxId)) {
                CRU.FRX.NAV.setCurrentFrxAndScroll(frxId, {
                    initialScroll: true
                });
                return frxId;
            } else {
                window.location.hash = '';
                CRU.FRX.NAV.setCurrentFrxAndScroll('generalComments', {
                    initialScroll: true
                });
            }
        }
    };

    CRU.FRX.NAV.frxDiffLoaded = function (frxId) {
        // For some reason frxId here is a number (not a string as currentFrxId).
        // Just not to break the app I'm going to cast frxId to string and then compare.
        if (currentFrxId === String(frxId)) {
            AJS.$(window).trigger('panes-resized');
            AJS.$('#frxinner' + frxId).trigger('current-frx-loaded');
            reviewUtil.triggerSourceCodeShown(frxId);
        }
    };

    var scrollToFrx = function (settings) {
        var frxId = getScrollToFrxId(settings);
        if (frxId) {
            CRU.FRX.NAV.setCurrentFrxAndScroll(frxId);
        }
    };

    /*eslint-disable complexity*/
    var getScrollToFrxId = function (settings) {
        var opts = {};

        AJS.$.extend(opts, defaultOpts, settings);

        var frxIds = AJS.$.merge(["generalComments"],
            AJS.$.grep(review.frxIds(), function (frxId) {
                return !review.frx(frxId).isFiltered();
            })
        );

        if (!frxIds || frxIds.length === 0) {
            return null;
        }

        var destinationFrxId = null;
        var destination = opts.destination;
        var skipCompleteFrxs = opts.skipCompleteFrxs;

        if (destination === 'first' && !skipCompleteFrxs) {
            destinationFrxId = frxIds[0];
        } else if (destination === 'last' && !skipCompleteFrxs) {
            destinationFrxId = frxIds[frxIds.length - 1];
        } else {
            // Find the source frx index in the list of frxs
            var index = -1;
            if (destination === 'last') {
                index = frxIds.length;
            } else if (destination !== 'first') {
                for (var j = 0, len = frxIds.length; j < len; j++) {
                    if (opts.frxId == frxIds[j]) { // eslint-disable-line eqeqeq
                        index = j;
                        break;
                    }
                }
            }

            // If we're iterating over unread comments, we want to keep jumping comments
            // when the comment is marked as 'read'.
            do {
                if (destination === 'previous' || destination === 'last') {
                    if (frxIds[index - 1]) {
                        destinationFrxId = frxIds[index - 1];
                        index--;
                    } else {
                        destinationFrxId = skipCompleteFrxs ? destinationFrxId : frxIds[index];
                        break;
                    }
                } else if (destination === 'next' || destination === 'first') {
                    if (frxIds[index + 1]) {
                        destinationFrxId = frxIds[index + 1];
                        index++;
                    } else {
                        destinationFrxId = skipCompleteFrxs ? destinationFrxId : frxIds[index];
                        break;
                    }
                } else {
                    destinationFrxId = frxIds[index];
                    break;
                }
                var frx = review.frx(destinationFrxId);
                var isFrxComplete = frx && frx.isComplete();
            } while (skipCompleteFrxs && isFrxComplete);
        }

        return destinationFrxId;
    };
    /*eslint-enable*/

})(CRU.REVIEW.UTIL);
/*[{!frx_nav_js_vdea51t!}]*/;
/* END /2static/script/cru/review/frx/frx-nav.js */
/* START /2static/script/cru/review/wikihelp.js */
if (!CRU.REVIEW.WIKI.HELP) {
    CRU.REVIEW.WIKI.HELP = {};
}
(function () {
    var wikiPopupShowing = false;
    var wikiPopup;


    var showPopup = function () {
        if (!wikiPopup) {
            wikiPopup = FECRU.DIALOG.create(800, 550, 'wikimarkupHelp')
                .addHeader('Wiki Markup Tips')
                .addPanel('All', AJS.$("#wiki-notation-quick").clone())
                .addButton('Full Wiki Markup', function () {
                    window.open(AJS.$("#wiki-notation-link a").attr("href"), "Full_Wiki_Markup");
                    hidePopup();

                }).addButton('Close', function () {
                    CRU.REVIEW.WIKI.HELP.hidePopup();
                });
        }
        if (!wikiPopupShowing) {
            wikiPopup.show();
            wikiPopupShowing = true;
            return false;
        }
    };

    var hidePopup = function () {
        if (wikiPopupShowing) {
            wikiPopup.hide();
            wikiPopupShowing = false;
            return false;
        }
    };
    CRU.REVIEW.WIKI.HELP = {
        popupShowing: function () {
            return wikiPopupShowing;
        },
        showPopup: showPopup,
        hidePopup: hidePopup
    };

    AJS.$(document).delegate('.wiki-help-button', 'click', function () {
        showPopup();
    });

})();
/*[{!wikihelp_js_b5zm51h!}]*/;
/* END /2static/script/cru/review/wikihelp.js */
/* START /2static/script/cru/create/create.js */
window.CRU = window.CRU || {};
CRU.CREATE = {};

(function ($) {
    var cruCreate = CRU.CREATE;

    cruCreate.changesets = {}; // map of csid -> array of revids
    cruCreate.revid2csid = {};
    cruCreate.revidsInIteration = {};
    cruCreate.repnameInUse = "";
    cruCreate.explorer = {};

    cruCreate.addLatestRevision = function (frxId, revid) {
        var done = function (resp) {
            if (resp.worked) {
                $("#frx-outdated" + frxId).hide();
            }
        };
        return cruCreate.addRevisionFromView('add', frxId, revid, done);
    };

    cruCreate.addRevisionFromView = function (command, frxId, revid, done) {
        var cruFrx = CRU.FRX;
        var frx = review.frx(frxId);
        var params = {
            "revid": revid,
            "command": command,
            "frxId": frxId,
            "attachMethod": "ITERATION",     // string value of Review.AttachMethod.ITERATION
            "fromRev": frx.visibleFromRevision(),
            "toRev": frx.visibleToRevision()
        };
        $.extend(params, CRU.FRX.diffParamsMap(frxId));

        var url = CRU.UTIL.jsonUrlBase(permaId) + "/editRevisionsFromRevisionAjax/";

        cruFrx.dimFrx(frxId);
        var onComp = function (resp) {
            if (!resp.worked) {
                cruFrx.unDimFrx(frxId);
            } else {
                if (resp.reloadReview) {
                    // we are refreshing the entire review
                    CRU.REVIEW.UTIL.reloadReview(true);
                }
                if (resp.reviewDueDate) {
                    //update review due date text
                    $('#review-meta-info .review-due-text').html(resp.reviewDueDate);
                }
                if (resp.frxExists) {
                    var cruFrxAjax = cruFrx.AJAX;
                    cruFrxAjax.shelveFrxControls(frxId);
                    $('#frxouter' + frxId).html(resp.payload);
                    cruFrxAjax.unshelveFrxControls(frxId);
                    cruFrxAjax.reloadFrxModel(frxId, resp, false);
                    cruFrxAjax.updateFrxSlider(frxId, resp);
                    cruFrxAjax.updateFrxDiffControls(frxId, resp);
                    cruFrxAjax.updateFrxEditRevisionsDropdown(frxId);
                    commentator.reloadFrxCommentCount(review.frx(frxId));
                } else {
                    cruCreate.removeFrxFromPage(frxId);
                }
            }
            if (done) {
                done({worked: resp.worked});
            }
        };
        FECRU.AJAX.ajaxUpdate(url, params, null, onComp);
        return false;
    };

    //remove an frx from the page entirely - only should be done if the file was removed from the review.
    cruCreate.removeFrxFromPage = function (frxId) {
        //remove frx
        var frx = review.frx(frxId);
        // frx may not actually be in the page for any number of reasons. do a sanity check.
        if (!frx) {
            return;
        }

        var currentlyViewing;
        var currentFrxElem = CRU.FRX.NAV.getCurrentFrxElement();
        if (currentFrxElem) {
            var currentFrxElementId = $(currentFrxElem).attr('id');
            var id = currentFrxElementId !== 'generalComments' ?
                currentFrxElementId.replace(/^frxouter/, '') :
                currentFrxElementId;

            currentlyViewing = frxId == id; // eslint-disable-line eqeqeq
        }
        review.removeFrx(frx);
        var $toRemove = $('#frx-list-item' + frxId);
        var $selectNext;
        var $toRemoveFolderSpan = $toRemove.children(".folder");
        if ($toRemoveFolderSpan.length > 0) {
            var $toRemoveFolderFrxDirItem = $toRemoveFolderSpan.children(".frx-dir-item");
            //if this is an frx with children, dont remove it, just remove the classes on it
            $toRemove.removeClass("activeFrx");
            $toRemoveFolderSpan.removeClass("frx-incomplete");
            $toRemoveFolderFrxDirItem.replaceWith($toRemoveFolderFrxDirItem.html());
            $toRemoveFolderSpan.find('.removeFrx, .spinner').remove();
            if (currentlyViewing) {
                $selectNext = $toRemove.find('.frx:first');
            }
        } else {
            while ($toRemove.hasClass('frx-list-item') && $toRemove.siblings().length === 0) {
                if ($toRemove.parent().attr('id') === 'tree-root') {
                    break;
                }
                var _$toRemove = $toRemove.parents('.frx-list-item:first');
                if (_$toRemove.length === 1) {
                    $toRemove = _$toRemove;
                } else {
                    break;
                }
            }
            //get next frx to select
            if (currentlyViewing) {
                $selectNext = $toRemove.next().find('.frx:first');
            }
            if ($toRemove) {
                $toRemove.remove();
            }
        }

        if (currentlyViewing) {
            if ($selectNext.length !== 1) {
                $selectNext = $('#navigation-tree .frx').filter(':last');
            }
            if ($selectNext.length !== 1) {
                $('#scroll-to-general-comments').click();
            } else {
                $selectNext.find('.scroll-to-frx').click();
            }
        }
        $('#frxouter' + frxId).remove();
        $('#frxControlsContainer' + frxId).remove();

        CRU.FRX.NAV.visibleFrxsChanged();
        CRU.COMMENT.NAV.visibleCommentsChanged();
    };

    cruCreate.retrieveNewFrxs = function (done) {
        var url = CRU.UTIL.jsonUrlBase(permaId) + "/retrieveNewFrxsAjax/";

        var onComp = function (resp) {
            if (resp.worked) {
                var activeTreeElem = $('#navigation-tree .activeFrx').attr('id');
                $('#navigation-tree').html(resp.navTree);
                $('#navigation-tree .activeFrx').removeClass('activeFrx');
                $('#' + activeTreeElem).addClass('activeFrx');
                AJS.$.each(review.frxs(), function (idx, frx) {
                    frx.invalidateCachedSelectors();
                });

                var insertAfter = 'generalComments';
                var frxs = resp.frxs;
                var frxIds = [];
                for (var i = 0, len = frxs.length; i < len; i++) {
                    var frxId = frxs[i].frxId;
                    var frxHtml = frxs[i].frxHtml;
                    if (!review.frx(frxId)) {
                        $(frxHtml).insertAfter('#' + (insertAfter !== 'generalComments' ? 'frxouter' + insertAfter : insertAfter));
                        eval('var frxModelLoader = ' + frxs[i].frxModelLoader);
                        frxModelLoader(insertAfter);
                        frxIds.push(frxId);
                    }
                    if (review.frx(frxId)) {
                        insertAfter = frxId;
                    }
                }

                if (done) {
                    done();
                }

                CRU.FRX.AJAX.prioritisedFrxLoad(frxIds);
            }
        };

        FECRU.AJAX.ajaxUpdate(url, {}, null, onComp);
        return false;

    };

    var addRemoveRevisionToIter = function (add, revid) {
        var busyid = "busyRev" + revid;
        var nochangeid = "";
        var $revPath = $("#revPath" + revid);
        toggleNodeAndImage(busyid, true, false, true);
        if (add) {
            toggleNodeAndImage("addRev" + revid, false, true, true);
            nochangeid = "addRev" + revid;
            $revPath.css("textDecoration", "");
        } else {
            toggleNodeAndImage("remRev" + revid, false, true, true);
            nochangeid = "remRev" + revid;
            $revPath.css("textDecoration", "line-through");
        }
        var params = {
            "revid": revid,
            "command": add ? "add" : "remove",
            "attachMethod": $("#attachMethod").val(),
            "fromRevision": $("#fromRevision").val()
        };
        var url = CRU.UTIL.jsonUrlBase(permaId) + "/editRevisionsAjax/";
        return doAddRemoveCall(url, params, busyid, nochangeid);
    };

    cruCreate.addRevisionToIter = function (revid) {
        addRemoveRevisionToIter(true, revid);
    };

    cruCreate.removeRevisionFromIter = function (revid) {
        addRemoveRevisionToIter(false, revid);
    };

    cruCreate.addAllSearchRevisions = function (url, spinnerId) {
        $('#' + spinnerId).css('display', 'inline');
        url += "&command=addSearch";
        url += "&search=" + $("#qlStr").val();
        url += "&spage=" + $("#results.thisPageNum").val();
        url += "&attachMethod=" + $("#attachMethod").val();
        url += "&fromRevision=" + $("#fromRevision").val();
        FECRU.XSRF.postUri(url);
    };

    var doAddMultipleCall = function (url, params) {
        var done = function (resp) {
            if (!resp.worked || FECRU.AJAX.checkError(resp)) {
                return false;
            }
            updateRespMsgBusy(resp.msgHtml);

            var updatedChangesets = {};

            $.each(resp.addedRevids, function () {
                var addedRevid = this;
                updatedChangesets[cruCreate.revid2csid[addedRevid]] = 1;
                cruCreate.revidsInIteration[addedRevid] = 1;
                toggleNodeAndImage("addRev" + addedRevid, false, true, true);
                toggleNodeAndImage("remRev" + addedRevid, true, false, true);
            });
            for (var csid in updatedChangesets) {
                if (updatedChangesets.hasOwnProperty(csid)) {
                    updateChangesetAddRemove(csid);
                }
            }
        };

        FECRU.AJAX.ajaxDo(url, params, done);
    };

    cruCreate.addRevisionsToIter = function (permaId, revIdArray) {
        $.each(revIdArray, function () {
            $("#revPath" + this).css("textDecoration", "");
        });
        var params = {
            "revid": revIdArray,
            "command": "add",
            "attachMethod": $("#attachMethod").val(),
            "fromRevision": $("#fromRevision").val()
        };
        var url = CRU.UTIL.jsonUrlBase(permaId) + "/editRevisionsAjax/";

        return doAddMultipleCall(url, params);
    };


    var doAddRemoveCall = function (url, params, busyid, nochangeid, extraDone) {
        var done = function (resp) {
            if (!resp.worked || FECRU.AJAX.checkError(resp)) {
                toggleNodeAndImage(busyid, false, true, true);
                toggleNodeAndImage(nochangeid, true, false, true);
                return false;
            }
            updateRespMsgBusy(resp.msgHtml);

            var updatedChangesets = {};

            toggleNodeAndImage(busyid, false, true, true);
            toggleNodeAndImage(nochangeid, true, false, true);

            $.each(resp.addedRevids, function () {
                updatedChangesets[cruCreate.revid2csid[this]] = 1;
                cruCreate.revidsInIteration[this] = 1;
                toggleNodeAndImage("addRev" + this, false, true, true);
                toggleNodeAndImage("remRev" + this, true, false, true);
            });
            $.each(resp.removedRevids, function () {
                updatedChangesets[cruCreate.revid2csid[this]] = 1;
                cruCreate.revidsInIteration[this] = 0;
                toggleNodeAndImage("addRev" + this, true, false, true);
                toggleNodeAndImage("remRev" + this, false, true, true);
            });

            for (var csid in updatedChangesets) {
                if (updatedChangesets.hasOwnProperty(csid)) {
                    updateChangesetAddRemove(csid);
                }
            }

            extraDone && extraDone(resp);
        };

        FECRU.AJAX.ajaxDo(url, params, done);
    };

    /**
     *
     * @param csid
     * @param showRemove show a tick / everything is already in review
     * @param showSome show an orange box / some items are in review
     * @param showAdd show an empty box / no items are in review
     */
    var updateChangesetAddRemove = function (csid, showRemove, showSome, showAdd) {
        var revids = cruCreate.changesets[csid];
        if (!showRemove && !showSome && !showAdd) {
            if (!revids) {
                return;
            }
            var inCount = 0;
            $.each(revids, function () {
                if (cruCreate.revidsInIteration[this] == 1) { // eslint-disable-line
                    inCount++;
                }
            });
            showAdd = inCount < revids.length;
            showRemove = inCount > 0;
            showSome = showAdd && showRemove;
            if (showSome) {
                showAdd = false;
                showRemove = false;
            }
        }
        var $csidLi = AJS.$("#csid-" + csid);
        var isMetadataOnlyChange = $csidLi.data('metadataonlychange');
        var isPartialMetadataChange = $csidLi.data('partialmetadatachange');

        //partial metadata changes will never fully be selected
        showSome = showSome || (showRemove && isPartialMetadataChange);
        //partial metadata changes will never be fully selected
        showRemove = showRemove && !isPartialMetadataChange;
        //metadata only changes will never show the add all checkbox state
        showAdd = showAdd && !isMetadataOnlyChange;

        toggleNodeAndImage("addCs" + csid, showAdd, !showAdd, true);
        toggleNodeAndImage("remCs" + csid, showRemove, !showRemove, true);
        toggleNodeAndImage("containsSome" + csid, showSome, !showSome, true);
        toggleNodeAndImage("metadataOnlyCs" + csid, isMetadataOnlyChange, !isMetadataOnlyChange, true);
    };

    cruCreate.addChangesetToIter = function (csid) {
        addRemoveChangesetToIter(true, csid);
    };

    cruCreate.removeChangesetFromIter = function (csid) {
        addRemoveChangesetToIter(false, csid);
    };

    var addRemoveChangesetToIter = function (add, csid) {
        var addCsIsHidden = $("#addCs" + csid).is(":hidden");
        var isPartialMetadataChange = $("#csid-" + csid).data("partialmetadatachange");

        // used to revert the spinner
        var showRemove = !add;
        var showSome = add && addCsIsHidden;
        var showAdd = add && !addCsIsHidden;

        var busyid = "busyCs" + csid;
        var nochangeid = "";
        if (!add) {
            if (isPartialMetadataChange) {
                nochangeid = "containsSome" + csid;
            } else {
                nochangeid = "remCs" + csid;
            }
        } else if (addCsIsHidden) {
            nochangeid = "containsSome" + csid;
        } else {
            nochangeid = "addCs" + csid;
        }
        toggleNodeAndImage(nochangeid, false, true, true);
        toggleNodeAndImage(busyid, true, false, true);

        var params = {
            "csid": csid,
            "command": add ? "add" : "remove",
            "sourceName": cruCreate.repnameInUse,
            "attachMethod": $("#attachMethod").val(),
            "fromRevision": $("#fromRevision").val()
        };

        var url = CRU.UTIL.jsonUrlBase(permaId) + '/editRevisionsAjax/';

        var done = function (resp) {
            if (!!resp.csReviewState) { // otherwise revert the spinner
                showRemove = resp.csReviewState === 'FULL';
                showSome = resp.csReviewState === 'PARTIAL';
                showAdd = resp.csReviewState === 'NONE';
            }
            updateChangesetAddRemove(csid, showRemove, showSome, showAdd);
        };

        doAddRemoveCall(url, params, busyid, nochangeid, done);
    };

    cruCreate.removeAllRevs = function (done) {
        var pars = 'command=removeAll&sourceName=' + cruCreate.repnameInUse;
        var url = CRU.UTIL.jsonUrlBase(permaId) + '/editRevisionsAjax/';
        doAddRemoveCall(url, pars, null, null, done);
    };

    cruCreate.addSearchFileRevToReview = function (revisionId) {
        addRemoveRevisionToIter(true, revisionId);
    };

    cruCreate.removeSearchFileRevToReview = function (revisionId) {
        addRemoveRevisionToIter(false, revisionId);
    };

    cruCreate.dirListRevs = [];

    //this is for the file browse tab
    cruCreate.addFileRevisionToReview = function (latestRevId) {
        var newSelectedRevId = document.forms["selectRevisionForm" + latestRevId].revId.value;
        addRemoveFileRevisionReview(true, newSelectedRevId, latestRevId);
    };

    cruCreate.removeFileRevisionFromReview = function (latestRevId) {
        var newSelectedRevId = document.forms["selectRevisionForm" + latestRevId].revId.value;
        addRemoveFileRevisionReview(false, newSelectedRevId, latestRevId);
    };

    var addRemoveFileRevisionReview = function (add, revid, latestRevId, onEval) {
        var busyid = "busyRev" + latestRevId;
        var nochangeid = "";
        toggleNodeAndImage(busyid, true, false, true);
        if (add) {
            toggleNodeAndImage("addRev" + latestRevId, false, true, true);
            nochangeid = "addRev" + latestRevId;
        } else {
            toggleNodeAndImage("remRev" + latestRevId, false, true, true);
            nochangeid = "remRev" + latestRevId;
        }

        var params = {
            "revid": revid,
            "sourceName": cruCreate.repnameInUse,
            "command": add ? "add" : "remove",
            "attachMethod": $("#attachMethod").val(),
            "fromRevision": $("#fromRevision").val()
        };
        var url = CRU.UTIL.jsonUrlBase(permaId) + '/editRevisionsAjax/';

        return doAddRemoveFRCall(url, params, busyid, nochangeid, latestRevId, onEval);
    };

    var doAddRemoveFRCall = function (url, params, busyid, nochangeid, latestRevId, onEval) {
        var done = function (resp) {
            try {
                // take out the spinner image regardless of what the response is
                toggleNodeAndImage(busyid, false, true, true);
                toggleNodeAndImage(nochangeid, true, false, true);
                if (!resp.worked || FECRU.AJAX.checkError(resp)) {
                    return false;
                }
                updateRespMsgBusy(resp.msgHtml);
                //todo fix this looks wrong
                for (var i = 0; i < resp.removedRevids.length; i++) {
                    cruCreate.dirListRevs[latestRevId] = "";
                    toggleNodeAndImage("addRev" + latestRevId, true, false, true);
                    toggleNodeAndImage("remRev" + latestRevId, false, true, true);
                }
                for (i = 0; i < resp.addedRevids.length; i++) {
                    cruCreate.dirListRevs[latestRevId] = resp.addedRevids[i];
                    toggleNodeAndImage("addRev" + latestRevId, false, true, true);
                    toggleNodeAndImage("remRev" + latestRevId, true, false, true);
                }
                if (onEval) {
                    onEval();
                }
            } catch (error) {
                window.alert(error);
            }
        };

        FECRU.AJAX.ajaxDo(url, params, done);
    };

    var loadFullHistoryDropdown = function (latestRevId) {
        var url = CRU.UTIL.jsonUrlBase(permaId) + '/loadFullHistoryDropdownAjax/';
        var params = {"latestRevId": latestRevId};
        var elementIdToUpdate = "selectDiff" + latestRevId;

        return FECRU.AJAX.ajaxUpdate(url, params, elementIdToUpdate);
    };

    cruCreate.updateSelectedRev = function (latestRevId) {
        var selectBox = document.forms["selectRevisionForm" + latestRevId].revId;
        var formval = selectBox.value;
        if (formval === "__LOADFULL__") {
            FECRU.AJAX.startSpin(selectBox, "", true);
            loadFullHistoryDropdown(latestRevId);
            return;
        }
        var onEval = function () {
            addRemoveFileRevisionReview(true, formval, latestRevId);
        };
        addRemoveFileRevisionReview(false, cruCreate.dirListRevs[latestRevId], latestRevId, onEval);
    };

    /* patch file revision functions */
    cruCreate.patches = [];
    cruCreate.patchesInc = [];
    cruCreate.patchRevs = [];
    cruCreate.incPatchRevs = [];

    cruCreate.addAllPatch = function (patchId) {
        addRemoveAllPatch(true, patchId);
    };

    cruCreate.removeAllPatch = function (patchId) {
        addRemoveAllPatch(false, patchId);
    };

    // must match Source.SEPARATOR
    cruCreate.SOURCE_SEPARATOR = ":";

    var addRemoveAllPatch = function (add, patchID) {
        var incRevs = cruCreate.patchesInc[patchID];
        var revs = cruCreate.patches[patchID];
        $("#addAll" + patchID).hide();
        $("#remAll" + patchID).hide();
        $("#containsSome" + patchID).hide();
        $("#busy" + patchID).show();

        var params = {
            "revid": cruCreate.patches[patchID],
            "command": add ? "add" : "remove"
        };

        var url = CRU.UTIL.jsonUrlBase(permaId) + '/editRevisionsAjax/';

        var done = function (resp) {
            var remRev = function (revId) {
                incRevs[revId] = "";
            };
            var addRev = function (revId) {
                incRevs[revId] = revId;
            };
            updateRespMsgBusy(resp, "busy" + patchID);
            if (resp.worked) {
                updateRevTicks(resp.removedRevids, true, remRev);
                updateRevTicks(resp.addedRevids, false, addRev);
            }
            cruCreate.setAddRemAll(patchID, incRevs, revs);
        };

        FECRU.AJAX.ajaxDo(url, params, done);
    };

    cruCreate.setAddRemAll = function (patchID, incRevs, revs) {
        var $addAll = $("#addAll" + patchID).hide();
        var $remAll = $("#remAll" + patchID).hide();
        var $hasSome = $("#containsSome" + patchID).hide();

        var count = countSelected(incRevs);
        if (count === 0) {
            $addAll.show();
        } else if (count < revs.length) {
            $hasSome.show();
        } else {
            $remAll.show();
        }
    };

    var countSelected = function (incRevs) {
        if (!incRevs) {
            return 0;
        }

        var count = 0;
        for (var i = 0, len = incRevs.length; i < len; i++) {
            if (incRevs[i]) {
                count++;
            }
        }
        return count;
    };

    var updateRespMsgBusy = function (resp, busyId) {
        if (resp.worked) {
            resp.msgHtml && $("#messages").html(resp.msgHtml);
        }
        resp.errors && $("#error-container").html(resp.errors);
        if (busyId) {
            $("#" + busyId).hide();
        }
    };

    var updateRevTicks = function (ids, removed, forEachFunc) {
        $.each(ids, function () {
            if (removed) {
                $("#addRev" + this).show();
                $("#remRev" + this).hide();
            } else {
                $("#addRev" + this).hide();
                $("#remRev" + this).show();
            }
            if (forEachFunc) {
                forEachFunc(this);
            }
        });
    };

    cruCreate.addRemoveFileRevision = function (add, revid, imgPostfix, sourceName) {
        var create = cruCreate;
        var patchID = sourceName.split(create.SOURCE_SEPARATOR)[1];
        var incRevs = create.patchesInc[sourceName];
        var revs = create.patches[sourceName];
        var busyId = "busyRev" + imgPostfix;
        $("#addRev" + imgPostfix).hide();
        $("#remRev" + imgPostfix).hide();
        $("#" + busyId).show();

        var params = {
            "revid": revid,
            "command": add ? "add" : "remove"
        };

        var url = CRU.UTIL.jsonUrlBase(permaId) + "/editRevisionsAjax/";

        var done = function (resp) {
            var remRev = function (revId) {
                if (incRevs) {
                    incRevs[revId] = "";
                }
            };
            var addRev = function (revId) {
                if (incRevs) {
                    incRevs[revId] = revId;
                }
            };
            updateRespMsgBusy(resp, busyId);
            var resetCheckbox = function () {
                if (add) {
                    $("#addRev" + imgPostfix).show();
                } else {
                    $("#remRev" + imgPostfix).show();
                }
            };
            if (resp.worked) {
                updateRevTicks(resp.removedRevids, true, remRev);
                updateRevTicks(resp.addedRevids, false, addRev);
                if (resp.hasErrors) {
                    $("#error-container").html(resp.errors);
                    resetCheckbox();
                } else {
                    $("#error-container").html("");
                }
            } else {
                resetCheckbox();
            }
            create.setAddRemAll(patchID, incRevs, revs);
        };

        FECRU.AJAX.ajaxDo(url, params, done);
    };

    cruCreate.storeStickyPreference = function (key, value) {
        var params = {
            "key": key,
            "value": value
        };
        var url = CRU.UTIL.jsonUrlBase(permaId) + "/storeStickyPreferenceAjax/";

        FECRU.AJAX.ajaxDo(url, params);
    };

    cruCreate.setSpecificDiffVisible = function (attachMethod) {
        if (attachMethod === 'SPECIFIC_DIFF') {
            $('#specificDiff').show();
        } else {
            $('#specificDiff').hide();
        }
        cruCreate.storeStickyPreference('attachMethod', attachMethod);
    };

    cruCreate.submitDetailsForm = function () {
        var cruReviewUtil = CRU.REVIEW.UTIL;
        cruReviewUtil.postEditDetailsForm(function () {
            cruReviewUtil.reloadReview(true, function () {
                cruReviewUtil.unblockReviewUpdatePolling();
            });

            CRU.FRX.AJAX.unblockFrxLoading();
            CRU.UNSAVED.watchForUnsavedChanges();
        });
    };

    cruCreate.submitDetailsFormAndStart = function (done) {
        //reload the entire page for now - wont have to refresh when we can update via polling
        var approve = function () {
            if (done) {
                done();
            }
            CRU.UTIL.stateTransition('action:approveReview', permaId);
        };
        CRU.REVIEW.UTIL.postEditDetailsForm(approve);
    };

    cruCreate.markChanged = function () {
        CRU.UTIL.editDetailsFormChange = true;
    };

    cruCreate.checkEditForm = function (done) {
        return CRU.UTIL.checkEditForm(done);
    };

    cruCreate.cleanPlaceholders = function ($form) {
        $form.find("input").each(function () {
            var $this = $(this);
            if ($this.isPlaceholded()) {
                $this.val("");
            }
        });
    };

    cruCreate.checkEditAndSubmitThis = function (formElement) {
        var submitter = function () {
            var form = formElement.form || (formElement[0] && formElement[0].form);
            cruCreate.cleanPlaceholders($(form));
            $(form).submit();
        };
        FECRU.UI.swapDatesIfReversed(function (dateString) {
            return dateString.substring(0, dateString.indexOf("T"));
        });
        cruCreate.checkEditForm(submitter);
    };

    cruCreate.command = function (cmd, pid, button) {
        CRU.UTIL.command(cmd, pid, button);
    };

    //This validates the saneness of the team selection removing and disabling the
    //selection of author and moderator as reviewers.
    cruCreate.validateTeamSelection = function () {
        var form = document.editDetailsForm;
        var mod = form.newModerator.value;
        var auth = form.newAuthor.value;
        var reviewers = form.reviewers;
        if (reviewers) {
            for (var i = 0, len = reviewers.length; i < len; i++) {
                var reviewer = reviewers[i];
                if (reviewer.value === mod || reviewer.value === auth) {
                    reviewer.checked = false;
                    reviewer.disabled = true;
                } else {
                    reviewer.disabled = false;
                }
            }
        } else if (reviewers) {
            reviewers.checked = false;
            reviewers.disabled = true;
        }
    };

    cruCreate.addInvitee = function () {
        var $input = $("#inviteeInput");
        var invitee = $input.val();
        if (!invitee) {
            return;
        }
        var $invitees = $("#inviteeSpan");

        var $newInvitee = $("<input name='invitees' type='checkbox' checked='checked' tabindex='8'>")
            .val(invitee);

        var $textSpan = $("<span>" + invitee + "; </span>");

        var $newSpan = $("<span id='inv_" + invitee + "'></span>")
            .append($newInvitee)
            .append($textSpan);

        $invitees.append($newSpan);

        CRU.UTIL.editDetailsFormChange = true;
        $input.val('');
    };

    cruCreate.loadChangesets = function ($container, $activityLoading, $newerActivityBtn, explorer, callback) {
        if (cruCreate.explorer.loading) {
            return false;
        }
        cruCreate.explorer.loading = true;

        $.extend(cruCreate.explorer, explorer);

        function isNavigatePast() {
            return cruCreate.explorer.navigate === "past";
        }

        function isNavigateFuture() {
            return cruCreate.explorer.navigate === "future";
        }

        var url = AJS.contextPath() + "/cru/" + encodeURI(permaId) + "/edit-changelog-ajax";
        if (cruCreate.explorer.wbUrl) {
            url += cruCreate.explorer.wbUrl;
        } else {
            url += cruCreate.explorer.wbSpec + "/" + cruCreate.explorer.fullPath;
        }

        if (isNavigatePast()) {
            if (cruCreate.explorer.nextInPast) {
                url += "?toid=" + encodeURI(cruCreate.explorer.nextInPast) + "&inc=" + encodeURI(cruCreate.explorer.nextInPastIsInc);
            } else {
                delete cruCreate.explorer.navigate;
                cruCreate.explorer.loading = false;
                return false;
            }
        } else if (isNavigateFuture()) {
            if (cruCreate.explorer.nextInFuture) {
                url += "?fromid=" + encodeURI(cruCreate.explorer.nextInFuture) + "&inc=" + encodeURI(cruCreate.explorer.nextInFutureIsInc);
            } else {
                delete cruCreate.explorer.navigate;
                cruCreate.explorer.loading = false;
                return false;
            }
        } else {
            if (cruCreate.explorer.jumptoid) {
                url += "?jumptoid=" + cruCreate.explorer.jumptoid;
            }

            $container.html('');
        }

        $activityLoading.show();
        FECRU.AJAX.ajaxUpdate(url, {}, null, function (response) {
            $activityLoading.hide();
            if (isNavigatePast()) {
                if (response.size) {
                    $container.append(response.payload);
                }
                cruCreate.explorer = $.extend(response.explorer, {
                    nextInFuture: cruCreate.explorer.nextInFuture,
                    nextInFutureIsInc: cruCreate.explorer.nextInFutureIsInc
                })
            } else if (isNavigateFuture()) {
                if (response.size) {
                    $container.prepend(response.payload);
                }

                cruCreate.explorer = $.extend(response.explorer, {
                    nextInPast: cruCreate.explorer.nextInPast,
                    nextInPastIsInc: cruCreate.explorer.nextInPastIsInc
                })
            } else {
                $container.html(response.payload);
                cruCreate.explorer = response.explorer;
            }


            if (cruCreate.explorer.nextInFuture) {
                $newerActivityBtn.show();
            } else {
                $newerActivityBtn.hide();
            }

            cruCreate.explorer.loading = false;
            callback && callback(response);
        });

        return true;
    };
})(AJS.$);
/*[{!create_js_y8w2510!}]*/
;
/* END /2static/script/cru/create/create.js */
/* START /2static/script/cru/create/create-analytics.js */
/**
 * @see fecru-analytics-plugin/src/main/resources/whitelist/fecru-core-whitelist.json
 */
(function ($, analytics) {

    /**
     * @returns {string} type of the attach method (like "diff" or "whole file") which is selected in the select box
     */
    var getAttachMethod = function() {
        return $("#attachMethod").val().toLowerCase().replace(/_/g, "-");
    };

    /**
     * @returns {string} type of the repository (like "git") which is selected in the select box
     */
    var getRepositoryType = function() {
        return $('#repository-input').attr('data-repository-type');
    };

    /**
     * @param {string} addContentMethod "method-changelog" / "method-browse" / "method-search"
     * @returns {Object} event's content
     */
    var defineAddContentEvent = function(addContentMethod) {
        return {
            name: function() {
                return 'cru.review.addcontent.' + addContentMethod + '.add.' + getAttachMethod();
            },
            data : {
                repositoryType : getRepositoryType
            }
        };
    };

    /**
     * @param {string} removeContentMethod "method-changelog" / "method-browse" / "method-search"
     * @returns {Object} event's content
     */
    var defineRemoveContentEvent = function(removeContentMethod) {
        return {
            name: 'cru.review.addcontent.' + removeContentMethod + '.remove',
            data : {
                repositoryType : getRepositoryType
            }
        };
    };

    /**
     * @param {string} removeContentMethod "method-changelog" / "method-browse" / "method-search"
     * @returns {Object} event's content
     */
    var defineRemoveAllRevisionsEvent = function(removeContentMethod) {
        return {
            name: 'cru.review.addcontent.' + removeContentMethod + '.remove-all-revisions',
            data : {
                repositoryType : getRepositoryType
            }
        };
    };

    // analytics events related with adding/removing review content via "Browse changesets"
    analytics.sendOn('[data-analytics-event="changelog-add"]', defineAddContentEvent('method-changelog'));
    analytics.sendOn('[data-analytics-event="changelog-remove"]', defineRemoveContentEvent('method-changelog'));
    analytics.sendOn('[data-analytics-event="changelog-remove-all"]', defineRemoveAllRevisionsEvent('method-changelog'));


    // analytics events related with adding/removing review content via "Explore repositories"
    analytics.sendOn('[data-analytics-event="browse-add"]', defineAddContentEvent('method-browse'));
    analytics.sendOn('[data-analytics-event="browse-remove"]', defineRemoveContentEvent('method-browse'));
    analytics.sendOn('[data-analytics-event="browse-remove-all"]', defineRemoveAllRevisionsEvent('method-browse'));

    // analytics events related with adding/removing review content via "Search for files"
    analytics.sendOn('[data-analytics-event="search-add"]', defineAddContentEvent('method-search'));
    analytics.sendOn('[data-analytics-event="search-remove"]', defineRemoveContentEvent('method-search'));
    analytics.sendOn('[data-analytics-event="search-remove-all"]', defineRemoveAllRevisionsEvent('method-search'));

})(AJS.$, FECRU.ANALYTICS);
;
/* END /2static/script/cru/create/create-analytics.js */
/* START /2static/script/cru/create/create-browse.js */
// File used in the manage files "browse" panel
if (CRU.CREATE === undefined) {
    CRU.CREATE = {};
}
CRU.CREATE.BROWSE = {};

(function () {
    /**
     * Find a link in the directory tree by its href
     */
    var $findLink = function (href) {
        return AJS.$("#navigation-tree").find("a.pathLink[href='" + href + "']");
    };

    var moveSelectedDirTreeIds = function ($newLink) {
        AJS.$("#selectedDirTreeLink, #selectedDirTreeNode").attr("id", "");
        $newLink.closest("span").attr("id", "selectedDirTreeNode");
        $newLink.attr("id", "selectedDirTreeLink");
    };

    var folderToggled = function ($linkNode) {
        // open the parents
        var $node = $findLink($linkNode.attr("href"));
        $node.parents("ul.closed,span.closed").removeClass("closed").addClass("open");
        moveSelectedDirTreeIds($node);

        AJS.$.ajax({
            type: "GET",
            url: $linkNode.attr("href").replace("edit-browse", "edit-browse-filelist"), // HACK!
            success: function (msg) {
                AJS.$("#fileResults").html(msg);
            }
        });
    };

    var rootSelected = function ($linkNode) {
        // Remove previously selected dirs
        AJS.$("#selectedDirTreeLink, #selectedDirTreeNode").attr("id", "");

        // Make request to root, at '/'
        var rawUrl = $linkNode.attr("href");
        AJS.$.ajax({
            type: "GET",
            url: rawUrl.substring(0, rawUrl.lastIndexOf('/')).replace("edit-browse", "edit-browse-filelist"), // HACK!
            success: function (msg) {
                AJS.$("#fileResults").html(msg);
            }
        });
    };

    CRU.CREATE.BROWSE.browseDirectoryPathLinkFunction = function (event) {
        var $node = AJS.$(event.target);
        var href = $node.attr("href");
        var self = CRU.CREATE.BROWSE.browseDirectoryPathLinkFunction;
        if ($node.hasClass("browse-directory")) {
            // find the node in the tree with the same href as us
            var $selectedLink = $findLink(href);
            FECRU.BROWSE.selectLink($selectedLink, folderToggled, self);
        } else {
            FECRU.BROWSE.selectLink($node, folderToggled, self);
        }
        return false;
    };

    CRU.CREATE.BROWSE.browseFilePathLinkFunction = function (event) {
        event.preventDefault();
        var $node = AJS.$(event.target);
        var $dirParent = $node.parents('ul.tree.open:first');

        // If file has a directory as a parent, select directory, else select root.
        if ($dirParent.length) {
            $node = $dirParent.siblings('span.tree.open').children('.pathLink');
            FECRU.BROWSE.selectLink($node, folderToggled);
        } else {
            rootSelected($node);
        }

        return false;
    };

})();
/*[{!create_browse_js_s51r50y!}]*/;
/* END /2static/script/cru/create/create-browse.js */
/* START /2static/script/cru/create/create-event.js */
(function ($) {

    $(document).ready(function () {

        var cruCreate = CRU.CREATE;
        var fecruAjax = FECRU.AJAX;
        var cruPatches = CRU.PATCHES;

        $(document).delegate(".changelist-link", "click", function (e) {
            e.preventDefault();
            cruCreate.loadChangesets($('#stream'), $('#activityLoadingTop'), $('.changelist-link-future'), {
                navigate: $(this).data('navigate')
            });
        });

        $(document).delegate("#changesetFilter", "submit", function (e) {
            cruCreate.cleanPlaceholders($(this));
            $('#changelog-warning').html('');
            $('#showid').val('');
            cruCreate.loadChangesets(AJS.$('#stream'), $('#activityLoadingTop'), $('.changelist-link-future'), {
                wbUrl: "/" + cruCreate.explorer.fullPath + "?" + $(this).serialize()
            });
            e.preventDefault();
        });


        $(document).delegate('.removeFrx:not(.disabled)', 'click', function () {
            var $x = $(this);
            var idBits = $x.attr('id').split('-');
            fecruAjax.startSpin($x);
            $x.hide();
            cruCreate.addRevisionFromView('remove', idBits[1], idBits[2], function () {
                fecruAjax.stopSpin($x);
                $x.show();
            });
            return false;
        });

        $(document).delegate('.frxSlider .deleteRev', 'click', function () {
            var $x = $(this);
            var xId = $x.attr('id');
            var idBits = xId.split('-');
            fecruAjax.startSpin($x);
            $x.hide();
            cruCreate.addRevisionFromView('removeRevisions', idBits[1], idBits[2], function () {
                var $x = $('#' + xId);
                fecruAjax.stopSpin($x);
                $x.show();
            });
        });

        $(document).delegate('.addRevision', 'click', function () {
            var $elem = $(this);
            var revId = $elem.attr('id').replace(/^addRev/, '');
            cruCreate.addRevisionToIter(revId);
        });

        $(document).delegate('.removeRevision', 'click', function () {
            var $elem = $(this);
            var revId = $elem.attr('id').replace(/^remRev/, '');
            cruCreate.removeRevisionFromIter(revId);
        });

        $(document).delegate('.addChangeSet', 'click', function () {
            var $elem = $(this);
            var csId = $elem.attr('id').replace(/^(addCs|containsSome)/, '');

            var isPartialMetadataChange = $('#csid-' + csId).data('partialmetadatachange');
            var isMetadataOnlyChange = $('#csid-' + csId).data('metadataonlychange');
            //If the user has added file revisions for the partial or full metadata changeset then
            //the only sensible action is to remove the changeset here
            if (!$elem.hasClass('addAllChangeSet') && (isPartialMetadataChange || isMetadataOnlyChange)) {
                cruCreate.removeChangesetFromIter(csId);
            } else {
                cruCreate.addChangesetToIter(csId);
            }
        });

        $(document).delegate('.removeChangeSet', 'click', function () {
            var $elem = $(this);
            var csId = $elem.attr('id').replace(/^remCs|removeSomeCs/, '');
            cruCreate.removeChangesetFromIter(csId);
        });

        $(document).delegate('.changeDiffAddRevision', 'click', function () {
            var $addButton = $(this);
            if (!$addButton.prop('disabled')) {
                var frxId = $addButton.attr('id').replace(/^changeDiffAddRevision/, '');
                var revId = $('#changeDiffSelect' + frxId).val();
                if (revId) {
                    $addButton.prop('disabled', true);
                    var ajax = fecruAjax;
                    ajax.startSpin($addButton, "edit-revision-spinner");
                    var done = function () {
                        ajax.stopSpin($addButton);
                        // Disabled status of button is handled by addRevisionFromView.
                    };
                    cruCreate.addRevisionFromView('add', frxId, revId, done);
                }
            }
        });

        cruCreate.bindUpdateFrxFromFormToggle = function (selector, frx) {
            var $items = $(selector);
            if ($items.data('updateFrxFromFormToggleBound')) {
                return; // avoid binding more than once
            } else {
                $items.data('updateFrxFromFormToggleBound', true);
            }

            AJS.InlineDialog(
                selector,
                'edit-revisions-inline-dialog-form-' + frx,
                function ($container, editRevisionLink, showPopup) {
                    var $editRevisionLink = $(editRevisionLink);
                    if ($editRevisionLink.is(".toggled-off")) {
                        return;
                    }
                    $editRevisionLink.addClass("toggled-off");

                    var frxId = $editRevisionLink.attr('id').replace('add-revisions-link-', '');
                    var $formSpan = $('#updateFrxFromFormSpan' + frxId);

                    if (!$formSpan.is('.allocated')) {
                        var url = CRU.UTIL.jsonUrlBase(permaId) + "/changeDiffDropdownAjax/";
                        var params = {frxId: frxId};
                        $editRevisionLink.parent().addClass('spinner');

                        fecruAjax.ajaxDo(url, params, function (resp) {
                            $editRevisionLink.parent().removeClass('spinner');
                            if (resp.worked) {
                                $formSpan
                                    .html(resp.msgHtml)
                                    .addClass('allocated');

                                $container.append($formSpan.show());
                                CRU.FRX.AJAX.updateFrxEditRevisionsDropdown(frxId);
                                showPopup();
                            }
                            $editRevisionLink.removeClass("toggled-off");
                        });
                    } else {
                        $container.append($formSpan.show());
                        showPopup();
                        $editRevisionLink.removeClass("toggled-off");
                    }
                },
                {
                    hideDelay: null,
                    width: 520,
                    offsetX: -10,
                    cacheContent: false,
                    initCallback: function () {
                        var inlineDialog = this;
                        $(document).bind('frx-deactive.edit-revisions', function () {
                            inlineDialog.hide();
                        });
                        inlineDialog.popup.find('.close').bind('click.edit-revisions', function () {
                            inlineDialog.hide();
                        });
                    },
                    hideCallback: function () {
                        $(document).unbind('frx-deactive.edit-revisions');
                        var $popup = this.popup;
                        $popup.find('.close').unbind('click.edit-revisions');
                        // Stash the form span away for the next time we need to show it.
                        $('body').append($popup.find('.updateFrxFromFormSpan').hide());
                    }
                }
            );
        };


        /* Patches */
        $(document).delegate('.addAllPatch', 'click', function () {
            var $this = $(this);
            var patchId = $this.data('patchid')
            cruCreate.addAllPatch(patchId);
        });

        $(document).delegate('.removeAllPatch', 'click', function () {
            var $this = $(this);
            var patchId = $this.data('patchid')
            cruCreate.removeAllPatch(patchId);
        });

        $(document).delegate('.remove-patch', 'click', function() {
            var $this = $(this);
            var patchId = $this.data('patch-id');
            var reviewId = $this.data('review-id');
            var $patchControls = AJS.$('#patch-controls-' + patchId);
            $patchControls.hide();
            AJS.$
                .ajax({
                    url: AJS.contextPath() + "/rest-service/reviews-v1/" + reviewId + "/patch/" + patchId,
                    dataType: 'json',
                    type: 'DELETE'
                })
                .fail(function(jqXHR, textStatus, errorThrown) {
                    $patchControls.show();
                    var msg;
                    try {
                        msg = JSON.parse(jqXHR.responseText).message;
                    } catch (e) {
                        msg = errorThrown;
                    }
                    AJS.messages.error({body: 'Something went wrong removing the patch. ' + msg});
                })
                .done(function(data) {
                    // update labels for the remaining groups
                    _.each(data.patchGroup, function(patchGroup) {
                        var patchId = patchGroup.sourceName.replace('PATCH:', '')
                        $('#patch-group-' + patchId + ' .patch-group-name').text(patchGroup.displayName);
                    });
                    $patchControls.remove();

                    // remove empty groups
                    $('.patch-group').each(function() {
                        if ($(this).find('.patch-controls').length === 0) {
                            $(this).remove();
                        }
                    });

                    // remove the whole 'Existing patches' section if empty
                    var $patchFilesSection = $('.existing-patch-files');
                    if ($patchFilesSection.find('.patch-group').length === 0) {
                        $patchFilesSection.remove();
                    }
                });
        });

        $(document).delegate('.addFileRevision', 'click', function () {
            var $this = $(this);
            var $fileRevision = $this.closest('.fileRevision');
            var sourceName = $fileRevision.attr('id').replace('fileRevision-', '');
            var revId = $this.attr('id').replace('addRev', '');
            cruCreate.addRemoveFileRevision(true, revId, revId, sourceName);
        });

        $(document).delegate('.removeFileRevision', 'click', function () {
            var $this = $(this);
            var $fileRevision = $this.closest('.fileRevision');
            var sourceName = $fileRevision.attr('id').replace('fileRevision-', '');
            var revId = $this.attr('id').replace('remRev', '');
            cruCreate.addRemoveFileRevision(false, revId, revId, sourceName);
        });

        var $anchorRepository = $("#anchor-repository");

        $anchorRepository.delegate('.anchored-path-edit', 'change', function () {
            var $this = $(this);
            if ($this.val() !== '') {
                var $controls = $this.closest('.patch-controls');
                var params = {
                    anchorSource: $controls.find('.anchored-source-value').val(),
                    anchorPath: $this.val(),
                    stripCount: $controls.find('.anchored-stripcount').val()
                };

                cruPatches.anchorPatch($controls, params);
            }
        });

        $anchorRepository.delegate('.anchored-source-edit', 'change', function () {
            var $this = $(this);

            var $controls = $this.closest('.patch-controls');
            if ($this.val() !== '') {
                var params = {
                    anchorSource: $this.val(),
                    search: true
                };

                cruPatches.anchorPatch($controls, params);
            } else {
                cruPatches.anchorPatch($controls, null);
            }
        });

        $anchorRepository.delegate('.edit-anchor, .find-anchor', 'click', function () {
            var $controls = $(this).closest('.patch-controls');
            if ($controls.is('.disabled')) {
                return;
            }

            var currentAnchorSource = $controls.find('.current-anchor > .anchored-source').text();

            $controls.removeClass('viewing');

            if (currentAnchorSource) {
                $controls.addClass('getting-paths');
                cruPatches.getPaths($controls, currentAnchorSource, function () {
                    $controls.removeClass('getting-paths').addClass('editing');
                });
            } else {
                $controls.addClass('editing');
            }
        });

        $anchorRepository.delegate('.cancel-edit', 'click', function () {
            var $controls = $(this).closest('.patch-controls');
            if ($controls.is('.disabled')) {
                return;
            }
            $controls.removeClass('editing').addClass('viewing');
        });

        $anchorRepository.delegate('.cancel-anchor', 'click', function () {
            var $controls = $(this).closest('.patch-controls');
            if ($controls.is('.disabled')) {
                return;
            }
            var cancel = $controls.data('cancel');
            cancel && cancel();
            $controls.removeClass('anchoring getting-paths').addClass('viewing');
        });

        $(document).delegate('.patch-revisions-expand', 'click', function () {
            var $this = $(this);
            var $patchRevisions = $this.parents('.patch-controls').find('.patch-revisions')
            $patchRevisions.slideToggle(200, function () {
                $this.toggleClass('expanded');
            });
        })

    });

})(AJS.$);
/*[{!create_event_js_091a50z!}]*/;
/* END /2static/script/cru/create/create-event.js */
/* START /2static/script/cru/dialog/dialog-event.js */
(function () {

    var $container = FECRU.DIALOG.getAjaxDialogContainer();

    var dialogHandler = function (callbacks) {
        return function (event) {
            var dialog = $container.data('dialog');
            var permaId = $container.data('permaId');

            if (CRU.UTIL.isReviewPage() && callbacks.review) {
                return callbacks.review(dialog, permaId, event);
            } else if (!CRU.UTIL.isReviewPage() && callbacks.external) {
                return callbacks.external(dialog, permaId, event);
            }
        };
    };

    var viewFiltersHandler = function (filters) {
        return dialogHandler({
            review: function (dialog) {
                if (AJS.$('body').hasClass('review-updated')) {
                    window.location.hash = 'f-' + filters.join(',');
                    window.location.reload(true);
                } else {
                    CRU.REVIEW.UTIL.filterAndExpandFrxs(filters);
                    dialog.remove();
                }
            },
            external: function (dialog, permaId) {
                window.location = CRU.UTIL.urlBase(permaId) + '#f-' + filters.join(',');
            }
        });
    };

    var batchProcessDraftComments = function (action, permaId, onComplete) {
        var url = CRU.UTIL.jsonUrlBase(permaId) + '/draftCommentsAjax';
        var params = {
            action: action
        };
        var done = function (resp) {
            if (onComplete) {
                onComplete(resp);
            }
        };
        FECRU.AJAX.ajaxDo(url, params, done, true);
    };

    var draftCommentsHandler = function (action) {
        return dialogHandler({
            review: function (dialog, permaId) {
                function toggleSpinner(spinnerSelector) {
                    var spinner = AJS.$(spinnerSelector);
                    if (spinner.is(':hidden')) {
                        spinner.removeClass('hidden');
                        spinner.spin();
                    } else {
                        spinner.spinStop();
                        spinner.addClass('hidden');
                    }
                }

                var successMsg;
                var failMsg;
                var closeButton = AJS.$('#' + dialog.id).find('.button-panel-button');
                closeButton.prop('disabled', true);

                if (action === 'publish') {
                    closeButton.text('Posting drafts');
                    toggleSpinner('#dialog-post-drafts-spinner');

                    successMsg = 'Your draft comments have been posted.';
                    failMsg = 'Posting some of your draft comments failed with an error: ';
                }

                batchProcessDraftComments(action, permaId, function (resp) {
                    AJS.$('#dialog-drafts-links').hide();
                    closeButton.prop('disabled', false);
                    if (resp.worked) {
                        AJS.$('#dialog-drafts-message').html(successMsg);
                        closeButton.text('Close');
                        CRU.REVIEW.UTIL.reloadReview(true);
                    } else {
                        var msg;
                        if (resp.errorMsg) {
                            msg = failMsg + '<br/>' + resp.errorMsg;
                        } else {
                            msg = "Request has failed with an status error: " + resp.status;
                        }
                        AJS.$('#dialog-drafts-message').html(msg);
                        closeButton.text('Close Anyway');
                    }
                });
            },
            external: function (dialog, permaId) {
                batchProcessDraftComments(action, permaId, function (resp) {
                    if (resp.worked) {
                        AJS.$('#dialog-drafts-links').hide();
                    } else {
                        // TODO Show error message within dialog panel.
                    }
                });
            }
        });
    };

    var resolveUnresolvedJiras = function () {
        var doIt = function (dialog, permaId) {
            AJS.$('#dialog-unresolved-jiras-controls').hide();
            var url = CRU.UTIL.jsonUrlBase(permaId) + '/resolveAllSubtasksAjax';
            var params = {};
            AJS.$('#dialog-unresolved-jiras-spinner').show();
            var done = function (resp) {
                AJS.$('#dialog-unresolved-jiras-spinner').hide();
                if (resp.worked) {
                    AJS.$('#dialog-unresolved-jiras-title').html("There are no unresolved subtasks.").show();
                } else {
                    AJS.$('#dialog-unresolved-jiras-results').addClass("jira-error").html(resp.errorMsg).show();
                }
            };
            FECRU.AJAX.ajaxDo(url, params, done, true);
        };
        return dialogHandler({review: doIt, external: doIt});
    };

    AJS.$(document).ready(function () {
        var $document = AJS.$(document);
        $document.delegate('#dialog-view-drafts', 'click', viewFiltersHandler(['draftcomments']));
        $document.delegate('#dialog-view-unread-comments', 'click', viewFiltersHandler(['unreadcomments']));
        $document.delegate('#dialog-view-incomplete-frxs', 'click', viewFiltersHandler(['incomplete']));
        $document.delegate('#dialog-view-unresolved-jiras', 'click', viewFiltersHandler(['unresolvedsubtasks']));

        $document.delegate('#dialog-post-drafts', 'click', draftCommentsHandler('publish'));
        $document.delegate('#dialog-resolve-unresolved-jiras', 'click', resolveUnresolvedJiras());
    });

})();
/*[{!dialog_event_js_bq41511!}]*/;
/* END /2static/script/cru/dialog/dialog-event.js */
/* START /2static/script/cru/review/review-analytics.js */
(function ($, analytics) {

    analytics.sendOn({type: 'add-content-dialog-shown.review'}, 'cru.review.addcontent.list.shown');

    analytics.sendOn({
        selector: '#add-content-methods .method',
        type: 'add-content-item-selected.review'
    }, {
        name: function () {
            var methodName = $(this).data('analytics-name');
            if (methodName) {
                return 'cru.review.addcontent.' + methodName;
            }
        }
    });

})(AJS.$, FECRU.ANALYTICS);;
/* END /2static/script/cru/review/review-analytics.js */
