/* CONCAT of
/2static/script/lib/ZeroClipboard-1.2.1.min.js
/2static/script/cru/unsaved-changes.js
/2static/script/cru/review/editableHeader.js
*/
/* START /2static/script/lib/ZeroClipboard-1.2.1.min.js */
/*!
* ZeroClipboard
* The ZeroClipboard library provides an easy way to copy text to the clipboard using an invisible Adobe Flash movie and a JavaScript interface.
* Copyright (c) 2013 Jon Rohan, James M. Greene
* Licensed MIT
* http://zeroclipboard.org/
* v1.2.1
*/
!function(){"use strict";var a,b=function(){var a=/\-([a-z])/g,b=function(a,b){return b.toUpperCase()};return function(c){return c.replace(a,b)}}(),c=function(a,c){var d,e,f,g,h,i;if(window.getComputedStyle?d=window.getComputedStyle(a,null).getPropertyValue(c):(e=b(c),d=a.currentStyle?a.currentStyle[e]:a.style[e]),"cursor"===c&&(!d||"auto"===d))for(f=a.tagName.toLowerCase(),g=["a"],h=0,i=g.length;i>h;h++)if(f===g[h])return"pointer";return d},d=function(a){if(p.prototype._singleton){a||(a=window.event);var b;this!==window?b=this:a.target?b=a.target:a.srcElement&&(b=a.srcElement),p.prototype._singleton.setCurrent(b)}},e=function(a,b,c){a.addEventListener?a.addEventListener(b,c,!1):a.attachEvent&&a.attachEvent("on"+b,c)},f=function(a,b,c){a.removeEventListener?a.removeEventListener(b,c,!1):a.detachEvent&&a.detachEvent("on"+b,c)},g=function(a,b){if(a.addClass)return a.addClass(b),a;if(b&&"string"==typeof b){var c=(b||"").split(/\s+/);if(1===a.nodeType)if(a.className){for(var d=" "+a.className+" ",e=a.className,f=0,g=c.length;g>f;f++)d.indexOf(" "+c[f]+" ")<0&&(e+=" "+c[f]);a.className=e.replace(/^\s+|\s+$/g,"")}else a.className=b}return a},h=function(a,b){if(a.removeClass)return a.removeClass(b),a;if(b&&"string"==typeof b||void 0===b){var c=(b||"").split(/\s+/);if(1===a.nodeType&&a.className)if(b){for(var d=(" "+a.className+" ").replace(/[\n\t]/g," "),e=0,f=c.length;f>e;e++)d=d.replace(" "+c[e]+" "," ");a.className=d.replace(/^\s+|\s+$/g,"")}else a.className=""}return a},i=function(){var a,b,c,d=1;return"function"==typeof document.body.getBoundingClientRect&&(a=document.body.getBoundingClientRect(),b=a.right-a.left,c=document.body.offsetWidth,d=Math.round(100*(b/c))/100),d},j=function(a){var b={left:0,top:0,width:0,height:0,zIndex:999999999},d=c(a,"z-index");if(d&&"auto"!==d&&(b.zIndex=parseInt(d,10)),a.getBoundingClientRect){var e,f,g,h=a.getBoundingClientRect();"pageXOffset"in window&&"pageYOffset"in window?(e=window.pageXOffset,f=window.pageYOffset):(g=i(),e=Math.round(document.documentElement.scrollLeft/g),f=Math.round(document.documentElement.scrollTop/g));var j=document.documentElement.clientLeft||0,k=document.documentElement.clientTop||0;b.left=h.left+e-j,b.top=h.top+f-k,b.width="width"in h?h.width:h.right-h.left,b.height="height"in h?h.height:h.bottom-h.top}return b},k=function(a,b){var c=!(b&&b.useNoCache===!1);return c?(-1===a.indexOf("?")?"?":"&")+"nocache="+(new Date).getTime():""},l=function(a){var b=[],c=[];return a.trustedOrigins&&("string"==typeof a.trustedOrigins?c.push(a.trustedOrigins):"object"==typeof a.trustedOrigins&&"length"in a.trustedOrigins&&(c=c.concat(a.trustedOrigins))),a.trustedDomains&&("string"==typeof a.trustedDomains?c.push(a.trustedDomains):"object"==typeof a.trustedDomains&&"length"in a.trustedDomains&&(c=c.concat(a.trustedDomains))),c.length&&b.push("trustedOrigins="+encodeURIComponent(c.join(","))),"string"==typeof a.amdModuleId&&a.amdModuleId&&b.push("amdModuleId="+encodeURIComponent(a.amdModuleId)),"string"==typeof a.cjsModuleId&&a.cjsModuleId&&b.push("cjsModuleId="+encodeURIComponent(a.cjsModuleId)),b.join("&")},m=function(a,b){if(b.indexOf)return b.indexOf(a);for(var c=0,d=b.length;d>c;c++)if(b[c]===a)return c;return-1},n=function(a){if("string"==typeof a)throw new TypeError("ZeroClipboard doesn't accept query strings.");return a.length?a:[a]},o=function(a,b,c,d,e){e?window.setTimeout(function(){a.call(b,c,d)},0):a.call(b,c,d)},p=function(a,b){if(a&&(p.prototype._singleton||this).glue(a),p.prototype._singleton)return p.prototype._singleton;p.prototype._singleton=this,this.options={};for(var c in s)this.options[c]=s[c];for(var d in b)this.options[d]=b[d];this.handlers={},p.detectFlashSupport()&&v()},q=[];p.prototype.setCurrent=function(b){a=b,this.reposition();var d=b.getAttribute("title");d&&this.setTitle(d);var e=this.options.forceHandCursor===!0||"pointer"===c(b,"cursor");return r.call(this,e),this},p.prototype.setText=function(a){return a&&""!==a&&(this.options.text=a,this.ready()&&this.flashBridge.setText(a)),this},p.prototype.setTitle=function(a){return a&&""!==a&&this.htmlBridge.setAttribute("title",a),this},p.prototype.setSize=function(a,b){return this.ready()&&this.flashBridge.setSize(a,b),this},p.prototype.setHandCursor=function(a){return a="boolean"==typeof a?a:!!a,r.call(this,a),this.options.forceHandCursor=a,this};var r=function(a){this.ready()&&this.flashBridge.setHandCursor(a)};p.version="1.2.1";var s={moviePath:"ZeroClipboard.swf",trustedOrigins:null,text:null,hoverClass:"zeroclipboard-is-hover",activeClass:"zeroclipboard-is-active",allowScriptAccess:"sameDomain",useNoCache:!0,forceHandCursor:!1};p.setDefaults=function(a){for(var b in a)s[b]=a[b]},p.destroy=function(){p.prototype._singleton.unglue(q);var a=p.prototype._singleton.htmlBridge;a.parentNode.removeChild(a),delete p.prototype._singleton},p.detectFlashSupport=function(){var a=!1;if("function"==typeof ActiveXObject)try{new ActiveXObject("ShockwaveFlash.ShockwaveFlash")&&(a=!0)}catch(b){}return!a&&navigator.mimeTypes["application/x-shockwave-flash"]&&(a=!0),a};var t=null,u=null,v=function(){var a=p.prototype._singleton,b=document.getElementById("global-zeroclipboard-html-bridge");if(!b){var c={};for(var d in a.options)c[d]=a.options[d];c.amdModuleId=t,c.cjsModuleId=u;var e=l(c),f='      <object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" id="global-zeroclipboard-flash-bridge" width="100%" height="100%">         <param name="movie" value="'+a.options.moviePath+k(a.options.moviePath,a.options)+'"/>         <param name="allowScriptAccess" value="'+a.options.allowScriptAccess+'"/>         <param name="scale" value="exactfit"/>         <param name="loop" value="false"/>         <param name="menu" value="false"/>         <param name="quality" value="best" />         <param name="bgcolor" value="#ffffff"/>         <param name="wmode" value="transparent"/>         <param name="flashvars" value="'+e+'"/>         <embed src="'+a.options.moviePath+k(a.options.moviePath,a.options)+'"           loop="false" menu="false"           quality="best" bgcolor="#ffffff"           width="100%" height="100%"           name="global-zeroclipboard-flash-bridge"           allowScriptAccess="always"           allowFullScreen="false"           type="application/x-shockwave-flash"           wmode="transparent"           pluginspage="http://www.macromedia.com/go/getflashplayer"           flashvars="'+e+'"           scale="exactfit">         </embed>       </object>';b=document.createElement("div"),b.id="global-zeroclipboard-html-bridge",b.setAttribute("class","global-zeroclipboard-container"),b.setAttribute("data-clipboard-ready",!1),b.style.position="absolute",b.style.left="-9999px",b.style.top="-9999px",b.style.width="15px",b.style.height="15px",b.style.zIndex="9999",b.innerHTML=f,document.body.appendChild(b)}a.htmlBridge=b,a.flashBridge=document["global-zeroclipboard-flash-bridge"]||b.children[0].lastElementChild};p.prototype.resetBridge=function(){return this.htmlBridge.style.left="-9999px",this.htmlBridge.style.top="-9999px",this.htmlBridge.removeAttribute("title"),this.htmlBridge.removeAttribute("data-clipboard-text"),h(a,this.options.activeClass),a=null,this.options.text=null,this},p.prototype.ready=function(){var a=this.htmlBridge.getAttribute("data-clipboard-ready");return"true"===a||a===!0},p.prototype.reposition=function(){if(!a)return!1;var b=j(a);return this.htmlBridge.style.top=b.top+"px",this.htmlBridge.style.left=b.left+"px",this.htmlBridge.style.width=b.width+"px",this.htmlBridge.style.height=b.height+"px",this.htmlBridge.style.zIndex=b.zIndex+1,this.setSize(b.width,b.height),this},p.dispatch=function(a,b){p.prototype._singleton.receiveEvent(a,b)},p.prototype.on=function(a,b){for(var c=a.toString().split(/\s/g),d=0;d<c.length;d++)a=c[d].toLowerCase().replace(/^on/,""),this.handlers[a]||(this.handlers[a]=b);return this.handlers.noflash&&!p.detectFlashSupport()&&this.receiveEvent("onNoFlash",null),this},p.prototype.addEventListener=p.prototype.on,p.prototype.off=function(a,b){for(var c=a.toString().split(/\s/g),d=0;d<c.length;d++){a=c[d].toLowerCase().replace(/^on/,"");for(var e in this.handlers)e===a&&this.handlers[e]===b&&delete this.handlers[e]}return this},p.prototype.removeEventListener=p.prototype.off,p.prototype.receiveEvent=function(b,c){b=b.toString().toLowerCase().replace(/^on/,"");var d=a,e=!0;switch(b){case"load":if(c&&parseFloat(c.flashVersion.replace(",",".").replace(/[^0-9\.]/gi,""))<10)return this.receiveEvent("onWrongFlash",{flashVersion:c.flashVersion}),void 0;this.htmlBridge.setAttribute("data-clipboard-ready",!0);break;case"mouseover":g(d,this.options.hoverClass);break;case"mouseout":h(d,this.options.hoverClass),this.resetBridge();break;case"mousedown":g(d,this.options.activeClass);break;case"mouseup":h(d,this.options.activeClass);break;case"datarequested":var f=d.getAttribute("data-clipboard-target"),i=f?document.getElementById(f):null;if(i){var j=i.value||i.textContent||i.innerText;j&&this.setText(j)}else{var k=d.getAttribute("data-clipboard-text");k&&this.setText(k)}e=!1;break;case"complete":this.options.text=null}if(this.handlers[b]){var l=this.handlers[b];"string"==typeof l&&"function"==typeof window[l]&&(l=window[l]),"function"==typeof l&&o(l,d,this,c,e)}},p.prototype.glue=function(a){a=n(a);for(var b=0;b<a.length;b++)-1==m(a[b],q)&&(q.push(a[b]),e(a[b],"mouseover",d));return this},p.prototype.unglue=function(a){a=n(a);for(var b=0;b<a.length;b++){f(a[b],"mouseover",d);var c=m(a[b],q);-1!=c&&q.splice(c,1)}return this},"function"==typeof define&&define.amd?define(["require","exports","module"],function(a,b,c){return t=c&&c.id||null,p}):"object"==typeof module&&module&&"object"==typeof module.exports&&module.exports?(u=module.id||null,module.exports=p):window.ZeroClipboard=p}();/*[{!ZeroClipboard_1_2_1_min_js_vsrm54r!}]*/;
/* END /2static/script/lib/ZeroClipboard-1.2.1.min.js */
/* START /2static/script/cru/unsaved-changes.js */
window.CRU = window.CRU || {};
if (!CRU.UNSAVED) {
    CRU.UNSAVED = {};
}

(function ($) {
    var unsaved = CRU.UNSAVED;

    var watchedInputs = [];

    unsaved.clearWatchForUnsavedChanges = function () {
        watchedInputs = [];
    };

    unsaved.watchForUnsavedChanges = function ($input, fieldName) {
        var input = $input ? $input[0] : undefined;
        if (!input) {
            return;
        }

        if ($input.siblings(".backup").length === 0) {
            return;
        }

        $input.data("fieldName", fieldName);

        if ($.inArray(input, watchedInputs) === -1) {
            watchedInputs.push(input);
        }
    };

    /**
     * Shows a confirm dialog if there are unsubmitted input elements on the page.
     * @return true if the user wants to continue
     */
    unsaved.confirmUnsubmittedInputs = function () {
        var warning = getUnsubmittedInputsWarning();
        if (warning) {
            var txt = "Are you sure you want to navigate away from this page?\n\n" +
                warning + "\n\n" +
                "Press OK to continue, or Cancel to stay on the current page.";
            return confirm(txt);
        }
        return true;
    };

    var getUnsubmittedInputsWarning = function () {
        var unsubmitted = getUnsubmittedInputs();
        var warning = null;
        var length = unsubmitted.length;
        if (length > 0) {
            var fields = "";
            for (var i = 0; i < length; i++) {
                if (fields.length > 0) {
                    if (i === length - 1) {
                        fields += " and "
                    } else {
                        fields += ", ";
                    }
                }
                fields += unsubmitted[i].data("fieldName");
            }

            warning = "The " + fields + (length === 1 ? " field has " : " fields have ") + "not been saved.";
        }
        return warning;
    };

    var getUnsubmittedInputs = function () {
        var unsubmitted = [];
        try {
            for (var i = 0, len = watchedInputs.length; i < len; i++) {
                var w = watchedInputs[i];
                // May have been removed from the DOM, so be defensive.
                if (!w) {
                    continue;
                }
                var $input = $(w);
                var $backup = $input.siblings(".backup");
                if ($input.val() !== $backup.val()) {
                    unsubmitted.push($input);
                }
            }
        } catch (e) {
            AJS.log("There was an error getting unsubmitted values: " + e);
        }
        return unsubmitted;
    };

    // Check that we don't have any unsubmitted input fields before unloading the page.
    $(window).bind('beforeunload', function (e) {
        e = e || window.event;

        var txt = getUnsubmittedInputsWarning();
        if (txt) {
            if (e) {
                // Firefox/IE
                e.returnValue = txt;
            }
            // Safari
            return txt;
        }
    });
})(AJS.$);
/*[{!unsaved_changes_js_y2o550w!}]*/;
/* END /2static/script/cru/unsaved-changes.js */
/* START /2static/script/cru/review/editableHeader.js */
window.CRU = window.CRU || {};
if (!CRU.REVIEW) {
    CRU.REVIEW = {};
}
if (!CRU.REVIEW.INLINE) {
    CRU.REVIEW.INLINE = {};
}

(function ($) {
    var reviewInline = CRU.REVIEW.INLINE;
    var CON_titleAndButtonsMargin = 90;
    var keyCode = AJS.$.ui.keyCode;

    var headerAlreadySetup = false;
    var reSetupTitle = null;
    /**
     *
     * @param name the name of the field to be used in user error messages
     * @param display selector for the normal display
     * @param input selector for the input field
     */
    reviewInline.setUpEditableHeader = function (name, display, input, isUpdate) {
        if (headerAlreadySetup && !isUpdate) {
            return;
        }
        headerAlreadySetup = true;
        var $reviewHeadInput = AJS.$(input);
        var $inputField = $reviewHeadInput.children('.input');
        var $submitTitle = $reviewHeadInput.children('.submit-title');

        AJS.$(display + '.editable').click(function (e) {
            var $target = AJS.$(e.target);
            if ($target.closest('a').length === 1) {
                return true;
            }
            AJS.$(this).hide();
            $reviewHeadInput.show();
            $inputField.focus();
        });

        CRU.UNSAVED.watchForUnsavedChanges($inputField, name);

        $inputField.keypress(function (e) {
            if (e.keyCode === keyCode.ENTER) {
                updateReviewTitle();
                e.preventDefault();
            } else if (e.keyCode === keyCode.ESCAPE) {
                discardNewTitle();
            }
        });

        var discardNewTitle = function () {
            if ($submitTitle.hasClass('spinner')) {
                return;
            }
            $reviewHeadInput.hide();
            AJS.$(display).show();

            // this needs a timeout because of a conflict with leaving the input box (or something like that)
            setTimeout(function () {
                var title = $reviewHeadInput.children('.backup').val();
                $inputField.val(title);
            }, 200);
        };

        var updateReviewTitle = function () {
            $submitTitle.addClass('spinner');
            var util = CRU.UTIL;
            var url = util.jsonUrlBase(permaId) + '/updateReviewTitleAjax';
            var params = {
                title: $inputField.val()
            };
            FECRU.AJAX.ajaxDo(url, params, function (resp) {
                $submitTitle.removeClass('spinner');
                if (resp.worked) {
                    AJS.$(display).children('.title').html(resp.titleHtml).attr('title', resp.title);
                    $reviewHeadInput.children('.backup, .input').val(resp.title);
                    discardNewTitle();
                }
            });
        };

        $submitTitle.click(updateReviewTitle);
        $reviewHeadInput.children('.discard-title').click(discardNewTitle);

        if (!reSetupTitle) {
            reSetupTitle = function () {
                reviewInline.setUpEditableHeader(name, display, input, true);
            }
        }
    };

    reviewInline.reSetupEditableTitle = function () {
        reSetupTitle && reSetupTitle();
    };

    var hasAdjustedReviewTitle = false;
    reviewInline.adjustReviewTitle = function () {
        var resizeReviewTitle = function () {
            var $buttons = $('#page-actions');

            if (!$buttons.length) {
                $buttons = $('#context-navigation')
            }

            var buttonLeft = $buttons.position().left;
            var titleWidth = buttonLeft - CON_titleAndButtonsMargin;
            $('#reviewHead, #reviewHeadInput').width(titleWidth);
        };
        if (!hasAdjustedReviewTitle) {
            $(window).bind('resize', AJS.$.throttle(400, function () {
                resizeReviewTitle();
            }));
            hasAdjustedReviewTitle = true;
        }
        resizeReviewTitle();
    };

    // from here is the logic of setting up the new editable title on review page
    // these change should be soon applied to snippet page when its page header is changed
    reviewInline.setUpReviewEditableTitle = function (name, $title) {
        var $titleInput = $title.find('.title-input > input');
        var title = $titleInput.val();

        $title.on('click', 'a', function (e) {            // Right click fires a click event in Firefox but not in Chrome
            if ($(this).parent().is('.jira-hover-trigger')) {
                // according to the UserTextRender, the jira issue links will be encapsulated in a span.jira-hover-trigger
                if (FECRU.isRightClick(e) || !FECRU.openInSameTab(e)) {
                    return;
                } else {
                    e.preventDefault();
                }
            } else {
                e.stopPropagation();
            }
        });

        $title.click(function (e) {
            var $target = $(e.target);
            if ($target.parent().is('.jira-hover-trigger')) {
                return;
            }

            if ($title.is('.read-mode')) {
                var width = $title.width();
                $titleInput.css('width', width);
                $title.removeClass('read-mode');
                $titleInput.select();
            }

            e.stopPropagation();
        });

        var submitAndSaveTitle = function () {
            var newTitle = $titleInput.val();
            if (newTitle === title) {
                $title.addClass('read-mode');
                return;
            }

            $title.removeClass('read-mode')
                .addClass('saving-mode');
            var util = CRU.UTIL;
            var url = util.jsonUrlBase(permaId) + '/updateReviewTitleAjax';
            var params = {
                title: newTitle,
                adgified: true
            };

            newTitle = $.trim(newTitle);

            if (newTitle) {
                $title.find('.title-content').text(newTitle);
            } else {
                $title.find('.title-content').html('<em>Untitled</em>');
            }

            FECRU.AJAX.ajaxDo(url, params, function (resp) {
                if (resp.worked) {
                    $title.replaceWith(resp.titleHtml);
                    $('#frx-pane').trigger('editable-title-updated');
                }
            });
        };

        $title.find('.aui-button.submit').click(function (e) {
            submitAndSaveTitle();
            e.stopPropagation();
        });

        $title.find('.aui-button.cancel').click(function (e) {
            $title.addClass('read-mode');
            $titleInput.val(title);
            e.stopPropagation();
        });

        $titleInput.keydown(function (e) {
            if (e.keyCode === keyCode.ENTER) {
                submitAndSaveTitle();
                e.stopPropagation();
                e.preventDefault();
            }
        });

        $(document).click(function () {
            if (!$title.is('.read-mode') && !$title.is('.saving-mode')) {
                submitAndSaveTitle();
            }
        });

        return {
            setTitle: function (newTitle, newTitleHtml) {
                $title.find('.title-content').html(newTitleHtml);
                title = newTitle;
                $titleInput.val(newTitle);
            }
        }
    }


})(AJS.$);
/*[{!editableHeader_js_td3k516!}]*/;
/* END /2static/script/cru/review/editableHeader.js */
