/* CONCAT of
/2static/script/lib/jquery/plugins/jquery.fecru.hoverIntent.js
/2static/script/lib/jquery/plugins/jquery.scrollTo.js
/2static/script/fecru/hover.js
/2static/script/fecru/issue-dialog.js
/2static/script/lib/ZeroClipboard-1.2.1.min.js
/2static/script/fecru/selection-history.js
/2static/script/fecru/ui.js
/2static/script/fecru/star.js
/2static/script/fecru/ajax.js
/2static/script/fe/fisheye-annotation.js
*/
/* START /2static/script/lib/jquery/plugins/jquery.fecru.hoverIntent.js */
/**
* NOTE: This version of hoverIntent has been modified for internal use
*   1. Provides the option to bind with liveEvents instead of classic browser binding
*   2. Namespaced binding
*
* hoverIntent is similar to jQuery's built-in "hover" function except that
* instead of firing the onMouseOver event immediately, hoverIntent checks
* to see if the user's mouse has slowed down (beneath the sensitivity
* threshold) before firing the onMouseOver event.
*
* hoverIntent r5 // 2007.03.27 // jQuery 1.1.2+
* <http://cherne.net/brian/resources/jquery.hoverIntent.html>
*
* hoverIntent is currently available for use in all personal or commercial
* projects under both MIT and GPL licenses. This means that you can choose
* the license that best suits your project, and use it accordingly.
*
* // basic usage (just like .hover) receives onMouseOver and onMouseOut functions
* $("ul li").hoverIntent( showNav , hideNav );
*
* // advanced usage receives configuration object only
* $("ul li").hoverIntent({
*    sensitivity: 7, // number = sensitivity threshold (must be 1 or higher)
*    interval: 100,   // number = milliseconds of polling interval
*    over: showNav,  // function = onMouseOver callback (required)
*    timeout: 0,   // number = milliseconds delay before onMouseOut function call
*    out: hideNav    // function = onMouseOut callback (required)
* });
*
* @param  f  onMouseOver function || An object with configuration options
* @param  g  onMouseOut function  || Nothing (use configuration options object)
* @author    Brian Cherne <brian@cherne.net>
*/
(function($) {
    $.fn.hoverIntent = function(f,g) {
        // default configuration options
        var cfg = {
            sensitivity: 7,
            interval: 100,
            timeout: 0,
            useLiveEvents: false
        };
        // override configuration options with user supplied object
        cfg = $.extend(cfg, g ? { over: f, out: g } : f );

        // instantiate variables
        // cX, cY = current X and Y position of mouse, updated by mousemove event
        // pX, pY = previous X and Y position of mouse, set by mouseover and polling interval
        var cX, cY, pX, pY;

        // A private function for getting mouse position
        var track = function(ev) {
            cX = ev.pageX;
            cY = ev.pageY;
        };

        // A private function for comparing current and previous mouse position
        var compare = function(ev,ob) {
            ob.hoverIntent_t = clearTimeout(ob.hoverIntent_t);
            // compare mouse positions to see if they've crossed the threshold
            if ( ( Math.abs(pX-cX) + Math.abs(pY-cY) ) < cfg.sensitivity ) {
                $(ob).unbind("mousemove.liveHoverIntent",track);
                // set hoverIntent state to true (so mouseOut can be called)
                ob.hoverIntent_s = 1;
                return cfg.over.apply(ob,[ev]);
            } else {
                // set previous coordinates for next time
                pX = cX; pY = cY;
                // use self-calling timeout, guarantees intervals are spaced out properly (avoids JavaScript timer bugs)
                ob.hoverIntent_t = setTimeout( function(){compare(ev, ob);} , cfg.interval );
            }
        };

        // A private function for delaying the mouseOut function
        var delay = function(ev,ob) {
            ob.hoverIntent_t = clearTimeout(ob.hoverIntent_t);
            ob.hoverIntent_s = 0;
            return cfg.out.apply(ob,[ev]);
        };

        // A private function for handling mouse 'hovering'
        var handleHover = function(e) {
            e = e.originalEvent;
            // next three lines copied from jQuery.hover, ignore children onMouseOver/onMouseOut
            var p = (e.type == "mouseover" ? e.fromElement : e.toElement) || e.relatedTarget;
            while ( p && p != this ) { try { p = p.parentNode; } catch(e) { p = this; } }
            if ( p == this ) { return false; }

            // copy objects to be passed into t (required for event object to be passed in IE)
            var ev = $.extend({},e);
            var ob = this;

            // cancel hoverIntent timer if it exists
            if (ob.hoverIntent_t) { ob.hoverIntent_t = clearTimeout(ob.hoverIntent_t); }

            // else e.type == "onmouseover"
            if (e.type == "mouseover") {
                // set "previous" X and Y position based on initial entry point
                pX = ev.pageX; pY = ev.pageY;
                // update "current" X and Y position based on mousemove
                $(ob).bind("mousemove.liveHoverIntent",track);
                // start polling interval (self-calling timeout) to compare mouse coordinates over time
                if (ob.hoverIntent_s != 1) { ob.hoverIntent_t = setTimeout( function(){compare(ev,ob);} , cfg.interval );}

            // else e.type == "onmouseout"
            } else {
                // unbind expensive mousemove event
                $(ob).unbind("mousemove.liveHoverIntent",track);
                // if hoverIntent state is true, then call the mouseOut function after the specified delay
                if (ob.hoverIntent_s == 1) { ob.hoverIntent_t = setTimeout( function(){delay(ev,ob);} , cfg.timeout );}
            }
        };

        // bind the function to the two event listeners
        if (cfg.useLiveEvents) {
            var selector = this.selector;
            if (selector) {
                return $(selector).live('mouseover.liveHoverIntent', handleHover).live('mouseout.liveHoverIntent', handleHover);
            } else {
                // todo: selector is not present - the jquery object not suitable for live event?
                // todo: fall back to something other than live, or just do nothing?
                return this.bind('mouseover.liveHoverIntent', handleHover).bind('mouseout.liveHoverIntent', handleHover);
            }
        } else {
            return this.bind('mouseover.liveHoverIntent', handleHover).bind('mouseout.liveHoverIntent', handleHover);
        }
    };
})(jQuery);
/*[{!jquery_fecru_hoverIntent_js_715u55g!}]*/;
/* END /2static/script/lib/jquery/plugins/jquery.fecru.hoverIntent.js */
/* START /2static/script/lib/jquery/plugins/jquery.scrollTo.js */
/*!
 * jQuery.ScrollTo
 * Copyright (c) 2007-2014 Ariel Flesler - aflesler<a>gmail<d>com | http://flesler.blogspot.com
 * Licensed under MIT
 * http://flesler.blogspot.com/2007/10/jqueryscrollto.html
 * @projectDescription Easy element scrolling using jQuery.
 * @author Ariel Flesler
 * @version 1.4.11
 */

;(function(plugin) {
    // AMD Support
    if (typeof define === 'function' && define.amd) {
        define(['jquery'], plugin);
    } else {
        plugin(jQuery);
    }
}(function($) {

    var $scrollTo = $.scrollTo = function( target, duration, settings ) {
        return $(window).scrollTo( target, duration, settings );
    };

    $scrollTo.defaults = {
        axis:'xy',
        duration: parseFloat($.fn.jquery) >= 1.3 ? 0 : 1,
        limit:true
    };

    // Returns the element that needs to be animated to scroll the window.
    // Kept for backwards compatibility (specially for localScroll & serialScroll)
    $scrollTo.window = function( scope ) {
        return $(window)._scrollable();
    };

    // Hack, hack, hack :)
    // Returns the real elements to scroll (supports window/iframes, documents and regular nodes)
    $.fn._scrollable = function() {
        return this.map(function() {
            var elem = this,
                isWin = !elem.nodeName || $.inArray( elem.nodeName.toLowerCase(), ['iframe','#document','html','body'] ) != -1;

            if (!isWin)
                return elem;

            var doc = (elem.contentWindow || elem).document || elem.ownerDocument || elem;

            return /webkit/i.test(navigator.userAgent) || doc.compatMode == 'BackCompat' ?
                doc.body :
                doc.documentElement;
        });
    };

    $.fn.scrollTo = function( target, duration, settings ) {
        if (typeof duration == 'object') {
            settings = duration;
            duration = 0;
        }
        if (typeof settings == 'function')
            settings = { onAfter:settings };

        if (target == 'max')
            target = 9e9;

        settings = $.extend( {}, $scrollTo.defaults, settings );
        // Speed is still recognized for backwards compatibility
        duration = duration || settings.duration;
        // Make sure the settings are given right
        settings.queue = settings.queue && settings.axis.length > 1;

        if (settings.queue)
        // Let's keep the overall duration
            duration /= 2;
        settings.offset = both( settings.offset );
        settings.over = both( settings.over );

        return this._scrollable().each(function() {
            // Null target yields nothing, just like jQuery does
            if (target == null) return;

            var elem = this,
                $elem = $(elem),
                targ = target, toff, attr = {},
                win = $elem.is('html,body');

            switch (typeof targ) {
                // A number will pass the regex
                case 'number':
                case 'string':
                    if (/^([+-]=?)?\d+(\.\d+)?(px|%)?$/.test(targ)) {
                        targ = both( targ );
                        // We are done
                        break;
                    }
                    // Relative selector, no break!
                    targ = $(targ,this);
                    if (!targ.length) return;
                case 'object':
                    // DOMElement / jQuery
                    if (targ.is || targ.style)
                    // Get the real position of the target
                        toff = (targ = $(targ)).offset();
            }

            var offset = $.isFunction(settings.offset) && settings.offset(elem, targ) || settings.offset;

            $.each( settings.axis.split(''), function( i, axis ) {
                var Pos	= axis == 'x' ? 'Left' : 'Top',
                    pos = Pos.toLowerCase(),
                    key = 'scroll' + Pos,
                    old = elem[key],
                    max = $scrollTo.max(elem, axis);

                if (toff) {// jQuery / DOMElement
                    attr[key] = toff[pos] + ( win ? 0 : old - $elem.offset()[pos] );

                    // If it's a dom element, reduce the margin
                    if (settings.margin) {
                        attr[key] -= parseInt(targ.css('margin'+Pos)) || 0;
                        attr[key] -= parseInt(targ.css('border'+Pos+'Width')) || 0;
                    }

                    attr[key] += offset[pos] || 0;

                    if(settings.over[pos])
                    // Scroll to a fraction of its width/height
                        attr[key] += targ[axis=='x'?'width':'height']() * settings.over[pos];
                } else {
                    var val = targ[pos];
                    // Handle percentage values
                    attr[key] = val.slice && val.slice(-1) == '%' ?
                        parseFloat(val) / 100 * max
                        : val;
                }

                // Number or 'number'
                if (settings.limit && /^\d+$/.test(attr[key]))
                // Check the limits
                    attr[key] = attr[key] <= 0 ? 0 : Math.min( attr[key], max );

                // Queueing axes
                if (!i && settings.queue) {
                    // Don't waste time animating, if there's no need.
                    if (old != attr[key])
                    // Intermediate animation
                        animate( settings.onAfterFirst );
                    // Don't animate this axis again in the next iteration.
                    delete attr[key];
                }
            });

            animate( settings.onAfter );

            function animate( callback ) {
                $elem.animate( attr, duration, settings.easing, callback && function() {
                    callback.call(this, targ, settings);
                });
            };

        }).end();
    };

    // Max scrolling position, works on quirks mode
    // It only fails (not too badly) on IE, quirks mode.
    $scrollTo.max = function( elem, axis ) {
        var Dim = axis == 'x' ? 'Width' : 'Height',
            scroll = 'scroll'+Dim;

        if (!$(elem).is('html,body'))
            return elem[scroll] - $(elem)[Dim.toLowerCase()]();

        var size = 'client' + Dim,
            html = elem.ownerDocument.documentElement,
            body = elem.ownerDocument.body;

        return Math.max( html[scroll], body[scroll] )
            - Math.min( html[size]  , body[size]   );
    };

    function both( val ) {
        return $.isFunction(val) || typeof val == 'object' ? val : { top:val, left:val };
    };

    // AMD requirement
    return $scrollTo;
}));/*[{!jquery_scrollTo_js_ei1655r!}]*/;
/* END /2static/script/lib/jquery/plugins/jquery.scrollTo.js */
/* START /2static/script/fecru/hover.js */
/*eslint eqeqeq:0*/

window.FECRU = window.FECRU || {};
FECRU.HOVER = (function () {
    var opts = {
        onHover: true,
        fadeTime: 200,
        hideDelay: 500,
        showDelay: 220,
        width: 300,
        offsetX: -4,
        offsetY: 10,
        container: "body",
        cacheContent: false,
        closeOthers: false, // without setting this to false, mousing over a user hover after opening the share dialog
                            //    will close the share dialog
        useLiveEvents: true,
        initCallback: function () {
            //this.popup.refresh();
        }
    };
    var respCache = {};
    var CACHE_FOREVER = -1;
    var displayHandlerDefaultOpts = {
        createUrl: function () {
            throw new Error("must provide createUrl");
        },
        createCacheKey: function () {
            throw new Error("must provide createCacheKey");
        },
        createParams: function () {
            throw new Error("must provide createParams");
        },
        minutesToCache: CACHE_FOREVER,
        cacheType: "__all",
        createTemplateContent: function () {
            return "";
        }
    };
    /**
     * createDisplayHandler returns a function that handles the display of the hover popup, and is used as the display handler
     * to be passed into AJS.InlineDialog as the url parameter (which is overloaded to take a function like this one).
     * @param params The named parameter needs the following properties:
     * @property createUrl : a function that accepts a jquery elem of the trigger of the hover, and returns the url to get
     * the content of the hover.
     * @property createCacheKey : a function that accepts a jquery elem of the trigger, and returns a unique string key for
     * this hover. Used to cache the result of the call created by createUrl
     * @property createParams : a function that accepts a key (created from createCacheKey) and a jquery elem of the trigger,
     * and returns a hash of the parameters to be passed along in the ajax request to the url created by creatUrl.
     * @optionalproperty minutesToCache : number of minutes to cache the result of the call to the url created by createUrl.
     * Defaults to CACHE_FOREVER
     * @optionalproperty cachetype : a unique string that identifies the type of hover being shown. Used by invalidateCache() to
     * clear the cache of this type. can be null.
     * @optionalproperty createExtraParams : a function that accepts the trigger and returns a map of parameters to be passed to the server
     * @optionalproperty createTemplateContent : a function that accepts a key, and optionally the trigger and returns a string to be
     * placed in the spinner template.
     */
    var createDisplayHandler = function (params) {
        var options = AJS.$.extend({}, displayHandlerDefaultOpts, params);
        var minutesToCache = options.createUrl;
        var cachetype = options.minutesToCache;
        var createTemplateContent = options.createTemplateContent;
        var triggerIdSeq = 1;
        var prevTriggerId = -1;

        return function ($contentDiv, mouseOverTrigger, showPopup) {
            var $trigger = AJS.$(mouseOverTrigger);
            var url = options.createUrl($trigger);
            var key = options.createCacheKey($trigger);
            var cache = respCache[cachetype] || {};
            var cacheHit = cache[key] || {isHit: false};
            var lastFetchTime = cacheHit.lastFetchTime || 0;
            var cacheTimedOut = (minutesToCache !== CACHE_FOREVER) &&
                ((new Date().getTime() - lastFetchTime) > (minutesToCache * 1000 * 60));
            if (key) {

                var triggerId = $trigger.data('data-trigger-id');
                if (!triggerId) {
                    triggerId = triggerIdSeq++;
                    $trigger.data('data-trigger-id', triggerId)
                }

                if (triggerId != prevTriggerId) {
                    $contentDiv.closest('.aui-inline-dialog').stop().hide();
                    prevTriggerId = triggerId;
                } else {
                    showPopup();
                    return;
                }

                $contentDiv.data("targetToDisplay", {key: key});
                var error = function (xmlHttpRequest, textStatus, errorThrown) {
                    $contentDiv.html(escape(textStatus) + "<br>" + escape(errorThrown ? errorThrown : ""));
                };
                var delayedShowSpinner;
                var done = function (resp) {
                    if (resp.worked) {
                        if (delayedShowSpinner) {
                            clearTimeout(delayedShowSpinner);
                        }
                        if ($contentDiv.data("targetToDisplay").key == key) {
                            $contentDiv.html(resp.html);
                            // show the popup if the spinner wasn't shown (either canceled or not supplied)
                            if (!createTemplateContent || delayedShowSpinner) {
                                showPopup();
                            }
                        }
                        // save result to cache
                        cacheHit.resp = resp;
                        cacheHit.lastFetchTime = new Date().getTime();
                        cacheHit.isHit = true;
                        cache[key] = cacheHit;
                        respCache[cachetype] = cache;
                    } else {
                        $contentDiv.html('<div class="hoverpopup">' + resp.errorMsg + '</div>');
                    }
                };
                if ((!cacheHit.isHit) || cacheTimedOut) {
                    AJS.$.ajax({
                        url: url,
                        data: options.createParams(key, $trigger),
                        type: "GET",
                        dataType: "json",
                        success: done,
                        error: error
                    });
                    // show the spinner if the template is provided, delaying it for a bit
                    if (createTemplateContent) {
                        delayedShowSpinner = setTimeout(function () {
                            if ($contentDiv.data("targetToDisplay").key == key) {
                                $contentDiv.html(getSpinnerTemplate(createTemplateContent(key, $trigger)));
                                showPopup();
                            }
                        }, 150);
                    }
                } else {
                    $contentDiv.html(cacheHit.resp.html);
                    showPopup();
                }
            }
        };
    };

    var invalidateCache = function (type, key) {
        if (!key) {
            respCache[type] = undefined;
        } else if (respCache[type]) {
            respCache[type][key] = undefined;
        }
    };

    var addAllLinkPopups = function () {
        if (!FECRU.isJiraIntegrationPluginEnabled) {
            addJiraLinkPopups(); // only show these when there is a JIRA 4.4 server (when the JIRA integration plugin is disabled)
        }
        addCruLinkPopups();
        addCsLinkPopups();
        addUserLinkPopups();
        addDeletedUserLinkPopups();
    };

    var addJiraLinkPopups = function () {
        var jiraShowDelay = 300;
        addLinkPopups({
            linkSpanClass: "jira-hover-trigger",
            url: FECRU.pageContext + '/json/action/issue-tooltip.do',
            showDelay: jiraShowDelay
        });
    };

    var addCruLinkPopups = function () {
        addLinkPopups({
            linkSpanClass: "crulinkspan",
            url: FECRU.pageContext + '/json/cru/tooltipdata',
            keyParser: function ($trigger) {
                var $permaId = $trigger.find('input.permaId');
                if ($permaId.length === 1) {
                    return $permaId.val();
                }
                return $trigger.find('a').text();
            }
        });
    };

    var addCsLinkPopups = function () {
        var changesetKeyPattern = /^(\/\/([^/]+)\/)(.+)$/;
        var getRepositoryName = function ($trigger) {
            return $trigger.data('repname') || $trigger.find('input.repname').val();
        };
        var getChangesetId = function ($trigger) {
            return $trigger.data('csid') || $trigger.find('input.csid').val();
        };

        addLinkPopups({
            linkSpanClass: "cslinkspan",
            url: FECRU.pageContext + '/json/action/cstooltipdata.do',
            keyParser: function ($trigger) {
                var repositoryName = getRepositoryName($trigger);
                var changesetId = getChangesetId($trigger);

                return '//' + repositoryName + '/' + changesetId;
            },
            createTemplateContent: function (key) {
                var matches = changesetKeyPattern.exec(key);
                if (matches) {
                    var changesetId = matches[3];
                    var repository = matches[2];
                    //abbrev. the id if too long
                    changesetId = changesetId.length > 10 ? changesetId.substring(0, 6) + "..." : changesetId;
                    return "changeset " + changesetId + " in " + repository;
                } else {
                    return "changeset";
                }
            },
            createExtraParams: function ($trigger) {
                return {
                    "repname": getRepositoryName($trigger),
                    "csid": getChangesetId($trigger)
                };
            }
        });
    };

    var getUrlParts = function (url) {
        var a = document.createElement('a');
        a.href = url;

        return {
            href: a.href,
            host: a.host,
            hostname: a.hostname,
            port: a.port,
            pathname: (a.pathname.charAt(0) === "/") ? a.pathname : "/" + a.pathname,
            protocol: a.protocol,
            hash: a.hash,
            search: a.search
        };
    };

    var addLinkPopups = function (params) {
        var defaults = {
            //the css class to bind the hover trigger to
            linkSpanClass: '',
            //the url to request the content of the trigger
            url: '',
            //how much to delay showing of the hover when triggered
            showDelay: opts.showDelay,
            //given the trigger jquery elem, return a unique string usable as a key for the cache
            keyParser: function ($trigger) {
                return $trigger.text();
            },
            //given the key and trigger, return something to display in the spinner message. can be an empty string.
            createTemplateContent: function (key, $trigger) {
                return key;
            }
        };
        var options = AJS.$.extend({}, defaults, params);
        var linkSpanClass = options.linkSpanClass;
        var displayHandler = createDisplayHandler({
            createUrl: function () {
                return options.url;
            },
            createCacheKey: function ($trigger) {
                var $keylink = AJS.$("a", $trigger);
                if ($keylink.length === 0) {
                    $keylink = $trigger;
                }
                var key = options.keyParser($keylink);
                key = AJS.$.trim(key);
                return key;
            },
            createParams: function (key, $trigger) {
                var extraParams = (options.createExtraParams && options.createExtraParams($trigger)) || {};
                return AJS.$.extend(false, extraParams, {key: key});
            },
            cacheType: linkSpanClass + "cache",
            createTemplateContent: options.createTemplateContent
        });
        var hoverOpts = AJS.$.extend(false, opts, {showDelay: options.showDelay});
        AJS.InlineDialog("." + linkSpanClass, linkSpanClass + "-popup", displayHandler, hoverOpts);
    };

    var addUserLinkPopups = function () {
        var getHref = function ($trigger) {
            var href = $trigger.attr('href');
            if (!href) {
                href = $trigger.parent().attr('href');//sometimes the trigger is the child
            }
            var parts = getUrlParts(href);
            // we need to make this relative, because wiki markup renders absolute links, which may be to a different
            // hostname than the one from which this page was loaded.
            return parts.pathname;
        };
        var displayHandler = createDisplayHandler({
            createUrl: function ($trigger) {
                return getHref($trigger);
            },
            createCacheKey: function ($trigger) {
                return getHref($trigger);
            },
            createParams: function () {
                return {ajax: "true"};
            },
            cacheType: 'userlinks',
            createTemplateContent: function (key, $trigger) {
                var $linkText = $trigger.hasClass('linkText') ? $trigger : $trigger.find(".linkText");
                if ($linkText.length === 0) {
                    //if the linkText doesnt exist, which does happen for avartars with no displayed name
                    return key.replace(/^.*\//, "");//remove all but the username
                } else {
                    return $linkText.text();
                }
            }
        });
        AJS.InlineDialog("a.userorcommitter,a.userorcommitter-parent .linkText", "user-hover-inline-dialog", displayHandler, opts);
    };

    var addDeletedUserLinkPopups = function () {
        var hoverContent = function ($contents, trigger, showPopup) {
            var $trigger = AJS.$(trigger);
            $contents.html(
                "<div class='user-hover-info'>" +
                "<div class='user-hover-avatar'>" +
                "<img height='48' width='48' alt='Deleted User' src='" + FECRU.pageContext + "/avatar/deleted' />" +
                "</div>" +
                "<div class='user-hover-details'>" +
                "<h4><span class='linkText'></span></h4>" +
                "<em>(deleted user)</em>" +
                "</div>"
            );
            var usernameSpan = $trigger.find(".hidden-username");
            if (usernameSpan) {
                $contents.find("span.linkText").text(usernameSpan.text());
            }
            showPopup();
        };
        AJS.InlineDialog("a.deleteduser,a.deleteduser-parent .linkText", "deleted-user-hover-inline-dialog", hoverContent, opts);
    };

    var getSpinnerTemplate = function (content) {
        // Don't add the content directly into the spinner, as it may contain unescaped HTML content.
        // The workaround is to create a jQuery object and call .text(), and then return the html of the constructed object.
        var $elem = AJS.$('<div><div class="hoverpopup-throb jirahoverpopup-throb">' +
            '<img src="' + FECRU.pageContext + '/' + FECRU.staticDirectory +
            '/2static/images/spinner_003366.gif" alt="Retrieving details">' +
            '<em class="hoverpopup-throbber-text">Retrieving ' +
            '<span class="hoverpopup-throbber-text-content">' +
            '</span>...</em></div></div>');
        $elem.find(".hoverpopup-throbber-text-content").text(content);
        return $elem.html();
    };

    return {
        addAllLinkPopups: addAllLinkPopups,
        invalidateCache: invalidateCache,
        CACHE_FOREVER: CACHE_FOREVER
    };
})();
/*[{!hover_js_75n453s!}]*/;
/* END /2static/script/fecru/hover.js */
/* START /2static/script/fecru/issue-dialog.js */
window.FECRU = window.FECRU || {};
FECRU.ISSUEDIALOG = (function () {

    var dialog;

    AJS.$(document).ready(function () {
        if (!FECRU.isJiraIntegrationPluginEnabled || // dont set up the issue dialog event when there is a JIRA 4.4 server (when the JIRA integration plugin is disabled)
            !window.top.jiraIntegration) { // if we're in an iframe with no outer window
            return;
        }

        var getDialog = function (self, e) {
            if (!dialog) {
                dialog = new window.top.jiraIntegration.JiraIssuesDialog({
                    oauthTriggerClass: 'ual-authenticate',
                    ajax: function (options) {
                        return AJS.$.ajax(AJS.$.extend({
                            cache: false // so IE doesnt cache it
                        }, options));
                    }
                });

                var onTransitioned = function (issueKey) {
                    setTimeout(function () {
                        CRU.UI.reloadInlineJiraIssues([issueKey]);
                        if (window.RIL && AJS.$('.jira-issues-report-row[data-jira-issue-key=' + issueKey + ']').length) {
                            RIL.insertReviewReport();
                        }
                    }, 0);
                };

                dialog.on('transitioned', onTransitioned);
            }
            dialog.on('authorizationRequired', function (authUrl, applicationName) {
                window.top.FECRU.OAUTH.getEventProducer(authUrl).authorized(function () {
                    window.top.FECRU.HOVER.invalidateCache(window.top.FECRU.HOVER.CACHE_FOREVER); // we dont know what key to remove, so remove all
                    if (typeof window.top.CRU !== 'undefined' && window.top.CRU.UI && window.top.CRU.UI.loadInlineJiraIssues) {
                        window.top.CRU.UI.loadInlineJiraIssues(); // might as well reload all issues
                    }
                    dialog.onAuthorizationSucceeded(authUrl);
                });
            });

            var issueKey;
            var $this = AJS.$(self);
            if ($this.is('a')) {
                issueKey = $this.text();
            } else {
                issueKey = $this.children('a').text();
            }

            if (typeof window.top.review !== 'undefined' && window.top.review.projectKey()) {
                dialog.setEntityKey('project.' + window.top.review.projectKey());
            } else if (window.top.FECRU && window.top.FECRU.INFO && window.top.FECRU.INFO.repoName) {
                dialog.setEntityKey('repository.' + window.top.FECRU.INFO.repoName);
            } else {
                dialog.setEntityKey(null);
            }

            dialog.setIssueKeys([issueKey]);
            dialog.setTitle('JIRA Issue \'' + issueKey + '\'');

            return dialog;
        };

        AJS.$('body').delegate('.jira-hover-trigger', 'click', function (e) {
            // Right click fires a click event in Firefox but not in Chrome
            if (FECRU.isRightClick(e) || !FECRU.openInSameTab(e)) {
                return;
            }
            e.stopPropagation();
            e.preventDefault();

            var dialog = getDialog(this, e);

            dialog.show();
        });
    });

})();
/*[{!issue_dialog_js_n95s53u!}]*/;
/* END /2static/script/fecru/issue-dialog.js */
/* START /2static/script/lib/ZeroClipboard-1.2.1.min.js */
/*!
* ZeroClipboard
* The ZeroClipboard library provides an easy way to copy text to the clipboard using an invisible Adobe Flash movie and a JavaScript interface.
* Copyright (c) 2013 Jon Rohan, James M. Greene
* Licensed MIT
* http://zeroclipboard.org/
* v1.2.1
*/
!function(){"use strict";var a,b=function(){var a=/\-([a-z])/g,b=function(a,b){return b.toUpperCase()};return function(c){return c.replace(a,b)}}(),c=function(a,c){var d,e,f,g,h,i;if(window.getComputedStyle?d=window.getComputedStyle(a,null).getPropertyValue(c):(e=b(c),d=a.currentStyle?a.currentStyle[e]:a.style[e]),"cursor"===c&&(!d||"auto"===d))for(f=a.tagName.toLowerCase(),g=["a"],h=0,i=g.length;i>h;h++)if(f===g[h])return"pointer";return d},d=function(a){if(p.prototype._singleton){a||(a=window.event);var b;this!==window?b=this:a.target?b=a.target:a.srcElement&&(b=a.srcElement),p.prototype._singleton.setCurrent(b)}},e=function(a,b,c){a.addEventListener?a.addEventListener(b,c,!1):a.attachEvent&&a.attachEvent("on"+b,c)},f=function(a,b,c){a.removeEventListener?a.removeEventListener(b,c,!1):a.detachEvent&&a.detachEvent("on"+b,c)},g=function(a,b){if(a.addClass)return a.addClass(b),a;if(b&&"string"==typeof b){var c=(b||"").split(/\s+/);if(1===a.nodeType)if(a.className){for(var d=" "+a.className+" ",e=a.className,f=0,g=c.length;g>f;f++)d.indexOf(" "+c[f]+" ")<0&&(e+=" "+c[f]);a.className=e.replace(/^\s+|\s+$/g,"")}else a.className=b}return a},h=function(a,b){if(a.removeClass)return a.removeClass(b),a;if(b&&"string"==typeof b||void 0===b){var c=(b||"").split(/\s+/);if(1===a.nodeType&&a.className)if(b){for(var d=(" "+a.className+" ").replace(/[\n\t]/g," "),e=0,f=c.length;f>e;e++)d=d.replace(" "+c[e]+" "," ");a.className=d.replace(/^\s+|\s+$/g,"")}else a.className=""}return a},i=function(){var a,b,c,d=1;return"function"==typeof document.body.getBoundingClientRect&&(a=document.body.getBoundingClientRect(),b=a.right-a.left,c=document.body.offsetWidth,d=Math.round(100*(b/c))/100),d},j=function(a){var b={left:0,top:0,width:0,height:0,zIndex:999999999},d=c(a,"z-index");if(d&&"auto"!==d&&(b.zIndex=parseInt(d,10)),a.getBoundingClientRect){var e,f,g,h=a.getBoundingClientRect();"pageXOffset"in window&&"pageYOffset"in window?(e=window.pageXOffset,f=window.pageYOffset):(g=i(),e=Math.round(document.documentElement.scrollLeft/g),f=Math.round(document.documentElement.scrollTop/g));var j=document.documentElement.clientLeft||0,k=document.documentElement.clientTop||0;b.left=h.left+e-j,b.top=h.top+f-k,b.width="width"in h?h.width:h.right-h.left,b.height="height"in h?h.height:h.bottom-h.top}return b},k=function(a,b){var c=!(b&&b.useNoCache===!1);return c?(-1===a.indexOf("?")?"?":"&")+"nocache="+(new Date).getTime():""},l=function(a){var b=[],c=[];return a.trustedOrigins&&("string"==typeof a.trustedOrigins?c.push(a.trustedOrigins):"object"==typeof a.trustedOrigins&&"length"in a.trustedOrigins&&(c=c.concat(a.trustedOrigins))),a.trustedDomains&&("string"==typeof a.trustedDomains?c.push(a.trustedDomains):"object"==typeof a.trustedDomains&&"length"in a.trustedDomains&&(c=c.concat(a.trustedDomains))),c.length&&b.push("trustedOrigins="+encodeURIComponent(c.join(","))),"string"==typeof a.amdModuleId&&a.amdModuleId&&b.push("amdModuleId="+encodeURIComponent(a.amdModuleId)),"string"==typeof a.cjsModuleId&&a.cjsModuleId&&b.push("cjsModuleId="+encodeURIComponent(a.cjsModuleId)),b.join("&")},m=function(a,b){if(b.indexOf)return b.indexOf(a);for(var c=0,d=b.length;d>c;c++)if(b[c]===a)return c;return-1},n=function(a){if("string"==typeof a)throw new TypeError("ZeroClipboard doesn't accept query strings.");return a.length?a:[a]},o=function(a,b,c,d,e){e?window.setTimeout(function(){a.call(b,c,d)},0):a.call(b,c,d)},p=function(a,b){if(a&&(p.prototype._singleton||this).glue(a),p.prototype._singleton)return p.prototype._singleton;p.prototype._singleton=this,this.options={};for(var c in s)this.options[c]=s[c];for(var d in b)this.options[d]=b[d];this.handlers={},p.detectFlashSupport()&&v()},q=[];p.prototype.setCurrent=function(b){a=b,this.reposition();var d=b.getAttribute("title");d&&this.setTitle(d);var e=this.options.forceHandCursor===!0||"pointer"===c(b,"cursor");return r.call(this,e),this},p.prototype.setText=function(a){return a&&""!==a&&(this.options.text=a,this.ready()&&this.flashBridge.setText(a)),this},p.prototype.setTitle=function(a){return a&&""!==a&&this.htmlBridge.setAttribute("title",a),this},p.prototype.setSize=function(a,b){return this.ready()&&this.flashBridge.setSize(a,b),this},p.prototype.setHandCursor=function(a){return a="boolean"==typeof a?a:!!a,r.call(this,a),this.options.forceHandCursor=a,this};var r=function(a){this.ready()&&this.flashBridge.setHandCursor(a)};p.version="1.2.1";var s={moviePath:"ZeroClipboard.swf",trustedOrigins:null,text:null,hoverClass:"zeroclipboard-is-hover",activeClass:"zeroclipboard-is-active",allowScriptAccess:"sameDomain",useNoCache:!0,forceHandCursor:!1};p.setDefaults=function(a){for(var b in a)s[b]=a[b]},p.destroy=function(){p.prototype._singleton.unglue(q);var a=p.prototype._singleton.htmlBridge;a.parentNode.removeChild(a),delete p.prototype._singleton},p.detectFlashSupport=function(){var a=!1;if("function"==typeof ActiveXObject)try{new ActiveXObject("ShockwaveFlash.ShockwaveFlash")&&(a=!0)}catch(b){}return!a&&navigator.mimeTypes["application/x-shockwave-flash"]&&(a=!0),a};var t=null,u=null,v=function(){var a=p.prototype._singleton,b=document.getElementById("global-zeroclipboard-html-bridge");if(!b){var c={};for(var d in a.options)c[d]=a.options[d];c.amdModuleId=t,c.cjsModuleId=u;var e=l(c),f='      <object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" id="global-zeroclipboard-flash-bridge" width="100%" height="100%">         <param name="movie" value="'+a.options.moviePath+k(a.options.moviePath,a.options)+'"/>         <param name="allowScriptAccess" value="'+a.options.allowScriptAccess+'"/>         <param name="scale" value="exactfit"/>         <param name="loop" value="false"/>         <param name="menu" value="false"/>         <param name="quality" value="best" />         <param name="bgcolor" value="#ffffff"/>         <param name="wmode" value="transparent"/>         <param name="flashvars" value="'+e+'"/>         <embed src="'+a.options.moviePath+k(a.options.moviePath,a.options)+'"           loop="false" menu="false"           quality="best" bgcolor="#ffffff"           width="100%" height="100%"           name="global-zeroclipboard-flash-bridge"           allowScriptAccess="always"           allowFullScreen="false"           type="application/x-shockwave-flash"           wmode="transparent"           pluginspage="http://www.macromedia.com/go/getflashplayer"           flashvars="'+e+'"           scale="exactfit">         </embed>       </object>';b=document.createElement("div"),b.id="global-zeroclipboard-html-bridge",b.setAttribute("class","global-zeroclipboard-container"),b.setAttribute("data-clipboard-ready",!1),b.style.position="absolute",b.style.left="-9999px",b.style.top="-9999px",b.style.width="15px",b.style.height="15px",b.style.zIndex="9999",b.innerHTML=f,document.body.appendChild(b)}a.htmlBridge=b,a.flashBridge=document["global-zeroclipboard-flash-bridge"]||b.children[0].lastElementChild};p.prototype.resetBridge=function(){return this.htmlBridge.style.left="-9999px",this.htmlBridge.style.top="-9999px",this.htmlBridge.removeAttribute("title"),this.htmlBridge.removeAttribute("data-clipboard-text"),h(a,this.options.activeClass),a=null,this.options.text=null,this},p.prototype.ready=function(){var a=this.htmlBridge.getAttribute("data-clipboard-ready");return"true"===a||a===!0},p.prototype.reposition=function(){if(!a)return!1;var b=j(a);return this.htmlBridge.style.top=b.top+"px",this.htmlBridge.style.left=b.left+"px",this.htmlBridge.style.width=b.width+"px",this.htmlBridge.style.height=b.height+"px",this.htmlBridge.style.zIndex=b.zIndex+1,this.setSize(b.width,b.height),this},p.dispatch=function(a,b){p.prototype._singleton.receiveEvent(a,b)},p.prototype.on=function(a,b){for(var c=a.toString().split(/\s/g),d=0;d<c.length;d++)a=c[d].toLowerCase().replace(/^on/,""),this.handlers[a]||(this.handlers[a]=b);return this.handlers.noflash&&!p.detectFlashSupport()&&this.receiveEvent("onNoFlash",null),this},p.prototype.addEventListener=p.prototype.on,p.prototype.off=function(a,b){for(var c=a.toString().split(/\s/g),d=0;d<c.length;d++){a=c[d].toLowerCase().replace(/^on/,"");for(var e in this.handlers)e===a&&this.handlers[e]===b&&delete this.handlers[e]}return this},p.prototype.removeEventListener=p.prototype.off,p.prototype.receiveEvent=function(b,c){b=b.toString().toLowerCase().replace(/^on/,"");var d=a,e=!0;switch(b){case"load":if(c&&parseFloat(c.flashVersion.replace(",",".").replace(/[^0-9\.]/gi,""))<10)return this.receiveEvent("onWrongFlash",{flashVersion:c.flashVersion}),void 0;this.htmlBridge.setAttribute("data-clipboard-ready",!0);break;case"mouseover":g(d,this.options.hoverClass);break;case"mouseout":h(d,this.options.hoverClass),this.resetBridge();break;case"mousedown":g(d,this.options.activeClass);break;case"mouseup":h(d,this.options.activeClass);break;case"datarequested":var f=d.getAttribute("data-clipboard-target"),i=f?document.getElementById(f):null;if(i){var j=i.value||i.textContent||i.innerText;j&&this.setText(j)}else{var k=d.getAttribute("data-clipboard-text");k&&this.setText(k)}e=!1;break;case"complete":this.options.text=null}if(this.handlers[b]){var l=this.handlers[b];"string"==typeof l&&"function"==typeof window[l]&&(l=window[l]),"function"==typeof l&&o(l,d,this,c,e)}},p.prototype.glue=function(a){a=n(a);for(var b=0;b<a.length;b++)-1==m(a[b],q)&&(q.push(a[b]),e(a[b],"mouseover",d));return this},p.prototype.unglue=function(a){a=n(a);for(var b=0;b<a.length;b++){f(a[b],"mouseover",d);var c=m(a[b],q);-1!=c&&q.splice(c,1)}return this},"function"==typeof define&&define.amd?define(["require","exports","module"],function(a,b,c){return t=c&&c.id||null,p}):"object"==typeof module&&module&&"object"==typeof module.exports&&module.exports?(u=module.id||null,module.exports=p):window.ZeroClipboard=p}();/*[{!ZeroClipboard_1_2_1_min_js_vsrm54r!}]*/;
/* END /2static/script/lib/ZeroClipboard-1.2.1.min.js */
/* START /2static/script/fecru/selection-history.js */
window.FECRU = window.FECRU || {};

FECRU.SELECTIONHISTORY = FECRU.SELECTIONHISTORY || {};

(function ($) {

    $(document).ready(function (e) {

        FECRU.SELECTIONHISTORY.displayDiff = function (revId, iframeheight) {
            var $iframeHolder = AJS.$('#iframe-holder');

            if (AJS.$('html').hasClass('safari')) {
                $iframeHolder.children().css('display', 'none');
            } else {
                $iframeHolder.children().css('visibility', 'hidden');
            }

            $iframeHolder.children('.aui-message').remove();
            var $iframe = $iframeHolder.children('#diff-' + revId);

            var $row = AJS.$('#revision-selection #rev-' + revId);
            var match = $row.data('match');
            var diff = $row.data('diff');
            var url = $row.find('.iframe-url').text().trim();

            var messageHeight = 0;
            if (!match) {
                // we need to display a message
                AJS.messages.warning($iframeHolder, {
                    id: "reselect-warning",
                    insert: "prepend",
                    title: "Time to rescope the search!",
                    body: "We've gone back so far that the lines have become a bit blurry. If you still haven't found what you're after, select the relevant lines from this revision."
                });
                messageHeight = $iframeHolder.children('.aui-message').outerHeight() + 20;
            } else if (!diff) {
                AJS.messages.info($iframeHolder, {
                    id: "reselect-warning",
                    insert: "prepend",
                    title: "We've hit the end!",
                    body: "This is the initial revision of this file. If you still haven't found what you're after, it may have come from a cross-file refactor. Have a look at the commit."
                });
                messageHeight = $iframeHolder.children('.aui-message').outerHeight() + 20;
            }

            if (!$iframe.length) {
                // we need to insert it
                //.attr('src', AJS.$(this).children('span').text());
                $iframeHolder.append(AJS.$('<iframe id="diff-' + revId + '" width="100%" height="' + (iframeheight - 101 - messageHeight) + 'px" src="' + url + '"></iframe>'))
            }

            if (AJS.$('html').hasClass('safari')) {
                $iframe.css('display', 'block');
            } else {
                $iframe.css('visibility', 'visible');
            }

        };

        if (!FECRU.isSelectionHistoryEnabled) {
            return;
        }

        if ($.browser.msie && $.browser.version.substring(0, 2) === '8.') {
            return; // don't support IE8 because it cant easily provide us with the selected lines
        }

        $('body').append('<div id="copy-clipboard">' +
            '<span id="clipboard-container">' +
            '<div id="clipboard-button">Copy</div>' +
            '</span>' +
            '<span id="super-blame">' +
            '<div id="blame-button">Blame</div>' +
            '</span>' +
            '</div>');

        ZeroClipboard.setDefaults({
            moviePath: FECRU.pageContext + '/' + FECRU.staticDirectory + '/2static/flash/ZeroClipboard-1.2.1.swf',
            hoverClass: 'zeroclipboard-is-hover',
            activeClass: "zeroclipboard-is-active"
        });
        var $clipboardButton = AJS.$('#clipboard-button');
        var clipboard = new ZeroClipboard($clipboardButton);

        clipboard.on('noflash', function () {
            $clipboardButton.addClass('hide');
        });
        clipboard.on('wrongflash', function () {
            $clipboardButton.addClass('hide');
        });
        clipboard.on('mouseup', function () {
            AJS.$("#copy-clipboard").css("left", "-999px");
        });

        $(document).delegate("body", "keyup", function (e) {
            if (e.keyCode === 27) {
                $("#copy-clipboard").hide();
            }
        });

        // fancy renderer
        $(document).delegate(".diff-container", "mouseup", function (e) {
            var nodes = getSelectedNodes(e);
            if (!nodes) {
                return true
            }

            var anchorLine = getLineNumberFancyRenderer(nodes.anchorNode);
            var focusLine = getLineNumberFancyRenderer(nodes.focusNode);

            var $diffContentBox = $(nodes.anchorNode).closest('.content-box');

            selectLines(e, anchorLine, focusLine, $diffContentBox.data('path'), $diffContentBox.data('revision'));

            return true;
        });

        // unified diff (single file + changeset)
        $(document).delegate(".annPane.view-diff, .changeset-page #panel-target", "mouseup", function (e) {
            var nodes = getSelectedNodes(e);
            if (!nodes) {
                return true
            }

            var anchorLine = getLineNumberForUnifiedDiff(nodes.anchorNode);
            var focusLine = getLineNumberForUnifiedDiff(nodes.focusNode);

            var $diffTable = $(nodes.anchorNode).closest('table.diff');

            selectLines(e, anchorLine, focusLine, $diffTable.data('path'), $diffTable.data('revision'));

            return true;
        });

        var selectLines = function (e, anchorLine, focusLine, path, revision) {
            var lowestLine = anchorLine < focusLine ? anchorLine : focusLine;
            var highestLine = anchorLine >= focusLine ? anchorLine : focusLine;

            var $copyClipboard = $("#copy-clipboard");
            $copyClipboard.show();
            $copyClipboard.css({
                top: e.pageY + 8,
                left: e.pageX + 8
            });
            $("#blame-button").data('lowLine', lowestLine)
                .data('highLine', highestLine)
                .data('path', path)
                .data('revision', revision);
        };

        window.top.FE.BLAME = window.top.FE.BLAME || {};

        AJS.$('#blame-button').click(function () {
            var $this = $(this);
            var highLine = $this.data('highLine');
            var lowLine = $this.data('lowLine');
            var path = $this.data('path');
            var revision = $this.data('revision');

            var url = FECRU.pageContext + '/line-history/' + window.top.FECRU.INFO.repoName + '/' + path + '?r=' + revision;
            url += '&from=' + lowLine + '&to=' + highLine;

            if (!window.top.FE.BLAME.$dialog) {
                window.top.FE.BLAME.$dialog = window.top.FECRU.DIALOG.ajaxDialog(1280, 768, {}, "super-blame");
                var iframeHeight = window.top.FE.BLAME.$dialog.height - 109;
                window.top.FE.BLAME.$dialog
                    .addHeader("Selection history for revision '" + revision + "' at lines " + lowLine + " to " + highLine)
                    .addPanel("Super Blame", "<div id='" + 'blame-panel' + "'></div>")
                    .addButton("Close", function (d) {
                        d.hide();
                    }, "cancelButton");
                window.top.AJS.$('#blame-panel').append(buildIframe(iframeHeight, url));
            } else {
                window.top.FE.BLAME.$dialog.addHeader("Selection history for revision '" + revision + "' at lines " + lowLine + " to " + highLine);
                iframeHeight = window.top.FE.BLAME.$dialog.height - 109;
                window.top.AJS.$('.selection-history-frame').remove();
                window.top.AJS.$('#blame-panel').append(buildIframe(iframeHeight, url));
            }
            window.top.FE.BLAME.$dialog.show();

            $("#copy-clipboard").hide();
        });

        var buildIframe = function (height, url) {
            return $("<iframe class='selection-history-frame' width='100%' height='" + height + "px' src='" + url + "&iframeHeight=" + height + "'/>");
        };

        var getLineNumberForUnifiedDiff = function (node) {
            var $row = $(node).closest('tr');
            var $commonLineNumbers = $row.children('.diffLineNumbers');
            var $toLineNumbers = $row.children('.diffLineNumbersB');
            var $fromLineNumbers = $row.children('.diffLineNumbersA');
            if ($commonLineNumbers.length) {
                return parseInt($($commonLineNumbers.get(0)).text(), 10);
            } else if ($toLineNumbers.length) {
                return parseInt($($toLineNumbers.get(1)).text(), 10);
            } else if ($fromLineNumbers.length) {
                return parseInt($($fromLineNumbers.get(0)).data("to-equiv"), 10);
            }
            return null;
        };

        var getLineNumberFancyRenderer = function (node) {
            var $row = $(node).closest('pre');
            return parseInt($row.children('.line-num').attr('title'), 10);
        };

        var getSelectedNodes = function (e) {
            var selection = window.getSelection();
            if (selection.anchorNode == null ||
                $(e.target).attr('id') === 'blame-button') {
                return null;
            }

            return {
                anchorNode: selection.anchorNode,
                focusNode: selection.focusNode
            }
        };

    });

})(AJS.$);
/*[{!selection_history_js_de2a546!}]*/;
/* END /2static/script/fecru/selection-history.js */
/* START /2static/script/fecru/ui.js */
window.FECRU = window.FECRU || {};
FECRU.UI = FECRU.UI || {};

(function () {

    var hasSetDropdowns = false;

    var enabledAnimations = true;
    if (AJS.$.browser.msie && AJS.$.browser.version < 9) {
        enabledAnimations = false;
    }

    FECRU.UI.setDropdowns = function () {
        if (hasSetDropdowns) {
            AJS.log("WARNING: About to set duplicated dropdown live events");
        } else {
            hasSetDropdowns = true;
        }

        var options = {
            selectionHandler: function () {
                // Prevent AUI from reimplementing default browser handling of <a> elements.
                // May need to revisit depending on AUI changes (see CR-FE-1617).
            },
            useLiveEvents: true, //using live meant that hovers will no longer need to perform a dropdown bind on load
            trigger: '.aui-dd-link'
        };

        options.dropDown = ".aui-dropdown-left:not(.aui-dropdown-ajax)";
        options.alignment = "left";
        AJS.dropDown.Standard(AJS.$.extend({}, options));

        options.dropDown = ".aui-dropdown-right:not(.aui-dropdown-ajax)";
        options.alignment = "right";
        AJS.dropDown.Standard(AJS.$.extend({}, options));
    };

    FECRU.UI.filterToggle = function (filters) {
        return AJS.dropDown.Standard({
            trigger: ".filter-toggle",
            dropDown: filters,
            alignment: 'right'
        });
    };

    /**
     * Setup a delegated event for the (+2 more) links for branches, tags, parents etc.
     * Currently used in the changeset and file history pages
     * @param $container
     */
    FECRU.UI.registerMetadataExpanders = function ($container) {
        $container.delegate(".metadata-plus a", "click", function () {
            var $p = AJS.$(this).parent();
            $p.siblings(".hidden").removeClass("hidden");
            $p.hide();
        });
    };

    var linkAugment = function () {
        AJS.$("a[rel='help']").attr("target", "_help");

        // details switch in stream
        // todo delete?
        AJS.$(".details-switch").unbind().click(function () {
            AJS.$(this).toggleClass("details-expanded");

            var $verbose = AJS.$(this).siblings(".details-verbose");
            if ($verbose.css("display") === "none") {//toggle() is broken in IE8, so checking display
                $verbose.show();
            }
            else {
                $verbose.hide();
            }
        });

        // inline hover in stream
        AJS.$(".hover").mouseover(function (event) {
            AJS.$("#hover").addClass("mouseover");
            inlineHover(AJS.$(this), event);
        });

        AJS.$("#hover").mouseout(function () {
            var which = AJS.$(this);
            which.bind("mouseleave", function () {
                AJS.$(which)
                    .removeClass("mouseover")
                    .hide();
            });
        });
        AJS.$("hover-close").click(function () {
            AJS.$(this).hide();
        });
    };

    var $focusedTableRow;
    FECRU.UI.tableRowClick = function (prefix, rowClickFn) {
        AJS.$(document).delegate("#" + prefix + "-table > tbody > tr", "click", function () {
            var clearFocus = function () {
                if ($focusedTableRow) {
                    $focusedTableRow.removeClass(prefix + "-focus");
                }
            };

            var $this = AJS.$(this);
            if ($this.hasClass(prefix + "-focus")) {
                clearFocus();
                $focusedTableRow = null;
            } else {
                clearFocus();
                $this.addClass(prefix + "-focus");
                $focusedTableRow = $this;
                if (rowClickFn) {
                    rowClickFn(this);
                }
            }
        });
    };

    FECRU.UI.tableSort = function (prefix, extractionFn) {
        var params = {};
        if (extractionFn) {
            params['textExtraction'] = extractionFn;
        }
        AJS.$("#" + prefix + "-table").tablesorter(params);
    };

    FECRU.UI.accordion = function () {
        AJS.$(document).delegate('.sidebar-collapse', "click", function () {
            AJS.$('#content').toggleClass('collapsed-sidebar');
            return false;
        }).delegate(".accordion-head", "click", function () {
            var $next = AJS.$(this).next();
            var $parent = AJS.$(this).parent();

            if ($next.is(":hidden")) {
                $parent.addClass("active");
                if (enabledAnimations) {
                    $next.slideDown("fast");
                } else {
                    $next.show();
                }
            }
            else {
                if (enabledAnimations) {
                    $next.slideUp("fast", function () {
                        $parent.removeClass("active");
                    });
                } else {
                    $next.hide();
                    $parent.removeClass("active");
                }
            }
            return false;
        }).delegate("#accordion-toggle", "click", function () {
            var $accordionToggle = AJS.$(this);
            var $accordionContent = $accordionToggle.find(".accordion-content");
            var $parent = AJS.$(this).parent();
            var isExpanded = $accordionToggle.html() === 'expand';
            if (isExpanded) {
                $parent.addClass("active");
                if (enabledAnimations) {
                    $accordionContent.slideDown("fast");
                } else {
                    $accordionContent.show();
                }
            } else {
                if (enabledAnimations) {
                    $accordionContent.slideUp("fast", function () {
                        $parent.removeClass("active");
                    });
                } else {
                    $accordionContent.hide();
                    $parent.removeClass("active");
                }
            }
            $accordionToggle.html(isExpanded ? 'expand' : 'collapse'); // reverse (it's now "wasExpanded")
            return false;
        });
    };

    var inlineHover = function (which, event) {
        if (!AJS.$("#hover").hasClass("mouseover")) {
            return false;//don't fire if the link is no longer hovered
        }

        var source = which.attr("name").split("-")[0];
        var subject = which.attr("name").split("-")[1];
        var content;
        var offset = which.offset();
        var height = which.height();

        if (source === "user") {
            content = hovers.users[subject]; // eslint-disable-line no-undef
        }
        else if (source === "item") {
            content = hovers.items[subject]; // eslint-disable-line no-undef
        }

        AJS.$("#hover-content").html(content);
        AJS.$("#hover").css({
            display: "block",
            top: offset.top + height,
            left: offset.left
        });
    };

    FECRU.UI.initStream = function () {
        linkAugment();
    };

    FECRU.UI.contentPadBottom = function () {
        var contentPadding = AJS.$("#content").css("padding-bottom");
        var messageHeight = AJS.$("#footer-bar .system-message").height();
        var messagePadding = parseInt(contentPadding, 10) + messageHeight;
        AJS.$("#content").css("padding-bottom", messagePadding);
    };

    /**
     * checks if the dates in the elements ".calendar-date-end" and ".calendar-date-start" are in the correct order
     * and swap them around if they are found to be reversed.
     *
     * @param extractDateStringFn a function to extract the date string into the format 'yy-mm-dd' from the format
     * obtained in the value attribute of the input element
     */
    FECRU.UI.swapDatesIfReversed = function (extractDateStringFn, context) {
        context = context || "body";
        var endDateInput = AJS.$("input.calendar-date-end", context);
        var startDateInput = AJS.$("input.calendar-date-start", context);
        if (endDateInput.length > 0 && startDateInput.length > 0) {
            var startDateStr = startDateInput.val();
            var endDateStr = endDateInput.val();
            var extractedStartDate = extractDateStringFn(startDateStr);
            var extractedEndDate = extractDateStringFn(endDateStr);
            var startDate;
            var endDate;
            var errorThrown = false;

            try {
                startDate = AJS.$.datepicker.parseDate('yy-mm-dd', extractedStartDate);
            } catch (e) {
                FECRU.AJAX.appendErrorMessage("Could not parse start date " + extractedStartDate);
                errorThrown = true;
            }

            try {
                endDate = AJS.$.datepicker.parseDate('yy-mm-dd', extractedEndDate);
            } catch (e) {
                FECRU.AJAX.appendErrorMessage("Could not parse end date " + extractedEndDate);
                errorThrown = true;
            }

            if (errorThrown) {
                FECRU.AJAX.showErrorBox();
                return false;
            }

            if (startDateStr && endDateStr && (startDate > endDate)) {
                //do a swap of the date values before submitting if the dates are found to be reversed
                endDateInput.val(startDateStr);
                startDateInput.val(endDateStr);
            }
        }
        return true;
    };

    FECRU.UI.setupCalendar = function (addTime, constrainInput) {
        if (addTime === undefined || addTime === null) {
            addTime = true;
        }
        if (constrainInput === undefined || constrainInput === null) {
            constrainInput = true;
        }
        var calDateStart = AJS.$("input.calendar-date-start");
        calDateStart.attr("autocomplete", "off");
        calDateStart.datepicker({
            dateFormat: 'yy-mm-dd',
            constrainInput: constrainInput,
            onClose: function (dateText) {
                //only do this if the text is the length of a date
                //this will FAIL if anyone changes the date format

                //NOTE: yy-mm-dd in jquery is a 10 character format
                // ie 1987-12-23
                if (addTime && dateText.length === 10) {
                    AJS.$(this).attr("value", dateText + "T00:00:00");
                }
            }
        });
        var calDateEnd = AJS.$("input.calendar-date-end");
        calDateEnd.attr("autocomplete", "off");
        calDateEnd.datepicker({
            dateFormat: 'yy-mm-dd',
            constrainInput: constrainInput,
            onClose: function (dateText) {
                if (addTime && dateText.length === 10) {
                    AJS.$(this).attr("value", dateText + "T23:59:59");
                }
            }
        });
    };

    FECRU.UI.warnAboutFirebug = function (onClose) {
        var cookieName = 'hide_fecru_fb_warn';
        var suppressWarning = AJS.$.cookie(cookieName) === 'Y';
        if (!suppressWarning && window.console && window.console.firebug) {
            var product = AJS.$("#product-name").text() || "FishEye + Crucible";
            var $warning = AJS.$("<div id='firebug-warning'><p>Firebug is known to cause performance problems with " +
                product + ". Why not disable it?</p><a class='close'>X</a></div>");
            AJS.$(document).delegate("#firebug-warning .close", "click", function () {
                $warning.slideUp('fast', function () {
                    AJS.$.cookie(cookieName, 'Y', {expires: 365});
                    if (onClose) {
                        onClose();
                    }
                });
            });
            $warning.prependTo(AJS.$("#masthead"));
        }
    };

    FECRU.UI.toggleSearch = function () {
        AJS.$(document).delegate("h5[rel='toggle']", "click", function () {
            if (AJS.$(this).hasClass("show")) {
                AJS.$("#search-more").show();
                AJS.$(this).removeClass("show").addClass("hide");
                AJS.$(this).find("em").text("hide");
            }
            else {
                AJS.$("#search-more").hide();
                AJS.$(this).addClass("show").removeClass("hide");
                AJS.$(this).find("em").text("show");
            }
            return false;
        });
    };

    FECRU.UI.setCompletedResizeTimeout = function (selector, callback, completionDelay) {
        completionDelay = completionDelay || 100;
        var timeout;

        AJS.$(selector).resize(function () {
            if (completionDelay > 0 && timeout) {
                clearTimeout(timeout);
            }
            timeout = setTimeout(callback, completionDelay);
        });
    };


    FECRU.UI.resizeAndCollateImagesToThumbs = function () {
        var $comments = AJS.$(".article-message .long-message.markup").filter(":has(.image-wrap)");
        var commentsSize = $comments.size();
        var thumbify = function ($img) {

            // Only thumb the image if it hasn't already been thumbed
            if ($img.parent().parent().hasClass('image-wrap')) {
                var width = $img[0].width; // we use the dom element properties to ingore the fact the image isn't visible
                var height = $img[0].height;
                var thumbs = {
                    width: 100,
                    height: 67
                };

                if (width > thumbs.width || height > thumbs.height) {
                    var wRatio = width / thumbs.width;
                    var hRatio = height / thumbs.height;

                    if (wRatio > hRatio) {
                        $img.width(thumbs.width);
                    } else {
                        $img.height(thumbs.height);
                    }
                }
                // IE workaround. We want to ensure this method is run again when the long message becomes visible
                if (width !== 0 || height !== 0) {
                    // Remove the class which hides the image now that we've thumbed it
                    $img.closest(".image-wrap").removeClass("image-wrap").addClass("image-wrapped");
                }
            }
        };

        for (var i = 0; i < commentsSize; i++) {
            var $wrappers = $comments.eq(i).find(".image-wrap");
            var wrappersSize = $wrappers.size();
            var $img = $wrappers.children("img");
            var className = "comment-t" + i;

            // Unfortunately we have to process each image separately
            AJS.$.each($img, function () {
                var $this = AJS.$(this);
                $this.wrap('<a href="' + $img.attr('src') + '" class="fancybox-image" rel="' + className + '"></a>');
                $this.load(function () {
                    thumbify($this);
                });
                if (this.complete) {
                    $this.trigger("load");
                }
            });
        }

        // Fancy box all the images in the comment into a gallery
        AJS.$(".fancybox-image").fancybox({
            transitionIn: 'elastic',
            transitionOut: 'elastic'
        });
    };

    /**
     * Hide aui-dropdown2 element basing on passed argument.
     * Why do we need this?
     * After AUI upgrade (from 5.5 to 5.8) dropdown2's behaviour was changed a bit.
     * So now if a click event was prevented, dropdown2 won't be closed automatically.
     *
     * @param {Node|jQuery} element - dropdown's child element or dropdown itself
     */
    FECRU.UI.hideClosestDropdown2 = function (element) {
        AJS.layer(AJS.$(element).closest('.aui-dropdown2')).hide();
    };

})();
/*[{!ui_js_1ew854b!}]*/;
/* END /2static/script/fecru/ui.js */
/* START /2static/script/fecru/star.js */
/*eslint eqeqeq:0*/

window.FECRU = window.FECRU || {};

(function () {

    /**
     * html for the star edit dialog, to be inserted on demand.
     */
    var DIALOG_DEFAULT = "Describe your favourite";
    /*eslint-disable indent*/
    var DIALOG_HTML = [
        "<div id='astronomy'>",
            "<div id='astronomy-label'>",
                "<h4><span>Update favourite</span></h4>",
                "<span class='close'><a href='#' class='close-astronomy' id='close-astronomy'>X</a></span>",
                "<form action='#'>",
                    "<fieldset class='input'>",
                        "<label for='star-labels'>Name</label>",
                        "<input type='text' id='star-labels' value='Describe your favourite'>",
                    "</fieldset>",
                    "<fieldset class='button'>",
                        "<ul>",
                            "<li><button class='remove' id='remove-astronomy'>Remove</button></li>",
                            "<li class='odd'><input type='submit' id='save-star-label' value='Save label'></li>",
                        "</ul>",
                    "</fieldset>",
                "</form>",
            "</div>",
        "</div>"
    ].join("");
    /*eslint-enable*/

    ////// private functions

    var ON_ONLY = true;
    var OFF_ONLY = false;

    function starOnOffClassName(on) {
        return on ? "star-on" : "star-off";
    }

    function starAddRemoveText($star, on) {
        return $star.find(on ? "input.star-textRemove" : "input.star-textAdd").val();
    }

    /**
     * todo: see if this can be swapped with the throbber jquery plugin.
     */
    function makeThrobberControl($link, throbberSetting) {
        /**
         * Starts the throbber, which activates after noLatencyThreshold milliseconds have passed.
         * @return a function that will stop the throbber after minThrobberDisplay milliseconds have passed, ensuring no flicker.
         */
        var startThrob = function () {
            $link.data("throbbing", true);
            var timeout = setTimeout(function () {
                $link.addClass("star-throb");
            }, throbberSetting.noLatencyThreshold);

            return function () {
                $link.data("throbbing", false);
                clearTimeout(timeout);
                setTimeout(function () {
                    $link.removeClass("star-throb");
                }, throbberSetting.minThrobberDisplay);
            };
        };

        /**
         * stores a function to stop the throbber for the given $link
         */
        var stopThrob = undefined;
        return {
            start: function () {
                if (throbberSetting.showThrob && !stopThrob) {
                    stopThrob = startThrob();
                }
            },
            stop: function () {
                if (stopThrob) {
                    stopThrob();
                    stopThrob = undefined;
                }
            },
            isThrobbing: function () {
                return $link.data("throbbing");
            }
        };
    }

    /**
     *
     * @param link the jquery element of the link that was clicked
     * @param dialogControl an object to control the dialog. Its members should be:
     * - showDialog: a function with no arguments, which when invoked will display the dialog
     * - hideDialog: a function with no arguments, which when invoked will hide the dialog
     * - getDialog: a function with no arguments, which returns a jquery object that represents the dialog
     * @param options the list of options. Available options are:
     * - throbber : options for throbbing
     *
     */
    function starClicked(link, dialogControl, options) {
        var starId = getStarId(link);
        var starOn = AJS.$(link).hasClass('star-on');

        var starKeys = {};
        var $link = AJS.$(link);
        var throbberControl = makeThrobberControl($link, options.throbberSetting);
        //if throbbing already, then don't do anything.
        if (throbberControl.isThrobbing()) {
            return;
        }

        $link.children("span.inputs").children("input.starKey").each(function () {
            var key = AJS.$(this);
            starKeys[key.attr("name")] = key.val();
        });
        if (starOn && starId != null) {
            if (isDialogShown($link)) {
                // we are unstarring, pop up the edit box
                editStar(starId, dialogControl, throbberControl, $link);
            } else {
                //...or remove directly without anymore interaction
                doRemoveStar(starId, throbberControl);
            }
        } else {
            // we are adding a star
            addStar(starKeys, dialogControl, throbberControl);
        }

        // todo: fix this hack to make hoverpopups refresh after starring
        // just always invalidate all popups
        var fecruHover = FECRU.HOVER;
        fecruHover.invalidateCache(fecruHover.CACHE_FOREVER);

    }

    function getIdElement(link) {
        return AJS.$(link).children("span.inputs").children("input[name='id']");
    }

    function getStarId(link) {
        return getIdElement(link).val();
    }

    function allStars(on) {
        return AJS.$("a." + starOnOffClassName(on));
    }

    function setStarAttributes(on, $node) {
        var newClass = starOnOffClassName(on);
        var oldClass = starOnOffClassName(!on);
        $node.removeClass(oldClass)
            .addClass(newClass)
            .children("span.starText").text(starAddRemoveText($node, on));
    }

    /**
     * Turn on the Star with the given keys
     * @param keys
     */
    function addStar(keys, dialogControl, throbberControl) {
        var paramMap = {};
        for (var key in keys) {
            if (keys.hasOwnProperty(key)) {
                paramMap["key." + key] = keys[key];
            }
        }
        throbberControl.start();
        doStar(FECRU.pageContext + "/json/profile/addStarAjax.do", paramMap, function (newId) {
            allStars(OFF_ONLY).each(function () {
                var $node = AJS.$(this);
                var $inputs = $node.children("span.inputs");
                for (var key in keys) {
                    if (keys.hasOwnProperty(key)) {
                        var input = $inputs.children("input.starKey[name='" + key + "']");
                        if (input.length === 0 || input.val() != keys[key]) {
                            return;
                        }
                    }
                }
                setStarAttributes(true, $node);
                $inputs.append("<input type='hidden' name='id' value='" + newId + "'>");
            });
            var itemType = keys["itemType"];
            if (itemType == "atlassian-chart" || itemType == "atlassian-search" ||
                itemType == "atlassian-quicksearch") {
                editStar(newId, dialogControl, throbberControl);
            } else {
                // WARNING: epic hack
                // This is to work around an incorrect usage of InlineDialog. We are leveraging IDs triggers to load
                // star ajax dialog, but in some cases we are not actually showing the dialog. This leaves the internal
                // state of InlineDialog in tatters and further calls to show the dialogs won't work. This workaround
                // simply shows and immediately hides the dialog ensuring the internal state is correct. The hidden
                // visibility is to ensure that the browser doesn't render the dialog on the screen.
                var $dialog = AJS.$("#inline-dialog-star-inline-dialog");
                $dialog.css("visibility", "hidden");
                dialogControl.showDialog();
                dialogControl.hideDialog();
                $dialog.css("visibility", "visible");
            }
            throbberControl.stop();
        });
    }

    /**
     * Pop up a dialog box for a Star which is in the on state, allowing the user to set its label or to remove it.
     * @param starId the id of the Star to change.
     * @param dialogControl
     */
    function editStar(starId, dialogControl, throbberControl, $star) {
        // pop up our star edit dialog
        var onSuccess = function (resp) {
            if (resp.worked) {
                var __updateLabel = function (label) {
                    doSaveLabel(starId, label, throbberControl, $star);
                };
                var __removeStar = function () {
                    doRemoveStar(starId, throbberControl);
                };
                showStarDialog(dialogControl, __updateLabel, __removeStar, resp.payload);
            } else {
                //resp.worked is false, reset the star to an off star.
                turnOffStar(starId);
            }
            throbberControl.stop();
        };
        throbberControl.start();
        // get the label for this Star, to supply it to the dialog
        AJS.$.post(FECRU.pageContext + "/json/profile/getStarLabelAjax.do", {id: starId}, onSuccess, 'json');
    }

    function turnOffStar(starId) {
        allStars(ON_ONLY).each(function () {
            var id = getStarId(this);
            if (starId == id) {
                // represents the same star
                getIdElement(this).remove();
                var $node = AJS.$(this);
                setStarAttributes(false, $node);
            }
        });
    }

    /**
     * Send a new label value to the server.
     * @param id the id of the Star who's label has been changed
     * @param label a String holding the new label text
     */
    function doSaveLabel(id, label, throbberControl, $star) {
        var onDone = function (rsp) {
            if ($star && $star.find('[name=id]')) {
                var starId = $star.find('[name=id]').val();
                AJS.$('#star-label-' + starId).html(rsp.name);
            }
            throbberControl.stop();
        };
        throbberControl.start();
        AJS.$.post(FECRU.pageContext + "/json/profile/setStarLabelAjax.do", {id: id, label: label}, onDone, 'json');
    }

    /**
     * Unstar the star with the given id.
     *
     * @param id the id of the Star to unstar.
     */
    function doRemoveStar(id, throbberControl) {
        throbberControl.start();
        doStar(FECRU.pageContext + "/json/profile/removeStarAjax.do", {id: id}, function () {
            turnOffStar(id);
            throbberControl.stop();
        });
    }

    /**
     * Change the state of a set of stars, and refresh the 'my stars' dropdown.
     * @param url the URL to inform the server about the change
     * @param updateStars the function to call to change the state of the stars in the browser
     */
    function doStar(url, params, updateStars) {
        var done = function (resp) {
            if (resp.worked) {
                updateStars(resp.id);
                return true;
            }
        };
        FECRU.AJAX.ajaxDo(url, params, done, false);
    }

    //todo: use AUI inline dialog
    function createStarDialog(dialogHider) {
        var $dialog = AJS.$(DIALOG_HTML);
        //intialize the dialog buttons
        AJS.$("#close-astronomy", $dialog).click(function (e) {
            dialogHider && dialogHider();
            e.preventDefault();
        });

        var $starLabel = AJS.$("#star-labels", $dialog);

        $starLabel.keypress(function (e) {
            if ((e.which || e.keyCode) === AJS.$.ui.keyCode.ENTER) {// if return is clicked
                e.preventDefault();
                AJS.$("#save-star-label", $dialog).trigger('click');
            }
        }).attr("autocomplete", "off");

        return $dialog;
    }

    function showStarDialog(dialogController, updateLabel, removeStar, currentLabel) {
        var $dialog = dialogController.getDialog();
        var $starLabel = AJS.$("#star-labels", $dialog);

        if (currentLabel) {
            $starLabel.val(currentLabel).data("defaultValue", currentLabel).addClass("focussed");
        } else {
            $starLabel.val('').data("defaultValue", "");
        }

        AJS.$("#remove-astronomy", $dialog).unbind().click(function (e) {
            e.preventDefault();
            removeStar();
            dialogController.hideDialog();
            $starLabel.val(DIALOG_DEFAULT).removeClass("focussed");
        });

        AJS.$("#save-star-label", $dialog).unbind().click(function (e) {
            e.preventDefault();
            var newLabel = $starLabel.val();
            if (newLabel == 'Describe your favourite') {
                newLabel = '';
            }
            if (newLabel !== $starLabel.data("defaultValue")) {
                $starLabel.data("defaultValue", newLabel);
                updateLabel(newLabel);
            }
            dialogController.hideDialog();
        });
        dialogController.showDialog();
    }

    function isDialogShown(starLink) {
        return starLink.hasClass("showDialog");
    }

    /**
     * bind a live click event to the stars.
     */
    function bindStars() {
        var $dialog = undefined; //stores a reference to the jquery elmem
        var dialogHider = undefined;
        var PADDING = 5;
        var hoverOptions = {
            onHover: false,
            showArrow: true,
            fadeTime: 200,
            hideDelay: null,
            showDelay: 0,
            width: 240 + PADDING,
            offsetX: -8, //to get the arrow centred at the star's vertical asix
            offsetY: 4,
            container: "body",
            useLiveEvents: true,
            cacheContent: false,
            initCallback: function () {
                //implementation note: we need a way to hide the dialog on demand - this callback has a hook into
                //the hide function that inline-dialog uses internally, so this is saving a reference to that function
                //for use later.
                var that = this;
                dialogHider = function () {
                    that.hide();
                };
            }
        };
        var onStarClickedHandler = function ($contentDiv, trigger, showPopup) {
            var $link = AJS.$(trigger);
            var dialogControl = {
                showDialog: function () {
                    if (isDialogShown($link)) {
                        if ($dialog === undefined) {
                            $dialog = createStarDialog(this.hideDialog);
                        }
                        $dialog.appendTo($contentDiv).show();
                        var $starLabels = AJS.$("#star-labels");
                        $starLabels.placeholder('Describe your favourite');
                        showPopup();
                    }
                },
                hideDialog: function () {
                    dialogHider && dialogHider();
                },
                getDialog: function () {
                    if ($dialog === undefined) {
                        $dialog = createStarDialog(this.hideDialog);
                    }
                    return $dialog;
                }
            };
            var opts = {
                throbberSetting: {
                    showThrob: true,         //todo: customizable throbbing needed?
                    noLatencyThreshold: 150, //if the ajax call takes less than this milliseconds, then no throb shown
                    minThrobberDisplay: 200  //otherwise, show for at least this milliseconds.
                }
            };
            starClicked(trigger, dialogControl, opts);
        };
        AJS.InlineDialog(".starrable.showDialog", "star-inline-dialog", onStarClickedHandler, hoverOptions);
        AJS.$(document).delegate('.starrable:not(.showDialog)', 'click', function () {
            onStarClickedHandler(null, this, null);
        });
    }

    ////// onload events for stars
    AJS.toInit(function () {
        bindStars();
    });
})();
/*[{!star_js_v63d549!}]*/;
/* END /2static/script/fecru/star.js */
/* START /2static/script/fecru/ajax.js */
window.FECRU = window.FECRU || {};

FECRU.AJAX = (function ($, window) {

    /**
     * We need to distinguish between two cases. A user clicking away to another page, cancelling an Ajax request. In that case we
     * want to do nothing. When the server refuses a connection, we want to display an error message.
     */
    var unloaded = false;
    $(window).bind('beforeunload', function () {
        unloaded = true;
    });

    /**
     * Factory method that creates a new SequentialAjaxExecutor instance.
     */
    function createSequentialExecutor() {
        return new SequentialAjaxExecutor();
    }

    /******************************************************************
     ******************** AJAX METHODS ********************************
     ******************************************************************/

    /**
     * This class represents a serial channel for ajax calls. An ajax call that
     * is submitted only gets run after the previous call has returned from the
     * server.
     * This is used by Crucible comments: when you click "post" while autosave
     * is waiting for the server to create and return the new commentId, the
     * Post action is queued and automatically gets evaluated after autosave
     * has returned (and populated the js comment model with the new commentId).
     */
    function SequentialAjaxExecutor() {

        var busy = false;
        var $jobs = $('<div></div>');   // private var to SequentialAjaxExecutor, never inserted into the document.

        /**
         * Makes an AJAX call, similar to FECRU.AJAX.ajaxDo(), but with the exception that
         * only one call can be active at any time. When this method is called
         * a second time, while the previous call has not yet finished, the new
         * call will be scheduled and executed automatically when the previous
         * call finishes.
         *
         * @param url
         * @param params
         * @param onCompleteFunc
         */
        this.executeAjax = function (url, params, onCompleteFunc, noDialog) {
            this.executeAjaxJob({
                url: url,
                params: params,
                callback: onCompleteFunc,
                noDialog: noDialog
            });
        };

        /**
         * Similar to SerializedAjaxDispatcher.executeAjax(), but takes a hash with
         * functions that allow callers to evaluate their url and query params
         * just-in-time.
         *
         * @param job
         */
        this.executeAjaxJob = function (job) {
            if (busy) {
                var dispatcher = this;
                $jobs.queue(function () {
                    dispatcher.executeAjaxJob(job);
                });
            } else {
                busy = true;
                ajaxDo(
                    $.isFunction(job.url) ? job.url() : job.url,
                    $.isFunction(job.params) ? job.params() : job.params,
                    function (resp) {
                        try {
                            if (job.callback) {
                                job.callback(resp);
                            }
                        } finally {
                            busy = false;
                            $jobs.dequeue();
                        }
                    },
                    $.isFunction(job.noDialog) ? job.noDialog() : job.noDialog);
            }
        };

        this.isPending = function () {
            return busy;
        };
    }

    function ajaxDo(url, params, onCompleteFunc, noDialog) {
        return ajaxUpdate(url, params, null, onCompleteFunc, noDialog);
    }

    /**
     * Makes a Ajax request with the specified parameters and runs the onCompleteFunc
     * function when the call returns. Optionally, a DOM element can be passed in
     * which will be updated with the payload of the Ajax response (the JSON response
     * object must contain a "payload" member.
     *
     * noDialog is optional: if falsy, the error message dialog is shown on error.
     * If it is a callback, it is invoked on error instead of showing the dialog.
     * Otherwise, if it is truthy, the dialog is not shown on error and no action
     * is taken. It makes sense to not report an error when the Ajax action is triggered by a timer, rather than by a
     * user action, or where the failure of the Ajax action doesn't affect what the user is doing. (e.g. ?)
     * TODO any other cases where we should not show an error?
     */
    function ajaxUpdate(url, params, elementIdToUpdate, onCompleteFunc, noDialog) {
        // Implemementation note:
        // jQuery does an eval(req.responseText) for us internally. We have an onSuccess callback to
        // intercept this, otherwise we end up eval'ing the response text twice (which is poor form).
        // The onComplete callback gives us access to the XmlHttpRequest and allows us to do extra
        // error handling if required.

        var data = false;
        var onSuccess = function (response) {
            data = response;
        };

        /*eslint-disable complexity*/
        var onComplete = function (req, textStatus) {
            // We do not want to proceed if the request was aborted
            if (textStatus === 'abort') {
                return;
            }

            var cleanUpOnFail = function () {
                if (onCompleteFunc) {
                    onCompleteFunc({worked: false});  //allow function to clean up
                }
            };
            try {

                if (req.status === 0) {
                    if (!unloaded) {
                        cleanUpOnFail();
                        if (!noDialog) {
                            showServerUnreachableBox();
                        }
                    }
                    //else this was caused by user navigating away, ignore it.
                    return;
                }
                if (!data || !isECMA(req)) {
                    noDialog || displayUnexpectedResponse(req);
                    cleanUpOnFail();
                    return;
                }

                var $updateMe;
                if (elementIdToUpdate) {
                    $updateMe = $("#" + elementIdToUpdate);
                }

                if (data.hasOwnProperty("worked") && !data.worked) {
                    if (!noDialog) {
                        appendErrorResponse(data.errorMsg, data.noEscape);
                        appendCredentialsRequests(data.credentialsRequired);
                        if (data.userError) {
                            showUserErrorBox();
                        } else {
                            showErrorBox();
                        }
                    }
                } else if ($updateMe && $updateMe.length === 1) {
                    if ($updateMe.is(':input')) {
                        $updateMe.val(data.payload);
                    } else {
                        $updateMe.html(data.payload);
                    }
                }
                if (onCompleteFunc) {
                    onCompleteFunc(data);
                }
            } catch (e) {
                console && console.error('ajaxUpdate failure: ' + e);
                displayUnexpectedResponse(req);
                cleanUpOnFail();
            }
        };
        /*eslint-enable*/

        return $.ajax({
            type: "post",
            url: url,
            data: params,
            dataType: "json",
            traditional: true, // serialize array params as rev=1&rev=2 rather than rev[]=1&rev[]=2
            success: onSuccess,
            complete: onComplete,
            beforeSend: function (req, settings) {
                req.url = settings.url;
            },
            error: noDialog ? ($.isFunction(noDialog) ? noDialog : NOOP) : ajaxFailure
        });
    }


    var NOOP = function () {
    };

    var ajaxFailure = function (req, textStatus, errorThrown) {
        try {
            if (!isECMA(req)) {
                displayUnexpectedResponse(req);
                return;
            }
            var resp = eval('(' + req.responseText + ')');
            var errorShown = false;
            if (!resp.worked || resp.errorMsg || resp.message) {
                appendErrorResponse(resp.errorMsg || resp.message, resp.noEscape);
                errorShown = true;
            }
            if (errorThrown) {
                appendErrorResponse(errorThrown);
                errorShown = true;
            }
            if (!errorShown) {
                appendErrorResponse("Unknown error");
            }
            showErrorBox();
        } catch (e) {
            console && console.error('ajaxFailure: ' + e);
            displayUnexpectedResponse(req);
        }
    };

    /******************************************************************
     ******************** HELPER METHODS ******************************
     ******************************************************************/

    var isECMA = function (req) {
        return isContentType(req, /^application\/(ecmascript|json)/);
    };

    var isHTML = function (req) {
        return isContentType(req, /^text\/html/);
    };

    var isContentType = function (req, targetType) {
        var respContentType = req.getResponseHeader("Content-Type");
        return respContentType != null && respContentType.match(targetType);
    };

    var isHTMLFrag = function (req) {
        var responseText = req.responseText;
        return responseText != null && !responseText.match(/<body/i);
    };

    //TODO use FECRU.htmlEscape || AJS.escapeHtml
    var ourHtmlEscape = function (input) {
        try {
            return input.replace(/&/g, '&amp;').
                replace(/>/g, '&gt;').
                replace(/</g, '&lt;').
                replace(/"/g, '&quot;');
        } catch (e) {
            console && console.error('escape failure: ' + e);
            return input.message || 'There was an error communicating with the server';
        }
    };

    /**
     * @deprecated use $.spin() instead which was introduced in AUI 5.0-fecru1
     */
    function startSpin(id, className, replace) {
        className = className ? className + " spinner" : "spinner";

        var $el = typeof(id) === 'object' ? $(id) : $("#" + id);
        if ($el.length === 1) {
            var $spinner = $(document.createElement("span"));
            $spinner.addClass(className)
                .html("<img src='" + FECRU.pageContext + "/" + FECRU.staticDirectory + "/2static/images/blank.gif'>");
            if (replace) {
                $el.replaceWith($spinner);
            } else {
                if (!$el.next().is('.spinner')) {
                    $spinner.insertAfter($el);
                }
            }
            return true;
        }
        return false;
    }

    /**
     * @deprecated use $.spinStop() instead which was introduced in AUI 5.0-fecru1
     */
    function stopSpin(id) {
        var $el = typeof(id) === 'object' ? $(id) : $("#" + id);

        if ($el.length === 1) {
            $el.nextAll(".spinner").remove();
        }
    }


    /******************************************************************
     ******************** ERROR HANDLING ******************************
     ******************************************************************/

    function checkError(resp) {
        return resp.error;
    }

    function appendErrorResponse(error, noEscape) {
        if (error) {
            appendErrorMessage(error + (error.stack ? ":\n" + error.stack : ""), noEscape);
        }
    }

    function appendCredentialsRequests(credentialsRequired) {
        if (credentialsRequired) {
            for (var i = 0; i < credentialsRequired.length; i++) {
                var creds = credentialsRequired[i];
                var msg = "Click <a onclick=\"FECRU.HOVER.invalidateCache(FECRU.HOVER.CACHE_FOREVER); return true;\" href='" + creds.authUrl + "' target='_new'>here</a> to authenticate with " + creds.name;
                appendErrorMessage(msg, true);
            }
        }
    }

    function appendErrorMessage(errorMsg, noEscape) {
        if (errorMsg) {
            var $err = $('#errorResponses');
            var errorCount = $err.find('.errorResponse').length;
            var escaped = (noEscape) ? errorMsg : ourHtmlEscape(errorMsg);

            var $existingErrors = $('#errorResponses .errorResponse');
            for (var i = 0, len = $existingErrors.length; i < len; i++) {
                if (escaped === $($existingErrors[i]).html()) {
                    return; // dont show an error if we have already seen it
                }
            }

            $err.show()
                .append($('<div class="errorResponse-count">Error' + (errorCount ? (' ' + ++errorCount) : '') + '</div>'))
                .append($('<div class="errorResponse"></div>').html(escaped));
        }
    }

    function appendNotificationMessage(message) {
        if (message) {
            var $err = $('#errorResponses');
            var $msg = $('<div class="notification-box-message"></div>');

            if (message.jquery) {
                $msg.append(message);
            } else {
                $msg.text(message);
            }
            $err.append($msg);
        }
    }

    var dialog = 0;

    function showErrorBox() {
        showNotificationBox('An error has occurred');
        $('#errorDetails').show();
    }

    function showUserErrorBox() {
        showNotificationBox('Cannot perform the requested action', 'usererror');
        $('#errorDetails').show();
    }

    function showServerUnreachableBox() {
        showNotificationBox('The server is not responding.');
        $('#errorDetails').show();
    }

    function showNotificationBox(title, severity) {
        severity = severity || "error";
        var util = CRU.UTIL;

        if (dialog === 0) {
            dialog = FECRU.DIALOG.create(640, 480, "error-dialog");
            dialog.addHeader(title)
                .addPanel("Information", $('#errorBox'))
                .addButton("Reload", function () {
                    window.location.reload();
                }, "reload-button")
                .addButton("Close", function () {
                    $('#errorResponses .errorResponse').remove();
                    $('#errorResponses .errorResponse-count').remove();
                    dialog.hide();
                }, "close-button");
        } else {
            dialog.addHeader(title);
        }
        var $dialog = $('#error-dialog');
        if (severity === 'error') {
            $dialog.addClass('error').removeClass('message usererror');
        } else if (severity === 'usererror' && !$dialog.hasClass('error')) {
            $dialog.find(".errorResponse-count").hide();
            $dialog.addClass('usererror').removeClass('message error');
        } else if (severity === 'message' && !$dialog.hasClass('error') && !$dialog.hasClass('usererror')) {
            $dialog.addClass('message').removeClass('error usererror');
        }

        // error overrides message and usererror, usererror overrides message
        if (severity === 'error') {
            override = true; // eslint-disable-line no-undef
        } else if (severity === 'usererror' && $dialog.hasClass('message')) {
            override = true; // eslint-disable-line no-undef
        }

        if (!util.isAnyDialogShowing()) {
            if (util.isAjaxDialogSpinning()) {
                util.stopAjaxDialogSpin();
            }
            dialog.show();
        }
        return false;
    }

    function displayUnexpectedResponse(req) {
        var error = {}; // message, noEscape, title, severity;
        if (isHTML(req) && isHTMLFrag(req)) {
            error.message = req.responseText;
        }
        else if (!req.responseText) {
            //no-op here: no responseText means most likely server is gone offline, which is handled in onComplete
        }
        else {
            try {
                var resp = eval('(' + req.responseText + ')');

                if (!resp.errorMessages[0]) {
                    resp.errorDetails = "<p>No further details were provided.</p>";
                }
                else {
                    resp.errorDetails = resp.errorMessages.join("<br>");
                }

                var startsWithVowel = resp.errorName && (-1 !== "aeiou".indexOf(resp.errorName.charAt(0).toLowerCase()));

                error.message = [
                    "<p>",
                    (resp.errorName ? (startsWithVowel ? "An " : "A ") + resp.errorName : "An error"),
                    " was encountered",
                    "</p>",
                    resp.errorDetails
                ].join("");
                error.noEscape = true;
            } catch (e) {
                if (req.status >= 400) {
                    error.message = req.status + ": " + req.statusText;
                    error.title = "Error communicating with the server";
                    error.severity = "error";
                }
            }
        }
        if (error.message) {
            appendErrorResponse("<p>URL: " + AJS.escapeHtml(req.url) + "</p>" + (error.noEscape ? error.message : AJS.escapeHtml(error.message)), true);
            if (error.title) {
                showNotificationBox(error.title, error.severity);
            } else {
                showErrorBox();
            }
        }
    }

    function displayErrorInResponse(err) {
        appendErrorResponse(err);
        showErrorBox();
    }

    return {
        createSequentialExecutor: createSequentialExecutor,

        ajaxDo: ajaxDo,
        ajaxUpdate: ajaxUpdate,

        /**
         * @deprecated use $.spin() instead which was introduced in AUI 5.0-fecru1
         */
        startSpin: startSpin,
        /**
         * @deprecated use $.spinStop() instead which was introduced in AUI 5.0-fecru1
         */
        stopSpin: stopSpin,

        checkError: checkError,

        appendErrorResponse: appendErrorResponse,
        appendErrorMessage: appendErrorMessage,
        showErrorBox: showErrorBox,
        showUserErrorBox: showUserErrorBox,
        showServerUnreachableBox: showServerUnreachableBox,
        appendNotificationMessage: appendNotificationMessage,
        showNotificationBox: showNotificationBox,
        ajaxFailure: ajaxFailure
    };
})(AJS.$, this);
/*[{!ajax_js_6oig53d!}]*/;
/* END /2static/script/fecru/ajax.js */
/* START /2static/script/fe/fisheye-annotation.js */
window.FE = window.FE || {};
FE.ANN = FE.ANN || {};

// Publicly exported so that we can communicate between iframes
var nextSegment;
var prevSegment;

(function ($) {

    var goHere = function ($place) {
        var $currentWindow = $(window);
        var $parentWindow = $(parent);
        var parentWindowScrollTop = $parentWindow.scrollTop();

        location.hash = $place.attr("id");
        parent.location.hash = $place.attr("id");
        $parentWindow.scrollTop(parentWindowScrollTop);

        window.top.AJS.trigger('scroll-content', $currentWindow.scrollTop());
    };

    var $highlightedLine;
    var scrollToLine = function ($lineNum) {
        goHere($lineNum);
        if ($highlightedLine) {
            $highlightedLine.removeClass("line-selected");
        }
        $highlightedLine = $lineNum.closest("tr").addClass("line-selected");
    };

    var interceptLinks = function () {
        // Intercept clicks on links so that we don't open them in the iframe if not necessary
        $(document).delegate("a", 'click', function () {
            var $a = $(this);

            if ($a.hasClass("line-number") || $a.hasClass("disabled")) {
                return;
            }

            var href = $a.attr("href");
            var target = $a.attr("target");

            // Don't intercept links which are anchors or opened in another target
            if (!target && href && href.charAt(0) !== '#') {
                // Open links not in this iframe, but the top level window
                parent.document.location = this.href;
            }
        });
    };

    var setupViewAnnotation = function () {
        $(document).delegate("#file-annotation tr .line-number", 'click', function () {
            scrollToLine($(this));
        });
    };

    var setupViewDiff = function () {
        $(document).delegate("#file-annotation a.diff-segment-link", 'click', function () {
            var dest = parseInt($(this).attr("href").replace("#seg", ""), 10);
            scrollToDiffSegment(dest);
        });

        var currentSegment;

        var scrollToDiffSegment = function (segmentNumber) {
            var $segment = $("#seg" + segmentNumber);
            if ($segment.length > 0) {
                goHere($segment);
                currentSegment = segmentNumber;
            }
        };

        // Scroll to the requested diff segment
        var hash = window.location.hash;
        if (/^#seg\d+/.test(hash)) {
            var segment = parseInt(hash.replace(/^#seg(\d+).*$/, '$1'), 10);
            scrollToDiffSegment(segment);
        }

        nextSegment = function () {
            scrollToDiffSegment(currentSegment ? currentSegment + 1 : 1);
        };

        prevSegment = function () {
            if (!currentSegment || currentSegment === 1) {
                return;
            }
            scrollToDiffSegment(currentSegment - 1);
        };

        // trigger event to the parent window to reset the iframe height
        window.parent !== window && window.parent.AJS &&
        window.parent.AJS.trigger('file-view-resize-from-iframe');
    };

    FE.ANN.onReady = function (pageType) {
        var isAnnotation = pageType === 'annotation';
        var isDiff = pageType === 'diff';

        $(function () {
            interceptLinks();
            if (isAnnotation) {
                setupViewAnnotation();
            } else if (isDiff) {
                setupViewDiff();
            } else {
                AJS.log("ERROR: I don't know how to setup page view for type " + pageType);
                return;
            }

            var eventBus = parent.FECRU ? parent.FECRU.eventBus : null;
            if (eventBus) {
                eventBus.trigger('file-view-iframe:loaded', {
                    $source: $('.blame-info:visible')
                });
            }
        });
    };
})(AJS.$);
/*[{!fisheye_annotation_js_ydw3527!}]*/;
/* END /2static/script/fe/fisheye-annotation.js */
