/*eslint eqeqeq:0*/

window.FE = window.FE || {};
if (FE.ADMIN === undefined) {
    FE.ADMIN = {};
}

(function () {

    FE.ADMIN.urlBase = function () {
        return FECRU.pageContext + '/admin/';
    };

    AJS.$(document).ready(function () {
        AJS.$("#createArchiveButton").click(function () {
            FE.ADMIN.createBackupDialog();
            return false;
        });
        AJS.$("#disableCheckbox").click(function () {
            FE.ADMIN.toggleEditScheduledBackupsProperties();
            return true;
        });
        AJS.$("#authUsingTrustedApps").click(function () {
            AJS.$("#trusted-subtask-warning").toggle();
        });
    });

    FE.ADMIN.createBackupDialog = function () {
        AJS.$("#createArchiveButton").prop("disabled", true);

        var params = "";
        AJS.$.each(AJS.$("#backupItemSelection :checkbox:checked"), function () {
            params += "includeItems=" + this.value + "&";
        });
        if (AJS.$(".field-group #path")) {
            params += "path=" + AJS.$(".field-group #path").attr("value");
        }

        var backupStarted = function(resp) {
            // show the progress dialog
            FECRU.DIALOG.create(840, 580)
                .addHeader('Creating Backup')
                .addPanel('All', "<iframe id='fecru-iframe' src='" + FE.ADMIN.urlBase() + "backupprogress.do' " +
                    "width='100%' height='100%' border='0' scrolling='no' frameborder='0'>")
                .addButton('Close', function (dialog) {
                    dialog.hide();
                    AJS.$("#createArchiveButton").prop("disabled", false);
                })
                .show();
        }
        FECRU.AJAX.ajaxDo("performBackup-start.do", params, backupStarted);
    };

    /** Open the db migration dialog.
     * @param redirectOnCompletion redirect URL once the migration finishes (successfully or not). */
    FE.ADMIN.migrateDialog = function (redirectOnCompletion) {

        FECRU.DIALOG.create(840, 550, "migrateDialog")
            .addHeader("Migrating Database")
            .addPanel("All", "<div id='dialogContentPane'>Loading...</div>")
            .addButton("Ok", function (dialog) {
                dialog.hide();
                window.location = redirectOnCompletion;
            }, "okButtonDialog")
            .show();
        AJS.$(".okButtonDialog", "#migrateDialog").prop('disabled', true);

        var done = function (resp) {
            AJS.$("textarea", "#dialogContentPane").scrollTo("max");
            if (resp.finished) {
                AJS.$(".okButtonDialog", "#migrateDialog").prop('disabled', false);
            } else {
                var url = FECRU.pageContext + "/setup/migrateDBProgressAjax";
                setTimeout(function () {
                        FECRU.AJAX.ajaxUpdate(url, {}, "dialogContentPane", done)
                    },
                    1000);  // poll once per second
            }
        };

        var url = FE.ADMIN.urlBase() + "migrateDialog.do";
        var params = AJS.$("#dbform").serializeArray();
        FECRU.AJAX.ajaxUpdate(url, params, "dialogContentPane", done);
    };

    FE.ADMIN.toggleEditScheduledBackupsProperties = function () {

        var checkbox = AJS.$("#disableCheckbox");
        var inputs = AJS.$("#editPane input, #editPane select")
            .filter(':not(#disableCheckbox, #saveButton, #cancelButton)');

        inputs.prop("disabled", checkbox.is(":checked"));
    };
})();


function showRepoAttribs(repo) {
    var storeDiffTrueElt = document.getElementById('repository_storeDifftrue');
    var storeDiffFalseElt = document.getElementById('repository_storeDifffalse');
    var cvsDiv = document.getElementById('cvsFields');
    var svnDiv = document.getElementById('svnFields');
    var p4Div = document.getElementById('p4Fields');
    var gitDiv = document.getElementById('gitFields');
    var ccDiv = document.getElementById('ccFields');
    var hgDiv = document.getElementById('hgFields');
    var selection = repo.options[repo.selectedIndex].value;
    if (selection == "cvs") {
        cvsDiv.style.display = '';
        svnDiv.style.display = 'none';
        p4Div.style.display = 'none';
        gitDiv.style.display = 'none';
        ccDiv.style.display = 'none';
        hgDiv.style.display = 'none';
        storeDiffTrueElt.disabled = true;
        storeDiffFalseElt.disabled = true;
    } else if (selection == "svn") {
        cvsDiv.style.display = 'none';
        svnDiv.style.display = '';
        p4Div.style.display = 'none';
        gitDiv.style.display = 'none';
        ccDiv.style.display = 'none';
        hgDiv.style.display = 'none';
        storeDiffTrueElt.disabled = false;
        storeDiffFalseElt.disabled = false;
    } else if (selection == "p4") {
        cvsDiv.style.display = 'none';
        svnDiv.style.display = 'none';
        p4Div.style.display = '';
        gitDiv.style.display = 'none';
        ccDiv.style.display = 'none';
        hgDiv.style.display = 'none';
        storeDiffTrueElt.disabled = false;
        storeDiffFalseElt.disabled = false;
    } else if (selection == "git") {
        cvsDiv.style.display = 'none';
        svnDiv.style.display = 'none';
        p4Div.style.display = 'none';
        gitDiv.style.display = '';
        ccDiv.style.display = 'none';
        hgDiv.style.display = 'none';
        storeDiffTrueElt.disabled = false;
        storeDiffFalseElt.disabled = false;
    } else if (selection == "clearcase") {
        cvsDiv.style.display = 'none';
        svnDiv.style.display = 'none';
        p4Div.style.display = 'none';
        gitDiv.style.display = 'none';
        ccDiv.style.display = '';
        hgDiv.style.display = 'none';
        storeDiffTrueElt.disabled = false;
        storeDiffFalseElt.disabled = false;
    } else if (selection == "hg") {
        cvsDiv.style.display = 'none';
        svnDiv.style.display = 'none';
        p4Div.style.display = 'none';
        gitDiv.style.display = 'none';
        ccDiv.style.display = 'none';
        hgDiv.style.display = '';
        storeDiffTrueElt.disabled = false;
        storeDiffFalseElt.disabled = false;
    } else {
        cvsDiv.style.display = 'none';
        svnDiv.style.display = 'none';
        p4Div.style.display = 'none';
        gitDiv.style.display = 'none';
        ccDiv.style.display = 'none';
        hgDiv.style.display = 'none';
        storeDiffTrueElt.disabled = false;
        storeDiffFalseElt.disabled = false;
    }
    showAdvRepoAttribs();
}

function showAdvRepoAttribs() {
    var commonAdv = document.getElementById('commonAdv');
    var cvsAdv = document.getElementById('cvsAdv');
    var svnAdv = document.getElementById('svnAdv');
    var p4Adv = document.getElementById('p4Adv');
    var gitAdv = document.getElementById('gitAdv');
    var ccAdv = document.getElementById('ccAdv');
    var hgAdv = document.getElementById('hgAdv');
    var repo = document.getElementById("repoTypeSelection");
    if (document.getElementById("advanced").value == 'Simple' /* indicates 'advanced' is selected */) {
        commonAdv.style.display = '';
        var selection = repo.options[repo.selectedIndex].value;
        if (selection == "cvs") {
            cvsAdv.style.display = '';
            svnAdv.style.display = 'none';
            p4Adv.style.display = 'none';
            gitAdv.style.display = 'none';
            ccAdv.style.display = 'none';
            hgAdv.style.display = 'none';
        } else if (selection == "svn") {
            cvsAdv.style.display = 'none';
            svnAdv.style.display = '';
            p4Adv.style.display = 'none';
            gitAdv.style.display = 'none';
            ccAdv.style.display = 'none';
            hgAdv.style.display = 'none';
        } else if (selection == "p4") {
            cvsAdv.style.display = 'none';
            svnAdv.style.display = 'none';
            p4Adv.style.display = '';
            gitAdv.style.display = 'none';
            ccAdv.style.display = 'none';
            hgAdv.style.display = 'none';
        } else if (selection == "git") {
            cvsAdv.style.display = 'none';
            svnAdv.style.display = 'none';
            p4Adv.style.display = 'none';
            gitAdv.style.display = '';
            ccAdv.style.display = 'none';
            hgAdv.style.display = 'none';
        } else if (selection == "clearcase") {
            cvsAdv.style.display = 'none';
            svnAdv.style.display = 'none';
            p4Adv.style.display = 'none';
            gitAdv.style.display = 'none';
            ccAdv.style.display = '';
            hgAdv.style.display = 'none';
        } else if (selection == "hg") {
            cvsAdv.style.display = 'none';
            svnAdv.style.display = 'none';
            p4Adv.style.display = 'none';
            gitAdv.style.display = 'none';
            ccAdv.style.display = 'none';
            hgAdv.style.display = '';
        } else {
            cvsAdv.style.display = 'none';
            svnAdv.style.display = 'none';
            p4Adv.style.display = 'none';
            gitAdv.style.display = 'none';
            ccAdv.style.display = 'none';
            hgAdv.style.display = 'none';
        }
    } else {
        commonAdv.style.display = 'none';
        cvsAdv.style.display = 'none';
        svnAdv.style.display = 'none';
        p4Adv.style.display = 'none';
        gitAdv.style.display = 'none';
        ccAdv.style.display = 'none';
        hgAdv.style.display = 'none';
    }
}
function toggleCCViewAttributes() {
    AJS.$(".ccAutoCreate").closest("tr").toggleClass('ccHide');
}
function toggleCCAttributes(stylesToToggle) {
    if (stylesToToggle == undefined) {
        stylesToToggle = ".ccUCM, .ccBase";
    }
    AJS.$(stylesToToggle).closest("tr").toggleClass('ccHide');
    AJS.$("label[for='clearcase_includeIntegrationActivities']").closest("tr").toggleClass('ccHide');
    var ucm_radio = AJS.$("#clearcase_ucmtrue")[0];
    if (ucm_radio.checked) {
        AJS.$("label[for='clearcase_integrationOnly']").text("Integration Streams Only?");
    } else {
        AJS.$("label[for='clearcase_integrationOnly']").text("Main Branches Only?");
    }
}

function svnSymDelRowEvent(a) {
    var tr = a.parentNode.parentNode;
    tr.parentNode.removeChild(tr);
    svnSymSetToCustom();
}
function svnSymAddRowEvent(stype) {
    svnSymAddRow(stype, false);
    svnSymSetToCustom();
}

function svnSymAddRow(stype, readonlyFields) {
    var tabBody = document.getElementById('svnsym' + stype);
    var idx = tabBody.getElementsByTagName("tr").length;

    var propPrefix = "svnSymbolic." + stype + "[" + idx + "]";

    var makesvnSymField = function (prop) {
        var field = document.createElement("input");
        field.type = "text";
        field.name = propPrefix + prop;
        field.size = "20";
        field.readOnly = readonlyFields;

        return field;
    };

    var newrow = document.createElement("tr");

    var addToRow = function (field) {
        var td = document.createElement("td");
        td.appendChild(field);
        newrow.appendChild(td);
    };

    var f1 = makesvnSymField(".regex");
    addToRow(f1);

    var f2 = makesvnSymField(".name");
    addToRow(f2);

    var f3 = makesvnSymField(".logical");
    addToRow(f3);

    var delAnchor = document.createElement("a");
    delAnchor.innerHTML = "Del";
    delAnchor.href = "#svnSymAnchor";
    delAnchor.onclick = function () {
        svnSymDelRowEvent(delAnchor);
    };
    addToRow(delAnchor);

    tabBody.appendChild(newrow);

    var result = {
        'regex': f1, 'name': f2, 'logical': f3
    };
    return result;
}

function svnSymSetToCustom() {
    var sel = document.getElementById("svnSymSelect");
    sel.value = "custom";
    svnSymTypeChange(sel);
}

function svnSymUpdateControls(body, readonly) {
    var fields = body.getElementsByTagName("input");
    for (var i = 0; i < fields.length; i++) {
        var f = fields[i];
        f.readOnly = false;
    }
}

function svnSymSetupRow(fields, reg, name, logical) {
    fields['regex'].value = reg;
    fields['name'].value = name;
    fields['logical'].value = logical;
}

function svnRemoveAllRows(svnParent) {
    var svnChildren = svnParent.rows;
    for (var i = 0; i < svnChildren.length; i++) {
        svnParent.removeChild(svnChildren[i]);
    }
}

function svnSymTypeChange(select) {
    var trunkd = document.getElementById('svnsymtrunk');
    var branchd = document.getElementById('svnsymbranch');
    var tagd = document.getElementById('svnsymtag');

    if (select.value == "custom") {
        svnSymUpdateControls(trunkd, false);
        svnSymUpdateControls(branchd, false);
        svnSymUpdateControls(tagd, false);
        return true;
    }

    svnRemoveAllRows(trunkd);
    svnRemoveAllRows(branchd);
    svnRemoveAllRows(tagd);

    if (select.value == "type1") {

        svnSymSetupRow(svnSymAddRow('trunk', true), "trunk(/|$)", "trunk", "");
        svnSymSetupRow(svnSymAddRow('branch', true), "branches/([^/]+)", "\${1}", "");
        svnSymSetupRow(svnSymAddRow('tag', true), "tags/([^/]+)", "\${1}", "");

    } else if (select.value == "type2") {

        svnSymSetupRow(svnSymAddRow('trunk', true), "([^/]+)/trunk(/|$)", "trunk", "\${1}");
        svnSymSetupRow(svnSymAddRow('branch', true), "([^/]+)/branches/([^/]+)", "\${1}-\${2}", "\${1}");
        svnSymSetupRow(svnSymAddRow('tag', true), "([^/]+)/tags/([^/]+)", "\${1}-\${2}", "\${1}");

    }
    return true;
}

// copied from crucibles global.js
function simpleSwap(toHide, toShow) {
    if (typeof(toHide) == 'object') {
        AJS.$(toHide).hide();
    } else {
        AJS.$("#" + toHide).hide();
    }
    if (typeof(toShow) == 'object') {
        AJS.$(toShow).show();
    } else {
        AJS.$("#" + toShow).show();
    }
}

// trim text fields of leading and trailing whitespace
function trimFormTextFields(form) {

    var inputs = AJS.$(form).find("input[type='text']");

    for (var i = 0, j = inputs.length; i < j; i++) {
        var inputElement = AJS.$(inputs[i]);
        inputElement.val(inputElement.val().replace(/^\s+|\s+$/g, ''));
    }

    return true;
}

// stack trace pretty

function expandStackTrace(tid) {
    toggleTrace(tid, true);
}

function collapseStackTrace(tid) {
    toggleTrace(tid, false);
}

function toggleTrace(tid, expand) {
    var expander = "#thread-" + tid + "-expander";
    var collapser = "#thread-" + tid + "-collapser";
    var stack = "#thread-" + tid;
    if (expand) {
        jQuery(expander).hide();
        jQuery(collapser).show();
        jQuery(stack).show();
    }
    else {
        jQuery(collapser).hide();
        jQuery(expander).show();
        jQuery(stack).hide();
    }
}

jQuery(document).ready(function () {
    jQuery(".stackElement", "#threaddump").each(function () {
        var traceLine = jQuery(this).text();
        if (traceLine.indexOf("cenqua") != -1 || traceLine.indexOf("atlassian") != -1) {
            jQuery(this).addClass("productCode");
            var threadId = jQuery(this.parentNode).attr("id");
            jQuery("#" + threadId + "-hl").addClass("productCodeHL");
        }
    });
});
/*[{!admin_js_dtip4ud!}]*/