(function(jQuery) {
    // Avoid the expensive regular expression that jQuery uses to ensure the data is proper JSON. The browser will throw
    // an exception if it is not. The regexp that was being used would kill FireFox for very large ajax JSON responses.
    // See: https://forum.jquery.com/topic/validating-json-unnecessarily-is-killing-firefox

    // This method is identical to jQuery 1.4.2's parseJSON, without the json validating regular expression.
    jQuery.parseJSON = function( data ) {
        if ( typeof data !== "string" || !data ) {
            return null;
        }

        // Make sure leading/trailing whitespace is removed (IE can't handle it)
        data = jQuery.trim( data );

        // Try to use the native JSON parser first
        return window.JSON && window.JSON.parse ?
            window.JSON.parse( data ) :
            (new Function("return " + data))();
    };
    jQuery.ajaxSettings.converters["text json"] = jQuery.parseJSON;
})(jQuery);
/*[{!jquery_overrides_js_flsj55q!}]*/