/*

highlight v3

Highlights arbitrary terms.

<http://johannburkard.de/blog/programming/javascript/highlight-javascript-text-higlighting-jquery-plugin.html>

MIT license.

Johann Burkard
<http://johannburkard.de>
<mailto:jb@eaio.com>

NOTE: THIS HAS BEEN MODIFIED:
* now accepts a highlight classname
* uses for loops instead of .each
* pat.toUpperCase() has been moved, however it probably didnt change anything

*/

jQuery.fn.highlight = function(pat, className) {
    className = className || "highlight";
    pat = pat.toUpperCase();
    function innerHighlight(node, pat, className) {
        var skip = 0;
        if (node.nodeType == 3) {
            var pos = node.data.toUpperCase().indexOf(pat);
            if (pos >= 0) {
                var spannode = document.createElement('span');
                spannode.className = className;
                var middlebit = node.splitText(pos);
                var endbit = middlebit.splitText(pat.length);
                var middleclone = middlebit.cloneNode(true);
                spannode.appendChild(middleclone);
                middlebit.parentNode.replaceChild(spannode, middlebit);
                skip = 1;
            }
        }
        else if (node.nodeType == 1 && node.childNodes && !/(script|style)/i.test(node.tagName)) {
            for (var i = 0; i < node.childNodes.length; ++i) {
                i += innerHighlight(node.childNodes[i], pat, className);
            }
        }
        return skip;
    }
    for (var j = 0, len = this.length; j < len; j++) {
        innerHighlight(this[j], pat, className);
    }
    return this;
};

jQuery.fn.removeHighlight = function(className) {
    className = className || "highlight";
    var $elems = this.find("span." + className);
    for (var i = 0, len = $elems.length; i < len; i++) {
        var elem = $elems[i];
        elem.parentNode.firstChild.nodeName;
        with (elem.parentNode) {
            replaceChild(elem.firstChild, elem);
            normalize();
        }
    }
    return this;
};
/*[{!jquery_highlight_3_js_652z55k!}]*/