/**
 * Displays default text in the input field when its value is empty.
 * If the browser supports placeholder input attributes (HTML5), then
 * we skip this component.
 *
 * Usage:
 * <pre>
 * &lt;input placeholder="Some default text"&gt;
 * </pre>
 *
 */
;(function($) {
    var hasHtml5Placeholder = ('placeholder' in document.createElement('input'));
    var attrName = "placeholder";
    var className = "placeholder-shown";

    $.fn.extend({
        placeholder: function (defaultValue) {
            var $this = this;
            $this.attr(attrName, defaultValue);
    
            if (hasHtml5Placeholder) {
                if ($this.val() == defaultValue) {
                    $this.val("");
                }
                return this;
            }

            if ($this.length) {//input exists
                var applyDefaultText = function() {
                    if (!$.trim($this.val()).length) {
                        $this.val($this.attr(attrName))
                                .addClass(className);
                    }
                };

                $this.bind('placeholderReset.jQueryPlaceholder', applyDefaultText);

                applyDefaultText();
                $this.blur(applyDefaultText).focus(function() {
                    if ($this.hasClass(className)) {
                        if ($this.val() == $this.attr(attrName)) {
                            $this.val("");
                        }
                        $this.removeClass(className);
                    }
                }).change(function () {
                    if ($this.val() == $this.attr(attrName)) {
                        $this.addClass(className);
                    } else {
                        $this.removeClass(className);
                    }
                }).change(); // this checks if the current value is the default value, and applies the appropriate class
            }
            return this;
        },
        isPlaceholded: function () {
            if (hasHtml5Placeholder) {
                return !this.val();
            }
            return this.hasClass(className);
        }
    });
})(jQuery);
/*[{!jquery_fecru_placeholder_js_pb3l55i!}]*/