/**
 * This plugin wraps the jquery autocomplete plugin to provide some encapsulation and share common code
 */
;(function($, templateFactory) {
    var getFormatItemFunction = function(settings, getSelectionCache) {

        var isItemChecked = settings.isItemChecked,
            useCheckboxes = settings.useCheckboxes;


        var entryTemplateText = [
                '<div>',
                    '<{entryTagName} class="entry{checkboxClass}{disabledClass}{headerClass}">',
                        '<span class="ac-display-primary" title="{primary}">{primary}</span>',
                        '<span class="ac-display-secondary">{secondary}</span>',
                        '<span class="ac-display-meta">{meta}</span>',
                    '</{entryTagName}>',
                '</div>'
            ].join('');

        var onClick = function(e) {
            //prevent autocomplete from closing the dropdown
            e.stopImmediatePropagation();
            settings.$input.focus();
        };

        return function(data) {
            var dataId = data.id,
                    selectionCache = getSelectionCache(),
                    entryHtml;

            entryHtml = templateFactory(entryTemplateText).fill({
                primary : data.displayPrimary || "Unknown",
                secondary: data.displaySecondary || "",
                meta : data.displayMeta || "",
                checkboxClass : useCheckboxes && dataId ? " ac-checkbox" : "",
                headerClass : data.isHeader ? " ac-header" : "",
                disabledClass : data.disabled ? " ac-disabled" : "",
                entryTagName : useCheckboxes ? "label" : "span"
            }).toString();

            var $entry = $(entryHtml);
            var $entrySpan = $entry.children(".entry");

            if (useCheckboxes && dataId) {
                $entrySpan.prepend(
                    $("<input type='checkbox'>")
                        .attr("name", dataId)
                        .attr('checked', selectionCache.hasOwnProperty(dataId) ?
                            selectionCache[dataId] :
                            selectionCache[dataId] = isItemChecked(dataId)
                        )
                        .change(function() {
                            getSelectionCache()[dataId] = this.checked;
                            settings.$input.trigger("selection", [dataId, this.checked]);
                        })
                );
                $entry.click(onClick);
            }

            /* TODO: this is damage control. Autocomplete sucks if you pass in non-strings.
               So only pass in elements if you need to (because you have event handlers).
               Need to fix up the autocomplete to be cool with elements.
             */
            return useCheckboxes ? $entry : $entry.children();
        };
    };

    var defaults = {
        disableCache: true,
        matchContains: false,
        max: 50,
        minChars: 0,
        maxHeight: 180,
        resultsClass: "ac_results",
        useCheckboxes: false,
        searchOnFocus : false,
        isItemChecked: function(value) {
            return false;
        },
        resultShown: null,
        parseResult: function (r) {
            return {
                data: r,
                value: r.id,
                disabled: r.disabled,
                isHeader: r.isHeader,
                result: r.displayPrimary,
                extraClass: r.extraClass
            };
        }
    };

    var getDefaultExtraParams = function (opts) {
        return {
            "spinnerStarted" : function () {
                FECRU.AJAX.startSpin(opts.id, "autocompleteSpinner");
                return "true";
            }
        }
    };

    $.fn.extend({
        fecruAutocomplete: function (opts) {
            var $input = this,
                $arrow = $input.siblings(".fecru-autocomplete-dropdown-icon"),
                additionalOptions = $input.data('fecru-ac-options');

            var settings = additionalOptions ? $.extend(additionalOptions, opts) : opts;

            var selectionCache = {};
            function getSelectionCache() {
                return selectionCache;
            };

            var arrowDisplay = settings.arrowDisplay || "visible";
            var arrowOnEnter = arrowDisplay === "enter";
            var arrowShown = arrowDisplay === "visible";

            var showArrow = function () {
                $arrow.addClass('visible');
            };
            var hideArrow = function () {
                $arrow.removeClass('visible');
            };


            // Create our own footer element option for an "Done" link
            if (settings.useCheckboxes) {
                var finishEvent = function($results) {
                    var selectedIds = [], unselectedIds = [];

                    for (var dataId in selectionCache) {
                        if (selectionCache.hasOwnProperty(dataId)) {
                            if (selectionCache[dataId]) {
                                selectedIds.push(dataId);
                            } else {
                                unselectedIds.push(dataId);
                            }
                        }
                    }

                    selectionCache = {};

                    $input.trigger('result', [null, selectedIds, unselectedIds]);
                    $results.hide();

                    return false;
                },
                selectCurrent = function($results, state) {
                    var $checkbox = $results.find(".ac_over input:visible"),
                        dataId = $checkbox.attr('name');
                    if (dataId) {
                        if (state === undefined) { //toggle
                            selectionCache[dataId] = !(selectionCache.hasOwnProperty(dataId) && selectionCache[dataId]);
                            $checkbox.attr('checked', selectionCache[dataId]);
                        } else {
                            $checkbox.attr('checked', selectionCache[dataId] = !!state);
                        }
                    }
                };

                //this matches the jquery.autocomplete's event handling (keypress for Opera).
                $input.bind(($.browser.opera ? "keypress" : "keydown"), function(event) {
                    switch(event.keyCode) {
                        case $.ui.keyCode.TAB:
                        case $.ui.keyCode.ENTER:
                            var $done = $(document).find('.ac-done:visible'),
                                $results = $done.closest('.ac_results');
                            selectCurrent($results);
                            finishEvent($results);
                            return false;
                    }
                });

                settings.$input = $input;

                if (!settings.getFooterElement) {
                    settings.getFooterElement = function(data, term, resp) {
                        return data && data.length ?
                            $("<div class='ac-footer-apply'></div>").append(
                                $('<a class="ac-done">Done</a>').click(function(event) {
                                    finishEvent($(this).closest('.ac_results'));
                                    event.stopImmediatePropagation();
                                    return false;
                                })
                            ) :
                            undefined;
                    };
                }
            }

            var isFocussed = false;

            $input.bind("focus", function () {
                    isFocussed = true;
                    if (!$input.hasClass('disabled')) {
                        this.select();
                    }
                    if (arrowOnEnter) {
                        showArrow();
                    }
                })
                .autocomplete(settings.url, getAutocompleteOptions($input, settings, getSelectionCache))
                .result(function(event, data) {
                    if (settings.result) {
                        settings.result($input, data);
                    } else {
                        if (!data.disabled && !data.isHeader) {
                            $input.val(data.id);
                        }
                    }
                });

            // If the client wants the arrow always shown, then we need to explicitly do it here
            if (arrowShown) {
                showArrow();
            } else if (arrowOnEnter) {
                $input.blur(function () {
                    isFocussed = false;
                    hideArrow();
                }).parent().hover(showArrow, function () {
                    // only hide the dropdown if it isn't focussed
                    if (!isFocussed) {
                        hideArrow();
                    }
                });
            } else {
                hideArrow();
            }
            
            $arrow.bind("mousedown", function (e) {
                if (e.target !== $input[0]) {
                   /* Internet explorer cannot prevent default on mousedown, meaning that a blur event will fire.
                    * We only want blur to fire when clicking outside of the field. The field in our case includes the
                    * dropdown or any elements appended by the sub classes so we only want to blur if it is not one of
                    * these child elements
                    */
                    if (AJS.$.browser.msie) {
                        $input[0].attachEvent("onbeforedeactivate", function () {
                            $input[0].detachEvent("onbeforedeactivate", arguments.callee);
                            return false;
                        });
                    } else {
                        e.preventDefault();
                    }
                }
            }).click(function () {
                $input.trigger("forceSearch", "");
            });

            $input.bind('fecruSetOptions', function(event, options) {
                $input.setOptions(getAutocompleteOptions($input, $.extend(settings, options, getSelectionCache)));
            }).bind('fecruResetSelectionCache', function() {
                selectionCache = {};
            });
            $input.data('fecru-ac-init', true);

            return $input;
        },
        fecruSetOptions : function(options) {
            var $input = this;
            if ($input.data('fecru-ac-init')) {
                $input.trigger('fecruSetOptions', [options]);
            } else {
                var existingOptions = $input.data('fecru-ac-options');
                $input.data('fecru-ac-options', existingOptions ?
                    $.extend(existingOptions, options) :
                    options);
            }

            return this;
        },
        resetSelectionCache : function() {
            return $(this).trigger('fecruResetSelectionCache');
        }
    });

    var getAutocompleteOptions = function ($input, opts, getSelectionCache) {
        var settings = $.extend({}, defaults, opts);
        var extraParams = $.extend({}, getDefaultExtraParams(opts), opts.extraParams);

        if (!settings.formatItem) {
            settings.formatItem = getFormatItemFunction(settings, getSelectionCache);
        }

        var header,
            lastResponseObject;

        return {
            disableCache: settings.disableCache,
            matchContains: settings.matchContains,
            max: settings.max,
            scrollHeight: settings.scrollHeight,
            minChars: settings.minChars,
            width: settings.width || $input.outerWidth() || $input.width(),
            resultsClass: settings.resultsClass,
            resultShown: settings.resultShown,
            formatItem: settings.formatItem,
            getHeaderElement: opts.getHeaderElement ? function(data, term) {
                    return opts.getHeaderElement(data, term, lastResponseObject);
                } : undefined,
            getFooterElement: opts.getFooterElement ? function(data, term) {
                    return opts.getFooterElement(data, term, lastResponseObject);
                } : undefined,
            searchOnFocus : opts.searchOnFocus || false,
            notFoundData: opts.notFoundData,
            errorData: opts.errorData,
            /**
             * This function is *not documented*, but is called as an alternative to the insufficient data.split("|") default.
             * @param data AJAX data to parse
             */
            parse: function (data) {
                var resp = lastResponseObject = eval(data);


                function parseResultItems(results){
                    var parsed = [];
                    for (var i = 0, len = results.length; i < len; i++) {
                        var r = results[i];
                        parsed.push(parser(r));
                    }
                    FECRU.AJAX.stopSpin(opts.id);
                    return parsed;
                }

                var results;
                var parser = settings.parseResult;
                if ($.isArray(resp)) {
                    return parseResultItems(resp);
                } else if("totalItems" in resp) {
                    results = parseResultItems(resp.items || []);
                    results.totalItems = resp.totalItems;
                    results.hasQuerySpecified = resp.hasQuerySpecified;
                    return results;
                } else {
                    if (resp.header) {
                        header = resp.header;
                    }
                    results = resp.results || [];
                    if (!opts.parseResult && resp.parser) {
                        try {
                            eval('parser = (' + resp.parser + ')');
                        } catch (e) {
                            AJS.log("Could not create autocomplete parser: " + e);
                        }
                    }
                    return parseResultItems(results);
                }
            },
            /**
             * The extra paramaters can accept functions, which get executed before the ajax request happens. We can piggy back onto it
             * to start the spinner.
             */
            extraParams: extraParams
        }
    };
})(jQuery, AJS.template);
/*[{!jquery_fecru_autocomplete_js_4loj55f!}]*/