window.FECRU = window.FECRU || {};

/**
 * jQuery uses [,] and : as special characters for selectors. These characters are still valid in HTML ids.
 * Use this method to return a sanitized version of the id for use in jQuery selectors.
 * @param id id to sanitize
 */
FECRU.sanitizeId = function (id) {
    return id.replace(/:/g, "\\:").replace(/\./g, "\\.");
};


FECRU.isRightClick = function (e) {
    return e.which === 3;
};

FECRU.openInSameTab = function (e) {
    return (!e.which || e.which === 1) && !(e.metaKey || e.ctrlKey || e.shiftKey || (e.altKey && !AJS.$.browser.msie));
};

/**
 * Pads a string with filler.  E.g.
 *      FECRU.pad(
 *          FECRU.pad(" Kwanzaa, ", 22, false, 'Merry, '),
 *          27, true, 'Joe')
 *  becomes "Merry, Merry Kwanzaa, JoeJo"
 * @param input - the input string to pad
 * @param length - the minimum length of the string
 * @param padRight - if true, add padding on the right side, otherwise add it to the left
 * @param padString - the string to pad the output with, default is a space.
 * @return a string padded to the requested length.
 */
FECRU.pad = function (input, length, padRight, padString) {
    padString = String(padString || ' ');
    var str = String(input);
    if (str.length < length) {
        var padLength = length - str.length;

        // padding is: (N repetitions of padString) + remaining substring of padString to fit.
        var padding = (new Array(1 + Math.floor(padLength / padString.length)).join(padString)) +
            padString.substring(0, padLength % padString.length);
        return padRight ? str + padding : padding + str;
    }
    return str;
};

/**
 * Format an number as a comma-separated int.
 *
 * Ex: formatInt(1000000) -> "1,000,000", formatInt(1000000.001) -> "1,000,000"
 */
FECRU.formatInt = function (num, localSeparator) {
    var sep = localSeparator || ",";
    var s = String(Math.floor(num));
    var sf = "";
    var length = s.length;

    for (var i = 0; i < length; i++) {
        sf = s.charAt(length - 1 - i) + sf;
        if (i !== length - 1 && i % 3 === 2) {
            sf = sep + sf;
        }
    }

    return sf;
};

/**
 * Given a changeset id, return a display version
 * @param repoType string representation of the repository type (svn|git|hg|p4|cvs)
 * @param id the changeset id to prettify
 */
FECRU.getDisplayCsId = function (repoType, id) {
    if (!repoType || !id) {
        throw "getDisplayCsId requires repoType and id arguments";
    }

    switch (repoType.toLowerCase()) {
        case "hg":
            return id.length > 12 ? id.substr(0, 12) : id;

        case "git":
            // Same as abbreviated commit hash
            return id.length > 7 ? id.substr(0, 7) : id;

        default:
            return id;
    }
};

/**
 * given a string, return a string with the quotes "quoted" - e.g., abc'def --> abc\'def
 * so that the string is safe to be used as json.
 * @param str
 */
FECRU.quoteString = function (str) {
    return str.replace(/('|\\")/g, "\\$1");
};

FECRU.truncateText = function (str, options) {
    if (!str) {
        return str;
    }
    var defaults = {
        maxLength: 10,
        ellipsis: "..."
    };

    var opts = AJS.$.extend({}, defaults, options);

    if (opts.maxLength < 1 || str.length <= opts.maxLength) {
        return str;
    } else if (opts.maxLength === 1) {
        return str.substring(0, 1) + opts.ellipsis;
    }

    var midpoint = Math.ceil(str.length / 2);
    var removeCount = str.length - opts.maxLength;
    var lStrip = Math.ceil(removeCount / 2);
    var rStrip = removeCount - lStrip;

    var truncated = str.substring(0, midpoint - lStrip) + opts.ellipsis + str.substring(midpoint + rStrip);
    // Let's not be idiotic about our "truncation" if we are generating a string of equal or greater length
    if (truncated.length >= str.length) {
        return str;
    }
    return truncated;
};
/**
 * Null-safe _.compose version
 */
FECRU.sequence = function () {
    var sequence = [];
    for (var i = 0; i < arguments.length; i++) {
        if (arguments[i] != null) {
            sequence.push(arguments[i]);
        }
    }
    return _.compose.apply(_, sequence);
};

/**
 * Copied off ExpressionUtil.escapeHtmlIdOrName()
 */
FECRU.zEscape = (function () {
    var A = 'A'.charCodeAt(0);
    var Z = 'Z'.charCodeAt(0);
    var a = 'a'.charCodeAt(0);
    var z = 'z'.charCodeAt(0);
    var zero = '0'.charCodeAt(0);
    var nine = '9'.charCodeAt(0);

    function isAsciiLetter(c) {
        return (A <= c && c <= Z) || (a <= c && c <= z);
    }

    function isAsciiDigit(c) {
        return (zero <= c && c <= nine);
    }

    function isAsciiLetterOrDigit(c) {
        return isAsciiDigit(c) || isAsciiLetter(c);
    }

    function toHexString(c) {
        return c.toString(16);
    }

    return function (s) {
        if (!s) {
            return null;
        }
        var out = [];
        var hex = undefined;
        var c = undefined;

        for (var i = 0, len = s.length; i < len; i++) {
            c = s.charCodeAt(i);
            //prepend 'z' if first letter is not a letter
            if ((i === 0 && !isAsciiLetter(c)) || c === Z) { //always escape 'Z' to prevent dupe ids
                out.push('Z');
            }
            if (isAsciiLetterOrDigit(c)) {
                out.push(String.fromCharCode(c));
            } else {
                switch (c) {
                    case '-'.charCodeAt(0):
                    case '_'.charCodeAt(0):
                    case '.'.charCodeAt(0):
                        out.push(String.fromCharCode(c));
                        break;
                    default:
                        //escape non-valid id characters & pad to 4 chars
                        out.push('Z');
                        hex = toHexString(c);
                        out.push(FECRU.pad("", 4 - hex.length, false, "0"));
                        out.push(hex);
                }
            }
        }
        return out.join("");
    };
})();

/**
 * NOTE: Avoid changing this implementation as the colors in the Commit Graph will be affected.
 * @param string A string to get the numerical hash for.
 * @param modulo A number that the hash will be mod'd by before being returned.
 * @return A number between zero (inclusive) and modulo (exclusive)
 */
FECRU.numericHash = function hash(string, modulo) {
    var hash = 0;
    for (var i = 0, l = string.length; i < l; i++) {
        hash = (hash * 31) + string.charCodeAt(i);
    }
    return hash % 100043 % modulo;
};

/**
 * Parse a date formatted as "YYYY-MM-DDTHH:mm:ss" and interpreted
 * in the user's local timezone.
 */
FECRU.parseISO8601Date = function (str) {
    var parts = str.split("T");
    var dateParts = parts[0].split("-");
    var timeParts = parts[1].split(":");
    var year = parseInt(dateParts[0], 10);
    var month = parseInt(dateParts[1], 10) - 1; // Jan = 0
    var day = parseInt(dateParts[2], 10);
    var hour = parseInt(timeParts[0], 10);
    var minute = parseInt(timeParts[1], 10);
    var second = parseInt(timeParts[2], 10);

    return new Date(year, month, day, hour, minute, second);
};

/**
 * Given two dates in the user's local timezone,
 * calculates the number of working days between them.  A working day is currently defined
 * as 24 hours occurring on dates that are Monday-Friday. So Friday 1pm to Monday 1pm is exactly 1 working day.
 *
 * NOTE: Should mimic ISO8601DateHelper.java's method
 */
FECRU.getElapsedWorkingDays = function (startDate, endDate) {
    if (endDate < startDate) {
        return -FECRU.getElapsedWorkingDays(endDate, startDate);
    }

    var currDate = new Date(endDate);

    var workDays = 0;

    while (currDate >= startDate) {
        if (currDate.getDay() !== 6 && currDate.getDay() !== 0) {
            workDays++;
        }
        currDate.setDate(currDate.getDate() - 1);
    }

    // If the first day is a work day, we have counted it, even though no time is elapsed.
    // So we remove that 1 day here.  An alternative explanation would be that
    // this handles the case where startDate is a weekend.  This way the difference between
    // any time Saturday and any time Friday is 0 days, Friday 4pm to Monday 3pm is 0 days, and
    // Friday 4pm to Monday 5pm is 1 day.
    workDays = Math.max(workDays - 1, 0);

    return workDays;
};

FECRU.pluralise = function (singular, plural, number) {
    return number === 1 || number === -1 ? singular : plural;
};

FECRU.getAvatarUrlAtSize = function (url, size) {
    var newUrl = FECRU.insertOrReplaceUrlParameter(url, "s", size);
    var redirectUrl = FECRU.getUrlParameter(newUrl, "d");
    if (redirectUrl.length > 0) {
        return FECRU.insertOrReplaceUrlParameter(newUrl,
            "d",
            FECRU.insertOrReplaceUrlParameter(redirectUrl, "s", "16"));
    } else {
        return newUrl;
    }

};

FECRU.insertOrReplaceUrlParameter = function (url, param, val) {
    var urlComponents = url.split("?");
    var newQs = "";
    var sep = "";
    if (urlComponents[1]) {
        var qsComponents = urlComponents[1].split("&");
        var qsComponentsLength = qsComponents.length;
        for (var ii = 0; ii < qsComponentsLength; ii++) {
            if (qsComponents[ii].indexOf(encodeURIComponent(param) + "=") === -1) {
                newQs = newQs + sep + qsComponents[ii];
                sep = "&";
            }
        }
    }
    return urlComponents[0] + "?" + newQs + sep + encodeURIComponent(param) + "=" + encodeURIComponent(val);
};

FECRU.getUrlParameter = function (url, param) {
    var urlComponents = url.split("?");
    if (urlComponents[1]) {
        var qsComponents = urlComponents[1].split("&");
        var qsComponentsLength = qsComponents.length;
        for (var ii = 0; ii < qsComponentsLength; ii++) {
            var prefix = encodeURIComponent(param) + "=";
            if (qsComponents[ii].indexOf(prefix) === 0) {
                return decodeURIComponent(qsComponents[ii].substring(prefix.length));
            }
        }
    }
    return "";
};

/**
 * Parse uri string to object with 'path' and 'params' properties
 * @param {String} uri Uri string
 * @returns {{path: string, params: {}}}
 */
FECRU.parseUri = function (uri) {
    var uriComponents = uri.split(/\?|#/);
    var parsed = {
        path: uriComponents[0],
        params: {}
    };
    var plusRegExp = /\+/g;
    if (uriComponents[1]) {
        var keyValuePairs = uriComponents[1].split('&');
        for (var i = 0; i < keyValuePairs.length; i++) {
            var keyValue = keyValuePairs[i].split('=');
            var key = decodeURIComponent(keyValue[0]);
            var value = typeof(keyValue[1]) === "string" ? decodeURIComponent(keyValue[1].replace(plusRegExp, " ")) : null;
            parsed.params[key] = value;
        }
    }
    if (uriComponents[2]) {
        parsed.anchor = uriComponents[2];
    }
    return parsed;
};

/**
 * Removes parameters from browser URL without page reload
 * @param paramNames
 * @returns new url without params
 */
FECRU.removeQueryParams = function(paramNames) {
    var currentUrl = window.location.toString();
    var newUrl = FECRU.removeQueryParamsFromUrl(currentUrl, paramNames);
    window.history.replaceState('', document.title, newUrl);
    return newUrl;
};


/**
 * Removes parameters from given URL query params with given param names
 * @param url, like: http://fecru.com/page?foo=1&bar=2&c=baz
 * @param paramNames, like: ['foo','baz']
 * @returns url without params, like http://fecru.com/page?bar=2
 */
FECRU.removeQueryParamsFromUrl = function (url, paramNames) {
    var parsedUrl = FECRU.parseUri(url);
    if (!AJS.$.isEmptyObject(parsedUrl.params)) {
        var filteredParams = _.omit(parsedUrl.params, paramNames);
        var newQueryParams = AJS.$.param(filteredParams);
        return parsedUrl.path + (newQueryParams ? '?' + newQueryParams : '') + (parsedUrl.anchor ? '#' + parsedUrl.anchor : '');
    }
    return url;
};

/**
 * Fire the callback when CSS transition of the passed element ends.
 * @param {jQuery} $element
 * @param {function} callback
 * @param {number} [waitNotMoreThan]
 */
FECRU.onTransitionEnd = function ($element, callback, waitNotMoreThan) {
    var transitionEndEvent = 'transitionend';
    var delay;
    var onDelay = function () {
        $element.off(transitionEndEvent, onTransitionEnd);
        callback();
    };
    var onTransitionEnd = function () {
        clearTimeout(delay);
        callback();
    };

    if (waitNotMoreThan) {
        delay = _.delay(onDelay, waitNotMoreThan);
    }

    $element.one(transitionEndEvent, onTransitionEnd);
};

/**

 1.
 To detect the browser and add a useful class to html
 can be extended in the future

 Current support classes:
 chrome, safari, firefox, msie

 This is useful for adding extra css for specific browser. e.g.

 html.msie .some-div {
    margin-left: 4px;  <-- will only take place in Internet Explorers
 }

 2.
 Since we have the user agent string, we will try to detect the os here as well.
 The result will be :
 windows, other

 */

(function () {
    var userAgent = navigator.userAgent;

    if (userAgent) {
        userAgent = userAgent.toLowerCase();
    } else {
        userAgent = '';
    }

    var $html = AJS.$('html');
    if (userAgent.indexOf('msie') !== -1) {
        $html.addClass('msie');
    } else if (userAgent.indexOf('firefox') !== -1) {
        $html.addClass('firefox');
    } else if (userAgent.indexOf('chrome') !== -1) {
        $html.addClass('chrome');
    } else if (userAgent.indexOf('safari') !== -1) {
        $html.addClass('safari');
    }

    FECRU.OS = userAgent.indexOf('windows') !== -1 ? 'windows' : 'other';
})();
/*[{!util_js_0w2154c!}]*/