window.FECRU = window.FECRU || {};
FECRU.UI = FECRU.UI || {};

(function () {

    var hasSetDropdowns = false;

    var enabledAnimations = true;
    if (AJS.$.browser.msie && AJS.$.browser.version < 9) {
        enabledAnimations = false;
    }

    FECRU.UI.setDropdowns = function () {
        if (hasSetDropdowns) {
            AJS.log("WARNING: About to set duplicated dropdown live events");
        } else {
            hasSetDropdowns = true;
        }

        var options = {
            selectionHandler: function () {
                // Prevent AUI from reimplementing default browser handling of <a> elements.
                // May need to revisit depending on AUI changes (see CR-FE-1617).
            },
            useLiveEvents: true, //using live meant that hovers will no longer need to perform a dropdown bind on load
            trigger: '.aui-dd-link'
        };

        options.dropDown = ".aui-dropdown-left:not(.aui-dropdown-ajax)";
        options.alignment = "left";
        AJS.dropDown.Standard(AJS.$.extend({}, options));

        options.dropDown = ".aui-dropdown-right:not(.aui-dropdown-ajax)";
        options.alignment = "right";
        AJS.dropDown.Standard(AJS.$.extend({}, options));
    };

    FECRU.UI.filterToggle = function (filters) {
        return AJS.dropDown.Standard({
            trigger: ".filter-toggle",
            dropDown: filters,
            alignment: 'right'
        });
    };

    /**
     * Setup a delegated event for the (+2 more) links for branches, tags, parents etc.
     * Currently used in the changeset and file history pages
     * @param $container
     */
    FECRU.UI.registerMetadataExpanders = function ($container) {
        $container.delegate(".metadata-plus a", "click", function () {
            var $p = AJS.$(this).parent();
            $p.siblings(".hidden").removeClass("hidden");
            $p.hide();
        });
    };

    var linkAugment = function () {
        AJS.$("a[rel='help']").attr("target", "_help");

        // details switch in stream
        // todo delete?
        AJS.$(".details-switch").unbind().click(function () {
            AJS.$(this).toggleClass("details-expanded");

            var $verbose = AJS.$(this).siblings(".details-verbose");
            if ($verbose.css("display") === "none") {//toggle() is broken in IE8, so checking display
                $verbose.show();
            }
            else {
                $verbose.hide();
            }
        });

        // inline hover in stream
        AJS.$(".hover").mouseover(function (event) {
            AJS.$("#hover").addClass("mouseover");
            inlineHover(AJS.$(this), event);
        });

        AJS.$("#hover").mouseout(function () {
            var which = AJS.$(this);
            which.bind("mouseleave", function () {
                AJS.$(which)
                    .removeClass("mouseover")
                    .hide();
            });
        });
        AJS.$("hover-close").click(function () {
            AJS.$(this).hide();
        });
    };

    var $focusedTableRow;
    FECRU.UI.tableRowClick = function (prefix, rowClickFn) {
        AJS.$(document).delegate("#" + prefix + "-table > tbody > tr", "click", function () {
            var clearFocus = function () {
                if ($focusedTableRow) {
                    $focusedTableRow.removeClass(prefix + "-focus");
                }
            };

            var $this = AJS.$(this);
            if ($this.hasClass(prefix + "-focus")) {
                clearFocus();
                $focusedTableRow = null;
            } else {
                clearFocus();
                $this.addClass(prefix + "-focus");
                $focusedTableRow = $this;
                if (rowClickFn) {
                    rowClickFn(this);
                }
            }
        });
    };

    FECRU.UI.tableSort = function (prefix, extractionFn) {
        var params = {};
        if (extractionFn) {
            params['textExtraction'] = extractionFn;
        }
        AJS.$("#" + prefix + "-table").tablesorter(params);
    };

    FECRU.UI.accordion = function () {
        AJS.$(document).delegate('.sidebar-collapse', "click", function () {
            AJS.$('#content').toggleClass('collapsed-sidebar');
            return false;
        }).delegate(".accordion-head", "click", function () {
            var $next = AJS.$(this).next();
            var $parent = AJS.$(this).parent();

            if ($next.is(":hidden")) {
                $parent.addClass("active");
                if (enabledAnimations) {
                    $next.slideDown("fast");
                } else {
                    $next.show();
                }
            }
            else {
                if (enabledAnimations) {
                    $next.slideUp("fast", function () {
                        $parent.removeClass("active");
                    });
                } else {
                    $next.hide();
                    $parent.removeClass("active");
                }
            }
            return false;
        }).delegate("#accordion-toggle", "click", function () {
            var $accordionToggle = AJS.$(this);
            var $accordionContent = $accordionToggle.find(".accordion-content");
            var $parent = AJS.$(this).parent();
            var isExpanded = $accordionToggle.html() === 'expand';
            if (isExpanded) {
                $parent.addClass("active");
                if (enabledAnimations) {
                    $accordionContent.slideDown("fast");
                } else {
                    $accordionContent.show();
                }
            } else {
                if (enabledAnimations) {
                    $accordionContent.slideUp("fast", function () {
                        $parent.removeClass("active");
                    });
                } else {
                    $accordionContent.hide();
                    $parent.removeClass("active");
                }
            }
            $accordionToggle.html(isExpanded ? 'expand' : 'collapse'); // reverse (it's now "wasExpanded")
            return false;
        });
    };

    var inlineHover = function (which, event) {
        if (!AJS.$("#hover").hasClass("mouseover")) {
            return false;//don't fire if the link is no longer hovered
        }

        var source = which.attr("name").split("-")[0];
        var subject = which.attr("name").split("-")[1];
        var content;
        var offset = which.offset();
        var height = which.height();

        if (source === "user") {
            content = hovers.users[subject]; // eslint-disable-line no-undef
        }
        else if (source === "item") {
            content = hovers.items[subject]; // eslint-disable-line no-undef
        }

        AJS.$("#hover-content").html(content);
        AJS.$("#hover").css({
            display: "block",
            top: offset.top + height,
            left: offset.left
        });
    };

    FECRU.UI.initStream = function () {
        linkAugment();
    };

    FECRU.UI.contentPadBottom = function () {
        var contentPadding = AJS.$("#content").css("padding-bottom");
        var messageHeight = AJS.$("#footer-bar .system-message").height();
        var messagePadding = parseInt(contentPadding, 10) + messageHeight;
        AJS.$("#content").css("padding-bottom", messagePadding);
    };

    /**
     * checks if the dates in the elements ".calendar-date-end" and ".calendar-date-start" are in the correct order
     * and swap them around if they are found to be reversed.
     *
     * @param extractDateStringFn a function to extract the date string into the format 'yy-mm-dd' from the format
     * obtained in the value attribute of the input element
     */
    FECRU.UI.swapDatesIfReversed = function (extractDateStringFn, context) {
        context = context || "body";
        var endDateInput = AJS.$("input.calendar-date-end", context);
        var startDateInput = AJS.$("input.calendar-date-start", context);
        if (endDateInput.length > 0 && startDateInput.length > 0) {
            var startDateStr = startDateInput.val();
            var endDateStr = endDateInput.val();
            var extractedStartDate = extractDateStringFn(startDateStr);
            var extractedEndDate = extractDateStringFn(endDateStr);
            var startDate;
            var endDate;
            var errorThrown = false;

            try {
                startDate = AJS.$.datepicker.parseDate('yy-mm-dd', extractedStartDate);
            } catch (e) {
                FECRU.AJAX.appendErrorMessage("Could not parse start date " + extractedStartDate);
                errorThrown = true;
            }

            try {
                endDate = AJS.$.datepicker.parseDate('yy-mm-dd', extractedEndDate);
            } catch (e) {
                FECRU.AJAX.appendErrorMessage("Could not parse end date " + extractedEndDate);
                errorThrown = true;
            }

            if (errorThrown) {
                FECRU.AJAX.showErrorBox();
                return false;
            }

            if (startDateStr && endDateStr && (startDate > endDate)) {
                //do a swap of the date values before submitting if the dates are found to be reversed
                endDateInput.val(startDateStr);
                startDateInput.val(endDateStr);
            }
        }
        return true;
    };

    FECRU.UI.setupCalendar = function (addTime, constrainInput) {
        if (addTime === undefined || addTime === null) {
            addTime = true;
        }
        if (constrainInput === undefined || constrainInput === null) {
            constrainInput = true;
        }
        var calDateStart = AJS.$("input.calendar-date-start");
        calDateStart.attr("autocomplete", "off");
        calDateStart.datepicker({
            dateFormat: 'yy-mm-dd',
            constrainInput: constrainInput,
            onClose: function (dateText) {
                //only do this if the text is the length of a date
                //this will FAIL if anyone changes the date format

                //NOTE: yy-mm-dd in jquery is a 10 character format
                // ie 1987-12-23
                if (addTime && dateText.length === 10) {
                    AJS.$(this).attr("value", dateText + "T00:00:00");
                }
            }
        });
        var calDateEnd = AJS.$("input.calendar-date-end");
        calDateEnd.attr("autocomplete", "off");
        calDateEnd.datepicker({
            dateFormat: 'yy-mm-dd',
            constrainInput: constrainInput,
            onClose: function (dateText) {
                if (addTime && dateText.length === 10) {
                    AJS.$(this).attr("value", dateText + "T23:59:59");
                }
            }
        });
    };

    FECRU.UI.warnAboutFirebug = function (onClose) {
        var cookieName = 'hide_fecru_fb_warn';
        var suppressWarning = AJS.$.cookie(cookieName) === 'Y';
        if (!suppressWarning && window.console && window.console.firebug) {
            var product = AJS.$("#product-name").text() || "FishEye + Crucible";
            var $warning = AJS.$("<div id='firebug-warning'><p>Firebug is known to cause performance problems with " +
                product + ". Why not disable it?</p><a class='close'>X</a></div>");
            AJS.$(document).delegate("#firebug-warning .close", "click", function () {
                $warning.slideUp('fast', function () {
                    AJS.$.cookie(cookieName, 'Y', {expires: 365});
                    if (onClose) {
                        onClose();
                    }
                });
            });
            $warning.prependTo(AJS.$("#masthead"));
        }
    };

    FECRU.UI.toggleSearch = function () {
        AJS.$(document).delegate("h5[rel='toggle']", "click", function () {
            if (AJS.$(this).hasClass("show")) {
                AJS.$("#search-more").show();
                AJS.$(this).removeClass("show").addClass("hide");
                AJS.$(this).find("em").text("hide");
            }
            else {
                AJS.$("#search-more").hide();
                AJS.$(this).addClass("show").removeClass("hide");
                AJS.$(this).find("em").text("show");
            }
            return false;
        });
    };

    FECRU.UI.setCompletedResizeTimeout = function (selector, callback, completionDelay) {
        completionDelay = completionDelay || 100;
        var timeout;

        AJS.$(selector).resize(function () {
            if (completionDelay > 0 && timeout) {
                clearTimeout(timeout);
            }
            timeout = setTimeout(callback, completionDelay);
        });
    };


    FECRU.UI.resizeAndCollateImagesToThumbs = function () {
        var $comments = AJS.$(".article-message .long-message.markup").filter(":has(.image-wrap)");
        var commentsSize = $comments.size();
        var thumbify = function ($img) {

            // Only thumb the image if it hasn't already been thumbed
            if ($img.parent().parent().hasClass('image-wrap')) {
                var width = $img[0].width; // we use the dom element properties to ingore the fact the image isn't visible
                var height = $img[0].height;
                var thumbs = {
                    width: 100,
                    height: 67
                };

                if (width > thumbs.width || height > thumbs.height) {
                    var wRatio = width / thumbs.width;
                    var hRatio = height / thumbs.height;

                    if (wRatio > hRatio) {
                        $img.width(thumbs.width);
                    } else {
                        $img.height(thumbs.height);
                    }
                }
                // IE workaround. We want to ensure this method is run again when the long message becomes visible
                if (width !== 0 || height !== 0) {
                    // Remove the class which hides the image now that we've thumbed it
                    $img.closest(".image-wrap").removeClass("image-wrap").addClass("image-wrapped");
                }
            }
        };

        for (var i = 0; i < commentsSize; i++) {
            var $wrappers = $comments.eq(i).find(".image-wrap");
            var wrappersSize = $wrappers.size();
            var $img = $wrappers.children("img");
            var className = "comment-t" + i;

            // Unfortunately we have to process each image separately
            AJS.$.each($img, function () {
                var $this = AJS.$(this);
                $this.wrap('<a href="' + $img.attr('src') + '" class="fancybox-image" rel="' + className + '"></a>');
                $this.load(function () {
                    thumbify($this);
                });
                if (this.complete) {
                    $this.trigger("load");
                }
            });
        }

        // Fancy box all the images in the comment into a gallery
        AJS.$(".fancybox-image").fancybox({
            transitionIn: 'elastic',
            transitionOut: 'elastic'
        });
    };

    /**
     * Hide aui-dropdown2 element basing on passed argument.
     * Why do we need this?
     * After AUI upgrade (from 5.5 to 5.8) dropdown2's behaviour was changed a bit.
     * So now if a click event was prevented, dropdown2 won't be closed automatically.
     *
     * @param {Node|jQuery} element - dropdown's child element or dropdown itself
     */
    FECRU.UI.hideClosestDropdown2 = function (element) {
        AJS.layer(AJS.$(element).closest('.aui-dropdown2')).hide();
    };

})();
/*[{!ui_js_1ew854b!}]*/