(function ($, g, undefined) {
    // UIBlock requires the Spinner.js (http://fgnass.github.io/spin.js/)
    // which is included in latest AUI.
    var Spinner = window.Spinner;
    var UIBlock = function ($parent, opts) {
        var t = this;
        t.$parent = $parent;
        t.margin = $.extend({}, marginDefault, opts.margin);
    };

    var marginDefault = {
        left: 0,
        right: 0,
        bottom: 0,
        top: 0
    };

    UIBlock.prototype = {
        init: function (opts) {
            opts = opts || {};
            var t = this;
            var $mask = t.$mask = $('<div class="fecru-page-mask"><div class="spinner-wrap"></div></div>');
            t.$parent.append($mask);
            t.$parent.css('position', 'relative');
            $mask.css(t.margin);

            var spinnerOpts = $.extend({
                lines: 9, // The number of lines to draw
                length: 12, // The length of each line
                width: 6, // The line thickness
                radius: 13, // The radius of the inner circle
                corners: 1, // Corner roundness (0..1)
                rotate: 0, // The rotation offset
                direction: 1, // 1: clockwise, -1: counterclockwise
                color: '#666', // #rgb or #rrggbb
                speed: 1, // Rounds per second
                trail: 60, // Afterglow percentage
                shadow: false, // Whether to render a shadow
                hwaccel: false, // Whether to use hardware acceleration
                className: 'spinner', // The CSS class to assign to the spinner
                zIndex: 2e9, // The z-index (defaults to 2000000000)
                top: 'auto', // Top position relative to parent in px
                left: 'auto' // Left position relative to parent in px
            }, opts.spinner);

            t.spinner = new Spinner(spinnerOpts);
            t.spinner.spin();
            $mask.find('.spinner-wrap').append(t.spinner.el);
        },
        block: function () {
            var t = this;
            var $spinner = t.$mask.find('.spinner');

            clearTimeout(t.spinnerTimer);
            $spinner.stop();

            var height = $(window).height() - t.$parent.find('#quicksearch-pane').offset().top;
            t.$mask.find('.spinner-wrap').height(height);

            $('.activityLoading').css('opacity', 0);

            t.spinnerTimer = setTimeout(function () {
                $spinner.animate({opacity: 1});
            }, 500);
            $spinner.css({opacity: 0.1});
            t.$mask.css({
                'display': 'block',
                'opacity': 0.5
            });
        },
        unblock: function () {
            var t = this;
            var $spinner = t.$mask.find('.spinner');

            clearTimeout(t.spinnerTimer);
            $spinner.stop();
            t.$mask.animate({opacity: 0}, function () {
                t.$mask.css('display', 'none');
            });

            $('.activityLoading').css('opacity', 1);
        }
    };

    g.UIBlock = UIBlock;
})(AJS.$, window);
/*[{!ui_block_js_cyfg54a!}]*/