/*eslint eqeqeq:0*/

window.FECRU = window.FECRU || {};

(function () {

    /**
     * html for the star edit dialog, to be inserted on demand.
     */
    var DIALOG_DEFAULT = "Describe your favourite";
    /*eslint-disable indent*/
    var DIALOG_HTML = [
        "<div id='astronomy'>",
            "<div id='astronomy-label'>",
                "<h4><span>Update favourite</span></h4>",
                "<span class='close'><a href='#' class='close-astronomy' id='close-astronomy'>X</a></span>",
                "<form action='#'>",
                    "<fieldset class='input'>",
                        "<label for='star-labels'>Name</label>",
                        "<input type='text' id='star-labels' value='Describe your favourite'>",
                    "</fieldset>",
                    "<fieldset class='button'>",
                        "<ul>",
                            "<li><button class='remove' id='remove-astronomy'>Remove</button></li>",
                            "<li class='odd'><input type='submit' id='save-star-label' value='Save label'></li>",
                        "</ul>",
                    "</fieldset>",
                "</form>",
            "</div>",
        "</div>"
    ].join("");
    /*eslint-enable*/

    ////// private functions

    var ON_ONLY = true;
    var OFF_ONLY = false;

    function starOnOffClassName(on) {
        return on ? "star-on" : "star-off";
    }

    function starAddRemoveText($star, on) {
        return $star.find(on ? "input.star-textRemove" : "input.star-textAdd").val();
    }

    /**
     * todo: see if this can be swapped with the throbber jquery plugin.
     */
    function makeThrobberControl($link, throbberSetting) {
        /**
         * Starts the throbber, which activates after noLatencyThreshold milliseconds have passed.
         * @return a function that will stop the throbber after minThrobberDisplay milliseconds have passed, ensuring no flicker.
         */
        var startThrob = function () {
            $link.data("throbbing", true);
            var timeout = setTimeout(function () {
                $link.addClass("star-throb");
            }, throbberSetting.noLatencyThreshold);

            return function () {
                $link.data("throbbing", false);
                clearTimeout(timeout);
                setTimeout(function () {
                    $link.removeClass("star-throb");
                }, throbberSetting.minThrobberDisplay);
            };
        };

        /**
         * stores a function to stop the throbber for the given $link
         */
        var stopThrob = undefined;
        return {
            start: function () {
                if (throbberSetting.showThrob && !stopThrob) {
                    stopThrob = startThrob();
                }
            },
            stop: function () {
                if (stopThrob) {
                    stopThrob();
                    stopThrob = undefined;
                }
            },
            isThrobbing: function () {
                return $link.data("throbbing");
            }
        };
    }

    /**
     *
     * @param link the jquery element of the link that was clicked
     * @param dialogControl an object to control the dialog. Its members should be:
     * - showDialog: a function with no arguments, which when invoked will display the dialog
     * - hideDialog: a function with no arguments, which when invoked will hide the dialog
     * - getDialog: a function with no arguments, which returns a jquery object that represents the dialog
     * @param options the list of options. Available options are:
     * - throbber : options for throbbing
     *
     */
    function starClicked(link, dialogControl, options) {
        var starId = getStarId(link);
        var starOn = AJS.$(link).hasClass('star-on');

        var starKeys = {};
        var $link = AJS.$(link);
        var throbberControl = makeThrobberControl($link, options.throbberSetting);
        //if throbbing already, then don't do anything.
        if (throbberControl.isThrobbing()) {
            return;
        }

        $link.children("span.inputs").children("input.starKey").each(function () {
            var key = AJS.$(this);
            starKeys[key.attr("name")] = key.val();
        });
        if (starOn && starId != null) {
            if (isDialogShown($link)) {
                // we are unstarring, pop up the edit box
                editStar(starId, dialogControl, throbberControl, $link);
            } else {
                //...or remove directly without anymore interaction
                doRemoveStar(starId, throbberControl);
            }
        } else {
            // we are adding a star
            addStar(starKeys, dialogControl, throbberControl);
        }

        // todo: fix this hack to make hoverpopups refresh after starring
        // just always invalidate all popups
        var fecruHover = FECRU.HOVER;
        fecruHover.invalidateCache(fecruHover.CACHE_FOREVER);

    }

    function getIdElement(link) {
        return AJS.$(link).children("span.inputs").children("input[name='id']");
    }

    function getStarId(link) {
        return getIdElement(link).val();
    }

    function allStars(on) {
        return AJS.$("a." + starOnOffClassName(on));
    }

    function setStarAttributes(on, $node) {
        var newClass = starOnOffClassName(on);
        var oldClass = starOnOffClassName(!on);
        $node.removeClass(oldClass)
            .addClass(newClass)
            .children("span.starText").text(starAddRemoveText($node, on));
    }

    /**
     * Turn on the Star with the given keys
     * @param keys
     */
    function addStar(keys, dialogControl, throbberControl) {
        var paramMap = {};
        for (var key in keys) {
            if (keys.hasOwnProperty(key)) {
                paramMap["key." + key] = keys[key];
            }
        }
        throbberControl.start();
        doStar(FECRU.pageContext + "/json/profile/addStarAjax.do", paramMap, function (newId) {
            allStars(OFF_ONLY).each(function () {
                var $node = AJS.$(this);
                var $inputs = $node.children("span.inputs");
                for (var key in keys) {
                    if (keys.hasOwnProperty(key)) {
                        var input = $inputs.children("input.starKey[name='" + key + "']");
                        if (input.length === 0 || input.val() != keys[key]) {
                            return;
                        }
                    }
                }
                setStarAttributes(true, $node);
                $inputs.append("<input type='hidden' name='id' value='" + newId + "'>");
            });
            var itemType = keys["itemType"];
            if (itemType == "atlassian-chart" || itemType == "atlassian-search" ||
                itemType == "atlassian-quicksearch") {
                editStar(newId, dialogControl, throbberControl);
            } else {
                // WARNING: epic hack
                // This is to work around an incorrect usage of InlineDialog. We are leveraging IDs triggers to load
                // star ajax dialog, but in some cases we are not actually showing the dialog. This leaves the internal
                // state of InlineDialog in tatters and further calls to show the dialogs won't work. This workaround
                // simply shows and immediately hides the dialog ensuring the internal state is correct. The hidden
                // visibility is to ensure that the browser doesn't render the dialog on the screen.
                var $dialog = AJS.$("#inline-dialog-star-inline-dialog");
                $dialog.css("visibility", "hidden");
                dialogControl.showDialog();
                dialogControl.hideDialog();
                $dialog.css("visibility", "visible");
            }
            throbberControl.stop();
        });
    }

    /**
     * Pop up a dialog box for a Star which is in the on state, allowing the user to set its label or to remove it.
     * @param starId the id of the Star to change.
     * @param dialogControl
     */
    function editStar(starId, dialogControl, throbberControl, $star) {
        // pop up our star edit dialog
        var onSuccess = function (resp) {
            if (resp.worked) {
                var __updateLabel = function (label) {
                    doSaveLabel(starId, label, throbberControl, $star);
                };
                var __removeStar = function () {
                    doRemoveStar(starId, throbberControl);
                };
                showStarDialog(dialogControl, __updateLabel, __removeStar, resp.payload);
            } else {
                //resp.worked is false, reset the star to an off star.
                turnOffStar(starId);
            }
            throbberControl.stop();
        };
        throbberControl.start();
        // get the label for this Star, to supply it to the dialog
        AJS.$.post(FECRU.pageContext + "/json/profile/getStarLabelAjax.do", {id: starId}, onSuccess, 'json');
    }

    function turnOffStar(starId) {
        allStars(ON_ONLY).each(function () {
            var id = getStarId(this);
            if (starId == id) {
                // represents the same star
                getIdElement(this).remove();
                var $node = AJS.$(this);
                setStarAttributes(false, $node);
            }
        });
    }

    /**
     * Send a new label value to the server.
     * @param id the id of the Star who's label has been changed
     * @param label a String holding the new label text
     */
    function doSaveLabel(id, label, throbberControl, $star) {
        var onDone = function (rsp) {
            if ($star && $star.find('[name=id]')) {
                var starId = $star.find('[name=id]').val();
                AJS.$('#star-label-' + starId).html(rsp.name);
            }
            throbberControl.stop();
        };
        throbberControl.start();
        AJS.$.post(FECRU.pageContext + "/json/profile/setStarLabelAjax.do", {id: id, label: label}, onDone, 'json');
    }

    /**
     * Unstar the star with the given id.
     *
     * @param id the id of the Star to unstar.
     */
    function doRemoveStar(id, throbberControl) {
        throbberControl.start();
        doStar(FECRU.pageContext + "/json/profile/removeStarAjax.do", {id: id}, function () {
            turnOffStar(id);
            throbberControl.stop();
        });
    }

    /**
     * Change the state of a set of stars, and refresh the 'my stars' dropdown.
     * @param url the URL to inform the server about the change
     * @param updateStars the function to call to change the state of the stars in the browser
     */
    function doStar(url, params, updateStars) {
        var done = function (resp) {
            if (resp.worked) {
                updateStars(resp.id);
                return true;
            }
        };
        FECRU.AJAX.ajaxDo(url, params, done, false);
    }

    //todo: use AUI inline dialog
    function createStarDialog(dialogHider) {
        var $dialog = AJS.$(DIALOG_HTML);
        //intialize the dialog buttons
        AJS.$("#close-astronomy", $dialog).click(function (e) {
            dialogHider && dialogHider();
            e.preventDefault();
        });

        var $starLabel = AJS.$("#star-labels", $dialog);

        $starLabel.keypress(function (e) {
            if ((e.which || e.keyCode) === AJS.$.ui.keyCode.ENTER) {// if return is clicked
                e.preventDefault();
                AJS.$("#save-star-label", $dialog).trigger('click');
            }
        }).attr("autocomplete", "off");

        return $dialog;
    }

    function showStarDialog(dialogController, updateLabel, removeStar, currentLabel) {
        var $dialog = dialogController.getDialog();
        var $starLabel = AJS.$("#star-labels", $dialog);

        if (currentLabel) {
            $starLabel.val(currentLabel).data("defaultValue", currentLabel).addClass("focussed");
        } else {
            $starLabel.val('').data("defaultValue", "");
        }

        AJS.$("#remove-astronomy", $dialog).unbind().click(function (e) {
            e.preventDefault();
            removeStar();
            dialogController.hideDialog();
            $starLabel.val(DIALOG_DEFAULT).removeClass("focussed");
        });

        AJS.$("#save-star-label", $dialog).unbind().click(function (e) {
            e.preventDefault();
            var newLabel = $starLabel.val();
            if (newLabel == 'Describe your favourite') {
                newLabel = '';
            }
            if (newLabel !== $starLabel.data("defaultValue")) {
                $starLabel.data("defaultValue", newLabel);
                updateLabel(newLabel);
            }
            dialogController.hideDialog();
        });
        dialogController.showDialog();
    }

    function isDialogShown(starLink) {
        return starLink.hasClass("showDialog");
    }

    /**
     * bind a live click event to the stars.
     */
    function bindStars() {
        var $dialog = undefined; //stores a reference to the jquery elmem
        var dialogHider = undefined;
        var PADDING = 5;
        var hoverOptions = {
            onHover: false,
            showArrow: true,
            fadeTime: 200,
            hideDelay: null,
            showDelay: 0,
            width: 240 + PADDING,
            offsetX: -8, //to get the arrow centred at the star's vertical asix
            offsetY: 4,
            container: "body",
            useLiveEvents: true,
            cacheContent: false,
            initCallback: function () {
                //implementation note: we need a way to hide the dialog on demand - this callback has a hook into
                //the hide function that inline-dialog uses internally, so this is saving a reference to that function
                //for use later.
                var that = this;
                dialogHider = function () {
                    that.hide();
                };
            }
        };
        var onStarClickedHandler = function ($contentDiv, trigger, showPopup) {
            var $link = AJS.$(trigger);
            var dialogControl = {
                showDialog: function () {
                    if (isDialogShown($link)) {
                        if ($dialog === undefined) {
                            $dialog = createStarDialog(this.hideDialog);
                        }
                        $dialog.appendTo($contentDiv).show();
                        var $starLabels = AJS.$("#star-labels");
                        $starLabels.placeholder('Describe your favourite');
                        showPopup();
                    }
                },
                hideDialog: function () {
                    dialogHider && dialogHider();
                },
                getDialog: function () {
                    if ($dialog === undefined) {
                        $dialog = createStarDialog(this.hideDialog);
                    }
                    return $dialog;
                }
            };
            var opts = {
                throbberSetting: {
                    showThrob: true,         //todo: customizable throbbing needed?
                    noLatencyThreshold: 150, //if the ajax call takes less than this milliseconds, then no throb shown
                    minThrobberDisplay: 200  //otherwise, show for at least this milliseconds.
                }
            };
            starClicked(trigger, dialogControl, opts);
        };
        AJS.InlineDialog(".starrable.showDialog", "star-inline-dialog", onStarClickedHandler, hoverOptions);
        AJS.$(document).delegate('.starrable:not(.showDialog)', 'click', function () {
            onStarClickedHandler(null, this, null);
        });
    }

    ////// onload events for stars
    AJS.toInit(function () {
        bindStars();
    });
})();
/*[{!star_js_v63d549!}]*/