/*eslint eqeqeq:0*/

(function ($) {
    var shareDialog;
    var userAutocomplete;
    var dialogOptions = {
        width: 280,
        offsetY: 10,
        offsetX: -40,
        hideDelay: 36e5,
        hideCallback: function () {
            userAutocomplete.trigger("unautocomplete");
        }
    };
    var initialised;
    var $note;
    var $input;

    var $html = $('html');
    var generatePopup = function ($contents, trigger, doShowPopup) {

        var $shareLink = AJS.$("#share-content-link");
        var contentType = $shareLink.attr("data-content-type");
        var prepopulated = false;

        // hide popup hooks
        var doHidePopup = function () {
            shareDialog.hide();
            return false;
        };

        if (!initialised) {
            $contents.empty();

            // load template
            $contents.append(AJS.template.load("share-content-popup").fill());

            AJS.$(document).bind("showLayer", function (e, type, dialog) {
                if (type == "inlineDialog" && dialog.popup == shareDialog && !$html.is('.msie')) {
                    // if we have pre-populated, we should also auto-focus the send button
                    prepopulated ? dialog.popup.find("#share-submit-button").focus() :
                        dialog.popup.find("#share-user-input").focus();
                }
            });
            initialised = true;

            $('#share-submit-button').click(function () {
                var $t = $(this);
                var $form = $t.closest('form');
                if ($t.not('[aria-disabled="true"]')) {
                    $form.submit();
                }
            });

            $note = $contents.find("#share-dialog-note");
            $note.elastic();
            $note.placeholder();

            $input = $contents.find("#share-user-input");
            $input.placeholder();

            //on keypress of enter in user dialog, do not submit form
            $input.keypress(function (e) {
                if (e.keyCode === 13) {
                    return false;
                }
                return true;
            }).bind("autocomplete-data-received", function (event, result) {
                if (!$input.is(":focus")) {
                    // if input has lost focus, and there is only one result, and the result is for the same query as was
                    // submitted, pick it
                    if (result.data.length === 1 && $input.val() == result.data[0].query) {
                        onUserSelected($input, result.data[0].data);
                    }
                }
            });

            $contents.find(".close-dialog").click(doHidePopup);
        }

        //close the share dialog if the escape key is pressed
        $(document).keyup(function (e) {
            if (e.keyCode === 27) {
                doHidePopup();
                $(document).unbind("keyup", arguments.callee); // eslint-disable-line no-caller
                return false;
            }
            return true;
        });


        var $shareButton = $contents.find("#share-submit-button");
        var shareTooltip = 'Select a user from the drop down to share with.';
        $shareButton.attr('title', shareTooltip);

        //this function is called when a user is clicked or enter is pressed in the autocomplete
        var onUserSelected = function ($input, user) {
            var $recipients;
            var $item;
            var recipientSelector;

            recipientSelector = "li[data-" + user.type + "=\"" + (user.type == "email" ? user.email : user.id) + "\"]";
            $recipients = $contents.find(".recipients");
            $item = $recipients.find(recipientSelector);

            if ($item.length > 0) {
                $item.hide();
            } else {
                user.context = AJS.contextPath();
                $recipients.append(AJS.template.load("share-content-popup-recipient-" + user.type).fill(user));
            }

            $item = $recipients.find(recipientSelector);

            $item.find(".remove-recipient").click(function () {
                if ($input.is(":enabled")) {
                    $item.fadeOut(200, function () {
                        $item.remove();
                        if ($recipients.find("li").length === 0) {
                            $shareButton
                                .attr("aria-disabled", "true")
                                .attr('title', shareTooltip);
                        }
                    });

                    $input.focus();
                }
                return false;

            });

            AJS.$("#share-user-input").val("");

            $item.fadeIn(200);
            $shareButton.removeAttr("aria-disabled")
                .removeAttr('title');
        };

        $contents.find("form").unbind().submit(function () {

            var users = [];
            $contents.find(".recipients li[data-user]").each(function (index, item) {
                users.push($(item).attr("data-user"))
            });

            var emails = [];
            $contents.find(".recipients li[data-email]").each(function (index, item) {
                emails.push($(item).attr("data-email"))
            });

            if (users.length <= 0 && emails.length <= 0) {
                return false;
            }

            AJS.$("button,input,textarea", this).attr("disabled", "disabled");

            var $messages = $contents.find(".share-dialog-progress-messages");
            $messages.text(AJS.I18n.getText("Sending"))
                .removeClass('error')
                .addClass('sending');

            var request = {
                users: users,
                emails: emails,
                note: $note.val(),
                type: contentType,
                entity1: shareEntity1,
                entity2: shareEntity2,
                url: window.location.href
            };
            AJS.$.ajax({
                type: "POST",
                contentType: "application/json; charset=utf-8",
                url: AJS.contextPath() + "/rest-service-fecru/share-content-v1/share",
                data: JSON.stringify(request),
                dataType: "text",
                success: function () {
                    initialised = false;
                    setTimeout(function () {
                        $messages.removeClass("sending")
                            .addClass("done")
                            .text("Sent");
                        setTimeout(function () {
                            doHidePopup();
                        }, 1000);
                    }, 500);
                },
                error: function (data, status) {
                    $shareButton.removeAttr("disabled");
                    $messages.removeClass("sending")
                        .addClass("error")
                        .text("Error while sending");
                }
            });

            return false;

        });

        //bind the user <input> field to a fecru autocomplete

        var opts = {
            result: onUserSelected,
            searchOnFocus: false,
            url: AJS.contextPath() + "/json/fe/activeUserFinder.do?includeQueryAsEmail=true",
            id: "share-user-input",
            inputId: "share-user-input",
            resultsClass: "ac_results share-user-input aui-box-shadow",
            notFoundData: [{
                displayPrimary: "No matching user or email found",
                disabled: true,
                extraClass: "no-results"
            }],
            errorData: [{
                displayPrimary: "A communication error occurred",
                disabled: true,
                extraClass: "no-results"
            }]
        };
        var $input = AJS.$("#share-user-input");
        userAutocomplete = $input.fecruAutocomplete(opts);

        var blockers = [];
        if (contentType === 'review' && window.review && review.isOverdue()) {
            // we need to prepopulate some stuff:
            //   * incomplete reviewers
            //   * some reminder text
            blockers = review.getBlockers();
            var currentUserId = review.getLoggedInUser().getUserName();
            for (var i = 0; i < blockers.length; i++) {
                if (blockers[i].id === currentUserId) {
                    // dont add the current user as a recipient
                    blockers.splice(i, 1);
                    break;
                }
            }

            if (blockers.length) {
                for (i = 0; i < blockers.length; i++) {
                    onUserSelected($input, blockers[i]);
                }
                var isAuthorOrModerator = false;
                if (blockers.length === 1 &&
                    ((review.getModerator() && review.getModerator().getUserName() === blockers[0].id) ||
                    review.getAuthor().getUserName() === blockers[0].id)) {
                    isAuthorOrModerator = true;
                }
                var reminderText = 'Please ' + (isAuthorOrModerator ? 'finalize' : 'complete') + ' this review as soon as possible, as it is overdue.';
                $note.val(reminderText);

                prepopulated = true;
            }
        }


        doShowPopup();
    };


    AJS.ShareDialog = {
        init: function () {
            initialised = false;
            shareDialog && shareDialog.remove();
            shareDialog = AJS.InlineDialog($("#share-content-link"), "shareContentPopup", generatePopup, dialogOptions);
        }
    }

    AJS.toInit(AJS.ShareDialog.init);
})(AJS.$);
/*[{!share_dialog_js_6ac5547!}]*/