window.FECRU = window.FECRU || {};

FECRU.SELECTIONHISTORY = FECRU.SELECTIONHISTORY || {};

(function ($) {

    $(document).ready(function (e) {

        FECRU.SELECTIONHISTORY.displayDiff = function (revId, iframeheight) {
            var $iframeHolder = AJS.$('#iframe-holder');

            if (AJS.$('html').hasClass('safari')) {
                $iframeHolder.children().css('display', 'none');
            } else {
                $iframeHolder.children().css('visibility', 'hidden');
            }

            $iframeHolder.children('.aui-message').remove();
            var $iframe = $iframeHolder.children('#diff-' + revId);

            var $row = AJS.$('#revision-selection #rev-' + revId);
            var match = $row.data('match');
            var diff = $row.data('diff');
            var url = $row.find('.iframe-url').text().trim();

            var messageHeight = 0;
            if (!match) {
                // we need to display a message
                AJS.messages.warning($iframeHolder, {
                    id: "reselect-warning",
                    insert: "prepend",
                    title: "Time to rescope the search!",
                    body: "We've gone back so far that the lines have become a bit blurry. If you still haven't found what you're after, select the relevant lines from this revision."
                });
                messageHeight = $iframeHolder.children('.aui-message').outerHeight() + 20;
            } else if (!diff) {
                AJS.messages.info($iframeHolder, {
                    id: "reselect-warning",
                    insert: "prepend",
                    title: "We've hit the end!",
                    body: "This is the initial revision of this file. If you still haven't found what you're after, it may have come from a cross-file refactor. Have a look at the commit."
                });
                messageHeight = $iframeHolder.children('.aui-message').outerHeight() + 20;
            }

            if (!$iframe.length) {
                // we need to insert it
                //.attr('src', AJS.$(this).children('span').text());
                $iframeHolder.append(AJS.$('<iframe id="diff-' + revId + '" width="100%" height="' + (iframeheight - 101 - messageHeight) + 'px" src="' + url + '"></iframe>'))
            }

            if (AJS.$('html').hasClass('safari')) {
                $iframe.css('display', 'block');
            } else {
                $iframe.css('visibility', 'visible');
            }

        };

        if (!FECRU.isSelectionHistoryEnabled) {
            return;
        }

        if ($.browser.msie && $.browser.version.substring(0, 2) === '8.') {
            return; // don't support IE8 because it cant easily provide us with the selected lines
        }

        $('body').append('<div id="copy-clipboard">' +
            '<span id="clipboard-container">' +
            '<div id="clipboard-button">Copy</div>' +
            '</span>' +
            '<span id="super-blame">' +
            '<div id="blame-button">Blame</div>' +
            '</span>' +
            '</div>');

        ZeroClipboard.setDefaults({
            moviePath: FECRU.pageContext + '/' + FECRU.staticDirectory + '/2static/flash/ZeroClipboard-1.2.1.swf',
            hoverClass: 'zeroclipboard-is-hover',
            activeClass: "zeroclipboard-is-active"
        });
        var $clipboardButton = AJS.$('#clipboard-button');
        var clipboard = new ZeroClipboard($clipboardButton);

        clipboard.on('noflash', function () {
            $clipboardButton.addClass('hide');
        });
        clipboard.on('wrongflash', function () {
            $clipboardButton.addClass('hide');
        });
        clipboard.on('mouseup', function () {
            AJS.$("#copy-clipboard").css("left", "-999px");
        });

        $(document).delegate("body", "keyup", function (e) {
            if (e.keyCode === 27) {
                $("#copy-clipboard").hide();
            }
        });

        // fancy renderer
        $(document).delegate(".diff-container", "mouseup", function (e) {
            var nodes = getSelectedNodes(e);
            if (!nodes) {
                return true
            }

            var anchorLine = getLineNumberFancyRenderer(nodes.anchorNode);
            var focusLine = getLineNumberFancyRenderer(nodes.focusNode);

            var $diffContentBox = $(nodes.anchorNode).closest('.content-box');

            selectLines(e, anchorLine, focusLine, $diffContentBox.data('path'), $diffContentBox.data('revision'));

            return true;
        });

        // unified diff (single file + changeset)
        $(document).delegate(".annPane.view-diff, .changeset-page #panel-target", "mouseup", function (e) {
            var nodes = getSelectedNodes(e);
            if (!nodes) {
                return true
            }

            var anchorLine = getLineNumberForUnifiedDiff(nodes.anchorNode);
            var focusLine = getLineNumberForUnifiedDiff(nodes.focusNode);

            var $diffTable = $(nodes.anchorNode).closest('table.diff');

            selectLines(e, anchorLine, focusLine, $diffTable.data('path'), $diffTable.data('revision'));

            return true;
        });

        var selectLines = function (e, anchorLine, focusLine, path, revision) {
            var lowestLine = anchorLine < focusLine ? anchorLine : focusLine;
            var highestLine = anchorLine >= focusLine ? anchorLine : focusLine;

            var $copyClipboard = $("#copy-clipboard");
            $copyClipboard.show();
            $copyClipboard.css({
                top: e.pageY + 8,
                left: e.pageX + 8
            });
            $("#blame-button").data('lowLine', lowestLine)
                .data('highLine', highestLine)
                .data('path', path)
                .data('revision', revision);
        };

        window.top.FE.BLAME = window.top.FE.BLAME || {};

        AJS.$('#blame-button').click(function () {
            var $this = $(this);
            var highLine = $this.data('highLine');
            var lowLine = $this.data('lowLine');
            var path = $this.data('path');
            var revision = $this.data('revision');

            var url = FECRU.pageContext + '/line-history/' + window.top.FECRU.INFO.repoName + '/' + path + '?r=' + revision;
            url += '&from=' + lowLine + '&to=' + highLine;

            if (!window.top.FE.BLAME.$dialog) {
                window.top.FE.BLAME.$dialog = window.top.FECRU.DIALOG.ajaxDialog(1280, 768, {}, "super-blame");
                var iframeHeight = window.top.FE.BLAME.$dialog.height - 109;
                window.top.FE.BLAME.$dialog
                    .addHeader("Selection history for revision '" + revision + "' at lines " + lowLine + " to " + highLine)
                    .addPanel("Super Blame", "<div id='" + 'blame-panel' + "'></div>")
                    .addButton("Close", function (d) {
                        d.hide();
                    }, "cancelButton");
                window.top.AJS.$('#blame-panel').append(buildIframe(iframeHeight, url));
            } else {
                window.top.FE.BLAME.$dialog.addHeader("Selection history for revision '" + revision + "' at lines " + lowLine + " to " + highLine);
                iframeHeight = window.top.FE.BLAME.$dialog.height - 109;
                window.top.AJS.$('.selection-history-frame').remove();
                window.top.AJS.$('#blame-panel').append(buildIframe(iframeHeight, url));
            }
            window.top.FE.BLAME.$dialog.show();

            $("#copy-clipboard").hide();
        });

        var buildIframe = function (height, url) {
            return $("<iframe class='selection-history-frame' width='100%' height='" + height + "px' src='" + url + "&iframeHeight=" + height + "'/>");
        };

        var getLineNumberForUnifiedDiff = function (node) {
            var $row = $(node).closest('tr');
            var $commonLineNumbers = $row.children('.diffLineNumbers');
            var $toLineNumbers = $row.children('.diffLineNumbersB');
            var $fromLineNumbers = $row.children('.diffLineNumbersA');
            if ($commonLineNumbers.length) {
                return parseInt($($commonLineNumbers.get(0)).text(), 10);
            } else if ($toLineNumbers.length) {
                return parseInt($($toLineNumbers.get(1)).text(), 10);
            } else if ($fromLineNumbers.length) {
                return parseInt($($fromLineNumbers.get(0)).data("to-equiv"), 10);
            }
            return null;
        };

        var getLineNumberFancyRenderer = function (node) {
            var $row = $(node).closest('pre');
            return parseInt($row.children('.line-num').attr('title'), 10);
        };

        var getSelectedNodes = function (e) {
            var selection = window.getSelection();
            if (selection.anchorNode == null ||
                $(e.target).attr('id') === 'blame-button') {
                return null;
            }

            return {
                anchorNode: selection.anchorNode,
                focusNode: selection.focusNode
            }
        };

    });

})(AJS.$);
/*[{!selection_history_js_de2a546!}]*/