/*eslint eqeqeq:0*/

window.FECRU = window.FECRU || {};

FECRU.SEARCH = (function ($, History) {
    var resultCounts = {}; // result counts for the given query for different search types
    var searchParams = {}; // current search params (query, sort, type, repo, project), used to build the queries
    var stats = {}; // the search stats (time, result counts, pagination data)

    var pushingState = true;
    var applyingState = false;

    var allPlaceholder = '$$ALL$$';

    // TypeCounts for the effect for result counts
    var TypeCount = function (opts, list) {
        $.extend(this, opts);
    };

    $.extend(TypeCount, {
        createList: function (types) {
            var list = {};
            _.each(types, function (t) {
                list[t.type] = new TypeCount({
                    type: t.type,
                    $el: t.$el
                });
            });

            return {
                ellipsis: function () {
                    _.each(list, function (c) {
                        c.ellipsis();
                    })
                },
                setCounts: function (counts) {
                    var t = this;
                    _.each(counts, function (count, type) {
                        t.setCount(type, count);
                    })
                },
                setCount: function (type, count) {
                    list[type].setCount(count);
                },
                hide: function () {
                    _.each(list, function (c) {
                        c.hide();
                    })
                }
            }
        }
    });
    TypeCount.prototype = {
        defaultOpts: {}, // may not be used
        ellipsis: function () {
            var t = this;

            t.$el
                .attr('data-count', '.')
                .children('.after')
                .css({display: 'none'});
            t.$el.children('.before')
                .css({display: 'inline', opacity: 1})
        },
        setCount: function (count) {
            var t = this;

            if (t.$el.children('.after').css('display') !== 'none') {
                return;
            }

            var $before = t.$el
                .attr('data-count', count)
                .children('.before');
            $before.animate({opacity: 0}, 250, function () {
                $before.hide();

                t.$el.children('.after')
                    .html(count)
                    .css({opacity: 0, display: 'inline'})
                    .animate({opacity: 1}, 250);
            });
        },
        hide: function () {
            this.$el.removeAttr('data-count');
        }
    };

    function setupUserAutocomplete() {
        var onUserSelected = function ($input, data) {
            changeUser(data.id, data.displayPrimary);
        };

        var opts = {
            result: onUserSelected,
            searchOnFocus: false,
            url: AJS.contextPath() + "/json/fe/activeUserFinder.do?includeQueryAsEmail=true&allowEmpty=true",
            resultsClass: "ac_results aui-box-shadow",
            notFoundData: [
                {
                    displayPrimary: "No matching user or email found",
                    disabled: true,
                    extraClass: "no-results"
                }
            ]
        };
        var $input = $("#user-filter");

        $input.fecruAutocomplete(opts);
        $input.on('change', function (event, ui) {
            if (!$(this).val()) {
                delete FECRU.SEARCH.searchParams.userFilter;
            }
        });
    }

    var init = function () {
        History.Adapter.bind(window, 'statechange', function () {
            if (!FECRU.SEARCH.pushingState) {
                FECRU.SEARCH.applyingState = true;
                var state = History.getState();
                FECRU.SEARCH.searchParams = parseStateUrl(state.url);
                loadInitialResults(true, true);
                FECRU.SEARCH.applyingState = false;
            }
        });

        FECRU.SEARCH.defaultRepo = $('.advanced-search-link').data('default-repository');
        setupUserAutocomplete();
        $("#search-form").submit(function () {
            submit();
            return false;
        });
        $('#user-form').submit(function () {
            submit();
            return false;
        });

        setupPathAbbreviation();

        // ensure that the search box starts with the focus
        $("#search-input").focus();

        $('.search-results')
            .on('click', '.expand-search>a', function (e) { // handle expanding search
                e.preventDefault();
                changeProject('', true);
                changeRepository('', true);
                loadInitialResults(true);
            })
            .find('.quicksearch-type-switch').on('click', function (e) { // handle switching type (either via the buttons on the left or the 'no results' page)
                e.preventDefault();
                e.stopPropagation();
                var searchType = $(this).data('type');
                changeType(searchType);
            });

        $('#quicksearch-pane').on('click', '.redo-ignore-repo-limit', function (e) {
            FECRU.SEARCH.searchParams.ignoreReposLimit = true;
            loadInitialResults(false);
        });

        $('.quicksearch-sortorder-switch').click(function (e) { // handle switching sort
            e.preventDefault();
            var sortOrder = parseInt($(this).data('sort'));
            changeSort(sortOrder);
        });

        $('.quicksearch-timebucket-switch').click(function (e) {
            e.preventDefault();
            if (!$('.search-sidebar-timebuckets').hasClass('disabled')) {
                var timeBucket = $(this).data('time-bucket');
                changeTimeBucket(timeBucket);
            }
        });
    };

    var submit = function () {
        FECRU.SEARCH.searchParams.q = $('#search-input').val();
        return loadInitialResults(true);
    };

    // handles the user filter being changed, if donReload is true just refreshes the UI, without fethching new results
    var changeUser = function (user, displayName, dontReload) {
        if (!user) {
            displayName = '';
        }

        if (displayName != null) {
            $('#user-filter').val(displayName);
        }

        FECRU.SEARCH.searchParams.userFilter = user;
        if (!dontReload) {
            loadInitialResults(true);
        }
    };

    // handles the search type being changed - if dontReload is true just handle the ux part, without fetching new results
    var changeType = function (type, dontReload) {
        $('.search-sidebar-types .aui-nav-selected').removeClass('aui-nav-selected');
        $('.search-sidebar-list>li.type-' + type).addClass('aui-nav-selected');

        // hacky - hide date sort and filters for commiter search (SearchType.COMMITTERS)
        var $dateSort = $('.quicksearch-sortorder-switch[data-sort="0"]');
        var $lastModifiedFilter = $('.search-sidebar-timebuckets');
        var $userFilter = $('.search-sidebar-user');
        var $userAutocomplete = $('#user-filter');

        var $userTooltip = $('.search-sidebar-user-tooltip')
        if (type == 0 || type == 2 || type == 3 || type == 4) {
            $userFilter.addClass('disabled');
            $userAutocomplete.attr('disabled', 'disabled');
            $userTooltip.attr('title', 'The user filter is not available for the selected search type');
        } else {
            $userFilter.removeClass('disabled');
            $userAutocomplete.removeAttr('disabled');
            $userTooltip.removeAttr('title');
        }

        var $timebucketTooltip = $('.search-sidebar-timebuckets-tooltip');
        if (type == 4) {
            $dateSort.hide();
            $lastModifiedFilter.addClass('disabled');
            $timebucketTooltip.attr('title', 'The last modified filter is not available for the selected search type');
        } else {
            $dateSort.show();
            $lastModifiedFilter.removeClass('disabled');
            $timebucketTooltip.removeAttr('title');
        }

        FECRU.SEARCH.searchParams.t = type;
        if (!dontReload) {
            loadInitialResults(false);
        }
    };

    // replaces the current results with the ones for the given search type - if dontReload is true just handle the ux part, without fetching new results
    var changeSort = function (sortOrder, dontReload) {
        $('.qsearch-sort-order .aui-nav-selected').removeClass('aui-nav-selected');
        $('#sort-order-' + sortOrder).parent().addClass('aui-nav-selected');
        FECRU.SEARCH.searchParams.s = sortOrder;
        if (!dontReload) {
            loadInitialResults(false);
        }
    };

    var changeTimeBucket = function (timeBucket, dontReload) {
        $('.search-sidebar-timebuckets .aui-nav-selected').removeClass('aui-nav-selected');
        $('#time-bucket-' + timeBucket).parent().addClass('aui-nav-selected');
        FECRU.SEARCH.searchParams.bucket = timeBucket;
        if (!dontReload) {
            loadInitialResults(true);
        }
    };

    // cleans up the input from the autocomplete dropdowns
    var unifyAutoCompleteInput = function (input) {
        if (input && input.disabled) {
            return null;
        }

        if (input && input.id) {
            return input.id == allPlaceholder ? '' : input.id;
        }

        return input ? input : '';
    };

    // handles the repository being changed
    var changeRepository = function (repository, dontReload) {
        repository = unifyAutoCompleteInput(repository);
        if (repository === null) {
            return;
        }

        $('#repository-input').val(repository);
        FECRU.SEARCH.searchParams.repository = repository;

        var $advancedSearchLink = $('.advanced-search-link');
        if (repository || FECRU.SEARCH.defaultRepo) {
            $advancedSearchLink.attr('href', AJS.contextPath() + '/search/' + encodeURIComponent(repository ? repository : FECRU.SEARCH.defaultRepo));
            $advancedSearchLink.show();
        } else {
            $advancedSearchLink.hide();
        }

        var $currentRepoHeader = $('.source-dropdown-current');
        if (repository) {
            // hacky - updates the masthead
            $currentRepoHeader.find('input[name="currentRepositoryName"]').attr('value', repository);
            var $currentRepoLink = $currentRepoHeader.find('a');
            $currentRepoLink.attr('href', AJS.contextPath() + '/changelog/' + encodeURIComponent(repository));
            $currentRepoLink.attr('title', repository);
            $currentRepoLink.text(repository);

            $currentRepoHeader.show();
        } else {
            $currentRepoHeader.hide();
        }

        if (!dontReload) {
            delete FECRU.SEARCH.searchParams.project;
            $('#project-input').val('');
            loadInitialResults(true);
        }
    };

    // handles the project being changed
    var changeProject = function (project, dontReload) {
        project = unifyAutoCompleteInput(project);
        if (project === null) {
            return;
        }

        $('#project-input').val(project);
        FECRU.SEARCH.searchParams.project = project;

        if (!dontReload) {
            delete FECRU.SEARCH.searchParams.repository;
            $('#repository-input').val('');
            loadInitialResults(true);
        }
    };

    // abbreviates the shown paths, either on the whole page, or in $context
    var triggerPathAbbreviation = function (hint, $context) {
        if (FECRU.SEARCH.searchParams.t !== 0) {
            return;
        }

        var $paths = $(".file-path", $context ? $context : $("#search-results"));
        var $repoNames = $paths.parent().siblings('.repo-name');
        var maxRepoNameWidth = 0;

        $repoNames.each(function () {
            maxRepoNameWidth = Math.max(maxRepoNameWidth, $(this).width());
        });

        $paths.abbreviatePath({
            boundingWidthGetter: function ($this) {
                return $this.closest('li').width() - maxRepoNameWidth;
            },
            growingElementGetter: function ($this) {
                return $this.parent() /*span.abbreviate-path-grower*/;
            },
            directionHint: hint,
            resetBoundsWidth: true
        });
    };

    // adds a resize handler to perform path abbreviation if needed
    var setupPathAbbreviation = function () {
        //on resize
        var $window = $(window);
        var windowWidth = $window.width();

        FECRU.UI.setCompletedResizeTimeout($window, function () {
            var newWindowWidth = $window.width();
            var shouldRun = windowWidth !== newWindowWidth;
            var hint = windowWidth < newWindowWidth ? 'larger' : 'smaller';

            windowWidth = newWindowWidth;
            if (shouldRun) {
                triggerPathAbbreviation(hint);
            }
        }, 150);
    };

    // called after initial page load/refresh
    var lazyLoad = function (initialState) {
        FECRU.SEARCH.searchParams = parseStateUrl(History.getState().url); // get the proper params
        if (initialState && _.isEmpty(FECRU.SEARCH.searchParams)) {
            FECRU.SEARCH.searchParams = initialState;
        }
        loadInitialResults(true, true);
    };

    // saves the current url in history, so we can navigate to it
    var pushState = function (queryUrl, replace) {
        if (!FECRU.SEARCH.applyingState) {
            FECRU.SEARCH.pushingState = true;
            if (replace) {
                History.replaceState(null, null, queryUrl);
            } else {
                History.pushState(null, null, queryUrl);
            }
            FECRU.SEARCH.pushingState = false;
        }
    };


    /**
     * create the count list for setting counts for categories and a small animation when changing those
     * number.
     */
    var typeCounts;

    /**
     * Fetches the first page of the results, sets up subsequent searches and counts.
     * The first page should handle some additional metadata - search time, updating the ui if the server changed the query
     * @param queryChanged true if anything that'd affect the results has changed (query, repo, project)
     * @param initialLoad whether this is the first ever load
     * @return Sequence number of submitted request or false if request was not submitted
     */
    var requestSeq = 0;
    var loadInitialResults = function (queryChanged, initialLoad) {
        if (FECRU.SEARCH.forceQueryChanged) {
            delete FECRU.SEARCH.forceQueryChanged;
            queryChanged = true;
        }

        if (queryChanged) {
            delete FECRU.SEARCH.searchParams.ignoreReposLimit; // don't persist it across searches
        }

        var queryUrl = buildQueryUrl(FECRU.SEARCH.searchParams);

        pushState(queryUrl, initialLoad);

        if (initialLoad) {
            var types = $('.typecount').map(function () {
                var $t = $(this);
                return {
                    type: $t.data('type'),
                    $el: $t
                };
            });
            typeCounts = TypeCount.createList(types);
        }
        updatePageBeforeSearch(queryUrl, queryChanged);

        var seq = false;
        if (FECRU.SEARCH.searchParams.q !== undefined) {
            seq = ++requestSeq;
            // get the search results
            fetchResults(seq, queryUrl + '&resultsOnly=true', function (data) {
                if (seq != requestSeq) {
                    return;
                }

                FECRU.SEARCH.stats = data.stats;
                FECRU.SEARCH.searchParams.q = data.stats.query;

                updatePageAfterSearch(data, queryChanged);

                searchBlock.unblock();
                if (data.stats.numPages == data.stats.page) {
                    $('.activityLoading').hide();
                } else {
                    var loadMoreWhenScreenNotFull = function () {
                        if ($('.activityLoading').is(':in-viewport-vert(0)')) {
                            loadMoreResults(loadMoreWhenScreenNotFull);
                        }
                    };

                    loadMoreWhenScreenNotFull();
                }
            });

            if (queryChanged) {
                loadCounts(seq);
            }
        } else {
            FECRU.SEARCH.searchParams.q = '';
            FECRU.SEARCH.forceQueryChanged = true;
        }

        FECRU.SEARCH.loading = false;
        if (initialLoad) {
            FECRU.ACTIVITY.onScrollToBottom(function () {
                loadMoreResults();
            });
        }

        return seq;
    };

    var showSearchErrorMessages = function (messagesHtml) {
        $('.quicksearch-results').html('');
        $('.query-error-message').show();
        var $defaultMsg = $('.default-qsearch-error-message');
        var $serverMsg = $('.server-qsearch-error-messages');

        if (messagesHtml) {
            $defaultMsg.hide(0);
            $serverMsg.html(messagesHtml);
            $serverMsg.show(0);
        } else {
            $defaultMsg.show(0);
            $serverMsg.html('');
            $serverMsg.hide(0);
        }

        searchBlock.unblock();
        $('.activityLoading').hide();
    };

    // fetches the search results for the given url
    var fetchResults = function (seq, url, done) {
        $.getJSON(url + '&resultsOnly=true', {_nocache: new Date().getTime()}, function (result) {
            if (!result.worked) {
                showSearchErrorMessages(result.html);
            } else {
                done && done(result);
            }
            setResultsSeq(seq);
        }).fail(function (req, textStatus, errorThrown) {
            if (req.statusText !== 'abort') {
                showSearchErrorMessages();
                AJS.log('Error fetching results ' + textStatus + ' - ' + errorThrown);
            }
            setResultsSeq(seq);
        });
    };

    var setResultsSeq = function (seq) {
        if (seq == requestSeq) {
            $('#search-results').attr("seq", seq);
        }
    };

    var getResultsSeq = function () {
        return $('#search-results').attr("seq");
    };

    var updateInputs = function (query, sortOrdinal, typeOrdinal, timeBucket, user, userFilterDisplayName, repository) {
        $('#search-input').val(query);
        changeType(typeOrdinal, true);
        changeSort(sortOrdinal, true);
        changeTimeBucket(timeBucket, true);
        changeRepository(repository, true);
        changeUser(user, userFilterDisplayName, true);
    };

    // sets up the page ui after performing a search (based on results, stats) (see quicksearchresults.jsp)
    var updatePageAfterSearch = function updatePageAfterSearch(data, queryChanged) {
        updateInputs(data.stats.query, data.stats.sortOrdinal, data.stats.typeOrdinal, data.stats.timeBucket,
            data.stats.userFilter, data.stats.userFilterDisplayName, data.stats.repository);

        // results
        var $resultslist = $('.quicksearch-results');
        $resultslist.html(data.html);
        triggerPathAbbreviation(null, $resultslist);

        // counts
        typeCounts.setCount(data.stats.type, data.stats.count);

        if (data.stats.count > 0) {
            FECRU.SEARCH.resultCounts[data.stats.type] = data.stats.count;
        }

        $('#search-summary-text').html(
            AJS.template('<span id="total-count">{totalCount}</span> results for <strong>{query}</strong> <em>({time}s)</em>')
                .fill({
                    totalCount: FECRU.formatInt(getTotalResultCount()),
                    query: data.stats.query,
                    time: data.stats.time
                })
        );

        updateNoResultsMessage();

        // star
        if (data.stats.starrable) {
            var $star = $('.qs_star');
            if (queryChanged) {
                var $starLink = $('.qs_star>a');
                data.stats.starId ? $starLink.addClass('star-on').removeClass('star-off') : $starLink.removeClass('star-on').addClass('star-off');
                $star.find('input[name="stringKey1"]').attr('value', FECRU.SEARCH.searchParams.repository ? FECRU.SEARCH.searchParams.repository : '__ALL_REPOS__');
                $star.find('input[name="stringKey2"]').attr('value', FECRU.SEARCH.searchParams.q);
                $star.find('input[name="id"]').remove();
                if (data.stats.starId) {
                    $star.find('.inputs').append('<input class="starKey" type="hidden" name="id" value="' + data.stats.starId + '">')
                }
            }

            $star.show();
        }

        // repo limit
        if (data.stats.limitedRepos) {
            var $limitedRepos = $('.limited-repos-message');
            $limitedRepos.html(
                AJS.template.load('limited-repos-message').fill({limitedRepos: data.stats.limitedRepos})
            );
            $limitedRepos.show();
        }
    };

    var getTotalResultCount = function () {
        var totalCount = 0;
        for (var type in FECRU.SEARCH.resultCounts) {
            if (FECRU.SEARCH.resultCounts.hasOwnProperty(type)) {
                totalCount += FECRU.SEARCH.resultCounts[type];
            }
        }
        return totalCount;
    };

    // sets up the page ui before performing a search (based on searchParams)
    var updatePageBeforeSearch = function (queryUrl, queryChanged) {
        updateInputs(FECRU.SEARCH.searchParams.q, FECRU.SEARCH.searchParams.s, FECRU.SEARCH.searchParams.t, FECRU.SEARCH.searchParams.bucket,
            FECRU.SEARCH.searchParams.userFilter, null, FECRU.SEARCH.searchParams.repository);

        $('.qs_star').hide();
        $('.query-error-message').hide();
        var $permalink = $('a.permalink');
        var $doc = $(document);
        if (FECRU.SEARCH.searchParams.q === undefined) {
            $doc.attr('title', 'Search');
            searchBlock.unblock();
            $('.activityLoading').hide();
            $('.count').parent().hide();
            $('.empty-query-message').show();

            $('.quicksearch-results').empty();
            $permalink.hide();
            $('#search-summary-text').html('');
        } else {
            $doc.attr('title', 'Search' + (FECRU.SEARCH.searchParams.q ? ' - "' + FECRU.SEARCH.searchParams.q + '"' : ''));
            searchBlock.block();
            $('.activityLoading').show();
            $('.empty-query-message').hide();
            $permalink.attr('href', queryUrl);
            $permalink.show();
        }

        // update the links
        $('.quicksearch-type-switch').each(function () {
            $(this).attr('href', buildQueryUrl($.extend({}, FECRU.SEARCH.searchParams, {t: $(this).data('type')})));
        });
        $('.quicksearch-sortorder-switch').each(function () {
            $(this).attr('href', buildQueryUrl($.extend({}, FECRU.SEARCH.searchParams, {s: $(this).data('sort')})));
        });
        $('.quicksearch-timebucket-switch').each(function () {
            $(this).attr('href', buildQueryUrl($.extend({}, FECRU.SEARCH.searchParams, {bucket: $(this).data('time-bucket')})));
        });

        $('.limited-repos-message').hide();

        // reset counts if needed
        if (queryChanged && FECRU.SEARCH.searchParams.q !== undefined) {
            FECRU.SEARCH.resultCounts = {};
            typeCounts.ellipsis();
        } else if (FECRU.SEARCH.searchParams.q === undefined) {
            FECRU.SEARCH.resultCounts = {};
            typeCounts.hide();
        }

        FECRU.SEARCH.stats = {};
    };

    // build a searchParams object from a string url
    var parseStateUrl = function (url) {
        var context = AJS.contextPath() + '/qsearch';
        var contextIndex = url.indexOf(context);
        if (contextIndex >= 0) {
            var afterContext = url.substring(contextIndex).substring(context.length);
            if (afterContext) {
                var queryIndex = afterContext.indexOf('?');
                if (queryIndex >= 0) {
                    var path = afterContext.substring(0, queryIndex);
                    var repository = path.split('/').join('');
                    var query = afterContext.substring(queryIndex + 1);
                } else {
                    var repository = afterContext.split('/').join('');
                }
            }
        }

        var queryParams = {};
        if (query) {
            query = query.split('+').join('%20'); // $.deserialize doesn't handle spaces encoded as '+', instead of '%20', which is what the quicknav form does
            queryParams = $.deserialize(query)
        }
        return $.extend(queryParams, repository ? {repository: repository} : {});
    };

    // build a query url from the current searchParams object
    var buildQueryUrl = function (searchParams) {
        var url = AJS.contextPath() + '/qsearch';
        var queryParams = $.extend({}, searchParams);

        if (searchParams.repository) {
            url += '/' + encodeURIComponent(searchParams.repository);
        }
        delete queryParams['repository']; // repository is handle above as a part of the path
        delete queryParams['r']; // QuickSearch.enableRedirection - should only be enabled for the initial request from quicknav

        var query = $.param(queryParams);

        return query ? url + '?' + query : url;
    };

    // loads a next page of results
    var loadMoreResults = function (done) {
        if (!$.isEmptyObject(FECRU.SEARCH.stats) && !FECRU.SEARCH.loading && !$('.query-error-message').is(':visible')) {
            FECRU.SEARCH.loading = true;
            var currentPage = parseInt(FECRU.SEARCH.stats.page);
            var numPages = parseInt(FECRU.SEARCH.stats.numPages);
            if (currentPage < numPages) {
                fetchResults(requestSeq, buildQueryUrl(FECRU.SEARCH.searchParams) + '&page=' + (currentPage + 1), function (data) {
                    var $additionalResults = $(data.html).find('.quicksearch-result-list > li');
                    $('.quicksearch-result-list').append($additionalResults);
                    triggerPathAbbreviation(null, $additionalResults);
                    FECRU.SEARCH.stats = data.stats;
                    FECRU.SEARCH.resultCounts[data.stats.type] = data.stats.count;

                    FECRU.SEARCH.loading = false;
                    done && done();
                });
            } else {
                $('.activityLoading').hide();
                FECRU.SEARCH.loading = false;
            }
        }
    };

    // fire-off AJAX to get counts
    var loadCounts = function loadCounts(seq) {
        $.getJSON(buildQueryUrl(FECRU.SEARCH.searchParams) + '&countsOnly=true',
            {_nocache: new Date().getTime()}, function (data) {
                if (seq != requestSeq) {
                    return;
                }

                // the counts json is usually just an object with counts, and doesn't have the worked property if no error occured
                if (data.hasOwnProperty('worked') && !data.worked) {
                    AJS.log('Error getting result counts');
                    return;
                }

                for (var type in data) {
                    if (data.hasOwnProperty(type)) {

                        var count = data[type];

                        // update the side counters
                        typeCounts.setCount(type, count);

                        // if we have some search results for the current category
                        if (count > 0) {
                            FECRU.SEARCH.resultCounts[type] = count;
                        }
                    }
                }

                updateNoResultsMessage();

                // update the total count of the results
                $("#total-count").text(FECRU.formatInt(getTotalResultCount())).fadeIn(250);
            }).fail(function (req, textStatus, errorThrown) {
                AJS.log('Error fetching counts ' + textStatus + ' - ' + errorThrown);
            });
    };

    var updateNoResultsMessage = function () {
        // update the counters in the message shown when the current category has no results:
        // "No results here but n results available there"
        if (!$.isEmptyObject(FECRU.SEARCH.resultCounts)) {
            for (var type in FECRU.SEARCH.resultCounts) {
                if (FECRU.SEARCH.resultCounts.hasOwnProperty(type)) {
                    $("#typecount-" + type).show().children("em").text(FECRU.formatInt(FECRU.SEARCH.resultCounts[type]));
                }
            }
            $("#typecounts").fadeIn(250);
        }
    };

    var searchBlock;
    $(function () {
        searchBlock = new UIBlock($('#column-content .content-container'), {
            margin: {
                top: '40px'
            }
        });

        searchBlock.init();
    });


    return {
        changeRepository: changeRepository,
        changeProject: changeProject,
        submit: submit,
        init: init,
        lazyLoad: lazyLoad,
        resultCounts: resultCounts,
        searchParams: searchParams,
        stats: stats,
        pushingState: pushingState,
        applyingState: applyingState,
        parseStateUrl: parseStateUrl,
        buildQueryUrl: buildQueryUrl,
        getResultsSeq: getResultsSeq
    };
})(AJS.$, History);
/*[{!search_js_r15d545!}]*/