/*eslint eqeqeq:0*/

window.FECRU = window.FECRU || {};
FECRU.RECENT = FECRU.RECENT || {};

(function ($) {

    var fecruRecent = FECRU.RECENT;

    fecruRecent.dropDownPopulatedMap = {
        "source": false,
        "projects": false,
        "people": false,
        "reviews": false
    };

    /**
     @param headerText The text to be used as the title of this section.
     @param itemsData An array of objects with linkUrl and linkText properties
     @returns A string containing the HTML representation of the section.
     */
    var sectionAsString = function (id, headerText, itemsData) {
        var $items = $("<div/>");
        for (var i = 0, l = itemsData.length; i < l; i++) {
            var item = itemsData[i];
            var MAX_LENGTH = 27; //the max length of text before truncation occurs
            var linkTextSuffix = item.linkTextSuffix ? item.linkTextSuffix : "";
            var fullLinkText = item.linkText + linkTextSuffix;
            var linkTextMax = MAX_LENGTH - linkTextSuffix.length - (item.iconUrl ? 4 : 0);
            var shortLinkText = item.linkText.substr(0, linkTextMax);

            var $a = $("<a />");
            $a.attr("href", item.linkUrl);
            if (shortLinkText != item.linkText) {
                shortLinkText += "...";
                $a.attr("title", fullLinkText);
            }
            shortLinkText += linkTextSuffix;
            $a.text(shortLinkText); // do this first because text() replaces the entire content of the tag
            if (item.iconUrl) {
                var $img = $("<img/>");
                $img.attr("src", FECRU.getAvatarUrlAtSize(item.iconUrl, "16"));
                $a.append($img);
                $a.addClass("aui-icon-container");
            }
            $items.append($("<li/>").append($a));
        }
        return "<div id='" + id + "' class='aui-dropdown2-section'><strong>" + headerText + "</strong><ul>" + $items.html() + "</ul></div>";
    };

    /**
     When called on an AUI dropdown object with section parameters, adds an HTML representation of those sections
     to the dropdown in the pentultimate position.

     @param sections... A variable number of arguments that are objects with the following structure:
     {
         headerText: "A Header",
         itemsData: [
             {
                 linkUrl: "http://www.example.com",
                 linkText: "Happy Time WebSite FunPlace!",
                 linkTextSuffix: "Not!",
                 iconUrl: "/foo/user/avatar/"
             }
             ...
         ]
     }
     */
    var populateDropdown = function ($this, s, type) {
        type = type || 'other';

        var sections = "";
        for (var i = 0, l = s.length; i < l; i++) {
            var sectionData = s[i];
            $("#" + sectionData.id).remove();
            if (sectionData.itemsData && sectionData.itemsData.length &&
                $this.children('strong:contains("' + sectionData.headerText + '")').size() === 0) {
                sections += sectionAsString(sectionData.id, sectionData.headerText, sectionData.itemsData) || "";
            }
        }

        if (type == 'review') {
            $this.append(sections);
        } else {
            $this.prepend(sections);
        }
        $this.closest(".menu-bar").addClass("menu-loaded");
    };

    var setSpinnerVisible = function ($menu, show) {
        var $e = $menu.find(".dropdown2-loading");
        if (show) {
            $e.show();
        } else {
            $e.hide();
        }
    };

    /**
     Create a recent items dropdown using the given options, the given callback function, and the shared cache.
     @param options The options object that gets passed to AUI
     @param onRefreshSuccess The function to call with a response string parameter when this control refreshes.
     */
    var cachedResponse = null;
    var initDropDown = function (options, onRefreshSuccess, isAjax) {
        var updateMenu = function ($this, data) {
            onRefreshSuccess($this, data);
        };
        $(options.dropDown).each(function () {
            var $this = AJS.$(this);

            // use the visibility of the log in link to determine if the user has logged in or not.
            var pathname = location.pathname;
            var rgxLogout = /\/logout$/;
            if (FECRU.isAnon || rgxLogout.exec(pathname)) {
                return;
            }

            $this.on({
                "aui-dropdown2-show": function () {
                    if (cachedResponse == null) {
                        setSpinnerVisible($this, true);
                        AJS.$.ajax({
                            dataType: "json",
                            type: "GET",
                            url: FECRU.pageContext + "/rest-service-fecru/recently-visited-v1/detailed.json",
                            error: errorHandler,
                            success: function (data, textStatus, jqXHR) {
                                cachedResponse = data;
                                setSpinnerVisible($this, false);
                                updateMenu($this, cachedResponse);
                            }
                        });
                    } else {
                        updateMenu($this, cachedResponse);
                    }
                }
            });
        });
    };

    // mark the dropdowns as errors if there is an error in the ajax call to fetch the list.
    var errorHandler = function () {
        AJS.$("#main-nav .aui-dd-parent").closest(".menu-bar").addClass("menu-loaded menu-error"); //TODO wrong selector
    };

    fecruRecent.setDropdowns = function () {
        var options = {
            selectionHandler: function () {
                // Prevent AUI from reimplementing default browser handling of <a> elements.
                // May need to revisit depending on AUI changes (see CR-FE-1617).
            },
            useLiveEvents: false, //Can't use live events with aui ajax dropdown
            selector: '#main-nav .aui-dd-parent', // Increase specificity as its not a live event
            trigger: '.aui-dd-link',
            alignment: "left",
            ajaxOptions: {
                dataType: "json",
                type: "GET",
                url: FECRU.pageContext + "/rest-service-fecru/recently-visited-v1/detailed.json",
                error: errorHandler
            }
        };

        var dropDownMapping = [{
            dropDownSelector: '#source-dropdown',
            populateFunction: function ($this, response) {
                var currentRepositoryName = $this.find("input[name=currentRepositoryName]").val();
                populateDropdown($this, [{
                    id: "recent-repositories-section",
                    headerText: "Recent repositories",
                    itemsData: AJS.$.map(response["repositories"]["repository"], function (item) {
                        return currentRepositoryName == item.entityId ? null : {
                            linkText: item.entityId,
                            linkUrl: FECRU.pageContext + item.uri
                        };
                    })
                }]);
                fecruRecent.dropDownPopulatedMap.source = true;
            }
        },
            {
                dropDownSelector: '#projects-dropdown',
                populateFunction: function ($this, response) {
                    var currentProjectKey = $this.find("input[name=currentProjectKey]").val();
                    populateDropdown($this, [{
                        id: "recent-projects-section",
                        headerText: "Recent projects",
                        itemsData: AJS.$.map(response["projects"]["project"], function (item) {
                            if (currentProjectKey == item.entityId) {
                                return null;
                            }
                            var project = item.projectData;
                            return {
                                linkText: project ? project.name : item.entityId,
                                linkTextSuffix: project ? " (" + item.entityId + ")" : null,
                                linkUrl: FECRU.pageContext + item.uri
                            };
                        })
                    }]);
                    fecruRecent.dropDownPopulatedMap.projects = true;
                }
            },
            {
                dropDownSelector: '#people-dropdown',
                populateFunction: function ($this, response) {
                    populateDropdown($this, [{
                        id: "recent-users-section",
                        headerText: "Recent users",
                        itemsData: AJS.$.map(response["users"]["user"], function (item) {
                            var user = item.userData;
                            return {
                                linkText: user ? user.displayName : item.entityId,
                                linkTextSuffix: user ? " (" + item.entityId + ")" : null,
                                linkUrl: FECRU.pageContext + item.uri,
                                iconUrl: user ? user.avatarUrl : null
                            };
                        })
                    }]);
                    fecruRecent.dropDownPopulatedMap.people = true;
                }
            },
            {
                dropDownSelector: '#reviews-dropdown',
                populateFunction: function ($this, response) {
                    populateDropdown($this, [{
                        id: "recent-reviews-section",
                        headerText: "Recent reviews",
                        itemsData: AJS.$.map(response["reviews"]["review"], function (item) {
                            var review = item.reviewData;
                            var linkText = item.entityId;
                            if (review) {
                                linkText += ": " + review.name;
                            }
                            return {
                                linkText: linkText,
                                linkUrl: FECRU.pageContext + item.uri
                            };
                        })
                    }, {
                        id: "recent-snippets-section",
                        headerText: "Recent snippets",
                        itemsData: AJS.$.map(response["snippets"]["snippet"], function (item) {
                            var snippet = item.snippetData;
                            var linkText = item.entityId;
                            if (snippet) {
                                linkText += ": " + snippet.name;
                            }
                            return {
                                linkText: linkText,
                                linkUrl: FECRU.pageContext + item.uri
                            };
                        })
                    }], 'review');
                    fecruRecent.dropDownPopulatedMap.reviews = true;
                }
            }];

        for (var i = 0, l = dropDownMapping.length; i < l; i++) {
            options.dropDown = dropDownMapping[i].dropDownSelector;
            initDropDown(options, dropDownMapping[i].populateFunction, !FECRU.isAnon);
        }
    };

})(AJS.$);
/*[{!recently_visited_js_vefd543!}]*/