window.FECRU = window.FECRU || {};
if (!FECRU.PROFILE) {
    FECRU.PROFILE = (function () {
        var makeDialogFor = function (url) {
            var windowWidth = AJS.$(window).width();
            var windowHeight = AJS.$(window).height();
            var width = (windowWidth < 1000) ? windowWidth - 120 : 800;
            var height = (windowHeight < 700) ? windowHeight - 100 : 700;
            var HEADER_HEIGHT = 55; //height of the dialog header, in px
            var BUTTON_HEIGHT = 50; //height of the buttons at bottom of dialog, in px.
            var BODY_PADDING = AJS.$('#adminpage').length ? 40 : 20; // needs to be the same as .aui-dialog .dialog-panel-body declaration in dialog.css
            var IFRAME_SPACING = 3; // under html5 the iframe gets arbtirary following spacing, and this removes the scrollbar it causes
            var OUTERHEIGHT = HEADER_HEIGHT + BUTTON_HEIGHT + BODY_PADDING + IFRAME_SPACING; // 110
            var iframeHeight = height - OUTERHEIGHT;
            var settingsDialog = FECRU.DIALOG.create(width, height, 'fecru-profile-settings-dialog');
            var deepProfileSettingsLink = url || FECRU.pageContext + "/profile";
            // hack: we're adding a random number to the iframe ID to work
            // around webkit bug: 24078 (http://lists.macosforge.org/pipermail/webkit-unassigned/2009-February/100941.html)
            var $iframe = AJS.$('<iframe/>');
            $iframe.attr({
                'id': 'fecru-iframe-' + (Math.ceil(Math.random() * 1000)),
                'frameborder': '0',
                'src': deepProfileSettingsLink,
                'style': 'width:100%;height:' + (iframeHeight) + 'px'
            });


            settingsDialog.addHeader("Profile settings");
            settingsDialog.addPanel("Display", $iframe);
            settingsDialog.addCancel("Close", function (dialog) {
                dialog.hide();

                //todo: fix up reloading?
                if (getDialogURL()) {
                    // Remove "dialog" parameter before reloading
                    var topURL = window.location.href;
                    topURL = topURL.replace(/\?dialog=[^&]*/, "?");
                    topURL = topURL.replace(/&dialog=[^&]*/, "");
                    topURL = topURL.replace(/\?$/, "");
                    window.location.replace(topURL);
                } else {
                    window.location.reload();
                }
            });
            return settingsDialog;
        };

        AJS.$(document).ready(function () {
            handleEmailChange();

            var toggleMappingSubmitButton = function () {
                var selectedIndex = AJS.$("#repositoryDropdown").attr("selectedIndex");
                var disabled = +selectedIndex === 0;

                AJS.$("#addMappingButton").prop("disabled", disabled);
            };
            AJS.$("#repositoryDropdown").change(toggleMappingSubmitButton);
            toggleMappingSubmitButton();    // set initial state

            var settingsDialog;
            //todo may be use live events?
            var $profileSettingsLink = AJS.$("a.dialog-settings").click(function (e) {
                e.preventDefault();
                FECRU.UI.hideClosestDropdown2(this);

                if (!settingsDialog) {
                    settingsDialog = makeDialogFor($profileSettingsLink.attr('href'));
                }
                settingsDialog.show();
            });

            var $form = AJS.$('form.autosubmit');
            $form.find('input,select').change(function (event) {
                var params = $form.serialize();
                var action = $form.attr('action');
                var $spinner = $form.find('.edit-settings-spinner').show();
                var saved = function () {
                    AJS.$('body').trigger('user.profile.change.save', event.currentTarget.name);
                    setTimeout(function () {
                        $spinner.hide();
                    }, 500); //show the spinner for slightly longer, so that the feedback is visible for longer
                };

                FECRU.AJAX.ajaxDo(action, params, saved);
            });

            $form.find('#clear-ignored-applinks').click(function () {
                var $spinner = AJS.$(".clear-ignored-applinks-spinner").show();
                FECRU.UAL.clearIgnoredAppLinks(function () {
                    setTimeout(function () {
                        $spinner.hide();
                        window.location.reload();
                    }, 500); //show the spinner for slightly longer, so that the feedback is visible for longer
                });
            });

            // If there's a dialog argument on our URL, open that dialog.
            var dialogURL = getDialogURL();
            if (dialogURL) {
                settingsDialog = makeDialogFor(FECRU.pageContext + dialogURL);
                settingsDialog.show();
            }

        });

        function getDialogURL() {
            // Don't match URLs which are login redirects
            if (location.search.match(/origUrl/)) {
                return null;
            }
            var matches = /[?&]dialog=([^&]*)/.exec(location.search);
            if (matches) {
                return decodeURIComponent(matches[1]);
            }
            return null;
        }

        /**
         * Handle email's field change.
         * In case it was modified user has to provide his password unless the password field is not rendered -
         *   password confirmation is not needed then.
         */
        function handleEmailChange() {
            var $emailSettingsForm = AJS.$('#profile-email-settings');
            var $password = $emailSettingsForm.find('#password');
            if ($password.length === 0) {
                return;
            }
            var $passwordGroup = $password.closest('.profile-settings-group');
            var $email = $emailSettingsForm.find('#email');
            var savedEmail = $emailSettingsForm.find('#savedEmail').val();
            var isPasswordEntered = function () {
                return $password.val().length > 0;
            };
            var isEmailModified = function () {
                return savedEmail !== $email.val().trim();
            };
            var updatePasswordConfirmationField = function () {
                if (isEmailModified()) {
                    $passwordGroup.stop(true, true).fadeIn(200);
                } else {
                    $passwordGroup.stop(true, true).fadeOut(200);
                }
            };

            $email.on('input', updatePasswordConfirmationField);
            $emailSettingsForm.on('submit', function (e) {
                if (isEmailModified() && !isPasswordEntered()) {
                    $password.focus();
                    e.preventDefault();
                }
            });
        }

        return true; //flag to stop multiple calls which adds multiple dialog boxes.
    })();
}
/*[{!profile_js_l3rx541!}]*/