window.FECRU = window.FECRU || {};
FECRU.PREFS = FECRU.PREFS || (function (window, document, $, fecruAjax, contextPathProvider) {
        var exports = {};
        var setChangePreferenceCookie = function (preferences) {
            var preferencesString = typeof preferences === 'string' ? preferences : decodeURIComponent($.param(preferences));
            $.cookie('set_crucibleprefs1', preferencesString, {path: contextPathProvider()});
        };

        /**
         * @param {String} name
         * @param {String} value
         * @param {Function} callback called when the preference will be successfully changed
         */
        exports.setPreference = function (name, value, callback) {
            var params = {};
            params[name] = value;
            exports.setPreferences(params, callback);
        };

        /**
         * @param {Object} prefs hash object with preferences
         * @param {Function} callback called when the preferences will be successfully changed
         */
        exports.setPreferences = function (prefs, callback) {
            setChangePreferenceCookie(prefs);
            fecruAjax.ajaxDo(contextPathProvider() + "/json/fe/setPreference.do", {}, callback, false);
        };

        exports.setupBinaryPrefLinks = function (name,
                                                 cookieName,
                                                 initialState,
                                                 fns,
                                                 onStateString,
                                                 offStateString,
                                                 forceInitialCall,
                                                 reload,
                                                 optionsSelector) {
            var onSelector = "." + name + onStateString;
            var offSelector = "." + name + offStateString;

            var setPref = function (value, hideSelector, showSelector, callback) {
                exports.setPreference(cookieName, value, callback);
                setVisibility(value, hideSelector, showSelector, true);
            };

            var setVisibility = function (value, hideSelector, showSelector, callfunction) {
                var $optionsSelector = $(optionsSelector);
                $optionsSelector.find(hideSelector).css("display", "none");
                $optionsSelector.find(showSelector).css("display", "block");
                if (callfunction || forceInitialCall) {
                    fns[value].call();
                }
            };

            var reloadPage = function () {
                if (reload) {
                    window.location.reload();
                }
            };

            // make sure we extend the selector to every match, by splitting on ",
            var createSelector = function (base, extra) {
                var arr = base.split(",");
                for (var i = 0; i < arr.length; i++) {
                    arr[i] = arr[i] + " " + extra;
                }
                return arr.join(",");
            };

            $(document).delegate(createSelector(optionsSelector, onSelector), "click", function () {
                setPref(onStateString, onSelector, offSelector, reloadPage);
                return false;
            }).delegate(createSelector(optionsSelector, offSelector), "click", function () {
                setPref(offStateString, offSelector, onSelector, reloadPage);
                return false;
            });
            if (initialState) {
                setVisibility(onStateString, onSelector, offSelector, false);
            } else {
                setVisibility(offStateString, offSelector, onSelector, false);
            }
        };

        AJS.$(function () {
            $(document).on('click', 'a[data-set-pref]', function () {
                setChangePreferenceCookie($(this).data('setPref'));
            });
        });

        return exports;
    })(window, document, AJS.$, FECRU.AJAX, AJS.contextPath);

