window.FECRU = window.FECRU || {};

FECRU.OAUTH = (function ($, window) {

    var Map = FECRU.DATA_STRUCTURES.Map;
    var EventProducer = FECRU.MIXINS.EventProducer;
    var fecruAjax = FECRU.AJAX;
    var applinksAuthorizationImpl = FECRU.UAL.oAuthAuthorization;


    var oAuthAuthorizationInfos = new Map();
    var getOrCreateOauthAuthInfo = function (key) {
        var authInfo = oAuthAuthorizationInfos.get(key);
        if (!authInfo) {
            oAuthAuthorizationInfos.set(key, authInfo = new EventProducer(['authorized', 'authorizationFailed']));
        }
        return authInfo;
    };
    var currentlyAuthenticating;

    function oAuthAuthorize(authorizationUri, optionalOAuthAuthorizationImpl) {
        var authInfo = getOrCreateOauthAuthInfo(authorizationUri);

        // Applinks doesn't support concurrent authentication (or rather, you can do it, but we can only get a callback for one at a time).
        // Therefore, "cancel" the last attempt and alert the user.
        if (currentlyAuthenticating && currentlyAuthenticating !== authInfo) {
            currentlyAuthenticating.authorizationImpl.cancelAuthorization(currentlyAuthenticating.uri);
            currentlyAuthenticating.authorizationFailed();

            fecruAjax.appendNotificationMessage("To process your new authentication, FishEye disconnected from your previous authentication window. You" +
                " may need to reload the page before your remote authentication is registered.");
            fecruAjax.showNotificationBox("Authentication Cancelled", "message");
        }
        currentlyAuthenticating = authInfo;

        var authImpl = authInfo.authorizationImpl = optionalOAuthAuthorizationImpl || applinksAuthorizationImpl;
        authInfo.uri = authorizationUri;
        authImpl.authorize(authorizationUri, function () {
                if (currentlyAuthenticating === authInfo) {
                    currentlyAuthenticating = null;
                }
                authInfo.authorized();
            },
            function () {
                if (currentlyAuthenticating === authInfo) {
                    currentlyAuthenticating = null;
                }
                authInfo.authorizationFailed();
            }
        );

        return authInfo.getBinder();
    }

    function getOAuthAuthorizationEventProducer(authorizationUri) {
        return getOrCreateOauthAuthInfo(authorizationUri).getBinder();
    }

    function clearAllOAuthEventProducers() {
        oAuthAuthorizationInfos = new Map();
    }

    return {
        authorize: oAuthAuthorize,
        getEventProducer: getOAuthAuthorizationEventProducer,
        internalClearAllEventProducers: clearAllOAuthEventProducers
    };
})(AJS.$, this);
/*[{!oauth_js_lrae53y!}]*/