window.FECRU = window.FECRU || {};
FECRU.NAVBUILDER = FECRU.NAVBUILDER || {};

(function (namespace) {
    var EXTRA_ESCAPE_CHARS = /['\\(\\)]/g;

    function strictUriEncode(str) {
        return encodeURIComponent(str).replace(EXTRA_ESCAPE_CHARS, function (c) {
            switch (c) {
                case "'":
                    return '%27';
                case "(":
                    return '%28';
                case ")":
                    return '%29';
            }
        });
    }

    /**
     * Generate a url for browsing the given repository at tag
     * @param repositoryName the repository name.
     * @param tag the tag name.
     * @return a string uri (includes the page context path) with the repository and tag component encoded
     */
    namespace.browseAtTag = function (repositoryName, tag) {
        return FECRU.pageContext + "/browse/~tag=" + strictUriEncode(tag) + "/" + strictUriEncode(repositoryName);
    };

    namespace.graphAtChangeset = function (repositoryName, csid) {
        return FECRU.pageContext + "/graph/" + strictUriEncode(repositoryName) + (csid ? "?csid=" + strictUriEncode(csid) : "");
    };

    namespace.user = function (userName) {
        return FECRU.pageContext + "/user/" + strictUriEncode(userName);
    };

    namespace.avatar = function (userName) {
        return FECRU.pageContext + "/avatar/" + strictUriEncode(userName);
    };

})(FECRU.NAVBUILDER);
/*[{!navbuilder_js_4lye53x!}]*/