/* modernise.js - holds code needed for older, non-IE browsers.
 * */




/* Properties:

 //run a get function:
 var x = theObject.thePropertyName;
 //run a set function:
 theObject.thePropertyName = value;

 The W3C standard is to use
 Object.defineProperty(theObject, "thePropertyName", {
 get : function() { return myValue; },
 set : function(value) { myValue = value; }
 });

 Older versions of FF (and others) instead use a custom function name (__define{G|S}etter__ was the
 de facto standard).  When Object.defineProperty doesn't exist, we define it using those custom functions:

 theObject.__defineGetter__("thePropertyName", function() { return myValue; });
 theObject.__defineSetter__("thePropertyName", function(value) { myValue = value; });

 Lowest browser versions that support Object.defineProperty:
 Firefox 4, (only one not there yet?)
 IE 8,
 Chrome (any),
 Safari 5
 This code can be removed once those are our lowest supported versions.
 */
if (!Object.defineProperty) {
    Object.defineProperty = function (obj, prop, descriptor) {
        if (descriptor.value) {
            obj[prop] = descriptor.value;
        } else {
            if (obj.__defineGetter__ && descriptor.get) {
                obj.__defineGetter__(prop, descriptor.get);
            }
            if (obj.__defineSetter__ && descriptor.set) {
                obj.__defineSetter__(prop, descriptor.set);
            }
        }
    };
}
/*[{!modernise_js_b0av53w!}]*/