define('FECRU/model/PermissionScheme', ['backbone'], function (Backbone) {
    'use strict';

    return Backbone.Model.extend({
        urlRoot: function () {
            return AJS.contextPath() + '/rest-service-fecru/admin/permission-schemes';
        },
        idAttribute: 'name'
    }, {
        getByName: function (name) {
            var model = new this({name: name});
            return model.fetch();
        },
        exists: function (name) {
            var deferred = Backbone.$.Deferred();
            this.getByName(name)
                .then(function () {
                    deferred.resolve(true);
                }, function (xhr, status, error) {
                    if (error === 'Not Found') {
                        deferred.resolve(false);
                        return;
                    }
                    deferred.reject(xhr, status, error);
                });
            return deferred.promise();
        }
    });
})