window.FECRU = window.FECRU || {};
FECRU.ISSUEDIALOG = (function () {

    var dialog;

    AJS.$(document).ready(function () {
        if (!FECRU.isJiraIntegrationPluginEnabled || // dont set up the issue dialog event when there is a JIRA 4.4 server (when the JIRA integration plugin is disabled)
            !window.top.jiraIntegration) { // if we're in an iframe with no outer window
            return;
        }

        var getDialog = function (self, e) {
            if (!dialog) {
                dialog = new window.top.jiraIntegration.JiraIssuesDialog({
                    oauthTriggerClass: 'ual-authenticate',
                    ajax: function (options) {
                        return AJS.$.ajax(AJS.$.extend({
                            cache: false // so IE doesnt cache it
                        }, options));
                    }
                });

                var onTransitioned = function (issueKey) {
                    setTimeout(function () {
                        CRU.UI.reloadInlineJiraIssues([issueKey]);
                        if (window.RIL && AJS.$('.jira-issues-report-row[data-jira-issue-key=' + issueKey + ']').length) {
                            RIL.insertReviewReport();
                        }
                    }, 0);
                };

                dialog.on('transitioned', onTransitioned);
            }
            dialog.on('authorizationRequired', function (authUrl, applicationName) {
                window.top.FECRU.OAUTH.getEventProducer(authUrl).authorized(function () {
                    window.top.FECRU.HOVER.invalidateCache(window.top.FECRU.HOVER.CACHE_FOREVER); // we dont know what key to remove, so remove all
                    if (typeof window.top.CRU !== 'undefined' && window.top.CRU.UI && window.top.CRU.UI.loadInlineJiraIssues) {
                        window.top.CRU.UI.loadInlineJiraIssues(); // might as well reload all issues
                    }
                    dialog.onAuthorizationSucceeded(authUrl);
                });
            });

            var issueKey;
            var $this = AJS.$(self);
            if ($this.is('a')) {
                issueKey = $this.text();
            } else {
                issueKey = $this.children('a').text();
            }

            if (typeof window.top.review !== 'undefined' && window.top.review.projectKey()) {
                dialog.setEntityKey('project.' + window.top.review.projectKey());
            } else if (window.top.FECRU && window.top.FECRU.INFO && window.top.FECRU.INFO.repoName) {
                dialog.setEntityKey('repository.' + window.top.FECRU.INFO.repoName);
            } else {
                dialog.setEntityKey(null);
            }

            dialog.setIssueKeys([issueKey]);
            dialog.setTitle('JIRA Issue \'' + issueKey + '\'');

            return dialog;
        };

        AJS.$('body').delegate('.jira-hover-trigger', 'click', function (e) {
            // Right click fires a click event in Firefox but not in Chrome
            if (FECRU.isRightClick(e) || !FECRU.openInSameTab(e)) {
                return;
            }
            e.stopPropagation();
            e.preventDefault();

            var dialog = getDialog(this, e);

            dialog.show();
        });
    });

})();
/*[{!issue_dialog_js_n95s53u!}]*/