/*eslint eqeqeq:0*/

window.FECRU = window.FECRU || {};
FECRU.HOVER = (function () {
    var opts = {
        onHover: true,
        fadeTime: 200,
        hideDelay: 500,
        showDelay: 220,
        width: 300,
        offsetX: -4,
        offsetY: 10,
        container: "body",
        cacheContent: false,
        closeOthers: false, // without setting this to false, mousing over a user hover after opening the share dialog
                            //    will close the share dialog
        useLiveEvents: true,
        initCallback: function () {
            //this.popup.refresh();
        }
    };
    var respCache = {};
    var CACHE_FOREVER = -1;
    var displayHandlerDefaultOpts = {
        createUrl: function () {
            throw new Error("must provide createUrl");
        },
        createCacheKey: function () {
            throw new Error("must provide createCacheKey");
        },
        createParams: function () {
            throw new Error("must provide createParams");
        },
        minutesToCache: CACHE_FOREVER,
        cacheType: "__all",
        createTemplateContent: function () {
            return "";
        }
    };
    /**
     * createDisplayHandler returns a function that handles the display of the hover popup, and is used as the display handler
     * to be passed into AJS.InlineDialog as the url parameter (which is overloaded to take a function like this one).
     * @param params The named parameter needs the following properties:
     * @property createUrl : a function that accepts a jquery elem of the trigger of the hover, and returns the url to get
     * the content of the hover.
     * @property createCacheKey : a function that accepts a jquery elem of the trigger, and returns a unique string key for
     * this hover. Used to cache the result of the call created by createUrl
     * @property createParams : a function that accepts a key (created from createCacheKey) and a jquery elem of the trigger,
     * and returns a hash of the parameters to be passed along in the ajax request to the url created by creatUrl.
     * @optionalproperty minutesToCache : number of minutes to cache the result of the call to the url created by createUrl.
     * Defaults to CACHE_FOREVER
     * @optionalproperty cachetype : a unique string that identifies the type of hover being shown. Used by invalidateCache() to
     * clear the cache of this type. can be null.
     * @optionalproperty createExtraParams : a function that accepts the trigger and returns a map of parameters to be passed to the server
     * @optionalproperty createTemplateContent : a function that accepts a key, and optionally the trigger and returns a string to be
     * placed in the spinner template.
     */
    var createDisplayHandler = function (params) {
        var options = AJS.$.extend({}, displayHandlerDefaultOpts, params);
        var minutesToCache = options.createUrl;
        var cachetype = options.minutesToCache;
        var createTemplateContent = options.createTemplateContent;
        var triggerIdSeq = 1;
        var prevTriggerId = -1;

        return function ($contentDiv, mouseOverTrigger, showPopup) {
            var $trigger = AJS.$(mouseOverTrigger);
            var url = options.createUrl($trigger);
            var key = options.createCacheKey($trigger);
            var cache = respCache[cachetype] || {};
            var cacheHit = cache[key] || {isHit: false};
            var lastFetchTime = cacheHit.lastFetchTime || 0;
            var cacheTimedOut = (minutesToCache !== CACHE_FOREVER) &&
                ((new Date().getTime() - lastFetchTime) > (minutesToCache * 1000 * 60));
            if (key) {

                var triggerId = $trigger.data('data-trigger-id');
                if (!triggerId) {
                    triggerId = triggerIdSeq++;
                    $trigger.data('data-trigger-id', triggerId)
                }

                if (triggerId != prevTriggerId) {
                    $contentDiv.closest('.aui-inline-dialog').stop().hide();
                    prevTriggerId = triggerId;
                } else {
                    showPopup();
                    return;
                }

                $contentDiv.data("targetToDisplay", {key: key});
                var error = function (xmlHttpRequest, textStatus, errorThrown) {
                    $contentDiv.html(escape(textStatus) + "<br>" + escape(errorThrown ? errorThrown : ""));
                };
                var delayedShowSpinner;
                var done = function (resp) {
                    if (resp.worked) {
                        if (delayedShowSpinner) {
                            clearTimeout(delayedShowSpinner);
                        }
                        if ($contentDiv.data("targetToDisplay").key == key) {
                            $contentDiv.html(resp.html);
                            // show the popup if the spinner wasn't shown (either canceled or not supplied)
                            if (!createTemplateContent || delayedShowSpinner) {
                                showPopup();
                            }
                        }
                        // save result to cache
                        cacheHit.resp = resp;
                        cacheHit.lastFetchTime = new Date().getTime();
                        cacheHit.isHit = true;
                        cache[key] = cacheHit;
                        respCache[cachetype] = cache;
                    } else {
                        $contentDiv.html('<div class="hoverpopup">' + resp.errorMsg + '</div>');
                    }
                };
                if ((!cacheHit.isHit) || cacheTimedOut) {
                    AJS.$.ajax({
                        url: url,
                        data: options.createParams(key, $trigger),
                        type: "GET",
                        dataType: "json",
                        success: done,
                        error: error
                    });
                    // show the spinner if the template is provided, delaying it for a bit
                    if (createTemplateContent) {
                        delayedShowSpinner = setTimeout(function () {
                            if ($contentDiv.data("targetToDisplay").key == key) {
                                $contentDiv.html(getSpinnerTemplate(createTemplateContent(key, $trigger)));
                                showPopup();
                            }
                        }, 150);
                    }
                } else {
                    $contentDiv.html(cacheHit.resp.html);
                    showPopup();
                }
            }
        };
    };

    var invalidateCache = function (type, key) {
        if (!key) {
            respCache[type] = undefined;
        } else if (respCache[type]) {
            respCache[type][key] = undefined;
        }
    };

    var addAllLinkPopups = function () {
        if (!FECRU.isJiraIntegrationPluginEnabled) {
            addJiraLinkPopups(); // only show these when there is a JIRA 4.4 server (when the JIRA integration plugin is disabled)
        }
        addCruLinkPopups();
        addCsLinkPopups();
        addUserLinkPopups();
        addDeletedUserLinkPopups();
    };

    var addJiraLinkPopups = function () {
        var jiraShowDelay = 300;
        addLinkPopups({
            linkSpanClass: "jira-hover-trigger",
            url: FECRU.pageContext + '/json/action/issue-tooltip.do',
            showDelay: jiraShowDelay
        });
    };

    var addCruLinkPopups = function () {
        addLinkPopups({
            linkSpanClass: "crulinkspan",
            url: FECRU.pageContext + '/json/cru/tooltipdata',
            keyParser: function ($trigger) {
                var $permaId = $trigger.find('input.permaId');
                if ($permaId.length === 1) {
                    return $permaId.val();
                }
                return $trigger.find('a').text();
            }
        });
    };

    var addCsLinkPopups = function () {
        var changesetKeyPattern = /^(\/\/([^/]+)\/)(.+)$/;
        var getRepositoryName = function ($trigger) {
            return $trigger.data('repname') || $trigger.find('input.repname').val();
        };
        var getChangesetId = function ($trigger) {
            return $trigger.data('csid') || $trigger.find('input.csid').val();
        };

        addLinkPopups({
            linkSpanClass: "cslinkspan",
            url: FECRU.pageContext + '/json/action/cstooltipdata.do',
            keyParser: function ($trigger) {
                var repositoryName = getRepositoryName($trigger);
                var changesetId = getChangesetId($trigger);

                return '//' + repositoryName + '/' + changesetId;
            },
            createTemplateContent: function (key) {
                var matches = changesetKeyPattern.exec(key);
                if (matches) {
                    var changesetId = matches[3];
                    var repository = matches[2];
                    //abbrev. the id if too long
                    changesetId = changesetId.length > 10 ? changesetId.substring(0, 6) + "..." : changesetId;
                    return "changeset " + changesetId + " in " + repository;
                } else {
                    return "changeset";
                }
            },
            createExtraParams: function ($trigger) {
                return {
                    "repname": getRepositoryName($trigger),
                    "csid": getChangesetId($trigger)
                };
            }
        });
    };

    var getUrlParts = function (url) {
        var a = document.createElement('a');
        a.href = url;

        return {
            href: a.href,
            host: a.host,
            hostname: a.hostname,
            port: a.port,
            pathname: (a.pathname.charAt(0) === "/") ? a.pathname : "/" + a.pathname,
            protocol: a.protocol,
            hash: a.hash,
            search: a.search
        };
    };

    var addLinkPopups = function (params) {
        var defaults = {
            //the css class to bind the hover trigger to
            linkSpanClass: '',
            //the url to request the content of the trigger
            url: '',
            //how much to delay showing of the hover when triggered
            showDelay: opts.showDelay,
            //given the trigger jquery elem, return a unique string usable as a key for the cache
            keyParser: function ($trigger) {
                return $trigger.text();
            },
            //given the key and trigger, return something to display in the spinner message. can be an empty string.
            createTemplateContent: function (key, $trigger) {
                return key;
            }
        };
        var options = AJS.$.extend({}, defaults, params);
        var linkSpanClass = options.linkSpanClass;
        var displayHandler = createDisplayHandler({
            createUrl: function () {
                return options.url;
            },
            createCacheKey: function ($trigger) {
                var $keylink = AJS.$("a", $trigger);
                if ($keylink.length === 0) {
                    $keylink = $trigger;
                }
                var key = options.keyParser($keylink);
                key = AJS.$.trim(key);
                return key;
            },
            createParams: function (key, $trigger) {
                var extraParams = (options.createExtraParams && options.createExtraParams($trigger)) || {};
                return AJS.$.extend(false, extraParams, {key: key});
            },
            cacheType: linkSpanClass + "cache",
            createTemplateContent: options.createTemplateContent
        });
        var hoverOpts = AJS.$.extend(false, opts, {showDelay: options.showDelay});
        AJS.InlineDialog("." + linkSpanClass, linkSpanClass + "-popup", displayHandler, hoverOpts);
    };

    var addUserLinkPopups = function () {
        var getHref = function ($trigger) {
            var href = $trigger.attr('href');
            if (!href) {
                href = $trigger.parent().attr('href');//sometimes the trigger is the child
            }
            var parts = getUrlParts(href);
            // we need to make this relative, because wiki markup renders absolute links, which may be to a different
            // hostname than the one from which this page was loaded.
            return parts.pathname;
        };
        var displayHandler = createDisplayHandler({
            createUrl: function ($trigger) {
                return getHref($trigger);
            },
            createCacheKey: function ($trigger) {
                return getHref($trigger);
            },
            createParams: function () {
                return {ajax: "true"};
            },
            cacheType: 'userlinks',
            createTemplateContent: function (key, $trigger) {
                var $linkText = $trigger.hasClass('linkText') ? $trigger : $trigger.find(".linkText");
                if ($linkText.length === 0) {
                    //if the linkText doesnt exist, which does happen for avartars with no displayed name
                    return key.replace(/^.*\//, "");//remove all but the username
                } else {
                    return $linkText.text();
                }
            }
        });
        AJS.InlineDialog("a.userorcommitter,a.userorcommitter-parent .linkText", "user-hover-inline-dialog", displayHandler, opts);
    };

    var addDeletedUserLinkPopups = function () {
        var hoverContent = function ($contents, trigger, showPopup) {
            var $trigger = AJS.$(trigger);
            $contents.html(
                "<div class='user-hover-info'>" +
                "<div class='user-hover-avatar'>" +
                "<img height='48' width='48' alt='Deleted User' src='" + FECRU.pageContext + "/avatar/deleted' />" +
                "</div>" +
                "<div class='user-hover-details'>" +
                "<h4><span class='linkText'></span></h4>" +
                "<em>(deleted user)</em>" +
                "</div>"
            );
            var usernameSpan = $trigger.find(".hidden-username");
            if (usernameSpan) {
                $contents.find("span.linkText").text(usernameSpan.text());
            }
            showPopup();
        };
        AJS.InlineDialog("a.deleteduser,a.deleteduser-parent .linkText", "deleted-user-hover-inline-dialog", hoverContent, opts);
    };

    var getSpinnerTemplate = function (content) {
        // Don't add the content directly into the spinner, as it may contain unescaped HTML content.
        // The workaround is to create a jQuery object and call .text(), and then return the html of the constructed object.
        var $elem = AJS.$('<div><div class="hoverpopup-throb jirahoverpopup-throb">' +
            '<img src="' + FECRU.pageContext + '/' + FECRU.staticDirectory +
            '/2static/images/spinner_003366.gif" alt="Retrieving details">' +
            '<em class="hoverpopup-throbber-text">Retrieving ' +
            '<span class="hoverpopup-throbber-text-content">' +
            '</span>...</em></div></div>');
        $elem.find(".hoverpopup-throbber-text-content").text(content);
        return $elem.html();
    };

    return {
        addAllLinkPopups: addAllLinkPopups,
        invalidateCache: invalidateCache,
        CACHE_FOREVER: CACHE_FOREVER
    };
})();
/*[{!hover_js_75n453s!}]*/