window.FECRU = window.FECRU || {};
FECRU.DIALOG = {};

(function ($, namespace) {
    var safeDimensions = function (maxWidth, maxHeight, margin) {
        margin = margin || 50;
        return {
            height: Math.min($(window).height() - margin, maxHeight),
            width: Math.min($(window).width() - margin, maxWidth)
        };
    };

    var $container = null;

    function initAjaxContainer() {
        $container = $('<div id="ajax-dialog-container"></div>');
        $(document).ready(function () {
            $('body').append($container);
        });
    }

    function create(maxWidth, maxHeight, id, options) {
        var dimensions = safeDimensions(maxWidth, maxHeight);
        var dimensionsAndId = {
            width: dimensions.width,
            height: dimensions.height,
            id: id
        };

        options = options ?
            $.extend({}, options, dimensionsAndId) :
            dimensionsAndId;
        var dialog = new AJS.Dialog(options);
        // Add the height and width of the dialog as properties of the object
        $.extend(dialog, {width: dimensions.width, height: dimensions.height});
        return dialog;
    }

    function triggerAjaxDialogLoaded() {
        $(document).trigger('ajax-dialog-loaded');
    }

    function ajaxDialog(maxWidth, maxHeight, data, id) {
        var $container = getAjaxDialogContainer();

        var dialog = FECRU.DIALOG.create(maxWidth, maxHeight, id);
        $.each(
            $.extend({dialog: dialog}, data),
            function (k, v) {
                $container.data(k, v);
            }
        );
        return dialog;
    }

    function getAjaxDialogContainer() {
        if (!$container) {
            initAjaxContainer();
        }
        return $container;
    }

    $.extend(namespace, {
        create: create,
        ajaxDialog: ajaxDialog,
        triggerAjaxDialogLoaded: triggerAjaxDialogLoaded,
        getAjaxDialogContainer: getAjaxDialogContainer
    });
})(AJS.$, FECRU.DIALOG);
/*[{!dialog_js_eiaw53n!}]*/