FECRU.DECORATORS = FECRU.DECORATORS || {};
(function (namespace, $) {

    var memoize = function (prototype, funcKey) {
        var func = prototype[funcKey];

        var newFunc = function () {
            var self = this;
            var val = func.call(self);
            var isArray = val instanceof Array;
            var russianDoll = function () {
                return isArray ? val.slice(0) : val;
            };
            russianDoll.flush = function () {
                self[funcKey] = newFunc;
            };

            self[funcKey] = russianDoll;

            return isArray ? val.slice(0) : val;
        };
        newFunc.flush = function () {
        };

        prototype[funcKey] = newFunc;
    };

    var eraseMemoized = function (prototype, funcKey, flushFuncOrKeysToFlush) {
        var func = prototype[funcKey];
        if ($.isFunction(flushFuncOrKeysToFlush)) {
            var flushFunc = flushFuncOrKeysToFlush;
            prototype[funcKey] = function () {
                var ret = func.apply(this, arguments);
                flushFunc.apply(this, arguments);
                return ret;
            };
        } else if ($.isArray(flushFuncOrKeysToFlush)) {
            var funcKeysArray = flushFuncOrKeysToFlush;
            prototype[funcKey] = function () {
                var ret = func.apply(this, arguments);
                var self = this;

                Array.each(funcKeysArray, function (funcNameToFlush) {
                    self[funcNameToFlush].flush();
                });
                return ret;
            };
        } else {
            throw "Expected function or Array as third parameter.";
        }
    };

    $.extend(namespace, {
        memoize: memoize,
        eraseMemoized: eraseMemoized
    });

})(FECRU.DECORATORS, AJS.$);
/*[{!decorators_js_gpqa53m!}]*/