/**
 * localStorage plugin, this plugin is only being used by barracuda ui currently.
 */

(function ($, g) {
    var hasLocalStorage = 'localStorage' in window && window['localStorage'] !== null;

    if (!FECRU.ClientStorage) {
        FECRU.ClientStorage = {
            get: function (key) {
                try {
                    if (hasLocalStorage) {
                        return g.localStorage.getItem(FECRU.pageContext + "-" + key);
                    } else {
                        return null;
                    }
                } catch (ex) {
                    return null;
                }
            },
            set: function (key, val) {
                try {
                    if (hasLocalStorage) {
                        g.localStorage.setItem(FECRU.pageContext + "-" + key, val);
                        return true;
                    } else {
                        return false;
                    }
                } catch (ex) {
                    return false;
                }
            },
            getJSON: function (key) {
                var str = this.get(key);
                if (str == null) {
                    return null;
                }
                else {
                    return JSON.parse(str);
                }
            },
            setJSON: function (key, val) {
                try {
                    var str = JSON.stringify(val);
                    return this.set(key, str);
                } catch (ex) {
                    return false;
                }
            },
            clear: function (key) {
                if (hasLocalStorage) {
                    g.localStorage.removeItem(FECRU.pageContext + "-" + key);
                } else {
                    return false;
                }
            }
        }
    }
})(AJS.$, window);
/*[{!clientStorage_js_uzcv53i!}]*/