var ResultSet = Backbone.Model.extend({
    initialize: function () {
        this.resultItems = new Backbone.Collection;
        this.highlighted = null;
    },
    process: function (response) {
        this.resultItems.reset(response.results);
        if (!this._shouldShow(response.query)) {
            return;
        }
        this.lastQuery = response.query;
        this._hiddenQuery = null;
        this.trigger('render');
    },
    setSelection: function (model) {
        this.selectedItem = model;
        this._hiddenQuery = null;
        this.trigger('selected', model.id);
    },
    hide: function (query) {
        this.trigger('hide');
        this._hiddenQuery = (typeof query !== 'undefined' ? query : this.lastQuery);
    },
    _shouldShow: function (query) {
        return query === '' || !(this._hiddenQuery && this._hiddenQuery === query);
    },
    highlightPrevious: function () {
        if (!this.highlighted) {
            return;
        }
        if (this.highlighted.id !== this.resultItems.first().id) {
            this.highlighted.trigger('unhighlight');
            this.highlighted = this.resultItems.at(this.resultItems.indexOf(this.highlighted) - 1).trigger('highlight');
        }
    },
    highlightNext: function () {
        if (!this.highlighted) {
            return;
        }
        if (this.highlighted.id !== this.resultItems.last().id) {
            this.highlighted.trigger('unhighlight');
            this.highlighted = this.resultItems.at(this.resultItems.indexOf(this.highlighted) + 1).trigger('highlight');
        }
    },
    highlightFirst: function () {
        this.highlighted && this.highlighted.trigger('unhighlight');
        this.highlighted = this.resultItems.first().trigger('highlight');
    },
    selectHighlighted: function () {
        this.setSelection(this.highlighted);
    }
});

var AutocompleteResults = Backbone.View.extend({
    initialize: function (options) {
        this._itemContainerClass = options.itemContainerClass || 'autocomplete-items';
        this._itemClass = options.itemClass || 'autocomplete-item';
        this._activeClass = options.activeClass || 'active';
        this._resultItemTemplate = options.resultItemTemplate || function () {
                return '';
            };

        this.model = new ResultSet;
        options.source.on('respond', this.model.process, this.model);
        this.model.on('render', this.render, this);
        this.model.on('hide selected', this.hide, this);
        this.$el.hide().addClass('autocomplete').appendTo('body');
    },
    render: function () {
        var $ul = jQuery('<ul>').attr({
            'class': this._itemContainerClass
        });
        this.model.resultItems.each(function (item) {
            var $li = jQuery('<li>').attr({'class': this._itemClass}, this._resultItemTemplate(item.attributes))
                .click(_.bind(this.model.setSelection, this.model, item))
                .appendTo($ul);
            item.on('highlight', _.bind(this.highlight, this, $li));
            item.on('unhighlight', _.bind(this.unhighlight, this, $li));
        }, this);


        if (this.model.resultItems.length) {
            this.$el.html($ul).show();
            this.model.highlightFirst();
        } else {
            this.$el.hide();
        }
        return this;
    },
    highlight: function ($el) {
        $el.addClass(this._activeClass);
    },
    unhighlight: function ($el) {
        $el.removeClass(this._activeClass);
    },
    reposition: function (input) {
        var inputOffset = input.$el.offset();
        var inputWidth = input.$el.outerWidth();
        var inputHeight = input.$el.outerHeight();
        this.$el.css({
            width: inputWidth,
            top: inputOffset.top + inputHeight,
            left: inputOffset.left
        });
    },
    hide: function () {
        this.$el.hide();
    }
});
/*[{!query_result_js_39t754g!}]*/