var QueryInput = Backbone.View.extend({
    initialize: function (options) {
        _.bindAll(this, 'changed', 'val');
        this._lastValue = this.val();
        this.$el.bind('keyup focus', this.changed);
    },
    val: function () {
        if (arguments.length) {
            this._lastValue = arguments[0];
        }
        return this.$el.val.apply(this.$el, arguments);
    },
    changed: function () {
        if (this._lastValue !== this.val()) {
            this.trigger('change', this.val());
            this._lastValue = this.val();
        }
    }
});

var SingleSelect = Backbone.View.extend({
    initialize: function (options) {
        this.datasource = new window.DataSource([], {
            queryEndpoint: options.queryEndpoint,
            maxResults: options.maxResults
        });
        this.datasource.searchAlgorithm = options.matcher;
        this.datasource.parse = options.parser;

        this.queryInput = new QueryInput({el: this.$el});
        this.queryInput.$el.attr('autocomplete', 'off');
        this.queryInput.on('change', this.datasource.query);
        this.queryInput.$el.keydown(_.bind(function (e) {
            if (this.queryResult.$el.is(':visible')) {
                switch (e.which) {
                    case jQuery.ui.keyCode.UP:
                        e.preventDefault();
                        this.queryResult.model.highlightPrevious();
                        break;
                    case jQuery.ui.keyCode.DOWN:
                        e.preventDefault();
                        this.queryResult.model.highlightNext();
                        break;
                    case jQuery.ui.keyCode.ENTER:
                    case jQuery.ui.keyCode.TAB:
                        e.preventDefault();
                        this.queryResult.model.selectHighlighted();
                        break;
                    case jQuery.ui.keyCode.ESCAPE:
                        e.stopPropagation();
                        this.queryResult.model.hide();
                        break;
                }
            }
        }, this)).blur(_.bind(function () {
            setTimeout(_.bind(function () {
                if (this.queryResult.$el.is(':visible')) {
                    this.queryResult.model.hide(null);
                }
            }, this), 200);
        }, this)).focus(_.bind(function () {
            this.queryResult.reposition(this.queryInput);
        }, this));

        this.queryResult = new AutocompleteResults({
            source: this.datasource,
            resultItemTemplate: options.resultItemTemplate
        });
        this.queryResult.model.on('selected', this.queryInput.val, this.queryInput);
    }
});
/*[{!query_input_js_nv3054f!}]*/