AJS.toInit(function ($) {

    var $document = $(document);

    /**
     * Get a trigger for the passed element.
     * @param {jQuery} $el
     * @returns {jQuery}
     */
    function getTrigger($el) {
        return $('[aria-controls="' + $el.get(0).id + '"]');
    }

    /**
     * @HACK
     * Fix for an AUI issue found in 5.8.12 version after upgrading from 5.5.2.
     * So here is a raised issue (https://ecosystem.atlassian.net/browse/AUI-3554)
     *   and once it will be resolved or AUI will be fixed this file should be removed.
     */
    if (!window.MutationObserver && window.skate) {
        skate.init(document.documentElement);
    }

    /**
     * @HACK
     * After upgrading AUI version from 5.5.2 to 5.8.12 we found out that the behaviour of how
     *   the dropdown2 component gets closed was changed. Previously the check was done using mousedown event,
     *   but now AUI plugin uses a click, which sometimes doesn't work because of stopped propagation.
     */
    $document.on('aui-dropdown2-show', function (e) {
        var $dropdown = $(e.target);
        var namespace = _.uniqueId('.aui-fix-ns-');

        $dropdown.one('aui-dropdown2-hide', function () {
            $document.off(namespace);
        });

        $document.on('mousedown' + namespace, function (e) {
            var $target = $(e.target);
            var isTargetDropdown;
            var isTargetDropdownTrigger;

            isTargetDropdown = !!$target.closest($dropdown).length;
            isTargetDropdownTrigger = !!$target.closest(getTrigger($dropdown)).length;

            if (!isTargetDropdown && !isTargetDropdownTrigger) {
                FECRU.UI.hideClosestDropdown2($dropdown);
            }
        });
    });

});