window.FECRU = window.FECRU || {};
FECRU.UAL = FECRU.UAL || {};

AppLinks = window.AppLinks || {};

AppLinks.SPI = AJS.$.extend(AppLinks.SPI || {}, {
    showCreateEntityLinkSuggestion: function () {
        return false;
    }
});

(function ($, namespace, window) {

    var ignoreCookieName = "ignoredAppLinks";

    // Applinks impl for doing OAuth authorizations.  Used by FECRU.AJAX
    var oAuthAuthorizationImpl = (function () {
        function reset() {
            if (window.aouthWindow) {
                window.aouthWindow.close();
            }

            window.oauthCallback = null;
            window.aouthWindow = null;
        }

        function createOAuthCallbackObj(authorizationUri, success, failure) {
            return {
                success: function () {
                    reset();

                    if (success) {
                        success();
                    }
                },
                failure: function () {
                    reset();

                    if (failure) {
                        failure();
                    }
                },
                uri: authorizationUri
            };
        }

        return { // injectable core for mocking
            authorize: function (authorizationUri, success, failure) {
                window.oauthCallback = createOAuthCallbackObj(authorizationUri, success, failure);
                window.aouthWindow = window.open(authorizationUri);
            },
            cancelAuthorization: function (authorizationUri) {
                if (window.oauthCallback && window.oauthCallback.uri === authorizationUri) {
                    reset();
                }
            }
        };
    })();

    function ignoreAppLink(applicationId) {
        var cookieValue = AJS.$.cookie(ignoreCookieName);
        if (!cookieValue) {
            cookieValue = "";
        }

        // set cookie so that anonymous users can at least have error messages suppressed
        cookieValue += (cookieValue.length > 0 ? "," : "") + applicationId;
        AJS.$.cookie(ignoreCookieName, cookieValue, {expires: 365, path: FECRU.pageContext});

        // also set server ignore preference for this applink
        var url = CRU.UTIL.jsonUrlBase() + "/ignoreLinkedApp.do";
        FECRU.AJAX.ajaxDo(url, {appLinkId: applicationId});
    }

    function clearIgnoredAppLinks(onComplete) {
        // clear cookie
        AJS.$.cookie("ignoredAppLinks", null, {path: FECRU.pageContext});

        var url = CRU.UTIL.jsonUrlBase() + "/clearIgnoreFlags.do";
        FECRU.AJAX.ajaxDo(url, {}, function () {
            if (AJS.$.isFunction(onComplete)) {
                onComplete();
            }
        });
    }

    /**
     * Remote exception notifier - display an error message, or prompt the user for authentication with a linked application
     *
     * @method warnRemoteActivityStream
     * @namespace AJS
     * @for AJS
     * @param applicationId {string} the ApplicationId of the remote application
     * @param message {string} a message to display
     * @param authUrl {string} the authorisation url to redirect the user to, if unspecified this method will display the
     * supplied message as an error message
     */
    function warnRemoteActivityStream(applicationId, applicationName, message, authUrl) {


        var cookieValue = AJS.$.cookie(ignoreCookieName);
        var suppressWarning = false;
        if (cookieValue) {
            suppressWarning = cookieValue.indexOf(applicationId) > -1;
        }

        if (authUrl) {
            if (!suppressWarning) {
                var linkId = "provide-credentials-" + applicationId;
                var $warning = AJS.$("<div class='remote-credentials-required-warning stream-notice'><p>" + message + "</p>" +
                    "<a id='" + linkId + "'>Authenticate</a> or <a class='ual-ignore-applink'>ignore authentication requests from " + applicationName + "</a></div>");
                AJS.$(".ual-ignore-applink", $warning).click(function () {
                    FECRU.HOVER.invalidateCache(FECRU.HOVER.CACHE_FOREVER)
                    $warning.slideUp("fast");
                    ignoreAppLink(applicationId);
                });
                AJS.$("#" + linkId, $warning).click(function () {
                    FECRU.OAUTH.authorize(authUrl, oAuthAuthorizationImpl).authorized(function () {
                        window.location.reload();
                    });
                });
                $warning.prependTo(AJS.$("#stream-notice-box"));
            }
        } else {
            if (!suppressWarning) {
                var $error = AJS.$("<div class='remote-error-warning stream-error'><p>" + message + "</p>" +
                    "<a class='ual-ignore-applink'>Ignore errors from " + applicationName + "</a></div>");
                AJS.$(".ual-ignore-applink", $error).click(function () {
                    $error.slideUp("fast");
                    ignoreAppLink(applicationId);
                });
                $error.prependTo(AJS.$("#stream-notice-box"));
            }
        }
    }


    function invalidateCache(issueKey) {
        FECRU.HOVER.invalidateCache(FECRU.HOVER.CACHE_FOREVER, issueKey);
    }

    AJS.$(document).delegate(".issue-hover-ignore-applink", "click", function () {
        var $this = AJS.$(this);
        var appLinkId = $this.attr('data-id');
        ignoreAppLink(appLinkId);
        var issueKey = $this.parents('.jirahover-details').attr('data-key');
        invalidateCache(issueKey);
        AJS.$("#inline-dialog-jira-hover-popup").hide();
    });

    AJS.$(document).delegate(".ual-authenticate", "click", function (e) {
        var $this = AJS.$(this);
        var issueKey = $this.parents('.jirahover-details').attr('data-key');
        invalidateCache(issueKey);
        AJS.$("#inline-dialog-jira-hover-popup").hide();

        FECRU.OAUTH.authorize($(this).attr("href"));

        e.preventDefault();
    });

    $.extend(namespace, {
        ignoreAppLink: ignoreAppLink,
        clearIgnoredAppLinks: clearIgnoredAppLinks,
        warnRemoteActivityStream: warnRemoteActivityStream,
        oAuthAuthorization: oAuthAuthorizationImpl
    });

})(AJS.$, FECRU.UAL, this);
/*[{!applinks_js_efd053e!}]*/