(function ($) {
    AJS.$(document).ready(function () {
        var CrucibleUser = Backbone.Model.extend({});
        CrucibleUser.matcher = function (model, query) {
            var matched = false;
            var names = [];

            names.push(model.get("displaySecondary"));
            names.push(model.get("email"));

            if (model.has("displayPrimary")) {
                var components = model.get("displayPrimary").split(' ');
                var suffix = '';
                for (var i = components.length - 1; i >= 0; i--) {
                    if (i !== components.length - 1) {
                        suffix = ' ' + suffix;
                    }
                    suffix = components[i] + suffix;
                    names.push(suffix);
                }
            }

            _.each(names, function (name) {
                matched = matched || name.toLowerCase().indexOf(query.toLowerCase()) === 0;
            });
            return matched;
        };
        var activeUsersDatasource = new AJS.ProgressiveDataSet([], {
            queryEndpoint: AJS.contextPath() + "/json/fe/activeUserFinder.do?limit=25",
            queryParamKey: "q",
            maxResults: 5,
            model: CrucibleUser,
            matcher: CrucibleUser.matcher
        });

        var userNotFoundResult = [{
            "displayPrimary": "No matching user found",
            "avatarUrl": FECRU.pageContext + "/" + FECRU.staticDirectory + "/2static/images/blank.gif",
            "notFound": true
        }];

        var spinnerTimeout;
        var lastQueryWithNoResults = null;

        var FishEyeUserAutocompleteResults = Backbone.View.extend({
            tagName: 'div',
            id: 'userAutocomplete',
            className: 'aui-dd-parent quick-nav-drop-down',

            initialize: function (options) {
                this.collection = new Backbone.Collection();
                this.collection.bind('reset', this.render, this);
                this.dataSource = options.dataSource;
                this.dataSource.bind('respond', this.processResults, this);
            },

            processResults: function (response) {
                lastQueryWithNoResults = null;
                this.collection.reset(response.results);

                var completed = false;
                if (!response.remoteQuery) {
                    completed = activeUsersDatasource.hasQueryCache(response.query) || !activeUsersDatasource.shouldGetMoreResults(response.results);
                } else {
                    // if this ajax call was the exact query we're after, or its a subset with < max results for the query we're after
                    completed = response.query === response.remoteQuery || (response.query.indexOf(response.remoteQuery) === 0 && !activeUsersDatasource.shouldGetMoreResults(response.results));
                }

                if (completed) {
                    clearTimeout(spinnerTimeout);
                    this.hideSpinner();
                    if (response.query && !response.results.length) {
                        // there is a query with no results, so display a 'user not found' result
                        this.collection.reset(userNotFoundResult);
                        lastQueryWithNoResults = response.query;
                    }
                }
            },

            hideSpinner: function () {
                this.spinnerOn = false;
                this.$el.find(".top-menu-item img").hide();
            },

            showSpinner: function () {
                this.spinnerOn = true;
                this.$el.find(".top-menu-item img").show();
            },

            render: function () {
                var html = "<div class=\"aui-dropdown aui-dropdown-left aui-box-shadow autocomplete autocomplete-links\">" +
                    "<ol class=\"top-menu-item\"><li><a href='#'>" +
                    "<span title='Start typing to search for people...'>" +
                    "<em id=\"mention-autocomplete-hint\"></em><img src=\"" + FECRU.pageContext + '/' + FECRU.staticDirectory + "/2static/images/spinner_003366.gif\"/>" +
                    "</span></a></li>" +
                    "</ol>" +
                    "<ol id=\"mention-autocomplete-user-list\">" +
                    "</ol>" +
                    "<ol class='last' style='display: none;'></ol>" +
                    "</div>";
                this.$el.html(html);
                if (this.spinnerOn) {
                    this.showSpinner();
                } else {
                    this.hideSpinner();
                }
                var $list = this.$("#mention-autocomplete-user-list");
                var $listItems = this.listOfUserResults();
                $listItems.each(function (i, $el) {
                    $list.append($el);
                });
                if ($listItems.get(0)) {
                    this.moveHighlightTo($listItems.get(0));
                } else {
                    this.clearHighlight();
                }
                $("#mention-autocomplete-hint").text(this.currentHint);

                return this;
            },

            spinnerOn: false,

            currentHint: "",

            $currentHighlight: null,

            currentQuery: "",

            setHint: function (hint) {
                this.currentHint = hint;
            },
            listOfUserResults: function () {
                var that = this;

                function spanWithText(s, className) {
                    var options = className ? {"class": className} : {};
                    return $('<span>').attr(options).text(s);
                }

                function createHighlightedSpan(s, className) {
                    var $span = spanWithText("", className);
                    var i = 0;
                    if (that.currentQuery.length > 0) {
                        while (true) {
                            var index = s.substring(i).toLowerCase().indexOf(that.currentQuery.toLowerCase());
                            if (index !== -1) {
                                if (index > 0) {
                                    $span.append(spanWithText(s.substring(i, i + index), "autocomplete-no-highlight"));
                                }
                                $span.append(spanWithText(s.substring(i + index, i + index + that.currentQuery.length), "autocomplete-query-highlight"));
                                i += index + that.currentQuery.length;
                            } else {
                                break;
                            }
                        }
                    }
                    $span.append(spanWithText(s.substring(i), "autocomplete-no-highlight"));
                    return $span;
                }

                return $(this.collection.map(function (model) {
                    var $user = $('<li>');
                    var $img = $('<img>').attr({"src": model.get("avatarUrl")});
                    var $a = $('<a>').attr({});
                    var $span = $('<span>').attr({"title": model.get("displayPrimary")});
                    var $displayNameSpan = createHighlightedSpan(model.get("displayPrimary"), "autocomplete-name autocomplete-displayname");
                    $user.append($img);
                    $user.append($a);
                    $a.append($span);
                    $span.append($displayNameSpan);
                    $user.data("username", model.get("id"));

                    //if userNotFound
                    if (model.get("notFound")) {
                        $user.addClass("not-found");
                        $user.addClass("disabled");
                    } else {
                        $user.click(function () {
                            var $this = $(this);
                            selectUser(that.$textArea, $this.data("username"));
                        });
                    }
                    return $user;
                }));
            },

            selectCurrent: function () {
                if (this.$currentHighlight) {
                    selectUser(this.$textArea, this.$currentHighlight.data("username"));
                }
            },

            highlightNext: function () {
                this.moveHighlightTo(this.$currentHighlight.next());
            },

            highlightPrevious: function () {
                this.moveHighlightTo(this.$currentHighlight.prev());
            },

            clearHighlight: function () {
                this.moveHighlightTo(null);
            },

            moveHighlightTo: function ($el) {
                if (!$el || $el.hasClass('not-found')) {
                    this.$currentHighlight = null;
                    return;
                }
                if ($el && $el.length > 0) {
                    $el.addClass("active");
                    if (this.$currentHighlight) {
                        this.$currentHighlight.removeClass("active");
                    }
                    this.$currentHighlight = $el;
                }
            }
        });

        var _getCaretPosition = function ($textarea) {
            var element = $textarea.get(0);
            if (typeof element.selectionStart === "number") {
                return element.selectionStart
            } else {
                if (document.selection && element.createTextRange) {
                    var range = document.selection.createRange();
                    var start = $textarea.val().length;

                    if (range && range.parentElement() === element) {
                        var len = element.value.length;
                        var normalizedValue = element.value.replace(/\r\n/g, "\n");
                        var textInputRange = element.createTextRange();
                        textInputRange.moveToBookmark(range.getBookmark());
                        var endRange = element.createTextRange();
                        endRange.collapse(false);
                        if (textInputRange.compareEndPoints("StartToEnd", endRange) > -1) {
                            start = len
                        } else {
                            start = -textInputRange.moveStart("character", -len);
                            start += normalizedValue.slice(0, start).split("\n").length - 1
                        }
                    }
                    return start
                }
            }
        };

        var _setCursorPosition = function ($textarea, index) {
            var input = $textarea.get(0);
            if (input.setSelectionRange) {
                input.focus();
                input.setSelectionRange(index, index)
            } else {
                if (input.createTextRange) {
                    var range = input.createTextRange();
                    range.collapse(true);
                    range.moveEnd("character", index);
                    range.moveStart("character", index);
                    range.select()
                }
            }
        };

        var selectUser = function ($textArea, name) {
            if (!name) {
                return;
            }

            var currentSearch = results.currentQuery;

            name = "[~" + name + "]";
            var caretPos = _getCaretPosition($textArea);
            var textAreaContents = $textArea.val();
            $textArea.val(
                textAreaContents.substring(0, caretPos - (currentSearch.length + 1)) +
                name +
                textAreaContents.substring(caretPos));

            _setCursorPosition($textArea, caretPos - (currentSearch.length + 1) + name.length);

            endAutocomplete($textArea);
        };

        var results = new FishEyeUserAutocompleteResults({
            dataSource: activeUsersDatasource
        });

        var findDiv = function () {
            return results.$el;
        };
        var getDiv = function () {
            var $el = findDiv();
            if (!$el.parent()[0]) {
                $('body').append($el);
            }
            return $el;
        };
        var initialHint = "Start typing to search for people...";

        var endAutocomplete = function ($this) {
            $this.data("inMention", false);
            getDiv($this).hide();
            queryLengthChanged("");
        };

        var queryLengthChanged = function (query) {
            results.currentQuery = query;
            if (query.length === 0) {
                results.setHint(initialHint);
                activeUsersDatasource.query(query);
            }
            if (query.length > 0) { // was 2 in confluence
                results.setHint("User suggestions");
            }
            if (query.indexOf(lastQueryWithNoResults) === 0) {
                return;
            }
            if (query.length > 0) {
                if (spinnerTimeout) {
                    clearTimeout(spinnerTimeout);
                }
                spinnerTimeout = setTimeout(function () {
                    results.showSpinner();
                }, 150);
                activeUsersDatasource.query(query);
            }
        };

        var processKeyDown = function (e) {
            var $this = $(this);
            // these keys are processed immediately and are not passed on to the textarea
            if ($this.data("inMention")) {
                if (e.which === jQuery.ui.keyCode.ENTER ||
                    e.which === jQuery.ui.keyCode.TAB) {
                    results.selectCurrent();
                    e.preventDefault();
                } else if (e.which === jQuery.ui.keyCode.UP) {
                    results.highlightPrevious();
                    e.preventDefault();
                } else if (e.which === jQuery.ui.keyCode.DOWN) {
                    results.highlightNext();
                    e.preventDefault();
                } else if (e.which === jQuery.ui.keyCode.ESCAPE) {
                    endAutocomplete($this);
                    e.preventDefault();
                    e.stopPropagation();
                } else if (e.which === jQuery.ui.keyCode.BACKSPACE) {
                    keyPress(e, $this);
                }
            }
        };

        var keyPress = function (e, $textarea) {
            $textarea = $textarea || $(this);
            setTimeout(function () {
                var c = e.which && String.fromCharCode(e.which);
                if (c === '@') {
                    beginAutocomplete($textarea, '');
                } else if (!$textarea.data("inMention")) {
                    return;
                }

                if (e.which === jQuery.ui.keyCode.ESCAPE) {
                    endAutocomplete($textarea);
                    e.preventDefault();
                    e.stopPropagation();
                    return;
                }
                var caret = _getCaretPosition($textarea);
                var username = _getUserNameFromInput($textarea, caret);
                if (username || username === '') {
                    if (results.currentQuery !== username) {
                        queryLengthChanged(username);
                    }
                } else {
                    endAutocomplete($textarea);
                }
            }, 0);
        };

        var _getUserNameFromInput = function ($textarea, caret) {
            if (typeof caret !== "number") {
                caret = _getCaretPosition($textarea)
            }
            return Matcher.getUserNameFromCurrentWord($textarea.val(), caret)
        };

        var beginAutocomplete = function ($textarea, query) {
            results.$textArea = $textarea;
            results.setHint(initialHint);
            getDiv($textarea); // make sure the div is in the DOM before we render
            results.render();
            $textarea.data("inMention", true);

            var pos = $textarea.getCaretPosition(-(query.length));
            var verticalAdjustment = 2;
            var horizontalAdjustment = -6;
            getDiv($textarea).css({
                position: "absolute",
                left: $textarea.offset().left + pos.left + horizontalAdjustment,
                top: $textarea.offset().top + pos.top + verticalAdjustment
            }).show();
        };

        var textareasWithMentionsSelector = ".commentTextarea, #objectives-input > textarea, #review-objectives textarea#description";

        $("body").delegate(textareasWithMentionsSelector, "keydown", processKeyDown)
            .delegate(textareasWithMentionsSelector, "keypress", keyPress);

        function inside(targetElement, container) {
            var containerElement = container.get(0);
            return (targetElement === containerElement) || jQuery.contains(containerElement, targetElement);
        }

        $(document).bind("click focusin mousedown", function (event) {
            var target = event.target;
            if (results.$textArea && !inside(target, getDiv(results.$textArea))) {
                endAutocomplete(results.$textArea);
            }
        });

        var Matcher = {
            AT_USERNAME_START_REGEX: /^@(.*)/i,
            AT_USERNAME_REGEX: /[^\[]@(.*)/i,
//            WIKI_MARKUP_REGEX:/\[[~@]+([^~@]*)/i,
            ACCEPTED_USER_REGEX: /\[~[^~\]]+\]/i,

            getUserNameFromCurrentWord: function (text, caretPosition) {
                var before = text.substr(0, caretPosition);
                var lastWordStartIndex = this.getLastWordBoundaryIndex(before, false);
                var prevChar = before.charAt(lastWordStartIndex - 1);
                var currentWord;
                var foundMatch;

                if (!prevChar.length || !/\w/i.test(prevChar)) {
                    currentWord = this._removeAcceptedUsernames(before.substr(lastWordStartIndex));
                    if (/[\r\n]/.test(currentWord)) {
                        return false
                    }
                    jQuery.each([this.AT_USERNAME_START_REGEX, this.AT_USERNAME_REGEX], function (i, regex) {
                        var match = regex.exec(currentWord);
                        if (match) {
                            foundMatch = match[1];
                            return false
                        }
                    })
                }
                return ((foundMatch || foundMatch === '') && this.lengthWithinLimit(foundMatch, 2)) ? foundMatch : false
            }, lengthWithinLimit: function (input, length) {
                var parts = jQuery.trim(input).split(/\s+/);
                return parts.length <= ~~length
            }, getLastWordBoundaryIndex: function (text, strip) {
                var lastAt = text.lastIndexOf("@");
                var lastWiki = text.lastIndexOf("[~");

                if (strip) {
                    lastAt = lastAt - 1;
                    lastWiki = lastWiki - 1
                }
                return (lastAt > lastWiki) ? lastAt : lastWiki
            }, _removeAcceptedUsernames: function (phrase) {
                var match = this.ACCEPTED_USER_REGEX.exec(phrase);
                if (match) {
                    return phrase.split(match)[1]
                } else {
                    return phrase
                }
            }
        };

    });
})(AJS.$);
/*[{!fisheye_mentions_js_nxsj53b!}]*/