window.FE = window.FE || {};
FE.UI = FE.UI || {};
(function ($) {
    /**
     * Converts an id to a jquery object.
     *
     * @param el an element id, a jquery id selector (starting with '#'), or a jquery elem
     * @return an object
     */
    var ensureObject = function (el) {
        if (typeof el === "string") {
            if (el.charAt(0) !== "#") {
                el = '#' + el;
            }
            el = AJS.$(el);
        }

        return el;
    };

    /**
     * Returns the minimum height of an element (el) so that it is always at least at
     * the height of its parent element, and optionally takes into account the height/s of
     * any siblings when el is not specified as onlyChild.
     *
     * onlyChild should be used either where el has no sibling element, or where you want
     * el to not consider its siblings - where el and siblings might be floated, for example.
     *
     */
    var elementGetMinHeight = function (el, onlyChild) {
        var element = ensureObject(el);
        if (element.length === 0) {// If element doesn't exist on the page a length of 0 will be returned
            return 0
        }

        var parentHeight = AJS.$(window).height();
        var siblingsHeight = 0;

        if (!onlyChild) {
            var siblings = element.siblings();
            var siblingsCount = siblings.size();

            for (var i = 0; i < siblingsCount; i += 1) {
                var sibling = siblings.eq(i);
                if (sibling.is(":visible") && sibling.css('position').toLowerCase() !== 'absolute') {
                    siblingsHeight += sibling.outerHeight(true);
                }
            }
        }

        return parseInt(parentHeight, 10) - parseInt(siblingsHeight, 10);
    };
    FE.elementGetMinHeight = elementGetMinHeight;

    /**
     * Sets the minimum height of an element (el) to "height" and works hand in hand with
     * elementGetMinHeight.
     *
     * Rather than being part of a larger function which might set _and_ get, this usage
     * allows other functions to utilize the method, without having to determine el's parent and/or
     * sibling elements.
     *
     */
    var elementSetMinHeight = function (el, height) {
        var element = ensureObject(el);

        element.css({
            minHeight: outerHeightProperties(el, height)
        })
    };

    /**
     * Sets the height of an element (el) to "height" and works hand in hand with
     * elementGetMinHeight.
     *
     * Rather than being part of a larger function which might set _and_ get, this usage
     * allows other functions to utilize the method, without having to determine el's parent and/or
     * sibling elements.
     *
     */
    var elementSetHeight = function (el, height) {
        var element = ensureObject(el);

        element.height(outerHeightProperties(el, height))
    };

    /**
     * Determines whether an element (el) has style proprties that affect its outerHeight(true) value
     *
     * You can't set outerHeight so we need to take outerHeight effecting properties in to account, so we
     * accept a height parameter, test for any "outer" properties, and subtract any we find from the height given
     *
     */

    var outerHeightProperties = function (el, height) {
        var element = ensureObject(el);
        var outerProperties = ["borderTopWidth", "borderBottomWidth", "marginTop", "marginBottom", "paddingTop", "paddingBottom"];
        var properties = 0;

        for (var i = 0, l = outerProperties.length; i < l; i += 1) {
            var property = parseInt(element.css(outerProperties[i]), 10);

            if (property) {
                properties += property;
            }
        }

        return height - properties;
    };
    FE.outerHeightProperties = outerHeightProperties;

    var ieWidth = -1;
    var ieHeight = -1;

    var scrollbarWidth;
    var getScrollbarWidth = function () {
        if (!scrollbarWidth) {
            var div = AJS.$('<div style="width:50px;height:50px;overflow:hidden;position:absolute;top:-200px;left:-200px;"><div style="height:100px;"></div>');
            // Append our div, do our calculation and then remove it
            AJS.$('body').append(div);
            var w1 = AJS.$('div', div).innerWidth();
            div.css('overflow-y', 'scroll');
            var w2 = AJS.$('div', div).innerWidth();
            AJS.$(div).remove();
            scrollbarWidth = w1 - w2;
        }
        return scrollbarWidth;
    };

    var calculateStickyPoint = function () {
        STALKING_HEADER.stickyPoint = $('#columns').position().top
            + $('#header').outerHeight(true) + $('.slurp-warning').height();
    };

    var panelsSetMinHeight = function (forceIEResize) {
        if (AJS.$("#atlas").length > 0) {//makes that we only try to force the element sizing on pages that can benefit from it
            if (AJS.$("#columns").length > 0) {//threePanelPAgeContent.tag used
                var viewportHeight = $(window).height();
                var viewportWidth = $(window).width();

                if (FECRU.isChangesetPage) {

                    var $page = $('#page');

                    // calculate the fixed header of the content
                    STALKING_HEADER.commonHeaderHeight = $('.page-sub-header').outerHeight(true); // common fixed header height
                    STALKING_HEADER.contentHeaderHeight = $('#toolbar').outerHeight(true);
                    STALKING_HEADER.sidebarHeaderHeight = 0;
                    STALKING_HEADER.viewportHeight = viewportHeight;
                    var borderWidth = 1;

                    calculateStickyPoint();

                    // the height of footer should also be taken off
                    STALKING_HEADER.footerHeight = $('#footer').outerHeight(true);

                    // get the content height
                    var contentSectionHeight = viewportHeight - STALKING_HEADER.footerHeight - borderWidth;
                    var sidebarSectionHeight = contentSectionHeight - STALKING_HEADER.sidebarHeaderHeight
                        - borderWidth;
                    var contentHeight = contentSectionHeight - STALKING_HEADER.contentHeaderHeight;

                    elementSetHeight("content-navigation-panel", contentSectionHeight);
                    elementSetHeight(AJS.$('#content-resizable'), sidebarSectionHeight);
                    elementSetHeight(AJS.$('#panel-target'), contentHeight);
                } else if (FECRU.isSourcePage) {
                    var columnsHeight = $(window).height() - $('#content > .page-sub-header').outerHeight() - $('#footer').height();
                    var sidebarHeight = columnsHeight - $('#content-column-panel > .content-view').outerHeight();

                    $('#columns').height(columnsHeight);
                    $('#content-navigation-panel').height(sidebarHeight - 2); // 2 for border widths
                } else {
                    var isHorizontalScrollShowing = viewportWidth < AJS.$('#columns').width();

                    var headerHeight = 0;
                    var $header = $('header.aui-page-header');

                    if ($header.length) {
                        headerHeight = $header.outerHeight(true) + ($('div.page-sub-header').outerHeight(true) || 0);
                    } else {
                        headerHeight = $('#content-fixed').outerHeight(true)
                    }
                    headerHeight += $('nav.aui-navgroup-horizontal').outerHeight(true) || 0;

                    elementSetHeight("columns", elementGetMinHeight("#atlas", false)
                        - headerHeight
                        - (isHorizontalScrollShowing ? getScrollbarWidth() : 0)
                    );

                    // Using the specified height, not the computed height (which is what css('height') returns)
                    // So we have to go native (jQuery doesn't have a way to get the actual style for the element).
                    var columnsEl = document.getElementById("columns");
                    var columnHeight = parseInt(columnsEl.style.height, 10) // not .height()
                        - AJS.$("#content-sidebar-head").outerHeight() // Less the branch selector
                        - 2; // Less 2 pixels (from a border i think. Its cheaper hard coding this

                    // If we are on the annotation/diff view, restrict, otherwise let it expand
                    if (FECRU.restrictToWindowHeight) {
                        elementSetHeight("content-navigation-panel", columnHeight);
                        elementSetHeight("column-content", columnHeight);
                    } else {
                        elementSetMinHeight("content-navigation-panel", columnHeight);
                    }
                }
            } else if (AJS.$("#content-single").length > 0) {
                elementSetMinHeight("content-single", AJS.$(window).height()
                    - AJS.$('#header').outerHeight(true)
                    - AJS.$('#footer').outerHeight(true)
                );
            }
            AJS.trigger('fe-page-resize');
            FE.UI.setupStalkingHeader();
        }
    };

    /**
     * Bind a callback that fires when resizing is completed on matching elements.
     *
     * A resize is considered complete after completionDelay ms have passed since
     * the last resize event.
     *
     * This prevents firing the resize event handler multiple times before the resize
     * is actually complete.
     *
     * This should only be being utilised by Snippets pages and TODO deprecate in favour
     * of elementSetMinHeight
     */

    var hasSetupPageFillHeight = false;
    FE.setupPageFillHeight = function ($changeHeight, useMinHeight) {
        if (hasSetupPageFillHeight) {
            return;
        }

        var offset = ($changeHeight) ? $changeHeight.offset().top : 34;

        $changeHeight = $changeHeight || AJS.$("#atlas");
        hasSetupPageFillHeight = true;
        var onResize = function () {
            var windowHeight = AJS.$(window).height();
            var footerHeight = AJS.$("#footer").outerHeight();
            var borderAndPadding = $changeHeight.outerHeight() - $changeHeight.height();

            $changeHeight.css(useMinHeight ? 'min-height' : 'height', windowHeight - footerHeight - offset - borderAndPadding);
        };
        onResize();
        FECRU.UI.setCompletedResizeTimeout(window, onResize);
    };

    var columnResize = function (min) {
        AJS.$("#content-resizable").resizable({
            ghost: true,
            handles: "e",
            maxWidth: 600,
            minWidth: min || 310,
            start: function () {
                AJS.$(".tearout-tabs").append(AJS.$(document.createElement("div")).addClass("ui-resizable-helper"));
            },
            stop: function () {
                AJS.$(".tearout-tabs").children(".ui-resizable-helper").remove();
                AJS.$('#content-sidebar').css('width', AJS.$(this).css('width'));
                AJS.trigger("sidebar-resize");
            }
        });

        // This is being done on mousedown/mouseup instead of resizable.start/stop because of
        // strange behavior in Chrome (possibly others). The cursor switches to text during resize
        // instead of remaining e-resize. I don't know why.
        var selector = "#content-resizable .ui-resizable-handle, #content-shield, .shielded";
        AJS.$(document).delegate(selector, "mousedown", function () {
            AJS.$("html").addClass("shielded");
        }).delegate(selector, "mouseup", function () {
            AJS.$("html").removeClass("shielded");
        });
    };

    var setupWatch = function () {
        var $watchform = AJS.$("#watchform");
        var eventName = "click.watchform";
        if ($watchform.length > 0) {
            var $input = $watchform.children("input");
            AJS.$(".watch-on", $watchform).unbind(eventName).bind(eventName, function (evnt) {
                evnt.preventDefault();
                $input.val('off');
                $watchform.submit();
            });
            AJS.$(".watch-off", $watchform).unbind(eventName).bind(eventName, function (evnt) {
                evnt.preventDefault();
                $input.val('on');
                $watchform.submit();
            });
        }
    };

    var reloadFilePaneAndHeader = function (href) {
        var origUrl = AJS.$("#origUrl").val();
        var $spinner = AJS.$("#file-table-spinner");
        $spinner.removeClass('hidden');
        FECRU.AJAX.ajaxDo(FECRU.pageContext + "/json/fe/loadFilePane.do", {
            href: href,
            origUrl: origUrl
        }, function (resp) {
            if (resp.worked) {
                var replacement = AJS.$.clean([resp.fileTable], document);
                AJS.$("#browse-table").replaceWith(replacement);
                AJS.$("#dirlist-toolbar-bar").replaceWith(resp.taskBarBar);
                AJS.$("header.aui-page-header .aui-page-header-main > .header").replaceWith(resp.contentTitle);

                setupWatch();
                FECRU.RSS.setupRSSDialog();
            }
            $spinner.addClass('hidden');
        }, false);
    };

    /**
     * Find a link in the directory tree by its href
     */
    var $findLink = function (href) {
        return AJS.$("#navigation-tree").find("a.pathLink[href='" + href + "']");
    };

    FE.browseDirectoryPathLinkFunction = function (event) {
        var $node = AJS.$(event.target);
        var href = $node.attr("href");
        var toggled = function () {
        };
        var self = FE.browseDirectoryPathLinkFunction;
        if ($node.hasClass("browse-directory")) {
            // find the node in the tree with the same href as us
            var $selectedLink = $findLink(href);
            FECRU.BROWSE.selectLink($selectedLink, toggled, self);
        } else {
            FECRU.BROWSE.selectLink($node, toggled, self);
        }
        reloadFilePaneAndHeader(href);
        return false;
    };

    FE.setupTable = function (prefix, rowClickFn, extractionFn) {
        FE.resetupTable(prefix, extractionFn);
        FECRU.UI.tableRowClick(prefix, rowClickFn);
    };

    FE.resetupTable = function (prefix, extractionFn) {
        columnResize();
        FECRU.UI.tableSort(prefix, extractionFn);
    };

    FE.toggleTabs = function () {
        AJS.$(document).delegate(".tearout-tabs li", "click", function () {
            var active = AJS.$(this).hasClass("tearout-active") ? true : null;
            var tab = AJS.$(this).attr("class").split("-")[1];
            var panel = "#panel-" + tab;
            var content = AJS.$('#content');

            AJS.$(".tearout-tabs li").each(function () {
                AJS.$(this).removeClass("tearout-active");
                AJS.$(this).children("a").unbind();
            });

            AJS.$(".panel-tearout", "#content-navigation").each(function () {
                AJS.$(this).addClass("hidden");
            });
            // preference will be null if we are ignoring preferences
            var preference = AJS.$(this).children("input").val();
            if (active) {
                content.addClass('collapsed-sidebar');
                // hiding everything
                if (preference) {
                    FECRU.PREFS.setPreference("shp", "N");
                }
                AJS.trigger('sidebar-collapsed');
            } else {
                AJS.$(this).addClass("tearout-active");
                var wasCollapsed = content.hasClass('collapsed-sidebar');
                content.removeClass('collapsed-sidebar');
                AJS.$(panel).removeClass("hidden");
                if (preference) {
                    FECRU.PREFS.setPreferences({slp: preference, shp: "Y"});
                }
                wasCollapsed && AJS.trigger('sidebar-expanded');
            }
            // resize the pane when in changeset view
            if (AJS.$('#section-changeset-view').length > 0) {
                AJS.$(window).resize();
            }
        });
    };

    var hasSetupPanes = false;

    FE.setupPanes = function () {
        if (!hasSetupPanes) {
            columnResize(310);
            hasSetupPanes = true;
        }

        var $bottomToolbar = AJS.$("div.toolbar-bottom");

        if ($bottomToolbar.size() && $bottomToolbar.offset().top < AJS.$(window).height()) {
            $bottomToolbar.hide();
        }
    };

    FE.streamMoreFocus = function () {
        AJS.$(document).delegate("#stream a.more", "click", function () {
            AJS.$(this).closest(".stream").addClass("stream-focus");
            AJS.$("body").one("click", function () {
                AJS.$("#stream").find(".stream").removeClass("stream-focus");
            });
        });
    };

    var hasSetupStalkingHeader = false;
    var STALKING_HEADER = {
        stickyPoint: 0,
        scrollbarZone: 10,
        footerHeight: 0,
        contentHeaderHeight: 0,
        viewportHeight: 0,
        previousScrollType: '',
        changeScrollTypeTimer: undefined
    };
    /**
     * the function should be called when:
     *  size of content changed
     *
     * @param $targetArea
     */
    FE.UI.setupStalkingHeader = function () {
        var recountBodyHeight = function () {
            var contentHeight = $target.children('.stream').outerHeight(true);
            var $body = $('body');
            $body.css('height', Math.max(contentHeight + STALKING_HEADER.stickyPoint
                + STALKING_HEADER.footerHeight
                + STALKING_HEADER.scrollbarZone
                + STALKING_HEADER.contentHeaderHeight,
                STALKING_HEADER.stickyPoint + STALKING_HEADER.viewportHeight));
        };

        if (FECRU.isChangesetPage) {
            var $columns = $('#columns');
            var $window = $(window);
            var $target = $('#panel-target');
            var $footer = $('#footer');
            var $pageSubHeader = $('.page-sub-header');
            var $page = $('#page');


            if (!hasSetupStalkingHeader) {
                var scrollItem = function ($item, value) {
                    $item.scrollTop(value);
                };

                // handle the funny "frozen" scrollbar problem in chrome
                // todo: need to review this some time later review@2014-10 we should remove it once chrome has the issue fixed
                setTimeout(function () {
                    $window.scrollTop(1);
                    $window.scrollTop(0);
                }, 0);

                /**
                 * The previous scroll type is for preventing cycle-calling the scroll event handlers.
                 * @param type 'page' | 'content'
                 * @returns {boolean} true if the event is valid to be run, false if the event handler should not be triggered
                 */
                STALKING_HEADER.setPreviousScrollType = function (type, forceScroll) {
                    if (!forceScroll && STALKING_HEADER.previousScrollType && STALKING_HEADER.previousScrollType !== type) {
                        return false;
                    }

                    STALKING_HEADER.previousScrollType = type;
                    clearTimeout(STALKING_HEADER.changeScrollTypeTimer);
                    STALKING_HEADER.changeScrollTypeTimer = setTimeout(function () {
                        STALKING_HEADER.previousScrollType = '';
                    }, 300);
                    return true;
                };

                // binding scrolling event here
                STALKING_HEADER.windowScrollTopCallback = _.throttle(function () {
                    if (!STALKING_HEADER.setPreviousScrollType('page')) {
                        return;
                    }
                    var scrollTop = $window.scrollTop();
                    var $target = $('#panel-target');

                    if (scrollTop > STALKING_HEADER.stickyPoint) {

                        var contentScrollTop = scrollTop - STALKING_HEADER.stickyPoint;
                        $target.scrollTop(contentScrollTop);
                        $page.scrollTop(STALKING_HEADER.stickyPoint);
                    } else {
                        $target.scrollTop(0);
                        $page.scrollTop(scrollTop);
                    }
                }, 20, {
                    trailing: true
                });

                /**
                 * forceScroll - when the file is changed, we need to force synchronise the scrollbars
                 * @type {*}
                 */
                STALKING_HEADER.panelScrollTopCallback = _.throttle(function (e, forceScroll) {
                    if (!STALKING_HEADER.setPreviousScrollType('content', forceScroll)) {
                        return;
                    }
                    var $target = $('#panel-target');
                    var targetScrollTop = $target.scrollTop();

                    $page.scrollTop(STALKING_HEADER.stickyPoint);
                    $window.scrollTop(targetScrollTop + STALKING_HEADER.stickyPoint);
                }, 30, {
                    trailing: true
                });

                FE.UI.scrollPanelTarget = function (forceScroll) {
                    STALKING_HEADER.panelScrollTopCallback(null, forceScroll);
                };

                $window.scroll(STALKING_HEADER.windowScrollTopCallback);
                hasSetupStalkingHeader = true;
            }

            $('#panel-target')
                .unbind('scroll.stalking-header')
                .bind('scroll.stalking-header', function (e, force) {
                    var $self = $(this);
                    var selfScrollTop = this.scrollTop;

                    if ($self.data('lastScrollTop') === selfScrollTop) {
                        return;
                    }
                    $self.data('lastScrollTop', selfScrollTop);

                    STALKING_HEADER.panelScrollTopCallback(e, force);
                })
                .data('lastScrollTop', 0);

            $(document).on('aui-message-close', function (event, message) {
                // Once again - trick to detect whether analytics message has been closed
                if (typeof message === 'undefined') {
                    calculateStickyPoint();
                    recountBodyHeight();
                }
            });
            recountBodyHeight();
            STALKING_HEADER.windowScrollTopCallback();
        }
    };

    AJS.$(function () {
        // Give a warning if firebug is running
        FECRU.UI.warnAboutFirebug(function () {
            AJS.$(window).resize();
        });

        panelsSetMinHeight();
        // this lazy repaint is to fix the problem in ie and in same case the nav height cannot be got correctly
        setTimeout(function () {
            panelsSetMinHeight(true);
        }, 0);

        var panelsSetMinHeightWithThrottle = _.throttle(panelsSetMinHeight, 200, {
            trailing: true
        });
        $(window).resize(panelsSetMinHeightWithThrottle);

        var events = [
            'barracuda-ui-updated', 'commit-message-toggled'
        ];
        AJS.bind(events.join(' '), panelsSetMinHeightWithThrottle);

        //setup the watch links
        setupWatch();

        FE.setupPanes();

        if (!AJS.$.support.opacity) {
            FE.streamMoreFocus();
        }
    });
})(AJS.$);
/*[{!fisheye_ui_js_2o9r52d!}]*/