(function ($, _, AJS) {

    var initContentScrollTop = false;
    var CONTENT_MARGIN_TOP = 10;

    function recordNeedScroll(e, contentScrollTop) {
        initContentScrollTop = contentScrollTop;
    }

    if (window.top === window) {
        AJS.bind('scroll-content', recordNeedScroll);
    }

    var initStalkingHeaders = (function () {
        var isSticky = false;
        var dimensions = {
            visibleHeaderHeight: 0,
            sourceContentHeader: 0,
            footerHeight: 0,
            switchToStickyPoint: 0
        };

        var elements = {
            iframe: undefined,
            scrollable: undefined
        };

        var initElements = function () {
            elements.iframe = $('#file-view-source-content').get(0);
            elements.$window = $(window);
            elements.$body = $(document.body);
            elements.page = document.getElementById('page');
            elements.$page = $(elements.page);
        };

        var initDynamicElements = function () {
            var fileViewResize = function () {
                var iframeHeight = $(elements.iframe).height();
                elements.scrollable = elements.iframe.contentDocument.getElementById('to-box');
                if (!elements.scrollable) {
                    elements.scrollable = elements.iframe.contentDocument.body;
                }
                if (elements.scrollable) {
                    var scrollableHeight = elements.scrollable.scrollHeight;
                    elements.$body.height(dimensions.switchToStickyPoint + dimensions.visibleHeaderHeight +
                        dimensions.sourceContentHeader + dimensions.footerHeight +
                        (scrollableHeight < iframeHeight ? iframeHeight : scrollableHeight));
                    // to prevent from moving page back to scrollTop=0 due to window resize
                    onScroll();
                }
            };

            AJS.bind('file-view-resize', fileViewResize);

            AJS.bind('barracuda-ui-updated', function () {
                initStaticDimensions();
                fileViewResize();
            });

            $(document).on('aui-message-close', function (event, message) {
                // Once again - trick to detect whether analytics message has been closed
                if (typeof message === 'undefined') {
                    initStaticDimensions();
                    fileViewResize();
                    onScroll();
                }
            });
        };

        var initStaticDimensions = function () {
            dimensions.visibleHeaderHeight = $('#content > .page-sub-header').outerHeight() +
                $('#content > .barracuda-page-message').outerHeight() +
                $('#content-column-panel > .content-view').outerHeight();
            dimensions.sourceContentHeader = $('#toolbar').outerHeight();
            dimensions.footerHeight = $('#footer').height();

            dimensions.switchToStickyPoint = $('#content > table').offset().top - CONTENT_MARGIN_TOP;
        };

        var initScroll = function () {
            var throttleOnScroll = _.throttle(onScroll, 20);
            elements.$window
                .on('scroll', throttleOnScroll);

            if (window.top === window) {
                AJS.unbind('scroll-content', recordNeedScroll);
                AJS.bind('scroll-content', _.throttle(function (e, contentScrollTop) {
                    scrollContent(contentScrollTop);
                }, 20));
            }
        };

        var movePage = function (position) {
            elements.page.scrollTop = position;
        };

        var skipAutoScroll = false;
        var scrollContent = function (position) {
            skipAutoScroll = true;
            var scrollTop = dimensions.switchToStickyPoint + position;
            movePage(dimensions.switchToStickyPoint);
            elements.$window.scrollTop(scrollTop);
        };

        var onScroll = function () {
            if (skipAutoScroll) {
                skipAutoScroll = false;
                return;
            }
            if (initContentScrollTop !== false) {
                initContentScrollTop = false;
                scrollContent(initContentScrollTop);
                return;
            }
            var windowScrollTop = elements.$window.scrollTop();

            if (windowScrollTop >= dimensions.switchToStickyPoint) {
                movePage(dimensions.switchToStickyPoint);
                if (!isSticky) {
                    isSticky = true;
                    elements.$body.trigger('sticky-headers-change', true);
                }
                if (elements.scrollable) {
                    elements.scrollable.scrollTop = windowScrollTop - dimensions.switchToStickyPoint;
                }
            } else {
                movePage(windowScrollTop);
                if (isSticky) {
                    isSticky = false;
                    elements.$body.trigger('sticky-headers-change', false);
                    if (elements.scrollable) {
                        elements.scrollable.scrollTop = 0;
                    }
                }
            }
        };

        return function () {
            initElements();
            initStaticDimensions();
            initDynamicElements();
            initScroll();
        };
    })();

    $(initStalkingHeaders);
})(AJS.$, _, AJS);
/*[{!fisheye_source_stalking_headers_js_2svh52c!}]*/