if (!FE.CHANGESET) {
    FE.CHANGESET = {};
}
(function (eventBusProvider) {
    var isInitialised = false;
    var currentPageNo = 0;

    /**
     * Set a property to indicate that the live events etc for the changeset page have been set up
     * @param newValue
     */
    var initialised = function (newValue) {
        if (newValue === undefined) {
            return isInitialised;
        }
        isInitialised = newValue;
        return newValue;
    };

    var pages = {};
    var pagesRequested = {};
    var currentPageRequest;

    var reloadChangesetPage = function (page, fileReloadCallback) {
        currentPageRequest = page;
        var beforeAjax = function () {
            var $panelTarget = AJS.$("#panel-target");
            var replacement = AJS.$('<div id="panel-target"><div></div></div>');
            FECRU.AJAX.startSpin(replacement.children('div'), 'source', true);
            replacement.css('height', $panelTarget.css('height'));
            $panelTarget.replaceWith(replacement);
        };

        var done = function (replacement) {
            if (currentPageRequest === page) {
                var $panelTarget = AJS.$("#panel-target");
                replacement.css('height', $panelTarget.css('height'));
                replacement.css('width', $panelTarget.css('width'));
                $panelTarget.replaceWith(replacement);
                setCurrentPageNo(page);
            }
        };
        var complete = function (isSameFile) {
            if (fileReloadCallback) {
                fileReloadCallback(isSameFile, currentPageRequest);
            } else {
                _onFileSelected(isSameFile, currentPageRequest);
            }
        };
        ajaxLoadChangeset(page, beforeAjax, done, complete);
    };

    var ajaxLoadChangeset = function (page, beforeAjax, done, complete) {
        if (page < 1 || page > getNoOfPages()) {
            return;
        }
        var csid = AJS.$("#csid").val();
        var currentPage = getCurrentPageNo();
        if (currentPage !== page) {
            var replacement = pages[page];
            if (replacement) {
                done && done(replacement);
                if (complete) {
                    complete(false);
                }
            } else {
                pagesRequested[page] = true;
                beforeAjax && beforeAjax();
                var params = {href: AJS.$("#baseClUrl").val(), csid: csid, pageNum: page};
                FECRU.AJAX.ajaxDo(FECRU.pageContext + "/json/fe/loadChangesetPage.do", params, function (resp) {
                    if (resp.worked) {
                        var replacement = AJS.$(AJS.$.clean([resp.changesetPage], document));
                        pages[page] = replacement;
                        done && done(replacement);
                        if (complete) {
                            complete(false);
                        }
                    }
                }, false);
            }
        } else {
            if (complete) {
                complete(true);
            }
        }
    };

    function getCurrentPageNo() {
        return currentPageNo;
    }

    function getNoOfPages() {
        return parseInt(AJS.$("#noOfPages").val(), 10);
    }

    function setNavClass(selector, enabled) {
        var links = AJS.$("span.cs-page a").filter(selector);
        if (enabled) {
            links.removeClass("disabled");
        } else {
            links.addClass("disabled");
        }
    }

    function setCurrentPageNo(newPageNo) {
        currentPageNo = newPageNo;
        setNavClass(".pagination-back, .pagination-first", newPageNo !== 1);
        setNavClass(".pagination-next, .pagination-last", newPageNo !== getNoOfPages());
    }

    function getAttrValue(node, name) {
        return node.children("input[name='" + name + "']").val();
    }

    FE.CHANGESET.changesetFileLinkFn = function (event) {
        var $node = AJS.$(event.target);
        if ($node.is('.fileLink')) {
            var $next = $node.closest('.file-li');
        } else {
            $next = FE.CHANGESET.getNextFile('#tree-root .file-li', $node);
        }
        FE.CHANGESET.selectNextFile($next, 1, 1);
        return false;
    };

    FE.CHANGESET.selectNextFile = function ($next, before, after, fileReloadCallback) {
        var $prev = AJS.$('#tree-root').find('.focused.tree-li').removeClass('focused');
        if ($prev.size()) {
            cancelPrevHightlights($prev.children('span'));
        }

        $next.addClass('focused');

        var $node = $next.children('span.file').children('a.fileLink:first');
        if ($node == null || $node.length === 0) {
            return false;
        }

        var page = parseInt(getAttrValue($node, "page"), 10);

        eventBusProvider().trigger('source-code:hidden', {key: page});

        reloadChangesetPage(page, fileReloadCallback);
        before = before || 0;
        after = after || 0;
        for (var i = 1; i <= before && page - i >= 1; i++) {
            if (!pagesRequested[page - i]) {
                ajaxLoadChangeset(page - i);
            }
        }
        var noOfPages = getNoOfPages();
        for (i = 1; i <= after && page + i <= noOfPages; i++) {
            if (!pagesRequested[page + i]) {
                ajaxLoadChangeset(page + i);
            }
        }

        return true;
    };

    FE.CHANGESET.changesetPathLinkFn = FE.CHANGESET.changesetFileLinkFn;

    FE.CHANGESET.changesetSubTreeArgs = function ($node) {
        return {csid: AJS.$("#csid").val()}
    };

    /**
     * Sets up the two detail blocks in the Changeset page and establishes the click responses and stickiness
     */
    function augmentDetails() {
        var $details = AJS.$("#changeset-details");
        var $terse = $details.children("h1.details-terse").children("span");
        var $verbose = $details.children("div.details-verbose");
        var $links = $details.find("a");
        var expandCsHeaderPref = 'xcsh';

        /**
         * Targets the single line "heading" and adds a click response to reveal the full details.
         * The !e.altKey checks the event properties to ensure that the alt/option key isn't being pressed. This
         * facilitates copy + paste actions
         */
        $terse.click(function (e) {
            if (!e.altKey && e.target.tagName.toLowerCase() !== "a") {
                $details.addClass('expand');
                FECRU.PREFS.setPreference(expandCsHeaderPref, 'Y');
            }
        });

        /**
         * Targets the multi line "details" and adds a click response to return to heading only.
         * The !e.altKey checks the event properties to ensure that the alt/option key isn't being pressed. This
         * facilitates copy + paste actions
         * The e.target checks ensure that only the text of the first line of the details will trigger the toggle
         */
        $verbose.click(function (e) {
            var target = e.target.tagName.toLowerCase();
            if (!e.altKey && target !== "a" && target !== "div") {
                if (target !== "p" || AJS.$(e.target).is(":first-child")) {
                    $details.removeClass('expand');
                    FECRU.PREFS.setPreference(expandCsHeaderPref, 'N');
                }
            }
        });

        /**
         * stops the link from firing if the user is trying to copy the link and also
         * stops the changelog commit message toggling so it won't bump if you're trying
         * to leave the page.
         */
        $links.click(function (e) {
            var $this = AJS.$(this);
            if (e.altKey || $this.hasClass('jira-hover-trigger') || $this.parent().hasClass('jira-hover-trigger')) {
                e.preventDefault();
                return true;
            }

            e.stopPropagation();
        });
    }

    /**
     * Maintains the UI show/hide principles by checking to see whether this element has any non-whitespace content
     * and displaying if any is found.
     */

    function showCustomDetails() {
        var $custom = AJS.$("td.custom-details");
        var $customDetails = $custom.find("dd");
        var customDetailsHtml = $customDetails.html();
        var details = false;

        if (customDetailsHtml && customDetailsHtml.replace(/\s/g, "").length > 0) {
            $custom.show();
        }
    }


    var _onFileSelected = function () {
    };

    // This is for binding the default onFileSelected callback.
    // The callback function will be triggered after reloadChangesetPage() successfully loads a file.
    FE.CHANGESET.bindFileSelected = function (callback) {
        _onFileSelected = callback;
    };

    FE.CHANGESET.init = function () {
        if (!initialised()) {
            var selectNextFile = false;
            if (getNoOfPages() > 0) {
                var selectNextFile = FE.CHANGESET.selectNextFile(AJS.$('#tree-root .file-li:first'), 0, 4);
            }

            if (!selectNextFile) {
                var $panelTarget = AJS.$("#panel-target");
                $panelTarget.addClass("inactive");
                $panelTarget.find(" .source").removeClass("spinner");
            }
            augmentDetails();
            showCustomDetails();

            var ajsFecruUi = FECRU.UI;

            ajsFecruUi.registerMetadataExpanders(AJS.$(".changeset-head"));

            initialised(true)
        }
    };

    FE.CHANGESET.getFirstFile = function (selector) {
        return FE.CHANGESET.getNextFile(selector);
    };

    FE.CHANGESET.getLastFile = function (selector) {
        return FE.CHANGESET.getPrevFile(selector);
    };

    FE.CHANGESET.getNextFile = function (selector, $focused) {
        var index;
        var items = jQuery(selector).add($focused);

        if (!$focused || $focused.length === 0) {
            $focused = jQuery(selector + ":first");
        } else {
            index = jQuery.inArray($focused.get(0), items);
            if (index < items.length - 1) {
                index = index + 1;
                $focused = items.eq(index);
            } else {
                $focused = jQuery(selector + ":first");
            }
        }
        return $focused;
    };

    FE.CHANGESET.getPrevFile = function (selector, $focused) {
        var index;
        var items = jQuery(selector).add($focused);

        if (!$focused || $focused.length === 0) {
            $focused = jQuery(selector + ":last");
        } else {
            index = jQuery.inArray($focused.get(0), items);
            if (index > 0) {
                index = index - 1;
                $focused = items.eq(index);
            } else {
                $focused = jQuery(selector + ":last");
            }
        }
        return $focused;
    };

    var cancelPrevHightlights = function ($elem) {
        $elem.stop().css('background-color', '');
    }
})(
    function () {
        return FECRU.eventBus
    }
);
/*[{!fisheye_changeset_js_lcm852a!}]*/