/**
 * To enabling the changeset page shortcuts 'j' & 'k'.
 *
 * html structure
 *
 *  #panel-target
 *      .stream
 *          .diffPaneChangeset
 *              // a non-diff line
 *              tr
 *              // a diff line
 *              tr.is-diff [data-index]
 *
 */
(function (g, $) {

    var selCodePanel = '#panel-target ';
    var selStream = selCodePanel + '.stream ';
    var selDiffContent = selStream + '.diffPaneChangeset ';
    var $diffs;
    var currDiffIndex;
    var $panel;
    var scrollPendingCallback;

    // true if there is currently a scrolling animation happening
    var isScrolling = false;

    var ChangesetNav = function () {
    };

    ChangesetNav.prototype = {
        init: function () {
            $panel = $('#panel-target');
            this.loadDiffs();
        },
        /**
         *
         * @param dir 'next' | 'prev'
         */
        scrollTo: function (dir, isFromPendingScroll) {
            if (!$panel || !$panel.is(":visible")) {
                return;
            }

            // Only one pending scrolling command is stored to avoid jumping crazily between diffs
            // if a user presses the nav keys for many times or continuously holds a key
            var _nav = this;

            if (isScrolling && !isFromPendingScroll) {
                // if it is currently scrolling and is not from pending scroll
                // push it to the next pending scroll
                scrollPendingCallback = function () {
                    _nav.scrollTo(dir, true);
                };
                return;
            }
            isScrolling = true;

            var $target = this.getNextDiff(dir, isFromPendingScroll);
            if (!$target) {
                return;
            }

            $panel
                .scrollTo($target, {
                    axis: 'y',
                    offset: -100,
                    onAfter: function () {
                        isScrolling = false;
                        if (scrollPendingCallback) {
                            // execute and clear next scrolling command
                            scrollPendingCallback();
                            scrollPendingCallback = null;
                        }
                        highlightElement($target);
                    }
                });
        },
        scrollToEdgeOfAll: function (dir) {
            var _this = this;
            _this._onEdgeOfAll(dir, function (isSameFile) {
                if (dir === 'first') {
                    _this.afterSwitchingFile('next', isSameFile);
                } else {
                    _this.afterSwitchingFile('prev', isSameFile);
                }
            });
        },
        /**
         * This method is for binding an onEdgeOfFile event handler.
         * The event will be triggered when scrollToEgdeOfAll() is called
         * It will require the top level js program to switch to the first/last file in the current changeset,
         * and let ChangeNav know when the switch is done.
         *
         * @param callback : function ( dir, edgeFileSelectedCallback )
         */
        bindEdgeOfAll: function (callback) {
            this._onEdgeOfAll = callback;
        },
        /**
         *
         * @param dir : string - 'first' | 'last'
         * @param edgeFileSelectedCallback : function ( isSameFile )
         * @private
         */
        _onEdgeOfAll: function (dir, edgeFileSelectedCallback) {
        },
        /**
         *
         * This method is for binding an onEdgeFile event handler
         * When the edge of a page, either top or bottom, is reached by using navigation shortcuts,
         * this event will be triggered.
         *
         * @param event function( pos )
         * pos: 'start' | 'end'
         */
        bindEdgeOfFile: function (callback) {
            this._onEdgeOfFile = callback;
        },
        /**
         *
         * @param dir : string - 'start' | 'end'
         * @param newFileSelectedCallback : function ( isSameFile )
         * @private
         */
        _onEdgeOfFile: function (dir, newFileSelectedCallback) {
        },
        afterSwitchingFile: function (dir, isSameFile) { // 'next' | 'prev'
            if (!isSameFile) {
                this.init();
            } else {
                if ($diffs.length === 0) {
                    isScrolling = false;
                    return;
                }
            }

            if (dir === 'prev') {
                currDiffIndex = $diffs.length;
                $panel.scrollTo('max', {
                    axis: 'y'
                });
                this.scrollTo('prev', true);
            } else if (dir === 'next') {
                currDiffIndex = -1;
                this.scrollTo('next', true);
            }
        },
        getNextDiff: function (dir, isFromPendingScroll) {
            var _this = this;
            var curr = _this.getCurrentDiffIndex(dir, isFromPendingScroll);
            if (dir === 'next') {
                curr++;
            } else {
                curr--;
            }
            if (curr < 0) {
                _this._onEdgeOfFile('start', function (isSameFile) {
                    _this.afterSwitchingFile('prev', isSameFile);
                });
            } else if (curr >= $diffs.length) {
                _this._onEdgeOfFile('end', function (isSameFile) {
                    _this.afterSwitchingFile('next', isSameFile);
                });
            }

            currDiffIndex = curr;
            return $diffs[currDiffIndex];
        },
        getCurrentDiffIndex: function (dir, isFromPendingScroll) {

            if (currDiffIndex < 0) {
                var closestDiffIndex = 0;
            } else if (currDiffIndex >= $diffs.length) {
                closestDiffIndex = $diffs.length - 1;
            } else {
                closestDiffIndex = currDiffIndex;
            }

            var $currDiff = $diffs[closestDiffIndex];
            if (!$currDiff) {
                return -1;
            }

            var currTop = $currDiff.position().top;
            var panelHeight = $panel.height();

            if (isFromPendingScroll || (currTop >= 0 && currTop <= panelHeight)) {
                return currDiffIndex;
            } else {
                for (var i = 0; i < $diffs.length; i++) {
                    if ($diffs[i].position().top > 0) {
                        currDiffIndex = i;
                        break;
                    }
                }

                if (dir === 'next') {
                    currDiffIndex--;
                } else {
                    currDiffIndex++;
                }
            }
            return currDiffIndex;

        },
        loadDiffs: function () {
            $diffs = [];
            var $tmpDiffs = $(selDiffContent).find('.is-diff');

            var prevIndex = -2;
            $tmpDiffs.each(function () {
                var $t = $(this);

                var ind = $t.attr('data-index');
                if (ind !== prevIndex + 1) {
                    $diffs.push($t);
                }
                prevIndex = parseInt(ind);
            });

            currDiffIndex = -1;
            return $diffs;
        }
    };

    // this function is also in crucible-ui
    var highlightElement = function ($elem) {
        $elem.children('td:visible').effect('highlight', {color: '#fffee8'}, 1000, function () {
            $(this).css('background-color', '');
        });
    };

    g.ChangesetNav = ChangesetNav;

})(window, AJS.$);
/*[{!fisheye_changeset_nav_js_16ci529!}]*/