window.FE = window.FE || {};
FE.ARTICLE = (function (window, $) {

    var CON_defaultHeight = 24;

    function expandCommentText($container) {
        if (!$container.is(".article-board")) {
            $container = $container.find(".article-board");
        }
        $container
            .removeClass("article-terse")
            .addClass("article-verbose");
    }

    function collapseCommentText($container) {
        if (!$container.is(".article-board")) {
            $container = $container.find(".article-board");
        }
        $container
            .addClass("article-terse")
            .removeClass("article-verbose");
    }


    /**
     * Retreive the height of a child of the $articleMessage and store it in the $articleMessage data as a cache
     * @param $articleMessage container of the messages
     * @param messageComponent css class of the $articleMessage child, also used as the data key
     */
    function getHeightForArticleMessage($articleMessage, messageComponent) {
        var height = $articleMessage.data(messageComponent);
        if (height == null || height <= 0) {
            var $messageComponent = $articleMessage.children("." + messageComponent);
            if (!$messageComponent.size()) {
                height = CON_defaultHeight;
            } else {
                height = $messageComponent.outerHeight(false);
            }
            $articleMessage.data(messageComponent, height);
        }
        return height;
    }

    function toggleArticleDetails($article, opts) {
        var $twixie = $article.find(".article-toggle");
        var $articleMessage = $article.find(".article-message");
        var $articleSections = $article.children(".article-section");
        var collapsedClass = "article-collapsed";
        var collapsingClass = "article-collapsing";
        var expandedClass = "article-expanded";

        var setOpened = opts && opts.setOpened != null ? opts.setOpened : $article.hasClass(collapsedClass);
        var animate = opts ? opts.animate : true;
        var beforeExpand = opts && opts.beforeExpand;
        var callback = opts && opts.callback;

        var onDone;
        var animateFn;

        if (setOpened) {
            onDone = function () {
                $article.addClass(expandedClass).removeClass(collapsingClass).removeClass(collapsedClass);
                $twixie.text("less");

                expandCommentText($article);

                // We want to remove the styles added by the animation, and fallback to the natural styling
                $articleMessage.children().andSelf().add($articleSections).attr("style", '');

                // this is done because IE can't figure out the width and height of the image until its visible, so we need to trigger it again
                $article.find('.long-message .image-wrap img').trigger('load');

                callback && callback($article, setOpened);
            };

            animateFn = function () {
                $article.addClass(collapsingClass).removeClass(collapsedClass);
                var shortHeight = getHeightForArticleMessage($articleMessage, "short-message");

                $articleMessage
                    .css({
                        "height": shortHeight,
                        "max-height": "none",
                        "overflow": "hidden"
                    })
                    .children('.short-message')
                    .hide();

                $articleSections.slideDown();

                beforeExpand && beforeExpand($article);

                $articleMessage.children(".long-message").show();
                var longHeight = getHeightForArticleMessage($articleMessage, "long-message");

                $articleMessage.animate({
                    "height": longHeight
                }, onDone);
            };
        } else {
            onDone = function () {
                // We want to remove the styles added by the animation, and fallback to the natural styling
                $articleMessage.children().andSelf().add($articleSections).attr("style", '');

                var longHeight = getHeightForArticleMessage($articleMessage, "long-message");
                $article.addClass(collapsedClass).removeClass(expandedClass);

                $twixie.text("more");
                collapseCommentText($article);

                callback && callback($article, setOpened);
            };

            animateFn = function () {
                var shortHeight = getHeightForArticleMessage($articleMessage, "short-message");

                $articleSections.slideUp();
                $articleMessage.animate({
                    "height": shortHeight
                }, onDone);
            };
        }

        if (animate && animateFn) {
            animateFn();
        } else {
            onDone && onDone();
        }
    }

    function initExpandCollapse($root, callback) {
        $root.delegate(".article-summary", "click", function (event) {
            var $target = $(event.target);
            if ($target.is("a, input, button, select, .input") || $target.parent().is("a, input, button, select, .input")) {
                return;
            }
            var $article = $(this).closest(".article");
            if ($article.hasClass("no-expand")) {
                return;
            }
            var opts = {
                animate: true,
                callback: callback
            };

            toggleArticleDetails($article, opts);
        });
    }

    return {
        initialize: function ($root, options) {
            options = options || {};
            initExpandCollapse($root, options.expandCollapseCallback);
        },
        setExpanded: function ($article, shouldExpand) {
            toggleArticleDetails($article, {
                setOpened: shouldExpand,
                animate: true
            });
        },
        setAllExpanded: function ($articles, shouldExpand) {
            var opts = {
                setOpened: shouldExpand,
                animate: false
            };
            Array.each($articles, function (article) {
                toggleArticleDetails($(article), opts);
            });
        }
    };
})(this, AJS.$);
/*[{!fisheye_article_js_xfrc528!}]*/