window.FE = window.FE || {};
FE.ANN = FE.ANN || {};

// Publicly exported so that we can communicate between iframes
var nextSegment;
var prevSegment;

(function ($) {

    var goHere = function ($place) {
        var $currentWindow = $(window);
        var $parentWindow = $(parent);
        var parentWindowScrollTop = $parentWindow.scrollTop();

        location.hash = $place.attr("id");
        parent.location.hash = $place.attr("id");
        $parentWindow.scrollTop(parentWindowScrollTop);

        window.top.AJS.trigger('scroll-content', $currentWindow.scrollTop());
    };

    var $highlightedLine;
    var scrollToLine = function ($lineNum) {
        goHere($lineNum);
        if ($highlightedLine) {
            $highlightedLine.removeClass("line-selected");
        }
        $highlightedLine = $lineNum.closest("tr").addClass("line-selected");
    };

    var interceptLinks = function () {
        // Intercept clicks on links so that we don't open them in the iframe if not necessary
        $(document).delegate("a", 'click', function () {
            var $a = $(this);

            if ($a.hasClass("line-number") || $a.hasClass("disabled")) {
                return;
            }

            var href = $a.attr("href");
            var target = $a.attr("target");

            // Don't intercept links which are anchors or opened in another target
            if (!target && href && href.charAt(0) !== '#') {
                // Open links not in this iframe, but the top level window
                parent.document.location = this.href;
            }
        });
    };

    var setupViewAnnotation = function () {
        $(document).delegate("#file-annotation tr .line-number", 'click', function () {
            scrollToLine($(this));
        });
    };

    var setupViewDiff = function () {
        $(document).delegate("#file-annotation a.diff-segment-link", 'click', function () {
            var dest = parseInt($(this).attr("href").replace("#seg", ""), 10);
            scrollToDiffSegment(dest);
        });

        var currentSegment;

        var scrollToDiffSegment = function (segmentNumber) {
            var $segment = $("#seg" + segmentNumber);
            if ($segment.length > 0) {
                goHere($segment);
                currentSegment = segmentNumber;
            }
        };

        // Scroll to the requested diff segment
        var hash = window.location.hash;
        if (/^#seg\d+/.test(hash)) {
            var segment = parseInt(hash.replace(/^#seg(\d+).*$/, '$1'), 10);
            scrollToDiffSegment(segment);
        }

        nextSegment = function () {
            scrollToDiffSegment(currentSegment ? currentSegment + 1 : 1);
        };

        prevSegment = function () {
            if (!currentSegment || currentSegment === 1) {
                return;
            }
            scrollToDiffSegment(currentSegment - 1);
        };

        // trigger event to the parent window to reset the iframe height
        window.parent !== window && window.parent.AJS &&
        window.parent.AJS.trigger('file-view-resize-from-iframe');
    };

    FE.ANN.onReady = function (pageType) {
        var isAnnotation = pageType === 'annotation';
        var isDiff = pageType === 'diff';

        $(function () {
            interceptLinks();
            if (isAnnotation) {
                setupViewAnnotation();
            } else if (isDiff) {
                setupViewDiff();
            } else {
                AJS.log("ERROR: I don't know how to setup page view for type " + pageType);
                return;
            }

            var eventBus = parent.FECRU ? parent.FECRU.eventBus : null;
            if (eventBus) {
                eventBus.trigger('file-view-iframe:loaded', {
                    $source: $('.blame-info:visible')
                });
            }
        });
    };
})(AJS.$);
/*[{!fisheye_annotation_js_ydw3527!}]*/