(function ($) {

    window.FECRU = window.FECRU || {};
    FECRU.ACTIVITY = {};

    var article = FE.ARTICLE;

    var triggerPathAbbreviation = function () {
    };

    FE.setupActivityStream = function () {
        var $streamItems = $("#stream");

        $("#expand-all-activity:not(.disabled)").click(function () {
            var $this = $(this);
            var shouldExpand = !$this.hasClass("active");
            var $articles = $streamItems.find(".article");

            article.setAllExpanded($articles, shouldExpand);

            if (shouldExpand) {
                Array.each($articles, function (article) {
                    triggerPathAbbreviation($(article), null, false, true);
                });

                $this.addClass("active");
            } else {
                $this.removeClass("active");
            }

            FECRU.PREFS.setPreference("aec", shouldExpand ? "Y" : "N");
        });

        $streamItems.delegate("a.article-create-review-link", "click", function (event) {
            var $target = $(event.target);
            var repname = $target.data("repname");
            var csid = $target.data("csid");

            CRU.UTIL.addToReview({csid: csid, repo: repname});

            //Stops event bubbling and default processing - stops double review creation
            //from both the JS and the href on the a element
            event.preventDefault();
        });

        article.initialize($streamItems, {
            beforeExpand: function ($article) {
                triggerPathAbbreviation($article, null, false, true);
            }
        });

        FECRU.UI.resizeAndCollateImagesToThumbs();

        FE.setupPathAbbreviation($streamItems);
    };

    /**
     * sets up the path abbreviations for the activity stream
     * @param $stream the element that contains the activitystream item. It should contain one or more .file-path elements.
     * @param boundingWidthGetter an optional function, that takes one argument - the path element.
     *          If supplied, it will be used to calculate the width to bound the path.
     */
    FE.setupPathAbbreviation = function ($stream, boundingWidthGetter) {
        var triggerPathAbbreviationPerArticle;
        var isIE = $.browser.msie;
        if (isIE) {
            triggerPathAbbreviationPerArticle = function ($articles) {
                var $paths = $articles.find('.file-path');
                var $path;

                //switch to statically truncated version from components
                for (var i = 0; i < $paths.length; i++) {
                    $path = $paths.eq(i);
                    $path.empty().append($path.siblings('.path-truncated').html());
                }
            };
            triggerPathAbbreviationPerArticle($stream);

        } else {
            triggerPathAbbreviationPerArticle = function ($articles, hint) {
                triggerPathAbbreviation($articles, hint, false, true);
            };
            triggerPathAbbreviation = function ($this, hint, useAlternateWidthCache, resetBoundsWidth) {
                var $paths = $this.find('.file-path');

                $paths.abbreviatePath({
                    boundingWidthGetter: boundingWidthGetter || function ($this) {
                        return $this.closest('li').width()
                    },
                    growingElementGetter: function ($this) {
                        return $this.closest('.abbreviate-path-grower');
                    },
                    directionHint: hint,
                    resetBoundsWidth: resetBoundsWidth,
                    widthCacheKey: useAlternateWidthCache ? 1 : 0
                });
            };

            //initial truncation
            triggerPathAbbreviationPerArticle(AJS.$('.article-expanded'), null);

            //on resize
            var $window = $(window);
            var windowWidth = $window.width();

            FECRU.UI.setCompletedResizeTimeout($window, function () {
                var newWindowWidth = $window.width();
                var shouldRun = windowWidth !== newWindowWidth;
                var hint = windowWidth < newWindowWidth ? 'larger' : 'smaller';

                windowWidth = newWindowWidth;

                if (shouldRun) {
                    triggerPathAbbreviationPerArticle(AJS.$('.article-expanded'), hint);
                }
            }, isIE ? 200 : 50);

            //on collapse/uncollapse sidebar
            AJS.bind('sidebar-expanded', function () {
                triggerPathAbbreviationPerArticle(AJS.$('.article-expanded'), 'smaller');
            }).bind('sidebar-collapsed', function () {
                triggerPathAbbreviationPerArticle(AJS.$('.article-expanded'), 'larger');
            });

            //on mouseenter/mouseleave
            // if we're moving from one path to another, the timing of css updates and js events are off and can cause
            // the paths to be too long (because the width we measure hasn't updated to include the ul.file-views) or
            // too short (because it's still including ul.file-views even though we left).
            // Calling the mouseleave resize on the next paths mouseenter solves this problem.
            var callOnMouseEnter = [];

            $stream.delegate('.stream-files > li', 'mouseenter', function () {
                var $this = $(this);
                var $fileViews = isIE ? $this.find('.file-views') : null;

                if (isIE) { // force display to fix ie bug
                    $fileViews.css('display', 'inline');
                }
                triggerPathAbbreviation($this, 'smaller', true, null);
                if (isIE) {
                    $fileViews.css('display', '');
                }
                while (callOnMouseEnter.length) {
                    triggerPathAbbreviation(callOnMouseEnter.shift(), 'larger', false);
                }
            }).delegate('.stream-files > li', 'mouseleave', function (eventObj) {
                var $this = $(this);
                var $to = $(eventObj.relatedTarget).closest('li');

                if ($to.length) { // lengthen the element you're leaving AFTER shortening
                    // the one you enter to avoid stretching the bounds.
                    callOnMouseEnter.push($this);
                }
                else {
                    triggerPathAbbreviation($this, 'larger', false);
                }
            });
        }
        FECRU.ACTIVITY.triggerPathAbbreviationPerArticle = triggerPathAbbreviationPerArticle;
    };


    FECRU.ACTIVITY.isScrolledToBottom = function isScrolledToBottom() {
        var paneHeight = window.document.documentElement.clientHeight;
        var contentHeight = window.document.documentElement.scrollHeight;
        var scrollTop = AJS.$(window).scrollTop();
        var scrollBottom = scrollTop + paneHeight;

        return (scrollBottom > contentHeight - 100);
    };

    /** Installs a scroll handler and invokes the callback given when the pane is scrolled to the bottom */
    FECRU.ACTIVITY.onScrollToBottom = function (callback) {
        AJS.$(window).scroll(function () {
            if (FECRU.ACTIVITY.isScrolledToBottom()) {
                callback();
            }
        });
    };

    AJS.$(document).ready(function () {
        FECRU.UI.resizeAndCollateImagesToThumbs();
    });
})(AJS.$);
/*[{!fisheye_activity_js_r9wp526!}]*/