FE.VIS.Fragment = (function ($) {

    /**
     * Returns an array composed of the given arr, and the given elem, but only if elem
     * is non-null.
     * @param arr an array
     * @param elem an element to append to the given array
     */
    function appendToArray(arr, elem) {
        if (arr && elem) {
            arr.push(elem);
        }
        return arr;
    }

    /*Public*/

    var Fragment = function (map, isAllBranchMode) {
        this.fragment = map;
        this.isAllBranchMode = isAllBranchMode;
    };

    Fragment.create = function (branches, isAllBranchMode, selectedChangesetId, highlighter, scrollToChangesetId) {
        var map = {};

        branches && (map.branch = $.isArray(branches) ? branches : [branches]);
        selectedChangesetId && (map.csid = selectedChangesetId);
        highlighter && (map.hl = highlighter);
        scrollToChangesetId && (map.scrollToCsid = scrollToChangesetId);

        return new Fragment(map, isAllBranchMode);
    };


    /**
     * expect the hash format to be #key=val&key2=val2
     * The key could have multiple values. In that case, the value will be added to an array in the order they appear.
     * @param fragmentString the hash fragment, or if undefined, defaults to the current urls' hash fragment
     * @param defaults the default values for keys, if they are not defined in the hash.
     * @param isAllBranchMode optional argument indicating whether the current mode is all branch mode. Assume to be false if not passed in.
     */
    Fragment.fromString = function (fragmentString, defaults, isAllBranchMode) {
        var fragmentStringMap = $.deparam.fragment(fragmentString || $.param.fragment(), false);
        var fullMap = defaults ?
            $.extend({}, defaults, fragmentStringMap) :
            fragmentStringMap;

        return new Fragment(fullMap, isAllBranchMode);
    };

    /**
     * @Returns the branches in the hash. If there are no branches in the hash, this will return the defaults (passed in via the ctor), or undefined if
     * the defaults didn't have any branches.
     */
    Fragment.prototype.getBranches = function () {
        var branches = this.get("branch");
        var csbr = (!this.isAllBranchMode) ? this.getChangesetBranch() : undefined;

        //the library doesn't force the branch param to be an array, so we do it here before munging
        return appendToArray(($.isArray(branches) ? branches : [branches]), csbr);
    };

    Fragment.prototype.getChangesetId = function () {
        return this.get("csid");
    };

    Fragment.prototype.getScrollToChangesetId = function () {
        return this.get("scrollToCsid");
    };

    Fragment.prototype.getChangesetBranch = function () {
        return this.get("csbr");
    };

    Fragment.prototype.getHighlighterName = function () {
        return this.get("hl");
    };

    /**
     * @Returns the parameter value given the key to the param key/val pair. The value could be an array if there are multiple
     * values for the same key. They are in the order that they appear in from the hash
     */
    Fragment.prototype.get = function (key) {
        return this.fragment[key];
    };

    Fragment.prototype.asMap = function () {
        return this.fragment;
    };

    Fragment.prototype.asString = function () {
        return $.param(this.fragment);
    };

    return Fragment;
})(AJS.$);
/*[{!fragment_js_v4zw52l!}]*/