;
(function ($) {

    var Map = FECRU.DATA_STRUCTURES.Map;

    /*private*/

    var changesetAttrs = $.extend(true, {
        Reviewed: {
            color: '#669900',
            hasBorder: false,
            borderColor: null,
            borderWidth: 0,
            textColor: null,
            backgroundColor: null
        },
        InProgress: {
            color: '#FF9900',
            hasBorder: false,
            borderColor: null,
            borderWidth: 0,
            textColor: null,
            backgroundColor: null
        },
        Unreviewed: {
            color: '#AA0000',
            hasBorder: false,
            borderColor: null,
            borderWidth: 0,
            textColor: null,
            backgroundColor: null
        }
    }, {});

    var attrsForState = {
        "Draft": changesetAttrs.InProgress,
        "Approval": changesetAttrs.InProgress,
        "Review": changesetAttrs.InProgress,
        "Summarize": changesetAttrs.InProgress,
        "Closed": changesetAttrs.Reviewed,
        "Dead": changesetAttrs.Unreviewed,
        "Rejected": changesetAttrs.Unreviewed
    };

    var reviewsForChangesets = new Map();
    var changesetIdsToLoad = [];
    var relatedChangesets = null;
    var focusedCsid = null;
    var jqXHR = null;
    var highlightHelper = null;
    var dataUrl;

    var init = function () {
        reviewsForChangesets = new Map();
        changesetIdsToLoad = [];
        relatedChangesets = null;
    };

    var dispose = function () {
        jqXHR && jqXHR.abort();
        init();
    };

    var loadReviewData = function () {
        highlightHelper.setLoading(true);
        jqXHR = $.ajax({
            url: dataUrl,
            type: "POST",
            dataType: 'json',
            data: {cs: changesetIdsToLoad},
            success: function (data) {
                jqXHR = null;
                changesetIdsToLoad = [];
                var changesets = data.changesets;
                if (changesets) {
                    Array.each(changesets, function (cs) {
                        if (cs.reviews && cs.reviews.length) {
                            reviewsForChangesets.set(cs.changesetId, cs.reviews);
                        }
                    });
                }
                if (focusedCsid) {
                    relatedChangesets = findChangesetsForReviews(reviewsForChangesets.get(focusedCsid));
                }
                highlightHelper.setLoading(false);
            },
            error: function (req, textStatus, errorThrown) {
                jqXHR = null;
                var resp = eval('(' + req.responseText + ')');
                if (resp.stacktrace) {
                    FECRU.AJAX.appendErrorResponse(resp.stacktrace, false);
                    FECRU.AJAX.showNotificationBox(resp.code + ": " + resp.message);
                }
                highlightHelper.setLoading(false);
            }
        });
    };

    var loadChangesets = function (changesets) {
        Array.each(changesets, function (cs) {
            var id = cs.csid;
            if (!reviewsForChangesets.has(id)) {
                changesetIdsToLoad.push(id);
            }
        });
        loadReviewData();
    };

    var unloadChangesets = function (changesets) {
        Array.each(changesets, function (cs) {
            reviewsForChangesets.remove(cs.csid);
            // todo clear out queue
        });
    };

    function findChangesetsForReviews(reviews) {
        var changesets = [];
        var changesetReviews;

        if (!reviews || !reviews.length) {
            return changesets;
        }

        var reviewKeys = Array.map(reviews, function (review) {
            return review.permaId.id;
        });
        Array.each(reviewsForChangesets.getKeys(), function (csid) {
            changesetReviews = reviewsForChangesets.get(csid);
            // nb this algorithm is slow, O(n*m), but should be closer to linear as there shouldn't be too many reviews
            Array.each(changesetReviews, function (review) {
                var permaId = review.permaId.id;
                if (jQuery.inArray(permaId, reviewKeys) >= 0) {
                    changesets.push(csid);
                    return false;
                }
            });
        });
        return changesets;
    }

    FE.VIS.getReviewHighlighter = function (url) {
        dataUrl = url;

        var reviewedChangesetHighlighter = {
            name: "Reviewed changesets",
            setHelper: function (helper) {
                highlightHelper = helper;
            },
            onDataLoaded: function (changesets) {
                loadChangesets(changesets);
            },
            onDataUnloaded: function (changesets) {
                unloadChangesets(changesets);
            },
            onActivation: function (changesets) {
                init();
                loadChangesets(changesets);
            },
            onDeactivation: function () {
                dispose();
            },
            highlightChangeset: function (cs, defaults) {
                var csid = cs.csid;
                var reviews = reviewsForChangesets.get(csid);
                if (focusedCsid === csid) {
                    cs.attr(defaults.Selected);
                } else if (focusedCsid !== null && relatedChangesets && $.inArray(csid, relatedChangesets) >= 0) {
                    cs.attr(defaults.Emphasized);
                } else if (reviews && reviews.length) {

                    var attr = changesetAttrs.Unreviewed;
                    Array.each(reviews, function (review) {
                        var revAttr = attrsForState[review.state];
                        if (revAttr === changesetAttrs.Reviewed) {
                            attr = revAttr;
                            return false;
                        }
                        if (revAttr !== changesetAttrs.Unreviewed) {
                            attr = revAttr;
                        }
                    });
                    cs.attr(attr);
                } else {
                    cs.attr(changesetAttrs.Unreviewed);
                }

                if (reviews && reviews.length) {
                    cs.attr("metadataCssClass", "has-review");
                }
            },
            onFocusChanged: function (highlightable) {
                if (highlightable && highlightable.isChangeset()) {
                    focusedCsid = highlightable.csid;
                    relatedChangesets = findChangesetsForReviews(reviewsForChangesets.get(focusedCsid));
                } else {
                    focusedCsid = null;
                    relatedChangesets = null;
                }
            },
            getChangesetAnnotation: function (cs, createAnnotationList) {
                var reviews = reviewsForChangesets.get(cs.csid);
                return createAnnotationList(reviews, {
                    sort: true,
                    getTruncationMessage: function (hiddenCount) {
                        return hiddenCount + " other reviews";
                    },
                    getItemHtml: function (review) {
                        var reviewKey = review.permaId.id;
                        var state = review.state;
                        var href = CRU.UTIL.urlBase(reviewKey);
                        var $stateElem = $("<span></span>");

                        $stateElem.text(" \u2013 " + state);

                        return $("<span>")
                            .append(
                            $("<a></a>")
                                .attr("href", href)
                                .text(reviewKey)
                        )
                            .append($stateElem);
                    }
                });
            },
            getLozenges: function (cs, createLozenge) {
                var reviews = reviewsForChangesets.get(cs.csid);
                if (!reviews || reviews.length === 0) {
                    return null;
                }
                var reviewKeys = Array.map(reviews, function (review) {
                    return review.permaId.id;
                });
                return createLozenge(reviewKeys, {
                    collapsedLozengeText: function (itemCount) {
                        return itemCount + " reviews";
                    },
                    getItemText: function (reviewKey) {
                        var href = CRU.UTIL.urlBase(reviewKey);
                        return $("<a></a>")
                            .attr("href", href)
                            .text(reviewKey)
                    },
                    sort: true,
                    lozengeClass: "review-lozenge"
                });
            }
        };

        return reviewedChangesetHighlighter;
    };
})(AJS.$);
/*[{!review_highlighter_js_5fcb530!}]*/